use strict;
use lib './lib';

my $shorttest_file = 't/files/test.txt';

use Test::More tests => 4;
BEGIN { use_ok('Lingua::Tokenize') };

use Lingua::Tokenize;

my $t = new Lingua::Tokenize( { debug => 0 } );

open FH, $shorttest_file or die "$!\n";
local $/;
my $corpus = <FH>;

my @tokens = $t->tokenize( {
        normalize => 1,
        tokendef => 'words',
        input => \$corpus
} );

# the correct tokenization and normalization of 't/files/test.txt'
my @toknorm = qw/dies ist ein einfacher Testsatz . er macht darber hinaus
    nicht viel Sinn , auch dann nicht , wenn er hiermit eine zweite Zeile
    zu eigen hat ! Ende . auch dies brauchen wir noch wegen dem anderen
    " dies " ./;

is_deeply( \@tokens, \@toknorm,  "Tokenization and normalisation" );

my @sentences = $t->extract_sentences( \@tokens );

is ( scalar( @sentences ), 4, "Extracted sentences" );

my @direct_sentences = $t->tokenize( {
        normalize => 1,
        tokendef => 'sentences',
        input => \$corpus
} );

is_deeply( \@sentences, \@direct_sentences,
        "typedef 'sentences' vs. extract_sentences()" );

# vim: ft=perl
