#!/usr/bin/perl

# $Header: /var/cvsroot/Lingua-Tokenize/tokenize.pl,v 1.3 2005/06/26 06:33:06 alex Exp $

BEGIN {
    unless ( $ARGV[0] ) {
        print "usage: $0 [file]\n";
        exit 1;
    }
}

use strict;
use Data::Dumper;
use Lingua::Tokenize;

my $file = shift( @ARGV );
my $t = new Lingua::Tokenize( {debug => 1} );

open FH, $file or die "$!\n";
local $/;
my $input = <FH>;
close FH;

my @tokens = $t->tokenize( {
        normalize=>1,
        tokendef=> 'words',
        input => \$input
} );

print Dumper @tokens;
