#!/usr/bin/perl

# $Header: /var/cvsroot/Lingua-Tokenize/extract_sentences.pl,v 1.2 2005/06/26 06:33:06 alex Exp $

BEGIN {
    unless ( $ARGV[0] ) {
        print "usage: $0 [file]\n";
        exit 1;
    }
}

use strict;
use Lingua::Tokenize;

my $file = shift( @ARGV );
my $t = new Lingua::Tokenize( {debug => 1} );

open FH, $file or die "$!\n";
local $/;
my $input = <FH>;
close FH;

my @sentences = $t->tokenize( {
        normalize=>1,
        tokendef => 'sentences',
        input => \$input
} );

print "Sentence: '$_'\n" foreach( @sentences );
