#!/usr/bin/perl

# $Header: /var/cvsroot/XFST-Lookup/lookup.pl,v 1.1 2005/07/17 08:24:46 alex Exp $

BEGIN {
    if ( @ARGV != 2 ) {
        print "usage: $0 [fst] [file]\n";
        exit 1;
    }
}

use strict;
use Data::Dumper;
use Lingua::Tokenize;
use XFST::Lookup;

my $l = new XFST::Lookup({debug=>0});
my $t = new Lingua::Tokenize( {debug=>0} );

undef $/;
open FH, "$ARGV[1]" or die "$!\n";
my $whole = <FH> ;
$/="\n";

my @wordforms = $t->tokenize( {input => \$whole,tokendef=>'words'} );
my @types = $t->unify( \@wordforms );

my %looked_up = $l->lookup({
        fst=>"$ARGV[0]",
        words=>\@types});

print Dumper %looked_up;
