# $Header: /var/cvsroot/XFST-Lookup/t/XFST-Lookup.t,v 1.9 2005/07/02 10:29:01 alex Exp $

use strict;
use lib "lib/";

use Test::More tests => 3;
BEGIN { use_ok('XFST::Lookup') };

my $add_path="";

SKIP: {
	skip "This is not MS Win32!", 1 unless ( $^O eq "MSWin32" );
	
	is( check_win32_lookup() , 1, "XEROX's lookup in path?" ) or
    	diag "\n\n\nIf XEROX's lookup is not in PATH, you can set the path\n" .
		"using the environment-variable XFST_PATH!\n\nExample:\n".
		"> set XFST_PATH=D:\\alex\\xerox-windows\n" .
		"> nmake test\n\n\n\n";
	
	$add_path=$ENV{XFST_PATH} if( $ENV{XFST_PATH} );
}
	
my @wordforms = qw/audire audio audis audit/;

my $lookup = new XFST::Lookup({ 
	debug=>0,
	path=>$add_path
});

$lookup->set_flags("L:L", "T-T");

my %looked_up = $lookup->lookup({
        fst=>'t/files/latin-verbs.fst',
        words=>\@wordforms});

my %latin_verb = (
    audit => [qw/audi+3P+Sg/],
    audio => [qw/audi+1P+Sg/],
    audire => [qw/audi+Inf/],
    audis => [qw/audi+2P+Sg/]
);

is_deeply( \%latin_verb, \%looked_up, 'latin verb-lookup' );

sub check_win32_lookup {
	if ( system("lookup.exe -v") == 0 ) { return 1 }
	elsif( system("$ENV{XFST_PATH}\\lookup.exe -v") == 0 ) { return 1 }

	return 0;
}

# vim: ft=perl
