# $Header: /var/cvsroot/XFST-Lookup/t/XFST-Lookup.t,v 1.6 2005/06/09 16:12:24 alex Exp $

use strict;
use lib "lib/";

use Test::More tests => 2;
BEGIN { use_ok('XFST::Lookup') };

my @wordforms = qw/audire audio audis audit/;

my $lookup = new XFST::Lookup({debug=>0});

$lookup->set_flags("L:L", "T-T");

my %looked_up = $lookup->lookup({
        fst=>'t/files/latin-verbs.fst',
        words=>\@wordforms});

my %latin_verb = (
    audit => [qw/audi+3P+Sg/],
    audio => [qw/audi+1P+Sg/],
    audire => [qw/audi+Inf/],
    audis => [qw/audi+2P+Sg/]
);

is_deeply( \%latin_verb, \%looked_up, 'latin verb-lookup' );

# vim: ft=perl
