#!/bin/sh
sysVer_item0=1
sysVer_item1=5
sysVer_item2=3
sysVer_item3=16

appVer_item0=2
appVer_item1=
appVer_item2=2
appVer_item3=24
#### Important Tips: Please Do Not Modify Above include add line delete line ####

tar Jxf /mnt/mtd/app/zmodules.tar.xz -C /tmp/
cd /tmp/modules

# sys firmware 1.12 have auto mount, but have a bug, only root can operate sd dir, do delete first
# if sys firmware not 1.12, 3 line can delete
`rm  /sbin/mount-sd.sh`
`rm /sbin/umount-sd.sh`
`umount /mnt/sd`

if [ -d "/mnt/param/" ];then
	echo "#### found param partition ####"
	if [ -d "/mnt/param/config/" ];then
		echo "#### found param partition and config dir ####"
	else
		echo "!!!! found param partition but no config dir, now cp app config and Rom.dat to param config !!!!"
		`cp /mnt/mtd/app/config/ /mnt/param/ -r`
		if [ -f "/mnt/param/config/Rom.dat" ];then
			echo "#### found /mnt/param/config/Rom.dat ####"
		else
			echo "!!!! not found /mnt/param/config/Rom.dat, now cp Rom.dat to config dir. !!!!"
			`cp /mnt/mtd/app/etc/Rom.dat /mnt/param/config/`
		fi
	fi
else
    echo "#### no found param partition, sys is old ####"
fi

if [ -f "/mnt/param/config/ProductConfig.xml" ];then
	echo "#### have config partition, rm app config and ln param to app ####"
	if [ -e "/mnt/mtd/app/config" ];then
		echo "!!!! have /mnt/mtd/app/config, rm it !!!!"
		`rm -rf /mnt/mtd/app/config`
	fi

	`ln -sf /mnt/param/config /mnt/mtd/app/config`
else
	echo "#### have no param partition, or param partition have no data ####"
fi

#write SYS_VER and APP_VER function APP_VER defined here
update_ver()
{
if [ -f "/mnt/mtd/app/config/DevVerConfig.xml" ];then
	dev_ver_config_path="/mnt/mtd/app/config/DevVerConfig.xml"
else
	echo " #### can not find DevVerConfig.xml file, now cp it from /mnt/app/app/config/DevVerConfig.xml #### "
	#dir /mnt/app/app/config is only read,so DevVerConfig.xml will not been modify.
	`cp /mnt/app/app/config/DevVerConfig.xml  /mnt/mtd/app/config/DevVerConfig.xml`
	dev_ver_config_path="/mnt/mtd/app/config/DevVerConfig.xml"
fi

if [ x$dev_ver_config_path == x ]; then
	echo " #### <-------------- can not find DevVer config file --------------> #### "
else
	eval $(sed -n '7p'  $dev_ver_config_path | grep 'item' | awk -F ">" '{print $2}' | awk -F "<" '{printf("sysVer0=%d",$1);}') 
	eval $(sed -n '8p'  $dev_ver_config_path | grep 'item' | awk -F ">" '{print $2}' | awk -F "<" '{printf("sysVer1=%d",$1);}') 
	eval $(sed -n '9p'  $dev_ver_config_path | grep 'item' | awk -F ">" '{print $2}' | awk -F "<" '{printf("sysVer2=%d",$1);}') 
	eval $(sed -n '10p' $dev_ver_config_path | grep 'item' | awk -F ">" '{print $2}' | awk -F "<" '{printf("sysVer3=%d",$1);}') 

	eval $(sed -n '14p' $dev_ver_config_path | grep 'item' | awk -F ">" '{print $2}' | awk -F "<" '{printf("appVer0=%d",$1);}') 	
	eval $(sed -n '16p' $dev_ver_config_path | grep 'item' | awk -F ">" '{print $2}' | awk -F "<" '{printf("appVer2=%d",$1);}') 
	eval $(sed -n '17p' $dev_ver_config_path | grep 'item' | awk -F ">" '{print $2}' | awk -F "<" '{printf("appVer3=%d",$1);}') 
	
	echo " #### SYS_VER_0:  $sysVer0 == $sysVer_item0 ? #### "
	if [ $sysVer_item0 -eq $sysVer0 ];then 
		echo " #### not need to rewrite sysVer_item0,old: $sysVer_item0 #### "
		else
		echo " #### now need to rewrite sysVer_item0,new: $sysVer_item0 #### "				
		`sed -i '7d' $dev_ver_config_path`
		`sed -i '7i \\		<item>'$sysVer_item0'</item>' $dev_ver_config_path`
	fi

	echo " #### SYS_VER_1: $sysVer1 == $sysVer_item1 ? #### "
	if [ $sysVer_item1 -eq $sysVer1 ];then 
		echo " #### not need to rewrite sysVer_item1,old: $sysVer_item1 #### "
		else
		echo " #### now need to rewrite sysVer_item1,new: $sysVer_item1 #### "				
		`sed -i '8d' $dev_ver_config_path `
		`sed -i '8i \\		<item>'"$sysVer_item1"'</item>' $dev_ver_config_path` 
	fi
	
	echo " #### SYS_VER_2:  $sysVer2 == $sysVer_item2 ? #### "
	if [ $sysVer_item2 -eq $sysVer2 ];then 
		echo " #### not need to rewrite sysVer_item2,old: $sysVer_item2 #### "
		else
		echo " #### now need to rewrite sysVer_item2,new: $sysVer_item2 #### "				
		`sed -i '9d' $dev_ver_config_path`
		`sed -i '9i \\		<item>'$sysVer_item2'</item>' $dev_ver_config_path`
	fi

	echo " #### SYS_VER_3: $sysVer3 == $sysVer_item3 ? #### "
	if [ $sysVer_item3 -eq $sysVer3 ];then 
		echo " #### not need to rewrite sysVer_item3,old: $sysVer_item3 #### "
		else
		echo " #### now need to rewrite sysVer_item3,new: $sysVer_item3 #### "				
		`sed -i '10d' $dev_ver_config_path `
		`sed -i '10i \\		<item>'"$sysVer_item3"'</item>' $dev_ver_config_path` 
	fi

	echo " #### APP_VER_0:  $appVer0 == $appVer_item0 ? #### "
	if [ $appVer_item0 -eq $appVer0 ];then 
		echo " #### not need to rewrite appVer_item0,old: $appVer_item0 #### "
		else
		echo " #### now need to rewrite appVer_item0,new: $appVer_item0 #### "				
		`sed -i '14d' $dev_ver_config_path`
		`sed -i '14i \\		<item>'$appVer_item0'</item>' $dev_ver_config_path`
	fi
	
	echo " #### APP_VER_2:  $appVer2 == $appVer_item2 ? #### "
	if [ $appVer_item2 -eq $appVer2 ];then 
		echo " #### not need to rewrite appVer_item2,old: $appVer_item2 #### "
		else
		echo " #### now need to rewrite appVer_item2,new: $appVer_item2 #### "				
		`sed -i '16d' $dev_ver_config_path`
		`sed -i '16i \\		<item>'$appVer_item2'</item>' $dev_ver_config_path`
	fi

	echo " #### APP_VER_3: $appVer3 == $appVer_item3 ? #### "
	if [ $appVer_item3 -eq $appVer3 ];then 
		echo " #### not need to rewrite appVer_item3,old: $appVer_item3 #### "
		else
		echo " #### now need to rewrite appVer_item3,new: $appVer_item3 #### "				
		`sed -i '17d' $dev_ver_config_path `
		`sed -i '17i \\		<item>'"$appVer_item3"'</item>' $dev_ver_config_path` 
	fi	
fi
}

product_config_path="/mnt/mtd/app/config/ProductConfig.xml"
eval $(cat $product_config_path | grep '<model>' | awk -F ">" '{print $2}' | awk -F "<" '{printf("MODELNUM=\"%d\"",$1);}') 
eval $(cat $product_config_path | grep 'modelName' | awk -F ">" '{print $2}' | awk -F "<" '{printf("MODELNAME=\"%s\"",$1);}') 
eval $(cat $product_config_path | grep 'sensorType' | awk -F ">" '{print $2}' | awk -F "<" '{printf("SENSOR=%d",$1);}') 
eval $(cat $product_config_path | grep 'wifiType' | awk -F ">" '{print $2}' | awk -F "<" '{printf("WIFI=%d",$1);}') 
eval $(cat $product_config_path | grep 'language' | awk -F ">" '{print $2}' | awk -F "<" '{printf("LANGUAGE=%d",$1);}') 
eval $(cat $product_config_path | grep 'modelVersion' | awk -F ">" '{print $2}' | awk -F "<" '{printf("MODELVERSION=%d",$1);}') 
eval $(cat $product_config_path | grep 'reserveFlag1' | awk -F ">" '{print $2}' | awk -F "<" '{printf("RESERVEFLAG1=%d",$1);}') 

echo "==== Your model name is $MODELNAME SENSOR=$SENSOR WIFI=$WIFI LANGUAGE=$LANGUAGE MODELVERSION=$MODELVERSION MODELNUM=$MODELNUM ===="
./load3518 -i $SENSOR $WIFI "$MODELNAME" $MODELVERSION $MODELNUM
ptzstate_xmlcfg=1
prehorpos_xmlcfg=0
preverpos_xmlcfg=0
ptz_config_path="/mnt/mtd/app/config/PTZConfig.xml"
if [ ! -f $ptz_config_path ];then
	echo "can not find ptz config file!!!"
else
	eval $(cat $ptz_config_path | grep 'SelfTestMode' | awk -F ">" '{print $2}' | awk -F "<" '{printf("ptzstate_xmlcfg=%d",$1);}') 
	eval $(cat $ptz_config_path | grep 'PreHorPos_Appointed' | awk -F ">" '{print $2}' | awk -F "<" '{printf("prehorpos_xmlcfg=%d",$1);}') 
	eval $(cat $ptz_config_path | grep 'PreVerPos_Appointed' | awk -F ">" '{print $2}' | awk -F "<" '{printf("preverpos_xmlcfg=%d",$1);}') 
fi

case $MODELVERSION in
	11|12|13|14)
		case $MODELNUM in
			7|19|33|41|42|43|46|47) #28W\963W\28P\FC8513WZ\FC8513PZ\FC8513EZ\28WV0\963WV0
				/sbin/insmod /tmp/modules/extdrv/fos_ptz_9828.ko ptz_state=$ptzstate_xmlcfg horizen_desire_pos=$prehorpos_xmlcfg vertical_desire_pos=$preverpos_xmlcfg zoom_max_step=930 zoom_desire_pos=100
				if [ $? -ne 0 ];then
					/sbin/insmod /tmp/modules/extdrv/fos_ptz_9828.ko ptz_state=1 horizen_desire_pos=0 vertical_desire_pos=0 zoom_max_step=930 zoom_desire_pos=100
				fi
				;;
			*)
				/sbin/insmod /tmp/modules/extdrv/fos_ptz.ko ptz_state=$ptzstate_xmlcfg horizen_desire_pos=$prehorpos_xmlcfg vertical_desire_pos=$preverpos_xmlcfg
				if [ $? -ne 0 ];then
					/sbin/insmod /tmp/modules/extdrv/fos_ptz.ko ptz_state=1 horizen_desire_pos=0 vertical_desire_pos=0
				fi
				;;
		esac
		;;
	21|22|23|24)
		case $MODELNUM in
			1001|1002|1003|1004|1005|1006|1007|1008|1009|1010|1011|1012|1013|1014|1015|1029|1030|1031|1032|1025|1026)
				#"HD950"|"HD950W"|"HD950E"|"FI9803"|"FI9803W"|"FI9803E"|"EH9501"|"EH9502"|"EH9503"|"HD933"|"HD933E"|"FI9853"|"FI9853E"|"EH9331"|"EH9333"|"FI9851"|"HD931"|"FI9851W"|"HD931W"|"FC5412P"|"FC5413P"
				;;
			1023) #"FC2403P"
				/sbin/insmod /tmp/modules/extdrv/fos_ptz_fc2403p.ko ptz_state=$ptzstate_xmlcfg horizen_desire_pos=$prehorpos_xmlcfg vertical_desire_pos=$preverpos_xmlcfg
				if [ $? -ne 0 ];then
					/sbin/insmod /tmp/modules/extdrv/fos_ptz_fc2403p.ko ptz_state=1 horizen_desire_pos=0 vertical_desire_pos=0
				fi
				;;
			1054|1055) #"FC2501P"|"FC2501PA"
				/sbin/insmod /tmp/modules/extdrv/fos_ptz_fc2501.ko ptz_state=$ptzstate_xmlcfg horizen_desire_pos=$prehorpos_xmlcfg vertical_desire_pos=$preverpos_xmlcfg
				if [ $? -ne 0 ];then
					/sbin/insmod /tmp/modules/extdrv/fos_ptz_fc2501.ko ptz_state=1 horizen_desire_pos=0 vertical_desire_pos=0
				fi
				;;
			1035|1036|1037) #"FI9826P V2"|"HD818P V2"|"EH8155 V2"
				/sbin/insmod /tmp/modules/extdrv/fos_ptz_hi3518c_zoom.ko ptz_state=$ptzstate_xmlcfg horizen_desire_pos=$prehorpos_xmlcfg vertical_desire_pos=$preverpos_xmlcfg
				if [ $? -ne 0 ];then
					/sbin/insmod /tmp/modules/extdrv/fos_ptz_hi3518c_zoom.ko ptz_state=1 horizen_desire_pos=0 vertical_desire_pos=0
				fi
				;;
			1111)	#"FosBaby"
				;;
			1112|1113)	#"FosBaby P1" "FosBaoPlus"
				if [ -f "/mnt/mtd/app/config/MotorManufacturerHuayong" ];then
					echo "######## here insmod Huayong Motor Drive ########"
					/sbin/insmod /tmp/modules/extdrv/fos_ptz_p1_huayong.ko ptz_state=$ptzstate_xmlcfg horizen_desire_pos=$prehorpos_xmlcfg vertical_desire_pos=$preverpos_xmlcfg
				else
					echo "######## here insmod the old Motor Drive ########"
					/sbin/insmod /tmp/modules/extdrv/fos_ptz_p1.ko ptz_state=$ptzstate_xmlcfg horizen_desire_pos=$prehorpos_xmlcfg vertical_desire_pos=$preverpos_xmlcfg
				fi

				if [ $? -ne 0 ];then
					/sbin/insmod /tmp/modules/extdrv/fos_ptz_p1.ko ptz_state=1 horizen_desire_pos=0 vertical_desire_pos=0
				fi
				;;
			*)
				/sbin/insmod /tmp/modules/extdrv/fos_ptz_hi3518c.ko ptz_state=$ptzstate_xmlcfg horizen_desire_pos=$prehorpos_xmlcfg vertical_desire_pos=$preverpos_xmlcfg
				if [ $? -ne 0 ];then
					/sbin/insmod /tmp/modules/extdrv/fos_ptz_hi3518c.ko ptz_state=1 horizen_desire_pos=0 vertical_desire_pos=0
				fi
				;;
		esac
		;;
	41|42|43|44)
		/sbin/insmod /tmp/modules/extdrv/fos_ptz.ko ptz_state=$ptzstate_xmlcfg horizen_desire_pos=$prehorpos_xmlcfg vertical_desire_pos=$preverpos_xmlcfg
		if [ $? -ne 0 ];then
			/sbin/insmod /tmp/modules/extdrv/fos_ptz.ko ptz_state=1 horizen_desire_pos=0 vertical_desire_pos=0
		fi
		;;
	*)
		;;
esac

if [ $? -ne 0 ] 
then
   echo "insmod fos_ptz.ko fail, now try default param"
   /sbin/insmod /tmp/modules/extdrv/fos_ptz.ko ptz_state=1
fi

/sbin/insmod /tmp/modules/hirtc.ko
/sbin/insmod /tmp/modules/wdt.ko default_margin=60

mkdir -p /etc/Wireless/RT2870STA
cp -f /mnt/mtd/app/etc/RT2870STA.dat /etc/Wireless/RT2870STA/
mkdir -p /etc/Wireless/RT2870AP
cp -f /mnt/mtd/app/etc/RT2870AP.dat /etc/Wireless/RT2870AP/
if [ -f "/mnt/mtd/app/config/Rom.dat" ];then
mac_tail=$(cat /mnt/mtd/app/config/Rom.dat  | tr -d '\0' | sed "s/FOSCAM//g" | cut -c7-12)
else
mac_tail=$(cat /mnt/mtd/app/etc/Rom.dat  | tr -d '\0' | sed "s/FOSCAM//g" | cut -c7-12)
fi
sed -i "s/^SSID.*$/SSID=FosBaby_$mac_tail/g" /etc/Wireless/RT2870AP/RT2870AP.dat
cp -f /mnt/mtd/app/etc/udhcpd.conf /mnt/mtd/app

mkdir /tmp/www
mkdir /etc/ppp

mkdir /mnt/windows

#init network
#if [ -e /mnt/mtd/debug ]; then
#ifconfig eth0 down
#ifconfig eth0 hw ether 004657166815
#ifconfig eth0 up
#ifconfig eth0 192.168.1.15
#mount -t nfs -o nolock 192.168.1.18:/home/yjt/nfs /mnt/nfs
#fi
ifconfig lo up

tar -Jxf /mnt/mtd/app/www.tar.xz -C /tmp/

#0:CN 1:CNEN 2:13 FL
case $LANGUAGE in
	0)
		cp -rf /mnt/mtd/app/diff_cn/* /tmp/www
		;;
	1)
		cp -rf /mnt/mtd/app/diff_cnen/* /tmp/www
		;;
	*)
		;;
esac

case $RESERVEFLAG1 in                               
        101)                                             
                ln -sf /tmp/www/images/login-logo_ht.png /tmp/www/images/login-logo.png 
                ln -sf /tmp/www/images/con-logo_ht.png /tmp/www/images/con-logo.png 
                ;; 
        100)                                             
				echo "OEM Device do nothing."
                ;; 				
        *) 
                ln -sf /tmp/www/images/login-logo_fos.png /tmp/www/images/login-logo.png                                         
                ln -sf /tmp/www/images/con-logo_fos.png /tmp/www/images/con-logo.png 
                                                               
                ;;                                       
esac


ln -s /mnt/mtd/app/plugins/IPCWebComponents.exe /tmp/www/IPCWebComponents.exe
ln -s /mnt/mtd/app/plugins/plugins.pkg /tmp/www/plugins.pkg

rm -rf /mnt/param/ringtone
mkdir -p /mnt/param/ringtone
#0:CN 1:CNEN 2:13 FL
case $LANGUAGE in
        0)
		ln -sf /mnt/mtd/app/ringtone/cn/cableconnected.wav /mnt/param/ringtone/cableconnected.wav
		ln -sf /mnt/mtd/app/ringtone/cn/ezlinkconnecting.wav /mnt/param/ringtone/ezlinkconnecting.wav
		ln -sf /mnt/mtd/app/ringtone/cn/poweron.wav /mnt/param/ringtone/poweron.wav
		ln -sf /mnt/mtd/app/ringtone/cn/reset.wav /mnt/param/ringtone/reset.wav
		ln -sf /mnt/mtd/app/ringtone/cn/wificonnected.wav /mnt/param/ringtone/wificonnected.wav
		ln -sf /mnt/mtd/app/ringtone/cn/wifipasswderr.wav /mnt/param/ringtone/wifipasswderr.wav
		ln -sf /mnt/mtd/app/ringtone/cn/wpsconnecting.wav /mnt/param/ringtone/wpsconnecting.wav
		ln -sf /mnt/mtd/app/ringtone/cn/softapactivated.wav /mnt/param/ringtone/softapactivated.wav
		;;
	2)
		ln -sf /mnt/mtd/app/ringtone/en/cableconnected.wav /mnt/param/ringtone/cableconnected.wav
		ln -sf /mnt/mtd/app/ringtone/en/ezlinkconnecting.wav /mnt/param/ringtone/ezlinkconnecting.wav
		ln -sf /mnt/mtd/app/ringtone/en/poweron.wav /mnt/param/ringtone/poweron.wav
		ln -sf /mnt/mtd/app/ringtone/en/reset.wav /mnt/param/ringtone/reset.wav
		ln -sf /mnt/mtd/app/ringtone/en/wificonnected.wav /mnt/param/ringtone/wificonnected.wav
		ln -sf /mnt/mtd/app/ringtone/en/wifipasswderr.wav /mnt/param/ringtone/wifipasswderr.wav
		ln -sf /mnt/mtd/app/ringtone/en/wpsconnecting.wav /mnt/param/ringtone/wpsconnecting.wav
		ln -sf /mnt/mtd/app/ringtone/en/softapactivated.wav /mnt/param/ringtone/softapactivated.wav
		;;
	*)
		ln -sf /mnt/mtd/app/ringtone/cn/cableconnected.wav /mnt/param/ringtone/cableconnected.wav
		ln -sf /mnt/mtd/app/ringtone/cn/ezlinkconnecting.wav /mnt/param/ringtone/ezlinkconnecting.wav
		ln -sf /mnt/mtd/app/ringtone/cn/poweron.wav /mnt/param/ringtone/poweron.wav
		ln -sf /mnt/mtd/app/ringtone/cn/reset.wav /mnt/param/ringtone/reset.wav
		ln -sf /mnt/mtd/app/ringtone/cn/wificonnected.wav /mnt/param/ringtone/wificonnected.wav
		ln -sf /mnt/mtd/app/ringtone/cn/wifipasswderr.wav /mnt/param/ringtone/wifipasswderr.wav
		ln -sf /mnt/mtd/app/ringtone/cn/wpsconnecting.wav /mnt/param/ringtone/wpsconnecting.wav
		ln -sf /mnt/mtd/app/ringtone/cn/softapactivated.wav /mnt/param/ringtone/softapactivated.wav
		;;
esac

# delete bin files
rm -rf /mnt/mtd/app/bin/*
mkdir /mnt/mtd/app/modules
mkdir /mnt/mtd/app/modules/extdrv

zlib=/mnt/mtd/app/zlib.tar.xz
tar -Jxf ${zlib} -C /usr/
tar -zxf /usr/lib/HZK.tar.gz -C /lib

zbin=/mnt/mtd/app/zbin.tar.xz
# run bin
tar -Jxf ${zbin} -C /usr/

# 0:ar0130_720p 1:9m034 2:icx692 3:imx104 4:ov9712 5:mn34031 6:ar0130_960p 7:soih22 8:ov2710 9:imx122
case $SENSOR in
	0|6)
		ln -sf /usr/lib/libsns_ar0130_960p.so /usr/lib/libsns_mixsensor.so
		;;
	4)
	        if [ $MODELNUM == 4 ]; then  #FI9821W V2
                    cd /usr/bin
	            ./SensorReader
	            if [ $? -eq 1 ];then
                        echo "#h22 sensor"
                        ln -sf /usr/lib/libsns_soih22.so /usr/lib/libsns_mixsensor.so
                    else
                        echo "#9712 sensor"
                        ln -sf /usr/lib/libsns_ov9712.so /usr/lib/libsns_mixsensor.so
                    fi
                else
                   ln -sf /usr/lib/libsns_ov9712.so /usr/lib/libsns_mixsensor.so               
                fi

		;;
	7)
		ln -sf /usr/lib/libsns_soih22.so /usr/lib/libsns_mixsensor.so
		;;
	8)
		ln -sf /usr/lib/libsns_ov2710.so /usr/lib/libsns_mixsensor.so
		;;
	9)
		ln -sf /usr/lib/libsns_imx122.so /usr/lib/libsns_mixsensor.so
		;;
	*)
		echo "sensor $SENSOR lib is not found"
		;;
esac

# copy cgi to web dir
cp /usr/bin/cgi-bin/* /tmp/www/cgi-bin/
# copy script to pppoe dir
mkdir /bin/ppp
cp /usr/bin/ppp/pppoe-start /bin/ppp
cp /usr/bin/ppp/pppoe-stop /bin/ppp
cp /usr/bin/ppp/pppoe-status /bin/ppp
chmod 777 /bin/ppp/*
cp /usr/bin/ppp/* /usr/sbin/
chmod 777 /usr/sbin/*
#telnetd &
mkdir /usr/local
cp -rf /usr/bin/lighttpd-1.4.35-hi/ /usr/local/

mv /tmp/modules/extdrv/mt7601Uap.ko /tmp
mv /tmp/modules/extdrv/mtutil7601Usta.ko /tmp
mv /tmp/modules/extdrv/mt7601Usta.ko /tmp
mv /tmp/modules/extdrv/mtnet7601Usta.ko /tmp
rm -rf /tmp/modules/*
mkdir /tmp/modules/extdrv
mv /tmp/mt7601Uap.ko /tmp/modules/extdrv
mv /tmp/mtutil7601Usta.ko /tmp/modules/extdrv
mv /tmp/mt7601Usta.ko /tmp/modules/extdrv
mv /tmp/mtnet7601Usta.ko /tmp/modules/extdrv

cp /usr/bin/ftpd/FtpPortConfig.xml /mnt/mtd/app/config/
mkdir /usr/local/pureftpd
mkdir /usr/local/pureftpd/etc
cp /usr/bin/ftpd/pureftpd.passwd /usr/local/pureftpd/etc/
cp /usr/bin/ftpd/pureftpd.pdb /usr/local/pureftpd/etc/

export PATH=$PATH:/usr/bin
export PATH=$PATH:/mnt/mtd/app/bin
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/mnt/mtd/app/lib
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/usr/lib

# play reboot music, fosbaby only
echo "bootRing" >> /mnt/mtd/bootRing

#patch
tar -Jxf /mnt/mtd/app/patch/patch.tar.xz -C /
#fonts
mkdir /tmp/fonts/
#tar -xJf /mnt/mtd/app/fonts/jq10_sample2.ttf.tar.xz -C /tmp/fonts/
#dhcp deconfig
if [  -f "/mnt/mtd/default.script" ];then
	rm -rf /usr/share/udhcpc/default.script
	cp /mnt/mtd/default.script  /usr/share/udhcpc/
	chmod +x /usr/share/udhcpc/default.script
fi

rtctool -rtctosys
MsgServer &
update_ver
sleep 2
/usr/bin/watchdog &
