#!/bin/sh

# This is a sample, you should rewrite it according to your chip #

# You can configure your pinmux for the application here!

pinmux_vo_select=mii       #mii, rmii, bt1120
pinmux_i2c_select=i2c      #i2c, gpio_i2c
pinmux_type_select=fosbaby      #fi9805e, fi9821c, fi9808w


#SENSOR default setting is Sensor Clk
sensor_clock_select()
{
	himm 0x200f0008 0x00000001 # 0:GPIO1_2   /1:SENSOR_CLK
}

fi9805e_select()
{
	himm 0x200f0134 0x00000001 #GPIO0_5
	himm 0x200f00fc 0x00000001 #GPIO8_5
	himm 0x200f0100 0x00000001 #GPIO8_6
	himm 0x200f0110 0x00000000 #GPIO5_4
	himm 0x200f0114 0x00000000 #GPIO5_5
	himm 0x200f0118 0x00000000 #GPIO5_6
	himm 0x200f011c 0x00000000 #GPIO5_7
	himm 0x200f007c 0x00000000 #GPIO1_7
	himm 0x200f0000 0x00000000 #GPIO1_0
	himm 0x200f0108 0x00000000 #GPIO7_6
	himm 0x200f010c 0x00000000 #GPIO7_7
	himm 0x200f00c4 0x00000000 #GPIO7_5
	himm 0x200f0024 0x00000001 #UART1_RXD
	himm 0x200f002c 0x00000001 #UART1_TXD
	
	himm 0x200f00c8 0x00000001 #GPIO9_0
	himm 0x200f00cc 0x00000001 #GPIO9_1
	himm 0x200f00d0 0x00000001 #GPIO9_2
	himm 0x200f00d4 0x00000001 #GPIO9_3
	himm 0x200f00d8 0x00000001 #GPIO9_4
	himm 0x200f00dc 0x00000001 #GPIO9_5
	himm 0x200f00e0 0x00000001 #GPIO9_6
	himm 0x200f00e4 0x00000001 #GPIO9_7
	himm 0x200f00bc 0x00000000 #GPIO5_2
	himm 0x200f00c0 0x00000000 #GPIO5_3
	himm 0x200f00e8 0x00000001 #GPIO8_0
	himm 0x200f00ec 0x00000001 #GPIO8_1
	himm 0x200f00f0 0x00000001 #GPIO8_2
	himm 0x200f00f8 0x00000001 #GPIO8_4
	himm 0x200f0104 0x00000001 #GPIO8_7

	himm 0x200f000c 0x00000000 #GPIO1_4
	himm 0x200f0010 0x00000000 #GPIO1_5
	
	echo "fi9805e gpio select";
}

fi9821c_select()
{
	himm 0x200f00bc 0x00000000 #GPIO5_2
	himm 0x200f00c0 0x00000000 #GPIO5_3
	himm 0x200f0120 0x00000000 #GPIO0_0
	himm 0x200f0128 0x00000000 #GPIO0_2
	himm 0x200f012c 0x00000000 #GPIO0_3
	himm 0x200f0130 0x00000000 #GPIO0_4
	himm 0x200f0134 0x00000001 #GPIO0_5
	himm 0x200f0138 0x00000000 #GPIO0_6
	himm 0x200f0024 0x00000001 #UART1_RXD
	himm 0x200f002c 0x00000001 #UART1_TXD
	
	echo "fi9821c gpio select";
}

fi9808w_select()
{
	himm 0x200f0120 0x00000000 #GPIO0_0
	himm 0x200f0124 0x00000000 #GPIO0_1
	himm 0x200f0128 0x00000000 #GPIO0_2
	himm 0x200f012c 0x00000000 #GPIO0_3
	himm 0x200f0130 0x00000000 #GPIO0_4
	himm 0x200f0008 0x00000000 #GPIO1_2
	himm 0x200f0024 0x00000000 #GPIO2_3
	himm 0x200f00bc 0x00000000 #GPIO5_2
	himm 0x200f00c0 0x00000000 #GPIO5_3
	himm 0x200f0134 0x00000001 #GPIO0_5
	himm 0x200f0138 0x00000000 #GPIO0_6
	himm 0x200f013c 0x00000001 #GPIO0_7
	
	echo "fi9808w gpio select";
}

hd950_select()
{
	himm 0x200f0120 0x00000000 #GPIO0_0	I2C->GPIO
	himm 0x200f0124 0x00000000 #GPIO0_1	I2C->GPIO
#	himm 0x200f0128 0x00000000 #GPIO0_2
	himm 0x200f012c 0x00000000 #GPIO0_3	RESET|WPS
#	himm 0x200f0130 0x00000000 #GPIO0_4
#	himm 0x200f0008 0x00000000 #GPIO1_2	SENSOR_CLK
	himm 0x200f0024 0x00000000 #GPIO2_3	LED_POWER
	himm 0x200f00bc 0x00000000 #GPIO5_2	CUT1
	himm 0x200f00c0 0x00000000 #GPIO5_3	CUT2
	himm 0x200f0134 0x00000001 #GPIO0_5	NET_RESET
	himm 0x200f0138 0x00000000 #GPIO0_6	WIFI_POWER
	himm 0x200f013c 0x00000001 #GPIO0_7	SENSOR_RESET
	
	echo "hd950 gpio select";
}

fi9903_select()
{
	himm 0x200f0120 0x00000000 #GPIO0_0	I2C->GPIO
	himm 0x200f0124 0x00000000 #GPIO0_1	I2C->GPIO
#	himm 0x200f0128 0x00000000 #GPIO0_2
	himm 0x200f012c 0x00000000 #GPIO0_3	RESET|WPS
#	himm 0x200f0130 0x00000000 #GPIO0_4
#	himm 0x200f0008 0x00000000 #GPIO1_2	SENSOR_CLK
	himm 0x200f0020 0x00000000 #GPIO2_2	LED_POWER
	himm 0x200f00bc 0x00000000 #GPIO5_2	CUT1
	himm 0x200f00c0 0x00000000 #GPIO5_3	CUT2
	himm 0x200f0134 0x00000001 #GPIO0_5	NET_RESET
	himm 0x200f0138 0x00000000 #GPIO0_6	WIFI_POWER
	himm 0x200f013c 0x00000001 #GPIO0_7	SENSOR_RESET
	
	echo "fi9903 gpio select";
}

# Hi3518C unite
fc2403p_select()
{
	himm 0x200f0120 0x00000000 #GPIO0_0	WIFI_POWER
	himm 0x200f0124 0x00000000 #GPIO0_1	AUDIO_RESET
	himm 0x200f0128 0x00000000 #GPIO0_2	WIFI_LED
	himm 0x200f012c 0x00000000 #GPIO0_3	RESET
	himm 0x200f0130 0x00000000 #GPIO0_4	AUDIO POWER	
	himm 0x200f0134 0x00000001 #GPIO0_5	NET RESET
	himm 0x200f0138 0x00000000 #GPIO0_6	PAN_RIGHT	PT2-2
	himm 0x200f013c 0x00000001 #GPIO0_7	SENSOR_RESET

	himm 0x200f0008 0x00000001 #SENSOR_CLK(G1_2)

	himm 0x200f0020 0x00000000 #GPIO2_2 TILT_UP		PT2-3
	himm 0x200f0024 0x00000000 #GPIO2_3	PAN_LEFT    PT2-1
	himm 0x200f002C 0x00000000 #GPIO2_5	TITL_DOWN	PT2-4

	himm 0x200f0030 0x00000000 #GPIO3_0				PT1-1
	himm 0x200f0034 0x00000000 #GPIO3_1				PT1-2
	himm 0x200f0058 0x00000000 #GPIO3_2				PT1-3

	himm 0x200f003C 0x00000000 #GPIO4_2				PT1-4
	himm 0x200f0038 0x00000000 #GPIO4_3				PT1-5
	himm 0x200f004C 0x00000000 #GPIO4_6				PT1-6
	himm 0x200f0048 0x00000000 #GPIO4_7				PT1-7
	
	himm 0x200f00B8 0x00000000 #GPIO5_1				PT1-8
	himm 0x200f00BC 0x00000000 #GPIO5_2	CUT
	himm 0x200f00C0 0x00000000 #GPIO5_3	IR_LED
	
	himm 0x200f0084 0x00000000 #GPIO6_1	WPS
	
	echo "fc2403p gpio select";
}

fc2501p_select()
{
	himm 0x200f0120 0x00000000 #GPIO0_0	WIFI_POWER
	himm 0x200f0124 0x00000000 #GPIO0_1	AUDIO_RESET
	himm 0x200f0128 0x00000000 #GPIO0_2	WIFI_LED
	himm 0x200f012c 0x00000000 #GPIO0_3	RESET	WPS
	himm 0x200f0130 0x00000000 #GPIO0_4	AUDIO POWER	
	himm 0x200f0134 0x00000001 #GPIO0_5	NET RESET
	himm 0x200f0138 0x00000000 #GPIO0_6	PAN_RIGHT	PT2-2
	himm 0x200f013c 0x00000001 #GPIO0_7	SENSOR_RESET

	himm 0x200f0008 0x00000000 #GPIO1_2 PIR_OUT

	himm 0x200f0020 0x00000000 #GPIO2_2 TILT_UP		PT2-3
	himm 0x200f0024 0x00000000 #GPIO2_3	PAN_LEFT    PT2-1
	himm 0x200f002C 0x00000000 #GPIO2_5	TITL_DOWN	PT2-4

	himm 0x200f0030 0x00000000 #GPIO3_0				PT1-1
	himm 0x200f0034 0x00000000 #GPIO3_1				PT1-2
	himm 0x200f0058 0x00000000 #GPIO3_2				PT1-3

	himm 0x200f003C 0x00000000 #GPIO4_2				PT1-4
	himm 0x200f0038 0x00000000 #GPIO4_3				PT1-5
	himm 0x200f004C 0x00000000 #GPIO4_6				PT1-6
	himm 0x200f0048 0x00000000 #GPIO4_7				PT1-7
	
	himm 0x200f00B8 0x00000000 #GPIO5_1				PT1-8
	himm 0x200f00BC 0x00000000 #GPIO5_2	CUT
	himm 0x200f00C0 0x00000000 #GPIO5_3	IR_LED
	
	himm 0x200f0070 0x00000000 #GPIO1_3	IO_ALARM_IN	
	himm 0x200f0084 0x00000000 #GPIO6_1	IO_ALARM_OUT
	
	echo "fc2501p gpio select";
}

# GPIO TEMP NOT USE
fi9821e_select()
{
	himm 0x200f0120 0x00000000 #GPIO0_0	AUDIO_RESET	FI9821E have no wifi_power
	himm 0x200f0124 0x00000000 #GPIO0_1	AUDIO_POWER
	himm 0x200f0128 0x00000000 #GPIO0_2	WIFI_LED
	himm 0x200f012c 0x00000000 #GPIO0_3	RESET
	himm 0x200f0130 0x00000000 #GPIO0_4	WPS
	himm 0x200f0134 0x00000001 #GPIO0_5	PAN_LEFT	PT2-1
	himm 0x200f0138 0x00000000 #GPIO0_6	PAN_RIGHT	PT2-2
	himm 0x200f013c 0x00000001 #GPIO0_7	SENSOR_RESET

	himm 0x200f0008 0x00000001 #SENSOR_CLK(G1_2)

	himm 0x200f0020 0x00000000 #GPIO2_2 TILT_UP		PT2-3
	himm 0x200f0024 0x00000000 #GPIO2_3	LED_POWER
	himm 0x200f002C 0x00000000 #GPIO2_5	TITL_DOWN	PT2-4

	himm 0x200f0030 0x00000000 #GPIO3_0				PT1-1
	himm 0x200f0034 0x00000000 #GPIO3_1				PT1-2
	himm 0x200f0058 0x00000000 #GPIO3_2				PT1-3

	himm 0x200f003C 0x00000000 #GPIO4_2				PT1-4
	himm 0x200f0038 0x00000000 #GPIO4_3				PT1-5
	himm 0x200f004C 0x00000000 #GPIO4_6				PT1-6
	himm 0x200f0048 0x00000000 #GPIO4_7				PT1-7
	
	himm 0x200f00B8 0x00000000 #GPIO5_1				PT1-8
	himm 0x200f00BC 0x00000000 #GPIO5_2	CUT1
	himm 0x200f00C0 0x00000000 #GPIO5_3	CUT1
	
	himm 0x200f0084 0x00000000 #GPIO6_1	NET_RESET
	
	echo "fi9821e gpio select";
}

fosbaby_select()
{
	himm 0x200f0120 0x00000000 #GPIO0_0
	himm 0x200f0124 0x00000000 #GPIO0_1
	himm 0x200f0128 0x00000000 #GPIO0_2
	himm 0x200f012c 0x00000000 #GPIO0_3
	himm 0x200f0130 0x00000000 #GPIO0_4
	himm 0x200f0134 0x00000001 #GPIO0_5
	himm 0x200f0138 0x00000000 #GPIO0_6
	himm 0x200f013c 0x00000001 #GPIO0_7
	himm 0x200f0008 0x00000001 #SENSOR_CLK NOT GPIO1_2
	himm 0x200f0020 0x00000000 #GPIO2_2
	himm 0x200f0024 0x00000000 #GPIO2_3
	himm 0x200f002c 0x00000000 #GPIO2_5
	himm 0x200f00b8 0x00000000 #GPIO5_1	//spk
	himm 0x200f00bc 0x00000000 #GPIO5_2
	himm 0x200f00c0 0x00000000 #GPIO5_3
		
	echo "fosbaby gpio select";
}

fosbabyp1_select()
{
	himm 0x200f0120 0x00000000 #GPIO0_0
	himm 0x200f0124 0x00000000 #GPIO0_1
	himm 0x200f0128 0x00000000 #GPIO0_2
	himm 0x200f012c 0x00000000 #GPIO0_3
	himm 0x200f0130 0x00000000 #GPIO0_4
	himm 0x200f0134 0x00000001 #GPIO0_5
	himm 0x200f0138 0x00000000 #GPIO0_6
	himm 0x200f013c 0x00000001 #GPIO0_7
	himm 0x200f0008 0x00000001 #SENSOR_CLK NOT GPIO1_2
	himm 0x200f0070 0x00000000 #GPIO1_3 NightLed
	himm 0x200f0020 0x00000000 #GPIO2_2
	himm 0x200f0024 0x00000001 #GPIO2_3
	himm 0x200f002c 0x00000000 #GPIO2_5
	himm 0x200f0030 0x00000000 #GPIO3_0	//PT
	himm 0x200f0034 0x00000000 #GPIO3_1	//PT
	himm 0x200f0058 0x00000000 #GPIO3_2	//PT
	himm 0x200f0044 0x00000000 #GPIO4_0	//PT
	himm 0x200f0040 0x00000000 #GPIO4_1	//PT
	himm 0x200f003C 0x00000000 #GPIO4_2	//PT
	himm 0x200f0038 0x00000000 #GPIO4_3	//PT
	himm 0x200f0054 0x00000000 #GPIO4_4	//PT
	himm 0x200f0050 0x00000000 #GPIO4_5	//PT
	himm 0x200f004C 0x00000000 #GPIO4_6	//PT
	himm 0x200f0048 0x00000000 #GPIO4_7	//PT
	himm 0x200f00b8 0x00000000 #GPIO5_1	//PT
	himm 0x200f00bc 0x00000000 #GPIO5_2	//IR_CUT
	himm 0x200f00c0 0x00000000 #GPIO5_3	//IR_LED
	himm 0x200f0084 0x00000000 #GPIO6_1	//SoftAp
		
	echo "fosbabyp1 gpio select";
}



#VICAP default setting is VIU
vicap_pin_mux_select()
{
	himm 0x200f0140 0x00000000 # 0:VIU_CLK   / 1:GPIO11_6
	himm 0x200f0144 0x00000000 # 0:VIU_VS    / 1:GPIO11_5
	himm 0x200f0148 0x00000000 # 0:VIU_HS    / 1:GPIO11_4
	himm 0x200f014c 0x00000000 # 0:VIU_DAT11 / 1:GPIO11_3
	himm 0x200f0150 0x00000000 # 0:VIU_DAT10 / 1:GPIO11_2
	himm 0x200f0154 0x00000000 # 0:VIU_DAT9  / 1:GPIO11_1
	himm 0x200f0158 0x00000000 # 0:VIU_DAT8  / 1:GPIO11_0
	himm 0x200f015c 0x00000000 # 0:VIU_DAT7  / 1:GPIO10_7
	himm 0x200f0160 0x00000000 # 0:VIU_DAT6  / 1:GPIO10_6
	himm 0x200f0164 0x00000000 # 0:VIU_DAT5  / 1:GPIO10_5
	himm 0x200f0168 0x00000000 # 0:VIU_DAT4  / 1:GPIO10_4
	himm 0x200f016c 0x00000000 # 0:VIU_DAT3  / 1:GPIO10_3
	himm 0x200f0170 0x00000000 # 0:VIU_DAT2  / 1:GPIO10_2
	himm 0x200f0174 0x00000000 # 0:VIU_DAT1  / 1:GPIO10_1
	himm 0x200f0178 0x00000000 # 0:VIU_DAT0  / 1:GPIO10_0    
}

#I2C default setting is I2C
i2c_type_select()
{
	himm 0x200f0018 0x00000001 # 0:GPIO2_0   / 1:I2C_SDA
	himm 0x200f001c 0x00000001 # 0:GPIO2_1   / 1:I2C_SCL
}

#I2C default setting is I2C
gpio_i2c_type_select()
{
	himm 0x200f0018 0x00000000 # 0:GPIO2_0   / 1:I2C_SDA
	himm 0x200f001c 0x00000000 # 0:GPIO2_1   / 1:I2C_SCL
}

#MII
net_mii_mode()
{
	himm 0x200f0030  0x1
	himm 0x200f0034  0x1
	himm 0x200f0038  0x1
	himm 0x200f003C  0x1
	himm 0x200f0040  0x1
	himm 0x200f0044  0x1
	himm 0x200f0048  0x1
	himm 0x200f004C  0x1
	himm 0x200f0050  0x1
	himm 0x200f0054  0x1
	himm 0x200f0058  0x1
	himm 0x200f005C  0x1
	himm 0x200f0060  0x1
	himm 0x200f0064  0x1
	himm 0x200f0068  0x1
	himm 0x200f006C  0x1
	himm 0x200f0070  0x1
	himm 0x200f0074  0x1
	himm 0x200f0078  0x1      
}

#RMII    
net_rmii_mode()
{
	himm 0x200f0030  0x1
	himm 0x200f0034  0x1
	himm 0x200f0038  0x1
	himm 0x200f003C  0x1
	himm 0x200f0040  0x1
	himm 0x200f0044  0x1
	himm 0x200f0048  0x1
	himm 0x200f004C  0x1
	himm 0x200f0050  0x1
	himm 0x200f0054  0x1
	himm 0x200f0058  0x1
	himm 0x200f005C  0x3
	himm 0x200f0060  0x1
	himm 0x200f0064  0x1
	himm 0x200f0068  0x1  #MII_TXER 0x1,GPIO2_6 0x0
	himm 0x200f006C  0x1  #MII_RXER 0x1,GPIO2_7 0x0
	himm 0x200f0070  0x1
	himm 0x200f0074  0x1
	himm 0x200f0078  0x1
}      
      
#BT1120
vo_bt1120_mode()
{
	himm 0x200f0030  0x2  #VOU1120_DATA10,MII_CRS 0x1,GPIO3_0 0x0
	himm 0x200f0034  0x2  #VOU1120_DATA9,MII_COL 0x1,GPIO3_1 0x0
	himm 0x200f0038  0x2  #VOU1120_DATA15,MII_RXD3 0x1,GPIO4_3 0x0  
	himm 0x200f003C  0x2  #VOU1120_DATA11,MII_RXD2 0x1,GPIO4_2 0x0
	himm 0x200f0040  0x2  #VOU1120_DATA8,MII_RXD1 0x1,GPIO4_1 0x0
	himm 0x200f0044  0x2  #VOU1120_DATA12,MII_RXD0 0x1,GPIO4_0 0x0
	himm 0x200f0048  0x2  #VOU1120_DATA3,MII_TXD3 0x1,GPIO4_7 0x0
	himm 0x200f004C  0x2  #VOU1120_DATA13,MII_TXD2 0x1,GPIO4_6 0x0
	himm 0x200f0050  0x2  #VOU1120_DATA0,MII_TXD1 0x1,GPIO4_5 0x0
	himm 0x200f0054  0x2  #VOU1120_DATA4,MII_TXD0 0x1,GPIO4_4 0x0
	himm 0x200f0058  0x2  #VOU1120_CLK,MII_RXCK 0x1,GPIO3_2 0x0
	himm 0x200f005C  0x2  #VOU1120_DATA7,MII_TXCK 0x1,GPIO3_3 0x0,RMII_CK 0x3
	himm 0x200f0060  0x2  #VOU1120_DATA1,MII_RXDV 0x1,GPIO3_4 0x0
	himm 0x200f0064  0x2  #VOU1120_DATA5,MII_TXEN 0x1,GPIO3_5 0x0
	himm 0x200f0070  0x2  #VOU1120_DATA2,EPHY_CLK 0x1,GPIO1_3 0x0
	himm 0x200f0074  0x2  #VOU1120_DATA6,MDCK 0x1,GPIO3_6 0x0,BOOTSEL 0x3
	himm 0x200f0078  0x2  #VOU1120_DATA14,MDIO 0x1,GPIO3_7 0x0
}

if [ $# -ge 1 ]; then
    pinmux_vo_select=$1
fi

if [ $# -ge 2 ]; then
    pinmux_i2c_select=$2
fi

if [ $# -ge 3 ]; then
    pinmux_type_select=$3
fi

case $pinmux_vo_select in
bt1120)
    echo "use bt1120";
    vo_bt1120_mode;
;;
rmii)
    echo "use rmii";
    net_rmii_mode;
;;
*)
    echo "use mii";
    net_mii_mode;
;;
esac

case $pinmux_i2c_select in
gpio_i2c)
    echo "use gpio_i2c";
    gpio_i2c_type_select;
;;
*)
    echo "use i2c";
    i2c_type_select;
;;
esac

if [ "$pinmux_type_select" = "fc2501p" ]; then
	 echo "############## this device is fc2501p, will not do sensor_clock_select ####";
else
	echo "############## this device is not fc2501p, will do sensor_clock_select ####";
	sensor_clock_select;
fi

#vicap_pin_mux_select;

case $pinmux_type_select in
fi9808w)
    fi9808w_select;
;;
fi9821c)
    fi9821c_select;
;;
hd950)
	hd950_select;
;;
fi9903)
	fi9903_select;
;;
fi9821e)
	fi9821e_select;
;;
fc2403p)
	fc2403p_select;
;;
fosbaby)
	fosbaby_select;
;;
fosbabyp1)
	fosbabyp1_select;
;;
fc2501p)
	fc2501p_select;
;;
*)
    fi9805e_select;
;;
esac
