#include "Perceptron.h"
#include <random>

Perceptron::Perceptron(int _n)
{
	std::random_device rd;
	std::uniform_real_distribution<float> dist(-1, 1);
	mWeights = new std::vector<float>();
	for (int i = 0; i < _n; i++)
	{
		mWeights->push_back(dist(rd));
	}
}
Perceptron::~Perceptron()
{
	delete mWeights;
	mWeights = nullptr;
}
float Perceptron::calculate(std::vector<float>* _inputs)
{
	float sum = 0;
	for (int i = 0; i < mWeights->size(); i++)
	{
		sum += (*mWeights)[i] * (*_inputs)[i];
	}
	return (activate(sum));
}

float Perceptron::activate(float _sum)
{
	if (_sum > THRESHOLD)
		return 1;
	else
		return 0;
}

int Perceptron::train(std::vector<float> *_inputs, int _desired)
{
	float guess = calculate(_inputs);
	float error = _desired - guess;
	for (int i = 0; i < mWeights->size(); i++) {
		(*mWeights)[i] += LEARNING_CONSTANT * error * (*_inputs)[i];
	}
	return guess;
}