#include "Trainer.h"
#include "Perceptron.h"
#include <iostream>
#include <random>
Trainer::Trainer(Perceptron * _child)
{
	mChild = _child;
	mInputs = new std::vector<float>();
	mRight = 0;
	mWrong = 0;
}

void Trainer::start(int _cycles)
{
	
	std::random_device rd;
	std::uniform_real_distribution<float> dist(-20, 20);
	for (int i = 0; i < _cycles; i++)
	{
		mInputs->clear();
		mAnswer = 1;
		mInputs->push_back(dist(rd));
		mInputs->push_back(dist(rd));
		mInputs->push_back(1);
		if (Line((*mInputs)[0]) >= (*mInputs)[1]) mAnswer = 0;
		if (mChild->train(mInputs, mAnswer) == mAnswer)
			mRight++;
		else
			mWrong++;
		
	}
	std::cout << "has % right: " << (float)mRight / (float)(mRight + mWrong)  << std::endl;
}

float Trainer::Line(float _x)
{
	return 2 * _x + 5;
}