(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    499284,      12327]*)
(*NotebookOutlinePosition[    499929,      12349]*)
(*  CellTagsIndexPosition[    499885,      12345]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \(\[IndentingNewLine]\)], "Input"],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(h[x_] := \(-3\) x^3 + x^2 + 4  x + 
        2\)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(extremwertplot = \ Plot[h[x], {x, \ \(-3\), \ 3}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.211485 0.03976 [
[.02381 .19898 -6 -9 ]
[.02381 .19898 6 0 ]
[.18254 .19898 -6 -9 ]
[.18254 .19898 6 0 ]
[.34127 .19898 -6 -9 ]
[.34127 .19898 6 0 ]
[.65873 .19898 -3 -9 ]
[.65873 .19898 3 0 ]
[.81746 .19898 -3 -9 ]
[.81746 .19898 3 0 ]
[.97619 .19898 -3 -9 ]
[.97619 .19898 3 0 ]
[.4875 .05244 -12 -4.5 ]
[.4875 .05244 0 4.5 ]
[.4875 .13196 -12 -4.5 ]
[.4875 .13196 0 4.5 ]
[.4875 .291 -6 -4.5 ]
[.4875 .291 0 4.5 ]
[.4875 .37052 -6 -4.5 ]
[.4875 .37052 0 4.5 ]
[.4875 .45004 -6 -4.5 ]
[.4875 .45004 0 4.5 ]
[.4875 .52956 -6 -4.5 ]
[.4875 .52956 0 4.5 ]
[.4875 .60908 -12 -4.5 ]
[.4875 .60908 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .21148 m
.02381 .21773 L
s
[(-3)] .02381 .19898 0 1 Mshowa
.18254 .21148 m
.18254 .21773 L
s
[(-2)] .18254 .19898 0 1 Mshowa
.34127 .21148 m
.34127 .21773 L
s
[(-1)] .34127 .19898 0 1 Mshowa
.65873 .21148 m
.65873 .21773 L
s
[(1)] .65873 .19898 0 1 Mshowa
.81746 .21148 m
.81746 .21773 L
s
[(2)] .81746 .19898 0 1 Mshowa
.97619 .21148 m
.97619 .21773 L
s
[(3)] .97619 .19898 0 1 Mshowa
.125 Mabswid
.05556 .21148 m
.05556 .21523 L
s
.0873 .21148 m
.0873 .21523 L
s
.11905 .21148 m
.11905 .21523 L
s
.15079 .21148 m
.15079 .21523 L
s
.21429 .21148 m
.21429 .21523 L
s
.24603 .21148 m
.24603 .21523 L
s
.27778 .21148 m
.27778 .21523 L
s
.30952 .21148 m
.30952 .21523 L
s
.37302 .21148 m
.37302 .21523 L
s
.40476 .21148 m
.40476 .21523 L
s
.43651 .21148 m
.43651 .21523 L
s
.46825 .21148 m
.46825 .21523 L
s
.53175 .21148 m
.53175 .21523 L
s
.56349 .21148 m
.56349 .21523 L
s
.59524 .21148 m
.59524 .21523 L
s
.62698 .21148 m
.62698 .21523 L
s
.69048 .21148 m
.69048 .21523 L
s
.72222 .21148 m
.72222 .21523 L
s
.75397 .21148 m
.75397 .21523 L
s
.78571 .21148 m
.78571 .21523 L
s
.84921 .21148 m
.84921 .21523 L
s
.88095 .21148 m
.88095 .21523 L
s
.9127 .21148 m
.9127 .21523 L
s
.94444 .21148 m
.94444 .21523 L
s
.25 Mabswid
0 .21148 m
1 .21148 L
s
.5 .05244 m
.50625 .05244 L
s
[(-4)] .4875 .05244 1 0 Mshowa
.5 .13196 m
.50625 .13196 L
s
[(-2)] .4875 .13196 1 0 Mshowa
.5 .291 m
.50625 .291 L
s
[(2)] .4875 .291 1 0 Mshowa
.5 .37052 m
.50625 .37052 L
s
[(4)] .4875 .37052 1 0 Mshowa
.5 .45004 m
.50625 .45004 L
s
[(6)] .4875 .45004 1 0 Mshowa
.5 .52956 m
.50625 .52956 L
s
[(8)] .4875 .52956 1 0 Mshowa
.5 .60908 m
.50625 .60908 L
s
[(10)] .4875 .60908 1 0 Mshowa
.125 Mabswid
.5 .07232 m
.50375 .07232 L
s
.5 .0922 m
.50375 .0922 L
s
.5 .11208 m
.50375 .11208 L
s
.5 .15184 m
.50375 .15184 L
s
.5 .17172 m
.50375 .17172 L
s
.5 .1916 m
.50375 .1916 L
s
.5 .23136 m
.50375 .23136 L
s
.5 .25124 m
.50375 .25124 L
s
.5 .27112 m
.50375 .27112 L
s
.5 .31088 m
.50375 .31088 L
s
.5 .33076 m
.50375 .33076 L
s
.5 .35064 m
.50375 .35064 L
s
.5 .3904 m
.50375 .3904 L
s
.5 .41028 m
.50375 .41028 L
s
.5 .43016 m
.50375 .43016 L
s
.5 .46992 m
.50375 .46992 L
s
.5 .4898 m
.50375 .4898 L
s
.5 .50968 m
.50375 .50968 L
s
.5 .54944 m
.50375 .54944 L
s
.5 .56932 m
.50375 .56932 L
s
.5 .5892 m
.50375 .5892 L
s
.5 .03256 m
.50375 .03256 L
s
.5 .01268 m
.50375 .01268 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.24912 .61803 m
.26171 .54542 L
.28302 .4526 L
.30316 .38241 L
.32313 .32818 L
.34157 .29048 L
.36029 .26315 L
.37094 .25209 L
.38092 .24443 L
.38588 .24154 L
.3913 .23905 L
.39378 .23813 L
.39642 .2373 L
.39889 .23666 L
.40117 .23619 L
.40357 .2358 L
.40483 .23565 L
.40617 .23552 L
.40733 .23544 L
.40842 .23539 L
.40961 .23536 L
.41088 .23536 L
.41202 .23538 L
.41325 .23543 L
.41441 .23551 L
.41549 .2356 L
.41753 .23584 L
.41969 .23617 L
.42458 .23721 L
.42906 .23852 L
.43916 .24261 L
.44807 .2474 L
.45744 .25352 L
.49555 .28658 L
.53611 .32784 L
.55485 .34579 L
.57516 .36256 L
.58626 .37003 L
.5965 .37559 L
.60629 .37952 L
.61123 .38093 L
.61403 .38155 L
.61665 .38201 L
.61791 .38219 L
.61924 .38235 L
.62039 .38246 L
.62163 .38255 L
.6224 .38259 L
.6231 .38262 L
.62377 .38264 L
Mistroke
.62448 .38265 L
.62571 .38265 L
.62641 .38263 L
.62706 .38261 L
.62835 .38254 L
.62956 .38244 L
.63065 .38233 L
.63183 .38218 L
.63449 .38175 L
.63694 .38121 L
.64122 .37997 L
.64594 .37813 L
.65086 .37567 L
.65548 .37284 L
.66534 .365 L
.6757 .35399 L
.69422 .32662 L
.714 .28539 L
.73238 .23479 L
.77148 .08257 L
Mfstroke
.77148 .08257 m
.78725 0 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oS`3oool0
0`000000oooo0?ooo`2>0?ooo`00S`3oool00`000000oooo0?ooo`1>0?ooo`030000003oool0oooo
03d0oooo002?0?ooo`030000003oool0oooo04h0oooo00<000000?ooo`3oool0?@3oool008l0oooo
0P00001>0?ooo`030000003oool0oooo03h0oooo002?0?ooo`030000003oool0oooo04d0oooo00<0
00000?ooo`3oool0?P3oool008l0oooo00<000000?ooo`3oool0C@3oool00`000000oooo0?ooo`0n
0?ooo`00S`3oool00`000000oooo0?ooo`1=0?ooo`030000003oool0oooo03h0oooo002?0?ooo`03
0000003oool0oooo04d0oooo00<000000?ooo`3oool0?P3oool008l0oooo00<000000?ooo`3oool0
C@3oool00`000000oooo0?ooo`0n0?ooo`00S`3oool2000004d0oooo00<000000?ooo`3oool0?`3o
ool008l0oooo00<000000?ooo`3oool0C03oool00`000000oooo0?ooo`0o0?ooo`00S`3oool00`00
0000oooo0?ooo`1<0?ooo`030000003oool0oooo03l0oooo00280?ooo`<00000103oool00`000000
oooo0?ooo`1<0?ooo`030000003oool0oooo03l0oooo00290?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool0C03oool00`000000oooo0?ooo`0o0?ooo`00QP3oool5000000@0oooo0`00
001<0?ooo`030000003oool0oooo03l0oooo00200?ooo`@000000P3oool010000000oooo0?ooo`00
00050?ooo`030000003oool0oooo04/0oooo00<000000?ooo`3oool0@03oool008L0oooo00<00000
0?ooo`0000001@3oool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo0400oooo00280?oo
o`8000001@3oool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo0400oooo002?0?ooo`03
0000003oool0oooo04/0oooo00<000000?ooo`3oool0@03oool008l0oooo00<000000?ooo`3oool0
B`3oool00`000000oooo0?ooo`100?ooo`00S`3oool2000004`0oooo00<000000?ooo`3oool0@03o
ool008l0oooo00<000000?ooo`3oool0BP3oool00`000000oooo0?ooo`110?ooo`00S`3oool00`00
0000oooo0?ooo`1:0?ooo`030000003oool0oooo0440oooo002?0?ooo`030000003oool0oooo04X0
oooo00<000000?ooo`3oool0@@3oool008l0oooo00<000000?ooo`3oool0BP3oool00`000000oooo
0?ooo`110?ooo`00S`3oool00`000000oooo0?ooo`190?ooo`030000003oool0oooo0480oooo002?
0?ooo`800000BP3oool00`000000oooo0?ooo`120?ooo`00S`3oool00`000000oooo0?ooo`190?oo
o`030000003oool0oooo0480oooo002?0?ooo`030000003oool0oooo04T0oooo00<000000?ooo`3o
ool0@P3oool008l0oooo00<000000?ooo`3oool0B03oool00`000000oooo0?ooo`130?ooo`00S`3o
ool00`000000oooo0?ooo`180?ooo`030000003oool0oooo04<0oooo002?0?ooo`800000B@3oool0
0`000000oooo0?ooo`130?ooo`00S`3oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo
04<0oooo002?0?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0A03oool008l0oooo
00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`140?ooo`00QP3oool4000000D0oooo00<0
00000?ooo`3oool0A`3oool00`000000oooo0?ooo`140?ooo`00QP3oool00`000000oooo0?ooo`06
0?ooo`030000003oool0oooo04L0oooo00<000000?ooo`3oool0A03oool008L0oooo00<000000?oo
o`3oool01@3oool3000004H0oooo00<000000?ooo`3oool0A@3oool00800oooo100000040?ooo`03
0000003oool0oooo00@0oooo00<000000?ooo`3oool0AP3oool00`000000oooo0?ooo`150?ooo`00
QP3oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo04H0oooo00<000000?ooo`3o
ool0A@3oool008L0oooo0P0000060?ooo`030000003oool0oooo04H0oooo00<000000?ooo`3oool0
A@3oool008l0oooo00<000000?ooo`3oool0A@3oool00`000000oooo0?ooo`160?ooo`00S`3oool0
0`000000oooo0?ooo`150?ooo`030000003oool0oooo04H0oooo002?0?ooo`800000AP3oool00`00
0000oooo0?ooo`160?ooo`00S`3oool00`000000oooo0?ooo`150?ooo`030000003oool0oooo04H0
oooo002?0?ooo`030000003oool0oooo04@0oooo00<000000?ooo`3oool0A`3oool008l0oooo00<0
00000?ooo`3oool0A03oool00`000000oooo0?ooo`170?ooo`00S`3oool00`000000oooo0?ooo`14
0?ooo`030000003oool0oooo04L0oooo000:0?ooo`800000:P3oool4000002T0oooo1@00000W0?oo
o`800000:@3oool5000001L0oooo00<000000?ooo`3oool03P3oool4000002X0oooo0P0000090?oo
o`002@3oool010000000oooo0?ooo`00000Y0?ooo`030000003oool0oooo02`0oooo00<000000?oo
o`3oool09`3oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo01H0oooo00<000000?oo
o`3oool03`3oool00`000000oooo0?ooo`0Z0?ooo`040000003oool0oooo000000P0oooo000;0?oo
o`030000003oool0oooo02T0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`0W0?oo
o`030000003oool0oooo02X0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo02/0oooo00<000000?ooo`3oool01`3oool000<0oooo100000050?ooo`03
0000003oool0oooo0240oooo100000040?ooo`030000003oool0oooo0280oooo100000040?ooo`03
0000003oool0oooo02L0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`0F0?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`060?ooo`00
2@3oool010000000oooo0?ooo`00000Y0?ooo`040000003oool0oooo000002/0oooo00<000000?oo
o`3oool09`3oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo01H0oooo00<000000?oo
o`3oool03`3oool010000000oooo0?ooo`00000Y0?ooo`040000003oool0oooo000000P0oooo000:
0?ooo`800000:`3oool2000002/0oooo0P00000Y0?ooo`030000003oool0oooo02T0oooo0P00000G
0?ooo`030000003oool0oooo0140oooo0P00000[0?ooo`8000002@3oool008l0oooo0P0000130?oo
o`030000003oool0oooo04T0oooo002?0?ooo`030000003oool0oooo0480oooo00<000000?ooo`3o
ool0B@3oool008l0oooo00<000000?ooo`3oool0@P3oool00`000000oooo0?ooo`190?ooo`00S`3o
ool00`000000oooo0?ooo`110?ooo`030000003oool0oooo04X0oooo002?0?ooo`030000003oool0
oooo0440oooo00<000000?ooo`3oool0BP3oool000030?ooo`00000000000?l00000700000020?oo
o`00203oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0080oooo00D000000?ooo`3o
ool0oooo000000080?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00080?ooo`030000003oool0oooo02X0
oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo02X0
oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo02X0
oooo00<000000?ooo`3oool01`3oool008l0oooo00<000000?ooo`3oool0@03oool00`000000oooo
0?ooo`1;0?ooo`00S`3oool00`000000oooo0?ooo`100?ooo`030000003oool0oooo04/0oooo002?
0?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool0B`3oool008l0oooo0P0000100?oo
o`030000003oool0oooo04`0oooo001c0?ooo`H000005P3oool00`000000oooo0?ooo`0o0?ooo`03
0000003oool0oooo04`0oooo001`0?ooo`<000001P3oool400000180oooo00<000000?ooo`3oool0
?`3oool00`000000oooo0?ooo`1<0?ooo`00K`3oool00`000000oooo0?ooo`0;0?ooo`800000403o
ool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo04d0oooo001]0?ooo`800000403oool0
0`000000oooo0?ooo`0=0?ooo`030000003oool0oooo03h0oooo00<000000?ooo`3oool0C@3oool0
06/0oooo0P00000C0?ooo`8000003@3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo
04d0oooo001Z0?ooo`030000003oool0oooo01D0oooo0P00000;0?ooo`800000?P3oool00`000000
oooo0?ooo`1>0?ooo`00J@3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool0?@3oool00`000000oooo0?ooo`1>0?ooo`00J03oool00`000000oooo0?oo
o`0J0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0?03oool00`000000oooo0?oo
o`1?0?ooo`00I`3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool0?03oool00`000000oooo0?ooo`1?0?ooo`00IP3oool00`000000oooo0?ooo`0N0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`1?0?oo
o`00IP3oool00`000000oooo0?ooo`0O0?ooo`8000001@3oool2000003`0oooo00<000000?ooo`3o
ool0D03oool006D0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`020?ooo`030000
003oool0oooo03/0oooo00<000000?ooo`3oool0D03oool006@0oooo00<000000?ooo`3oool0903o
ool01@000000oooo0?ooo`3oool0000003d0oooo00<000000?ooo`3oool0D03oool006@0oooo00<0
00000?ooo`3oool09@3oool010000000oooo0?ooo`00000l0?ooo`030000003oool0oooo0540oooo
001S0?ooo`030000003oool0oooo0200oooo100000030?ooo`030000003oool0000003`0oooo00<0
00000?ooo`3oool0D@3oool006<0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`05
0?ooo`800000>`3oool00`000000oooo0?ooo`1B0?ooo`00HP3oool00`000000oooo0?ooo`0R0?oo
o`030000003oool0oooo00D0oooo0`00000i0?ooo`030000003oool0oooo0580oooo001Q0?ooo`03
0000003oool0oooo02@0oooo00<000000?ooo`3oool0103oool2000003T0oooo00<000000?ooo`3o
ool0D`3oool00640oooo00<000000?ooo`3oool08P3oool010000000oooo0?ooo`0000050?ooo`03
0000003oool0000003P0oooo00<000000?ooo`3oool0D`3oool00600oooo00<000000?ooo`3oool0
903oool2000000H0oooo00@000000?ooo`3oool00000=P3oool00`000000oooo0?ooo`1D0?ooo`00
H03oool00`000000oooo0?ooo`0/0?ooo`050000003oool0oooo0?ooo`000000=@3oool00`000000
oooo0?ooo`1D0?ooo`00G`3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo0080oooo
00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`1E0?ooo`00G`3oool00`000000oooo0?oo
o`0]0?ooo`800000103oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo05D0oooo001N
0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0^
0?ooo`030000003oool0oooo05H0oooo001N0?ooo`030000003oool0oooo02h0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo05H0oooo001M0?ooo`03
0000003oool0oooo02l0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0[0?ooo`03
0000003oool0oooo05L0oooo001M0?ooo`030000003oool0oooo02l0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo05L0oooo001M0?ooo`030000003o
ool0oooo02l0oooo0P0000090?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0F03o
ool005`0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo02L0oooo00<000000?ooo`3oool0F03oool005`0oooo00<000000?ooo`3oool0<03oool00`00
0000oooo0?ooo`0:0?ooo`8000009P3oool00`000000oooo0?ooo`1I0?ooo`00F`3oool00`000000
oooo0?ooo`0a0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool08P3oool00`000000
oooo0?ooo`1J0?ooo`00F`3oool00`000000oooo0?ooo`0a0?ooo`030000003oool0oooo00d0oooo
00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`1J0?ooo`00F`3oool00`000000oooo0?oo
o`0a0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?oo
o`1K0?ooo`00FP3oool00`000000oooo0?ooo`0b0?ooo`800000403oool00`000000oooo0?ooo`0N
0?ooo`030000003oool0oooo05/0oooo001J0?ooo`030000003oool0oooo0380oooo00<000000?oo
o`3oool0403oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo05`0oooo001J0?ooo`03
0000003oool0oooo0380oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0J0?ooo`03
0000003oool0oooo05d0oooo001I0?ooo`030000003oool0oooo02`0oooo0`0000040?ooo`030000
003oool0oooo0180oooo00<000000?ooo`3oool0603oool00`000000oooo0?ooo`1N0?ooo`00F@3o
ool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool04`3o
ool2000001L0oooo00<000000?ooo`3oool0G`3oool005P0oooo00<000000?ooo`3oool0:`3oool5
000000@0oooo0`00000E0?ooo`030000003oool0oooo0180oooo0P00001R0?ooo`00F03oool00`00
0000oooo0?ooo`0[0?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool05P3oool2
00000140oooo00<000000?ooo`3oool0HP3oool005P0oooo00<000000?ooo`3oool0;03oool00`00
0000oooo000000050?ooo`030000003oool0oooo01P0oooo0P00000>0?ooo`030000003oool0oooo
06<0oooo001G0?ooo`030000003oool0oooo02h0oooo0P0000050?ooo`030000003oool0oooo01X0
oooo0`0000070?ooo`@00000IP3oool005L0oooo00<000000?ooo`3oool0=@3oool00`000000oooo
0?ooo`0M0?ooo`L00000JP3oool005L0oooo00<000000?ooo`3oool0=@3oool00`000000oooo0?oo
o`2>0?ooo`00EP3oool00`000000oooo0?ooo`0f0?ooo`800000S`3oool005H0oooo00<000000?oo
o`3oool0=P3oool00`000000oooo0?ooo`2>0?ooo`00EP3oool00`000000oooo0?ooo`0f0?ooo`03
0000003oool0oooo08h0oooo001F0?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0
SP3oool005D0oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`2>0?ooo`00E@3oool0
0`000000oooo0?ooo`0g0?ooo`030000003oool0oooo08h0oooo001E0?ooo`030000003oool0oooo
03L0oooo0P00002?0?ooo`00E@3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo08h0
oooo001D0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool0SP3oool005@0oooo00<0
00000?ooo`3oool0>03oool00`000000oooo0?ooo`2>0?ooo`00E03oool00`000000oooo0?ooo`0h
0?ooo`030000003oool0oooo08h0oooo001D0?ooo`030000003oool0oooo03P0oooo0P00002?0?oo
o`00D`3oool00`000000oooo0?ooo`0i0?ooo`030000003oool0oooo08h0oooo001C0?ooo`030000
003oool0oooo03T0oooo00<000000?ooo`3oool0SP3oool005<0oooo00<000000?ooo`3oool0>@3o
ool00`000000oooo0?ooo`2>0?ooo`00D`3oool00`000000oooo0?ooo`0`0?ooo`<000001P3oool0
0`000000oooo0?ooo`2>0?ooo`00DP3oool00`000000oooo0?ooo`0a0?ooo`040000003oool0oooo
000000D0oooo00<000000?ooo`3oool0SP3oool00580oooo00<000000?ooo`3oool0<@3oool01000
0000oooo0?ooo`0000050?ooo`<00000SP3oool00580oooo00<000000?ooo`3oool0<@3oool30000
00H0oooo00<000000?ooo`3oool0SP3oool00580oooo00<000000?ooo`3oool0<P3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo08h0oooo001B0?ooo`030000003oool0oooo0380oooo
0`0000050?ooo`030000003oool0oooo08h0oooo001A0?ooo`030000003oool0oooo03/0oooo00<0
00000?ooo`3oool0SP3oool00540oooo00<000000?ooo`3oool0>`3oool00`000000oooo0?ooo`2>
0?ooo`00D@3oool00`000000oooo0?ooo`0k0?ooo`800000S`3oool00540oooo00<000000?ooo`3o
ool0>`3oool00`000000oooo0?ooo`2>0?ooo`00D03oool00`000000oooo0?ooo`0l0?ooo`030000
003oool0oooo08h0oooo001@0?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3oool0SP3o
ool00500oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`2>0?ooo`00D03oool00`00
0000oooo0?ooo`0l0?ooo`800000S`3oool004l0oooo00<000000?ooo`3oool0?@3oool00`000000
oooo0?ooo`2>0?ooo`00C`3oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo08h0oooo
001?0?ooo`030000003oool0oooo03d0oooo00<000000?ooo`3oool0SP3oool004l0oooo00<00000
0?ooo`3oool0?@3oool00`000000oooo0?ooo`2>0?ooo`00C`3oool00`000000oooo0?ooo`0m0?oo
o`030000003oool0oooo08h0oooo001>0?ooo`030000003oool0oooo03h0oooo0P00002?0?ooo`00
CP3oool00`000000oooo0?ooo`0n0?ooo`030000003oool0oooo08h0oooo001>0?ooo`030000003o
ool0oooo03h0oooo00<000000?ooo`3oool0SP3oool004h0oooo00<000000?ooo`3oool0=P3oool2
000000H0oooo00<000000?ooo`3oool0SP3oool004d0oooo00<000000?ooo`3oool0=P3oool01000
0000oooo0?ooo`0000050?ooo`030000003oool0oooo08h0oooo001=0?ooo`030000003oool0oooo
03H0oooo00@000000?ooo`3oool000001@3oool3000008h0oooo001=0?ooo`030000003oool0oooo
03L0oooo0P0000060?ooo`030000003oool0oooo08h0oooo001=0?ooo`030000003oool0oooo03H0
oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`2>0?ooo`00C03oool00`000000
oooo0?ooo`0h0?ooo`8000001P3oool00`000000oooo0?ooo`2>0?ooo`00C03oool00`000000oooo
0?ooo`100?ooo`030000003oool0oooo08h0oooo001<0?ooo`030000003oool0oooo0400oooo00<0
00000?ooo`3oool0SP3oool004`0oooo00<000000?ooo`3oool0@03oool2000008l0oooo001<0?oo
o`030000003oool0oooo0400oooo00<000000?ooo`3oool0SP3oool004/0oooo00<000000?ooo`3o
ool0@@3oool00`000000oooo0?ooo`2>0?ooo`00B`3oool00`000000oooo0?ooo`110?ooo`030000
003oool0oooo08h0oooo001;0?ooo`030000003oool0oooo0440oooo00<000000?ooo`3oool0SP3o
ool004/0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`2>0?ooo`00B`3oool00`00
0000oooo0?ooo`110?ooo`800000S`3oool004X0oooo00<000000?ooo`3oool0@P3oool00`000000
oooo0?ooo`2>0?ooo`00BP3oool00`000000oooo0?ooo`120?ooo`030000003oool0oooo08h0oooo
001:0?ooo`030000003oool0oooo0480oooo00<000000?ooo`3oool0SP3oool004X0oooo00<00000
0?ooo`3oool0@P3oool00`000000oooo0?ooo`2>0?ooo`00BP3oool00`000000oooo0?ooo`120?oo
o`800000S`3oool004X0oooo00<000000?ooo`3oool0@P3oool00`000000oooo0?ooo`2>0?ooo`00
B@3oool00`000000oooo0?ooo`130?ooo`030000003oool0oooo08h0oooo00190?ooo`030000003o
ool0oooo04<0oooo00<000000?ooo`3oool0SP3oool004T0oooo00<000000?ooo`3oool0=03oool5
00000080oooo0P0000060?ooo`030000003oool0oooo08h0oooo00190?ooo`030000003oool0oooo
03H0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0SP3oool004T0oooo00<000000?ooo`3oool0=P3oool01@000000oooo0?ooo`3oool0
00000080oooo00<000000?ooo`3oool00`3oool3000008h0oooo00180?ooo`030000003oool0oooo
03L0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0SP3oool004P0oooo00<000000?ooo`3oool0=`3oool01@000000oooo0?ooo`3oool0
00000080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`2>0?ooo`00B03oool00`00
0000oooo0?ooo`0f0?ooo`800000103oool2000000H0oooo00<000000?ooo`3oool0SP3oool00?l0
oooo8@3oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-3.1933, -5.31912, 0.022253, \
0.0888384}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[\(h'\)[x] \[Equal] 0, x]\)], "Input"],

Cell[BoxData[
    \({{x \[Rule] 1\/9\ \((1 - \@37)\)}, {x \[Rule] 
          1\/9\ \((1 + \@37)\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(minimum = 
      ListPlot[{{1\/9\ \((1 - \@37)\), h[1\/9\ \((1 - \@37)\)]}}, 
        PlotStyle \[Rule] \ {Hue[0.67], \ \ AbsolutePointSize[
              7]}]\)\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.97619 0.843186 0.0147151 0.490249 [
[.133 .00222 -6 -9 ]
[.133 .00222 6 0 ]
[.30164 .00222 -12 -9 ]
[.30164 .00222 12 0 ]
[.47028 .00222 -12 -9 ]
[.47028 .00222 12 0 ]
[.63892 .00222 -12 -9 ]
[.63892 .00222 12 0 ]
[.80755 .00222 -12 -9 ]
[.80755 .00222 12 0 ]
[.96369 .11276 -18 -4.5 ]
[.96369 .11276 0 4.5 ]
[.96369 .21081 -18 -4.5 ]
[.96369 .21081 0 4.5 ]
[.96369 .30886 -18 -4.5 ]
[.96369 .30886 0 4.5 ]
[.96369 .40691 -18 -4.5 ]
[.96369 .40691 0 4.5 ]
[.96369 .50496 -6 -4.5 ]
[.96369 .50496 0 4.5 ]
[.96369 .60301 -18 -4.5 ]
[.96369 .60301 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.133 .01472 m
.133 .02097 L
s
[(-1)] .133 .00222 0 1 Mshowa
.30164 .01472 m
.30164 .02097 L
s
[(-0.8)] .30164 .00222 0 1 Mshowa
.47028 .01472 m
.47028 .02097 L
s
[(-0.6)] .47028 .00222 0 1 Mshowa
.63892 .01472 m
.63892 .02097 L
s
[(-0.4)] .63892 .00222 0 1 Mshowa
.80755 .01472 m
.80755 .02097 L
s
[(-0.2)] .80755 .00222 0 1 Mshowa
.125 Mabswid
.17516 .01472 m
.17516 .01847 L
s
.21732 .01472 m
.21732 .01847 L
s
.25948 .01472 m
.25948 .01847 L
s
.3438 .01472 m
.3438 .01847 L
s
.38596 .01472 m
.38596 .01847 L
s
.42812 .01472 m
.42812 .01847 L
s
.51244 .01472 m
.51244 .01847 L
s
.5546 .01472 m
.5546 .01847 L
s
.59676 .01472 m
.59676 .01847 L
s
.68108 .01472 m
.68108 .01847 L
s
.72323 .01472 m
.72323 .01847 L
s
.76539 .01472 m
.76539 .01847 L
s
.84971 .01472 m
.84971 .01847 L
s
.89187 .01472 m
.89187 .01847 L
s
.93403 .01472 m
.93403 .01847 L
s
.09085 .01472 m
.09085 .01847 L
s
.04869 .01472 m
.04869 .01847 L
s
.00653 .01472 m
.00653 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.97619 .11276 m
.98244 .11276 L
s
[(0.2)] .96369 .11276 1 0 Mshowa
.97619 .21081 m
.98244 .21081 L
s
[(0.4)] .96369 .21081 1 0 Mshowa
.97619 .30886 m
.98244 .30886 L
s
[(0.6)] .96369 .30886 1 0 Mshowa
.97619 .40691 m
.98244 .40691 L
s
[(0.8)] .96369 .40691 1 0 Mshowa
.97619 .50496 m
.98244 .50496 L
s
[(1)] .96369 .50496 1 0 Mshowa
.97619 .60301 m
.98244 .60301 L
s
[(1.2)] .96369 .60301 1 0 Mshowa
.125 Mabswid
.97619 .03923 m
.97994 .03923 L
s
.97619 .06374 m
.97994 .06374 L
s
.97619 .08825 m
.97994 .08825 L
s
.97619 .13728 m
.97994 .13728 L
s
.97619 .16179 m
.97994 .16179 L
s
.97619 .1863 m
.97994 .1863 L
s
.97619 .23533 m
.97994 .23533 L
s
.97619 .25984 m
.97994 .25984 L
s
.97619 .28435 m
.97994 .28435 L
s
.97619 .33338 m
.97994 .33338 L
s
.97619 .35789 m
.97994 .35789 L
s
.97619 .3824 m
.97994 .3824 L
s
.97619 .43143 m
.97994 .43143 L
s
.97619 .45594 m
.97994 .45594 L
s
.97619 .48045 m
.97994 .48045 L
s
.97619 .52948 m
.97994 .52948 L
s
.97619 .55399 m
.97994 .55399 L
s
.97619 .5785 m
.97994 .5785 L
s
.25 Mabswid
.97619 0 m
.97619 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.02 0 1 r
7 Mabswid
.5 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00;03oool5000002@0oooo0P0000040?ooo`800000103oool200000200oooo0P0000040?oo
o`8000000`3oool300000200oooo0P0000040?ooo`8000001@3oool3000001h0oooo0P0000040?oo
o`8000000`3oool400000380oooo000^0?ooo`030000003oool0oooo02<0oooo00@000000?ooo`3o
ool00000203oool010000000oooo0?ooo`00000N0?ooo`040000003oool0oooo000000P0oooo00@0
00000?ooo`3oool000007P3oool010000000oooo0?ooo`00000;0?ooo`030000003oool0oooo01`0
oooo00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`0c0?ooo`00;P3oool00`000000
oooo0?ooo`0S0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000007P3oool0
10000000oooo0?ooo`0000080?ooo`040000003oool0oooo000001h0oooo00@000000?ooo`3oool0
0000203oool5000001d0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`0b0?oo
o`009P3oool4000000@0oooo00<000000?ooo`3oool07@3oool400000080oooo00@000000?ooo`3o
ool000002@3oool2000001T0oooo100000020?ooo`040000003oool0oooo000000P0oooo0`00000I
0?ooo`@000000P3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000001P0oooo
100000020?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool0<@3oool002h0oooo
00<000000?ooo`3oool08`3oool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo0000
01h0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`0N0?ooo`040000003oool0
oooo000000T0oooo00<000000?ooo`0000007P3oool010000000oooo0?ooo`0000080?ooo`040000
003oool0oooo00000380oooo000]0?ooo`8000009P3oool2000000X0oooo0P00000P0?ooo`800000
2P3oool3000001l0oooo0P00000;0?ooo`8000007`3oool2000000X0oooo0P00000c0?ooo`00o`3o
oolQ0?ooo`00o`3ooolB0?ooo`030000003oool0oooo00`0oooo003o0?oooa80oooo00<000000?oo
o`3oool0303oool00?l0oooo4P3oool00`000000oooo0?ooo`0<0?ooo`00o`3ooolB0?ooo`030000
003oool0oooo00`0oooo00070?ooool000004P0000080?ooo`002@3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0303oool002/0oooo00<000000?oo
o`3oool0:`3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo02/0oooo00<000000?oo
o`3oool0:`3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo00`0oooo003o0?oooa80
oooo00<000000?ooo`3oool0303oool00?l0oooo4P3oool00`000000oooo0?ooo`0<0?ooo`00o`3o
oolB0?ooo`030000003oool0oooo00`0oooo003o0?oooa80oooo00<000000?ooo`3oool0303oool0
0?l0oooo4P3oool2000000d0oooo003o0?oooa80oooo00<000000?ooo`3oool0303oool00?l0oooo
4P3oool00`000000oooo0?ooo`0<0?ooo`00o`3ooolB0?ooo`030000003oool0oooo00`0oooo003o
0?oooa80oooo00<000000?ooo`3oool0303oool00?l0oooo4P3oool00`000000oooo0?ooo`0<0?oo
o`00o`3ooolB0?ooo`8000003@3oool00?l0oooo4P3oool00`000000oooo0?ooo`0<0?ooo`00o`3o
oolB0?ooo`030000003oool0oooo00`0oooo003o0?oooa80oooo00<000000?ooo`3oool0303oool0
0?l0oooo4P3oool00`000000oooo0?ooo`0<0?ooo`00o`3ooolB0?ooo`030000003oool0oooo00`0
oooo003o0?oooa80oooo00<000000?ooo`3oool0303oool00?l0oooo4P3oool2000000d0oooo003o
0?oooa80oooo00<000000?ooo`3oool0303oool00?l0oooo4P3oool00`000000oooo0?ooo`0<0?oo
o`00o`3ooolB0?ooo`030000003oool0oooo00`0oooo003o0?oooa80oooo00<000000?ooo`3oool0
303oool00?d0oooo0P0000040?ooo`8000000`3oool4000000D0oooo00<000000?ooo`3oool0303o
ool00?`0oooo00@000000?ooo`3oool00000203oool00`000000oooo0?ooo`060?ooo`030000003o
ool0oooo00`0oooo003l0?ooo`040000003oool0oooo000000T0oooo00<000000?ooo`3oool01@3o
ool2000000d0oooo003l0?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool0103o
ool00`000000oooo0?ooo`0<0?ooo`00o03oool010000000oooo0?ooo`0000080?ooo`040000003o
ool0oooo000000D0oooo00<000000?ooo`3oool0303oool00?d0oooo0P00000:0?ooo`8000001P3o
ool00`000000oooo0?ooo`0<0?ooo`00o`3ooolB0?ooo`030000003oool0oooo00`0oooo003o0?oo
oa80oooo00<000000?ooo`3oool0303oool00?l0oooo4P3oool2000000d0oooo003o0?oooa80oooo
00<000000?ooo`3oool0303oool00?l0oooo4P3oool00`000000oooo0?ooo`0<0?ooo`00o`3ooolB
0?ooo`030000003oool0oooo00`0oooo003o0?oooa80oooo00<000000?ooo`3oool0303oool00?l0
oooo4P3oool00`000000oooo0?ooo`0<0?ooo`00o`3ooolB0?ooo`030000003oool0oooo00`0oooo
003o0?oooa80oooo0P00000=0?ooo`00o`3ooolB0?ooo`030000003oool0oooo00`0oooo003o0?oo
oa80oooo00<000000?ooo`3oool0303oool00?l0oooo4P3oool00`000000oooo0?ooo`0<0?ooo`00
o`3ooolB0?ooo`030000003oool0oooo00`0oooo003o0?oooa80oooo00<000000?ooo`3oool0303o
ool00?l0oooo4P3oool00`000000oooo0?ooo`0<0?ooo`00o`3ooolB0?ooo`8000003@3oool00?l0
oooo4P3oool00`000000oooo0?ooo`0<0?ooo`00o`3ooolB0?ooo`030000003oool0oooo00`0oooo
003o0?oooa80oooo00<000000?ooo`3oool0303oool00?d0oooo0P0000040?ooo`8000001@3oool3
000000@0oooo00<000000?ooo`3oool0303oool00?`0oooo00@000000?ooo`3oool000002`3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo00`0oooo003l0?ooo`040000003oool0oooo
000000P0oooo1@0000040?ooo`8000003@3oool00?`0oooo00@000000?ooo`3oool00000203oool0
10000000oooo0?ooo`0000050?ooo`030000003oool0oooo00`0oooo003l0?ooo`040000003oool0
oooo000000T0oooo00<000000?ooo`0000001@3oool00`000000oooo0?ooo`0<0?ooo`00o@3oool2
000000/0oooo0P0000050?ooo`030000003oool0oooo00`0oooo003o0?oooa80oooo00<000000?oo
o`3oool0303oool00?l0oooo4P3oool00`000000oooo0?ooo`0<0?ooo`00o`3ooolB0?ooo`030000
003oool0oooo00`0oooo003o0?oooa80oooo0P00000=0?ooo`00o`3ooolB0?ooo`030000003oool0
oooo00`0oooo003o0?oooa80oooo00<000000?ooo`3oool0303oool00?l0oooo4P3oool00`000000
oooo0?ooo`0<0?ooo`00o`3ooolB0?ooo`030000003oool0oooo00`0oooo003o0?oooa80oooo00<0
00000?ooo`3oool0303oool00?l0oooo4P3oool00`000000oooo0?ooo`0<0?ooo`00o`3ooolB0?oo
o`8000003@3oool00?l0oooo4P3oool00`000000oooo0?ooo`0<0?ooo`00o`3ooolB0?ooo`030000
003oool0oooo00`0oooo003o0?oooa80oooo00<000000?ooo`3oool0303oool00?l0oooo4P3oool0
0`000000oooo0?ooo`0<0?ooo`00o`3ooolB0?ooo`030000003oool0oooo00`0oooo003o0?oooa80
oooo0P00000=0?ooo`00o`3ooolB0?ooo`030000003oool0oooo00`0oooo003o0?oooa80oooo00<0
00000?ooo`3oool0303oool00?l0oooo4P3oool00`000000oooo0?ooo`0<0?ooo`00SP3oool300D0
oh00oooo00<000000?ooo`3oool0303oool008d0oooo1@050?m[0?ooo`800000103oool2000000<0
oooo0`0000060?ooo`030000003oool0oooo00`0oooo002<0?ooo`L01@3oJ@3oool010000000oooo
0?ooo`0000080?ooo`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0303oool008`0
oooo1`050?mY0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000001@3oool2
000000d0oooo002<0?ooo`L01@3oJ@3oool010000000oooo0?ooo`0000080?ooo`<000001P3oool0
0`000000oooo0?ooo`0<0?ooo`00S@3oool500D0ofX0oooo00@000000?ooo`3oool000002@3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00`0oooo002>0?ooo`<01@3oK03oool20000
00X0oooo0`0000050?ooo`030000003oool0oooo00`0oooo003o0?oooa80oooo00<000000?ooo`3o
ool0303oool00?l0oooo4P3oool00`000000oooo0?ooo`0<0?ooo`00o`3ooolB0?ooo`030000003o
ool0oooo00`0oooo003o0?oooa80oooo0P00000=0?ooo`00o`3ooolB0?ooo`030000003oool0oooo
00`0oooo003o0?oooa80oooo00<000000?ooo`3oool0303oool00?l0oooo4P3oool00`000000oooo
0?ooo`0<0?ooo`00o`3ooolB0?ooo`030000003oool0oooo00`0oooo003o0?oooa80oooo00<00000
0?ooo`3oool0303oool00?l0oooo4P3oool2000000d0oooo003o0?oooa80oooo00<000000?ooo`3o
ool0303oool00?l0oooo4P3oool00`000000oooo0?ooo`0<0?ooo`00o`3ooolB0?ooo`030000003o
ool0oooo00`0oooo003o0?oooa80oooo00<000000?ooo`3oool0303oool00?l0oooo4P3oool00`00
0000oooo0?ooo`0<0?ooo`00o`3ooolB0?ooo`030000003oool0oooo00`0oooo003o0?oooa80oooo
0P00000=0?ooo`00o`3ooolB0?ooo`030000003oool0oooo00`0oooo003o0?oooa80oooo00<00000
0?ooo`3oool0303oool00?l0oooo4P3oool00`000000oooo0?ooo`0<0?ooo`00o`3ooolB0?ooo`03
0000003oool0oooo00`0oooo003m0?ooo`800000103oool2000000@0oooo0P0000060?ooo`030000
003oool0oooo00`0oooo003l0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool0
00001@3oool00`000000oooo0?ooo`0<0?ooo`00o03oool010000000oooo0?ooo`0000080?ooo`04
0000003oool0oooo000000D0oooo0P00000=0?ooo`00o03oool010000000oooo0?ooo`0000090?oo
o`8000001P3oool00`000000oooo0?ooo`0<0?ooo`00o03oool010000000oooo0?ooo`0000080?oo
o`040000003oool0oooo000000D0oooo00<000000?ooo`3oool0303oool00?d0oooo0P00000:0?oo
o`8000001P3oool00`000000oooo0?ooo`0<0?ooo`00o`3ooolB0?ooo`030000003oool0oooo00`0
oooo003o0?oooa80oooo00<000000?ooo`3oool0303oool00?l0oooo4P3oool2000000d0oooo003o
0?oooa80oooo00<000000?ooo`3oool0303oool00?l0oooo4P3oool00`000000oooo0?ooo`0<0?oo
o`00o`3ooolB0?ooo`030000003oool0oooo00`0oooo003o0?oooa80oooo00<000000?ooo`3oool0
303oool00?l0oooo4P3oool00`000000oooo0?ooo`0<0?ooo`00o`3ooolB0?ooo`030000003oool0
oooo00`0oooo003o0?oooa80oooo0P00000=0?ooo`00o`3ooolB0?ooo`030000003oool0oooo00`0
oooo003o0?oooa80oooo00<000000?ooo`3oool0303oool00?l0oooo4P3oool00`000000oooo0?oo
o`0<0?ooo`00o`3ooolB0?ooo`030000003oool0oooo00`0oooo003o0?oooa80oooo00<000000?oo
o`3oool0303oool00?l0oooo4P3oool00`000000oooo0?ooo`0<0?ooo`00o`3ooolB0?ooo`800000
3@3oool00?l0oooo4P3oool00`000000oooo0?ooo`0<0?ooo`00o`3ooolB0?ooo`030000003oool0
oooo00`0oooo003o0?oooa80oooo00<000000?ooo`3oool0303oool00?l0oooo2@3oool5000000@0
oooo00<000000?ooo`3oool0303oool00?l0oooo2`3oool00`000000oooo0?ooo`040?ooo`030000
003oool0oooo00`0oooo003o0?ooo`/0oooo00<000000?ooo`3oool0103oool2000000d0oooo003o
0?ooo`/0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0<0?ooo`00o`3oool;0?oo
o`030000003oool0oooo00@0oooo00<000000?ooo`3oool0303oool00?l0oooo2P3oool2000000H0
oooo00<000000?ooo`3oool0303oool00?l0oooo4P3oool00`000000oooo0?ooo`0<0?ooo`00o`3o
oolB0?ooo`030000003oool0oooo00`0oooo003o0?oooa80oooo00<000000?ooo`3oool0303oool0
0?l0oooo4P3oool2000000d0oooo003o0?oooa80oooo00<000000?ooo`3oool0303oool00?l0oooo
4P3oool00`000000oooo0?ooo`0<0?ooo`00o`3ooolB0?ooo`030000003oool0oooo00`0oooo003o
0?oooa80oooo00<000000?ooo`3oool0303oool00?l0oooo4P3oool00`000000oooo0?ooo`0<0?oo
o`00o`3ooolB0?ooo`030000003oool0oooo00`0oooo003o0?oooa80oooo0P00000=0?ooo`00o`3o
oolB0?ooo`030000003oool0oooo00`0oooo003o0?oooa80oooo00<000000?ooo`3oool0303oool0
0?l0oooo4P3oool00`000000oooo0?ooo`0<0?ooo`00o`3ooolB0?ooo`030000003oool0oooo00`0
oooo003o0?oooa80oooo00<000000?ooo`3oool0303oool00?l0oooo4P3oool2000000d0oooo003o
0?oooa80oooo00<000000?ooo`3oool0303oool00?l0oooo4P3oool00`000000oooo0?ooo`0<0?oo
o`00o`3ooolB0?ooo`030000003oool0oooo00`0oooo003o0?oooa80oooo00<000000?ooo`3oool0
303oool00?`0oooo1@0000020?ooo`8000000`3oool4000000D0oooo00<000000?ooo`3oool0303o
ool00?h0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo00`0oooo003n0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool20000
00d0oooo003n0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`0<0?ooo`00oP3oool00`000000oooo0?ooo`070?ooo`040000003oool0oooo000000D0
oooo00<000000?ooo`3oool0303oool00?d0oooo0P00000:0?ooo`8000001P3oool00`000000oooo
0?ooo`0<0?ooo`00o`3ooolB0?ooo`030000003oool0oooo00`0oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-1.19036, -0.0929774, \
0.00435965, 0.00749823}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(maximum = 
      ListPlot[{{1\/9\ \((1 + \@37)\), h[1\/9\ \((1 + \@37)\)]}}, 
        PlotStyle \[Rule] \ {Hue[0.67], \ \ AbsolutePointSize[
              7]}]\)\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.605091 0.0147151 0.0683622 [
[.17508 .00222 -12 -9 ]
[.17508 .00222 12 0 ]
[.32635 .00222 -9 -9 ]
[.32635 .00222 9 0 ]
[.47763 .00222 -12 -9 ]
[.47763 .00222 12 0 ]
[.6289 .00222 -3 -9 ]
[.6289 .00222 3 0 ]
[.78017 .00222 -12 -9 ]
[.78017 .00222 12 0 ]
[.93145 .00222 -9 -9 ]
[.93145 .00222 9 0 ]
[.01131 .15144 -6 -4.5 ]
[.01131 .15144 0 4.5 ]
[.01131 .28816 -6 -4.5 ]
[.01131 .28816 0 4.5 ]
[.01131 .42489 -6 -4.5 ]
[.01131 .42489 0 4.5 ]
[.01131 .56161 -6 -4.5 ]
[.01131 .56161 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.17508 .01472 m
.17508 .02097 L
s
[(0.25)] .17508 .00222 0 1 Mshowa
.32635 .01472 m
.32635 .02097 L
s
[(0.5)] .32635 .00222 0 1 Mshowa
.47763 .01472 m
.47763 .02097 L
s
[(0.75)] .47763 .00222 0 1 Mshowa
.6289 .01472 m
.6289 .02097 L
s
[(1)] .6289 .00222 0 1 Mshowa
.78017 .01472 m
.78017 .02097 L
s
[(1.25)] .78017 .00222 0 1 Mshowa
.93145 .01472 m
.93145 .02097 L
s
[(1.5)] .93145 .00222 0 1 Mshowa
.125 Mabswid
.05406 .01472 m
.05406 .01847 L
s
.08432 .01472 m
.08432 .01847 L
s
.11457 .01472 m
.11457 .01847 L
s
.14483 .01472 m
.14483 .01847 L
s
.20534 .01472 m
.20534 .01847 L
s
.23559 .01472 m
.23559 .01847 L
s
.26585 .01472 m
.26585 .01847 L
s
.2961 .01472 m
.2961 .01847 L
s
.35661 .01472 m
.35661 .01847 L
s
.38686 .01472 m
.38686 .01847 L
s
.41712 .01472 m
.41712 .01847 L
s
.44737 .01472 m
.44737 .01847 L
s
.50788 .01472 m
.50788 .01847 L
s
.53814 .01472 m
.53814 .01847 L
s
.56839 .01472 m
.56839 .01847 L
s
.59865 .01472 m
.59865 .01847 L
s
.65915 .01472 m
.65915 .01847 L
s
.68941 .01472 m
.68941 .01847 L
s
.71966 .01472 m
.71966 .01847 L
s
.74992 .01472 m
.74992 .01847 L
s
.81043 .01472 m
.81043 .01847 L
s
.84068 .01472 m
.84068 .01847 L
s
.87094 .01472 m
.87094 .01847 L
s
.90119 .01472 m
.90119 .01847 L
s
.9617 .01472 m
.9617 .01847 L
s
.99195 .01472 m
.99195 .01847 L
s
.25 Mabswid
0 .01472 m
1 .01472 L
s
.02381 .15144 m
.03006 .15144 L
s
[(2)] .01131 .15144 1 0 Mshowa
.02381 .28816 m
.03006 .28816 L
s
[(4)] .01131 .28816 1 0 Mshowa
.02381 .42489 m
.03006 .42489 L
s
[(6)] .01131 .42489 1 0 Mshowa
.02381 .56161 m
.03006 .56161 L
s
[(8)] .01131 .56161 1 0 Mshowa
.125 Mabswid
.02381 .0489 m
.02756 .0489 L
s
.02381 .08308 m
.02756 .08308 L
s
.02381 .11726 m
.02756 .11726 L
s
.02381 .18562 m
.02756 .18562 L
s
.02381 .2198 m
.02756 .2198 L
s
.02381 .25398 m
.02756 .25398 L
s
.02381 .32234 m
.02756 .32234 L
s
.02381 .35653 m
.02756 .35653 L
s
.02381 .39071 m
.02756 .39071 L
s
.02381 .45907 m
.02756 .45907 L
s
.02381 .49325 m
.02756 .49325 L
s
.02381 .52743 m
.02756 .52743 L
s
.02381 .59579 m
.02756 .59579 L
s
.25 Mabswid
.02381 0 m
.02381 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.02 0 1 r
7 Mabswid
.5 .30902 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00;P3oool2000000@0oooo0P0000030?ooo`@000000`3oool2000001P0oooo0P0000040?oo
o`800000103oool2000001P0oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`020?oo
o`8000007P3oool5000001/0oooo1@0000020?ooo`8000000`3oool4000000<0oooo0P00000G0?oo
o`D000000P3oool2000000@0oooo0P00000C0?ooo`00;@3oool010000000oooo0?ooo`0000080?oo
o`030000003oool0oooo00<0oooo00@000000?ooo`3oool000005P3oool010000000oooo0?ooo`00
00080?ooo`040000003oool0oooo000001H0oooo00@000000?ooo`3oool000002P3oool01@000000
oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`0M0?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool00`3oool010000000oooo0?ooo`00000H
0?ooo`030000003oool0oooo00L0oooo00@000000?ooo`3oool000004P3oool002d0oooo00@00000
0?ooo`3oool000002@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01@0oooo00@0
00000?ooo`3oool000002`3oool00`000000oooo0?ooo`0D0?ooo`040000003oool0oooo000000X0
oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0M0?ooo`030000003oool0oooo01d0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01H0
oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0@0?ooo`00;@3oool010000000oooo
0?ooo`00000:0?ooo`030000003oool0oooo0080oooo0P00000G0?ooo`040000003oool0oooo0000
00T0oooo0P00000G0?ooo`040000003oool0oooo000000/0oooo00@000000?ooo`3oool0oooo0P00
000P0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`020?ooo`8000006@3oool00`000000oooo0?ooo`080?ooo`8000004`3oool002d0oooo00@00000
0?ooo`3oool00000203oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo01H0oooo
00@000000?ooo`3oool000002@3oool00`000000oooo0?ooo`0F0?ooo`040000003oool0oooo0000
00P0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0
oooo01d0oooo00<000000?ooo`3oool01`3oool010000000oooo0?ooo`0000030?ooo`030000003o
ool0oooo01P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`0B0?ooo`00;P3oool2
000000X0oooo0P0000040?ooo`<000005`3oool2000000X0oooo0`00000G0?ooo`8000002@3oool4
000000<0oooo0`00000N0?ooo`8000007P3oool2000000X0oooo0P0000040?ooo`<000005`3oool2
000000X0oooo0`00000B0?ooo`00o`3ooolQ0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`l0
oooo000?0?ooo`030000003oool0oooo0?l0oooo3`3oool000l0oooo00<000000?ooo`3oool0o`3o
ool?0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo00080?ooool000004`0000060?oo
o`003`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool01P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3o
ool01P3oool000l0oooo00<000000?ooo`3oool09P3oool00`000000oooo0?ooo`0V0?ooo`030000
003oool0oooo02H0oooo00<000000?ooo`3oool09`3oool00`000000oooo0?ooo`0V0?ooo`030000
003oool0oooo02H0oooo00<000000?ooo`3oool05`3oool000l0oooo00<000000?ooo`3oool0o`3o
ool?0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000003oool0oooo
0?l0oooo3`3oool000l0oooo00<000000?ooo`3oool0o`3oool?0?ooo`003`3oool00`000000oooo
0?ooo`3o0?ooo`l0oooo000?0?ooo`030000003oool0oooo0?l0oooo3`3oool000l0oooo0P00003o
0?oooa00oooo000?0?ooo`030000003oool0oooo0?l0oooo3`3oool000l0oooo00<000000?ooo`3o
ool0o`3oool?0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000003o
ool0oooo0?l0oooo3`3oool000l0oooo00<000000?ooo`3oool0o`3oool?0?ooo`003`3oool00`00
0000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000003oool0oooo0?l0oooo3`3oool000l0oooo
00<000000?ooo`3oool0o`3oool?0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000?
0?ooo`800000o`3oool@0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`03
0000003oool0oooo0?l0oooo3`3oool000l0oooo00<000000?ooo`3oool0o`3oool?0?ooo`003`3o
ool00`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000003oool0oooo0?l0oooo3`3oool0
00l0oooo00<000000?ooo`3oool0o`3oool?0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`l0
oooo000?0?ooo`030000003oool0oooo0?l0oooo3`3oool000l0oooo0P00003o0?oooa00oooo000?
0?ooo`030000003oool0oooo0?l0oooo3`3oool000l0oooo00<000000?ooo`3oool0o`3oool?0?oo
o`003`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000003oool0oooo0?l0oooo
3`3oool000l0oooo00<000000?ooo`3oool0o`3oool?0?ooo`003`3oool00`000000oooo0?ooo`3o
0?ooo`l0oooo00060?ooo`@000001@3oool00`000000oooo0?ooo`3o0?ooo`l0oooo00060?ooo`03
0000003oool0oooo00H0oooo00<000000?ooo`3oool0o`3oool?0?ooo`001`3oool00`000000oooo
0?ooo`050?ooo`800000o`3oool@0?ooo`00203oool00`000000oooo0?ooo`040?ooo`030000003o
ool0oooo0?l0oooo3`3oool000H0oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?oo
o`3o0?ooo`l0oooo00070?ooo`8000001P3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000?0?oo
o`030000003oool0oooo0?l0oooo3`3oool000l0oooo00<000000?ooo`3oool0o`3oool?0?ooo`00
3`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000003oool0oooo0?l0oooo3`3o
ool000l0oooo00<000000?ooo`3oool0o`3oool?0?ooo`003`3oool00`000000oooo0?ooo`3o0?oo
o`l0oooo000?0?ooo`800000o`3oool@0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo
000?0?ooo`030000003oool0oooo0?l0oooo3`3oool000l0oooo00<000000?ooo`3oool0o`3oool?
0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000003oool0oooo0?l0
oooo3`3oool000l0oooo00<000000?ooo`3oool0o`3oool?0?ooo`003`3oool00`000000oooo0?oo
o`3o0?ooo`l0oooo000?0?ooo`030000003oool0oooo0?l0oooo3`3oool000l0oooo0P00003o0?oo
oa00oooo000?0?ooo`030000003oool0oooo0?l0oooo3`3oool000l0oooo00<000000?ooo`3oool0
o`3oool?0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000003oool0
oooo0?l0oooo3`3oool000l0oooo00<000000?ooo`3oool0o`3oool?0?ooo`003`3oool00`000000
oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000003oool0oooo0?l0oooo3`3oool000l0oooo00<0
00000?ooo`3oool0o`3oool?0?ooo`003`3oool200000?l0oooo403oool000l0oooo00<000000?oo
o`3oool0o`3oool?0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000
003oool0oooo0?l0oooo3`3oool000l0oooo00<000000?ooo`3oool0o`3oool?0?ooo`003`3oool0
0`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000003oool0oooo0?l0oooo3`3oool000l0
oooo00<000000?ooo`3oool0o`3oool?0?ooo`00203oool3000000@0oooo00<000000?ooo`3oool0
o`3oool?0?ooo`002@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0?l0oooo3`3o
ool000H0oooo1@0000040?ooo`800000o`3oool@0?ooo`001P3oool010000000oooo0?ooo`000005
0?ooo`030000003oool0oooo0?l0oooo3`3oool000L0oooo00<000000?ooo`0000001@3oool00`00
0000oooo0?ooo`1m0?ooo`<01@3oSP3oool000P0oooo0P0000050?ooo`030000003oool0oooo07`0
oooo1@050?n=0?ooo`003`3oool00`000000oooo0?ooo`1k0?ooo`L01@3oS03oool000l0oooo00<0
00000?ooo`3oool0N`3oool700D0oh`0oooo000?0?ooo`030000003oool0oooo07/0oooo1`050?n<
0?ooo`003`3oool00`000000oooo0?ooo`1l0?ooo`D01@3oS@3oool000l0oooo00<000000?ooo`3o
ool0O@3oool300D0ohh0oooo000?0?ooo`800000o`3oool@0?ooo`003`3oool00`000000oooo0?oo
o`3o0?ooo`l0oooo000?0?ooo`030000003oool0oooo0?l0oooo3`3oool000l0oooo00<000000?oo
o`3oool0o`3oool?0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000
003oool0oooo0?l0oooo3`3oool000l0oooo00<000000?ooo`3oool0o`3oool?0?ooo`003`3oool0
0`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000003oool0oooo0?l0oooo3`3oool000l0
oooo0P00003o0?oooa00oooo000?0?ooo`030000003oool0oooo0?l0oooo3`3oool000l0oooo00<0
00000?ooo`3oool0o`3oool?0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000?0?oo
o`030000003oool0oooo0?l0oooo3`3oool000l0oooo00<000000?ooo`3oool0o`3oool?0?ooo`00
3`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000003oool0oooo0?l0oooo3`3o
ool000l0oooo00<000000?ooo`3oool0o`3oool?0?ooo`003`3oool00`000000oooo0?ooo`3o0?oo
o`l0oooo000?0?ooo`800000o`3oool@0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo
000?0?ooo`030000003oool0oooo0?l0oooo3`3oool000l0oooo00<000000?ooo`3oool0o`3oool?
0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000003oool0oooo0?l0
oooo3`3oool000l0oooo00<000000?ooo`3oool0o`3oool?0?ooo`001P3oool3000000H0oooo00<0
00000?ooo`3oool0o`3oool?0?ooo`001P3oool010000000oooo0?ooo`0000050?ooo`030000003o
ool0oooo0?l0oooo3`3oool000H0oooo00@000000?ooo`3oool000001@3oool200000?l0oooo403o
ool000H0oooo0`0000060?ooo`030000003oool0oooo0?l0oooo3`3oool000L0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`3o0?ooo`l0oooo00070?ooo`<000001@3oool00`000000
oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000003oool0oooo0?l0oooo3`3oool000l0oooo00<0
00000?ooo`3oool0o`3oool?0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000?0?oo
o`030000003oool0oooo0?l0oooo3`3oool000l0oooo00<000000?ooo`3oool0o`3oool?0?ooo`00
3`3oool200000?l0oooo403oool000l0oooo00<000000?ooo`3oool0o`3oool?0?ooo`003`3oool0
0`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000003oool0oooo0?l0oooo3`3oool000l0
oooo00<000000?ooo`3oool0o`3oool?0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo
000?0?ooo`030000003oool0oooo0?l0oooo3`3oool000l0oooo00<000000?ooo`3oool0o`3oool?
0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`800000o`3oool@0?ooo`00
3`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000003oool0oooo0?l0oooo3`3o
ool000l0oooo00<000000?ooo`3oool0o`3oool?0?ooo`003`3oool00`000000oooo0?ooo`3o0?oo
o`l0oooo000?0?ooo`030000003oool0oooo0?l0oooo3`3oool000l0oooo00<000000?ooo`3oool0
o`3oool?0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000003oool0
oooo0?l0oooo3`3oool000l0oooo00<000000?ooo`3oool0o`3oool?0?ooo`003`3oool200000?l0
oooo403oool000l0oooo00<000000?ooo`3oool0o`3oool?0?ooo`003`3oool00`000000oooo0?oo
o`3o0?ooo`l0oooo000?0?ooo`030000003oool0oooo0?l0oooo3`3oool000l0oooo00<000000?oo
o`3oool0o`3oool?0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000
003oool0oooo0?l0oooo3`3oool000L0oooo0P0000060?ooo`030000003oool0oooo0?l0oooo3`3o
ool000H0oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`3o0?ooo`l0oooo0006
0?ooo`040000003oool0oooo000000D0oooo0P00003o0?oooa00oooo00070?ooo`8000001P3oool0
0`000000oooo0?ooo`3o0?ooo`l0oooo00060?ooo`040000003oool0oooo000000D0oooo00<00000
0?ooo`3oool0o`3oool?0?ooo`001`3oool2000000H0oooo00<000000?ooo`3oool0o`3oool?0?oo
o`003`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000003oool0oooo0?l0oooo
3`3oool000l0oooo00<000000?ooo`3oool0o`3oool?0?ooo`003`3oool00`000000oooo0?ooo`3o
0?ooo`l0oooo000?0?ooo`030000003oool0oooo0?l0oooo3`3oool000l0oooo0P00003o0?oooa00
oooo000?0?ooo`030000003oool0oooo0?l0oooo3`3oool000l0oooo00<000000?ooo`3oool0o`3o
ool?0?ooo`003`3oool00`000000oooo0?ooo`3o0?ooo`l0oooo000?0?ooo`030000003oool0oooo
0?l0oooo3`3oool000l0oooo00<000000?ooo`3oool0o`3oool?0?ooo`003`3oool00`000000oooo
0?ooo`3o0?ooo`l0oooo0000\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0914915, -0.665581, \
0.00606014, 0.0536398}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(extremwertPunkte = 
      Show[extremwertplot, \ minimum, \ maximum]\)\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
%%ImageSize: 600 370.82 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.15873 0.211498 0.0397533 [
[.02381 .199 -6 -9 ]
[.02381 .199 6 0 ]
[.18254 .199 -6 -9 ]
[.18254 .199 6 0 ]
[.34127 .199 -6 -9 ]
[.34127 .199 6 0 ]
[.65873 .199 -3 -9 ]
[.65873 .199 3 0 ]
[.81746 .199 -3 -9 ]
[.81746 .199 3 0 ]
[.97619 .199 -3 -9 ]
[.97619 .199 3 0 ]
[.4875 .05248 -12 -4.5 ]
[.4875 .05248 0 4.5 ]
[.4875 .13199 -12 -4.5 ]
[.4875 .13199 0 4.5 ]
[.4875 .291 -6 -4.5 ]
[.4875 .291 0 4.5 ]
[.4875 .37051 -6 -4.5 ]
[.4875 .37051 0 4.5 ]
[.4875 .45002 -6 -4.5 ]
[.4875 .45002 0 4.5 ]
[.4875 .52952 -6 -4.5 ]
[.4875 .52952 0 4.5 ]
[.4875 .60903 -12 -4.5 ]
[.4875 .60903 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .2115 m
.02381 .21775 L
s
[(-3)] .02381 .199 0 1 Mshowa
.18254 .2115 m
.18254 .21775 L
s
[(-2)] .18254 .199 0 1 Mshowa
.34127 .2115 m
.34127 .21775 L
s
[(-1)] .34127 .199 0 1 Mshowa
.65873 .2115 m
.65873 .21775 L
s
[(1)] .65873 .199 0 1 Mshowa
.81746 .2115 m
.81746 .21775 L
s
[(2)] .81746 .199 0 1 Mshowa
.97619 .2115 m
.97619 .21775 L
s
[(3)] .97619 .199 0 1 Mshowa
.125 Mabswid
.05556 .2115 m
.05556 .21525 L
s
.0873 .2115 m
.0873 .21525 L
s
.11905 .2115 m
.11905 .21525 L
s
.15079 .2115 m
.15079 .21525 L
s
.21429 .2115 m
.21429 .21525 L
s
.24603 .2115 m
.24603 .21525 L
s
.27778 .2115 m
.27778 .21525 L
s
.30952 .2115 m
.30952 .21525 L
s
.37302 .2115 m
.37302 .21525 L
s
.40476 .2115 m
.40476 .21525 L
s
.43651 .2115 m
.43651 .21525 L
s
.46825 .2115 m
.46825 .21525 L
s
.53175 .2115 m
.53175 .21525 L
s
.56349 .2115 m
.56349 .21525 L
s
.59524 .2115 m
.59524 .21525 L
s
.62698 .2115 m
.62698 .21525 L
s
.69048 .2115 m
.69048 .21525 L
s
.72222 .2115 m
.72222 .21525 L
s
.75397 .2115 m
.75397 .21525 L
s
.78571 .2115 m
.78571 .21525 L
s
.84921 .2115 m
.84921 .21525 L
s
.88095 .2115 m
.88095 .21525 L
s
.9127 .2115 m
.9127 .21525 L
s
.94444 .2115 m
.94444 .21525 L
s
.25 Mabswid
0 .2115 m
1 .2115 L
s
.5 .05248 m
.50625 .05248 L
s
[(-4)] .4875 .05248 1 0 Mshowa
.5 .13199 m
.50625 .13199 L
s
[(-2)] .4875 .13199 1 0 Mshowa
.5 .291 m
.50625 .291 L
s
[(2)] .4875 .291 1 0 Mshowa
.5 .37051 m
.50625 .37051 L
s
[(4)] .4875 .37051 1 0 Mshowa
.5 .45002 m
.50625 .45002 L
s
[(6)] .4875 .45002 1 0 Mshowa
.5 .52952 m
.50625 .52952 L
s
[(8)] .4875 .52952 1 0 Mshowa
.5 .60903 m
.50625 .60903 L
s
[(10)] .4875 .60903 1 0 Mshowa
.125 Mabswid
.5 .07236 m
.50375 .07236 L
s
.5 .09224 m
.50375 .09224 L
s
.5 .11211 m
.50375 .11211 L
s
.5 .15187 m
.50375 .15187 L
s
.5 .17174 m
.50375 .17174 L
s
.5 .19162 m
.50375 .19162 L
s
.5 .23137 m
.50375 .23137 L
s
.5 .25125 m
.50375 .25125 L
s
.5 .27113 m
.50375 .27113 L
s
.5 .31088 m
.50375 .31088 L
s
.5 .33076 m
.50375 .33076 L
s
.5 .35063 m
.50375 .35063 L
s
.5 .39039 m
.50375 .39039 L
s
.5 .41026 m
.50375 .41026 L
s
.5 .43014 m
.50375 .43014 L
s
.5 .46989 m
.50375 .46989 L
s
.5 .48977 m
.50375 .48977 L
s
.5 .50965 m
.50375 .50965 L
s
.5 .5494 m
.50375 .5494 L
s
.5 .56928 m
.50375 .56928 L
s
.5 .58915 m
.50375 .58915 L
s
.5 .03261 m
.50375 .03261 L
s
.5 .01273 m
.50375 .01273 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.24911 .61803 m
.26171 .54537 L
.28302 .45257 L
.30316 .3824 L
.32313 .32818 L
.34157 .29048 L
.36029 .26316 L
.37094 .2521 L
.38092 .24444 L
.38588 .24155 L
.3913 .23905 L
.39378 .23814 L
.39642 .23731 L
.39889 .23667 L
.40117 .2362 L
.40357 .23581 L
.40483 .23566 L
.40617 .23553 L
.40733 .23545 L
.40842 .2354 L
.40961 .23537 L
.41088 .23536 L
.41202 .23539 L
.41325 .23544 L
.41441 .23552 L
.41549 .23561 L
.41753 .23584 L
.41969 .23617 L
.42458 .23722 L
.42906 .23852 L
.43916 .24261 L
.44807 .24741 L
.45744 .25353 L
.49555 .28658 L
.53611 .32783 L
.55485 .34578 L
.57516 .36255 L
.58626 .37002 L
.5965 .37557 L
.60629 .3795 L
.61123 .38091 L
.61403 .38154 L
.61665 .382 L
.61791 .38218 L
.61924 .38233 L
.62039 .38244 L
.62163 .38253 L
.6224 .38258 L
.6231 .38261 L
.62377 .38262 L
Mistroke
.62448 .38264 L
.62571 .38263 L
.62641 .38262 L
.62706 .38259 L
.62835 .38252 L
.62956 .38243 L
.63065 .38232 L
.63183 .38217 L
.63449 .38173 L
.63694 .3812 L
.64122 .37996 L
.64594 .37812 L
.65086 .37566 L
.65548 .37282 L
.66534 .36499 L
.6757 .35398 L
.69422 .32662 L
.714 .28539 L
.73238 .2348 L
.77148 .08261 L
Mfstroke
.77148 .08261 m
.78726 0 L
s
.02 0 1 r
7 Mabswid
.41036 .23536 Mdot
.62492 .38264 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{600, 370.813},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40009H0001LR000`400?l00000o`00003oo`3oool/
0?ooo`030000003oool0oooo0?l0oooo:`3oool00?l0oooo;03oool00`000000oooo0?ooo`2Y0?oo
o`030000003oool0oooo07h0oooo003o0?ooob`0oooo00<000000?ooo`3oool0Z@3oool00`000000
oooo0?ooo`1n0?ooo`00o`3oool/0?ooo`030000003oool0oooo0:P0oooo00<000000?ooo`3oool0
O`3oool00?l0oooo;03oool00`000000oooo0?ooo`2X0?ooo`030000003oool0oooo07l0oooo003o
0?ooob`0oooo00<000000?ooo`3oool0Z03oool00`000000oooo0?ooo`1o0?ooo`00o`3oool/0?oo
o`030000003oool0oooo0:P0oooo00<000000?ooo`3oool0O`3oool00?l0oooo;03oool300000:P0
oooo00<000000?ooo`3oool0O`3oool00?l0oooo;03oool00`000000oooo0?ooo`2W0?ooo`030000
003oool0oooo0800oooo003o0?ooob`0oooo00<000000?ooo`3oool0Y`3oool00`000000oooo0?oo
o`200?ooo`00o`3oool/0?ooo`030000003oool0oooo0:L0oooo00<000000?ooo`3oool0P03oool0
0?l0oooo;03oool00`000000oooo0?ooo`2W0?ooo`030000003oool0oooo0800oooo003o0?ooob`0
oooo00<000000?ooo`3oool0Y`3oool00`000000oooo0?ooo`200?ooo`00o`3oool/0?ooo`030000
003oool0oooo0:H0oooo00<000000?ooo`3oool0P@3oool00?l0oooo;03oool00`000000oooo0?oo
o`2V0?ooo`030000003oool0oooo0840oooo003o0?ooob`0oooo00<000000?ooo`3oool0YP3oool0
0`000000oooo0?ooo`210?ooo`00o`3oool/0?ooo`030000003oool0oooo0:H0oooo00<000000?oo
o`3oool0P@3oool00?l0oooo;03oool00`000000oooo0?ooo`2V0?ooo`030000003oool0oooo0840
oooo003o0?ooob`0oooo00<000000?ooo`3oool0Y@3oool00`000000oooo0?ooo`220?ooo`00o`3o
ool/0?ooo`<00000Y@3oool00`000000oooo0?ooo`220?ooo`00o`3oool/0?ooo`030000003oool0
oooo0:D0oooo00<000000?ooo`3oool0PP3oool00?l0oooo;03oool00`000000oooo0?ooo`2U0?oo
o`030000003oool0oooo0880oooo003o0?ooob`0oooo00<000000?ooo`3oool0Y@3oool00`000000
oooo0?ooo`220?ooo`00o`3oool/0?ooo`030000003oool0oooo0:@0oooo00<000000?ooo`3oool0
P`3oool00?l0oooo;03oool00`000000oooo0?ooo`2T0?ooo`030000003oool0oooo08<0oooo003o
0?ooob`0oooo00<000000?ooo`3oool0Y03oool00`000000oooo0?ooo`230?ooo`00o`3oool/0?oo
o`030000003oool0oooo0:@0oooo00<000000?ooo`3oool0P`3oool00?l0oooo;03oool00`000000
oooo0?ooo`2S0?ooo`030000003oool0oooo08@0oooo003o0?ooob`0oooo00<000000?ooo`3oool0
X`3oool00`000000oooo0?ooo`240?ooo`00o`3ooolR0?ooo`<000001`3oool00`000000oooo0?oo
o`2S0?ooo`030000003oool0oooo08@0oooo003o0?ooob<0oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`2S0?ooo`030000003oool0oooo08@0oooo003o0?ooob00oooo1@0000070?oo
o`D00000X@3oool00`000000oooo0?ooo`240?ooo`00o`3ooolJ0?ooo`@000000P3oool010000000
oooo0?ooo`0000080?ooo`030000003oool0oooo0:80oooo00<000000?ooo`3oool0Q@3oool00?l0
oooo8@3oool00`000000oooo000000080?ooo`030000003oool0oooo0:80oooo00<000000?ooo`3o
ool0Q@3oool00?l0oooo8P3oool2000000P0oooo00<000000?ooo`3oool0XP3oool00`000000oooo
0?ooo`250?ooo`00o`3oool/0?ooo`030000003oool0oooo0:80oooo00<000000?ooo`3oool0Q@3o
ool00?l0oooo;03oool00`000000oooo0?ooo`2R0?ooo`030000003oool0oooo08D0oooo003o0?oo
ob`0oooo00<000000?ooo`3oool0X@3oool00`000000oooo0?ooo`260?ooo`00o`3oool/0?ooo`03
0000003oool0oooo0:40oooo00<000000?ooo`3oool0QP3oool00?l0oooo;03oool00`000000oooo
0?ooo`2Q0?ooo`030000003oool0oooo08H0oooo003o0?ooob`0oooo00<000000?ooo`3oool0X@3o
ool00`000000oooo0?ooo`260?ooo`00o`3oool/0?ooo`030000003oool0oooo0:40oooo00<00000
0?ooo`3oool0QP3oool00?l0oooo;03oool00`000000oooo0?ooo`2P0?ooo`030000003oool0oooo
08L0oooo003o0?ooob`0oooo0`00002P0?ooo`030000003oool0oooo08L0oooo003o0?ooob`0oooo
00<000000?ooo`3oool0X03oool00`000000oooo0?ooo`270?ooo`00o`3oool/0?ooo`030000003o
ool0oooo0:00oooo00<000000?ooo`3oool0Q`3oool00?l0oooo;03oool00`000000oooo0?ooo`2P
0?ooo`030000003oool0oooo08L0oooo003o0?ooob`0oooo00<000000?ooo`3oool0W`3oool00`00
0000oooo0?ooo`280?ooo`00o`3oool/0?ooo`030000003oool0oooo09l0oooo00<000000?ooo`3o
ool0R03oool00?l0oooo;03oool00`000000oooo0?ooo`2O0?ooo`030000003oool0oooo08P0oooo
003o0?ooob`0oooo00<000000?ooo`3oool0W`3oool00`000000oooo0?ooo`280?ooo`00o`3oool/
0?ooo`030000003oool0oooo09h0oooo00<000000?ooo`3oool0R@3oool00?l0oooo;03oool00`00
0000oooo0?ooo`2N0?ooo`030000003oool0oooo08T0oooo003o0?ooob`0oooo00<000000?ooo`3o
ool0WP3oool00`000000oooo0?ooo`290?ooo`00o`3oool/0?ooo`030000003oool0oooo09h0oooo
00<000000?ooo`3oool0R@3oool00?l0oooo;03oool3000009d0oooo00<000000?ooo`3oool0RP3o
ool00?l0oooo;03oool00`000000oooo0?ooo`2M0?ooo`030000003oool0oooo08X0oooo003o0?oo
ob`0oooo00<000000?ooo`3oool0W@3oool00`000000oooo0?ooo`2:0?ooo`00o`3oool/0?ooo`03
0000003oool0oooo09d0oooo00<000000?ooo`3oool0RP3oool00?l0oooo;03oool00`000000oooo
0?ooo`2L0?ooo`030000003oool0oooo08/0oooo003o0?ooob`0oooo00<000000?ooo`3oool0W03o
ool00`000000oooo0?ooo`2;0?ooo`00o`3oool/0?ooo`030000003oool0oooo09`0oooo00<00000
0?ooo`3oool0R`3oool00?l0oooo;03oool00`000000oooo0?ooo`2L0?ooo`030000003oool0oooo
08/0oooo003o0?ooob`0oooo00<000000?ooo`3oool0V`3oool00`000000oooo0?ooo`2<0?ooo`00
o`3oool/0?ooo`030000003oool0oooo09/0oooo00<000000?ooo`3oool0S03oool00?l0oooo;03o
ool00`000000oooo0?ooo`2K0?ooo`030000003oool0oooo08`0oooo003o0?ooob`0oooo00<00000
0?ooo`3oool0V`3oool00`000000oooo0?ooo`2<0?ooo`00o`3oool/0?ooo`<00000VP3oool00`00
0000oooo0?ooo`2=0?ooo`00o`3oool/0?ooo`030000003oool0oooo09X0oooo00<000000?ooo`3o
ool0S@3oool00?l0oooo;03oool00`000000oooo0?ooo`2J0?ooo`030000003oool0oooo08d0oooo
003o0?ooob`0oooo00<000000?ooo`3oool0VP3oool00`000000oooo0?ooo`2=0?ooo`00o`3oool/
0?ooo`030000003oool0oooo09T0oooo00<000000?ooo`3oool0SP3oool00?l0oooo;03oool00`00
0000oooo0?ooo`2I0?ooo`030000003oool0oooo08h0oooo003o0?ooob`0oooo00<000000?ooo`3o
ool0V@3oool00`000000oooo0?ooo`2>0?ooo`00o`3oool/0?ooo`030000003oool0oooo09T0oooo
00<000000?ooo`3oool0SP3oool00?l0oooo;03oool00`000000oooo0?ooo`2H0?ooo`030000003o
ool0oooo08l0oooo003o0?ooob`0oooo00<000000?ooo`3oool0V03oool00`000000oooo0?ooo`2?
0?ooo`00o`3ooolP0?ooo`@00000203oool00`000000oooo0?ooo`2H0?ooo`030000003oool0oooo
08l0oooo003o0?ooob00oooo00<000000?ooo`3oool02@3oool00`000000oooo0?ooo`2H0?ooo`03
0000003oool0oooo08l0oooo003o0?ooob40oooo00<000000?ooo`3oool0203oool5000009D0oooo
00<000000?ooo`3oool0T03oool00?l0oooo6P3oool4000000@0oooo00<000000?ooo`3oool01`3o
ool00`000000oooo0?ooo`2G0?ooo`030000003oool0oooo0900oooo003o0?ooob00oooo00@00000
0?ooo`3oool00000203oool00`000000oooo0?ooo`2G0?ooo`030000003oool0oooo0900oooo003o
0?ooob40oooo0P0000090?ooo`030000003oool0oooo09L0oooo00<000000?ooo`3oool0T03oool0
0?l0oooo;03oool00`000000oooo0?ooo`2F0?ooo`030000003oool0oooo0940oooo003o0?ooob`0
oooo00<000000?ooo`3oool0UP3oool00`000000oooo0?ooo`2A0?ooo`00o`3oool/0?ooo`030000
003oool0oooo09H0oooo00<000000?ooo`3oool0T@3oool00?l0oooo;03oool00`000000oooo0?oo
o`2F0?ooo`030000003oool0oooo0940oooo003o0?ooob`0oooo00<000000?ooo`3oool0U@3oool0
0`000000oooo0?ooo`2B0?ooo`00o`3oool/0?ooo`030000003oool0oooo09D0oooo00<000000?oo
o`3oool0TP3oool00?l0oooo;03oool00`000000oooo0?ooo`2E0?ooo`030000003oool0oooo0980
oooo003o0?ooob`0oooo00<000000?ooo`3oool0U@3oool00`000000oooo0?ooo`2B0?ooo`00o`3o
ool/0?ooo`<00000U03oool00`000000oooo0?ooo`2C0?ooo`00o`3oool/0?ooo`030000003oool0
oooo09@0oooo00<000000?ooo`3oool0T`3oool00?l0oooo;03oool00`000000oooo0?ooo`2D0?oo
o`030000003oool0oooo09<0oooo003o0?ooob`0oooo00<000000?ooo`3oool0U03oool00`000000
oooo0?ooo`2C0?ooo`00o`3oool/0?ooo`030000003oool0oooo09<0oooo00<000000?ooo`3oool0
U03oool00?l0oooo;03oool00`000000oooo0?ooo`2C0?ooo`030000003oool0oooo09@0oooo003o
0?ooob`0oooo00<000000?ooo`3oool0T`3oool00`000000oooo0?ooo`2D0?ooo`00o`3oool/0?oo
o`030000003oool0oooo09<0oooo00<000000?ooo`3oool0U03oool00?l0oooo;03oool00`000000
oooo0?ooo`2B0?ooo`030000003oool0oooo09D0oooo003o0?ooob`0oooo00<000000?ooo`3oool0
TP3oool00`000000oooo0?ooo`2E0?ooo`00o`3oool/0?ooo`030000003oool0oooo0980oooo00<0
00000?ooo`3oool0U@3oool00?l0oooo;03oool300000980oooo00<000000?ooo`3oool0U@3oool0
0?l0oooo;03oool00`000000oooo0?ooo`2A0?ooo`030000003oool0oooo09H0oooo003o0?ooob`0
oooo00<000000?ooo`3oool0T@3oool00`000000oooo0?ooo`2F0?ooo`00o`3oool/0?ooo`030000
003oool0oooo0940oooo00<000000?ooo`3oool0UP3oool00?l0oooo;03oool00`000000oooo0?oo
o`2A0?ooo`030000003oool0oooo09H0oooo003o0?ooob`0oooo00<000000?ooo`3oool0T03oool0
0`000000oooo0?ooo`2G0?ooo`00o`3oool/0?ooo`030000003oool0oooo0900oooo00<000000?oo
o`3oool0U`3oool00?l0oooo;03oool00`000000oooo0?ooo`2@0?ooo`030000003oool0oooo09L0
oooo003o0?ooob`0oooo00<000000?ooo`3oool0T03oool00`000000oooo0?ooo`2G0?ooo`00403o
ool2000005`0oooo1000001K0?ooo`D00000F@3oool00`000000oooo0?ooo`1J0?ooo`D00000<03o
ool00`000000oooo0?ooo`0W0?ooo`@00000G03oool2000000l0oooo000?0?ooo`040000003oool0
oooo000005/0oooo00<000000?ooo`3oool0GP3oool00`000000oooo0?ooo`1I0?ooo`030000003o
ool0oooo05`0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0W0?ooo`030000003o
ool0oooo05`0oooo00@000000?ooo`3oool000003P3oool00140oooo00<000000?ooo`3oool0F`3o
ool00`000000oooo0?ooo`1M0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool0G03o
ool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0G@3o
ool00`000000oooo0?ooo`0=0?ooo`002@3oool4000000D0oooo00<000000?ooo`3oool0D`3oool4
000000@0oooo00<000000?ooo`3oool0E03oool4000000@0oooo00<000000?ooo`3oool0F@3oool3
000005`0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`0Y0?ooo`030000003oool0
oooo05d0oooo00<000000?ooo`3oool0303oool000l0oooo00@000000?ooo`3oool00000F`3oool0
10000000oooo0?ooo`00001M0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool0G03o
ool00`000000oooo0?ooo`0_0?ooo`030000003oool0oooo02P0oooo00@000000?ooo`3oool00000
F`3oool010000000oooo0?ooo`00000>0?ooo`00403oool2000005d0oooo0P00001M0?ooo`800000
F`3oool00`000000oooo0?ooo`1K0?ooo`800000<@3oool00`000000oooo0?ooo`0Y0?ooo`800000
G@3oool2000000l0oooo003o0?ooob`0oooo00<000000?ooo`3oool0SP3oool00`000000oooo0?oo
o`2I0?ooo`00o`3oool/0?ooo`030000003oool0oooo08h0oooo00<000000?ooo`3oool0V@3oool0
0?l0oooo;03oool00`000000oooo0?ooo`2=0?ooo`030000003oool0oooo09X0oooo003o0?ooob`0
oooo00<000000?ooo`3oool0S@3oool00`000000oooo0?ooo`2J0?ooo`00o`3oool/0?ooo`030000
003oool0oooo08d0oooo00<000000?ooo`3oool0VP3oool00?l0oooo;03oool00`000000oooo0?oo
o`2=0?ooo`030000003oool0oooo09X0oooo003o0?ooob`0oooo00<000000?ooo`3oool0S03oool0
0`000000oooo0?ooo`2K0?ooo`00o`3oool/0?ooo`030000003oool0oooo08`0oooo00<000000?oo
o`3oool0V`3oool00?l0oooo;03oool00`000000oooo0?ooo`2<0?ooo`030000003oool0oooo09/0
oooo003o00000?l00000F@0000010?ooo`003P3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo00H0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0@0?ooo`030000003o
ool0oooo00d0oooo000>0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool01P3oool0
0`000000oooo0?ooo`070?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0403oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool03@3oool0
00h0oooo00<000000?ooo`3oool0G03oool00`000000oooo0?ooo`1L0?ooo`030000003oool0oooo
05`0oooo00<000000?ooo`3oool0G03oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo
02d0oooo00<000000?ooo`3oool0G03oool00`000000oooo0?ooo`0=0?ooo`003P3oool00`000000
oooo0?ooo`1L0?ooo`030000003oool0oooo05`0oooo00<000000?ooo`3oool0G03oool00`000000
oooo0?ooo`1L0?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool0;@3oool00`000000
oooo0?ooo`1L0?ooo`030000003oool0oooo00d0oooo003o0?ooob`0oooo00<000000?ooo`3oool0
RP3oool00`000000oooo0?ooo`2M0?ooo`00o`3oool/0?ooo`030000003oool0oooo08X0oooo00<0
00000?ooo`3oool0W@3oool00?l0oooo;03oool00`000000oooo0?ooo`2:0?ooo`030000003oool0
oooo09d0oooo003o0?ooob`0oooo00<000000?ooo`3oool0RP3oool00`000000oooo0?ooo`2M0?oo
o`00o`3oool/0?ooo`030000003oool0oooo08T0oooo00<000000?ooo`3oool0WP3oool00?l0oooo
;03oool00`000000oooo0?ooo`290?ooo`030000003oool0oooo09h0oooo003o0?ooob`0oooo00<0
00000?ooo`3oool0R@3oool00`000000oooo0?ooo`2N0?ooo`00m03oool300D0oc@0oooo0`000029
0?ooo`030000003oool0oooo09h0oooo003c0?ooo`D01@3o<`3oool00`000000oooo0?ooo`280?oo
o`030000003oool0oooo09l0oooo003b0?ooo`L01@3o<P3oool00`000000oooo0?ooo`280?ooo`03
0000003oool0oooo09l0oooo003_0?ooo`<000001`050?l4000002h0oooo00<000000?ooo`3oool0
R03oool00`000000oooo0?ooo`2O0?ooo`00j`3oool4000000<0oooo1`050?l40?ooo`D00000:@3o
ool00`000000oooo0?ooo`270?ooo`030000003oool0oooo0:00oooo003Y0?ooo`800000203oool5
00D0o`X0oooo0P00000W0?ooo`030000003oool0oooo08L0oooo00<000000?ooo`3oool0X03oool0
0>L0oooo0P00000;0?ooo`<01@3o3@3oool2000002D0oooo00<000000?ooo`3oool0Q`3oool00`00
0000oooo0?ooo`2P0?ooo`00i@3oool2000001l0oooo0P00000S0?ooo`030000003oool0oooo08H0
oooo00<000000?ooo`3oool0X@3oool00>@0oooo00<000000?ooo`3oool08@3oool200000240oooo
00<000000?ooo`3oool0QP3oool00`000000oooo0?ooo`2Q0?ooo`00h`3oool00`000000oooo0?oo
o`0T0?ooo`8000007`3oool00`000000oooo0?ooo`250?ooo`030000003oool0oooo0:80oooo003R
0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`25
0?ooo`030000003oool0oooo0:80oooo003P0?ooo`800000:`3oool2000001`0oooo00<000000?oo
o`3oool0Q@3oool00`000000oooo0?ooo`2R0?ooo`00g`3oool00`000000oooo0?ooo`0]0?ooo`80
00006P3oool3000008@0oooo00<000000?ooo`3oool0X`3oool00=h0oooo00<000000?ooo`3oool0
<03oool2000001P0oooo00<000000?ooo`3oool0Q03oool00`000000oooo0?ooo`2S0?ooo`00g@3o
ool00`000000oooo0?ooo`0c0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool0Q03o
ool00`000000oooo0?ooo`2S0?ooo`00g03oool00`000000oooo0?ooo`0e0?ooo`030000003oool0
oooo01@0oooo00<000000?ooo`3oool0P`3oool00`000000oooo0?ooo`2T0?ooo`00fP3oool20000
03T0oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`230?ooo`030000003oool0oooo
0:@0oooo003I0?ooo`030000003oool0oooo03X0oooo00<000000?ooo`3oool04P3oool00`000000
oooo0?ooo`220?ooo`030000003oool0oooo0:D0oooo003H0?ooo`030000003oool0oooo03`0oooo
0P00000B0?ooo`030000003oool0oooo0880oooo00<000000?ooo`3oool0Y@3oool00=L0oooo00<0
00000?ooo`3oool0?`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0880oooo00<0
00000?ooo`3oool0Y@3oool00=H0oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo0840oooo00<000000?ooo`3oool0YP3oool00=H0oooo00<000000?oo
o`3oool0@P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0840oooo00<000000?oo
o`3oool0YP3oool00=D0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`0<0?ooo`03
0000003oool0oooo0840oooo00<000000?ooo`3oool0YP3oool00=@0oooo00<000000?ooo`3oool0
AP3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0800oooo00<000000?ooo`3oool0
Y`3oool00=@0oooo00<000000?ooo`3oool0A`3oool00`000000oooo0?ooo`0:0?ooo`<00000P03o
ool00`000000oooo0?ooo`2W0?ooo`00d`3oool00`000000oooo0?ooo`190?ooo`030000003oool0
oooo00T0oooo00<000000?ooo`3oool0P03oool00`000000oooo0?ooo`2W0?ooo`00dP3oool00`00
0000oooo0?ooo`1;0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0O`3oool00`00
0000oooo0?ooo`2X0?ooo`00dP3oool00`000000oooo0?ooo`1<0?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool0O`3oool00`000000oooo0?ooo`2X0?ooo`00d@3oool00`000000oooo
0?ooo`1>0?ooo`8000001`3oool00`000000oooo0?ooo`1n0?ooo`030000003oool0oooo0:T0oooo
003A0?ooo`030000003oool0oooo0500oooo00<000000?ooo`3oool0103oool00`000000oooo0?oo
o`1n0?ooo`030000003oool0oooo0:T0oooo003@0?ooo`030000003oool0oooo0580oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`1n0?ooo`030000003oool0oooo0:T0oooo003?0?oo
o`030000003oool0oooo05@0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`1m0?oo
o`030000003oool0oooo0:X0oooo003?0?ooo`030000003oool0oooo05D0oooo00D000000?ooo`3o
ool0oooo0000001o0?ooo`030000003oool0oooo0:X0oooo003>0?ooo`030000003oool0oooo05L0
oooo00@000000?ooo`3oool00000O`3oool00`000000oooo0?ooo`2Z0?ooo`00c@3oool00`000000
oooo0?ooo`1?0?ooo`@000001P3oool00`000000oooo0000001n0?ooo`030000003oool0oooo0:/0
oooo003=0?ooo`030000003oool0oooo04l0oooo00<000000?ooo`3oool0203oool2000007h0oooo
00<000000?ooo`3oool0Z`3oool00<`0oooo00<000000?ooo`3oool0D@3oool00`000000oooo0?oo
o`080?ooo`D00000N@3oool00`000000oooo0?ooo`2/0?ooo`00b`3oool00`000000oooo0?ooo`1C
0?ooo`030000003oool0oooo00L0oooo0P00001l0?ooo`030000003oool0oooo0:`0oooo003;0?oo
o`030000003oool0oooo0540oooo00@000000?ooo`3oool00000203oool00`000000oooo0000001j
0?ooo`030000003oool0oooo0:d0oooo003:0?ooo`030000003oool0oooo05<0oooo0P0000090?oo
o`040000003oool0oooo000007T0oooo00<000000?ooo`3oool0[@3oool00<X0oooo00<000000?oo
o`3oool0GP3oool01@000000oooo0?ooo`3oool0000007L0oooo00<000000?ooo`3oool0[P3oool0
0<T0oooo00<000000?ooo`3oool0G`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
07@0oooo00<000000?ooo`3oool0[P3oool00<T0oooo00<000000?ooo`3oool0G`3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo0780oooo00<000000?ooo`3oool0[`3oool00<P0oooo
00<000000?ooo`3oool0H03oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0740oooo
00<000000?ooo`3oool0[`3oool00<P0oooo00<000000?ooo`3oool0H03oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo06l0oooo00<000000?ooo`3oool0/03oool00<L0oooo00<00000
0?ooo`3oool0H@3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo06h0oooo00<00000
0?ooo`3oool0/03oool00<L0oooo00<000000?ooo`3oool0H@3oool00`000000oooo0?ooo`070?oo
o`030000003oool0oooo06`0oooo00<000000?ooo`3oool0/@3oool00<H0oooo00<000000?ooo`3o
ool0HP3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo06/0oooo00<000000?ooo`3o
ool0/@3oool00<H0oooo00<000000?ooo`3oool0HP3oool3000000T0oooo00<000000?ooo`3oool0
J@3oool00`000000oooo0?ooo`2b0?ooo`00a@3oool00`000000oooo0?ooo`1S0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool0J03oool00`000000oooo0?ooo`2b0?ooo`00a@3oool0
0`000000oooo0?ooo`1S0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0IP3oool0
0`000000oooo0?ooo`2c0?ooo`00a03oool00`000000oooo0?ooo`1T0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool0I@3oool00`000000oooo0?ooo`2c0?ooo`00a03oool00`000000
oooo0?ooo`1T0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0H`3oool00`000000
oooo0?ooo`2d0?ooo`00``3oool00`000000oooo0?ooo`1U0?ooo`030000003oool0oooo00h0oooo
00<000000?ooo`3oool0HP3oool00`000000oooo0?ooo`2d0?ooo`00``3oool00`000000oooo0?oo
o`1U0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0H03oool00`000000oooo0?oo
o`2e0?ooo`00`P3oool00`000000oooo0?ooo`1V0?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool0G`3oool00`000000oooo0?ooo`2e0?ooo`00`P3oool00`000000oooo0?ooo`1V0?oo
o`030000003oool0oooo0140oooo00<000000?ooo`3oool0G@3oool00`000000oooo0?ooo`2f0?oo
o`00`@3oool00`000000oooo0?ooo`1W0?ooo`030000003oool0oooo0180oooo00<000000?ooo`3o
ool0G03oool00`000000oooo0?ooo`2f0?ooo`00`@3oool00`000000oooo0?ooo`1W0?ooo`030000
003oool0oooo01<0oooo00<000000?ooo`3oool0FP3oool00`000000oooo0?ooo`2g0?ooo`00`@3o
ool00`000000oooo0?ooo`1W0?ooo`030000003oool0oooo01@0oooo00<000000?ooo`3oool0F@3o
ool00`000000oooo0?ooo`2g0?ooo`00`03oool00`000000oooo0?ooo`1X0?ooo`<000005@3oool0
0`000000oooo0?ooo`1G0?ooo`030000003oool0oooo0;P0oooo00300?ooo`030000003oool0oooo
06P0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`1E0?ooo`030000003oool0oooo
0;T0oooo00300?ooo`030000003oool0oooo06P0oooo00<000000?ooo`3oool05`3oool00`000000
oooo0?ooo`1D0?ooo`030000003oool0oooo0;T0oooo002o0?ooo`030000003oool0oooo06T0oooo
00<000000?ooo`3oool0603oool00`000000oooo0?ooo`1B0?ooo`030000003oool0oooo0;X0oooo
002o0?ooo`030000003oool0oooo06T0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?oo
o`1@0?ooo`030000003oool0oooo0;/0oooo002n0?ooo`030000003oool0oooo06X0oooo00<00000
0?ooo`3oool06P3oool00`000000oooo0?ooo`1>0?ooo`030000003oool0oooo0;`0oooo002n0?oo
o`030000003oool0oooo06X0oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`1=0?oo
o`030000003oool0oooo0;`0oooo002n0?ooo`030000003oool0oooo06X0oooo00<000000?ooo`3o
ool0703oool00`000000oooo0?ooo`1;0?ooo`030000003oool0oooo0;d0oooo002m0?ooo`030000
003oool0oooo06/0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`190?ooo`030000
003oool0oooo0;h0oooo002m0?ooo`030000003oool0oooo06/0oooo00<000000?ooo`3oool07P3o
ool00`000000oooo0?ooo`180?ooo`030000003oool0oooo0;h0oooo002m0?ooo`030000003oool0
oooo06/0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`160?ooo`030000003oool0
oooo0;l0oooo002l0?ooo`030000003oool0oooo06`0oooo0`00000P0?ooo`030000003oool0oooo
04@0oooo00<000000?ooo`3oool0`03oool00;`0oooo00<000000?ooo`3oool0K03oool00`000000
oooo0?ooo`0Q0?ooo`800000A03oool00`000000oooo0?ooo`300?ooo`00_03oool00`000000oooo
0?ooo`1/0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0@03oool00`000000oooo
0?ooo`310?ooo`00^`3oool00`000000oooo0?ooo`1]0?ooo`030000003oool0oooo02@0oooo00<0
00000?ooo`3oool0?P3oool00`000000oooo0?ooo`320?ooo`00^`3oool00`000000oooo0?ooo`1]
0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`33
0?ooo`00^P3oool00`000000oooo0?ooo`1^0?ooo`030000003oool0oooo02H0oooo00<000000?oo
o`3oool0>P3oool00`000000oooo0?ooo`340?ooo`00^P3oool00`000000oooo0?ooo`1^0?ooo`03
0000003oool0oooo02L0oooo0P00000j0?ooo`030000003oool0oooo0<@0oooo002j0?ooo`030000
003oool0oooo06h0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0f0?ooo`030000
003oool0oooo0<D0oooo002i0?ooo`030000003oool0oooo06l0oooo00<000000?ooo`3oool0:P3o
ool00`000000oooo0?ooo`0d0?ooo`030000003oool0oooo0<H0oooo002i0?ooo`030000003oool0
oooo06l0oooo00<000000?ooo`3oool0:`3oool2000003<0oooo00<000000?ooo`3oool0a`3oool0
0;T0oooo00<000000?ooo`3oool0I@3oool3000000L0oooo00<000000?ooo`3oool0;@3oool20000
0300oooo00<000000?ooo`3oool0b03oool00;P0oooo00<000000?ooo`3oool0I`3oool00`000000
oooo0?ooo`060?ooo`030000003oool0oooo02l0oooo0P00000]0?ooo`030000003oool0oooo0<T0
oooo002h0?ooo`030000003oool0oooo06@0oooo1@0000070?ooo`D00000;`3oool00`000000oooo
0?ooo`0X0?ooo`800000c03oool00;P0oooo00<000000?ooo`3oool0I03oool010000000oooo0?oo
o`0000080?ooo`030000003oool0oooo0380oooo0P00000W0?ooo`030000003oool0oooo0<`0oooo
002g0?ooo`030000003oool0oooo06H0oooo00<000000?ooo`000000203oool00`000000oooo0?oo
o`0d0?ooo`8000008`3oool200000<l0oooo002g0?ooo`030000003oool0oooo06L0oooo0P000008
0?ooo`030000003oool0oooo03H0oooo0P00000O0?ooo`800000d@3oool00;H0oooo00<000000?oo
o`3oool0LP3oool00`000000oooo0?ooo`0h0?ooo`8000006`3oool200000=<0oooo002f0?ooo`03
0000003oool0oooo0780oooo00<000000?ooo`3oool0>P3oool2000000/0oooo0`050?l:0?ooo`03
0000003oool0oooo0=<0oooo002f0?ooo`030000003oool0oooo0780oooo00<000000?ooo`3oool0
?03oool3000000L0oooo1@050?l60?ooo`<00000eP3oool00;D0oooo00<000000?ooo`3oool0L`3o
ool00`000000oooo0?ooo`0o0?ooo`H000001`050?l500000=T0oooo002e0?ooo`030000003oool0
oooo07<0oooo00<000000?ooo`3oool0A@3oool700D0omh0oooo002e0?ooo`030000003oool0oooo
07<0oooo00<000000?ooo`3oool0A@3oool700D0omh0oooo002d0?ooo`030000003oool0oooo07@0
oooo00<000000?ooo`3oool0AP3oool500D0oml0oooo002d0?ooo`030000003oool0oooo07@0oooo
00<000000?ooo`3oool0A`3oool300D0on00oooo002d0?ooo`030000003oool0oooo07@0oooo0`00
003o0?ooob/0oooo002d0?ooo`030000003oool0oooo07@0oooo00<000000?ooo`3oool0o`3oool[
0?ooo`00/`3oool00`000000oooo0?ooo`1e0?ooo`030000003oool0oooo0?l0oooo:`3oool00;<0
oooo00<000000?ooo`3oool0M@3oool00`000000oooo0?ooo`3o0?ooob/0oooo002c0?ooo`030000
003oool0oooo07D0oooo00<000000?ooo`3oool0o`3oool[0?ooo`00/P3oool00`000000oooo0?oo
o`1f0?ooo`030000003oool0oooo0?l0oooo:`3oool00;80oooo00<000000?ooo`3oool0MP3oool0
0`000000oooo0?ooo`3o0?ooob/0oooo002b0?ooo`030000003oool0oooo07H0oooo00<000000?oo
o`3oool0o`3oool[0?ooo`00/@3oool00`000000oooo0?ooo`1g0?ooo`030000003oool0oooo0?l0
oooo:`3oool00;40oooo00<000000?ooo`3oool0M`3oool00`000000oooo0?ooo`3o0?ooob/0oooo
002a0?ooo`030000003oool0oooo07L0oooo00<000000?ooo`3oool0o`3oool[0?ooo`00/@3oool0
0`000000oooo0?ooo`1g0?ooo`030000003oool0oooo0?l0oooo:`3oool00;00oooo00<000000?oo
o`3oool0N03oool300000?l0oooo:`3oool00;00oooo00<000000?ooo`3oool0N03oool00`000000
oooo0?ooo`3o0?ooob/0oooo002`0?ooo`030000003oool0oooo07P0oooo00<000000?ooo`3oool0
o`3oool[0?ooo`00[`3oool00`000000oooo0?ooo`1i0?ooo`030000003oool0oooo0?l0oooo:`3o
ool00:l0oooo00<000000?ooo`3oool0N@3oool00`000000oooo0?ooo`3o0?ooob/0oooo002_0?oo
o`030000003oool0oooo07T0oooo00<000000?ooo`3oool0o`3oool[0?ooo`00[`3oool00`000000
oooo0?ooo`1i0?ooo`030000003oool0oooo0?l0oooo:`3oool00:h0oooo00<000000?ooo`3oool0
NP3oool00`000000oooo0?ooo`3o0?ooob/0oooo002^0?ooo`030000003oool0oooo07X0oooo00<0
00000?ooo`3oool0o`3oool[0?ooo`00[P3oool00`000000oooo0?ooo`1j0?ooo`030000003oool0
oooo0?l0oooo:`3oool00:d0oooo00<000000?ooo`3oool0N`3oool00`000000oooo0?ooo`3o0?oo
ob/0oooo002]0?ooo`030000003oool0oooo07/0oooo00<000000?ooo`3oool0o`3oool[0?ooo`00
[@3oool00`000000oooo0?ooo`1k0?ooo`<00000o`3oool[0?ooo`00[@3oool00`000000oooo0?oo
o`1k0?ooo`030000003oool0oooo0?l0oooo:`3oool00:`0oooo00<000000?ooo`3oool0O03oool0
0`000000oooo0?ooo`3o0?ooob/0oooo002/0?ooo`030000003oool0oooo07`0oooo00<000000?oo
o`3oool0o`3oool[0?ooo`00[03oool00`000000oooo0?ooo`1l0?ooo`030000003oool0oooo0?l0
oooo:`3oool00:/0oooo00<000000?ooo`3oool0O@3oool00`000000oooo0?ooo`3o0?ooob/0oooo
002[0?ooo`030000003oool0oooo07d0oooo00<000000?ooo`3oool0o`3oool[0?ooo`00Z`3oool0
0`000000oooo0?ooo`1m0?ooo`030000003oool0oooo0?l0oooo:`3oool00:X0oooo00<000000?oo
o`3oool0OP3oool00`000000oooo0?ooo`3o0?ooob/0oooo002Z0?ooo`030000003oool0oooo07h0
oooo00<000000?ooo`3oool0o`3oool[0?ooo`00ZP3oool00`000000oooo0?ooo`1b0?ooo`<00000
2@3oool00`000000oooo0?ooo`3o0?ooob/0oooo002Z0?ooo`030000003oool0oooo0780oooo00@0
00000?ooo`3oool00000203oool00`000000oooo0?ooo`3o0?ooob/0oooo002Y0?ooo`030000003o
ool0oooo07<0oooo00@000000?ooo`3oool00000203oool500000?l0oooo:@3oool00:T0oooo00<0
00000?ooo`3oool0L`3oool3000000T0oooo00<000000?ooo`3oool0o`3oool[0?ooo`00Z@3oool0
0`000000oooo0?ooo`1d0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0o`3oool[
0?ooo`00Z@3oool00`000000oooo0?ooo`1d0?ooo`<00000203oool00`000000oooo0?ooo`3o0?oo
ob/0oooo002X0?ooo`030000003oool0oooo0800oooo00<000000?ooo`3oool0o`3oool[0?ooo`00
Z03oool00`000000oooo0?ooo`200?ooo`030000003oool0oooo0?l0oooo:`3oool00:P0oooo00<0
00000?ooo`3oool0P03oool00`000000oooo0?ooo`3o0?ooob/0oooo002X0?ooo`030000003oool0
oooo0800oooo00<000000?ooo`3oool0o`3oool[0?ooo`00Y`3oool00`000000oooo0?ooo`210?oo
o`030000003oool0oooo0?l0oooo:`3oool00:L0oooo00<000000?ooo`3oool0P@3oool00`000000
oooo0?ooo`3o0?ooob/0oooo002W0?ooo`030000003oool0oooo0840oooo00<000000?ooo`3oool0
o`3oool[0?ooo`00Y`3oool00`000000oooo0?ooo`210?ooo`030000003oool0oooo0?l0oooo:`3o
ool00:H0oooo00<000000?ooo`3oool0PP3oool300000?l0oooo:`3oool00:H0oooo00<000000?oo
o`3oool0PP3oool00`000000oooo0?ooo`3o0?ooob/0oooo002V0?ooo`030000003oool0oooo0880
oooo00<000000?ooo`3oool0o`3oool[0?ooo`00YP3oool00`000000oooo0?ooo`220?ooo`030000
003oool0oooo0?l0oooo:`3oool00:H0oooo00<000000?ooo`3oool0PP3oool00`000000oooo0?oo
o`3o0?ooob/0oooo002U0?ooo`030000003oool0oooo08<0oooo00<000000?ooo`3oool0o`3oool[
0?ooo`00Y@3oool00`000000oooo0?ooo`230?ooo`030000003oool0oooo0?l0oooo:`3oool00:D0
oooo00<000000?ooo`3oool0P`3oool00`000000oooo0?ooo`3o0?ooob/0oooo002U0?ooo`030000
003oool0oooo08<0oooo00<000000?ooo`3oool0o`3oool[0?ooo`00Y03oool00`000000oooo0?oo
o`240?ooo`030000003oool0oooo0?l0oooo:`3oool00:@0oooo00<000000?ooo`3oool0Q03oool0
0`000000oooo0?ooo`3o0?ooob/0oooo002T0?ooo`030000003oool0oooo08@0oooo00<000000?oo
o`3oool0o`3oool[0?ooo`00Y03oool00`000000oooo0?ooo`240?ooo`<00000o`3oool[0?ooo`00
X`3oool00`000000oooo0?ooo`250?ooo`030000003oool0oooo0?l0oooo:`3oool00:<0oooo00<0
00000?ooo`3oool0Q@3oool00`000000oooo0?ooo`3o0?ooob/0oooo002S0?ooo`030000003oool0
oooo08D0oooo00<000000?ooo`3oool0o`3oool[0?ooo`00X`3oool00`000000oooo0?ooo`250?oo
o`030000003oool0oooo0?l0oooo:`3oool00:80oooo00<000000?ooo`3oool0QP3oool00`000000
oooo0?ooo`3o0?ooob/0oooo002R0?ooo`030000003oool0oooo08H0oooo00<000000?ooo`3oool0
o`3oool[0?ooo`00XP3oool00`000000oooo0?ooo`260?ooo`030000003oool0oooo0?l0oooo:`3o
ool00:80oooo00<000000?ooo`3oool0QP3oool00`000000oooo0?ooo`3o0?ooob/0oooo002R0?oo
o`030000003oool0oooo08H0oooo00<000000?ooo`3oool0o`3oool[0?ooo`00X@3oool00`000000
oooo0?ooo`270?ooo`030000003oool0oooo0?l0oooo:`3oool00:40oooo00<000000?ooo`3oool0
Q`3oool00`000000oooo0?ooo`3o0?ooob/0oooo002Q0?ooo`030000003oool0oooo08L0oooo0`00
003o0?ooob/0oooo002Q0?ooo`030000003oool0oooo08L0oooo00<000000?ooo`3oool0o`3oool[
0?ooo`00X03oool00`000000oooo0?ooo`280?ooo`030000003oool0oooo0?l0oooo:`3oool00:00
oooo00<000000?ooo`3oool0R03oool00`000000oooo0?ooo`3o0?ooob/0oooo002P0?ooo`030000
003oool0oooo08P0oooo00<000000?ooo`3oool0o`3oool[0?ooo`00X03oool00`000000oooo0?oo
o`280?ooo`030000003oool0oooo0?l0oooo:`3oool009l0oooo00<000000?ooo`3oool0R@3oool0
0`000000oooo0?ooo`3o0?ooob/0oooo002O0?ooo`030000003oool0oooo08T0oooo00<000000?oo
o`3oool0o`3oool[0?ooo`00W`3oool00`000000oooo0?ooo`290?ooo`030000003oool0oooo0?l0
oooo:`3oool009l0oooo00<000000?ooo`3oool0R@3oool00`000000oooo0?ooo`3o0?ooob/0oooo
002O0?ooo`030000003oool0oooo07h0oooo0P0000090?ooo`030000003oool0oooo0?l0oooo:`3o
ool009h0oooo00<000000?ooo`3oool0OP3oool010000000oooo0?ooo`0000080?ooo`030000003o
ool0oooo0?l0oooo:`3oool009h0oooo00<000000?ooo`3oool0OP3oool010000000oooo0?ooo`00
00080?ooo`D00000o`3ooolY0?ooo`00WP3oool00`000000oooo0?ooo`1o0?ooo`8000002@3oool0
0`000000oooo0?ooo`3o0?ooob/0oooo002N0?ooo`030000003oool0oooo07h0oooo00@000000?oo
o`3oool00000203oool00`000000oooo0?ooo`3o0?ooob/0oooo002M0?ooo`030000003oool0oooo
0800oooo0P0000090?ooo`030000003oool0oooo0?l0oooo:`3oool009d0oooo00<000000?ooo`3o
ool0R`3oool00`000000oooo0?ooo`3o0?ooob/0oooo002M0?ooo`030000003oool0oooo08/0oooo
00<000000?ooo`3oool0o`3oool[0?ooo`00W@3oool00`000000oooo0?ooo`2;0?ooo`030000003o
ool0oooo0?l0oooo:`3oool009`0oooo00<000000?ooo`3oool0S03oool00`000000oooo0?ooo`3o
0?ooob/0oooo002L0?ooo`030000003oool0oooo08`0oooo00<000000?ooo`3oool0o`3oool[0?oo
o`00W03oool00`000000oooo0?ooo`2<0?ooo`030000003oool0oooo0?l0oooo:`3oool009`0oooo
00<000000?ooo`3oool0S03oool00`000000oooo0?ooo`3o0?ooob/0oooo002L0?ooo`030000003o
ool0oooo08`0oooo0`00003o0?ooob/0oooo002L0?ooo`030000003oool0oooo08`0oooo00<00000
0?ooo`3oool0o`3oool[0?ooo`00V`3oool00`000000oooo0?ooo`2=0?ooo`030000003oool0oooo
0?l0oooo:`3oool009/0oooo00<000000?ooo`3oool0S@3oool00`000000oooo0?ooo`3o0?ooob/0
oooo002K0?ooo`030000003oool0oooo08d0oooo00<000000?ooo`3oool0o`3oool[0?ooo`00V`3o
ool00`000000oooo0?ooo`2=0?ooo`030000003oool0oooo0?l0oooo:`3oool009/0oooo00<00000
0?ooo`3oool0S@3oool00`000000oooo0?ooo`3o0?ooob/0oooo002K0?ooo`030000003oool0oooo
08d0oooo00<000000?ooo`3oool0o`3oool[0?ooo`00VP3oool00`000000oooo0?ooo`2>0?ooo`03
0000003oool0oooo0?l0oooo:`3oool009X0oooo00<000000?ooo`3oool0SP3oool00`000000oooo
0?ooo`3o0?ooob/0oooo002J0?ooo`030000003oool0oooo08h0oooo00<000000?ooo`3oool0o`3o
ool[0?ooo`00VP3oool00`000000oooo0?ooo`2>0?ooo`030000003oool0oooo0?l0oooo:`3oool0
09X0oooo00<000000?ooo`3oool0SP3oool300000?l0oooo:`3oool009X0oooo00<000000?ooo`3o
ool0SP3oool00`000000oooo0?ooo`3o0?ooob/0oooo002I0?ooo`030000003oool0oooo08l0oooo
00<000000?ooo`3oool0o`3oool[0?ooo`00V@3oool00`000000oooo0?ooo`2?0?ooo`030000003o
ool0oooo0?l0oooo:`3oool009T0oooo00<000000?ooo`3oool0S`3oool00`000000oooo0?ooo`3o
0?ooob/0oooo002I0?ooo`030000003oool0oooo08l0oooo00<000000?ooo`3oool0o`3oool[0?oo
o`00V@3oool00`000000oooo0?ooo`2?0?ooo`030000003oool0oooo0?l0oooo:`3oool009T0oooo
00<000000?ooo`3oool0S`3oool00`000000oooo0?ooo`3o0?ooob/0oooo002H0?ooo`030000003o
ool0oooo0900oooo00<000000?ooo`3oool0o`3oool[0?ooo`00V03oool00`000000oooo0?ooo`2@
0?ooo`030000003oool0oooo0?l0oooo:`3oool009P0oooo00<000000?ooo`3oool0T03oool00`00
0000oooo0?ooo`3o0?ooob/0oooo002H0?ooo`030000003oool0oooo0900oooo00<000000?ooo`3o
ool0o`3oool[0?ooo`00V03oool00`000000oooo0?ooo`2@0?ooo`<00000o`3oool[0?ooo`00V03o
ool00`000000oooo0?ooo`2@0?ooo`030000003oool0oooo0?l0oooo:`3oool009L0oooo00<00000
0?ooo`3oool0T@3oool00`000000oooo0?ooo`3o0?ooob/0oooo002G0?ooo`030000003oool0oooo
0940oooo00<000000?ooo`3oool0o`3oool[0?ooo`00U`3oool00`000000oooo0?ooo`2A0?ooo`03
0000003oool0oooo0?l0oooo:`3oool009L0oooo00<000000?ooo`3oool0T@3oool00`000000oooo
0?ooo`3o0?ooob/0oooo002G0?ooo`030000003oool0oooo0940oooo00<000000?ooo`3oool0o`3o
ool[0?ooo`00U`3oool00`000000oooo0?ooo`2A0?ooo`030000003oool0oooo0?l0oooo:`3oool0
09H0oooo00<000000?ooo`3oool0TP3oool00`000000oooo0?ooo`3o0?ooob/0oooo002F0?ooo`03
0000003oool0oooo0980oooo00<000000?ooo`3oool0o`3oool[0?ooo`00UP3oool00`000000oooo
0?ooo`200?ooo`D000000P3oool2000000T0oooo00<000000?ooo`3oool0o`3oool[0?ooo`00UP3o
ool00`000000oooo0?ooo`220?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo
0?ooo`060?ooo`030000003oool0oooo0?l0oooo:`3oool009H0oooo00<000000?ooo`3oool0PP3o
ool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool01P3oool500000?l0oooo
:@3oool009H0oooo00<000000?ooo`3oool0PP3oool01@000000oooo0?ooo`3oool000000080oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`3o0?ooob/0oooo002E0?ooo`030000003o
ool0oooo08<0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00H0oooo
00<000000?ooo`3oool0o`3oool[0?ooo`00U@3oool00`000000oooo0?ooo`220?ooo`800000103o
ool2000000T0oooo00<000000?ooo`3oool0o`3oool[0?ooo`00U@3oool00`000000oooo0?ooo`2C
0?ooo`030000003oool0oooo0?l0oooo:`3oool009D0oooo00<000000?ooo`3oool0T`3oool00`00
0000oooo0?ooo`3o0?ooob/0oooo0000\
\>"],
  ImageRangeCache->{{{0, 599}, {369.813, 0}} -> {-3.15334, -5.32034, \
0.0105287, 0.0420397}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<G:\Robert\Vorlesungen\Variationsrechnung\Pr\[ADoubleDot]\
sentation\extremwertPunkte.png\>", extremwertPunkte, \ 
      ImageSize \[Rule] 400]\)], "Input"],

Cell[BoxData[
    RowBox[{\(StringForm::"sfr"\), \(\(:\)\(\ \)\), "\<\"Item \\!\\(2\\) \
requested in \\\"\\!\\(\[LeftSkeleton] 185 \[RightSkeleton]\\)\\\" out of \
range; \\!\\(1\\) items available. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"StringForm::sfr\\\"]\\)\"\>"}]], \
"Message"],

Cell[BoxData[
    RowBox[{\(Export::"image"\), \(\(:\)\(\ \)\), "\<\"Value of option \
\\!\\(400\\\\ pt\\) -> `2` is not a list of two numbers or Automatic. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"Export::image\\\"]\\)\"\>"}]], \
"Message"],

Cell[BoxData[
    RowBox[{\(Export::"format"\), \(\(:\)\(\ \)\), "\<\"\\!\\(ImageSize \
\[Rule] \\(\\(400\\\\ pt\\)\\)\\) is not a recognized Export format. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"Export::format\\\"]\\)\"\>"}]], \
"Message"],

Cell[BoxData[
    RowBox[{"Export", "[", 
      RowBox[{"\<\"G:\\\\Robert\\\\Vorlesungen\\\\Variationsrechnung\\\\Pr\
\[ADoubleDot]sentation\\\\extremwertPunkte.png\"\>", ",", 
        TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
          False,
          Editable->False], ",", \(ImageSize \[Rule] 400\ pt\)}], 
      "]"}]], "Output"]
}, Open  ]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[{
    \(f1[x_] := x\), "\[IndentingNewLine]", 
    \(f2[x_] := x^2\), "\[IndentingNewLine]", 
    \(f3[x_] := x^3\), "\[IndentingNewLine]", 
    \(f4[x_] := x^4\), "\[IndentingNewLine]", 
    \(g1[x_] := \(-\((x - 1)\)^6\) + 
        1\[IndentingNewLine]\), "\[IndentingNewLine]", 
    \(fontSize = 26\)}], "Input"],

Cell[BoxData[
    \(26\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"kurven01", "=", 
      RowBox[{"Plot", "[", 
        RowBox[{\({g1[x], f1[x], \ f3[x]}\), ",", \({x, 0, 1}\), ",", 
          RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"{", 
              RowBox[{
                FormBox["Thickness",
                  "TraditionalForm"], "[", "0.006", "]"}], "}"}]}], ",", 
          RowBox[{"PlotStyle", "\[Rule]", " ", 
            RowBox[{"{", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{
                      StyleBox["RGBColor",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      RowBox[{
                        StyleBox["1",
                          "MR"], 
                        StyleBox[",",
                          "MR"], " ", "0", 
                        StyleBox[",",
                          "MR"], " ", "0"}], 
                      StyleBox["]",
                        "MR"]}], 
                    StyleBox[",",
                      "MR"], 
                    RowBox[{
                      FormBox["Thickness",
                        "TraditionalForm"], "[", "0.006", "]"}]}], 
                  StyleBox["}",
                    "MR"]}], 
                StyleBox[",",
                  "MR"], 
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{
                      StyleBox["RGBColor",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      RowBox[{
                        StyleBox["0",
                          "MR"], 
                        StyleBox[",",
                          "MR"], " ", "0", 
                        StyleBox[",",
                          "MR"], 
                        StyleBox["0",
                          "MR"]}], 
                      StyleBox["]",
                        "MR"]}], 
                    StyleBox[",",
                      "MR"], 
                    RowBox[{
                      FormBox["Thickness",
                        "TraditionalForm"], "[", "0.006", "]"}]}], 
                  StyleBox["}",
                    "MR"]}], 
                StyleBox[",",
                  "MR"], 
                StyleBox[
                  RowBox[{"{", 
                    RowBox[{\(RGBColor[0, 0, 1]\), ",", 
                      RowBox[{
                        FormBox["Thickness",
                          "TraditionalForm"], "[", "0.006", "]"}]}], "}"}],
                  "MR"], 
                StyleBox[",",
                  "MR"]}], "}"}]}], ",", " ", \(ImageSize \[Rule] 400\), ",", 
          " ", \(AspectRatio \[Rule] 0.8\), 
          ",", \(TextStyle \[Rule] {FontFamily \[Rule] "\<Times\>", 
              FontSize \[Rule] fontSize}\)}], "]"}]}]], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .8 
%%ImageSize: 400 320 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0190476 0.761905 [
[.21429 .00655 -18.3125 -31.75 ]
[.21429 .00655 18.3125 0 ]
[.40476 .00655 -18.3125 -31.75 ]
[.40476 .00655 18.3125 0 ]
[.59524 .00655 -18.3125 -31.75 ]
[.59524 .00655 18.3125 0 ]
[.78571 .00655 -18.3125 -31.75 ]
[.78571 .00655 18.3125 0 ]
[.97619 .00655 -8.53125 -31.75 ]
[.97619 .00655 8.53125 0 ]
[.01131 .17143 -36.625 -15.875 ]
[.01131 .17143 0 15.875 ]
[.01131 .32381 -36.625 -15.875 ]
[.01131 .32381 0 15.875 ]
[.01131 .47619 -36.625 -15.875 ]
[.01131 .47619 0 15.875 ]
[.01131 .62857 -36.625 -15.875 ]
[.01131 .62857 0 15.875 ]
[.01131 .78095 -17.0625 -15.875 ]
[.01131 .78095 0 15.875 ]
[ -0.003 -0.003 0 0 ]
[ 1.003 .803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01905 m
.21429 .0253 L
s
gsave
.21429 .00655 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
1.000 setlinewidth
grestore
.40476 .01905 m
.40476 .0253 L
s
gsave
.40476 .00655 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
1.000 setlinewidth
grestore
.59524 .01905 m
.59524 .0253 L
s
gsave
.59524 .00655 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
1.000 setlinewidth
grestore
.78571 .01905 m
.78571 .0253 L
s
gsave
.78571 .00655 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
1.000 setlinewidth
grestore
.97619 .01905 m
.97619 .0253 L
s
gsave
.97619 .00655 -69.5313 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.125 Mabswid
.07143 .01905 m
.07143 .0228 L
s
.11905 .01905 m
.11905 .0228 L
s
.16667 .01905 m
.16667 .0228 L
s
.2619 .01905 m
.2619 .0228 L
s
.30952 .01905 m
.30952 .0228 L
s
.35714 .01905 m
.35714 .0228 L
s
.45238 .01905 m
.45238 .0228 L
s
.5 .01905 m
.5 .0228 L
s
.54762 .01905 m
.54762 .0228 L
s
.64286 .01905 m
.64286 .0228 L
s
.69048 .01905 m
.69048 .0228 L
s
.7381 .01905 m
.7381 .0228 L
s
.83333 .01905 m
.83333 .0228 L
s
.88095 .01905 m
.88095 .0228 L
s
.92857 .01905 m
.92857 .0228 L
s
.006 w
0 .01905 m
1 .01905 L
s
.25 Mabswid
.02381 .17143 m
.03006 .17143 L
s
gsave
.01131 .17143 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
1.000 setlinewidth
grestore
.02381 .32381 m
.03006 .32381 L
s
gsave
.01131 .32381 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
1.000 setlinewidth
grestore
.02381 .47619 m
.03006 .47619 L
s
gsave
.01131 .47619 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
1.000 setlinewidth
grestore
.02381 .62857 m
.03006 .62857 L
s
gsave
.01131 .62857 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
1.000 setlinewidth
grestore
.02381 .78095 m
.03006 .78095 L
s
gsave
.01131 .78095 -78.0625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.125 Mabswid
.02381 .05714 m
.02756 .05714 L
s
.02381 .09524 m
.02756 .09524 L
s
.02381 .13333 m
.02756 .13333 L
s
.02381 .20952 m
.02756 .20952 L
s
.02381 .24762 m
.02756 .24762 L
s
.02381 .28571 m
.02756 .28571 L
s
.02381 .3619 m
.02756 .3619 L
s
.02381 .4 m
.02756 .4 L
s
.02381 .4381 m
.02756 .4381 L
s
.02381 .51429 m
.02756 .51429 L
s
.02381 .55238 m
.02756 .55238 L
s
.02381 .59048 m
.02756 .59048 L
s
.02381 .66667 m
.02756 .66667 L
s
.02381 .70476 m
.02756 .70476 L
s
.02381 .74286 m
.02756 .74286 L
s
.006 w
.02381 0 m
.02381 .8 L
s
0 0 m
1 0 L
1 .8 L
0 .8 L
closepath
clip
newpath
1 0 0 r
.02381 .01905 m
.06244 .18668 L
.10458 .33327 L
.14415 .44219 L
.18221 .52515 L
.22272 .59412 L
.26171 .64513 L
.30316 .68605 L
.34309 .7152 L
.3815 .73579 L
.40095 .74396 L
.42237 .75149 L
.46172 .76202 L
.48113 .76592 L
.502 .76935 L
.52171 .77196 L
.54323 .77423 L
.56382 .77593 L
.58294 .77718 L
.60346 .77821 L
.62207 .77894 L
.64131 .77951 L
.66213 .77997 L
.68207 .78029 L
.69224 .78042 L
.70314 .78053 L
.71341 .78062 L
.72277 .78068 L
.74111 .78078 L
.75102 .78082 L
.76019 .78085 L
.7709 .78088 L
.78095 .7809 L
.78994 .78091 L
.79962 .78092 L
.81037 .78093 L
.82022 .78094 L
.83002 .78094 L
.83914 .78095 L
.84915 .78095 L
.85475 .78095 L
.85984 .78095 L
.86469 .78095 L
.86983 .78095 L
.87426 .78095 L
.87903 .78095 L
.88415 .78095 L
.88893 .78095 L
.89462 .78095 L
.89983 .78095 L
Mistroke
.90461 .78095 L
.90723 .78095 L
.9097 .78095 L
.91201 .78095 L
.9145 .78095 L
.91885 .78095 L
.92136 .78095 L
.92411 .78095 L
.92698 .78095 L
.92966 .78095 L
.93217 .78095 L
.93445 .78095 L
.93709 .78095 L
.93959 .78095 L
.94185 .78095 L
.94398 .78095 L
.94631 .78095 L
.94762 .78095 L
.94882 .78095 L
.94992 .78095 L
.9511 .78095 L
.95239 .78095 L
.95359 .78095 L
.95495 .78095 L
.95622 .78095 L
.95737 .78095 L
.95861 .78095 L
.95971 .78095 L
.96073 .78095 L
.96185 .78095 L
.96306 .78095 L
.96432 .78095 L
.96552 .78095 L
.96659 .78095 L
.96776 .78095 L
.96877 .78095 L
.96988 .78095 L
.97105 .78095 L
.97214 .78095 L
.97316 .78095 L
.97409 .78095 L
.97511 .78095 L
.97619 .78095 L
Mfstroke
0 0 0 r
.02381 .01905 m
.06244 .04996 L
.10458 .08366 L
.14415 .11532 L
.18221 .14577 L
.22272 .17817 L
.26171 .20937 L
.30316 .24252 L
.34309 .27447 L
.3815 .3052 L
.42237 .33789 L
.46172 .36937 L
.49955 .39964 L
.53984 .43187 L
.57861 .46289 L
.61984 .49587 L
.65954 .52764 L
.69774 .55819 L
.73838 .59071 L
.77751 .62201 L
.81909 .65528 L
.85916 .68733 L
.89771 .71817 L
.93871 .75097 L
.97619 .78095 L
s
0 0 1 r
.02381 .01905 m
.02499 .01905 L
.02605 .01905 L
.02729 .01905 L
.02846 .01905 L
.02954 .01905 L
.03053 .01905 L
.03163 .01905 L
.03279 .01905 L
.03395 .01905 L
.0352 .01905 L
.03746 .01905 L
.03884 .01905 L
.04016 .01905 L
.04262 .01905 L
.045 .01906 L
.04753 .01906 L
.0521 .01907 L
.05489 .01907 L
.05752 .01908 L
.06244 .0191 L
.06757 .01912 L
.07299 .01915 L
.08269 .01923 L
.09312 .01934 L
.10458 .01951 L
.11478 .01971 L
.12409 .01994 L
.145 .02062 L
.16409 .02148 L
.18485 .02273 L
.20462 .02426 L
.22563 .0263 L
.26338 .03118 L
.30359 .03836 L
.34227 .04753 L
.38341 .06006 L
.42304 .07517 L
.46115 .09282 L
.50171 .11531 L
.54075 .14089 L
.58225 .17265 L
.62223 .20806 L
.6607 .2469 L
.70162 .2937 L
.74102 .34444 L
.77891 .39878 L
.81925 .46295 L
.85807 .53117 L
.89935 .61101 L
Mistroke
.93911 .69537 L
.97619 .78095 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{400, 320},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0001@2000`400?l00000o`00003oo`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00IP3oool4000000L0oooo0P00
00040?ooo`X00000:03oool4000000L0oooo0P00000;0?ooo`800000:@3oool4000000L0oooo0P00
00070?ooo`D00000:P3oool4000000L0oooo0P0000070?ooo`D00000<`3oool6000000l0oooo001U
0?ooo`8000000`3oool2000000D0oooo0P0000050?ooo`T000009`3oool2000000<0oooo0P000005
0?ooo`8000002`3oool2000002P0oooo0P0000030?ooo`8000001@3oool2000000H0oooo0P000003
0?ooo`800000:03oool2000000<0oooo0P0000050?ooo`8000001@3oool3000000@0oooo0P00000c
0?ooo`8000004@3oool006D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00@0oooo0P00000V0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0403oool2000002P0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0:0?oo
o`8000001@3oool2000002L0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`090?oo
o`<000001P3oool200000380oooo0P00000A0?ooo`00I03oool2000000D0oooo0P00000=0?ooo`03
0000003oool0oooo02X0oooo0P0000050?ooo`8000004@3oool2000002L0oooo0P0000050?ooo`80
00002`3oool2000000H0oooo00<000000?ooo`3oool0903oool2000000D0oooo0P00000:0?ooo`80
00001`3oool200000380oooo0P00000A0?ooo`00I03oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00P0oooo2`00000U0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
203oool2000000L0oooo0P00000U0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
203oool2000000L0oooo0P00000b0?ooo`8000004@3oool006<0oooo0P0000070?ooo`8000003P3o
ool00`000000oooo0?ooo`0W0?ooo`8000001`3oool2000000T0oooo00<000000?ooo`3oool0103o
ool2000002H0oooo0P0000070?ooo`8000002@3oool2000000L0oooo0P00000T0?ooo`8000001`3o
ool2000000T0oooo0P0000060?ooo`<00000<P3oool200000140oooo001S0?ooo`8000001`3oool2
000000l0oooo00<000000?ooo`3oool09P3oool2000000L0oooo0P00000:0?ooo`030000003oool0
oooo00<0oooo0P00000V0?ooo`8000001`3oool2000000T0oooo0P0000070?ooo`800000903oool2
000000L0oooo0P00000:0?ooo`800000103oool3000003<0oooo0P00000A0?ooo`00H`3oool20000
00L0oooo0P00000?0?ooo`030000003oool0oooo02H0oooo0P0000070?ooo`8000002`3oool00`00
0000oooo0?ooo`020?ooo`8000009P3oool2000000L0oooo0P0000090?ooo`8000001`3oool20000
02@0oooo0P0000070?ooo`8000002`3oool010000000oooo0?ooo`3oool3000003@0oooo0P00000A
0?ooo`00H`3oool2000000L0oooo0P00000@0?ooo`030000003oool0oooo02D0oooo0P0000070?oo
o`8000002`3oool00`000000oooo0?ooo`020?ooo`8000009P3oool2000000L0oooo0P0000090?oo
o`8000001P3oool2000002D0oooo0P0000070?ooo`800000303oool5000003D0oooo0P00000A0?oo
o`00H`3oool2000000L0oooo0P00000A0?ooo`030000003oool0oooo02@0oooo0P0000070?ooo`80
0000303oool010000000oooo0?ooo`3oool2000002H0oooo0P0000070?ooo`8000002@3oool40000
00<0oooo0`00000U0?ooo`8000001`3oool2000000`0oooo1000000f0?ooo`8000004@3oool006<0
oooo0P0000070?ooo`8000004@3oool00`000000oooo0?ooo`0T0?ooo`8000001`3oool2000000d0
oooo00<000000?ooo`3oool00P00000V0?ooo`8000001`3oool2000000X0oooo0P0000000`3oool0
000000000002000002L0oooo0P0000070?ooo`8000002`3oool300000080oooo00<000000?ooo`3o
ool0<`3oool200000140oooo001S0?ooo`8000001`3oool200000140oooo0P00000U0?ooo`800000
1`3oool2000000d0oooo00<000000?ooo`3oool00P00000V0?ooo`8000001`3oool2000000X0oooo
0P00000/0?ooo`8000001`3oool2000000X0oooo0`0000040?ooo`800000<`3oool200000140oooo
001T0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`050?ooo`8000009P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00d0oooo00@0
00000?ooo`00000000009`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00X0oooo
0P00000/0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool3000000H0oooo
0P00000b0?ooo`8000004@3oool006@0oooo0P0000050?ooo`8000002P3oool00`000000oooo0?oo
o`050?ooo`8000009P3oool2000000D0oooo0P00000?0?ooo`040000003oool00000000002L0oooo
0P0000050?ooo`8000003@3oool2000002/0oooo0P0000050?ooo`8000002P3oool2000000L0oooo
0P00000b0?ooo`8000004@3oool006D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo0080oooo1000000W0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool03`3oool3000002P0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`0=0?ooo`800000:`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00T0oooo0P00
00070?ooo`800000<P3oool200000140oooo001U0?ooo`8000000`3oool2000000`0oooo2000000X
0?ooo`8000000`3oool200000180oooo0P00000X0?ooo`8000000`3oool200000100oooo0`00000Y
0?ooo`8000000`3oool2000000`0oooo0P0000050?ooo`800000<03oool500000140oooo001W0?oo
o`<00000403oool4000002`0oooo0`00000D0?ooo`800000:P3oool3000001@0oooo1000000X0?oo
o`<00000403oool6000003<0oooo0`00000A0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3o
oonA0?ooo`00o`3ooonA0?ooo`00;`3oool200000?l0ooooH03oool002l0oooo0P00003o0?ooof00
oooo000_0?ooo`800000o`3ooomP0?ooo`00;`3oool200000?l0ooooH03oool002l0oooo0P00003o
0?ooof00oooo000_0?ooo`800000o`3ooomP0?ooo`00;`3oool200000?l0ooooH03oool002L0oooo
2000000i0000ool00000800000090?ooo`009`3oool8000004P0003oo`00000A000000T0oooo000_
0?ooo`030000003o0000000000<00000<`3ooolF0000ocL0oooo00<000000?ooo`3oool0@03oool0
0`000000oooo0?ooo`100?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool03`3oool0
02l0oooo00@000000?l0003o0000oooo0`0000110?ooo`d0003oo`3oool=0?ooo`00;`3oool01@00
0000o`000?l0003o0000oooo00<00000A`3oool=0000ool0oooo1P3oool002l0oooo0P0000020?l0
0080oooo1000001;0?ooo`h0003ooP3oool002l0oooo0P0000020?l000<0oooo1000001A0?ooo`/0
003onP3oool002l0oooo0P0000020?l000D0oooo0`00001G0?ooo`L0003om`3oool002l0oooo0P00
00020?l000H0oooo1000001I0?ooo`L0003ol`3oool002l0oooo0P0000030?l000H0oooo1000001K
0?ooo`L0003ol03oool002l0oooo0P0000000`3oool0o`000?l000080?ooo`<00000GP3oool70000
on`0oooo000_0?ooo`80000000<0oooo0?l0003o00002@3oool300000600oooo1`000?oY0?ooo`00
;`3oool2000000030?ooo`3o0000o`0000X0oooo1000001R0?ooo`L0003oi@3oool002l0oooo0`00
00030?l000X0oooo1000001T0?ooo`L0003ohP3oool002l0oooo0P0000020?ooo`80o`00303oool3
000006L0oooo1`000?oN0?ooo`00;`3oool200000080oooo0P3o000=0?ooo`<00000J@3oool70000
om/0oooo000_0?ooo`8000000P3oool20?l000h0oooo1000001Z0?ooo`H0003of@3oool002l0oooo
0P0000020?ooo`80o`003`3oool4000006`0oooo1P000?oF0?ooo`00;`3oool200000080oooo0`3o
000@0?ooo`<00000K@3oool70000om<0oooo000_0?ooo`8000000`3oool20?l00140oooo0`00001_
0?ooo`H0003od@3oool002l0oooo0P0000030?ooo`80o`004P3oool400000700oooo1@000?o?0?oo
o`00;`3oool2000000<0oooo0P3o000C0?ooo`@00000L@3oool50000old0oooo000_0?ooo`800000
0`3oool30?l001@0oooo0`00001b0?ooo`H0003obP3oool002l0oooo0P0000040?ooo`80o`005@3o
ool400000780oooo1P000?o80?ooo`00;`3oool2000000@0oooo0P3o000F0?ooo`@00000M03oool5
0000olH0oooo000_0?ooo`800000103oool20?l001P0oooo0`00001e0?ooo`D0003oa03oool002l0
oooo0`0000030?ooo`80o`006@3oool3000007H0oooo10000?o30?ooo`00;`3oool2000000@0oooo
0`3o000I0?ooo`@00000MP3oool40000ol40oooo000_0?ooo`8000001@3oool20?l001X0oooo1000
001f0?ooo`D0003o_`3oool002l0oooo0P0000050?ooo`80o`00703oool3000007L0oooo1@000?nm
0?ooo`00;`3oool2000000D0oooo0P3o000M0?ooo`<00000N03oool40000ok`0oooo000_0?ooo`80
00001@3oool30?l001d0oooo1000001h0?ooo`@0003o^P3oool002l0oooo0P0000060?ooo`80o`00
7P3oool4000007P0oooo1@000?nh0?ooo`00;`3oool2000000H0oooo0P3o000P0?ooo`<00000N@3o
ool50000okH0oooo000_0?ooo`8000001P3oool20?l00240oooo0`00001j0?ooo`@0003o]@3oool0
02l0oooo0P0000060?ooo`80o`008P3oool4000007X0oooo10000?nc0?ooo`00;`3oool2000000H0
oooo0`3o000R0?ooo`@00000NP3oool40000ok80oooo000_0?ooo`8000001`3oool20?l002@0oooo
0`00001k0?ooo`@0003o/03oool002l0oooo0P0000070?ooo`80o`009@3oool3000007/0oooo1000
0?n_0?ooo`00;`3oool2000000L0oooo0P3o000V0?ooo`<00000O03oool40000ojd0oooo000_0?oo
o`<000001P3oool30?l002H0oooo0`00001l0?ooo`@0003o[03oool002l0oooo0P0000080?ooo`80
o`009`3oool4000007`0oooo10000?nZ0?ooo`00;`3oool2000000P0oooo0P3o000X0?ooo`@00000
O03oool40000ojT0oooo000_0?ooo`800000203oool20?l002X0oooo0`00001m0?ooo`@0003oY`3o
ool002l0oooo0P0000080?ooo`80o`00:`3oool3000007d0oooo10000?nV0?ooo`003@3oool40000
00L0oooo0P0000040?ooo`X000001`3oool2000000P0oooo0`3o000[0?ooo`@00000O@3oool30000
ojD0oooo000<0?ooo`8000000`3oool2000000D0oooo0P0000050?ooo`T000001`3oool2000000T0
oooo0P3o000/0?ooo`@00000O@3oool40000oj<0oooo000<0?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`040?ooo`8000001P3oool2000000T0oooo
0P3o000^0?ooo`<00000O@3oool40000oj80oooo000;0?ooo`8000001@3oool2000000d0oooo00<0
00000?ooo`3oool02`3oool2000000T0oooo0P3o000_0?ooo`@00000O@3oool40000oj00oooo000;
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0:
0?ooo`8000002@3oool30?l002l0oooo1000001m0?ooo`@0003oW`3oool000X0oooo0P0000070?oo
o`8000003P3oool00`000000oooo0?ooo`090?ooo`8000002P3oool20?l00340oooo1000001m0?oo
o`<0003oWP3oool000X0oooo0P0000070?ooo`8000003`3oool00`000000oooo0?ooo`080?ooo`80
00002P3oool20?l00380oooo1000001m0?ooo`@0003oW03oool000X0oooo0P0000070?ooo`800000
3`3oool00`000000oooo0?ooo`080?ooo`8000002P3oool20?l003@0oooo0`00001m0?ooo`@0003o
V`3oool000X0oooo0P0000070?ooo`800000403oool00`000000oooo0?ooo`070?ooo`@00000203o
ool20?l003D0oooo1000001m0?ooo`<0003oVP3oool000X0oooo0P0000070?ooo`8000004@3oool0
0`000000oooo0?ooo`060?ooo`8000002P3oool30?l003D0oooo1000001m0?ooo`<0003oV@3oool0
00X0oooo0P0000070?ooo`8000004@3oool00`000000oooo0?ooo`060?ooo`8000002`3oool20?l0
03L0oooo0`00001m0?ooo`<0003oV03oool000X0oooo0P0000070?ooo`8000004@3oool2000000L0
oooo0P00000;0?ooo`80o`00>03oool3000007d0oooo0`000?nG0?ooo`002`3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool2000000L0oooo
0P00000;0?ooo`80o`00>@3oool4000007`0oooo0`000?nF0?ooo`002`3oool2000000D0oooo0P00
000:0?ooo`030000003oool0oooo00D0oooo0P0000070?ooo`8000002`3oool30?l003T0oooo1000
001l0?ooo`<0003oU@3oool000`0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0:
0?ooo`030000003oool0oooo0080oooo100000070?ooo`800000303oool20?l003/0oooo0`00001l
0?ooo`@0003oT`3oool000`0oooo0P0000030?ooo`800000303oool8000000P0oooo0P00000<0?oo
o`80o`00?03oool3000007`0oooo10000?nB0?ooo`003P3oool300000100oooo1000000:0?ooo`80
0000303oool30?l003`0oooo0`00001m0?ooo`<0003oT@3oool002l0oooo0P00000=0?ooo`80o`00
?@3oool3000007d0oooo0`000?n@0?ooo`00;`3oool2000000d0oooo0P3o000n0?ooo`@00000O03o
ool30000ohl0oooo000_0?ooo`8000003@3oool20?l003l0oooo1000001l0?ooo`<0003oSP3oool0
02l0oooo0P00000=0?ooo`<0o`00@03oool3000007`0oooo0`000?n=0?ooo`00;`3oool3000000d0
oooo0P3o00110?ooo`<00000O03oool30000oh`0oooo000_0?ooo`8000003P3oool20?l00480oooo
0`00001l0?ooo`<0003oR`3oool002l0oooo0P00000>0?ooo`<0o`00@P3oool4000007/0oooo0`00
0?n:0?ooo`00;`3oool2000000l0oooo0P3o00130?ooo`@00000N`3oool30000ohT0oooo000_0?oo
o`8000003`3oool20?l004D0oooo0`00001k0?ooo`<0003oR03oool002l0oooo0P00000?0?ooo`80
o`00AP3oool3000007/0oooo0`000?n70?ooo`00;`3oool2000000l0oooo0`3o00160?ooo`@00000
NP3oool30000ohH0oooo000_0?ooo`800000403oool20?l004L0oooo1000001j0?ooo`<0003oQ@3o
ool002l0oooo0P00000@0?ooo`80o`00B@3oool3000007X0oooo0`000?n40?ooo`00;`3oool20000
0100oooo0`3o00190?ooo`<00000NP3oool30000oh<0oooo000_0?ooo`8000004@3oool20?l004X0
oooo1000001i0?ooo`<0003oPP3oool002l0oooo0P00000A0?ooo`80o`00B`3oool4000007T0oooo
0`000?n10?ooo`00;`3oool200000140oooo0P3o001=0?ooo`<00000N@3oool30000oh00oooo000_
0?ooo`8000004@3oool30?l004d0oooo1000001h0?ooo`<0003oO`3oool002l0oooo0`00000A0?oo
o`80o`00CP3oool4000007P0oooo0`000?mn0?ooo`00;`3oool200000180oooo0P3o001@0?ooo`<0
0000N03oool20000ogh0oooo000_0?ooo`8000004P3oool30?l00500oooo0`00001h0?ooo`80003o
O@3oool002l0oooo0P00000C0?ooo`80o`00D@3oool4000007H0oooo0`000?ml0?ooo`00;`3oool2
000001<0oooo0P3o001B0?ooo`@00000MP3oool30000og/0oooo000_0?ooo`8000004`3oool20?l0
05@0oooo0`00001f0?ooo`<0003oNP3oool002l0oooo0P00000C0?ooo`<0o`00E03oool3000007H0
oooo0`000?mi0?ooo`00;`3oool2000001@0oooo0P3o001E0?ooo`@00000M@3oool20000ogT0oooo
000_0?ooo`800000503oool20?l005H0oooo1000001e0?ooo`80003oN03oool002l0oooo0P00000D
0?ooo`<0o`00E`3oool3000007@0oooo0`000?mg0?ooo`00;`3oool2000001D0oooo0P3o001H0?oo
o`<00000M03oool30000ogH0oooo000_0?ooo`8000005@3oool20?l005T0oooo1000001c0?ooo`<0
003oM@3oool002l0oooo0P00000E0?ooo`80o`00FP3oool4000007<0oooo0`000?md0?ooo`00;`3o
ool3000001@0oooo0`3o001K0?ooo`<00000L`3oool20000og@0oooo000_0?ooo`8000005P3oool2
0?l005`0oooo0`00001c0?ooo`80003oL`3oool002l0oooo0P00000F0?ooo`80o`00G@3oool30000
0780oooo0`000?mb0?ooo`00;`3oool2000001H0oooo0`3o001M0?ooo`<00000LP3oool20000og80
oooo000_0?ooo`8000005`3oool20?l005h0oooo1000001a0?ooo`80003oL@3oool002l0oooo0P00
000G0?ooo`80o`00G`3oool400000740oooo0P000?m`0?ooo`003@3oool4000000L0oooo0P00000;
0?ooo`800000203oool2000001L0oooo0P3o001Q0?ooo`<00000L@3oool20000ofl0oooo000<0?oo
o`8000000`3oool2000000D0oooo0P00000;0?ooo`800000203oool2000001L0oooo0`3o001Q0?oo
o`<00000L@3oool00`000?l0oooo0?ooo`1]0?ooo`00303oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo0100oooo0P0000080?ooo`800000603oool20?l00680oooo1000001_0?ooo`80
003oKP3oool000/0oooo0P0000050?ooo`8000004@3oool2000000P0oooo0P00000H0?ooo`80o`00
H`3oool4000006l0oooo0P000?m]0?ooo`002`3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00P0oooo2`0000060?ooo`800000603oool30?l006@0oooo0`00001_0?ooo`80003oK03o
ool000X0oooo0P0000070?ooo`8000002@3oool00`000000oooo0?ooo`040?ooo`800000203oool2
000001T0oooo0P3o001U0?ooo`@00000KP3oool20000of/0oooo000:0?ooo`8000001`3oool20000
00X0oooo00<000000?ooo`3oool00`3oool2000000P0oooo0P00000I0?ooo`80o`00IP3oool40000
06h0oooo00<0003o0?ooo`3oool0J@3oool000X0oooo0P0000070?ooo`8000002`3oool00`000000
oooo0?ooo`020?ooo`800000203oool4000001L0oooo0P3o001X0?ooo`@00000K03oool20000ofX0
oooo000:0?ooo`8000001`3oool2000000/0oooo00<000000?ooo`3oool00P3oool2000000P0oooo
0P00000I0?ooo`<0o`00J03oool4000006`0oooo0P000?mY0?ooo`002P3oool2000000L0oooo0P00
000<0?ooo`040000003oool0oooo0?ooo`800000203oool2000001X0oooo0P3o001Z0?ooo`<00000
K03oool20000ofP0oooo000:0?ooo`8000001`3oool2000000d0oooo00<000000?ooo`3oool00P00
00080?ooo`8000006P3oool20?l006/0oooo1000001[0?ooo`030000o`3oool0oooo06H0oooo000:
0?ooo`8000001`3oool2000000d0oooo00<000000?ooo`3oool00P0000080?ooo`8000006P3oool3
0?l006/0oooo1000001Z0?ooo`80003oI`3oool000/0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`0=0?ooo`040000003oool00000000000P0oooo0P00000K0?ooo`80o`00K@3oool3
000006X0oooo0P000?mV0?ooo`002`3oool2000000D0oooo0P00000?0?ooo`040000003oool00000
000000P0oooo0P00000K0?ooo`80o`00KP3oool3000006X0oooo0P000?mU0?ooo`00303oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo00l0oooo0`0000080?ooo`8000006`3oool30?l0
06h0oooo1000001Y0?ooo`80003oI03oool000`0oooo0P0000030?ooo`8000004P3oool2000000P0
oooo0P00000L0?ooo`80o`00K`3oool4000006T0oooo00<0003o0?ooo`3oool0HP3oool000h0oooo
0`00000D0?ooo`800000203oool2000001`0oooo0`3o001`0?ooo`<00000J03oool20000of<0oooo
000_0?ooo`8000007@3oool20?l00740oooo0`00001X0?ooo`80003oHP3oool002l0oooo0P00000M
0?ooo`80o`00LP3oool3000006P0oooo0P000?mQ0?ooo`00;`3oool2000001d0oooo0`3o001b0?oo
o`<00000J03oool00`000?l0oooo0?ooo`1O0?ooo`00;`3oool2000001h0oooo0P3o001c0?ooo`@0
0000IP3oool20000of00oooo000_0?ooo`<000007@3oool20?l007@0oooo1000001V0?ooo`80003o
G`3oool002l0oooo0P00000N0?ooo`<0o`00M@3oool3000006H0oooo0P000?mN0?ooo`00;`3oool2
000001l0oooo0P3o001f0?ooo`<00000IP3oool00`000?l0oooo0?ooo`1L0?ooo`00;`3oool20000
01l0oooo0P3o001g0?ooo`@00000I03oool20000oed0oooo000_0?ooo`8000007`3oool30?l007L0
oooo1000001T0?ooo`80003oG03oool002l0oooo0P00000P0?ooo`80o`00N@3oool3000006@0oooo
00<0003o0?ooo`3oool0FP3oool002l0oooo0P00000P0?ooo`<0o`00N@3oool3000006<0oooo0P00
0?mK0?ooo`00;`3oool200000240oooo0P3o001j0?ooo`@00000HP3oool20000oeX0oooo000_0?oo
o`8000008@3oool20?l007/0oooo1000001R0?ooo`80003oF@3oool002l0oooo0P00000Q0?ooo`<0
o`00O03oool300000680oooo00<0003o0?ooo`3oool0E`3oool002l0oooo0P00000R0?ooo`80o`00
O@3oool300000640oooo0P000?mH0?ooo`00;`3oool200000280oooo0P3o001n0?ooo`@00000H03o
ool20000oeL0oooo000_0?ooo`8000008P3oool30?l007h0oooo1000001P0?ooo`80003oEP3oool0
02l0oooo0`00000R0?ooo`80o`00P03oool300000600oooo00<0003o0?ooo`3oool0E03oool002l0
oooo0P00000S0?ooo`<0o`00P03oool4000005h0oooo0P000?mE0?ooo`00;`3oool2000002@0oooo
0P3o00210?ooo`@00000GP3oool20000oe@0oooo000_0?ooo`800000903oool20?l008<0oooo0`00
001N0?ooo`030000o`3oool0oooo0580oooo000_0?ooo`800000903oool30?l008<0oooo0`00001M
0?ooo`80003oD`3oool002l0oooo0P00000U0?ooo`80o`00Q03oool4000005`0oooo00<0003o0?oo
o`3oool0D@3oool002l0oooo0P00000U0?ooo`80o`00Q@3oool4000005/0oooo0P000?mB0?ooo`00
;`3oool2000002D0oooo0`3o00260?ooo`<00000F`3oool20000oe40oooo000_0?ooo`8000009P3o
ool20?l008L0oooo0`00001K0?ooo`030000o`3oool0oooo04l0oooo000_0?ooo`8000009P3oool2
0?l008P0oooo1000001I0?ooo`80003oD03oool002l0oooo0P00000W0?ooo`80o`00R03oool40000
05T0oooo0P000?m?0?ooo`00;`3oool2000002L0oooo0P3o002:0?ooo`<00000F@3oool00`000?l0
oooo0?ooo`1=0?ooo`00;`3oool2000002L0oooo0`3o002:0?ooo`<00000F03oool20000odh0oooo
000_0?ooo`<000009`3oool20?l008/0oooo1000001G0?ooo`80003oC@3oool002l0oooo0P00000X
0?ooo`80o`00S03oool4000005L0oooo00<0003o0?ooo`3oool0B`3oool002l0oooo0P00000Y0?oo
o`030?l0003oool0oooo08`0oooo0`00001F0?ooo`80003oC03oool002l0oooo0P00000Y0?ooo`80
o`00SP3oool3000005H0oooo00<0003o0?ooo`3oool0BP3oool002l0oooo0P00000Z0?ooo`030?l0
003oool0oooo08d0oooo0`00001E0?ooo`80003oB`3oool002l0oooo0P00000Z0?ooo`80o`00S`3o
ool3000005D0oooo0P000?m:0?ooo`003@3oool4000000L0oooo0P0000070?ooo`D000002@3oool2
000002/0oooo00<0o`000?ooo`3oool0SP3oool4000005@0oooo00<0003o0?ooo`3oool0B03oool0
00`0oooo0P0000030?ooo`8000001@3oool2000000H0oooo0P0000030?ooo`800000203oool20000
02/0oooo00<0o`000?ooo`3oool0S`3oool4000005<0oooo0P000?m90?ooo`00303oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00X0oooo0P0000050?ooo`8000001`3oool2000002/0
oooo0P3o002B0?ooo`<00000D`3oool20000odP0oooo000;0?ooo`8000001@3oool2000000/0oooo
0P0000060?ooo`030000003oool0oooo00D0oooo0P00000/0?ooo`030?l0003oool0oooo0940oooo
0`00001C0?ooo`030000o`3oool0oooo04H0oooo000;0?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool0203oool2000000L0oooo0P0000060?ooo`800000;03oool20?l009<0oooo0`00
001B0?ooo`80003oA`3oool000X0oooo0P0000070?ooo`8000002@3oool2000000L0oooo0P000006
0?ooo`800000;@3oool00`3o0000oooo0?ooo`2B0?ooo`@00000D@3oool00`000?l0oooo0?ooo`15
0?ooo`002P3oool2000000L0oooo0P0000090?ooo`8000001`3oool2000000H0oooo0P00000]0?oo
o`80o`00U03oool400000500oooo0P000?m60?ooo`002P3oool2000000L0oooo0P0000090?ooo`80
00001`3oool2000000H0oooo0P00000^0?ooo`030?l0003oool0oooo09@0oooo0`00001@0?ooo`03
0000o`3oool0oooo04@0oooo000:0?ooo`8000001`3oool2000000T0oooo0P0000060?ooo`800000
1`3oool4000002`0oooo0P3o002F0?ooo`<00000C`3oool20000odD0oooo000:0?ooo`8000001`3o
ool2000000T0oooo100000030?ooo`<000001`3oool2000002l0oooo00<0o`000?ooo`3oool0U@3o
ool4000004h0oooo0P000?m40?ooo`002P3oool2000000L0oooo0P00000:0?ooo`80000000<0oooo
0000000000000P0000090?ooo`800000;`3oool00`3o0000oooo0?ooo`2F0?ooo`@00000CP3oool0
0`000?l0oooo0?ooo`120?ooo`002P3oool2000000L0oooo0P00000:0?ooo`8000003P3oool20000
02l0oooo0P3o002I0?ooo`<00000C@3oool20000od<0oooo000;0?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool02P3oool2000000d0oooo0P00000`0?ooo`030?l0003oool0oooo09P0
oooo0`00001=0?ooo`030000o`3oool0oooo0440oooo000;0?ooo`8000001@3oool2000000d0oooo
0P00000<0?ooo`800000<03oool20?l009X0oooo1000001;0?ooo`80003o@P3oool000`0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`0=0?ooo`8000002`3oool200000340oooo00<0
o`000?ooo`3oool0V@3oool4000004/0oooo00<0003o0?ooo`3oool0@03oool000`0oooo0P000003
0?ooo`800000403oool3000000T0oooo0P00000a0?ooo`80o`00W03oool3000004X0oooo0P000?m1
0?ooo`003P3oool3000001@0oooo100000060?ooo`800000<P3oool00`3o0000oooo0?ooo`2K0?oo
o`@00000B@3oool00`000?l0oooo0?ooo`0o0?ooo`00;`3oool200000380oooo0P3o002M0?ooo`@0
0000B03oool20000od00oooo000_0?ooo`800000<`3oool00`3o0000oooo0?ooo`2M0?ooo`<00000
B03oool00`000?l0oooo0?ooo`0n0?ooo`00;`3oool2000003<0oooo0P3o002O0?ooo`<00000A`3o
ool20000ocl0oooo000_0?ooo`800000=03oool00`3o0000oooo0?ooo`2N0?ooo`@00000AP3oool0
0`000?l0oooo0?ooo`0m0?ooo`00;`3oool3000003<0oooo00<0o`000?ooo`3oool0W`3oool40000
04D0oooo0P000?ln0?ooo`00;`3oool2000003@0oooo0P3o002R0?ooo`<00000A@3oool20000ocd0
oooo000_0?ooo`800000=@3oool00`3o0000oooo0?ooo`2Q0?ooo`<00000A@3oool00`000?l0oooo
0?ooo`0k0?ooo`00;`3oool2000003D0oooo0P3o002S0?ooo`@00000@`3oool20000oc`0oooo000_
0?ooo`800000=P3oool00`3o0000oooo0?ooo`2R0?ooo`@00000@`3oool00`000?l0oooo0?ooo`0j
0?ooo`00;`3oool2000003H0oooo0P3o002U0?ooo`<00000@P3oool20000oc/0oooo000_0?ooo`80
0000=`3oool20?l00:D0oooo0`0000120?ooo`030000o`3oool0oooo03T0oooo000_0?ooo`800000
>03oool00`3o0000oooo0?ooo`2T0?ooo`@00000@03oool20000ocX0oooo000_0?ooo`800000>03o
ool20?l00:H0oooo100000100?ooo`030000o`3oool0oooo03P0oooo000_0?ooo`800000>@3oool0
0`3o0000oooo0?ooo`2V0?ooo`<00000?`3oool20000ocT0oooo000_0?ooo`800000>@3oool20?l0
0:P0oooo0`00000o0?ooo`030000o`3oool0oooo03L0oooo000_0?ooo`800000>P3oool20?l00:P0
oooo0`00000n0?ooo`80003o>03oool002l0oooo0P00000k0?ooo`030?l0003oool0oooo0:L0oooo
0`00000n0?ooo`030000o`3oool0oooo03H0oooo000_0?ooo`800000>`3oool20?l00:T0oooo1000
000l0?ooo`80003o=`3oool002l0oooo0`00000k0?ooo`80o`00Z@3oool4000003`0oooo0P000?lf
0?ooo`00;`3oool2000003d0oooo00<0o`000?ooo`3oool0Z@3oool3000003`0oooo00<0003o0?oo
o`3oool0=03oool002l0oooo0P00000m0?ooo`80o`00Z`3oool3000003/0oooo0P000?le0?ooo`00
;`3oool2000003h0oooo00<0o`000?ooo`3oool0ZP3oool4000003X0oooo00<0003o0?ooo`3oool0
<`3oool002l0oooo0P00000n0?ooo`80o`00[03oool4000003T0oooo0P000?ld0?ooo`00;`3oool2
000003l0oooo0P3o002]0?ooo`<00000>@3oool00`000?l0oooo0?ooo`0b0?ooo`00;`3oool20000
0400oooo00<0o`000?ooo`3oool0[03oool3000003P0oooo0P000?lc0?ooo`00;`3oool200000400
oooo0P3o002^0?ooo`@00000=`3oool00`000?l0oooo0?ooo`0a0?ooo`00;`3oool200000440oooo
0P3o002^0?ooo`@00000=P3oool20000oc80oooo000_0?ooo`800000@P3oool00`3o0000oooo0?oo
o`2^0?ooo`<00000=P3oool00`000?l0oooo0?ooo`0`0?ooo`00;`3oool200000480oooo0P3o002`
0?ooo`<00000=@3oool20000oc40oooo000_0?ooo`800000@`3oool00`3o0000oooo0?ooo`2_0?oo
o`@00000=03oool00`000?l0oooo0?ooo`0_0?ooo`00;`3oool2000004<0oooo0P3o002a0?ooo`@0
0000<`3oool20000oc00oooo000_0?ooo`<00000@`3oool20?l00;80oooo0`00000c0?ooo`80003o
;`3oool002l0oooo0P0000150?ooo`030?l0003oool0oooo0;40oooo1000000b0?ooo`030000o`3o
ool0oooo02d0oooo000_0?ooo`800000A@3oool20?l00;<0oooo1000000a0?ooo`80003o;P3oool0
02l0oooo0P0000160?ooo`80o`00]03oool300000340oooo00<0003o0?ooo`3oool0;03oool002l0
oooo0P0000170?ooo`80o`00]03oool300000300oooo0P000?l]0?ooo`00;`3oool2000004P0oooo
00<0o`000?ooo`3oool0/`3oool4000002l0oooo00<0003o0?ooo`3oool0:`3oool000d0oooo1000
00070?ooo`8000001`3oool5000000T0oooo0P0000180?ooo`80o`00]@3oool4000002h0oooo0P00
0?l/0?ooo`00303oool2000000<0oooo0P0000050?ooo`8000001@3oool3000000@0oooo0P000007
0?ooo`800000B@3oool20?l00;H0oooo0`00000^0?ooo`030000o`3oool0oooo02X0oooo000<0?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool02@3oool3000000H0oooo0P0000060?oo
o`800000BP3oool00`3o0000oooo0?ooo`2e0?ooo`<00000;@3oool20000ob/0oooo000;0?ooo`80
00001@3oool2000000X0oooo0P0000070?ooo`8000001P3oool2000004X0oooo0P3o002g0?ooo`@0
0000;03oool00`000?l0oooo0?ooo`0Y0?ooo`002`3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00P0oooo0P0000070?ooo`8000001P3oool2000004/0oooo0P3o002g0?ooo`@00000
:`3oool20000obX0oooo000:0?ooo`8000001`3oool2000000T0oooo0P0000060?ooo`<000001P3o
ool2000004`0oooo0P3o002h0?ooo`<00000:`3oool00`000?l0oooo0?ooo`0X0?ooo`002P3oool2
000000L0oooo0P00000:0?ooo`800000103oool3000000L0oooo0P00001=0?ooo`030?l0003oool0
oooo0;L0oooo0`00000Z0?ooo`80003o:@3oool000X0oooo0P0000070?ooo`8000002`3oool01000
0000oooo0?ooo`3oool3000000P0oooo1000001;0?ooo`80o`00^@3oool4000002T0oooo00<0003o
0?ooo`3oool09`3oool000X0oooo0P0000070?ooo`800000303oool5000000T0oooo0P00001>0?oo
o`80o`00^@3oool4000002P0oooo00<0003o0?ooo`3oool09`3oool000X0oooo0P0000070?ooo`80
0000303oool4000000X0oooo0P00001?0?ooo`030?l0003oool0oooo0;T0oooo0`00000W0?ooo`80
003o:03oool000X0oooo0P0000070?ooo`8000002`3oool300000080oooo00<000000?ooo`3oool0
1`3oool2000004l0oooo0P3o002k0?ooo`<000009`3oool00`000?l0oooo0?ooo`0V0?ooo`002P3o
ool2000000L0oooo0P00000:0?ooo`<00000103oool2000000L0oooo0P00001@0?ooo`80o`00^`3o
ool4000002D0oooo0P000?lW0?ooo`002`3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00P0oooo0`0000060?ooo`8000001P3oool200000540oooo0P3o002k0?ooo`@000009@3oool0
0`000?l0oooo0?ooo`0U0?ooo`002`3oool2000000D0oooo0P00000:0?ooo`8000001`3oool20000
00H0oooo0P00001B0?ooo`80o`00_03oool3000002@0oooo0P000?lV0?ooo`00303oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00T0oooo0P0000070?ooo`8000001P3oool200000580
oooo0`3o002l0?ooo`<00000903oool00`000?l0oooo0?ooo`0T0?ooo`00303oool2000000<0oooo
0P00000<0?ooo`8000001@3oool2000000L0oooo0P00001C0?ooo`<0o`00_03oool400000280oooo
0P000?lU0?ooo`003P3oool300000100oooo1P0000080?ooo`800000E03oool30?l00;`0oooo1000
000R0?ooo`030000o`3oool0oooo02<0oooo000_0?ooo`800000E@3oool30?l00;d0oooo0`00000Q
0?ooo`80003o903oool002l0oooo0P00001F0?ooo`<0o`00_@3oool400000200oooo00<0003o0?oo
o`3oool08P3oool002l0oooo0P00001G0?ooo`<0o`00_@3oool4000001l0oooo0P000?lS0?ooo`00
;`3oool2000005P0oooo103o002m0?ooo`<000007`3oool00`000?l0oooo0?ooo`0Q0?ooo`00;`3o
ool3000005P0oooo103o002m0?ooo`<000007P3oool20000ob80oooo000_0?ooo`800000F`3oool3
0?l00;d0oooo1000000M0?ooo`030000o`3oool0oooo0200oooo000_0?ooo`800000G03oool30?l0
0;d0oooo1000000L0?ooo`030000o`3oool0oooo0200oooo000_0?ooo`800000G@3oool30?l00;h0
oooo0`00000K0?ooo`80003o8@3oool002l0oooo0P00001N0?ooo`<0o`00_P3oool3000001/0oooo
00<0003o0?ooo`3oool07`3oool002l0oooo0P00001O0?ooo`<0o`00_P3oool4000001T0oooo0P00
0?lP0?ooo`00;`3oool200000600oooo0`3o002n0?ooo`@000006@3oool00`000?l0oooo0?ooo`0N
0?ooo`00;`3oool200000640oooo103o002n0?ooo`<00000603oool20000oal0oooo000_0?ooo`80
0000HP3oool40?l00;h0oooo0`00000H0?ooo`030000o`3oool0oooo01d0oooo000_0?ooo`800000
I03oool30?l00;h0oooo1000000F0?ooo`80003o7P3oool002l0oooo0P00001U0?ooo`<0o`00_P3o
ool4000001H0oooo0P000?lM0?ooo`00;`3oool2000006H0oooo103o002n0?ooo`<000005@3oool2
0000oad0oooo000_0?ooo`800000I`3oool40?l00;h0oooo0`00000D0?ooo`<0003o703oool002l0
oooo0`00001X0?ooo`<0o`00_P3oool3000001@0oooo0P000?lL0?ooo`00;`3oool2000006X0oooo
0`3o002n0?ooo`<000004`3oool20000oa`0oooo000_0?ooo`800000J`3oool40?l00;d0oooo1000
000A0?ooo`<0003o6`3oool002l0oooo0P00001/0?ooo`@0o`00_@3oool400000140oooo0P000?lK
0?ooo`00;`3oool2000006h0oooo103o002m0?ooo`<00000403oool30000oaX0oooo000_0?ooo`80
0000K`3oool50?l00;`0oooo0`00000@0?ooo`80003o6P3oool002l0oooo0P00001a0?ooo`D0o`00
^`3oool4000000h0oooo0`000?lI0?ooo`00;`3oool2000007<0oooo103o002k0?ooo`@000003P3o
ool20000oaT0oooo000_0?ooo`800000M@3oool40?l00;/0oooo0`00000=0?ooo`80003o6@3oool0
02l0oooo0P00001f0?ooo`D0o`00^P3oool4000000/0oooo0`000?lH0?ooo`00;`3oool2000007P0
oooo1@3o002i0?ooo`@000002`3oool20000oaP0oooo000_0?ooo`800000NP3oool50?l00;T0oooo
100000090?ooo`<0003o5`3oool002l0oooo0P00001l0?ooo`H0o`00]`3oool4000000T0oooo0P00
0?lG0?ooo`00;`3oool3000007d0oooo1P3o002g0?ooo`<00000203oool30000oaH0oooo000_0?oo
o`800000P@3oool60?l00;D0oooo100000070?ooo`80003o5P3oool002l0oooo0P0000230?ooo`P0
o`00/P3oool4000000H0oooo0P000?lF0?ooo`00;`3oool2000008L0oooo203o002`0?ooo`<00000
1@3oool30000oaD0oooo000_0?ooo`800000R`3oool70?l00:h0oooo0`0000050?ooo`80003o5@3o
ool002l0oooo0P00002?0?ooo`H0o`00[03oool4000000<0oooo0`000?lD0?ooo`008@3oool60000
00P0oooo0P00002B0?ooo`H0o`00ZP3oool4000000<0oooo0P000?lD0?ooo`008`3oool2000000X0
oooo0P00002E0?ooo`X0o`00Y@3oool300000080oooo0`000?lC0?ooo`008`3oool2000000X0oooo
0P00002H0?ooo`/0o`00XP3oool300000080oooo0P000?lC0?ooo`008`3oool2000000X0oooo0P00
002O0?ooo`P0o`00W`3oool3000000040?ooo`000?l0003o0000oa80oooo000S0?ooo`8000002P3o
ool200000:<0oooo4P3o002B0?ooo`<0000000<0oooo0000o`000?l04P3oool002<0oooo0P00000:
0?ooo`800000Y`3ooolE0?l008`0oooo0`0000020000oa80oooo000S0?ooo`8000002P3oool20000
0;D0oooo5@3o001o0?ooo`8000000`000?lA0?ooo`008`3oool2000000X0oooo0P00002l0?ooocD0
o`00FP3oool00`000000003o0000o`0A0?ooo`008`3oool2000000X0oooo100000380?oooh80o`00
0`000?l@0?ooo`008`3oool2000000X0oooo0P00003a0?oooe`0o`0000<0003o0?ooo`3oool03`3o
ool002<0oooo0P00000:0?ooo`800000o`3ooomP0?ooo`008`3oool2000000X0oooo0P00003o0?oo
of00oooo000S0?ooo`8000002P3oool200000?l0ooooH03oool002<0oooo0P00000:0?ooo`800000
o`3ooomP0?ooo`008`3oool2000000X0oooo0P00003o0?ooof00oooo000P0?ooo`D000002P3oool2
00000?l0ooooH03oool00280oooo0`00003o0?ooof`0oooo003o0?oooi40oooo003o0?oooi40oooo
003o0?oooi40oooo003o0?oooi40oooo003o0?oooi40oooo003o0?oooi40oooo003o0?oooi40oooo
0000\
\>"],
  ImageRangeCache->{{{0, 399}, {319, 0}} -> {-0.145125, -0.135325, \
0.00299633, 0.00374541}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(Lf1 = \[Integral]\_0\%1 Sqrt[
            1 + \(f1'\)[x]] \[DifferentialD]x\)\)\)], "Input"],

Cell[BoxData[
    \(\@2\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(Lg1 = 
      N[\[Integral]\_0\%1 Sqrt[1 + \(g1'\)[x]^2] \[DifferentialD]x, 
        3]\)\)\)], "Input"],

Cell[BoxData[
    \(1.8471270883830366151`2.9999999999999996\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Lf3 = 
      N[\[Integral]\_0\%1 Sqrt[
              1 + \(f3'\)[x]^2] \[DifferentialD]x]\)], "Input"],

Cell[BoxData[
    \(1.54786565468361`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(Lf3 = 1.55\)\)\)], "Input"],

Cell[BoxData[
    \(1.55`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(labelf1 = 
      Graphics[Text[
          StyleForm[Lf1, FontSize \[Rule] fontSize], {0.6, f1[0.6]}, {\(-1\), 
            1}]]\)\)\)], "Input"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(labelg1 = 
      Graphics[Text[
          StyleForm[Lg1, FontSize \[Rule] fontSize], {0.6, g1[0.6]}, {\(-1\), 
            1}]]\)\)\)], "Input"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(labelf3 = 
      Show[Graphics[
          Text[StyleForm[Lf3, FontSize \[Rule] fontSize], {0.6, 
              f3[0.6]}, {\(-1\), 1}]]]\)\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.793651 0.0147151 1.36251 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
gsave
.5 .30902 -61 -25.0625 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 29.0625 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 21.188 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.55) show
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{288, 177.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004P0000/B000`400?l00000o`00003oo`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ0?ooo`00o`3ooolQ
0?ooo`00o`3ooolQ0?ooo`00U03oool9000000X0oooo1000000;0?ooo`@00000303oool4000005H0
oooo002H0?ooo`030000003oool0oooo00`0oooo100000090?ooo`800000103oool00`000000oooo
0?ooo`070?ooo`800000103oool00`000000oooo0?ooo`1C0?ooo`00V03oool00`000000oooo0?oo
o`0<0?ooo`@00000203oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`1B0?ooo`00V03oool00`000000oooo0?ooo`0Q
0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0D@3oool009P0oooo00<000000?oo
o`3oool08@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0540oooo002H0?ooo`03
0000003oool0oooo0240oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`1A0?ooo`00
V03oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
D@3oool009P0oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo0540oooo002H0?ooo`030000003oool0oooo0200oooo00<000000?ooo`3oool03@3oool0
0`000000oooo0?ooo`1B0?ooo`00V03oool00`000000oooo0?ooo`0I0?ooo`800000103oool20000
00P0oooo0P0000040?ooo`800000E03oool009P0oooo00<000000?ooo`3oool06@3oool00`000000
oooo00000003000000X0oooo00<000000?ooo`0000000`00001F0?ooo`00V03oool00`000000oooo
0?ooo`0I0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0F@3oool009P0oooo00<0
00000?ooo`3oool06@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo05T0oooo002D
0?ooo`050000003oool0oooo0?ooo`0000006`3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo05T0oooo002E0?ooo`@000006`3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0
oooo05T0oooo002H0?ooo`030000003oool0oooo01T0oooo200000080?ooo`P00000E03oool00?l0
oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0
oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00?l0oooo8@3oool00001\
\>"],
  ImageRangeCache->{{{0, 287}, {176.938, 0}} -> {-0.0315626, -0.0108023, \
0.00440113, 0.00256362}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(funktionale = 
      Show[kurven01, labelf1, \ labelg1, \ labelf3, \ 
        ImageSize \[Rule] 400]\)\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .8 
%%ImageSize: 400 320 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0190476 0.761905 [
[.21429 .00655 -18.3125 -31.75 ]
[.21429 .00655 18.3125 0 ]
[.40476 .00655 -18.3125 -31.75 ]
[.40476 .00655 18.3125 0 ]
[.59524 .00655 -18.3125 -31.75 ]
[.59524 .00655 18.3125 0 ]
[.78571 .00655 -18.3125 -31.75 ]
[.78571 .00655 18.3125 0 ]
[.97619 .00655 -8.53125 -31.75 ]
[.97619 .00655 8.53125 0 ]
[.01131 .17143 -36.625 -15.875 ]
[.01131 .17143 0 15.875 ]
[.01131 .32381 -36.625 -15.875 ]
[.01131 .32381 0 15.875 ]
[.01131 .47619 -36.625 -15.875 ]
[.01131 .47619 0 15.875 ]
[.01131 .62857 -36.625 -15.875 ]
[.01131 .62857 0 15.875 ]
[.01131 .78095 -17.0625 -15.875 ]
[.01131 .78095 0 15.875 ]
[ -0.003 -0.003 0 0 ]
[ 1.003 .803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01905 m
.21429 .0253 L
s
gsave
.21429 .00655 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
1.000 setlinewidth
grestore
.40476 .01905 m
.40476 .0253 L
s
gsave
.40476 .00655 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
1.000 setlinewidth
grestore
.59524 .01905 m
.59524 .0253 L
s
gsave
.59524 .00655 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
1.000 setlinewidth
grestore
.78571 .01905 m
.78571 .0253 L
s
gsave
.78571 .00655 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
1.000 setlinewidth
grestore
.97619 .01905 m
.97619 .0253 L
s
gsave
.97619 .00655 -69.5313 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.125 Mabswid
.07143 .01905 m
.07143 .0228 L
s
.11905 .01905 m
.11905 .0228 L
s
.16667 .01905 m
.16667 .0228 L
s
.2619 .01905 m
.2619 .0228 L
s
.30952 .01905 m
.30952 .0228 L
s
.35714 .01905 m
.35714 .0228 L
s
.45238 .01905 m
.45238 .0228 L
s
.5 .01905 m
.5 .0228 L
s
.54762 .01905 m
.54762 .0228 L
s
.64286 .01905 m
.64286 .0228 L
s
.69048 .01905 m
.69048 .0228 L
s
.7381 .01905 m
.7381 .0228 L
s
.83333 .01905 m
.83333 .0228 L
s
.88095 .01905 m
.88095 .0228 L
s
.92857 .01905 m
.92857 .0228 L
s
.006 w
0 .01905 m
1 .01905 L
s
.25 Mabswid
.02381 .17143 m
.03006 .17143 L
s
gsave
.01131 .17143 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
1.000 setlinewidth
grestore
.02381 .32381 m
.03006 .32381 L
s
gsave
.01131 .32381 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
1.000 setlinewidth
grestore
.02381 .47619 m
.03006 .47619 L
s
gsave
.01131 .47619 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
1.000 setlinewidth
grestore
.02381 .62857 m
.03006 .62857 L
s
gsave
.01131 .62857 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
1.000 setlinewidth
grestore
.02381 .78095 m
.03006 .78095 L
s
gsave
.01131 .78095 -78.0625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.125 Mabswid
.02381 .05714 m
.02756 .05714 L
s
.02381 .09524 m
.02756 .09524 L
s
.02381 .13333 m
.02756 .13333 L
s
.02381 .20952 m
.02756 .20952 L
s
.02381 .24762 m
.02756 .24762 L
s
.02381 .28571 m
.02756 .28571 L
s
.02381 .3619 m
.02756 .3619 L
s
.02381 .4 m
.02756 .4 L
s
.02381 .4381 m
.02756 .4381 L
s
.02381 .51429 m
.02756 .51429 L
s
.02381 .55238 m
.02756 .55238 L
s
.02381 .59048 m
.02756 .59048 L
s
.02381 .66667 m
.02756 .66667 L
s
.02381 .70476 m
.02756 .70476 L
s
.02381 .74286 m
.02756 .74286 L
s
.006 w
.02381 0 m
.02381 .8 L
s
0 0 m
1 0 L
1 .8 L
0 .8 L
closepath
clip
newpath
1 0 0 r
.02381 .01905 m
.06244 .18668 L
.10458 .33327 L
.14415 .44219 L
.18221 .52515 L
.22272 .59412 L
.26171 .64513 L
.30316 .68605 L
.34309 .7152 L
.3815 .73579 L
.40095 .74396 L
.42237 .75149 L
.46172 .76202 L
.48113 .76592 L
.502 .76935 L
.52171 .77196 L
.54323 .77423 L
.56382 .77593 L
.58294 .77718 L
.60346 .77821 L
.62207 .77894 L
.64131 .77951 L
.66213 .77997 L
.68207 .78029 L
.69224 .78042 L
.70314 .78053 L
.71341 .78062 L
.72277 .78068 L
.74111 .78078 L
.75102 .78082 L
.76019 .78085 L
.7709 .78088 L
.78095 .7809 L
.78994 .78091 L
.79962 .78092 L
.81037 .78093 L
.82022 .78094 L
.83002 .78094 L
.83914 .78095 L
.84915 .78095 L
.85475 .78095 L
.85984 .78095 L
.86469 .78095 L
.86983 .78095 L
.87426 .78095 L
.87903 .78095 L
.88415 .78095 L
.88893 .78095 L
.89462 .78095 L
.89983 .78095 L
Mistroke
.90461 .78095 L
.90723 .78095 L
.9097 .78095 L
.91201 .78095 L
.9145 .78095 L
.91885 .78095 L
.92136 .78095 L
.92411 .78095 L
.92698 .78095 L
.92966 .78095 L
.93217 .78095 L
.93445 .78095 L
.93709 .78095 L
.93959 .78095 L
.94185 .78095 L
.94398 .78095 L
.94631 .78095 L
.94762 .78095 L
.94882 .78095 L
.94992 .78095 L
.9511 .78095 L
.95239 .78095 L
.95359 .78095 L
.95495 .78095 L
.95622 .78095 L
.95737 .78095 L
.95861 .78095 L
.95971 .78095 L
.96073 .78095 L
.96185 .78095 L
.96306 .78095 L
.96432 .78095 L
.96552 .78095 L
.96659 .78095 L
.96776 .78095 L
.96877 .78095 L
.96988 .78095 L
.97105 .78095 L
.97214 .78095 L
.97316 .78095 L
.97409 .78095 L
.97511 .78095 L
.97619 .78095 L
Mfstroke
0 0 0 r
.02381 .01905 m
.06244 .04996 L
.10458 .08366 L
.14415 .11532 L
.18221 .14577 L
.22272 .17817 L
.26171 .20937 L
.30316 .24252 L
.34309 .27447 L
.3815 .3052 L
.42237 .33789 L
.46172 .36937 L
.49955 .39964 L
.53984 .43187 L
.57861 .46289 L
.61984 .49587 L
.65954 .52764 L
.69774 .55819 L
.73838 .59071 L
.77751 .62201 L
.81909 .65528 L
.85916 .68733 L
.89771 .71817 L
.93871 .75097 L
.97619 .78095 L
s
0 0 1 r
.02381 .01905 m
.02499 .01905 L
.02605 .01905 L
.02729 .01905 L
.02846 .01905 L
.02954 .01905 L
.03053 .01905 L
.03163 .01905 L
.03279 .01905 L
.03395 .01905 L
.0352 .01905 L
.03746 .01905 L
.03884 .01905 L
.04016 .01905 L
.04262 .01905 L
.045 .01906 L
.04753 .01906 L
.0521 .01907 L
.05489 .01907 L
.05752 .01908 L
.06244 .0191 L
.06757 .01912 L
.07299 .01915 L
.08269 .01923 L
.09312 .01934 L
.10458 .01951 L
.11478 .01971 L
.12409 .01994 L
.145 .02062 L
.16409 .02148 L
.18485 .02273 L
.20462 .02426 L
.22563 .0263 L
.26338 .03118 L
.30359 .03836 L
.34227 .04753 L
.38341 .06006 L
.42304 .07517 L
.46115 .09282 L
.50171 .11531 L
.54075 .14089 L
.58225 .17265 L
.62223 .20806 L
.6607 .2469 L
.70162 .2937 L
.74102 .34444 L
.77891 .39878 L
.81925 .46295 L
.85807 .53117 L
.89935 .61101 L
Mistroke
.93911 .69537 L
.97619 .78095 L
Mfstroke
0 g
gsave
.59524 .47619 -61 -38.1875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 42.1875 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

0.000 0.000 0.000 setrgbcolor
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
63.000 15.625 moveto
(\\217) show
84.250 15.625 moveto
(!) show
90.000 15.625 moveto
(!) show
94.188 15.625 moveto
(!) show
85.500 30.938 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
gsave
.59524 .77783 -61 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.85) show
1.000 setlinewidth
grestore
gsave
.59524 .18362 -61 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.55) show
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{400, 320},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0001@2000`400?l00000o`00003oo`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00IP3oool4000000L0oooo0P00
00040?ooo`X00000:03oool4000000L0oooo0P00000;0?ooo`800000:@3oool4000000L0oooo0P00
00070?ooo`D00000:P3oool4000000L0oooo0P0000070?ooo`D00000<`3oool6000000l0oooo001U
0?ooo`8000000`3oool2000000D0oooo0P0000050?ooo`T000009`3oool2000000<0oooo0P000005
0?ooo`8000002`3oool2000002P0oooo0P0000030?ooo`8000001@3oool2000000H0oooo0P000003
0?ooo`800000:03oool2000000<0oooo0P0000050?ooo`8000001@3oool3000000@0oooo0P00000c
0?ooo`8000004@3oool006D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00@0oooo0P00000V0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0403oool2000002P0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0:0?oo
o`8000001@3oool2000002L0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`090?oo
o`<000001P3oool200000380oooo0P00000A0?ooo`00I03oool2000000D0oooo0P00000=0?ooo`03
0000003oool0oooo02X0oooo0P0000050?ooo`8000004@3oool2000002L0oooo0P0000050?ooo`80
00002`3oool2000000H0oooo00<000000?ooo`3oool0903oool2000000D0oooo0P00000:0?ooo`80
00001`3oool200000380oooo0P00000A0?ooo`00I03oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00P0oooo2`00000U0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
203oool2000000L0oooo0P00000U0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
203oool2000000L0oooo0P00000b0?ooo`8000004@3oool006<0oooo0P0000070?ooo`8000003P3o
ool00`000000oooo0?ooo`0W0?ooo`8000001`3oool2000000T0oooo00<000000?ooo`3oool0103o
ool2000002H0oooo0P0000070?ooo`8000002@3oool2000000L0oooo0P00000T0?ooo`8000001`3o
ool2000000T0oooo0P0000060?ooo`<00000<P3oool200000140oooo001S0?ooo`8000001`3oool2
000000l0oooo00<000000?ooo`3oool09P3oool2000000L0oooo0P00000:0?ooo`030000003oool0
oooo00<0oooo0P00000V0?ooo`8000001`3oool2000000T0oooo0P0000070?ooo`800000903oool2
000000L0oooo0P00000:0?ooo`800000103oool3000003<0oooo0P00000A0?ooo`00H`3oool20000
00L0oooo0P00000?0?ooo`030000003oool0oooo02H0oooo0P0000070?ooo`8000002`3oool00`00
0000oooo0?ooo`020?ooo`8000009P3oool2000000L0oooo0P0000090?ooo`8000001`3oool20000
02@0oooo0P0000070?ooo`8000002`3oool010000000oooo0?ooo`3oool3000003@0oooo0P00000A
0?ooo`00H`3oool2000000L0oooo0P00000@0?ooo`030000003oool0oooo02D0oooo0P0000070?oo
o`8000002`3oool00`000000oooo0?ooo`020?ooo`8000009P3oool2000000L0oooo0P0000090?oo
o`8000001P3oool2000002D0oooo0P0000070?ooo`800000303oool5000003D0oooo0P00000A0?oo
o`00H`3oool2000000L0oooo0P00000A0?ooo`030000003oool0oooo02@0oooo0P0000070?ooo`80
0000303oool010000000oooo0?ooo`3oool2000002H0oooo0P0000070?ooo`8000002@3oool40000
00<0oooo0`00000U0?ooo`8000001`3oool2000000`0oooo1000000f0?ooo`8000004@3oool006<0
oooo0P0000070?ooo`8000004@3oool00`000000oooo0?ooo`0T0?ooo`8000001`3oool2000000d0
oooo00<000000?ooo`3oool00P00000V0?ooo`8000001`3oool2000000X0oooo0P0000000`3oool0
000000000002000002L0oooo0P0000070?ooo`8000002`3oool300000080oooo00<000000?ooo`3o
ool0<`3oool200000140oooo001S0?ooo`8000001`3oool200000140oooo0P00000U0?ooo`800000
1`3oool2000000d0oooo00<000000?ooo`3oool00P00000V0?ooo`8000001`3oool2000000X0oooo
0P00000/0?ooo`8000001`3oool2000000X0oooo0`0000040?ooo`800000<`3oool200000140oooo
001T0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`050?ooo`8000009P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00d0oooo00@0
00000?ooo`00000000009`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00X0oooo
0P00000/0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool3000000H0oooo
0P00000b0?ooo`8000004@3oool006@0oooo0P0000050?ooo`8000002P3oool00`000000oooo0?oo
o`050?ooo`8000009P3oool2000000D0oooo0P00000?0?ooo`040000003oool00000000002L0oooo
0P0000050?ooo`8000003@3oool2000002/0oooo0P0000050?ooo`8000002P3oool2000000L0oooo
0P00000b0?ooo`8000004@3oool006D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo0080oooo1000000W0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool03`3oool3000002P0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`0=0?ooo`800000:`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00T0oooo0P00
00070?ooo`800000<P3oool200000140oooo001U0?ooo`8000000`3oool2000000`0oooo2000000X
0?ooo`8000000`3oool200000180oooo0P00000X0?ooo`8000000`3oool200000100oooo0`00000Y
0?ooo`8000000`3oool2000000`0oooo0P0000050?ooo`800000<03oool500000140oooo001W0?oo
o`<00000403oool4000002`0oooo0`00000D0?ooo`800000:P3oool3000001@0oooo1000000X0?oo
o`<00000403oool6000003<0oooo0`00000A0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3o
oonA0?ooo`00o`3ooonA0?ooo`00;`3oool200000?l0ooooH03oool002l0oooo0P00003o0?ooof00
oooo000_0?ooo`800000o`3ooomP0?ooo`00;`3oool200000?l0ooooH03oool002l0oooo0P00003o
0?ooof00oooo000_0?ooo`800000o`3ooomP0?ooo`00;`3oool200000?l0ooooH03oool002L0oooo
2000000i0000ool00000800000090?ooo`009`3oool8000004P0003oo`00000A000000T0oooo000_
0?ooo`030000003o0000000000<00000<`3ooolF0000ocL0oooo00<000000?ooo`3oool0@03oool0
0`000000oooo0?ooo`100?ooo`030000003oool0oooo0400oooo00<000000?ooo`3oool03`3oool0
02l0oooo00@000000?l0003o0000oooo0`0000110?ooo`d0003oo`3oool=0?ooo`00;`3oool01@00
0000o`000?l0003o0000oooo00<00000A`3oool=0000ool0oooo1P3oool002l0oooo0P0000020?l0
0080oooo1000001;0?ooo`h0003ooP3oool002l0oooo0P0000020?l000<0oooo1000001A0?ooo`/0
003onP3oool002l0oooo0P0000020?l000D0oooo0`00001G0?ooo`L0003om`3oool002l0oooo0P00
00020?l000H0oooo1000001I0?ooo`L0003ol`3oool002l0oooo0P0000030?l000H0oooo1000001K
0?ooo`L0003ol03oool002l0oooo0P0000000`3oool0o`000?l000080?ooo`<00000GP3oool70000
on`0oooo000_0?ooo`80000000<0oooo0?l0003o00002@3oool300000600oooo1`000?oY0?ooo`00
;`3oool2000000030?ooo`3o0000o`0000X0oooo1000001R0?ooo`L0003oi@3oool002l0oooo0`00
00030?l000X0oooo1000001T0?ooo`L0003ohP3oool002l0oooo0P0000020?ooo`80o`00303oool3
000006L0oooo1`000?oN0?ooo`00;`3oool200000080oooo0P3o000=0?ooo`<00000J@3oool70000
om/0oooo000_0?ooo`8000000P3oool20?l000h0oooo1000001Z0?ooo`H0003of@3oool002l0oooo
0P0000020?ooo`80o`003`3oool4000006`0oooo1P000?oF0?ooo`00;`3oool200000080oooo0`3o
000@0?ooo`<00000K@3oool70000om<0oooo000_0?ooo`8000000`3oool20?l00140oooo0`00001_
0?ooo`H0003od@3oool002l0oooo0P0000030?ooo`80o`004P3oool400000700oooo1@000?o?0?oo
o`00;`3oool2000000<0oooo0P3o000C0?ooo`@00000L@3oool50000old0oooo000_0?ooo`800000
0`3oool30?l001@0oooo0`00001b0?ooo`H0003obP3oool002l0oooo0P0000040?ooo`80o`005@3o
ool400000780oooo1P000?o80?ooo`00;`3oool2000000@0oooo0P3o000F0?ooo`@00000M03oool5
0000olH0oooo000_0?ooo`800000103oool20?l001P0oooo0`00001e0?ooo`D0003oa03oool002l0
oooo0`0000030?ooo`80o`006@3oool3000007H0oooo10000?o30?ooo`00;`3oool2000000@0oooo
0`3o000I0?ooo`@00000MP3oool40000ol40oooo000_0?ooo`8000001@3oool20?l001X0oooo1000
001f0?ooo`D0003o_`3oool002l0oooo0P0000050?ooo`80o`00703oool3000007L0oooo1@000?nm
0?ooo`00;`3oool2000000D0oooo0P3o000M0?ooo`<00000N03oool40000ok`0oooo000_0?ooo`80
00001@3oool30?l001d0oooo1000001h0?ooo`@0003o^P3oool002l0oooo0P0000060?ooo`80o`00
7P3oool4000007P0oooo1@000?nh0?ooo`00;`3oool2000000H0oooo0P3o000P0?ooo`<00000N@3o
ool50000okH0oooo000_0?ooo`8000001P3oool20?l00240oooo0`00001j0?ooo`@0003o8`3oool6
000000D0oooo0P0000050?ooo`D00000203oool5000006h0oooo000_0?ooo`8000001P3oool20?l0
0280oooo1000001j0?ooo`@0003o8`3oool2000000L0oooo0P0000040?ooo`800000103oool00`00
0000oooo0?ooo`040?ooo`800000103oool00`000000oooo0?ooo`1[0?ooo`00;`3oool2000000H0
oooo0`3o000R0?ooo`@00000NP3oool40000ob80oooo0P00000D0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool0JP3oool002l0oooo0P0000070?ooo`80o`00903oool3000007/0oooo
10000?lP0?ooo`8000005@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo06T0oooo
000_0?ooo`8000001`3oool20?l002D0oooo0`00001k0?ooo`@0003o7`3oool2000001D0oooo0P00
000;0?ooo`800000JP3oool002l0oooo0P0000070?ooo`80o`009P3oool3000007`0oooo10000?lM
0?ooo`8000005@3oool2000000/0oooo0P00001Z0?ooo`00;`3oool3000000H0oooo0`3o000V0?oo
o`<00000O03oool40000oa`0oooo0P00000E0?ooo`8000002`3oool2000006X0oooo000_0?ooo`80
0000203oool20?l002L0oooo1000001l0?ooo`@0003o6P3oool2000001D0oooo0P00000;0?ooo`80
0000JP3oool002l0oooo0P0000080?ooo`80o`00:03oool4000007`0oooo10000?lI0?ooo`800000
503oool3000000X0oooo0`00001Z0?ooo`00;`3oool2000000P0oooo0P3o000Z0?ooo`<00000O@3o
ool40000oaL0oooo0P00000C0?ooo`<000002P3oool3000006/0oooo000_0?ooo`800000203oool2
0?l002/0oooo0`00001m0?ooo`@0003o5P3oool200000140oooo100000090?ooo`@00000K03oool0
00d0oooo100000070?ooo`800000103oool:000000L0oooo0P0000080?ooo`<0o`00:`3oool40000
07d0oooo0`000?lE0?ooo`8000003P3oool6000000L0oooo1P00001]0?ooo`00303oool2000000<0
oooo0P0000050?ooo`8000001@3oool9000000L0oooo0P0000090?ooo`80o`00;03oool4000007d0
oooo10000?lC0?ooo`8000003`3oool3000000X0oooo0`00001_0?ooo`00303oool00`000000oooo
0?ooo`030?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0103oool2000000H0oooo
0P0000090?ooo`80o`00;P3oool3000007d0oooo10000?lB0?ooo`8000003`3oool00`000000oooo
0?ooo`0:0?ooo`030000003oool0oooo06l0oooo000;0?ooo`8000001@3oool2000000d0oooo00<0
00000?ooo`3oool02`3oool2000000T0oooo0P3o000_0?ooo`@00000O@3oool40000oa00oooo0P00
000@0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool0KP3oool000/0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00X0oooo0P000009
0?ooo`<0o`00;`3oool4000007d0oooo10000?l<0?ooo`D00000403oool6000000L0oooo1P00001[
0?ooo`002P3oool2000000L0oooo0P00000>0?ooo`030000003oool0oooo00T0oooo0P00000:0?oo
o`80o`00<@3oool4000007d0oooo0`000?l=0?ooo`<000004@3oool6000000L0oooo1P00001Z0?oo
o`002P3oool2000000L0oooo0P00000?0?ooo`030000003oool0oooo00P0oooo0P00000:0?ooo`80
o`00<P3oool4000007d0oooo10000?nL0?ooo`002P3oool2000000L0oooo0P00000?0?ooo`030000
003oool0oooo00P0oooo0P00000:0?ooo`80o`00=03oool3000007d0oooo10000?nK0?ooo`002P3o
ool2000000L0oooo0P00000@0?ooo`030000003oool0oooo00L0oooo100000080?ooo`80o`00=@3o
ool4000007d0oooo0`000?nJ0?ooo`002P3oool2000000L0oooo0P00000A0?ooo`030000003oool0
oooo00H0oooo0P00000:0?ooo`<0o`00=@3oool4000007d0oooo0`000?nI0?ooo`002P3oool20000
00L0oooo0P00000A0?ooo`030000003oool0oooo00H0oooo0P00000;0?ooo`80o`00=`3oool30000
07d0oooo0`000?nH0?ooo`002P3oool2000000L0oooo0P00000A0?ooo`8000001`3oool2000000/0
oooo0P3o000h0?ooo`<00000O@3oool30000oiL0oooo000;0?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`8000001`3oool2000000/0oooo
0P3o000i0?ooo`@00000O03oool30000oiH0oooo000;0?ooo`8000001@3oool2000000X0oooo00<0
00000?ooo`3oool01@3oool2000000L0oooo0P00000;0?ooo`<0o`00>@3oool4000007`0oooo0`00
0?nE0?ooo`00303oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00X0oooo00<00000
0?ooo`3oool00P3oool4000000L0oooo0P00000<0?ooo`80o`00>`3oool3000007`0oooo10000?nC
0?ooo`00303oool2000000<0oooo0P00000<0?ooo`P00000203oool2000000`0oooo0P3o000l0?oo
o`<00000O03oool40000oi80oooo000>0?ooo`<00000403oool4000000X0oooo0P00000<0?ooo`<0
o`00?03oool3000007d0oooo0`000?nA0?ooo`00;`3oool2000000d0oooo0P3o000m0?ooo`<00000
O@3oool30000oi00oooo000_0?ooo`8000003@3oool20?l003h0oooo1000001l0?ooo`<0003oS`3o
ool002l0oooo0P00000=0?ooo`80o`00?`3oool4000007`0oooo0`000?n>0?ooo`00;`3oool20000
00d0oooo0`3o00100?ooo`<00000O03oool30000ohd0oooo000_0?ooo`<000003@3oool20?l00440
oooo0`00001l0?ooo`<0003oS03oool002l0oooo0P00000>0?ooo`80o`00@P3oool3000007`0oooo
0`000?n;0?ooo`00;`3oool2000000h0oooo0`3o00120?ooo`@00000N`3oool30000ohX0oooo000_
0?ooo`8000003`3oool20?l004<0oooo1000001k0?ooo`<0003oR@3oool002l0oooo0P00000?0?oo
o`80o`00A@3oool3000007/0oooo0`000?n80?ooo`00;`3oool2000000l0oooo0P3o00160?ooo`<0
0000N`3oool30000ohL0oooo000_0?ooo`8000003`3oool30?l004H0oooo1000001j0?ooo`<0003o
QP3oool002l0oooo0P00000@0?ooo`80o`00A`3oool4000007X0oooo0`000?n50?ooo`00;`3oool2
00000100oooo0P3o00190?ooo`<00000NP3oool30000oh@0oooo000_0?ooo`800000403oool30?l0
04T0oooo0`00001j0?ooo`<0003oP`3oool002l0oooo0P00000A0?ooo`80o`00BP3oool4000007T0
oooo0`000?n20?ooo`00;`3oool200000140oooo0P3o001;0?ooo`@00000N@3oool30000oh40oooo
000_0?ooo`8000004@3oool20?l004d0oooo0`00001i0?ooo`<0003oP03oool002l0oooo0P00000A
0?ooo`<0o`00C@3oool4000007P0oooo0`000?mo0?ooo`00;`3oool300000140oooo0P3o001>0?oo
o`@00000N03oool30000ogh0oooo000_0?ooo`8000004P3oool20?l00500oooo0`00001h0?ooo`80
003oOP3oool002l0oooo0P00000B0?ooo`<0o`00D03oool3000007P0oooo0P000?mm0?ooo`00;`3o
ool2000001<0oooo0P3o001A0?ooo`@00000MP3oool30000og`0oooo000_0?ooo`8000004`3oool2
0?l00580oooo1000001f0?ooo`<0003oN`3oool002l0oooo0P00000C0?ooo`80o`00E03oool30000
07H0oooo0`000?mj0?ooo`00;`3oool2000001<0oooo0`3o001D0?ooo`<00000MP3oool30000ogT0
oooo000_0?ooo`800000503oool20?l005D0oooo1000001e0?ooo`80003oN@3oool002l0oooo0P00
000D0?ooo`80o`00EP3oool4000007D0oooo0P000?mh0?ooo`00;`3oool2000001@0oooo0`3o001G
0?ooo`<00000M03oool30000ogL0oooo000_0?ooo`8000005@3oool20?l005P0oooo0`00001d0?oo
o`<0003oMP3oool002l0oooo0P00000E0?ooo`80o`00F@3oool4000007<0oooo0`000?me0?ooo`00
;`3oool2000001D0oooo0P3o001J0?ooo`@00000L`3oool30000og@0oooo000_0?ooo`<00000503o
ool30?l005/0oooo0`00001c0?ooo`80003oM03oool002l0oooo0P00000F0?ooo`80o`00G03oool3
000007<0oooo0P000?mc0?ooo`00;`3oool2000001H0oooo0P3o001M0?ooo`<00000LP3oool30000
og80oooo000_0?ooo`8000005P3oool30?l005d0oooo0`00001b0?ooo`80003oLP3oool002l0oooo
0P00000G0?ooo`80o`00GP3oool400000740oooo0P000?ma0?ooo`00;`3oool2000001L0oooo0P3o
001O0?ooo`@00000L@3oool20000og00oooo000=0?ooo`@000001`3oool2000000/0oooo0P000008
0?ooo`8000005`3oool20?l00640oooo0`00001a0?ooo`80003oK`3oool000`0oooo0P0000030?oo
o`8000001@3oool2000000/0oooo0P0000080?ooo`8000005`3oool30?l00640oooo0`00001a0?oo
o`030000o`3oool0oooo06d0oooo000<0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0403oool2000000P0oooo0P00000H0?ooo`80o`00HP3oool4000006l0oooo0P000?m^0?ooo`00
2`3oool2000000D0oooo0P00000A0?ooo`800000203oool2000001P0oooo0P3o001S0?ooo`@00000
K`3oool20000ofd0oooo000;0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203o
ool;000000H0oooo0P00000H0?ooo`<0o`00I03oool3000006l0oooo0P000?m/0?ooo`002P3oool2
000000L0oooo0P0000090?ooo`030000003oool0oooo00@0oooo0P0000080?ooo`8000006@3oool2
0?l006D0oooo1000001^0?ooo`80003oJ`3oool000X0oooo0P0000070?ooo`8000002P3oool00`00
0000oooo0?ooo`030?ooo`800000203oool2000001T0oooo0P3o001V0?ooo`@00000KP3oool00`00
0?l0oooo0?ooo`1Y0?ooo`002P3oool2000000L0oooo0P00000;0?ooo`030000003oool0oooo0080
oooo0P0000080?ooo`@000005`3oool20?l006P0oooo1000001/0?ooo`80003oJP3oool000X0oooo
0P0000070?ooo`8000002`3oool00`000000oooo0?ooo`020?ooo`800000203oool2000001T0oooo
0`3o001X0?ooo`@00000K03oool20000ofT0oooo000:0?ooo`8000001`3oool2000000`0oooo00@0
00000?ooo`3oool0oooo0P0000080?ooo`8000006P3oool20?l006X0oooo0`00001/0?ooo`80003o
J03oool000X0oooo0P0000070?ooo`8000003@3oool00`000000oooo0?ooo`02000000P0oooo0P00
000J0?ooo`80o`00J`3oool4000006/0oooo00<0003o0?ooo`3oool0IP3oool000X0oooo0P000007
0?ooo`8000003@3oool00`000000oooo0?ooo`02000000P0oooo0P00000J0?ooo`<0o`00J`3oool4
000006X0oooo0P000?mW0?ooo`002`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
00d0oooo00@000000?ooo`0000000000203oool2000001/0oooo0P3o001]0?ooo`<00000JP3oool2
0000ofH0oooo000;0?ooo`8000001@3oool2000000l0oooo00@000000?ooo`0000000000203oool2
000001/0oooo0P3o001^0?ooo`<00000JP3oool20000ofD0oooo000<0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool03`3oool3000000P0oooo0P00000K0?ooo`<0o`00KP3oool40000
06T0oooo0P000?mT0?ooo`00303oool2000000<0oooo0P00000B0?ooo`800000203oool2000001`0
oooo0P3o001_0?ooo`@00000J@3oool00`000?l0oooo0?ooo`1R0?ooo`003P3oool3000001@0oooo
0P0000080?ooo`800000703oool30?l00700oooo0`00001X0?ooo`80003oH`3oool002l0oooo0P00
000M0?ooo`80o`00L@3oool3000006P0oooo0P000?mR0?ooo`00;`3oool2000001d0oooo0P3o001b
0?ooo`<00000J03oool20000of40oooo000_0?ooo`8000007@3oool30?l00780oooo0`00001X0?oo
o`030000o`3oool0oooo05l0oooo000_0?ooo`8000007P3oool20?l007<0oooo1000001V0?ooo`80
003oH03oool002l0oooo0`00000M0?ooo`80o`00M03oool4000006H0oooo0P000?mO0?ooo`00;`3o
ool2000001h0oooo0`3o001e0?ooo`<00000IP3oool20000oeh0oooo000_0?ooo`8000007`3oool2
0?l007H0oooo0`00001V0?ooo`030000o`3oool0oooo05`0oooo000_0?ooo`8000007`3oool20?l0
07L0oooo1000001T0?ooo`80003oG@3oool002l0oooo0P00000O0?ooo`<0o`00M`3oool4000006@0
oooo0P000?mL0?ooo`00;`3oool200000200oooo0P3o001i0?ooo`<00000I03oool00`000?l0oooo
0?ooo`1J0?ooo`00;`3oool200000200oooo0`3o001i0?ooo`<00000H`3oool20000oe/0oooo000_
0?ooo`8000008@3oool20?l007X0oooo1000001R0?ooo`80003oFP3oool002l0oooo0P00000Q0?oo
o`80o`00N`3oool400000680oooo0P000?mI0?ooo`00;`3oool200000240oooo0`3o001l0?ooo`<0
0000HP3oool00`000?l0oooo0?ooo`1G0?ooo`00;`3oool200000280oooo0P3o001m0?ooo`<00000
H@3oool20000oeP0oooo000_0?ooo`8000008P3oool20?l007h0oooo1000000^0?ooo`800000<03o
ool20000oeL0oooo000_0?ooo`8000008P3oool30?l007h0oooo1000000]0?ooo`800000<@3oool2
0000oeH0oooo000_0?ooo`<000008P3oool20?l00800oooo0`00000[0?ooo`<00000<P3oool00`00
0?l0oooo0?ooo`1D0?ooo`00;`3oool2000002<0oooo0`3o00200?ooo`@00000:@3oool3000000/0
oooo2P00000M0?ooo`80003oE@3oool002l0oooo0P00000T0?ooo`80o`00P@3oool4000002L0oooo
1@00000;0?ooo`T000007P3oool20000oe@0oooo000_0?ooo`800000903oool20?l008<0oooo0`00
000V0?ooo`<0000000<0oooo0000003oool02`3oool00`000000oooo0?ooo`040?ooo`8000007P3o
ool00`000?l0oooo0?ooo`1B0?ooo`00;`3oool2000002@0oooo0`3o00230?ooo`<00000903oool4
000000030?ooo`000000oooo00`0oooo00<000000?ooo`3oool08`3oool20000oe<0oooo000_0?oo
o`8000009@3oool20?l008@0oooo1000000R0?ooo`<000000`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo02<0oooo00<0003o0?ooo`3oool0D@3oool002l0oooo0P00000U0?ooo`80
o`00Q@3oool400000200oooo0`0000040?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool08P3oool20000oe80oooo000_0?ooo`8000009@3oool30?l008H0oooo0`00000O0?ooo`<00000
103oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0280oooo0P000?mA0?ooo`00;`3o
ool2000002H0oooo0P3o00270?ooo`<000007@3oool3000000D0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0S0?ooo`030000o`3oool0oooo04l0oooo000_0?ooo`8000009P3oool2
0?l008P0oooo1000000G0?ooo`040000003oool0oooo0?ooo`<000001P3oool00`000000oooo0?oo
o`0=0?ooo`030000003oool0oooo0280oooo0P000?m@0?ooo`00;`3oool2000002L0oooo0P3o0028
0?ooo`@000005P3oool2000000040?ooo`0000000000000000L0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0R0?ooo`80003oC`3oool002l0oooo0P00000W0?ooo`80o`00RP3oool3
000001L0oooo100000070?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool08`3oool0
0`000?l0oooo0?ooo`1=0?ooo`00;`3oool2000002L0oooo0`3o002:0?ooo`<00000603oool00`00
0000oooo0?ooo`070?ooo`030000003oool0oooo00d0oooo0P00000T0?ooo`80003oCP3oool002l0
oooo0`00000W0?ooo`80o`00R`3oool400000200oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`050?ooo`8000009@3oool20000odd0oooo000_0?ooo`800000:03oool20?l008`0oooo
1000000O0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool01@3oool2000002H0oooo
00<0003o0?ooo`3oool0B`3oool002l0oooo0P00000Y0?ooo`030?l0003oool0oooo08`0oooo0`00
000O0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool00P3oool4000002H0oooo0P00
0?m<0?ooo`00;`3oool2000002T0oooo0P3o002>0?ooo`<000007P3oool00`000000oooo0?ooo`05
0?ooo`P00000:03oool00`000?l0oooo0?ooo`1:0?ooo`00;`3oool2000002X0oooo00<0o`000?oo
o`3oool0S@3oool3000001d0oooo00<000000?ooo`3oool01`3oool4000002X0oooo0P000?m;0?oo
o`00;`3oool2000002X0oooo0P3o002?0?ooo`<00000703oool00`000000oooo0?ooo`0f0?ooo`80
003oBP3oool000d0oooo100000070?ooo`8000001`3oool5000000T0oooo0P00000[0?ooo`030?l0
003oool0oooo08h0oooo1000000K0?ooo`030000003oool0oooo03H0oooo00<0003o0?ooo`3oool0
B03oool000`0oooo0P0000030?ooo`8000001@3oool2000000H0oooo0P0000030?ooo`800000203o
ool2000002/0oooo00<0o`000?ooo`3oool0S`3oool4000001X0oooo00<000000?ooo`3oool0=P3o
ool20000odT0oooo000<0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool02P3oool2
000000D0oooo0P0000070?ooo`800000:`3oool20?l00980oooo0`00000I0?ooo`030000003oool0
oooo03L0oooo0P000?m80?ooo`002`3oool2000000D0oooo0P00000;0?ooo`8000001P3oool00`00
0000oooo0?ooo`050?ooo`800000;03oool00`3o0000oooo0?ooo`2A0?ooo`<000006@3oool00`00
0000oooo0?ooo`0g0?ooo`030000o`3oool0oooo04H0oooo000;0?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool0203oool2000000L0oooo0P0000060?ooo`800000;03oool20?l009<0
oooo0`00000H0?ooo`030000003oool0oooo03L0oooo0P000?m70?ooo`002P3oool2000000L0oooo
0P0000090?ooo`8000001`3oool2000000H0oooo0P00000]0?ooo`030?l0003oool0oooo0980oooo
1000000F0?oooa800000:@3oool00`000?l0oooo0?ooo`150?ooo`002P3oool2000000L0oooo0P00
00090?ooo`8000001`3oool2000000H0oooo0P00000]0?ooo`80o`00U03oool400000500oooo0P00
0?m60?ooo`002P3oool2000000L0oooo0P0000090?ooo`8000001`3oool2000000H0oooo0P00000^
0?ooo`030?l0003oool0oooo09@0oooo0`00001@0?ooo`030000o`3oool0oooo04@0oooo000:0?oo
o`8000001`3oool2000000T0oooo0P0000060?ooo`8000001`3oool4000002`0oooo0P3o002F0?oo
o`<00000C`3oool20000odD0oooo000:0?ooo`8000001`3oool2000000T0oooo100000030?ooo`<0
00001`3oool2000002l0oooo00<0o`000?ooo`3oool0U@3oool4000004h0oooo0P000?m40?ooo`00
2P3oool2000000L0oooo0P00000:0?ooo`80000000<0oooo0000000000000P0000090?ooo`800000
;`3oool00`3o0000oooo0?ooo`2F0?ooo`@00000CP3oool00`000?l0oooo0?ooo`120?ooo`002P3o
ool2000000L0oooo0P00000:0?ooo`8000003P3oool2000002l0oooo0P3o002I0?ooo`<00000C@3o
ool20000od<0oooo000;0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool02P3oool2
000000d0oooo0P00000`0?ooo`030?l0003oool0oooo09P0oooo0`00001=0?ooo`030000o`3oool0
oooo0440oooo000;0?ooo`8000001@3oool2000000d0oooo0P00000<0?ooo`800000<03oool20?l0
09X0oooo1000001;0?ooo`80003o@P3oool000`0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`0=0?ooo`8000002`3oool200000340oooo00<0o`000?ooo`3oool0V@3oool4000004/0
oooo00<0003o0?ooo`3oool0@03oool000`0oooo0P0000030?ooo`800000403oool3000000T0oooo
0P00000a0?ooo`80o`00W03oool3000004X0oooo0P000?m10?ooo`003P3oool3000001@0oooo1000
00060?ooo`800000<P3oool00`3o0000oooo0?ooo`2K0?ooo`@00000B@3oool00`000?l0oooo0?oo
o`0o0?ooo`00;`3oool200000380oooo0P3o002M0?ooo`@00000B03oool20000od00oooo000_0?oo
o`800000<`3oool00`3o0000oooo0?ooo`2M0?ooo`<00000B03oool00`000?l0oooo0?ooo`0n0?oo
o`00;`3oool2000003<0oooo0P3o002O0?ooo`<00000A`3oool20000ocl0oooo000_0?ooo`800000
=03oool00`3o0000oooo0?ooo`2N0?ooo`@00000AP3oool00`000?l0oooo0?ooo`0m0?ooo`00;`3o
ool3000003<0oooo00<0o`000?ooo`3oool0W`3oool4000004D0oooo0P000?ln0?ooo`00;`3oool2
000003@0oooo0P3o002R0?ooo`<00000A@3oool20000ocd0oooo000_0?ooo`800000=@3oool00`3o
0000oooo0?ooo`2Q0?ooo`<00000A@3oool00`000?l0oooo0?ooo`0k0?ooo`00;`3oool2000003D0
oooo0P3o002S0?ooo`@00000@`3oool20000oc`0oooo000_0?ooo`800000=P3oool00`3o0000oooo
0?ooo`2R0?ooo`@00000@`3oool00`000?l0oooo0?ooo`0j0?ooo`00;`3oool2000003H0oooo0P3o
002U0?ooo`<00000@P3oool20000oc/0oooo000_0?ooo`800000=`3oool20?l00:D0oooo0`000012
0?ooo`030000o`3oool0oooo03T0oooo000_0?ooo`800000>03oool00`3o0000oooo0?ooo`2T0?oo
o`@00000@03oool20000ocX0oooo000_0?ooo`800000>03oool20?l00:H0oooo100000100?ooo`03
0000o`3oool0oooo03P0oooo000_0?ooo`800000>@3oool00`3o0000oooo0?ooo`2V0?ooo`<00000
?`3oool20000ocT0oooo000_0?ooo`800000>@3oool20?l00:P0oooo0`00000o0?ooo`030000o`3o
ool0oooo03L0oooo000_0?ooo`800000>P3oool20?l00:P0oooo0`00000n0?ooo`80003o>03oool0
02l0oooo0P00000k0?ooo`030?l0003oool0oooo0:L0oooo0`00000n0?ooo`030000o`3oool0oooo
03H0oooo000_0?ooo`800000>`3oool20?l00:T0oooo1000000l0?ooo`80003o=`3oool002l0oooo
0`00000k0?ooo`80o`00Z@3oool4000003`0oooo0P000?lf0?ooo`00;`3oool2000003d0oooo00<0
o`000?ooo`3oool0Z@3oool3000003`0oooo00<0003o0?ooo`3oool0=03oool002l0oooo0P00000m
0?ooo`80o`00Z`3oool3000003/0oooo0P000?le0?ooo`00;`3oool2000003h0oooo00<0o`000?oo
o`3oool0ZP3oool4000003X0oooo00<0003o0?ooo`3oool0<`3oool002l0oooo0P00000n0?ooo`80
o`00[03oool4000003T0oooo0P000?ld0?ooo`00;`3oool2000003l0oooo0P3o002]0?ooo`<00000
>@3oool00`000?l0oooo0?ooo`0b0?ooo`00;`3oool200000400oooo00<0o`000?ooo`3oool0[03o
ool3000003P0oooo0P000?lc0?ooo`00;`3oool200000400oooo0P3o002^0?ooo`@00000=`3oool0
0`000?l0oooo0?ooo`0a0?ooo`00;`3oool200000440oooo0P3o002^0?ooo`@00000=P3oool20000
oc80oooo000_0?ooo`800000@P3oool00`3o0000oooo0?ooo`2^0?ooo`<00000=P3oool00`000?l0
oooo0?ooo`0`0?ooo`00;`3oool200000480oooo0P3o002`0?ooo`<00000=@3oool20000oc40oooo
000_0?ooo`800000@`3oool00`3o0000oooo0?ooo`2_0?ooo`@00000=03oool00`000?l0oooo0?oo
o`0_0?ooo`00;`3oool2000004<0oooo0P3o002a0?ooo`@00000<`3oool20000oc00oooo000_0?oo
o`<00000@`3oool20?l00;80oooo0`00000c0?ooo`80003o;`3oool002l0oooo0P0000150?ooo`03
0?l0003oool0oooo0;40oooo1000000b0?ooo`030000o`3oool0oooo02d0oooo000_0?ooo`800000
A@3oool20?l00;<0oooo1000000a0?ooo`80003o;P3oool002l0oooo0P0000160?ooo`80o`00]03o
ool300000340oooo00<0003o0?ooo`3oool0;03oool002l0oooo0P0000170?ooo`80o`00]03oool3
00000300oooo0P000?l]0?ooo`00;`3oool2000004P0oooo00<0o`000?ooo`3oool0/`3oool40000
02l0oooo00<0003o0?ooo`3oool0:`3oool000d0oooo100000070?ooo`8000001`3oool5000000T0
oooo0P0000180?ooo`80o`00]@3oool4000002h0oooo0P000?l/0?ooo`00303oool2000000<0oooo
0P0000050?ooo`8000001@3oool3000000@0oooo0P0000070?ooo`800000B@3oool20?l00;H0oooo
0`00000^0?ooo`030000o`3oool0oooo02X0oooo000<0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool02@3oool3000000H0oooo0P0000060?ooo`800000BP3oool00`3o0000oooo0?oo
o`2e0?ooo`<00000;@3oool20000ob/0oooo000;0?ooo`8000001@3oool2000000X0oooo0P000007
0?ooo`8000001P3oool2000004X0oooo0P3o002g0?ooo`@00000;03oool00`000?l0oooo0?ooo`0Y
0?ooo`002`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo0P0000070?oo
o`8000001P3oool2000004/0oooo0P3o002g0?ooo`@00000:`3oool20000obX0oooo000:0?ooo`80
00001`3oool2000000T0oooo0P0000060?ooo`<000001P3oool2000004`0oooo0P3o002h0?ooo`<0
0000:`3oool00`000?l0oooo0?ooo`0X0?ooo`002P3oool2000000L0oooo0P00000:0?ooo`800000
103oool3000000L0oooo0P00001=0?ooo`030?l0003oool0oooo0;L0oooo0`00000Z0?ooo`80003o
:@3oool000X0oooo0P0000070?ooo`8000002`3oool010000000oooo0?ooo`3oool3000000P0oooo
1000001;0?ooo`80o`00^@3oool4000002T0oooo00<0003o0?ooo`3oool09`3oool000X0oooo0P00
00070?ooo`800000303oool5000000T0oooo0P00001>0?ooo`80o`00^@3oool4000002P0oooo00<0
003o0?ooo`3oool09`3oool000X0oooo0P0000070?ooo`800000303oool4000000X0oooo0P00001?
0?ooo`030?l0003oool0oooo0;T0oooo0`00000W0?ooo`80003o:03oool000X0oooo0P0000070?oo
o`8000002`3oool300000080oooo00<000000?ooo`3oool01`3oool2000004l0oooo0P3o002k0?oo
o`<000009`3oool00`000?l0oooo0?ooo`0V0?ooo`002P3oool2000000L0oooo0P00000:0?ooo`<0
0000103oool2000000L0oooo0P00001@0?ooo`80o`00^`3oool4000002D0oooo0P000?lW0?ooo`00
2`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo0`0000060?ooo`800000
1P3oool200000540oooo0P3o002k0?ooo`@000009@3oool00`000?l0oooo0?ooo`0U0?ooo`002`3o
ool2000000D0oooo0P00000:0?ooo`8000001`3oool2000000H0oooo0P00001B0?ooo`80o`00_03o
ool3000002@0oooo0P000?lV0?ooo`00303oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo00T0oooo0P0000070?ooo`8000001P3oool200000580oooo0`3o002l0?ooo`<00000903oool0
0`000?l0oooo0?ooo`0T0?ooo`00303oool2000000<0oooo0P00000<0?ooo`8000001@3oool20000
00L0oooo0P00001C0?ooo`<0o`00_03oool400000280oooo0P000?lU0?ooo`003P3oool300000100
oooo1P0000080?ooo`800000E03oool30?l00;`0oooo1000000R0?ooo`030000o`3oool0oooo02<0
oooo000_0?ooo`800000E@3oool30?l00;d0oooo0`00000Q0?ooo`80003o903oool002l0oooo0P00
001F0?ooo`<0o`00_@3oool400000200oooo00<0003o0?ooo`3oool08P3oool002l0oooo0P00001G
0?ooo`<0o`00_@3oool4000001l0oooo0P000?lS0?ooo`00;`3oool2000005P0oooo103o002m0?oo
o`<000007`3oool00`000?l0oooo0?ooo`0Q0?ooo`00;`3oool3000005P0oooo103o002m0?ooo`<0
00007P3oool20000ob80oooo000_0?ooo`800000F`3oool30?l00;d0oooo1000000M0?ooo`030000
o`3oool0oooo0200oooo000_0?ooo`800000G03oool30?l00;d0oooo1000000L0?ooo`030000o`3o
ool0oooo0200oooo000_0?ooo`800000G@3oool30?l00;h0oooo0`00000K0?ooo`80003o8@3oool0
02l0oooo0P00001N0?ooo`<0o`00_P3oool3000001/0oooo00<0003o0?ooo`3oool07`3oool002l0
oooo0P00001O0?ooo`<0o`00_P3oool4000001T0oooo0P000?lP0?ooo`00;`3oool200000600oooo
0`3o002n0?ooo`@000006@3oool00`000?l0oooo0?ooo`0N0?ooo`00;`3oool200000640oooo103o
002n0?ooo`<00000603oool20000oal0oooo000_0?ooo`800000HP3oool40?l00;h0oooo0`00000H
0?ooo`030000o`3oool0oooo01d0oooo000_0?ooo`800000I03oool30?l00;h0oooo1000000F0?oo
o`80003o7P3oool002l0oooo0P00001U0?ooo`<0o`00_P3oool4000001H0oooo0P000?lM0?ooo`00
;`3oool2000006H0oooo103o002n0?ooo`<000005@3oool20000oad0oooo000_0?ooo`800000I`3o
ool40?l00;h0oooo0`00000D0?ooo`<0003o703oool002l0oooo0`00001X0?ooo`<0o`00_P3oool3
000001@0oooo0P000?lL0?ooo`00;`3oool2000006X0oooo0`3o002n0?ooo`<000004`3oool20000
oa`0oooo000_0?ooo`800000J`3oool40?l005h0oooo1P0000050?ooo`8000001`3oool5000000H0
oooo1@00000k0?ooo`@000004@3oool30000oa/0oooo000_0?ooo`800000K03oool40?l005l0oooo
0P0000070?ooo`8000001@3oool3000000@0oooo0P0000030?ooo`800000103oool00`000000oooo
0?ooo`0i0?ooo`@000004@3oool20000oa/0oooo000_0?ooo`800000KP3oool40?l005d0oooo0P00
000=0?ooo`<000001P3oool2000000T0oooo00<000000?ooo`3oool0>P3oool300000100oooo0`00
0?lJ0?ooo`00;`3oool2000006l0oooo1@3o001K0?ooo`8000003@3oool2000000L0oooo0P00000:
0?ooo`030000003oool0oooo03X0oooo0`00000@0?ooo`80003o6P3oool002l0oooo0P00001a0?oo
o`D0o`00F@3oool2000000d0oooo0P0000070?ooo`8000002P3oool2000003`0oooo1000000>0?oo
o`<0003o6@3oool002l0oooo0P00001c0?ooo`@0o`00F03oool2000000d0oooo0P0000060?ooo`<0
00002P3oool2000003d0oooo1000000>0?ooo`80003o6@3oool002l0oooo0P00001e0?ooo`@0o`00
EP3oool2000000h0oooo0P0000040?ooo`<000002`3oool2000003l0oooo0`00000=0?ooo`80003o
6@3oool002l0oooo0P00001f0?ooo`D0o`00E03oool2000000l0oooo00@000000?ooo`3oool0oooo
0`00000<0?ooo`800000@03oool4000000/0oooo0`000?lH0?ooo`00;`3oool2000007P0oooo1@3o
001B0?ooo`800000403oool5000000`0oooo0`0000110?ooo`@000002`3oool20000oaP0oooo000_
0?ooo`800000NP3oool50?l00500oooo0P00000@0?ooo`@00000303oool3000004@0oooo10000009
0?ooo`<0003o5`3oool002l0oooo0P00001l0?ooo`H0o`00C@3oool2000000l0oooo0`0000020?oo
o`030000003oool0oooo00L0oooo100000160?ooo`@000002@3oool20000oaL0oooo000_0?ooo`<0
0000O@3oool60?l004/0oooo0P00000>0?ooo`<00000103oool2000000@0oooo1P0000190?ooo`<0
0000203oool30000oaH0oooo000_0?ooo`800000P@3oool60?l004P0oooo0P00000=0?ooo`<00000
1P3oool2000000@0oooo0`00001<0?ooo`@000001`3oool20000oaH0oooo000_0?ooo`800000P`3o
ool80?l004@0oooo0P00000=0?ooo`8000001`3oool2000000@0oooo00<000000?ooo`3oool0C@3o
ool4000000H0oooo0P000?lF0?ooo`00;`3oool2000008L0oooo203o00100?ooo`8000003@3oool2
000000L0oooo0P0000050?ooo`030000003oool0oooo04h0oooo0`0000050?ooo`<0003o5@3oool0
02l0oooo0P00002;0?ooo`L0o`00>P3oool5000000h0oooo0P0000050?ooo`8000001P3oool60000
04`0oooo0`0000050?ooo`80003o5@3oool002l0oooo0P00002?0?ooo`H0o`00>@3oool300000100
oooo1P0000080?ooo`H00000C03oool4000000<0oooo0`000?lD0?ooo`008@3oool6000000P0oooo
0P00002B0?ooo`H0o`00ZP3oool4000000<0oooo0P000?lD0?ooo`008`3oool2000000X0oooo0P00
002E0?ooo`X0o`00Y@3oool300000080oooo0`000?lC0?ooo`008`3oool2000000X0oooo0P00002H
0?ooo`/0o`00XP3oool300000080oooo0P000?lC0?ooo`008`3oool2000000X0oooo0P00002O0?oo
o`P0o`00W`3oool3000000040?ooo`000?l0003o0000oa80oooo000S0?ooo`8000002P3oool20000
0:<0oooo4P3o002B0?ooo`<0000000<0oooo0000o`000?l04P3oool002<0oooo0P00000:0?ooo`80
0000Y`3ooolE0?l008`0oooo0`0000020000oa80oooo000S0?ooo`8000002P3oool200000;D0oooo
5@3o001o0?ooo`8000000`000?lA0?ooo`008`3oool2000000X0oooo0P00002l0?ooocD0o`00FP3o
ool00`000000003o0000o`0A0?ooo`008`3oool2000000X0oooo100000380?oooh80o`000`000?l@
0?ooo`008`3oool2000000X0oooo0P00003a0?oooe`0o`0000<0003o0?ooo`3oool03`3oool002<0
oooo0P00000:0?ooo`800000o`3ooomP0?ooo`008`3oool2000000X0oooo0P00003o0?ooof00oooo
000S0?ooo`8000002P3oool200000?l0ooooH03oool002<0oooo0P00000:0?ooo`800000o`3ooomP
0?ooo`008`3oool2000000X0oooo0P00003o0?ooof00oooo000P0?ooo`D000002P3oool200000?l0
ooooH03oool00280oooo0`00003o0?ooof`0oooo003o0?oooi40oooo003o0?oooi40oooo003o0?oo
oi40oooo003o0?oooi40oooo003o0?oooi40oooo003o0?oooi40oooo003o0?oooi40oooo0000\
\>"],
  ImageRangeCache->{{{0, 399}, {319, 0}} -> {-0.145125, -0.135325, \
0.00299633, 0.00374541}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<G:\Robert\Vorlesungen\Variationsrechnung\Pr\[ADoubleDot]\
sentation\Funktionale.png\>", funktionale]\)], "Input"],

Cell[BoxData[
    \("G:\\Robert\\Vorlesungen\\Variationsrechnung\\Pr\[ADoubleDot]sentation\\\
Funktionale.png"\)], "Output"]
}, Open  ]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"loesungsfunktion", "=", 
      RowBox[{"Plot", "[", 
        RowBox[{\(f1[x]\), ",", \({x, 0, 1}\), ",", 
          RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"{", 
              RowBox[{
                FormBox["Thickness",
                  "TraditionalForm"], "[", "0.006", "]"}], "}"}]}], ",", 
          RowBox[{"PlotStyle", "\[Rule]", " ", 
            RowBox[{"{", 
              RowBox[{"{", 
                RowBox[{
                  RowBox[{
                    StyleBox["RGBColor",
                      "MR"], 
                    StyleBox["[",
                      "MR"], 
                    RowBox[{
                      StyleBox["0",
                        "MR"], 
                      StyleBox[",",
                        "MR"], " ", "0", 
                      StyleBox[",",
                        "MR"], " ", "1"}], 
                    StyleBox["]",
                      "MR"]}], 
                  StyleBox[",",
                    "MR"], 
                  RowBox[{
                    FormBox["Thickness",
                      "TraditionalForm"], "[", "0.006", "]"}]}], 
                StyleBox["}",
                  "MR"]}], "}"}]}], ",", " ", \(ImageSize \[Rule] 400\), ",", 
          " ", \(AspectRatio \[Rule] 0.8\), 
          ",", \(TextStyle \[Rule] {FontFamily \[Rule] "\<Times\>", 
              FontSize \[Rule] fontSize}\)}], "]"}]}]], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .8 
%%ImageSize: 400 320 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0190476 0.761905 [
[.21429 .00655 -18.3125 -31.75 ]
[.21429 .00655 18.3125 0 ]
[.40476 .00655 -18.3125 -31.75 ]
[.40476 .00655 18.3125 0 ]
[.59524 .00655 -18.3125 -31.75 ]
[.59524 .00655 18.3125 0 ]
[.78571 .00655 -18.3125 -31.75 ]
[.78571 .00655 18.3125 0 ]
[.97619 .00655 -8.53125 -31.75 ]
[.97619 .00655 8.53125 0 ]
[.01131 .17143 -36.625 -15.875 ]
[.01131 .17143 0 15.875 ]
[.01131 .32381 -36.625 -15.875 ]
[.01131 .32381 0 15.875 ]
[.01131 .47619 -36.625 -15.875 ]
[.01131 .47619 0 15.875 ]
[.01131 .62857 -36.625 -15.875 ]
[.01131 .62857 0 15.875 ]
[.01131 .78095 -17.0625 -15.875 ]
[.01131 .78095 0 15.875 ]
[ -0.003 -0.003 0 0 ]
[ 1.003 .803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01905 m
.21429 .0253 L
s
gsave
.21429 .00655 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
1.000 setlinewidth
grestore
.40476 .01905 m
.40476 .0253 L
s
gsave
.40476 .00655 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
1.000 setlinewidth
grestore
.59524 .01905 m
.59524 .0253 L
s
gsave
.59524 .00655 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
1.000 setlinewidth
grestore
.78571 .01905 m
.78571 .0253 L
s
gsave
.78571 .00655 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
1.000 setlinewidth
grestore
.97619 .01905 m
.97619 .0253 L
s
gsave
.97619 .00655 -69.5313 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.125 Mabswid
.07143 .01905 m
.07143 .0228 L
s
.11905 .01905 m
.11905 .0228 L
s
.16667 .01905 m
.16667 .0228 L
s
.2619 .01905 m
.2619 .0228 L
s
.30952 .01905 m
.30952 .0228 L
s
.35714 .01905 m
.35714 .0228 L
s
.45238 .01905 m
.45238 .0228 L
s
.5 .01905 m
.5 .0228 L
s
.54762 .01905 m
.54762 .0228 L
s
.64286 .01905 m
.64286 .0228 L
s
.69048 .01905 m
.69048 .0228 L
s
.7381 .01905 m
.7381 .0228 L
s
.83333 .01905 m
.83333 .0228 L
s
.88095 .01905 m
.88095 .0228 L
s
.92857 .01905 m
.92857 .0228 L
s
.006 w
0 .01905 m
1 .01905 L
s
.25 Mabswid
.02381 .17143 m
.03006 .17143 L
s
gsave
.01131 .17143 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
1.000 setlinewidth
grestore
.02381 .32381 m
.03006 .32381 L
s
gsave
.01131 .32381 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
1.000 setlinewidth
grestore
.02381 .47619 m
.03006 .47619 L
s
gsave
.01131 .47619 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
1.000 setlinewidth
grestore
.02381 .62857 m
.03006 .62857 L
s
gsave
.01131 .62857 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
1.000 setlinewidth
grestore
.02381 .78095 m
.03006 .78095 L
s
gsave
.01131 .78095 -78.0625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.125 Mabswid
.02381 .05714 m
.02756 .05714 L
s
.02381 .09524 m
.02756 .09524 L
s
.02381 .13333 m
.02756 .13333 L
s
.02381 .20952 m
.02756 .20952 L
s
.02381 .24762 m
.02756 .24762 L
s
.02381 .28571 m
.02756 .28571 L
s
.02381 .3619 m
.02756 .3619 L
s
.02381 .4 m
.02756 .4 L
s
.02381 .4381 m
.02756 .4381 L
s
.02381 .51429 m
.02756 .51429 L
s
.02381 .55238 m
.02756 .55238 L
s
.02381 .59048 m
.02756 .59048 L
s
.02381 .66667 m
.02756 .66667 L
s
.02381 .70476 m
.02756 .70476 L
s
.02381 .74286 m
.02756 .74286 L
s
.006 w
.02381 0 m
.02381 .8 L
s
0 0 m
1 0 L
1 .8 L
0 .8 L
closepath
clip
newpath
0 0 1 r
.02381 .01905 m
.06244 .04996 L
.10458 .08366 L
.14415 .11532 L
.18221 .14577 L
.22272 .17817 L
.26171 .20937 L
.30316 .24252 L
.34309 .27447 L
.3815 .3052 L
.42237 .33789 L
.46172 .36937 L
.49955 .39964 L
.53984 .43187 L
.57861 .46289 L
.61984 .49587 L
.65954 .52764 L
.69774 .55819 L
.73838 .59071 L
.77751 .62201 L
.81909 .65528 L
.85916 .68733 L
.89771 .71817 L
.93871 .75097 L
.97619 .78095 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{400, 320},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0001@2000`400?l00000o`00003oo`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00IP3oool4000000L0oooo0P00
00040?ooo`X00000:03oool4000000L0oooo0P00000;0?ooo`800000:@3oool4000000L0oooo0P00
00070?ooo`D00000:P3oool4000000L0oooo0P0000070?ooo`D00000<`3oool6000000l0oooo001U
0?ooo`8000000`3oool2000000D0oooo0P0000050?ooo`T000009`3oool2000000<0oooo0P000005
0?ooo`8000002`3oool2000002P0oooo0P0000030?ooo`8000001@3oool2000000H0oooo0P000003
0?ooo`800000:03oool2000000<0oooo0P0000050?ooo`8000001@3oool3000000@0oooo0P00000c
0?ooo`8000004@3oool006D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00@0oooo0P00000V0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0403oool2000002P0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0:0?oo
o`8000001@3oool2000002L0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`090?oo
o`<000001P3oool200000380oooo0P00000A0?ooo`00I03oool2000000D0oooo0P00000=0?ooo`03
0000003oool0oooo02X0oooo0P0000050?ooo`8000004@3oool2000002L0oooo0P0000050?ooo`80
00002`3oool2000000H0oooo00<000000?ooo`3oool0903oool2000000D0oooo0P00000:0?ooo`80
00001`3oool200000380oooo0P00000A0?ooo`00I03oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00P0oooo2`00000U0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
203oool2000000L0oooo0P00000U0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
203oool2000000L0oooo0P00000b0?ooo`8000004@3oool006<0oooo0P0000070?ooo`8000003P3o
ool00`000000oooo0?ooo`0W0?ooo`8000001`3oool2000000T0oooo00<000000?ooo`3oool0103o
ool2000002H0oooo0P0000070?ooo`8000002@3oool2000000L0oooo0P00000T0?ooo`8000001`3o
ool2000000T0oooo0P0000060?ooo`<00000<P3oool200000140oooo001S0?ooo`8000001`3oool2
000000l0oooo00<000000?ooo`3oool09P3oool2000000L0oooo0P00000:0?ooo`030000003oool0
oooo00<0oooo0P00000V0?ooo`8000001`3oool2000000T0oooo0P0000070?ooo`800000903oool2
000000L0oooo0P00000:0?ooo`800000103oool3000003<0oooo0P00000A0?ooo`00H`3oool20000
00L0oooo0P00000?0?ooo`030000003oool0oooo02H0oooo0P0000070?ooo`8000002`3oool00`00
0000oooo0?ooo`020?ooo`8000009P3oool2000000L0oooo0P0000090?ooo`8000001`3oool20000
02@0oooo0P0000070?ooo`8000002`3oool010000000oooo0?ooo`3oool3000003@0oooo0P00000A
0?ooo`00H`3oool2000000L0oooo0P00000@0?ooo`030000003oool0oooo02D0oooo0P0000070?oo
o`8000002`3oool00`000000oooo0?ooo`020?ooo`8000009P3oool2000000L0oooo0P0000090?oo
o`8000001P3oool2000002D0oooo0P0000070?ooo`800000303oool5000003D0oooo0P00000A0?oo
o`00H`3oool2000000L0oooo0P00000A0?ooo`030000003oool0oooo02@0oooo0P0000070?ooo`80
0000303oool010000000oooo0?ooo`3oool2000002H0oooo0P0000070?ooo`8000002@3oool40000
00<0oooo0`00000U0?ooo`8000001`3oool2000000`0oooo1000000f0?ooo`8000004@3oool006<0
oooo0P0000070?ooo`8000004@3oool00`000000oooo0?ooo`0T0?ooo`8000001`3oool2000000d0
oooo00<000000?ooo`3oool00P00000V0?ooo`8000001`3oool2000000X0oooo0P0000000`3oool0
000000000002000002L0oooo0P0000070?ooo`8000002`3oool300000080oooo00<000000?ooo`3o
ool0<`3oool200000140oooo001S0?ooo`8000001`3oool200000140oooo0P00000U0?ooo`800000
1`3oool2000000d0oooo00<000000?ooo`3oool00P00000V0?ooo`8000001`3oool2000000X0oooo
0P00000/0?ooo`8000001`3oool2000000X0oooo0`0000040?ooo`800000<`3oool200000140oooo
001T0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`050?ooo`8000009P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00d0oooo00@0
00000?ooo`00000000009`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00X0oooo
0P00000/0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool3000000H0oooo
0P00000b0?ooo`8000004@3oool006@0oooo0P0000050?ooo`8000002P3oool00`000000oooo0?oo
o`050?ooo`8000009P3oool2000000D0oooo0P00000?0?ooo`040000003oool00000000002L0oooo
0P0000050?ooo`8000003@3oool2000002/0oooo0P0000050?ooo`8000002P3oool2000000L0oooo
0P00000b0?ooo`8000004@3oool006D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo0080oooo1000000W0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool03`3oool3000002P0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`0=0?ooo`800000:`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00T0oooo0P00
00070?ooo`800000<P3oool200000140oooo001U0?ooo`8000000`3oool2000000`0oooo2000000X
0?ooo`8000000`3oool200000180oooo0P00000X0?ooo`8000000`3oool200000100oooo0`00000Y
0?ooo`8000000`3oool2000000`0oooo0P0000050?ooo`800000<03oool500000140oooo001W0?oo
o`<00000403oool4000002`0oooo0`00000D0?ooo`800000:P3oool3000001@0oooo1000000X0?oo
o`<00000403oool6000003<0oooo0`00000A0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3o
oonA0?ooo`00o`3ooonA0?ooo`00;`3oool200000?l0ooooH03oool002l0oooo0P00003o0?ooof00
oooo000_0?ooo`800000o`3ooomP0?ooo`00;`3oool200000?l0ooooH03oool002l0oooo0P00003o
0?ooof00oooo000_0?ooo`800000o`3ooomP0?ooo`00;`3oool00`000000003o0?ooo`3o0?oooel0
oooo000W0?ooo`P000000`000?oo000005H000002@3oool002L0oooo2@0000040000ool00000E000
00090?ooo`00;`3oool2000000@0003o?P3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0
oooo0400oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`100?ooo`030000003oool0
oooo00l0oooo000_0?ooo`8000000P3oool30000ool0ooooF`3oool002l0oooo0P0000030?ooo`<0
003oo`3ooomJ0?ooo`00;`3oool2000000@0oooo10000?oo0?oooeP0oooo000_0?ooo`8000001@3o
ool40000ool0ooooE`3oool002l0oooo0P0000070?ooo`<0003oo`3ooomF0?ooo`00;`3oool20000
00P0oooo10000?oo0?oooe@0oooo000_0?ooo`8000002@3oool40000ool0ooooD`3oool002l0oooo
0P00000;0?ooo`<0003oo`3ooomB0?ooo`00;`3oool2000000`0oooo0`000?oo0?oooe40oooo000_
0?ooo`8000003@3oool40000ool0ooooC`3oool002l0oooo0`00000=0?ooo`@0003oo`3ooom>0?oo
o`00;`3oool200000100oooo0`000?oo0?ooodd0oooo000_0?ooo`8000004@3oool30000ool0oooo
C03oool002l0oooo0P00000B0?ooo`@0003oo`3ooom:0?ooo`00;`3oool2000001<0oooo10000?oo
0?ooodT0oooo000_0?ooo`8000005@3oool30000ool0ooooB03oool002l0oooo0P00000F0?ooo`<0
003oo`3ooom70?ooo`00;`3oool2000001L0oooo10000?oo0?ooodD0oooo000_0?ooo`800000603o
ool40000ool0ooooA03oool002l0oooo0P00000J0?ooo`<0003oo`3ooom30?ooo`00;`3oool20000
01/0oooo10000?oo0?oood40oooo000_0?ooo`800000703oool40000ool0oooo@03oool002l0oooo
0P00000N0?ooo`<0003oo`3ooolo0?ooo`00;`3oool3000001h0oooo0`000?oo0?oooch0oooo000_
0?ooo`800000803oool40000ool0oooo?03oool002l0oooo0P00000Q0?ooo`@0003oo`3ooolk0?oo
o`00;`3oool2000002<0oooo0`000?oo0?ooocX0oooo000_0?ooo`800000903oool30000ool0oooo
>@3oool002l0oooo0P00000U0?ooo`@0003oo`3ooolg0?ooo`00;`3oool2000002H0oooo10000?oo
0?ooocH0oooo000_0?ooo`800000:03oool30000ool0oooo=@3oool002l0oooo0P00000Y0?ooo`<0
003oo`3ooold0?ooo`00;`3oool2000002X0oooo10000?oo0?oooc80oooo000_0?ooo`800000:`3o
ool40000ool0oooo<@3oool002l0oooo0P00000]0?ooo`<0003oo`3oool`0?ooo`00;`3oool20000
02h0oooo0`000?oo0?ooobl0oooo000_0?ooo`800000;`3oool30000ool0oooo;P3oool002l0oooo
0`00000_0?ooo`<0003oo`3oool]0?ooo`00;`3oool200000340oooo10000?oo0?ooob/0oooo000_
0?ooo`800000<P3oool40000ool0oooo:P3oool002l0oooo0P00000d0?ooo`<0003oo`3ooolY0?oo
o`00;`3oool2000003D0oooo0`000?oo0?ooobP0oooo000=0?ooo`@000001`3oool2000000@0oooo
2P0000070?ooo`800000=P3oool40000ool0oooo9P3oool000`0oooo0P0000030?ooo`8000001@3o
ool2000000D0oooo2@0000070?ooo`800000=`3oool40000ool0oooo9@3oool000`0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo0P000006
0?ooo`800000>@3oool30000ool0oooo903oool000/0oooo0P0000050?ooo`8000003@3oool00`00
0000oooo0?ooo`0;0?ooo`800000>P3oool40000ool0oooo8P3oool000/0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00X0oooo0P00000k0?ooo`@0
003oo`3ooolQ0?ooo`002P3oool2000000L0oooo0P00000>0?ooo`030000003oool0oooo00T0oooo
0P00000m0?ooo`@0003oo`3ooolO0?ooo`002P3oool2000000L0oooo0P00000?0?ooo`030000003o
ool0oooo00P0oooo0P00000n0?ooo`@0003oo`3ooolN0?ooo`002P3oool2000000L0oooo0P00000?
0?ooo`030000003oool0oooo00P0oooo0P0000100?ooo`<0003oo`3ooolM0?ooo`002P3oool20000
00L0oooo0P00000@0?ooo`030000003oool0oooo00L0oooo1000000o0?ooo`@0003oo`3ooolK0?oo
o`002P3oool2000000L0oooo0P00000A0?ooo`030000003oool0oooo00H0oooo0P0000120?ooo`@0
003oo`3ooolJ0?ooo`002P3oool2000000L0oooo0P00000A0?ooo`030000003oool0oooo00H0oooo
0P0000140?ooo`<0003oo`3ooolI0?ooo`002P3oool2000000L0oooo0P00000A0?ooo`8000001`3o
ool2000004D0oooo0`000?oo0?oooaP0oooo000;0?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`8000001`3oool2000004H0oooo10000?oo
0?oooaH0oooo000;0?ooo`8000001@3oool2000000X0oooo00<000000?ooo`3oool01@3oool20000
00L0oooo0P0000170?ooo`@0003oo`3ooolE0?ooo`00303oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00X0oooo00<000000?ooo`3oool00P3oool4000000L0oooo0P0000190?ooo`<0
003oo`3ooolD0?ooo`00303oool2000000<0oooo0P00000<0?ooo`P00000203oool2000004X0oooo
0`000?oo0?oooa<0oooo000>0?ooo`<00000403oool4000000X0oooo0P00001;0?ooo`<0003oo`3o
oolB0?ooo`00;`3oool2000004`0oooo0`000?oo0?oooa40oooo000_0?ooo`800000C@3oool40000
ool0oooo3`3oool002l0oooo0P00001>0?ooo`@0003oo`3oool>0?ooo`00;`3oool200000500oooo
0`000?oo0?ooo`d0oooo000_0?ooo`<00000D03oool30000ool0oooo303oool002l0oooo0P00001B
0?ooo`<0003oo`3oool;0?ooo`00;`3oool2000005<0oooo10000?oo0?ooo`T0oooo000_0?ooo`80
0000E03oool40000ool0oooo203oool002l0oooo0P00001F0?ooo`<0003oo`3oool70?ooo`00;`3o
ool2000005L0oooo0`000?oo0?ooo`H0oooo000_0?ooo`800000F03oool40000ool0oooo103oool0
02l0oooo0P00001I0?ooo`@0003oo`3oool30?ooo`00;`3oool2000005/0oooo0`000?oo0?ooo`80
oooo000_0?ooo`800000G03oool30000ool0oooo0@3oool002l0oooo0P00001M0?ooo`@0003ooP3o
ool002l0oooo0P00001N0?ooo`@0003oo@3oool002l0oooo0P00001P0?ooo`<0003oo03oool002l0
oooo0P00001Q0?ooo`@0003onP3oool002l0oooo0`00001Q0?ooo`@0003on@3oool002l0oooo0P00
001T0?ooo`<0003on03oool002l0oooo0P00001U0?ooo`<0003om`3oool002l0oooo0P00001V0?oo
o`@0003om@3oool002l0oooo0P00001W0?ooo`@0003om03oool002l0oooo0P00001Y0?ooo`<0003o
l`3oool002l0oooo0P00001Z0?ooo`<0003olP3oool002l0oooo0P00001[0?ooo`@0003ol03oool0
02l0oooo0P00001/0?ooo`@0003ok`3oool002l0oooo0P00001^0?ooo`<0003okP3oool002l0oooo
0P00001_0?ooo`<0003ok@3oool002l0oooo0P00001`0?ooo`@0003oj`3oool002l0oooo0P00001a
0?ooo`@0003ojP3oool002l0oooo0`00001b0?ooo`<0003oj@3oool002l0oooo0P00001d0?ooo`<0
003oj03oool002l0oooo0P00001e0?ooo`<0003oi`3oool002l0oooo0P00001f0?ooo`<0003oiP3o
ool002l0oooo0P00001g0?ooo`@0003oi03oool002l0oooo0P00001h0?ooo`@0003oh`3oool000d0
oooo100000070?ooo`8000002`3oool2000000P0oooo0P00001j0?ooo`<0003ohP3oool000`0oooo
0P0000030?ooo`8000001@3oool2000000/0oooo0P0000080?ooo`800000N`3oool30000on40oooo
000<0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0403oool2000000P0oooo0P00
001l0?ooo`@0003og`3oool000/0oooo0P0000050?ooo`8000004@3oool2000000P0oooo0P00001m
0?ooo`@0003ogP3oool000/0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?oo
o`/000001P3oool2000007l0oooo0`000?oM0?ooo`002P3oool2000000L0oooo0P0000090?ooo`03
0000003oool0oooo00@0oooo0P0000080?ooo`800000P03oool40000om/0oooo000:0?ooo`800000
1`3oool2000000X0oooo00<000000?ooo`3oool00`3oool2000000P0oooo0P0000210?ooo`@0003o
fP3oool000X0oooo0P0000070?ooo`8000002`3oool00`000000oooo0?ooo`020?ooo`800000203o
ool400000840oooo10000?oH0?ooo`002P3oool2000000L0oooo0P00000;0?ooo`030000003oool0
oooo0080oooo0P0000080?ooo`800000Q03oool40000omL0oooo000:0?ooo`8000001`3oool20000
00`0oooo00@000000?ooo`3oool0oooo0P0000080?ooo`800000QP3oool30000omH0oooo000:0?oo
o`8000001`3oool2000000d0oooo00<000000?ooo`3oool00P0000080?ooo`800000Q`3oool40000
om@0oooo000:0?ooo`8000001`3oool2000000d0oooo00<000000?ooo`3oool00P0000080?ooo`80
0000R03oool40000om<0oooo000;0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
3@3oool010000000oooo0000000000080?ooo`800000RP3oool30000om80oooo000;0?ooo`800000
1@3oool2000000l0oooo00@000000?ooo`0000000000203oool2000008/0oooo0`000?oA0?ooo`00
303oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00l0oooo0`0000080?ooo`800000
S03oool40000oll0oooo000<0?ooo`8000000`3oool200000180oooo0P0000080?ooo`800000S@3o
ool40000olh0oooo000>0?ooo`<00000503oool2000000P0oooo0P00002?0?ooo`<0003oc@3oool0
02l0oooo0P00002@0?ooo`<0003oc03oool002l0oooo0P00002A0?ooo`<0003ob`3oool002l0oooo
0P00002B0?ooo`<0003obP3oool002l0oooo0P00002C0?ooo`@0003ob03oool002l0oooo0`00002C
0?ooo`@0003oa`3oool002l0oooo0P00002F0?ooo`<0003oaP3oool002l0oooo0P00002G0?ooo`<0
003oa@3oool002l0oooo0P00002H0?ooo`@0003o``3oool002l0oooo0P00002I0?ooo`@0003o`P3o
ool002l0oooo0P00002K0?ooo`<0003o`@3oool002l0oooo0P00002L0?ooo`<0003o`03oool002l0
oooo0P00002M0?ooo`@0003o_P3oool002l0oooo0P00002N0?ooo`@0003o_@3oool002l0oooo0P00
002P0?ooo`<0003o_03oool002l0oooo0P00002Q0?ooo`<0003o^`3oool002l0oooo0P00002R0?oo
o`@0003o^@3oool002l0oooo0P00002S0?ooo`@0003o^03oool002l0oooo0`00002T0?ooo`<0003o
]`3oool002l0oooo0P00002V0?ooo`@0003o]@3oool002l0oooo0P00002W0?ooo`@0003o]03oool0
02l0oooo0P00002Y0?ooo`<0003o/`3oool002l0oooo0P00002Z0?ooo`<0003o/P3oool002l0oooo
0P00002[0?ooo`@0003o/03oool002l0oooo0P00002/0?ooo`@0003o[`3oool002l0oooo0P00002^
0?ooo`<0003o[P3oool002l0oooo0P00002_0?ooo`<0003o[@3oool002l0oooo0P00002`0?ooo`@0
003oZ`3oool002l0oooo0P00002a0?ooo`@0003oZP3oool002l0oooo0P00002c0?ooo`<0003oZ@3o
ool002l0oooo0P00002d0?ooo`<0003oZ03oool002l0oooo0`00002d0?ooo`@0003oYP3oool002l0
oooo0P00002f0?ooo`@0003oY@3oool002l0oooo0P00002h0?ooo`<0003oY03oool002l0oooo0P00
002i0?ooo`<0003oX`3oool002l0oooo0P00002j0?ooo`<0003oXP3oool002l0oooo0P00002k0?oo
o`<0003oX@3oool000d0oooo100000070?ooo`8000001`3oool5000000T0oooo0P00002l0?ooo`@0
003oW`3oool000`0oooo0P0000030?ooo`8000001@3oool2000000H0oooo0P0000030?ooo`800000
203oool200000;d0oooo10000?nN0?ooo`00303oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo00X0oooo0P0000050?ooo`8000001`3oool200000;l0oooo0`000?nM0?ooo`002`3oool2
000000D0oooo0P00000;0?ooo`8000001P3oool00`000000oooo0?ooo`050?ooo`800000`03oool3
0000oi`0oooo000;0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool20000
00L0oooo0P0000060?ooo`800000`@3oool30000oi/0oooo000:0?ooo`8000001`3oool2000000T0
oooo0P0000070?ooo`8000001P3oool200000<80oooo10000?nI0?ooo`002P3oool2000000L0oooo
0P0000090?ooo`8000001`3oool2000000H0oooo0P0000330?ooo`@0003oV03oool000X0oooo0P00
00070?ooo`8000002@3oool2000000L0oooo0P0000060?ooo`800000a@3oool30000oiL0oooo000:
0?ooo`8000001`3oool2000000T0oooo0P0000060?ooo`8000001`3oool400000<@0oooo0`000?nF
0?ooo`002P3oool2000000L0oooo0P0000090?ooo`@000000`3oool3000000L0oooo0P0000370?oo
o`@0003oU03oool000X0oooo0P0000070?ooo`8000002P3oool2000000030?ooo`00000000000080
00002@3oool200000<P0oooo10000?nC0?ooo`002P3oool2000000L0oooo0P00000:0?ooo`800000
3P3oool200000<X0oooo0`000?nB0?ooo`002`3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00X0oooo0P00000=0?ooo`800000b`3oool30000oi40oooo000;0?ooo`8000001@3oool2
000000d0oooo0P00000<0?ooo`800000c03oool40000ohl0oooo000<0?ooo`030000003oool0oooo
00<0oooo00<000000?ooo`3oool03@3oool2000000/0oooo0P00003=0?ooo`@0003oSP3oool000`0
oooo0P0000030?ooo`800000403oool3000000T0oooo0P00003?0?ooo`<0003oS@3oool000h0oooo
0`00000D0?ooo`@000001P3oool200000=00oooo10000?n;0?ooo`00;`3oool200000=40oooo1000
0?n:0?ooo`00;`3oool200000=<0oooo0`000?n90?ooo`00;`3oool200000=@0oooo0`000?n80?oo
o`00;`3oool200000=D0oooo10000?n60?ooo`00;`3oool300000=D0oooo10000?n50?ooo`00;`3o
ool200000=P0oooo0`000?n40?ooo`00;`3oool200000=T0oooo0`000?n30?ooo`00;`3oool20000
0=X0oooo10000?n10?ooo`00;`3oool200000=/0oooo10000?n00?ooo`00;`3oool200000=d0oooo
0`000?mo0?ooo`00;`3oool200000=h0oooo0`000?mn0?ooo`00;`3oool200000=l0oooo10000?ml
0?ooo`00;`3oool200000>00oooo10000?mk0?ooo`00;`3oool200000>80oooo0`000?mj0?ooo`00
;`3oool200000><0oooo0`000?mi0?ooo`00;`3oool200000>@0oooo0`000?mh0?ooo`00;`3oool2
00000>D0oooo0`000?mg0?ooo`00;`3oool200000>H0oooo10000?me0?ooo`00;`3oool300000>H0
oooo10000?md0?ooo`00;`3oool200000>T0oooo0`000?mc0?ooo`00;`3oool200000>X0oooo0`00
0?mb0?ooo`00;`3oool200000>/0oooo10000?m`0?ooo`00;`3oool200000>`0oooo10000?m_0?oo
o`00;`3oool200000>h0oooo0`000?m^0?ooo`00;`3oool200000>l0oooo0`000?m]0?ooo`00;`3o
ool200000?00oooo10000?m[0?ooo`00;`3oool200000?40oooo10000?mZ0?ooo`00;`3oool20000
0?<0oooo0`000?mY0?ooo`00;`3oool200000?@0oooo0`000?mX0?ooo`00;`3oool200000?D0oooo
10000?mV0?ooo`00;`3oool200000?H0oooo10000?mU0?ooo`00;`3oool300000?L0oooo0`000?mT
0?ooo`00;`3oool200000?T0oooo10000?mR0?ooo`00;`3oool200000?X0oooo10000?mQ0?ooo`00
;`3oool200000?`0oooo0`000?mP0?ooo`00;`3oool200000?d0oooo0`000?mO0?ooo`00;`3oool2
00000?h0oooo10000?mM0?ooo`003@3oool4000000L0oooo0P0000070?ooo`D000002@3oool20000
0?l0oooo10000?mL0?ooo`00303oool2000000<0oooo0P0000050?ooo`8000001@3oool3000000@0
oooo0P0000070?ooo`800000o`3oool20?ooo`<0003oF`3oool000`0oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`090?ooo`<000001P3oool2000000H0oooo0P00003o0?ooo`<0oooo
0`000?mJ0?ooo`002`3oool2000000D0oooo0P00000:0?ooo`8000001`3oool2000000H0oooo0P00
003o0?ooo`@0oooo10000?mH0?ooo`002`3oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00P0oooo0P0000070?ooo`8000001P3oool200000?l0oooo1@3oool40000oeL0oooo000:0?oo
o`8000001`3oool2000000T0oooo0P0000060?ooo`<000001P3oool200000?l0oooo1`3oool30000
oeH0oooo000:0?ooo`8000001`3oool2000000X0oooo0P0000040?ooo`<000001`3oool200000?l0
oooo203oool30000oeD0oooo000:0?ooo`8000001`3oool2000000/0oooo00@000000?ooo`3oool0
oooo0`0000080?ooo`@00000o`3oool70?ooo`@0003oD`3oool000X0oooo0P0000070?ooo`800000
303oool5000000T0oooo0P00003o0?ooo`X0oooo10000?mB0?ooo`002P3oool2000000L0oooo0P00
000<0?ooo`@000002P3oool200000?l0oooo303oool30000oe40oooo000:0?ooo`8000001`3oool2
000000/0oooo0`0000020?ooo`030000003oool0oooo00L0oooo0P00003o0?ooo`d0oooo0`000?m@
0?ooo`002P3oool2000000L0oooo0P00000:0?ooo`<00000103oool2000000L0oooo0P00003o0?oo
o`h0oooo10000?m>0?ooo`002`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0
oooo0`0000060?ooo`8000001P3oool200000?l0oooo3`3oool40000odd0oooo000;0?ooo`800000
1@3oool2000000X0oooo0P0000070?ooo`8000001P3oool200000?l0oooo4@3oool30000od`0oooo
000<0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool02@3oool2000000L0oooo0P00
00060?ooo`800000o`3ooolB0?ooo`<0003oB`3oool000`0oooo0P0000030?ooo`800000303oool2
000000D0oooo0P0000070?ooo`800000o`3ooolC0?ooo`@0003oB@3oool000h0oooo0`00000@0?oo
o`H00000203oool200000?l0oooo503oool40000odP0oooo000_0?ooo`800000o`3ooolF0?ooo`<0
003oA`3oool002l0oooo0P00003o0?oooaL0oooo10000?m50?ooo`00;`3oool200000?l0oooo603o
ool40000od@0oooo000_0?ooo`800000o`3ooolJ0?ooo`<0003o@`3oool002l0oooo0`00003o0?oo
oaX0oooo0`000?m20?ooo`00;`3oool200000?l0oooo703oool40000od00oooo000_0?ooo`800000
o`3ooolM0?ooo`@0003o?`3oool002l0oooo0P00003o0?oooal0oooo0`000?ln0?ooo`00;`3oool2
00000?l0oooo803oool30000ocd0oooo000_0?ooo`800000o`3ooolQ0?ooo`@0003o>`3oool002l0
oooo0P00003o0?ooob80oooo10000?lj0?ooo`00;`3oool200000?l0oooo903oool30000ocT0oooo
000_0?ooo`800000o`3ooolU0?ooo`<0003o>03oool002l0oooo0P00003o0?ooobH0oooo10000?lf
0?ooo`00;`3oool200000?l0oooo9`3oool40000ocD0oooo000_0?ooo`800000o`3ooolY0?ooo`<0
003o=03oool002l0oooo0P00003o0?ooobX0oooo0`000?lc0?ooo`00;`3oool300000?l0oooo:P3o
ool30000oc80oooo000_0?ooo`800000o`3oool/0?ooo`<0003o<@3oool002l0oooo0P00003o0?oo
obd0oooo10000?l_0?ooo`00;`3oool200000?l0oooo;P3oool40000obh0oooo000_0?ooo`800000
o`3oool`0?ooo`<0003o;@3oool002l0oooo0P00003o0?oooc40oooo0`000?l/0?ooo`00;`3oool2
00000?l0oooo<P3oool40000obX0oooo000_0?ooo`800000o`3ooolc0?ooo`@0003o:@3oool002l0
oooo0P00003o0?ooocD0oooo0`000?lX0?ooo`00;`3oool200000?l0oooo=P3oool40000obH0oooo
000_0?ooo`800000o`3ooolg0?ooo`@0003o9@3oool002l0oooo0P00003o0?ooocT0oooo10000?lS
0?ooo`00;`3oool200000?l0oooo>P3oool40000ob80oooo000_0?ooo`<00000o`3ooolk0?ooo`<0
003o8@3oool002l0oooo0P00003o0?ooocd0oooo10000?lO0?ooo`00;`3oool200000?l0oooo?P3o
ool40000oah0oooo000_0?ooo`800000o`3ooom00?ooo`<0003o7@3oool002l0oooo0P00003o0?oo
od40oooo0`000?lL0?ooo`00;`3oool200000?l0oooo@P3oool40000oaX0oooo000Q0?ooo`H00000
203oool200000?l0oooo@`3oool40000oaT0oooo000S0?ooo`8000002P3oool200000?l0ooooA@3o
ool30000oaP0oooo000S0?ooo`8000002P3oool200000?l0ooooAP3oool30000oaL0oooo000S0?oo
o`8000002P3oool200000?l0ooooA`3oool30000oaH0oooo000S0?ooo`8000002P3oool200000?l0
ooooB03oool30000oaD0oooo000S0?ooo`8000002P3oool200000?l0ooooB@3oool40000oa<0oooo
000S0?ooo`8000002P3oool200000?l0ooooBP3oool40000oa80oooo000S0?ooo`8000002P3oool2
00000?l0ooooC03oool30000oa40oooo000S0?ooo`8000002P3oool400000?l0ooooB`3oool30000
oa00oooo000S0?ooo`8000002P3oool200000?l0ooooCP3oool00`000?l0oooo0?ooo`0?0?ooo`00
8`3oool2000000X0oooo0P00003o0?ooof00oooo000S0?ooo`8000002P3oool200000?l0ooooH03o
ool002<0oooo0P00000:0?ooo`800000o`3ooomP0?ooo`008`3oool2000000X0oooo0P00003o0?oo
of00oooo000S0?ooo`8000002P3oool200000?l0ooooH03oool00200oooo1@00000:0?ooo`800000
o`3ooomP0?ooo`008P3oool300000?l0ooooK03oool00?l0ooooT@3oool00?l0ooooT@3oool00?l0
ooooT@3oool00?l0ooooT@3oool00?l0ooooT@3oool00?l0ooooT@3oool00?l0ooooT@3oool00001
\
\>"],
  ImageRangeCache->{{{0, 399}, {319, 0}} -> {-0.145125, -0.135325, \
0.00299633, 0.00374541}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<G:\Robert\Vorlesungen\Variationsrechnung\Pr\[ADoubleDot]\
sentation\Loesungsfunktion.png\>", loesungsfunktion]\)], "Input"],

Cell[BoxData[
    \("G:\\Robert\\Vorlesungen\\Variationsrechnung\\Pr\[ADoubleDot]sentation\\\
Loesungsfunktion.png"\)], "Output"]
}, Open  ]],

Cell[BoxData[{
    \(v[x_] := 0.2\ Sin[x*Pi]\), "\[IndentingNewLine]", 
    \(w[x_] := 1 - 4*\((x - 0.5)\)^2\)}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"\[IndentingNewLine]", 
      RowBox[{"Plot", "[", 
        RowBox[{\(w[x]\), ",", \({x, \ 0, 1}\), ",", 
          RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"{", 
              RowBox[{
                FormBox["Thickness",
                  "TraditionalForm"], "[", "0.006", "]"}], "}"}]}], ",", 
          RowBox[{"PlotStyle", "\[Rule]", " ", 
            RowBox[{"{", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{
                      StyleBox["RGBColor",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      RowBox[{
                        StyleBox["1",
                          "MR"], 
                        StyleBox[",",
                          "MR"], " ", "0", 
                        StyleBox[",",
                          "MR"], " ", "0"}], 
                      StyleBox["]",
                        "MR"]}], 
                    StyleBox[",",
                      "MR"], 
                    RowBox[{
                      FormBox["Thickness",
                        "TraditionalForm"], "[", "0.006", "]"}]}], 
                  StyleBox["}",
                    "MR"]}], 
                StyleBox[",",
                  "MR"], 
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{
                      StyleBox["RGBColor",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      RowBox[{
                        StyleBox["0",
                          "MR"], 
                        StyleBox[",",
                          "MR"], " ", "0", 
                        StyleBox[",",
                          "MR"], 
                        StyleBox["0",
                          "MR"]}], 
                      StyleBox["]",
                        "MR"]}], 
                    StyleBox[",",
                      "MR"], 
                    RowBox[{
                      FormBox["Thickness",
                        "TraditionalForm"], "[", "0.006", "]"}]}], 
                  StyleBox["}",
                    "MR"]}], 
                StyleBox[",",
                  "MR"], 
                StyleBox[
                  RowBox[{"{", 
                    RowBox[{\(RGBColor[0, 0, 1]\), ",", 
                      RowBox[{
                        FormBox["Thickness",
                          "TraditionalForm"], "[", "0.006", "]"}]}], "}"}],
                  "MR"], 
                StyleBox[",",
                  "MR"]}], "}"}]}], ",", " ", \(ImageSize \[Rule] 400\), ",", 
          " ", \(AspectRatio \[Rule] 0.8\), 
          ",", \(TextStyle \[Rule] {FontFamily \[Rule] "\<Times\>", 
              FontSize \[Rule] fontSize}\)}], "]"}]}]], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .8 
%%ImageSize: 400 320 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0190476 0.761906 [
[.21429 .00655 -18.3125 -31.75 ]
[.21429 .00655 18.3125 0 ]
[.40476 .00655 -18.3125 -31.75 ]
[.40476 .00655 18.3125 0 ]
[.59524 .00655 -18.3125 -31.75 ]
[.59524 .00655 18.3125 0 ]
[.78571 .00655 -18.3125 -31.75 ]
[.78571 .00655 18.3125 0 ]
[.97619 .00655 -8.53125 -31.75 ]
[.97619 .00655 8.53125 0 ]
[.01131 .17143 -36.625 -15.875 ]
[.01131 .17143 0 15.875 ]
[.01131 .32381 -36.625 -15.875 ]
[.01131 .32381 0 15.875 ]
[.01131 .47619 -36.625 -15.875 ]
[.01131 .47619 0 15.875 ]
[.01131 .62857 -36.625 -15.875 ]
[.01131 .62857 0 15.875 ]
[.01131 .78095 -17.0625 -15.875 ]
[.01131 .78095 0 15.875 ]
[ -0.003 -0.003 0 0 ]
[ 1.003 .803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01905 m
.21429 .0253 L
s
gsave
.21429 .00655 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
1.000 setlinewidth
grestore
.40476 .01905 m
.40476 .0253 L
s
gsave
.40476 .00655 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
1.000 setlinewidth
grestore
.59524 .01905 m
.59524 .0253 L
s
gsave
.59524 .00655 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
1.000 setlinewidth
grestore
.78571 .01905 m
.78571 .0253 L
s
gsave
.78571 .00655 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
1.000 setlinewidth
grestore
.97619 .01905 m
.97619 .0253 L
s
gsave
.97619 .00655 -69.5313 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.125 Mabswid
.07143 .01905 m
.07143 .0228 L
s
.11905 .01905 m
.11905 .0228 L
s
.16667 .01905 m
.16667 .0228 L
s
.2619 .01905 m
.2619 .0228 L
s
.30952 .01905 m
.30952 .0228 L
s
.35714 .01905 m
.35714 .0228 L
s
.45238 .01905 m
.45238 .0228 L
s
.5 .01905 m
.5 .0228 L
s
.54762 .01905 m
.54762 .0228 L
s
.64286 .01905 m
.64286 .0228 L
s
.69048 .01905 m
.69048 .0228 L
s
.7381 .01905 m
.7381 .0228 L
s
.83333 .01905 m
.83333 .0228 L
s
.88095 .01905 m
.88095 .0228 L
s
.92857 .01905 m
.92857 .0228 L
s
.006 w
0 .01905 m
1 .01905 L
s
.25 Mabswid
.02381 .17143 m
.03006 .17143 L
s
gsave
.01131 .17143 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
1.000 setlinewidth
grestore
.02381 .32381 m
.03006 .32381 L
s
gsave
.01131 .32381 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
1.000 setlinewidth
grestore
.02381 .47619 m
.03006 .47619 L
s
gsave
.01131 .47619 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
1.000 setlinewidth
grestore
.02381 .62857 m
.03006 .62857 L
s
gsave
.01131 .62857 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
1.000 setlinewidth
grestore
.02381 .78095 m
.03006 .78095 L
s
gsave
.01131 .78095 -78.0625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.125 Mabswid
.02381 .05714 m
.02756 .05714 L
s
.02381 .09524 m
.02756 .09524 L
s
.02381 .13333 m
.02756 .13333 L
s
.02381 .20952 m
.02756 .20952 L
s
.02381 .24762 m
.02756 .24762 L
s
.02381 .28571 m
.02756 .28571 L
s
.02381 .36191 m
.02756 .36191 L
s
.02381 .4 m
.02756 .4 L
s
.02381 .4381 m
.02756 .4381 L
s
.02381 .51429 m
.02756 .51429 L
s
.02381 .55238 m
.02756 .55238 L
s
.02381 .59048 m
.02756 .59048 L
s
.02381 .66667 m
.02756 .66667 L
s
.02381 .70476 m
.02756 .70476 L
s
.02381 .74286 m
.02756 .74286 L
s
.006 w
.02381 0 m
.02381 .8 L
s
0 0 m
1 0 L
1 .8 L
0 .8 L
closepath
clip
newpath
1 0 0 r
.02381 .01905 m
.06244 .13767 L
.10458 .25559 L
.14415 .35548 L
.18221 .44162 L
.22272 .52262 L
.26171 .59016 L
.30316 .65076 L
.34309 .69822 L
.3815 .73377 L
.40095 .74799 L
.42237 .7607 L
.44268 .76991 L
.45178 .77314 L
.46172 .77603 L
.4671 .77732 L
.4721 .77834 L
.47727 .77922 L
.48196 .77986 L
.48658 .78035 L
.4887 .78052 L
.49093 .78068 L
.49332 .7808 L
.49438 .78085 L
.49552 .78089 L
.49675 .78092 L
.49789 .78094 L
.49859 .78095 L
.49925 .78095 L
.50049 .78095 L
.50163 .78094 L
.50286 .78093 L
.50401 .7809 L
.50508 .78087 L
.50754 .78076 L
.51014 .78061 L
.51268 .78041 L
.51504 .78019 L
.5204 .77956 L
.5293 .77807 L
.53882 .77589 L
.54906 .77287 L
.56016 .76879 L
.58032 .75928 L
.60019 .74722 L
.62123 .73157 L
.65912 .69588 L
.69946 .64728 L
.73829 .59017 L
.77956 .51835 L
Mistroke
.81932 .43834 L
.85757 .35136 L
.89827 .248 L
.93745 .13798 L
.97619 .01905 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{400, 320},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0001@2000`400?l00000o`00003oo`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00IP3oool4000000L0oooo0P00
00040?ooo`X00000:03oool4000000L0oooo0P00000;0?ooo`800000:@3oool4000000L0oooo0P00
00070?ooo`D00000:P3oool4000000L0oooo0P0000070?ooo`D00000<`3oool6000000l0oooo001U
0?ooo`8000000`3oool2000000D0oooo0P0000050?ooo`T000009`3oool2000000<0oooo0P000005
0?ooo`8000002`3oool2000002P0oooo0P0000030?ooo`8000001@3oool2000000H0oooo0P000003
0?ooo`800000:03oool2000000<0oooo0P0000050?ooo`8000001@3oool3000000@0oooo0P00000c
0?ooo`8000004@3oool006D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0;0?oo
o`030000003oool0oooo00@0oooo0P00000V0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0403oool2000002P0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0:0?oo
o`8000001@3oool2000002L0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`090?oo
o`<000001P3oool200000380oooo0P00000A0?ooo`00I03oool2000000D0oooo0P00000=0?ooo`03
0000003oool0oooo02X0oooo0P0000050?ooo`8000004@3oool2000002L0oooo0P0000050?ooo`80
00002`3oool2000000H0oooo00<000000?ooo`3oool0903oool2000000D0oooo0P00000:0?ooo`80
00001`3oool200000380oooo0P00000A0?ooo`00I03oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00P0oooo2`00000U0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
203oool2000000L0oooo0P00000U0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
203oool2000000L0oooo0P00000b0?ooo`8000004@3oool006<0oooo0P0000070?ooo`8000003P3o
ool00`000000oooo0?ooo`0W0?ooo`8000001`3oool2000000T0oooo00<000000?ooo`3oool0103o
ool2000002H0oooo0P0000070?ooo`8000002@3oool2000000L0oooo0P00000T0?ooo`8000001`3o
ool2000000T0oooo0P0000060?ooo`<00000<P3oool200000140oooo001S0?ooo`8000001`3oool2
000000l0oooo00<000000?ooo`3oool09P3oool2000000L0oooo0P00000:0?ooo`030000003oool0
oooo00<0oooo0P00000V0?ooo`8000001`3oool2000000T0oooo0P0000070?ooo`800000903oool2
000000L0oooo0P00000:0?ooo`800000103oool3000003<0oooo0P00000A0?ooo`00H`3oool20000
00L0oooo0P00000?0?ooo`030000003oool0oooo02H0oooo0P0000070?ooo`8000002`3oool00`00
0000oooo0?ooo`020?ooo`8000009P3oool2000000L0oooo0P0000090?ooo`8000001`3oool20000
02@0oooo0P0000070?ooo`8000002`3oool010000000oooo0?ooo`3oool3000003@0oooo0P00000A
0?ooo`00H`3oool2000000L0oooo0P00000@0?ooo`030000003oool0oooo02D0oooo0P0000070?oo
o`8000002`3oool00`000000oooo0?ooo`020?ooo`8000009P3oool2000000L0oooo0P0000090?oo
o`8000001P3oool2000002D0oooo0P0000070?ooo`800000303oool5000003D0oooo0P00000A0?oo
o`00H`3oool2000000L0oooo0P00000A0?ooo`030000003oool0oooo02@0oooo0P0000070?ooo`80
0000303oool010000000oooo0?ooo`3oool2000002H0oooo0P0000070?ooo`8000002@3oool40000
00<0oooo0`00000U0?ooo`8000001`3oool2000000`0oooo1000000f0?ooo`8000004@3oool006<0
oooo0P0000070?ooo`8000004@3oool00`000000oooo0?ooo`0T0?ooo`8000001`3oool2000000d0
oooo00<000000?ooo`3oool00P00000V0?ooo`8000001`3oool2000000X0oooo0P0000000`3oool0
000000000002000002L0oooo0P0000070?ooo`8000002`3oool300000080oooo00<000000?ooo`3o
ool0<`3oool200000140oooo001S0?ooo`8000001`3oool200000140oooo0P00000U0?ooo`800000
1`3oool2000000d0oooo00<000000?ooo`3oool00P00000V0?ooo`8000001`3oool2000000X0oooo
0P00000/0?ooo`8000001`3oool2000000X0oooo0`0000040?ooo`800000<`3oool200000140oooo
001T0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?oo
o`050?ooo`8000009P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00d0oooo00@0
00000?ooo`00000000009`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00X0oooo
0P00000/0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool3000000H0oooo
0P00000b0?ooo`8000004@3oool006@0oooo0P0000050?ooo`8000002P3oool00`000000oooo0?oo
o`050?ooo`8000009P3oool2000000D0oooo0P00000?0?ooo`040000003oool00000000002L0oooo
0P0000050?ooo`8000003@3oool2000002/0oooo0P0000050?ooo`8000002P3oool2000000L0oooo
0P00000b0?ooo`8000004@3oool006D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`0:0?ooo`030000003oool0oooo0080oooo1000000W0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool03`3oool3000002P0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`0=0?ooo`800000:`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00T0oooo0P00
00070?ooo`800000<P3oool200000140oooo001U0?ooo`8000000`3oool2000000`0oooo2000000X
0?ooo`8000000`3oool200000180oooo0P00000X0?ooo`8000000`3oool200000100oooo0`00000Y
0?ooo`8000000`3oool2000000`0oooo0P0000050?ooo`800000<03oool500000140oooo001W0?oo
o`<00000403oool4000002`0oooo0`00000D0?ooo`800000:P3oool3000001@0oooo1000000X0?oo
o`<00000403oool6000003<0oooo0`00000A0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3o
oonA0?ooo`00o`3ooonA0?ooo`00;`3oool200000?l0ooooH03oool002l0oooo0P00003o0?ooof00
oooo000_0?ooo`800000o`3ooomP0?ooo`00;`3oool200000?l0ooooH03oool002l0oooo0P00003o
0?ooof00oooo000_0?ooo`800000o`3ooomP0?ooo`00;`3oool00`000000o`000?ooo`3o0?ooodd0
oooo00<0o`000?ooo`3oool03`3oool002L0oooo200000030?l00?l00000C00000030?l000L00000
2@3oool002L0oooo2@0000020?l00?l00000C00000020?l000P000002@3oool002l0oooo00<00000
0?l0003o0000@@3oool00`000000oooo0?ooo`0o0?ooo`030000003oool0oooo0400oooo00<00000
0?ooo`3oool0@03oool00`000000oooo0?ooo`0o0?ooo`80o`004@3oool002l0oooo00@000000?l0
003o0000o`00o`3ooom:0?ooo`<0o`004@3oool002l0oooo0P0000020?l00?l0ooooBP3oool20?l0
0180oooo000_0?ooo`8000000P3o003o0?ooodX0oooo0P3o000B0?ooo`00;`3oool2000000<0o`00
o`3ooom80?ooo`<0o`004P3oool002l0oooo0P0000000`3oool0o`000?l0003o0?ooodP0oooo0P3o
000C0?ooo`00;`3oool2000000030?ooo`3o0000o`000?l0ooooB03oool20?l001<0oooo000_0?oo
o`80000000@0oooo0?l0003o0000o`00o`3ooom60?ooo`<0o`004`3oool002l0oooo0P0000020?oo
o`80o`00o`3ooom60?ooo`80o`00503oool002l0oooo0P0000020?ooo`80o`00o`3ooom60?ooo`80
o`00503oool002l0oooo0P0000020?ooo`80o`00o`3ooom50?ooo`<0o`00503oool002l0oooo0`00
0000103oool0o`000?l0003o003o0?oood@0oooo0P3o000E0?ooo`00;`3oool2000000<0oooo0P3o
003o0?oood@0oooo0P3o000E0?ooo`00;`3oool2000000<0oooo0P3o003o0?oood<0oooo0`3o000E
0?ooo`00;`3oool2000000<0oooo0`3o003o0?oood80oooo0P3o000F0?ooo`00;`3oool2000000@0
oooo0P3o003o0?oood80oooo0P3o000F0?ooo`00;`3oool2000000@0oooo0P3o003o0?oood40oooo
0`3o000F0?ooo`00;`3oool2000000@0oooo0`3o003o0?oood00oooo0P3o000G0?ooo`00;`3oool2
000000D0oooo0P3o003o0?ooocl0oooo0`3o000G0?ooo`00;`3oool2000000D0oooo0P3o003o0?oo
ocl0oooo0P3o000H0?ooo`00;`3oool2000000D0oooo0`3o003o0?oooch0oooo0P3o000H0?ooo`00
;`3oool2000000H0oooo0P3o003o0?ooocd0oooo0`3o000H0?ooo`00;`3oool2000000H0oooo0P3o
003o0?ooocd0oooo0P3o000I0?ooo`00;`3oool2000000H0oooo0`3o003o0?oooc`0oooo0P3o000I
0?ooo`00;`3oool3000000H0oooo0P3o003o0?oooc/0oooo0`3o000I0?ooo`00;`3oool2000000L0
oooo0P3o003o0?oooc/0oooo0P3o000J0?ooo`00;`3oool2000000L0oooo0`3o003o0?ooocX0oooo
0P3o000J0?ooo`00;`3oool2000000P0oooo0P3o003o0?ooocT0oooo0`3o000J0?ooo`00;`3oool2
000000P0oooo0P3o003o0?ooocT0oooo0P3o000K0?ooo`00;`3oool2000000P0oooo0P3o003o0?oo
ocT0oooo0P3o000K0?ooo`00;`3oool2000000P0oooo0`3o003o0?ooocL0oooo0`3o000K0?ooo`00
;`3oool2000000T0oooo0P3o003o0?ooocL0oooo0P3o000L0?ooo`00;`3oool2000000T0oooo0P3o
003o0?ooocL0oooo0P3o000L0?ooo`00;`3oool2000000T0oooo0`3o003o0?ooocD0oooo0`3o000L
0?ooo`00;`3oool2000000X0oooo0P3o003o0?ooocD0oooo0P3o000M0?ooo`00;`3oool2000000X0
oooo0P3o003o0?ooocD0oooo0P3o000M0?ooo`00;`3oool2000000X0oooo0`3o003o0?oooc<0oooo
0`3o000M0?ooo`00;`3oool2000000/0oooo0P3o003o0?oooc<0oooo0P3o000N0?ooo`00;`3oool3
000000X0oooo0P3o003o0?oooc<0oooo0P3o000N0?ooo`00;`3oool2000000/0oooo0`3o003o0?oo
oc40oooo0`3o000N0?ooo`00;`3oool2000000`0oooo0P3o003o0?oooc40oooo0P3o000O0?ooo`00
;`3oool2000000`0oooo0P3o003o0?oooc40oooo0P3o000O0?ooo`00;`3oool2000000`0oooo0`3o
003o0?ooobl0oooo0`3o000O0?ooo`003@3oool4000000L0oooo0P0000040?ooo`X000001`3oool2
000000d0oooo0P3o003o0?ooobl0oooo0P3o000P0?ooo`00303oool2000000<0oooo0P0000050?oo
o`8000001@3oool9000000L0oooo0P00000=0?ooo`80o`00o`3oool_0?ooo`80o`00803oool000`0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0
oooo0P0000060?ooo`8000003@3oool30?l00?l0oooo;@3oool30?l00200oooo000;0?ooo`800000
1@3oool2000000d0oooo00<000000?ooo`3oool02`3oool2000000h0oooo0P3o003o0?ooobd0oooo
0P3o000Q0?ooo`002`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool02P3oool2000000h0oooo0`3o003o0?ooob/0oooo0`3o000Q0?ooo`002P3oool2
000000L0oooo0P00000>0?ooo`030000003oool0oooo00T0oooo0P00000?0?ooo`80o`00o`3oool[
0?ooo`80o`008P3oool000X0oooo0P0000070?ooo`8000003`3oool00`000000oooo0?ooo`080?oo
o`8000003`3oool20?l00?l0oooo:`3oool20?l00280oooo000:0?ooo`8000001`3oool2000000l0
oooo00<000000?ooo`3oool0203oool2000000l0oooo0`3o003o0?ooobT0oooo0`3o000R0?ooo`00
2P3oool2000000L0oooo0P00000@0?ooo`030000003oool0oooo00L0oooo1000000>0?ooo`80o`00
o`3ooolY0?ooo`80o`008`3oool000X0oooo0P0000070?ooo`8000004@3oool00`000000oooo0?oo
o`060?ooo`800000403oool20?l00?l0oooo:@3oool20?l002<0oooo000:0?ooo`8000001`3oool2
00000140oooo00<000000?ooo`3oool01P3oool200000100oooo0`3o003o0?ooobL0oooo0`3o000S
0?ooo`002P3oool2000000L0oooo0P00000A0?ooo`8000001`3oool200000140oooo0P3o003o0?oo
obL0oooo0P3o000T0?ooo`002`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool01@3oool2000000L0oooo0P00000A0?ooo`80o`00o`3ooolW0?ooo`80
o`00903oool000/0oooo0P0000050?ooo`8000002P3oool00`000000oooo0?ooo`050?ooo`800000
1`3oool200000140oooo0`3o003o0?ooobD0oooo0`3o000T0?ooo`00303oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool00P3oool4000000L0oooo0P00
000B0?ooo`80o`00o`3ooolU0?ooo`80o`009@3oool000`0oooo0P0000030?ooo`800000303oool8
000000P0oooo0P00000B0?ooo`80o`00o`3ooolT0?ooo`<0o`009@3oool000h0oooo0`00000@0?oo
o`@000002P3oool200000180oooo0`3o003o0?ooob<0oooo0P3o000V0?ooo`00;`3oool2000001<0
oooo0P3o003o0?ooob<0oooo0P3o000V0?ooo`00;`3oool2000001<0oooo0`3o003o0?ooob40oooo
0`3o000V0?ooo`00;`3oool2000001@0oooo0P3o003o0?ooob40oooo0P3o000W0?ooo`00;`3oool2
000001@0oooo0P3o003o0?ooob40oooo0P3o000W0?ooo`00;`3oool3000001<0oooo0`3o003o0?oo
oal0oooo0`3o000W0?ooo`00;`3oool2000001D0oooo0P3o003o0?oooal0oooo0P3o000X0?ooo`00
;`3oool2000001D0oooo0P3o003o0?oooal0oooo0P3o000X0?ooo`00;`3oool2000001D0oooo0`3o
003o0?oooad0oooo0`3o000X0?ooo`00;`3oool2000001H0oooo0P3o003o0?oooad0oooo0P3o000Y
0?ooo`00;`3oool2000001H0oooo0P3o003o0?oooad0oooo0P3o000Y0?ooo`00;`3oool2000001H0
oooo0`3o003o0?oooa/0oooo0`3o000Y0?ooo`00;`3oool2000001L0oooo0P3o003o0?oooa/0oooo
0P3o000Z0?ooo`00;`3oool2000001L0oooo0P3o003o0?oooaX0oooo0`3o000Z0?ooo`00;`3oool2
000001L0oooo0`3o003o0?oooaT0oooo0P3o000[0?ooo`00;`3oool2000001P0oooo0P3o003o0?oo
oaT0oooo0P3o000[0?ooo`00;`3oool2000001P0oooo0`3o003o0?oooaL0oooo0`3o000[0?ooo`00
;`3oool2000001T0oooo0P3o003o0?oooaL0oooo0P3o000/0?ooo`00;`3oool2000001T0oooo0P3o
003o0?oooaL0oooo0P3o000/0?ooo`00;`3oool3000001P0oooo0`3o003o0?oooaD0oooo0`3o000/
0?ooo`00;`3oool2000001X0oooo0P3o003o0?oooaD0oooo0P3o000]0?ooo`00;`3oool2000001X0
oooo0P3o003o0?oooaD0oooo0P3o000]0?ooo`00;`3oool2000001X0oooo0`3o003o0?oooa<0oooo
0`3o000]0?ooo`00;`3oool2000001/0oooo0P3o003o0?oooa<0oooo0P3o000^0?ooo`00;`3oool2
000001/0oooo0P3o003o0?oooa80oooo0`3o000^0?ooo`00;`3oool2000001/0oooo0`3o003o0?oo
oa40oooo0P3o000_0?ooo`00;`3oool2000001`0oooo0P3o003o0?oooa40oooo0P3o000_0?ooo`00
;`3oool2000001`0oooo0`3o003o0?ooo`l0oooo0`3o000_0?ooo`00;`3oool2000001d0oooo0P3o
003o0?ooo`l0oooo0P3o000`0?ooo`00;`3oool2000001d0oooo0P3o003o0?ooo`h0oooo0`3o000`
0?ooo`00;`3oool2000001d0oooo0`3o003o0?ooo`d0oooo0P3o000a0?ooo`00;`3oool2000001h0
oooo0P3o003o0?ooo`d0oooo0P3o000a0?ooo`00;`3oool3000001d0oooo0`3o003o0?ooo`/0oooo
0`3o000a0?ooo`00;`3oool2000001l0oooo0P3o003o0?ooo`/0oooo0P3o000b0?ooo`00;`3oool2
000001l0oooo0P3o003o0?ooo`X0oooo0`3o000b0?ooo`00;`3oool2000001l0oooo0`3o003o0?oo
o`T0oooo0P3o000c0?ooo`00;`3oool200000200oooo0P3o003o0?ooo`T0oooo0P3o000c0?ooo`00
;`3oool200000200oooo0`3o003o0?ooo`L0oooo0`3o000c0?ooo`003@3oool4000000L0oooo0P00
000;0?ooo`800000203oool200000240oooo0P3o003o0?ooo`L0oooo0P3o000d0?ooo`00303oool2
000000<0oooo0P0000050?ooo`8000002`3oool2000000P0oooo0P00000Q0?ooo`80o`00o`3oool7
0?ooo`80o`00=03oool000`0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0@0?oo
o`800000203oool200000240oooo0`3o003o0?ooo`D0oooo0`3o000d0?ooo`002`3oool2000000D0
oooo0P00000A0?ooo`800000203oool200000280oooo0P3o003o0?ooo`D0oooo0P3o000e0?ooo`00
2`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo2`0000060?ooo`800000
8P3oool30?l00?l0oooo0`3oool30?l003D0oooo000:0?ooo`8000001`3oool2000000T0oooo00<0
00000?ooo`3oool0103oool2000000P0oooo0P00000S0?ooo`80o`00o`3oool30?ooo`80o`00=P3o
ool000X0oooo0P0000070?ooo`8000002P3oool00`000000oooo0?ooo`030?ooo`800000203oool2
000002<0oooo0P3o003o0?ooo`<0oooo0P3o000f0?ooo`002P3oool2000000L0oooo0P00000;0?oo
o`030000003oool0oooo0080oooo0P0000080?ooo`@000008@3oool30?l00?l0oooo0@3oool30?l0
03H0oooo000:0?ooo`8000001`3oool2000000/0oooo00<000000?ooo`3oool00P3oool2000000P0
oooo0P00000T0?ooo`80o`00o`3oool10?ooo`80o`00=`3oool000X0oooo0P0000070?ooo`800000
303oool010000000oooo0?ooo`3oool2000000P0oooo0P00000T0?ooo`<0o`00oP3oool30?l003L0
oooo000:0?ooo`8000001`3oool2000000d0oooo00<000000?ooo`3oool00P0000080?ooo`800000
9@3oool20?l00?h0oooo0P3o000h0?ooo`002P3oool2000000L0oooo0P00000=0?ooo`030000003o
ool0oooo00800000203oool2000002D0oooo0P3o003n0?ooo`80o`00>03oool000/0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`0=0?ooo`040000003oool00000000000P0oooo0P00
000U0?ooo`<0o`00o03oool30?l003P0oooo000;0?ooo`8000001@3oool2000000l0oooo00@00000
0?ooo`0000000000203oool2000002H0oooo0P3o003l0?ooo`80o`00>@3oool000`0oooo00<00000
0?ooo`3oool00`3oool00`000000oooo0?ooo`0?0?ooo`<00000203oool2000002H0oooo0`3o003j
0?ooo`<0o`00>@3oool000`0oooo0P0000030?ooo`8000004P3oool2000000P0oooo0P00000W0?oo
o`80o`00nP3oool20?l003X0oooo000>0?ooo`<00000503oool2000000P0oooo0P00000W0?ooo`80
o`00nP3oool20?l003X0oooo000_0?ooo`8000009`3oool30?l00?P0oooo0`3o000j0?ooo`00;`3o
ool2000002P0oooo0P3o003h0?ooo`80o`00>`3oool002l0oooo0P00000X0?ooo`<0o`00mP3oool3
0?l003/0oooo000_0?ooo`800000:@3oool20?l00?H0oooo0P3o000l0?ooo`00;`3oool3000002P0
oooo0`3o003e0?ooo`80o`00?03oool002l0oooo0P00000Z0?ooo`80o`00m03oool30?l003`0oooo
000_0?ooo`800000:P3oool20?l00?@0oooo0P3o000m0?ooo`00;`3oool2000002X0oooo0`3o003b
0?ooo`<0o`00?@3oool002l0oooo0P00000[0?ooo`80o`00lP3oool20?l003h0oooo000_0?ooo`80
0000:`3oool30?l00?40oooo0P3o000n0?ooo`00;`3oool2000002`0oooo0P3o003`0?ooo`<0o`00
?P3oool002l0oooo0P00000/0?ooo`<0o`00k`3oool20?l003l0oooo000_0?ooo`800000;@3oool2
0?l00>h0oooo0`3o000o0?ooo`00;`3oool2000002d0oooo0P3o003^0?ooo`80o`00@03oool002l0
oooo0P00000]0?ooo`<0o`00k03oool30?l00400oooo000_0?ooo`800000;P3oool20?l00>`0oooo
0P3o00110?ooo`00;`3oool2000002h0oooo0`3o003[0?ooo`80o`00@@3oool002l0oooo0`00000^
0?ooo`80o`00jP3oool30?l00440oooo000_0?ooo`800000;`3oool30?l00>T0oooo0P3o00120?oo
o`00;`3oool200000300oooo0P3o003X0?ooo`<0o`00@P3oool002l0oooo0P00000`0?ooo`<0o`00
i`3oool20?l004<0oooo000_0?ooo`800000<@3oool20?l00>H0oooo0`3o00130?ooo`00;`3oool2
00000340oooo0P3o003V0?ooo`80o`00A03oool002l0oooo0P00000a0?ooo`<0o`00i@3oool20?l0
04@0oooo000_0?ooo`800000<P3oool20?l00>@0oooo0`3o00140?ooo`00;`3oool200000380oooo
0`3o003S0?ooo`80o`00A@3oool002l0oooo0P00000c0?ooo`80o`00hP3oool30?l004D0oooo000_
0?ooo`800000<`3oool30?l00>40oooo0P3o00160?ooo`00;`3oool2000003@0oooo0P3o003Q0?oo
o`80o`00AP3oool002l0oooo0P00000d0?ooo`80o`00h03oool20?l004L0oooo000_0?ooo`<00000
=03oool20?l00=l0oooo0P3o00170?ooo`00;`3oool2000003D0oooo0P3o003O0?ooo`030?l0003o
ool0oooo04H0oooo000_0?ooo`800000=P3oool00`3o0000oooo0?ooo`3L0?ooo`80o`00B03oool0
02l0oooo0P00000f0?ooo`80o`00g@3oool00`3o0000oooo0?ooo`170?ooo`00;`3oool2000003L0
oooo00<0o`000?ooo`3oool0fP3oool20?l004T0oooo000_0?ooo`800000=`3oool20?l00=/0oooo
00<0o`000?ooo`3oool0B03oool000d0oooo100000070?ooo`8000001`3oool5000000T0oooo0P00
000h0?ooo`030?l0003oool0oooo0=P0oooo0P3o001:0?ooo`00303oool2000000<0oooo0P000005
0?ooo`8000001P3oool2000000<0oooo0P0000080?ooo`800000>03oool20?l00=T0oooo00<0o`00
0?ooo`3oool0B@3oool000`0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0:0?oo
o`8000001@3oool2000000L0oooo0P00000i0?ooo`030?l0003oool0oooo0=H0oooo0P3o001;0?oo
o`002`3oool2000000D0oooo0P00000;0?ooo`8000001P3oool00`000000oooo0?ooo`050?ooo`80
0000>@3oool20?l00=L0oooo00<0o`000?ooo`3oool0BP3oool000/0oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`080?ooo`8000001`3oool2000000H0oooo0P00000j0?ooo`80o`00
e@3oool20?l004`0oooo000:0?ooo`8000001`3oool2000000T0oooo0P0000070?ooo`8000001P3o
ool2000003/0oooo00<0o`000?ooo`3oool0d`3oool00`3o0000oooo0?ooo`1;0?ooo`002P3oool2
000000L0oooo0P0000090?ooo`8000001`3oool2000000H0oooo0P00000k0?ooo`80o`00d`3oool2
0?l004d0oooo000:0?ooo`8000001`3oool2000000T0oooo0P0000070?ooo`8000001P3oool20000
03`0oooo00<0o`000?ooo`3oool0d@3oool00`3o0000oooo0?ooo`1<0?ooo`002P3oool2000000L0
oooo0P0000090?ooo`8000001P3oool2000000L0oooo1000000j0?ooo`80o`00d@3oool20?l004h0
oooo000:0?ooo`8000001`3oool2000000T0oooo100000030?ooo`<000001`3oool2000003d0oooo
00<0o`000?ooo`3oool0c`3oool00`3o0000oooo0?ooo`1=0?ooo`002P3oool2000000L0oooo0P00
000:0?ooo`80000000<0oooo0000000000000P0000090?ooo`800000?@3oool20?l00<l0oooo0P3o
001?0?ooo`002P3oool2000000L0oooo0P00000:0?ooo`8000003P3oool2000003h0oooo00<0o`00
0?ooo`3oool0c@3oool00`3o0000oooo0?ooo`1>0?ooo`002`3oool00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00X0oooo0P00000=0?ooo`800000?P3oool20?l00<d0oooo0P3o001@0?oo
o`002`3oool2000000D0oooo0P00000=0?ooo`800000303oool2000003l0oooo00<0o`000?ooo`3o
ool0b`3oool00`3o0000oooo0?ooo`1?0?ooo`00303oool00`000000oooo0?ooo`030?ooo`030000
003oool0oooo00d0oooo0P00000;0?ooo`800000?`3oool20?l00</0oooo0P3o001A0?ooo`00303o
ool2000000<0oooo0P00000@0?ooo`<000002@3oool200000400oooo00<0o`000?ooo`3oool0b@3o
ool00`3o0000oooo0?ooo`1@0?ooo`003P3oool3000001@0oooo100000060?ooo`800000@03oool2
0?l00<T0oooo0P3o001B0?ooo`00;`3oool200000440oooo0P3o00380?ooo`030?l0003oool0oooo
0540oooo000_0?ooo`800000@P3oool00`3o0000oooo0?ooo`350?ooo`80o`00D`3oool002l0oooo
0P0000120?ooo`80o`00aP3oool00`3o0000oooo0?ooo`1B0?ooo`00;`3oool2000004<0oooo00<0
o`000?ooo`3oool0``3oool20?l005@0oooo000_0?ooo`<00000@P3oool20?l00<@0oooo00<0o`00
0?ooo`3oool0D`3oool002l0oooo0P0000140?ooo`030?l0003oool0oooo0<40oooo0P3o001E0?oo
o`00;`3oool2000004@0oooo0P3o00320?ooo`030?l0003oool0oooo05@0oooo000_0?ooo`800000
A@3oool00`3o0000oooo0?ooo`2o0?ooo`80o`00EP3oool002l0oooo0P0000150?ooo`80o`00_`3o
ool20?l005L0oooo000_0?ooo`800000AP3oool00`3o0000oooo0?ooo`2m0?ooo`030?l0003oool0
oooo05H0oooo000_0?ooo`800000AP3oool20?l00;d0oooo0P3o001H0?ooo`00;`3oool2000004L0
oooo00<0o`000?ooo`3oool0^`3oool00`3o0000oooo0?ooo`1G0?ooo`00;`3oool2000004L0oooo
0P3o002k0?ooo`80o`00F@3oool002l0oooo0P0000180?ooo`80o`00^@3oool20?l005X0oooo000_
0?ooo`800000B@3oool00`3o0000oooo0?ooo`2g0?ooo`030?l0003oool0oooo05T0oooo000_0?oo
o`800000B@3oool20?l00;L0oooo0P3o001K0?ooo`00;`3oool2000004X0oooo00<0o`000?ooo`3o
ool0]@3oool00`3o0000oooo0?ooo`1J0?ooo`00;`3oool2000004X0oooo0P3o002e0?ooo`80o`00
G03oool002l0oooo0`00001:0?ooo`030?l0003oool0oooo0;80oooo0P3o001M0?ooo`00;`3oool2
000004/0oooo0P3o002c0?ooo`030?l0003oool0oooo05`0oooo000_0?ooo`800000C03oool00`3o
0000oooo0?ooo`2`0?ooo`80o`00GP3oool002l0oooo0P00001<0?ooo`80o`00/@3oool00`3o0000
oooo0?ooo`1M0?ooo`00;`3oool2000004d0oooo00<0o`000?ooo`3oool0[P3oool20?l005l0oooo
000_0?ooo`800000C@3oool20?l00:h0oooo0P3o001P0?ooo`00;`3oool2000004h0oooo00<0o`00
0?ooo`3oool0[03oool00`3o0000oooo0?ooo`1O0?ooo`00;`3oool2000004h0oooo0P3o002/0?oo
o`80o`00H@3oool002l0oooo0P00001?0?ooo`80o`00Z`3oool00`3o0000oooo0?ooo`1P0?ooo`00
;`3oool200000500oooo00<0o`000?ooo`3oool0Z03oool20?l00680oooo000_0?ooo`800000D03o
ool20?l00:P0oooo0P3o001S0?ooo`00;`3oool200000540oooo00<0o`000?ooo`3oool0YP3oool0
0`3o0000oooo0?ooo`1R0?ooo`00;`3oool200000540oooo0P3o002V0?ooo`80o`00I03oool002l0
oooo0`00001A0?ooo`030?l0003oool0oooo0:@0oooo00<0o`000?ooo`3oool0H`3oool002l0oooo
0P00001B0?ooo`80o`00Y03oool20?l006D0oooo000_0?ooo`800000D`3oool20?l00:80oooo0P3o
001V0?ooo`00;`3oool2000005@0oooo00<0o`000?ooo`3oool0X03oool00`3o0000oooo0?ooo`1U
0?ooo`00;`3oool2000005@0oooo0P3o002P0?ooo`80o`00I`3oool002l0oooo0P00001E0?ooo`80
o`00WP3oool20?l006P0oooo000=0?ooo`@000001`3oool2000000L0oooo1@0000090?ooo`800000
EP3oool20?l009d0oooo00<0o`000?ooo`3oool0I`3oool000`0oooo0P0000030?ooo`8000001@3o
ool2000000D0oooo0`0000040?ooo`8000001`3oool2000005L0oooo00<0o`000?ooo`3oool0VP3o
ool20?l006T0oooo000<0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool02@3oool3
000000H0oooo0P0000060?ooo`800000E`3oool20?l009X0oooo0P3o001Z0?ooo`002`3oool20000
00D0oooo0P00000:0?ooo`8000001`3oool2000000H0oooo0P00001H0?ooo`80o`00V@3oool00`3o
0000oooo0?ooo`1Y0?ooo`002`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0
oooo0P0000070?ooo`8000001P3oool2000005T0oooo00<0o`000?ooo`3oool0UP3oool20?l006/0
oooo000:0?ooo`8000001`3oool2000000T0oooo0P0000060?ooo`<000001P3oool2000005T0oooo
0P3o002G0?ooo`030?l0003oool0oooo06X0oooo000:0?ooo`8000001`3oool2000000X0oooo0P00
00040?ooo`<000001`3oool2000005X0oooo0P3o002E0?ooo`80o`00K03oool000X0oooo0P000007
0?ooo`8000002`3oool010000000oooo0?ooo`3oool3000000P0oooo1000001I0?ooo`80o`00T`3o
ool20?l006d0oooo000:0?ooo`8000001`3oool2000000`0oooo1@0000090?ooo`800000G03oool0
0`3o0000oooo0?ooo`2A0?ooo`030?l0003oool0oooo06`0oooo000:0?ooo`8000001`3oool20000
00`0oooo1000000:0?ooo`800000G03oool20?l00940oooo0P3o001^0?ooo`002P3oool2000000L0
oooo0P00000;0?ooo`<000000P3oool00`000000oooo0?ooo`070?ooo`800000G@3oool20?l008l0
oooo0P3o001_0?ooo`002P3oool2000000L0oooo0P00000:0?ooo`<00000103oool2000000L0oooo
0P00001N0?ooo`030?l0003oool0oooo08d0oooo00<0o`000?ooo`3oool0KP3oool000/0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`<000001P3oool2000000H0oooo0P00
001N0?ooo`80o`00S@3oool20?l00700oooo000;0?ooo`8000001@3oool2000000X0oooo0P000007
0?ooo`8000001P3oool2000005l0oooo0P3o002;0?ooo`80o`00L@3oool000`0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`090?ooo`8000001`3oool2000000H0oooo0P00001P0?oo
o`80o`00R@3oool20?l00780oooo000<0?ooo`8000000`3oool2000000`0oooo0P0000050?ooo`80
00001`3oool200000640oooo0P3o00270?ooo`<0o`00LP3oool000h0oooo0`00000@0?ooo`H00000
203oool200000640oooo0`3o00260?ooo`80o`00L`3oool002l0oooo0P00001R0?ooo`80o`00Q@3o
ool20?l007@0oooo000_0?ooo`800000H`3oool20?l008<0oooo0`3o001d0?ooo`00;`3oool20000
06@0oooo0P3o00210?ooo`<0o`00M@3oool002l0oooo0P00001T0?ooo`<0o`00O`3oool30?l007H0
oooo000_0?ooo`<00000I03oool30?l007d0oooo0`3o001g0?ooo`00;`3oool2000006H0oooo0`3o
001l0?ooo`80o`00N03oool002l0oooo0P00001W0?ooo`80o`00N`3oool20?l007T0oooo000_0?oo
o`800000J03oool20?l007T0oooo0`3o001i0?ooo`00;`3oool2000006P0oooo0`3o001g0?ooo`<0
o`00NP3oool002l0oooo0P00001Y0?ooo`<0o`00M@3oool30?l007/0oooo000_0?ooo`800000JP3o
ool30?l007<0oooo0`3o001l0?ooo`00;`3oool2000006/0oooo0`3o001b0?ooo`80o`00O@3oool0
02l0oooo0P00001/0?ooo`80o`00L@3oool20?l007h0oooo000_0?ooo`800000K@3oool20?l006l0
oooo0`3o001n0?ooo`00;`3oool2000006d0oooo0`3o001]0?ooo`<0o`00O`3oool002l0oooo0P00
001^0?ooo`<0o`00J`3oool30?l00800oooo000_0?ooo`800000K`3oool30?l006P0oooo103o0021
0?ooo`00;`3oool3000006l0oooo0`3o001V0?ooo`@0o`00PP3oool002l0oooo0P00001a0?ooo`<0
o`00I03oool30?l008@0oooo000_0?ooo`800000LP3oool30?l00680oooo0`3o00250?ooo`00;`3o
ool2000007<0oooo0`3o001P0?ooo`<0o`00QP3oool002l0oooo0P00001d0?ooo`@0o`00G@3oool3
0?l008L0oooo000_0?ooo`800000M@3oool40?l005X0oooo103o00280?ooo`00;`3oool2000007L0
oooo0`3o001H0?ooo`@0o`00R@3oool002l0oooo0P00001h0?ooo`<0o`00EP3oool30?l008/0oooo
000_0?ooo`800000N@3oool30?l005@0oooo0`3o002<0?ooo`00;`3oool2000007X0oooo0`3o001B
0?ooo`<0o`00S@3oool002l0oooo0P00001k0?ooo`<0o`00D03oool30?l008h0oooo000_0?ooo`80
0000O03oool40?l004`0oooo103o002?0?ooo`00;`3oool2000007d0oooo103o001:0?ooo`@0o`00
T03oool002l0oooo0`00001n0?ooo`@0o`00A`3oool30?l00980oooo000_0?ooo`800000P03oool4
0?l004D0oooo0`3o002C0?ooo`00;`3oool200000880oooo103o00110?ooo`@0o`00U03oool002l0
oooo0P0000230?ooo`@0o`00?P3oool50?l009D0oooo000_0?ooo`800000Q@3oool40?l003/0oooo
103o002G0?ooo`00;`3oool2000008H0oooo103o000h0?ooo`@0o`00V@3oool00240oooo1P000008
0?ooo`800000R03oool40?l003@0oooo1@3o002J0?ooo`008`3oool2000000X0oooo0P0000290?oo
o`D0o`00;`3oool60?l009`0oooo000S0?ooo`8000002P3oool2000008/0oooo1P3o000Z0?ooo`H0
o`00WP3oool002<0oooo0P00000:0?ooo`800000S@3oool60?l002H0oooo1@3o002Q0?ooo`008`3o
ool2000000X0oooo0P00002@0?ooo`H0o`008@3oool50?l00:<0oooo000S0?ooo`8000002P3oool2
00000980oooo1`3o000J0?ooo`L0o`00Y@3oool002<0oooo0P00000:0?ooo`800000U@3oool80?l0
01<0oooo1`3o002X0?ooo`008`3oool2000000X0oooo0P00002H0?ooo``0o`001@3oool;0?l00:/0
oooo000S0?ooo`8000002P3oool4000009X0oooo5@3o002^0?ooo`008`3oool2000000X0oooo0P00
002S0?ooo`L0o`00]@3oool002<0oooo0P00000:0?ooo`800000o`3ooomP0?ooo`008`3oool20000
00X0oooo0P00003o0?ooof00oooo000S0?ooo`8000002P3oool200000?l0ooooH03oool002<0oooo
0P00000:0?ooo`800000o`3ooomP0?ooo`008`3oool2000000X0oooo0P00003o0?ooof00oooo000P
0?ooo`D000002P3oool200000?l0ooooH03oool00280oooo0`00003o0?ooof`0oooo003o0?oooi40
oooo003o0?oooi40oooo003o0?oooi40oooo003o0?oooi40oooo003o0?oooi40oooo003o0?oooi40
oooo003o0?oooi40oooo0000\
\>"],
  ImageRangeCache->{{{0, 399}, {319, 0}} -> {-0.145125, -0.135325, \
0.00299633, 0.0037454}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"vergleichsfunktion", " ", "=", 
      RowBox[{"Plot", "[", 
        RowBox[{\(f1[x] + w[x]\), ",", \({x, 0, 1}\), ",", 
          RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"{", 
              RowBox[{
                FormBox["Thickness",
                  "TraditionalForm"], "[", "0.006", "]"}], "}"}]}], ",", 
          RowBox[{"PlotStyle", "\[Rule]", " ", 
            RowBox[{"{", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{
                      StyleBox["RGBColor",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      RowBox[{
                        StyleBox["1",
                          "MR"], 
                        StyleBox[",",
                          "MR"], " ", "0", 
                        StyleBox[",",
                          "MR"], " ", "0"}], 
                      StyleBox["]",
                        "MR"]}], 
                    StyleBox[",",
                      "MR"], 
                    RowBox[{
                      FormBox["Thickness",
                        "TraditionalForm"], "[", "0.006", "]"}]}], 
                  StyleBox["}",
                    "MR"]}], 
                StyleBox[",",
                  "MR"], 
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{
                      StyleBox["RGBColor",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      RowBox[{
                        StyleBox["0",
                          "MR"], 
                        StyleBox[",",
                          "MR"], " ", "0", 
                        StyleBox[",",
                          "MR"], 
                        StyleBox["0",
                          "MR"]}], 
                      StyleBox["]",
                        "MR"]}], 
                    StyleBox[",",
                      "MR"], 
                    RowBox[{
                      FormBox["Thickness",
                        "TraditionalForm"], "[", "0.006", "]"}]}], 
                  StyleBox["}",
                    "MR"]}], 
                StyleBox[",",
                  "MR"], 
                StyleBox[
                  RowBox[{"{", 
                    RowBox[{\(RGBColor[0, 0, 1]\), ",", 
                      RowBox[{
                        FormBox["Thickness",
                          "TraditionalForm"], "[", "0.006", "]"}]}], "}"}],
                  "MR"], 
                StyleBox[",",
                  "MR"]}], "}"}]}], ",", " ", \(ImageSize \[Rule] 400\), ",", 
          " ", \(AspectRatio \[Rule] 0.8\), 
          ",", \(TextStyle \[Rule] {FontFamily \[Rule] "\<Times\>", 
              FontSize \[Rule] fontSize}\)}], "]"}]}]], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .8 
%%ImageSize: 400 320 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 -0.301322 0.692656 [
[.21429 .37883 -18.3125 -31.75 ]
[.21429 .37883 18.3125 0 ]
[.40476 .37883 -18.3125 -31.75 ]
[.40476 .37883 18.3125 0 ]
[.59524 .37883 -18.3125 -31.75 ]
[.59524 .37883 18.3125 0 ]
[.78571 .37883 -18.3125 -31.75 ]
[.78571 .37883 18.3125 0 ]
[.97619 .37883 -8.53125 -31.75 ]
[.97619 .37883 8.53125 0 ]
[.01131 .11427 -36.625 -15.875 ]
[.01131 .11427 0 15.875 ]
[.01131 .2528 -36.625 -15.875 ]
[.01131 .2528 0 15.875 ]
[.01131 .52986 -36.625 -15.875 ]
[.01131 .52986 0 15.875 ]
[.01131 .6684 -36.625 -15.875 ]
[.01131 .6684 0 15.875 ]
[ -0.003 -0.003 0 0 ]
[ 1.003 .803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .39133 m
.21429 .39758 L
s
gsave
.21429 .37883 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
1.000 setlinewidth
grestore
.40476 .39133 m
.40476 .39758 L
s
gsave
.40476 .37883 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
1.000 setlinewidth
grestore
.59524 .39133 m
.59524 .39758 L
s
gsave
.59524 .37883 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
1.000 setlinewidth
grestore
.78571 .39133 m
.78571 .39758 L
s
gsave
.78571 .37883 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
1.000 setlinewidth
grestore
.97619 .39133 m
.97619 .39758 L
s
gsave
.97619 .37883 -69.5313 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.125 Mabswid
.07143 .39133 m
.07143 .39508 L
s
.11905 .39133 m
.11905 .39508 L
s
.16667 .39133 m
.16667 .39508 L
s
.2619 .39133 m
.2619 .39508 L
s
.30952 .39133 m
.30952 .39508 L
s
.35714 .39133 m
.35714 .39508 L
s
.45238 .39133 m
.45238 .39508 L
s
.5 .39133 m
.5 .39508 L
s
.54762 .39133 m
.54762 .39508 L
s
.64286 .39133 m
.64286 .39508 L
s
.69048 .39133 m
.69048 .39508 L
s
.7381 .39133 m
.7381 .39508 L
s
.83333 .39133 m
.83333 .39508 L
s
.88095 .39133 m
.88095 .39508 L
s
.92857 .39133 m
.92857 .39508 L
s
.006 w
0 .39133 m
1 .39133 L
s
.25 Mabswid
.02381 .11427 m
.03006 .11427 L
s
gsave
.01131 .11427 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
1.000 setlinewidth
grestore
.02381 .2528 m
.03006 .2528 L
s
gsave
.01131 .2528 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
1.000 setlinewidth
grestore
.02381 .52986 m
.03006 .52986 L
s
gsave
.01131 .52986 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.2) show
1.000 setlinewidth
grestore
.02381 .6684 m
.03006 .6684 L
s
gsave
.01131 .6684 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.4) show
1.000 setlinewidth
grestore
.125 Mabswid
.02381 .1489 m
.02756 .1489 L
s
.02381 .18354 m
.02756 .18354 L
s
.02381 .21817 m
.02756 .21817 L
s
.02381 .28744 m
.02756 .28744 L
s
.02381 .32207 m
.02756 .32207 L
s
.02381 .3567 m
.02756 .3567 L
s
.02381 .42597 m
.02756 .42597 L
s
.02381 .4606 m
.02756 .4606 L
s
.02381 .49523 m
.02756 .49523 L
s
.02381 .5645 m
.02756 .5645 L
s
.02381 .59913 m
.02756 .59913 L
s
.02381 .63376 m
.02756 .63376 L
s
.02381 .07964 m
.02756 .07964 L
s
.02381 .04501 m
.02756 .04501 L
s
.02381 .01037 m
.02756 .01037 L
s
.02381 .70303 m
.02756 .70303 L
s
.02381 .73766 m
.02756 .73766 L
s
.02381 .77229 m
.02756 .77229 L
s
.006 w
.02381 0 m
.02381 .8 L
s
0 0 m
1 0 L
1 .8 L
0 .8 L
closepath
clip
newpath
1 0 0 r
.11369 0 m
.14415 .09206 L
.18221 .19804 L
.22272 .30114 L
.26171 .39091 L
.30316 .47614 L
.34309 .54833 L
.3815 .60858 L
.42237 .66279 L
.46172 .70534 L
.49955 .73733 L
.52059 .75134 L
.53984 .76179 L
.55972 .7702 L
.57861 .77596 L
.5882 .77805 L
.59346 .77895 L
.59842 .77965 L
.60305 .78017 L
.60549 .78039 L
.60806 .78058 L
.61023 .78071 L
.61138 .78077 L
.61261 .78083 L
.61375 .78087 L
.61478 .7809 L
.61582 .78092 L
.6168 .78094 L
.61794 .78095 L
.61917 .78095 L
.62033 .78095 L
.62139 .78094 L
.62257 .78091 L
.62386 .78088 L
.62521 .78084 L
.62646 .78078 L
.62906 .78065 L
.63142 .78049 L
.63671 .78 L
.64126 .77945 L
.64619 .7787 L
.65513 .77697 L
.6646 .77461 L
.67501 .77139 L
.69605 .76284 L
.7155 .75254 L
.73639 .73889 L
.77767 .7041 L
.81743 .66074 L
.85567 .60992 L
Mistroke
.89637 .54603 L
.93555 .47495 L
.97619 .39133 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{400, 320},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0001@2000`400?l00000o`00003oo`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00:03oool200000?l0ooooI`3o
ool002P0oooo0P00000P0?ooo`80o`00o`3ooom50?ooo`00:03oool200000200oooo0P3o003o0?oo
odD0oooo000X0?ooo`800000803oool30?l00?l0ooooA03oool002P0oooo0`00000P0?ooo`80o`00
o`3ooom40?ooo`00:03oool200000240oooo0P3o003o0?oood@0oooo000X0?ooo`8000008@3oool3
0?l00?l0oooo@`3oool002P0oooo0P00000R0?ooo`80o`00o`3ooom30?ooo`00:03oool200000280
oooo0P3o003o0?oood<0oooo000X0?ooo`8000008P3oool30?l00?l0oooo@P3oool002P0oooo0P00
000S0?ooo`80o`00o`3ooom20?ooo`00:03oool2000002<0oooo0P3o003o0?oood80oooo000X0?oo
o`8000008`3oool30?l00?l0oooo@@3oool002P0oooo0P00000T0?ooo`80o`00o`3ooom10?ooo`00
:03oool2000002@0oooo0P3o003o0?oood40oooo000X0?ooo`800000903oool30?l00?l0oooo@03o
ool002P0oooo0`00000T0?ooo`80o`00o`3ooom00?ooo`00:03oool2000002D0oooo0P3o003o0?oo
od00oooo000X0?ooo`8000009@3oool30?l00?l0oooo?`3oool002P0oooo0P00000V0?ooo`80o`00
o`3ooolo0?ooo`00:03oool2000002H0oooo0P3o003o0?ooocl0oooo000X0?ooo`8000009P3oool3
0?l00?l0oooo?P3oool002P0oooo0P00000W0?ooo`80o`00o`3oooln0?ooo`00:03oool2000002L0
oooo0P3o003o0?oooch0oooo000X0?ooo`8000009`3oool30?l00?l0oooo?@3oool002P0oooo0P00
000X0?ooo`80o`00o`3ooolm0?ooo`00:03oool2000002P0oooo0P3o003o0?ooocd0oooo000X0?oo
o`800000:03oool30?l00?l0oooo?03oool002P0oooo0P00000Y0?ooo`80o`00o`3oooll0?ooo`00
:03oool3000002P0oooo0P3o003o0?oooc`0oooo000X0?ooo`800000:@3oool30?l00?l0oooo>`3o
ool002P0oooo0P00000Z0?ooo`80o`00o`3ooolk0?ooo`00:03oool2000002X0oooo0P3o003o0?oo
oc/0oooo000X0?ooo`800000:P3oool30?l00?l0oooo>P3oool000H0oooo100000070?ooo`800000
1`3oool5000000T0oooo0P00000[0?ooo`80o`00o`3ooolj0?ooo`001@3oool2000000<0oooo0P00
00050?ooo`8000001P3oool2000000<0oooo0P0000080?ooo`800000:`3oool20?l00?l0oooo>P3o
ool000D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0:0?ooo`8000001@3oool2
000000L0oooo0P00000[0?ooo`<0o`00o`3oooli0?ooo`00103oool2000000D0oooo0P00000;0?oo
o`8000001P3oool00`000000oooo0?ooo`050?ooo`800000;03oool20?l00?l0oooo>@3oool000@0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`8000001`3oool2000000H0
oooo0P00000/0?ooo`80o`00o`3oooli0?ooo`000`3oool2000000L0oooo0P0000090?ooo`800000
1`3oool2000000H0oooo0P00000/0?ooo`<0o`00o`3ooolh0?ooo`000`3oool2000000L0oooo0P00
00090?ooo`8000001`3oool2000000H0oooo0P00000]0?ooo`80o`00o`3ooolh0?ooo`000`3oool2
000000L0oooo0P0000090?ooo`8000001`3oool2000000H0oooo0P00000]0?ooo`<0o`00o`3ooolg
0?ooo`000`3oool2000000L0oooo0P0000090?ooo`8000001P3oool2000000L0oooo1000000/0?oo
o`80o`00o`3ooolg0?ooo`000`3oool2000000L0oooo0P0000090?ooo`@000000`3oool3000000L0
oooo0P00000^0?ooo`80o`00o`3ooolg0?ooo`000`3oool2000000L0oooo0P00000:0?ooo`800000
00<0oooo0000000000000P0000090?ooo`800000;P3oool30?l00?l0oooo=P3oool000<0oooo0P00
00070?ooo`8000002P3oool2000000h0oooo0P00000_0?ooo`80o`00o`3ooolf0?ooo`00103oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00X0oooo0P00000=0?ooo`800000;`3oool2
0?l00?l0oooo=P3oool000@0oooo0P0000050?ooo`8000003@3oool2000000`0oooo0P00000_0?oo
o`<0o`00o`3ooole0?ooo`001@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00d0
oooo0P00000;0?ooo`800000<03oool20?l00?l0oooo=@3oool000D0oooo0P0000030?ooo`800000
403oool3000000T0oooo0P00000`0?ooo`80o`00o`3ooole0?ooo`001`3oool3000001@0oooo1000
00060?ooo`800000<03oool30?l00?l0oooo=03oool002P0oooo0P00000a0?ooo`80o`00o`3ooold
0?ooo`00:03oool200000340oooo0P3o003o0?oooc@0oooo000X0?ooo`800000<@3oool30?l00?l0
oooo<`3oool002P0oooo0`00000a0?ooo`80o`00o`3ooolc0?ooo`00:03oool200000380oooo0`3o
003o0?oooc80oooo000X0?ooo`800000<`3oool20?l00?l0oooo<P3oool002P0oooo0P00000c0?oo
o`80o`00o`3ooolb0?ooo`00:03oool2000003<0oooo0`3o003o0?oooc40oooo000X0?ooo`800000
=03oool20?l00?l0oooo<@3oool002P0oooo0P00000d0?ooo`80o`00o`3ooola0?ooo`00:03oool2
000003@0oooo0`3o003o0?oooc00oooo000X0?ooo`800000=@3oool20?l00?l0oooo<03oool002P0
oooo0P00000e0?ooo`80o`00o`3oool`0?ooo`00:03oool2000003D0oooo0`3o003o0?ooobl0oooo
000X0?ooo`800000=P3oool20?l00?l0oooo;`3oool002P0oooo0P00000f0?ooo`<0o`00o`3oool^
0?ooo`00:03oool3000003H0oooo0P3o003o0?ooobh0oooo000X0?ooo`800000=`3oool20?l00?l0
oooo;P3oool002P0oooo0P00000g0?ooo`<0o`00o`3oool]0?ooo`00:03oool2000003P0oooo0P3o
003o0?ooobd0oooo000X0?ooo`800000>03oool20?l00?l0oooo;@3oool002P0oooo0P00000h0?oo
o`<0o`00o`3oool/0?ooo`00:03oool2000003T0oooo0P3o003o0?ooob`0oooo000X0?ooo`800000
>@3oool20?l00?l0oooo;03oool002P0oooo0P00000i0?ooo`<0o`00o`3oool[0?ooo`00:03oool2
000003X0oooo0P3o003o0?ooob/0oooo000X0?ooo`800000>P3oool30?l00?l0oooo:P3oool002P0
oooo0P00000k0?ooo`80o`00o`3ooolZ0?ooo`00:03oool2000003/0oooo0P3o003o0?ooobX0oooo
000X0?ooo`<00000>P3oool30?l00?l0oooo:@3oool002P0oooo0P00000l0?ooo`80o`00o`3ooolY
0?ooo`00:03oool2000003`0oooo0P3o003o0?ooobT0oooo000X0?ooo`800000?03oool30?l00?l0
oooo:03oool002P0oooo0P00000m0?ooo`80o`00o`3ooolX0?ooo`001P3oool4000000L0oooo0P00
00070?ooo`D000002@3oool2000003d0oooo0P3o003o0?ooobP0oooo00050?ooo`8000000`3oool2
000000D0oooo0P0000050?ooo`<00000103oool2000000L0oooo0P00000m0?ooo`<0o`00o`3ooolW
0?ooo`001@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00T0oooo0`0000060?oo
o`8000001P3oool2000003h0oooo0P3o003o0?ooobL0oooo00040?ooo`8000001@3oool2000000X0
oooo0P0000070?ooo`8000001P3oool2000003h0oooo0`3o003o0?ooobH0oooo00040?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0203oool2000000L0oooo0P0000060?ooo`800000
?`3oool20?l00?l0oooo9P3oool000<0oooo0P0000070?ooo`8000002@3oool2000000H0oooo0`00
00060?ooo`800000?`3oool20?l00?l0oooo9P3oool000<0oooo0P0000070?ooo`8000002P3oool2
000000@0oooo0`0000070?ooo`800000?`3oool30?l00?l0oooo9@3oool000<0oooo0P0000070?oo
o`8000002`3oool010000000oooo0?ooo`3oool3000000P0oooo1000000n0?ooo`80o`00o`3ooolU
0?ooo`000`3oool2000000L0oooo0P00000<0?ooo`D000002@3oool200000400oooo0P3o003o0?oo
obD0oooo00030?ooo`8000001`3oool2000000`0oooo1000000:0?ooo`800000@03oool30?l00?l0
oooo903oool000<0oooo0P0000070?ooo`8000002`3oool300000080oooo00<000000?ooo`3oool0
1`3oool200000440oooo0P3o003o0?ooob@0oooo00030?ooo`8000001`3oool2000000X0oooo0`00
00040?ooo`8000001`3oool200000440oooo0`3o003o0?ooob<0oooo00040?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool0203oool3000000H0oooo0P0000060?ooo`800000@P3oool2
0?l00?l0oooo8`3oool000@0oooo0P0000050?ooo`8000002P3oool2000000L0oooo0P0000060?oo
o`800000@P3oool20?l00?l0oooo8`3oool000D0oooo00<000000?ooo`3oool00`3oool00`000000
oooo0?ooo`090?ooo`8000001`3oool2000000H0oooo0P0000120?ooo`<0o`00o`3ooolR0?ooo`00
1@3oool2000000<0oooo0P00000<0?ooo`8000001@3oool2000000L0oooo0P0000130?ooo`80o`00
o`3ooolR0?ooo`001`3oool300000100oooo1P0000080?ooo`800000@`3oool20?l00?l0oooo8P3o
ool002P0oooo0P0000130?ooo`<0o`00o`3ooolQ0?ooo`00:03oool2000004@0oooo0P3o003o0?oo
ob40oooo000X0?ooo`800000A03oool20?l00?l0oooo8@3oool002P0oooo0`0000140?ooo`80o`00
o`3ooolP0?ooo`00:03oool2000004D0oooo0P3o003o0?ooob00oooo000X0?ooo`800000A@3oool3
0?l00?l0oooo7`3oool002P0oooo0P0000160?ooo`80o`00o`3ooolO0?ooo`00:03oool2000004H0
oooo0P3o003o0?oooal0oooo000X0?ooo`800000A`3oool00`3o0000oooo0?ooo`3o0?oooad0oooo
000X0?ooo`800000A`3oool20?l00?l0oooo7P3oool002P0oooo0P0000180?ooo`030?l0003oool0
oooo0?l0oooo703oool002P0oooo0P0000180?ooo`80o`00o`3ooolM0?ooo`00:03oool2000004T0
oooo00<0o`000?ooo`3oool0o`3ooolK0?ooo`00:03oool2000003P0oooo100000070?ooo`800000
103oool00`3o0000000000000007000002/0oooo100000070?ooo`8000002`3oool2000002/0oooo
100000070?ooo`8000001`3oool5000002d0oooo100000070?ooo`8000001`3oool5000003H0oooo
1P0000080?ooo`00:03oool2000003L0oooo0P0000030?ooo`8000001@3oool2000000@0oooo0P3o
0008000002X0oooo0P0000030?ooo`8000001@3oool2000000/0oooo0P00000Z0?ooo`8000000`3o
ool2000000D0oooo0P0000060?ooo`8000000`3oool2000002/0oooo0P0000030?ooo`8000001@3o
ool2000000D0oooo0`0000040?ooo`800000=P3oool2000000X0oooo000X0?ooo`800000=`3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo00X0oooo00<0o`000000003oool01@3oool2
000002T0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0@0?ooo`800000:P3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo00X0oooo0P0000050?ooo`800000:P3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo00T0oooo0`0000060?ooo`800000=@3oool2
000000X0oooo000X0?ooo`<00000=@3oool2000000D0oooo0P00000;0?ooo`80o`0000<000000?oo
o`3oool0;@3oool2000000D0oooo0P00000A0?ooo`800000:@3oool2000000D0oooo0P00000;0?oo
o`8000001P3oool00`000000oooo0?ooo`0W0?ooo`8000001@3oool2000000X0oooo0P0000070?oo
o`800000=@3oool2000000X0oooo000X0?ooo`800000=P3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00X0oooo00<0o`000?ooo`000000;P3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo00P0oooo2`00000W0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0203oool2000000L0oooo0P00000X0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0203oool2000000L0oooo0P00000e0?ooo`8000002P3oool002P0oooo0P00000e0?ooo`800000
1`3oool2000000/0oooo0P3o00000`3oool000000?ooo`0[0?ooo`8000001`3oool2000000T0oooo
00<000000?ooo`3oool0103oool2000002P0oooo0P0000070?ooo`8000002@3oool2000000L0oooo
0P00000W0?ooo`8000001`3oool2000000T0oooo0P0000060?ooo`<00000=@3oool2000000X0oooo
000X0?ooo`800000=@3oool2000000L0oooo0P00000<0?ooo`040?l0003oool0oooo000002/0oooo
0P0000070?ooo`8000002P3oool00`000000oooo0?ooo`030?ooo`800000:03oool2000000L0oooo
0P0000090?ooo`8000001`3oool2000002L0oooo0P0000070?ooo`8000002P3oool2000000@0oooo
0`00000f0?ooo`8000002P3oool002P0oooo0P00000e0?ooo`8000001`3oool2000000`0oooo0P3o
00000`3oool000000?ooo`0Z0?ooo`8000001`3oool2000000/0oooo00<000000?ooo`3oool00P3o
ool2000002P0oooo0P0000070?ooo`8000002@3oool2000000L0oooo0P00000W0?ooo`8000001`3o
ool2000000/0oooo00@000000?ooo`3oool0oooo0`00000g0?ooo`8000002P3oool002P0oooo0P00
000e0?ooo`8000001`3oool2000000d0oooo00@0o`000?ooo`3oool00000:P3oool2000000L0oooo
0P00000;0?ooo`030000003oool0oooo0080oooo0P00000X0?ooo`8000001`3oool2000000T0oooo
0P0000060?ooo`800000:03oool2000000L0oooo0P00000<0?ooo`D00000>03oool2000000X0oooo
000X0?ooo`800000=@3oool2000000L0oooo0P00000=0?ooo`80o`000P3oool00`000000oooo0?oo
o`0W0?ooo`8000001`3oool2000000`0oooo00@000000?ooo`3oool0oooo0P00000X0?ooo`800000
1`3oool2000000T0oooo100000030?ooo`<00000:03oool2000000L0oooo0P00000<0?ooo`@00000
>@3oool2000000X0oooo000X0?ooo`800000=@3oool2000000L0oooo0P00000>0?ooo`040?l0003o
ool0oooo000002T0oooo0P0000070?ooo`8000003@3oool00`000000oooo0?ooo`02000002P0oooo
0P0000070?ooo`8000002P3oool2000000030?ooo`000000000000800000:P3oool2000000L0oooo
0P00000;0?ooo`<000000P3oool00`000000oooo0?ooo`0f0?ooo`8000002P3oool002P0oooo0P00
000e0?ooo`8000001`3oool2000000h0oooo00<0o`000?ooo`3oool00P00000X0?ooo`8000001`3o
ool2000000d0oooo00<000000?ooo`3oool00P00000X0?ooo`8000001`3oool2000000X0oooo0P00
000_0?ooo`8000001`3oool2000000X0oooo0`0000040?ooo`800000=P3oool2000000X0oooo000X
0?ooo`800000=P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool00P3oool20?l000030?ooo`000000000002T0oooo00<000000?ooo`3oool01@3oool0
0`000000oooo0?ooo`0=0?ooo`040000003oool00000000002T0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`0:0?ooo`800000;`3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo00P0oooo0`0000060?ooo`800000=@3oool2000000X0oooo000X0?ooo`800000=P3oool2
000000D0oooo0P00000:0?ooo`030000003oool0oooo00<0oooo00@0o`000?ooo`0000000000:@3o
ool2000000D0oooo0P00000?0?ooo`040000003oool00000000002T0oooo0P0000050?ooo`800000
3@3oool2000002h0oooo0P0000050?ooo`8000002P3oool2000000L0oooo0P00000e0?ooo`800000
2P3oool002P0oooo0P00000g0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool02P3o
ool00`000000oooo0?ooo`020?ooo`80o`000P00000Z0?ooo`030000003oool0oooo00<0oooo00<0
00000?ooo`3oool03`3oool3000002X0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`0=0?ooo`800000;P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00T0oooo0P00
00070?ooo`800000=@3oool2000000X0oooo000X0?ooo`<00000=P3oool2000000<0oooo0P00000<
0?ooo`H0000000<0o`000000003oool0:P3oool2000000<0oooo0P00000B0?ooo`800000:P3oool2
000000<0oooo0P00000@0?ooo`<00000;03oool2000000<0oooo0P00000<0?ooo`8000001@3oool2
000003<0oooo1@00000:0?ooo`00:03oool2000003T0oooo0`00000@0?ooo`@000000P3o000]0?oo
o`<00000503oool2000002`0oooo0`00000D0?ooo`@00000:`3oool300000100oooo1P00000f0?oo
o`<000002P3oool002P0oooo0P00001A0?ooo`030?l0003oool0oooo0?l0oooo4`3oool002P0oooo
0P00001A0?ooo`80o`00o`3ooolD0?ooo`00:03oool200000580oooo00<0o`000?ooo`3oool0o`3o
oolB0?ooo`00:03oool200000580oooo0P3o003o0?oooa<0oooo000X0?ooo`800000D`3oool00`3o
0000oooo0?ooo`3o0?oooa40oooo000X0?ooo`800000D`3oool00`3o0000oooo0?ooo`3o0?oooa40
oooo000X0?ooo`800000D`3oool20?l00?l0oooo4P3oool002P0oooo0P00001D0?ooo`030?l0003o
ool0oooo0?l0oooo403oool002P0oooo0P00001D0?ooo`80o`00o`3ooolA0?ooo`00:03oool20000
05D0oooo00<0o`000?ooo`3oool0o`3oool?0?ooo`00:03oool2000005D0oooo0P3o003o0?ooo`D0
oooo00<0o`000?ooo`3oool0203oool001l0ooooH@0000000`3o000000000000003o000000<00000
00<0o`000000000000001P0000020?ooo`007`3ooomQ00000080o`00o`00000300000080o`002000
00020?ooo`00:03oool2000004@0oooo00<000000?ooo`3oool0403oool00`3o0000oooo0?ooo`0`
0?ooo`030000003oool0oooo04<0oooo00<000000?ooo`3oool0@P3oool00`000000oooo0?ooo`12
0?ooo`030?l000000000oooo00T0oooo000X0?ooo`800000E`3oool20?l00?l0oooo0@3oool20?l0
00/0oooo000X0?ooo`800000F03oool00`3o0000oooo0?ooo`3n0?ooo`030?l0003oool0oooo00X0
oooo000X0?ooo`800000F03oool20?l00?h0oooo0P3o000<0?ooo`00:03oool2000005T0oooo00<0
o`000?ooo`3oool0o03oool00`3o0000oooo0?ooo`0;0?ooo`00:03oool2000005T0oooo0P3o003l
0?ooo`80o`003@3oool002P0oooo0P00001J0?ooo`030?l0003oool0oooo0?X0oooo00<0o`000?oo
o`3oool0303oool002P0oooo0P00001J0?ooo`80o`00nP3oool20?l000h0oooo000X0?ooo`800000
F`3oool00`3o0000oooo0?ooo`3h0?ooo`030?l0003oool0oooo00d0oooo000X0?ooo`800000F`3o
ool20?l00?P0oooo0P3o000?0?ooo`00:03oool3000005/0oooo00<0o`000?ooo`3oool0mP3oool0
0`3o0000oooo0?ooo`0>0?ooo`00:03oool2000005`0oooo0P3o003f0?ooo`80o`00403oool002P0
oooo0P00001M0?ooo`030?l0003oool0oooo0?@0oooo00<0o`000?ooo`3oool03`3oool002P0oooo
0P00001M0?ooo`030?l0003oool0oooo0?<0oooo0P3o000A0?ooo`00:03oool2000005d0oooo0P3o
003d0?ooo`030?l0003oool0oooo0100oooo000X0?ooo`800000GP3oool00`3o0000oooo0?ooo`3a
0?ooo`80o`004P3oool002P0oooo0P00001N0?ooo`80o`00lP3oool00`3o0000oooo0?ooo`0A0?oo
o`00:03oool2000005l0oooo00<0o`000?ooo`3oool0k`3oool20?l001<0oooo000X0?ooo`800000
G`3oool20?l00?00oooo00<0o`000?ooo`3oool04P3oool002P0oooo0P00001P0?ooo`030?l0003o
ool0oooo0>d0oooo0P3o000D0?ooo`00:03oool200000600oooo0P3o003^0?ooo`030?l0003oool0
oooo01<0oooo000X0?ooo`800000H@3oool00`3o0000oooo0?ooo`3[0?ooo`80o`005@3oool002P0
oooo0P00001Q0?ooo`80o`00k03oool00`3o0000oooo0?ooo`0D0?ooo`00:03oool300000640oooo
00<0o`000?ooo`3oool0j@3oool20?l001H0oooo000X0?ooo`800000HP3oool20?l00>X0oooo00<0
o`000?ooo`3oool05@3oool002P0oooo0P00001S0?ooo`030?l0003oool0oooo0>L0oooo0P3o000G
0?ooo`00:03oool2000006<0oooo0P3o003X0?ooo`030?l0003oool0oooo01H0oooo000X0?ooo`80
0000I03oool00`3o0000oooo0?ooo`3U0?ooo`80o`00603oool002P0oooo0P00001T0?ooo`80o`00
iP3oool00`3o0000oooo0?ooo`0G0?ooo`00:03oool2000006D0oooo00<0o`000?ooo`3oool0h`3o
ool20?l001T0oooo000X0?ooo`800000I@3oool20?l00>@0oooo00<0o`000?ooo`3oool0603oool0
02P0oooo0P00001V0?ooo`030?l0003oool0oooo0>40oooo0P3o000J0?ooo`00:03oool2000006H0
oooo0P3o003R0?ooo`030?l0003oool0oooo01T0oooo000X0?ooo`800000I`3oool00`3o0000oooo
0?ooo`3O0?ooo`80o`006`3oool002P0oooo0P00001W0?ooo`80o`00g`3oool20?l001`0oooo000X
0?ooo`800000J03oool00`3o0000oooo0?ooo`3M0?ooo`030?l0003oool0oooo01/0oooo000X0?oo
o`<00000I`3oool20?l00=d0oooo0P3o000M0?ooo`00:03oool2000006T0oooo0P3o003L0?ooo`03
0?l0003oool0oooo01`0oooo000X0?ooo`800000JP3oool00`3o0000oooo0?ooo`3I0?ooo`80o`00
7P3oool002P0oooo0P00001Z0?ooo`80o`00fP3oool00`3o0000oooo0?ooo`0M0?ooo`00:03oool2
000006/0oooo00<0o`000?ooo`3oool0e`3oool20?l001l0oooo00060?ooo`H000001@3oool20000
00@0oooo2P0000070?ooo`800000J`3oool20?l00=P0oooo00<0o`000?ooo`3oool07P3oool000P0
oooo0P0000070?ooo`8000001@3oool9000000L0oooo0P00001/0?ooo`030?l0003oool0oooo0=D0
oooo0P3o000P0?ooo`00203oool2000000l0oooo00<000000?ooo`3oool0103oool2000000H0oooo
0P00001/0?ooo`80o`00eP3oool00`3o0000oooo0?ooo`0O0?ooo`00203oool200000100oooo00<0
00000?ooo`3oool02`3oool2000006d0oooo00<0o`000?ooo`3oool0d`3oool20?l00240oooo0008
0?ooo`8000004@3oool00`000000oooo0?ooo`0:0?ooo`800000K@3oool20?l00=@0oooo00<0o`00
0?ooo`3oool0803oool000P0oooo0P00000B0?ooo`030000003oool0oooo00T0oooo0P00001^0?oo
o`030?l0003oool0oooo0=40oooo0P3o000R0?ooo`00203oool2000001<0oooo00<000000?ooo`3o
ool0203oool2000006h0oooo0P3o003A0?ooo`80o`008`3oool000P0oooo0P00000C0?ooo`030000
003oool0oooo00P0oooo1000001]0?ooo`030?l0003oool0oooo0<l0oooo00<0o`000?ooo`3oool0
8P3oool000P0oooo0P00000D0?ooo`030000003oool0oooo00L0oooo0P00001_0?ooo`80o`00c`3o
ool20?l002@0oooo00080?ooo`8000005@3oool00`000000oooo0?ooo`060?ooo`800000L03oool2
0?l00<h0oooo00<0o`000?ooo`3oool08`3oool000P0oooo0P00000E0?ooo`030000003oool0oooo
00H0oooo0P00001a0?ooo`030?l0003oool0oooo0</0oooo0P3o000U0?ooo`00203oool2000001D0
oooo0P0000070?ooo`800000L@3oool20?l00<`0oooo00<0o`000?ooo`3oool0903oool000P0oooo
0P00000=0?ooo`030000003oool0oooo00D0oooo0P0000070?ooo`800000LP3oool00`3o0000oooo
0?ooo`390?ooo`80o`009P3oool000P0oooo0P00000=0?ooo`030000003oool0oooo00D0oooo0P00
00070?ooo`800000LP3oool20?l00<X0oooo00<0o`000?ooo`3oool09@3oool000P0oooo0P00000>
0?ooo`030000003oool0oooo0080oooo100000070?ooo`800000L`3oool00`3o0000oooo0?ooo`37
0?ooo`80o`009`3oool000D0oooo1@00000>0?ooo`P00000203oool2000007<0oooo0P3o00370?oo
o`80o`00:03oool000L0oooo0`00000@0?ooo`@000002P3oool2000007@0oooo0P3o00360?ooo`03
0?l0003oool0oooo02L0oooo000X0?ooo`800000M@3oool00`3o0000oooo0?ooo`330?ooo`80o`00
:@3oool002P0oooo0P00001e0?ooo`80o`00a03oool00`3o0000oooo0?ooo`0X0?ooo`00:03oool2
000007H0oooo00<0o`000?ooo`3oool0`@3oool20?l002X0oooo000X0?ooo`<00000M@3oool20?l0
0<40oooo0P3o000[0?ooo`00:03oool2000007L0oooo0P3o00300?ooo`030?l0003oool0oooo02X0
oooo000X0?ooo`800000N03oool00`3o0000oooo0?ooo`2m0?ooo`80o`00;03oool002P0oooo0P00
001h0?ooo`80o`00_@3oool20?l002d0oooo000X0?ooo`800000N@3oool20?l00;`0oooo00<0o`00
0?ooo`3oool0;03oool002P0oooo0P00001j0?ooo`030?l0003oool0oooo0;T0oooo0P3o000^0?oo
o`00:03oool2000007X0oooo0P3o002j0?ooo`030?l0003oool0oooo02d0oooo000X0?ooo`800000
N`3oool20?l00;P0oooo0P3o000_0?ooo`00:03oool2000007`0oooo00<0o`000?ooo`3oool0]@3o
ool20?l00300oooo000X0?ooo`800000O03oool20?l00;H0oooo00<0o`000?ooo`3oool0;`3oool0
02P0oooo0P00001m0?ooo`030?l0003oool0oooo0;<0oooo0P3o000a0?ooo`00:03oool2000007d0
oooo0P3o002c0?ooo`80o`00<P3oool002P0oooo0P00001n0?ooo`80o`00/P3oool00`3o0000oooo
0?ooo`0a0?ooo`00:03oool3000007h0oooo00<0o`000?ooo`3oool0[`3oool20?l003<0oooo000X
0?ooo`800000O`3oool20?l00;00oooo00<0o`000?ooo`3oool0<P3oool002P0oooo0P0000200?oo
o`80o`00[P3oool20?l003@0oooo000X0?ooo`800000P@3oool00`3o0000oooo0?ooo`2[0?ooo`80
o`00=@3oool002P0oooo0P0000210?ooo`80o`00[03oool00`3o0000oooo0?ooo`0d0?ooo`00:03o
ool200000880oooo0P3o002Z0?ooo`80o`00=P3oool002P0oooo0P0000230?ooo`80o`00Z03oool2
0?l003L0oooo000X0?ooo`800000Q03oool00`3o0000oooo0?ooo`2U0?ooo`80o`00>03oool002P0
oooo0P0000240?ooo`80o`00Y@3oool20?l003T0oooo000X0?ooo`800000Q@3oool20?l00:@0oooo
00<0o`000?ooo`3oool0>03oool002P0oooo0P0000260?ooo`80o`00XP3oool20?l003X0oooo000X
0?ooo`800000Q`3oool00`3o0000oooo0?ooo`2O0?ooo`80o`00>`3oool002P0oooo0`0000260?oo
o`80o`00W`3oool20?l003`0oooo000X0?ooo`800000R03oool20?l009h0oooo00<0o`000?ooo`3o
ool0>`3oool002P0oooo0P0000290?ooo`80o`00W03oool20?l003d0oooo000X0?ooo`800000RP3o
ool00`3o0000oooo0?ooo`2I0?ooo`80o`00?P3oool002P0oooo0P00002:0?ooo`80o`00V@3oool2
0?l003l0oooo00060?ooo`H000001@3oool2000000/0oooo0P0000080?ooo`800000R`3oool20?l0
09L0oooo0P3o00100?ooo`00203oool2000000L0oooo0P00000;0?ooo`800000203oool2000008`0
oooo0P3o002F0?ooo`030?l0003oool0oooo03l0oooo00080?ooo`800000503oool2000000P0oooo
0P00002=0?ooo`030?l0003oool0oooo09<0oooo0P3o00110?ooo`00203oool2000001@0oooo0P00
00080?ooo`800000S@3oool20?l009<0oooo0P3o00120?ooo`00203oool2000000d0oooo2`000006
0?ooo`800000SP3oool20?l00940oooo0P3o00130?ooo`00203oool2000000d0oooo00<000000?oo
o`3oool0103oool2000000P0oooo0P00002?0?ooo`80o`00S`3oool20?l004@0oooo00080?ooo`80
00003P3oool00`000000oooo0?ooo`030?ooo`800000203oool200000900oooo0P3o002=0?ooo`<0
o`00A03oool000P0oooo0P00000?0?ooo`030000003oool0oooo0080oooo0P0000080?ooo`800000
T03oool30?l008/0oooo0`3o00150?ooo`00203oool2000000l0oooo00<000000?ooo`3oool00P3o
ool2000000P0oooo1000002?0?ooo`<0o`00R@3oool30?l004H0oooo00080?ooo`800000403oool0
10000000oooo0?ooo`3oool2000000P0oooo0P00002B0?ooo`<0o`00Q`3oool30?l004L0oooo0008
0?ooo`8000004@3oool00`000000oooo0?ooo`02000000P0oooo0P00002C0?ooo`<0o`00Q@3oool3
0?l004P0oooo00080?ooo`8000004@3oool00`000000oooo0?ooo`02000000P0oooo0P00002D0?oo
o`<0o`00P`3oool30?l004T0oooo00080?ooo`8000004P3oool010000000oooo0000000000080?oo
o`800000U@3oool30?l00840oooo0`3o001:0?ooo`00203oool200000180oooo00@000000?ooo`00
00000000203oool2000009H0oooo0P3o00210?ooo`80o`00B`3oool000P0oooo0P00000C0?ooo`<0
0000203oool2000009L0oooo0P3o001o0?ooo`80o`00C03oool000D0oooo1@00000D0?ooo`800000
203oool2000009L0oooo0`3o001m0?ooo`<0o`00C03oool000L0oooo0`00000D0?ooo`800000203o
ool2000009P0oooo0`3o001k0?ooo`<0o`00C@3oool002P0oooo0P00002I0?ooo`<0o`00N@3oool3
0?l004h0oooo000X0?ooo`800000VP3oool30?l007L0oooo0`3o001?0?ooo`00:03oool2000009/0
oooo0`3o001e0?ooo`<0o`00D03oool002P0oooo0P00002L0?ooo`<0o`00L`3oool30?l00540oooo
000X0?ooo`<00000W03oool30?l00740oooo0`3o001B0?ooo`00:03oool2000009h0oooo0`3o001_
0?ooo`<0o`00D`3oool002P0oooo0P00002O0?ooo`@0o`00K03oool30?l005@0oooo000X0?ooo`80
0000X03oool40?l006T0oooo103o001E0?ooo`00:03oool200000:80oooo0`3o001W0?ooo`@0o`00
EP3oool002P0oooo0P00002S0?ooo`<0o`00I@3oool30?l005P0oooo000X0?ooo`800000Y03oool4
0?l00680oooo0`3o001I0?ooo`00:03oool200000:D0oooo103o001P0?ooo`<0o`00FP3oool002P0
oooo0P00002W0?ooo`<0o`00GP3oool30?l005/0oooo000X0?ooo`800000Z03oool30?l005/0oooo
103o001L0?ooo`00:03oool200000:T0oooo103o001H0?ooo`@0o`00G@3oool002P0oooo0P00002Z
0?ooo`@0o`00EP3oool30?l005l0oooo000X0?ooo`<00000Z`3oool30?l005@0oooo0`3o001P0?oo
o`00:03oool200000:d0oooo103o001@0?ooo`@0o`00H@3oool002P0oooo0P00002^0?ooo`@0o`00
CP3oool40?l00680oooo000X0?ooo`800000/03oool40?l004X0oooo103o001T0?ooo`00:03oool2
00000;40oooo103o00180?ooo`@0o`00I@3oool002P0oooo0P00002c0?ooo`@0o`00A03oool40?l0
06L0oooo000X0?ooo`800000]03oool40?l00440oooo1@3o001X0?ooo`00:03oool200000;H0oooo
103o000m0?ooo`D0o`00JP3oool002P0oooo0P00002g0?ooo`D0o`00>P3oool40?l006`0oooo000X
0?ooo`800000^@3oool60?l003D0oooo103o001^0?ooo`00:03oool200000;/0oooo1P3o000a0?oo
o`D0o`00K`3oool002P0oooo0P00002n0?ooo`H0o`00:`3oool60?l00740oooo000X0?ooo`800000
`03oool70?l002H0oooo1P3o001c0?ooo`00:03oool300000<80oooo1`3o000O0?ooo`L0o`00MP3o
ool002P0oooo0P0000360?ooo`L0o`00603oool80?l007T0oooo000X0?ooo`800000b@3oool90?l0
00h0oooo2@3o001m0?ooo`00:03oool200000<d0oooo603o00210?ooo`00:03oool200000=40oooo
403o00250?ooo`00:03oool200000?l0ooooI`3oool002P0oooo0P00003o0?ooofL0oooo000X0?oo
o`800000o`3ooomW0?ooo`00:03oool200000?l0ooooI`3oool002P0oooo0P00003o0?ooofL0oooo
000X0?ooo`800000o`3ooomW0?ooo`00:03oool200000?l0ooooI`3oool00?l0ooooT@3oool00?l0
ooooT@3oool00?l0ooooT@3oool00?l0ooooT@3oool00?l0ooooT@3oool00?l0ooooT@3oool00?l0
ooooT@3oool00?l0ooooT@3oool00?l0ooooT@3oool00?l0ooooT@3oool00?l0ooooT@3oool00?l0
ooooT@3oool00001\
\>"],
  ImageRangeCache->{{{0, 399}, {319, 0}} -> {-0.118372, 0.382331, 0.0028735, \
0.00395098}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\[AliasDelimiter]\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(labelvergleich = 
      Graphics[Text[
          StyleForm["\<Vergleichsfunktion\>", FontSize \[Rule] fontSize\ , \ 
            FontColor \[Rule] RGBColor[1, 0, 0]], {0.45, 
            f1[0.2] + v[0.2] + 0.6}, {\(-0.5\), \(-1\)}]]\)\)\)], "Input"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(\(labelloesung = 
      Graphics[Text[
          StyleForm["\<L\[ODoubleDot]sungsfunktion\>", 
            FontSize \[Rule] fontSize, \ 
            FontColor \[Rule] RGBColor[0, 0, 1]], {0.6, 
            f1[0.2]}, {\(-0.5\), \(-1\)}]]\)\(\[IndentingNewLine]\)
    \)\)\)], "Input"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Show[labelloesung]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.793651 0.0147151 1.47151 [
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
0 g
gsave
.5 .30902 -121.063 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 31.25 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 21.438 moveto
%%IncludeResource: font Courier
%%IncludeFont: Courier
%%BeginResource: font Courier-MISO
%%BeginFont: Courier-MISO
/Courier /Courier-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 1.000 setrgbcolor
0.000 0.000 rmoveto
63.000 21.438 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 1.000 setrgbcolor
(L\\366) show
(sungsfunktion) show
299.250 21.438 moveto
%%IncludeResource: font Courier-MISO
%%IncludeFont: Courier-MISO
/Courier-MISO findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 1.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{411, 253.875},
  ImageMargins->{{64, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006K0000oB000`400?l00000o`00003oo`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00iP3oool60000ojl0oooo003/0?ooo`030000o`3o
ool0oooo0:`0oooo003]0?ooo`030000o`3oool0oooo0:/0oooo003]0?ooo`030000o`3oool0oooo
0:/0oooo003]0?ooo`030000o`3oool0oooo0:/0oooo002D0?ooo`d0003o1P3oool60000o`L0oooo
00<0003o0?ooo`3oool01P000?l:0?ooo`D0003o0P3oool30000o`80oooo1@000?l40?ooo`D0003o
1P3oool40000o`80oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060000o`P0oooo
2@000?l90?ooo`D0003o0P3oool30000o`80oooo1@000?l40?ooo`D0003o0`3oool30000o`D0oooo
1@000?l80?ooo`D0003o1P3oool;0000o`P0oooo1P000?l60?ooo`D0003o103oool50000oaX0oooo
002G0?ooo`030000o`3oool0oooo00H0oooo00<0003o0?ooo`3oool00`3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00@0oooo0`000?l60?ooo`030000o`3oool0oooo00H0oooo00<0
003o0?ooo`3oool00`3oool30000o`H0oooo00<0003o0?ooo`3oool01P3oool00`000?l0oooo0?oo
o`050?ooo`030000o`3oool0oooo0080oooo00<0003o0?ooo`000?l01P3oool30000o`H0oooo00<0
003o0?ooo`3oool0203oool00`000?l0oooo0?ooo`0;0?ooo`030000o`3oool0oooo00<0oooo0`00
0?l60?ooo`030000o`3oool0oooo00H0oooo00<0003o0?ooo`3oool01@3oool00`000?l0oooo0?oo
o`040?ooo`030000o`3oool0oooo00P0oooo00<0003o0?ooo`3oool00`3oool20000o`T0oooo00<0
003o0?ooo`3oool02P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00<0
003o0?ooo`3oool01P3oool00`000?l0oooo0?ooo`0J0?ooo`00U`3oool00`000?l0oooo0?ooo`06
0?ooo`030000o`3oool0oooo0080oooo00<0003o0?ooo`3oool01P3oool00`000?l0oooo0?ooo`03
0?ooo`030000o`3oool0oooo00L0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`06
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00@0oooo0P000?l60?ooo`030000o`3oool0oooo00L0oooo00<0003o
0?ooo`3oool01`3oool00`000?l0oooo0?ooo`0:0?ooo`030000o`3oool0oooo00H0oooo00<0003o
0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`030000o`3oool0oooo00D0oooo00<0003o
0?ooo`3oool00`3oool00`000?l0oooo0?ooo`080?ooo`030000o`3oool0oooo00l0oooo00<0003o
0?ooo`3oool02@3oool00`000?l0oooo0?ooo`060?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool01P3oool00`000?l0oooo0?ooo`0J0?ooo`00U`3oool00`000?l0oooo0?ooo`060?oo
o`050000o`3oool0oooo0?ooo`000?l02P3oool00`000?l0oooo0?ooo`020?ooo`030000o`3oool0
oooo00L0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01P3oool00`000?l0oooo0?ooo`030?ooo`030000o`3oool0
oooo00H0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`070?ooo`030000o`3oool0
oooo00L0oooo00<0003o0?ooo`3oool02P3oool00`000?l0oooo0?ooo`060?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01P3oool00`000?l0oooo0?ooo`050?ooo`030000o`3oool0
oooo0080oooo00<0003o0?ooo`3oool02@3oool00`000?l0oooo0?ooo`0?0?ooo`030000o`3oool0
oooo00P0oooo00<0003o0?ooo`3oool0203oool00`000?l0oooo0?ooo`030?ooo`030000o`3oool0
oooo00H0oooo00<0003o0?ooo`3oool06P3oool009L0oooo00<0003o0?ooo`3oool01P3oool01@00
0?l0oooo0?ooo`3oool0003o00X0oooo00<0003o0?ooo`3oool0303oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00H0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`06
0?ooo`030000o`3oool0oooo00<0oooo00<0003o0?ooo`3oool01P3oool00`000?l0oooo0?ooo`0>
0?ooo`030000o`3oool0oooo00L0oooo00<0003o0?ooo`3oool02P3oool00`000?l0oooo0?ooo`06
0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool00`000?l0oooo0?ooo`05
0?ooo`050000o`3oool0oooo0?ooo`000?l0303oool00`000?l0oooo0?ooo`0?0?ooo`030000o`3o
ool0oooo00P0oooo00<0003o0?ooo`3oool0203oool00`000?l0oooo0?ooo`030?ooo`030000o`3o
ool0oooo00H0oooo00<0003o0?ooo`3oool06P3oool009L0oooo00<0003o0?ooo`3oool01P3oool0
1@000?l0oooo0?ooo`3oool0003o00X0oooo00<0003o0?ooo`3oool02`3oool00`000?l0oooo0?oo
o`050?ooo`030000o`3oool0oooo00H0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?oo
o`060?ooo`030000o`3oool0oooo00<0oooo00<0003o0?ooo`3oool01P3oool00`000?l0oooo0?oo
o`0=0?ooo`030000o`3oool0oooo00P0oooo00<0003o0?ooo`3oool02P3oool00`000?l0oooo0?oo
o`060?ooo`030000o`3oool0oooo00@0oooo00<0003o0?ooo`3oool01P3oool00`000?l0oooo0?oo
o`050?ooo`80003o00<0oooo0000o`3oool0303oool00`000?l0oooo0?ooo`0?0?ooo`030000o`3o
ool0oooo00P0oooo00<0003o0?ooo`3oool0203oool00`000?l0oooo0?ooo`030?ooo`030000o`3o
ool0oooo00H0oooo00<0003o0?ooo`3oool06P3oool009L0oooo00<0003o0?ooo`3oool02P3oool0
0`000?l0oooo0?ooo`080?ooo`030000o`3oool0oooo00@0oooo1`000?l80?ooo`030000o`3oool0
oooo00H0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`060?ooo`030000o`3oool0
oooo00<0oooo00<0003o0?ooo`3oool01P3oool00`000?l0oooo0?ooo`060?ooo`L0003o2`3oool0
0`000?l0oooo0?ooo`0:0?ooo`030000o`3oool0oooo00H0oooo00<0003o0?ooo`3oool0103oool0
0`000?l0oooo0?ooo`060?ooo`030000o`3oool0oooo00D0oooo00@0003o0?ooo`000?l0003o3@3o
ool00`000?l0oooo0?ooo`0?0?ooo`030000o`3oool0oooo00P0oooo00<0003o0?ooo`3oool0203o
ool00`000?l0oooo0?ooo`030?ooo`030000o`3oool0oooo00H0oooo00<0003o0?ooo`3oool06P3o
ool009L0oooo00<0003o0?ooo`3oool02P3oool00`000?l0oooo0?ooo`080?ooo`030000o`3oool0
oooo00<0oooo00<0003o0?ooo`3oool03@3oool00`000?l0oooo0?ooo`060?ooo`030000o`3oool0
oooo00@0oooo00<0003o0?ooo`3oool01P3oool00`000?l0oooo0?ooo`030?ooo`030000o`3oool0
oooo00H0oooo00<0003o0?ooo`3oool01@3oool00`000?l0oooo0?ooo`0@0?ooo`030000o`3oool0
oooo00X0oooo00<0003o0?ooo`3oool01P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0
oooo00H0oooo00<0003o0?ooo`3oool01@3oool01@000?l0oooo0?ooo`3oool0003o00`0oooo00<0
003o0?ooo`3oool03`3oool00`000?l0oooo0?ooo`080?ooo`030000o`3oool0oooo00P0oooo00<0
003o0?ooo`3oool00`3oool00`000?l0oooo0?ooo`060?ooo`030000o`3oool0oooo01X0oooo002G
0?ooo`030000o`3oool0oooo00/0oooo00<0003o0?ooo`3oool01P3oool00`000?l0oooo0?ooo`04
0?ooo`030000o`3oool0oooo00H0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`06
0?ooo`030000o`3oool0oooo00@0oooo0P000?l70?ooo`030000o`3oool0oooo00@0oooo00<0003o
0?ooo`3oool0103oool20000o`L0oooo00<0003o0?ooo`3oool01P3oool00`000?l0oooo0?ooo`07
0?ooo`030000o`3oool0oooo00X0oooo00<0003o0?ooo`3oool01P3oool00`000?l0oooo0?ooo`04
0?ooo`80003o1`3oool00`000?l0oooo0?ooo`050?ooo`030000o`3oool0oooo0080oooo00<0003o
0?ooo`3oool02@3oool00`000?l0oooo0?ooo`0?0?ooo`030000o`3oool0oooo00T0oooo00<0003o
0?ooo`3oool01P3oool00`000?l0oooo0?ooo`040?ooo`80003o1`3oool00`000?l0oooo0?ooo`0J
0?ooo`00U`3oool00`000?l0oooo0?ooo`0<0?ooo`030000o`3oool0oooo00@0oooo00<0003o0?oo
o`3oool01@3oool00`000?l0oooo0?ooo`050?ooo`80003o1P3oool00`000?l0oooo0?ooo`060?oo
o`030000o`3oool0oooo00@0oooo00<0003o0?ooo`000?l01@3oool00`000?l0oooo0?ooo`060?oo
o`030000o`3oool0oooo0080oooo00<0003o0?ooo`000?l01`3oool00`000?l0oooo0?ooo`050?oo
o`80003o2@3oool00`000?l0oooo0?ooo`0:0?ooo`030000o`3oool0oooo00H0oooo00<0003o0?oo
o`3oool0103oool00`000?l0oooo0000o`050?ooo`030000o`3oool0oooo00H0oooo00<0003o0?oo
o`3oool00`3oool00`000?l0oooo0?ooo`080?ooo`030000o`3oool0oooo00l0oooo00<0003o0?oo
o`3oool02P3oool00`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00D0oooo00<0003o0?oo
o`000?l01@3oool00`000?l0oooo0?ooo`0K0?ooo`00U`3oool00`000?l0oooo0?ooo`0=0?ooo`H0
003o2@3oool70000o`030?ooo`000?l0oooo00<0oooo0`000?l60?ooo`<0003o103oool30000o`80
oooo1@000?l:0?ooo`@0003o0P3oool30000o`H0oooo1`000?l00`3oool0003o0?ooo`050?ooo`X0
003o103oool30000o`H0oooo0`000?l40?ooo`<0003o0P3oool50000o`T0oooo00<0003o0?ooo`3o
ool00P3oool50000o`@0oooo2`000?l60?ooo`D0003o3@3oool60000o`H0oooo0`000?l20?ooo`D0
003o7P3oool009L0oooo00<0003o0?ooo`3oool0KP3oool00`000?l0oooo0?ooo`0[0?ooo`030000
o`3oool0oooo00h0oooo00<0003o0?ooo`3oool0D@3oool009L0oooo00<0003o0?ooo`3oool0KP3o
ool00`000?l0oooo0?ooo`0[0?ooo`030000o`3oool0oooo00h0oooo00<0003o0?ooo`3oool0D@3o
ool009L0oooo00<0003o0?ooo`3oool0303oool20000o`@0oooo0P000?mJ0?ooo`030000o`3oool0
oooo02/0oooo00<0003o0?ooo`3oool03P3oool00`000?l0oooo0?ooo`1A0?ooo`00U03oool70000
o`/0oooo0P000?l40?ooo`80003oF`3oool00`000?l0oooo0?ooo`0Z0?ooo`030000o`3oool0oooo
00h0oooo00<0003o0?ooo`3oool03P3oool20000od40oooo003o0?ooo`/0oooo1`000?lS0?ooo`<0
003o8@3oool20000od40oooo003o0?oooeT0oooo0P000?m10?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL0?ooo`00o`3ooonL
0?ooo`00o`3ooonL0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 410}, {252.875, 0}} -> {-0.031295, -0.0100021, \
0.00307949, 0.0016609}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\[IndentingNewLine]\)], "Input"],

Cell[BoxData[
    RowBox[{
      TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
        False,
        Editable->False], "\[IndentingNewLine]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(loesungsVergleichsfunktion = 
      Show[loesungsfunktion, \ vergleichsfunktion, labelvergleich, 
        labelloesung]\)\)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .8 
%%ImageSize: 400 320 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.0238095 0.952381 0.0190476 0.487619 [
[.21429 .00655 -18.3125 -31.75 ]
[.21429 .00655 18.3125 0 ]
[.40476 .00655 -18.3125 -31.75 ]
[.40476 .00655 18.3125 0 ]
[.59524 .00655 -18.3125 -31.75 ]
[.59524 .00655 18.3125 0 ]
[.78571 .00655 -18.3125 -31.75 ]
[.78571 .00655 18.3125 0 ]
[.97619 .00655 -8.53125 -31.75 ]
[.97619 .00655 8.53125 0 ]
[.01131 .14095 -49.6875 -15.875 ]
[.01131 .14095 0 15.875 ]
[.01131 .26286 -36.625 -15.875 ]
[.01131 .26286 0 15.875 ]
[.01131 .38476 -49.6875 -15.875 ]
[.01131 .38476 0 15.875 ]
[.01131 .50667 -17.0625 -15.875 ]
[.01131 .50667 0 15.875 ]
[.01131 .62857 -49.6875 -15.875 ]
[.01131 .62857 0 15.875 ]
[.01131 .75048 -36.625 -15.875 ]
[.01131 .75048 0 15.875 ]
[ -0.003 -0.003 0 0 ]
[ 1.003 .803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.21429 .01905 m
.21429 .0253 L
s
gsave
.21429 .00655 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.2) show
1.000 setlinewidth
grestore
.40476 .01905 m
.40476 .0253 L
s
gsave
.40476 .00655 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.4) show
1.000 setlinewidth
grestore
.59524 .01905 m
.59524 .0253 L
s
gsave
.59524 .00655 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
1.000 setlinewidth
grestore
.78571 .01905 m
.78571 .0253 L
s
gsave
.78571 .00655 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
1.000 setlinewidth
grestore
.97619 .01905 m
.97619 .0253 L
s
gsave
.97619 .00655 -69.5313 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.125 Mabswid
.07143 .01905 m
.07143 .0228 L
s
.11905 .01905 m
.11905 .0228 L
s
.16667 .01905 m
.16667 .0228 L
s
.2619 .01905 m
.2619 .0228 L
s
.30952 .01905 m
.30952 .0228 L
s
.35714 .01905 m
.35714 .0228 L
s
.45238 .01905 m
.45238 .0228 L
s
.5 .01905 m
.5 .0228 L
s
.54762 .01905 m
.54762 .0228 L
s
.64286 .01905 m
.64286 .0228 L
s
.69048 .01905 m
.69048 .0228 L
s
.7381 .01905 m
.7381 .0228 L
s
.83333 .01905 m
.83333 .0228 L
s
.88095 .01905 m
.88095 .0228 L
s
.92857 .01905 m
.92857 .0228 L
s
.006 w
0 .01905 m
1 .01905 L
s
.25 Mabswid
.02381 .14095 m
.03006 .14095 L
s
gsave
.01131 .14095 -110.688 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.25) show
1.000 setlinewidth
grestore
.02381 .26286 m
.03006 .26286 L
s
gsave
.01131 .26286 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.02381 .38476 m
.03006 .38476 L
s
gsave
.01131 .38476 -110.688 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.75) show
1.000 setlinewidth
grestore
.02381 .50667 m
.03006 .50667 L
s
gsave
.01131 .50667 -78.0625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.02381 .62857 m
.03006 .62857 L
s
gsave
.01131 .62857 -110.688 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.25) show
1.000 setlinewidth
grestore
.02381 .75048 m
.03006 .75048 L
s
gsave
.01131 .75048 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.5) show
1.000 setlinewidth
grestore
.125 Mabswid
.02381 .04343 m
.02756 .04343 L
s
.02381 .06781 m
.02756 .06781 L
s
.02381 .09219 m
.02756 .09219 L
s
.02381 .11657 m
.02756 .11657 L
s
.02381 .16533 m
.02756 .16533 L
s
.02381 .18971 m
.02756 .18971 L
s
.02381 .2141 m
.02756 .2141 L
s
.02381 .23848 m
.02756 .23848 L
s
.02381 .28724 m
.02756 .28724 L
s
.02381 .31162 m
.02756 .31162 L
s
.02381 .336 m
.02756 .336 L
s
.02381 .36038 m
.02756 .36038 L
s
.02381 .40914 m
.02756 .40914 L
s
.02381 .43352 m
.02756 .43352 L
s
.02381 .4579 m
.02756 .4579 L
s
.02381 .48229 m
.02756 .48229 L
s
.02381 .53105 m
.02756 .53105 L
s
.02381 .55543 m
.02756 .55543 L
s
.02381 .57981 m
.02756 .57981 L
s
.02381 .60419 m
.02756 .60419 L
s
.02381 .65295 m
.02756 .65295 L
s
.02381 .67733 m
.02756 .67733 L
s
.02381 .70171 m
.02756 .70171 L
s
.02381 .7261 m
.02756 .7261 L
s
.02381 .77486 m
.02756 .77486 L
s
.02381 .79924 m
.02756 .79924 L
s
.006 w
.02381 0 m
.02381 .8 L
s
0 0 m
1 0 L
1 .8 L
0 .8 L
closepath
clip
newpath
0 0 1 r
.02381 .01905 m
.06244 .03883 L
.10458 .0604 L
.14415 .08066 L
.18221 .10015 L
.22272 .12089 L
.26171 .14085 L
.30316 .16207 L
.34309 .18252 L
.3815 .20218 L
.42237 .22311 L
.46172 .24326 L
.49955 .26263 L
.53984 .28325 L
.57861 .30311 L
.61984 .32421 L
.65954 .34454 L
.69774 .3641 L
.73838 .38491 L
.77751 .40494 L
.81909 .42623 L
.85916 .44675 L
.89771 .46649 L
.93871 .48748 L
.97619 .50667 L
s
1 0 0 r
.02381 .01905 m
.06244 .11474 L
.10458 .21179 L
.14415 .29598 L
.18221 .37059 L
.22272 .44317 L
.26171 .50637 L
.30316 .56637 L
.34309 .61719 L
.3815 .65961 L
.42237 .69777 L
.46172 .72772 L
.49955 .75025 L
.52059 .76011 L
.53984 .76746 L
.55972 .77338 L
.57861 .77744 L
.5882 .77891 L
.59346 .77954 L
.59842 .78004 L
.60305 .7804 L
.60549 .78056 L
.60806 .78069 L
.61023 .78079 L
.61138 .78083 L
.61261 .78086 L
.61375 .78089 L
.61478 .78091 L
.61582 .78093 L
.6168 .78094 L
.61794 .78095 L
.61917 .78095 L
.62033 .78095 L
.62139 .78094 L
.62257 .78093 L
.62386 .7809 L
.62521 .78087 L
.62646 .78083 L
.62906 .78074 L
.63142 .78062 L
.63671 .78028 L
.64126 .77989 L
.64619 .77937 L
.65513 .77815 L
.6646 .77649 L
.67501 .77422 L
.69605 .7682 L
.7155 .76095 L
.73639 .75134 L
.77767 .72685 L
Mistroke
.81743 .69632 L
.85567 .66055 L
.89637 .61557 L
.93555 .56553 L
.97619 .50667 L
Mfstroke
0 g
gsave
.45238 .46647 -112.484 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(Vergleichsfunktion) show
264.938 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
gsave
.59524 .11657 -106.313 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
/MISOfy
{
    /newfontname exch def
    /oldfontname exch def

    oldfontname findfont
    dup length dict begin
        {1 index /FID ne {def} {pop pop} ifelse} forall
        /Encoding WindowsANSIEncoding def
        currentdict
    end

    newfontname exch definefont pop
} def

63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
%%BeginResource: font Times-Roman-MISO
%%BeginFont: Times-Roman-MISO
/Times-Roman /Times-Roman-MISO MISOfy
%%EndFont
%%EndResource
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 1.000 setrgbcolor
0.000 0.000 rmoveto
63.000 28.500 moveto
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 1.000 setrgbcolor
(L\\366) show
(sungsfunktion) show
240.250 28.500 moveto
%%IncludeResource: font Times-Roman-MISO
%%IncludeFont: Times-Roman-MISO
/Times-Roman-MISO findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 1.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{400, 320},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0001@2000`400?l00000o`00003oo`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA
0?ooo`00o`3ooonA0?ooo`00K03oool4000000L0oooo0P0000040?ooo`X00000:03oool4000000L0
oooo0P00000;0?ooo`800000:P3oool4000000L0oooo0P0000070?ooo`D00000:P3oool4000000L0
oooo0P0000070?ooo`D00000=03oool6000000L0oooo001[0?ooo`8000000`3oool2000000D0oooo
0P0000050?ooo`T000009`3oool2000000<0oooo0P0000050?ooo`8000002`3oool2000002T0oooo
0P0000030?ooo`8000001@3oool2000000H0oooo0P0000030?ooo`800000:03oool2000000<0oooo
0P0000050?ooo`8000001@3oool3000000@0oooo0P00000d0?ooo`8000002@3oool006/0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo0P00
000V0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0403oool2000002T0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`0:0?ooo`8000001@3oool2000002L0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`090?ooo`<000001P3oool2000003<0oooo0P00
00090?ooo`00JP3oool2000000D0oooo0P00000=0?ooo`030000003oool0oooo02X0oooo0P000005
0?ooo`8000004@3oool2000002P0oooo0P0000050?ooo`8000002`3oool2000000H0oooo00<00000
0?ooo`3oool0903oool2000000D0oooo0P00000:0?ooo`8000001`3oool2000003<0oooo0P000009
0?ooo`00JP3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool0:@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo2`00000V0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool2000000L0oooo0P00000U0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool2000000L0oooo0P00000c0?oo
o`8000002@3oool006T0oooo0P0000070?ooo`8000003P3oool00`000000oooo0?ooo`0W0?ooo`80
00001`3oool2000000T0oooo00<000000?ooo`3oool0103oool2000002L0oooo0P0000070?ooo`80
00002@3oool2000000L0oooo0P00000T0?ooo`8000001`3oool2000000T0oooo0P0000060?ooo`<0
0000<`3oool2000000T0oooo001Y0?ooo`8000001`3oool2000000l0oooo00<000000?ooo`3oool0
9P3oool2000000L0oooo0P00000:0?ooo`030000003oool0oooo00<0oooo0P00000W0?ooo`800000
1`3oool2000000T0oooo0P0000070?ooo`800000903oool2000000L0oooo0P00000:0?ooo`800000
103oool3000003@0oooo0P0000090?ooo`00J@3oool2000000L0oooo0P00000?0?ooo`030000003o
ool0oooo02H0oooo0P0000070?ooo`8000002`3oool00`000000oooo0?ooo`020?ooo`8000009`3o
ool2000000L0oooo0P0000090?ooo`8000001`3oool2000002@0oooo0P0000070?ooo`8000002`3o
ool010000000oooo0?ooo`3oool3000003D0oooo0P0000090?ooo`00J@3oool2000000L0oooo0P00
000@0?ooo`030000003oool0oooo02D0oooo0P0000070?ooo`8000002`3oool00`000000oooo0?oo
o`020?ooo`8000009`3oool2000000L0oooo0P0000090?ooo`8000001P3oool2000002D0oooo0P00
00070?ooo`800000303oool5000003H0oooo0P0000090?ooo`00J@3oool2000000L0oooo0P00000A
0?ooo`030000003oool0oooo02@0oooo0P0000070?ooo`800000303oool010000000oooo0?ooo`3o
ool2000002L0oooo0P0000070?ooo`8000002@3oool4000000<0oooo0`00000U0?ooo`8000001`3o
ool2000000`0oooo1000000g0?ooo`8000002@3oool006T0oooo0P0000070?ooo`8000004@3oool0
0`000000oooo0?ooo`0T0?ooo`8000001`3oool2000000d0oooo00<000000?ooo`3oool00P00000W
0?ooo`8000001`3oool2000000X0oooo0P0000000`3oool0000000000002000002L0oooo0P000007
0?ooo`8000002`3oool300000080oooo00<000000?ooo`3oool0=03oool2000000T0oooo001Y0?oo
o`8000001`3oool200000140oooo0P00000U0?ooo`8000001`3oool2000000d0oooo00<000000?oo
o`3oool00P00000W0?ooo`8000001`3oool2000000X0oooo0P00000/0?ooo`8000001`3oool20000
00X0oooo0`0000040?ooo`800000=03oool2000000T0oooo001Z0?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`8000009P3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00d0oooo00@000000?ooo`0000000000:03oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo00X0oooo0P00000/0?ooo`030000003oool0oooo
00D0oooo00<000000?ooo`3oool0203oool3000000H0oooo0P00000c0?ooo`8000002@3oool006X0
oooo0P0000050?ooo`8000002P3oool00`000000oooo0?ooo`050?ooo`8000009P3oool2000000D0
oooo0P00000?0?ooo`040000003oool00000000002P0oooo0P0000050?ooo`8000003@3oool20000
02/0oooo0P0000050?ooo`8000002P3oool2000000L0oooo0P00000c0?ooo`8000002@3oool006/0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0080
oooo1000000W0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool03`3oool3000002T0
oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0=0?ooo`800000:`3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00T0oooo0P0000070?ooo`800000<`3oool2000000T0
oooo001[0?ooo`8000000`3oool2000000`0oooo2000000X0?ooo`8000000`3oool200000180oooo
0P00000Y0?ooo`8000000`3oool200000100oooo0`00000Y0?ooo`8000000`3oool2000000`0oooo
0P0000050?ooo`800000<@3oool5000000T0oooo001]0?ooo`<00000403oool4000002`0oooo0`00
000D0?ooo`800000:`3oool3000001@0oooo1000000X0?ooo`<00000403oool6000003@0oooo0`00
00090?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00=@3o
ool200000?l0ooooFP3oool003D0oooo0P00003o0?oooeX0oooo000e0?ooo`800000o`3ooomJ0?oo
o`00=@3oool200000?l0ooooFP3oool003D0oooo0P00003o0?oooeX0oooo000e0?ooo`800000o`3o
oomJ0?ooo`00=@3oool00`000000o`000?ooo`3o0?oooeT0oooo000/0?ooo`T000000`3o00000`00
0?l000000000003o000005@000000P3oool002`0oooo2P0000020?l000<0003oo`00001D00000080
oooo000e0?ooo`030000003o0000o`0000D0003o?03oool00`000000oooo0?ooo`100?ooo`030000
003oool0oooo0400oooo00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`100?ooo`030000
003oool0oooo00P0oooo000e0?ooo`050000003o0000o`000?l0003oool010000?oo0?oooe<0oooo
000e0?ooo`8000000P3o00030?ooo`@0003oo`3ooomA0?ooo`00=@3oool2000000<0o`000`3oool5
0000ool0ooooC`3oool003D0oooo0P0000000`3oool0o`000?l000050?ooo`D0003oo`3ooom=0?oo
o`00=@3oool2000000030?ooo`3o0000o`0000L0oooo1@000?oo0?oood/0oooo000e0?ooo`800000
00@0oooo0?l0003o0000o`00203oool50000ool0ooooB@3oool003D0oooo0`0000000`3oool0o`00
0?l0000:0?ooo`D0003oo`3ooom70?ooo`00=@3oool200000080oooo0`3o000;0?ooo`@0003oo`3o
oom60?ooo`00=@3oool2000000<0oooo0P3o000=0?ooo`@0003oo`3ooom40?ooo`00=@3oool20000
00<0oooo0P3o000>0?ooo`D0003oo`3ooom20?ooo`00=@3oool2000000<0oooo0`3o000?0?ooo`D0
003oo`3ooom00?ooo`00=@3oool2000000@0oooo0P3o000A0?ooo`D0003oo`3oooln0?ooo`00=@3o
ool2000000@0oooo0P3o000C0?ooo`D0003oo`3oooll0?ooo`00=@3oool2000000@0oooo0`3o000D
0?ooo`D0003oo`3ooolj0?ooo`00=@3oool3000000@0oooo0P3o000F0?ooo`D0003oo`3ooolh0?oo
o`00=@3oool2000000D0oooo0`3o000G0?ooo`D0003oo`3ooolf0?ooo`00=@3oool2000000H0oooo
0P3o000I0?ooo`D0003oo`3ooold0?ooo`00=@3oool2000000H0oooo0P3o000K0?ooo`D0003oo`3o
oolb0?ooo`00=@3oool2000000H0oooo0`3o000L0?ooo`D0003oo`3oool`0?ooo`00=@3oool20000
00L0oooo0P3o000N0?ooo`D0003oo`3oool^0?ooo`00=@3oool2000000L0oooo0P3o000P0?ooo`D0
003oo`3oool/0?ooo`00=@3oool2000000L0oooo0`3o000Q0?ooo`D0003oo`3ooolZ0?ooo`00=@3o
ool2000000P0oooo0P3o000S0?ooo`@0003oo`3ooolY0?ooo`00=@3oool3000000L0oooo0`3o000T
0?ooo`@0003oo`3ooolW0?ooo`00=@3oool2000000T0oooo0P3o000U0?ooo`D0003oo`3ooolU0?oo
o`00=@3oool2000000T0oooo0P3o000W0?ooo`D0003oo`3ooolS0?ooo`00=@3oool2000000X0oooo
0P3o000X0?ooo`D0003oo`3ooolQ0?ooo`00=@3oool2000000X0oooo0P3o000Z0?ooo`D0003oo`3o
oolO0?ooo`00=@3oool2000000X0oooo0`3o000[0?ooo`D0003oo`3ooolM0?ooo`00=@3oool20000
00/0oooo0P3o000]0?ooo`H0003oo`3ooolJ0?ooo`00=@3oool2000000/0oooo0P3o000_0?ooo`H0
003oo`3ooolH0?ooo`00=@3oool3000000/0oooo00<0o`000?ooo`3oool0<03oool50000ool0oooo
5P3oool000H0oooo100000070?ooo`800000103oool:000000@0oooo1@00000;0?ooo`800000303o
ool20?l003<0oooo1@000?oo0?oooa@0oooo00050?ooo`8000000`3oool2000000D0oooo0P000005
0?ooo`T000000`3oool2000000@0oooo00<000000?ooo`3oool0203oool2000000d0oooo00<0o`00
0?ooo`3oool0<`3oool50000ool0oooo4P3oool000D0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`0;0?ooo`030000003oool0oooo00@0oooo0P0000090?ooo`030000003oool0oooo
00L0oooo0P00000=0?ooo`80o`00=P3oool50000oiD0oooo1`000?mc0?ooo`00103oool2000000D0
oooo0P00000=0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool01P3oool2000000h0
oooo00<0o`000?ooo`3oool0=P3oool50000oi80oooo0`000?l50?ooo`030000o`3oool0oooo0700
oooo00040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0303oool00`000000oooo
0?ooo`0>0?ooo`8000001`3oool2000000h0oooo00<0o`000?ooo`3oool0>03oool40000oi00oooo
0P000?l80?ooo`030000o`3oool0oooo06l0oooo00030?ooo`8000001`3oool2000000h0oooo00<0
00000?ooo`3oool03@3oool2000000L0oooo0P00000>0?ooo`80o`00>`3oool40000ohh0oooo0P00
0?l90?ooo`030000o`3oool0oooo06h0oooo00030?ooo`8000001`3oool2000000l0oooo00<00000
0?ooo`3oool0303oool2000000L0oooo0P00000?0?ooo`030?l0003oool0oooo03X0oooo1@000?n=
0?ooo`030000o`3oool0oooo00L0oooo00<0003o0?ooo`3oool0KP3oool000<0oooo0P0000070?oo
o`8000003`3oool00`000000oooo0?ooo`0<0?ooo`8000001`3oool2000000l0oooo0P3o000m0?oo
o`D0003oS03oool00`000?l0oooo0?ooo`050?ooo`80003oL03oool000<0oooo0P0000070?ooo`80
0000403oool00`000000oooo0?ooo`0:0?ooo`<000001`3oool4000000h0oooo00<0o`000?ooo`3o
ool0?@3oool50000odT0oooo30000?l60?ooo`D0003o1@3oool00`000?l0oooo0?ooo`030000o`H0
oooo10000?l20?ooo`80003o0P3oool60000o`80oooo1@000?l20?ooo`X0003o00@0oooo0000o`3o
ool0oooo0`000?l40?ooo`H0003o103oool40000o`80oooo0P000?l20?ooo`H0003o0P3oool;0000
o`80oooo1@000?l30?ooo`<0003o00<0oooo0000o`000?l010000?l40?ooo`D0003o103oool60000
o`80oooo1@000?l@0?ooo`000`3oool2000000L0oooo0P00000A0?ooo`030000003oool0oooo00P0
oooo0`0000080?ooo`800000403oool20?l00400oooo1@000?m90?ooo`80003o1P3oool20000o`D0
oooo0P000?l40?ooo`030000o`3oool0oooo0080oooo0`000?l30?ooo`030000o`3oool0oooo00<0
oooo0P000?l20?ooo`H0003o0P3oool20000o`D0oooo0P000?l30?ooo`X0003o0P3oool30000o`<0
oooo00<0003o0?ooo`3oool00`3oool20000o`H0oooo0P000?l20?ooo`H0003o0P3oool20000o`D0
oooo0P000?l40?ooo`80003o1@3oool20000o`@0oooo0P000?l20?ooo`030000o`3oool0oooo0080
003o1@3oool20000o`@0oooo00<0003o0?ooo`3oool00`3oool20000o`D0oooo0P000?lB0?ooo`00
0`3oool2000000L0oooo0P00000A0?ooo`030000003oool0oooo00H0oooo100000090?ooo`800000
4@3oool00`3o0000oooo0?ooo`100?ooo`D0003oA`3oool20000o`L0oooo0P000?l30?ooo`80003o
1P3oool010000?l0oooo0?ooo`3oool20000o`@0oooo0P000?l30?ooo`80003o1@3oool20000o`@0
oooo0P000?l50?ooo`80003o0`3oool20000o`X0oooo0P000?l40?ooo`80003o103oool20000o`D0
oooo0P000?l50?ooo`80003o103oool20000o`D0oooo0P000?l40?ooo`80003o103oool20000o`D0
oooo0P000?l50?ooo`80003o103oool20000o`H0oooo00<0003o0?ooo`3oool00P3oool20000o`D0
oooo0P000?lB0?ooo`000`3oool2000000L0oooo0P00000A0?ooo`800000103oool6000000X0oooo
0P00000A0?ooo`80o`00@`3oool60000od@0oooo0P000?l70?ooo`80003o0P3oool30000o`H0oooo
00D0003o0?ooo`3oool0oooo0000o`050?ooo`80003o0`3oool20000o`D0oooo0P000?l40?ooo`80
003o1@3oool20000o`@0oooo00<0003o0?ooo`3oool0203oool00`000?l0oooo0?ooo`030?ooo`80
003o103oool20000o`D0oooo0P000?l50?ooo`80003o103oool20000o`D0oooo0P000?l40?ooo`80
003o0`3oool20000o`H0oooo0P000?l50?ooo`80003o0`3oool30000o`H0oooo00<0003o0?ooo`3o
ool00P3oool20000o`D0oooo0P000?lB0?ooo`00103oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool2000000D0oooo0`00000<0?ooo`800000
4P3oool00`3o0000oooo0?ooo`130?ooo`H0003o@P3oool20000o`P0oooo00<0003o0?ooo`3oool0
0P000?l70?ooo`80003o1`3oool30000o`<0oooo0P000?l50?ooo`80003o103oool20000o`D0oooo
0P000?l50?ooo`D0003o2P3oool30000o`@0oooo0P000?l50?ooo`80003o1@3oool20000o`@0oooo
0P000?l50?ooo`80003o103oool20000o`80oooo0P000?l70?ooo`80003o1@3oool20000o`<0oooo
0P000?l70?ooo`80003o0`3oool20000o`D0oooo0P000?lB0?ooo`00103oool2000000D0oooo0P00
000:0?ooo`030000003oool0oooo00D0oooo0P0000050?ooo`030000003oool0oooo00`0oooo0P00
000B0?ooo`030?l0003oool0oooo04H0oooo1@000?m00?ooo`80003o2`3oool20000o`L0oooo0P00
0?l50?ooo`@0003o103oool20000o`D0oooo0P000?l40?ooo`80003o1@3oool20000o`@0oooo0P00
0?l30?ooo`80003o1`3oool40000o`D0oooo0P000?l50?ooo`80003o1@3oool20000o`@0oooo0P00
0?l50?ooo`80003o103oool20000o`030?ooo`000?l0003o00P0oooo0P000?l50?ooo`80003o0`3o
ool20000o`L0oooo0P000?l30?ooo`80003o1@3oool20000oa80oooo00050?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`020?ooo`@000001P3oool0
0`000000oooo0?ooo`0;0?ooo`8000004P3oool20?l004T0oooo1@000?ln0?ooo`80003o2`3oool2
0000o`L0oooo0P000?l30?ooo`D0003o1@3oool20000o`D0oooo0P000?l40?ooo`80003o1@3oool2
0000o`<0oooo0P000?l50?ooo`80003o103oool50000o`H0oooo0P000?l50?ooo`80003o1@3oool2
0000o`@0oooo0P000?l50?ooo`80003o103oool40000o`T0oooo0P000?l50?ooo`80003o0`3oool2
0000o`L0oooo0P000?l30?ooo`80003o1@3oool20000oa80oooo00050?ooo`8000000`3oool20000
00`0oooo200000070?ooo`H00000203oool2000001<0oooo00<0o`000?ooo`3oool0B@3oool50000
oc`0oooo0P000?l;0?ooo`80003o1`3oool20000o`80oooo0`000?l80?ooo`80003o1@3oool20000
o`@0oooo0P000?l50?ooo`80003o0`3oool20000o`D0oooo0P000?l30?ooo`<0003o2@3oool20000
o`D0oooo0P000?l50?ooo`80003o103oool20000o`D0oooo0P000?l40?ooo`80003o00<0oooo0000
o`3oool0203oool20000o`D0oooo0P000?l30?ooo`80003o1`3oool20000o`<0oooo0P000?l50?oo
o`80003o4P3oool000L0oooo0`00000@0?ooo`@000002P3oool6000000L0oooo0P00000C0?ooo`80
o`00C03oool40000oc/0oooo0P000?l<0?ooo`030000o`3oool0oooo00@0oooo0`000?l20?ooo`80
003o103oool00`000?l0oooo0?ooo`020?ooo`80003o1@3oool20000o`@0oooo0P000?l50?ooo`80
003o0`3oool20000o`D0oooo0P000?l30?ooo`80003o103oool00`000?l0oooo0?ooo`030?ooo`80
003o1@3oool20000o`D0oooo0P000?l40?ooo`80003o1@3oool20000o`@0oooo0P000?l20?ooo`03
0000o`3oool0oooo00H0oooo0P000?l50?ooo`80003o103oool00`000?l0oooo0?ooo`040?ooo`<0
003o0`3oool20000o`D0oooo0P000?lB0?ooo`00=@3oool3000001<0oooo00<0o`000?ooo`3oool0
C03oool40000ocT0oooo0P000?l<0?ooo`80003o1@3oool20000o`<0oooo00<0003o0?ooo`3oool0
0P3oool20000o`@0oooo0P000?l50?ooo`80003o103oool20000o`D0oooo0P000?l30?ooo`80003o
1@3oool20000o`<0oooo00<0003o0?ooo`3oool00P3oool20000o`D0oooo0P000?l50?ooo`80003o
1@3oool20000o`@0oooo0P000?l50?ooo`80003o103oool20000o`<0oooo00<0003o0?ooo`3oool0
1@3oool20000o`D0oooo0P000?l40?ooo`80003o1@3oool20000o`@0oooo0P000?l50?ooo`80003o
4P3oool003D0oooo0P00000D0?ooo`80o`00CP3oool50000ocL0oooo0P000?l=0?ooo`030000o`3o
ool0oooo0080oooo0P000?l40?ooo`030000o`3oool0oooo0080oooo0P000?l40?ooo`80003o1@3o
ool20000o`80oooo1P000?l20?ooo`<0003o103oool20000o`<0oooo1@000?l00`3oool0003o0?oo
o`030?ooo`80003o1@3oool20000o`D0oooo0P000?l50?ooo`80003o0P3oool60000o`80oooo0`00
0?l40?ooo`80003o103oool20000o`D0oooo0P000?l30?ooo`@0003o1@3oool00`000?l0oooo0?oo
o`020?ooo`80003o0`3oool60000o`80oooo0`000?lB0?ooo`00=@3oool2000001D0oooo00<0o`00
0?ooo`3oool0CP3oool50000ocD0oooo0P000?l>0?ooo`D0003o1P3oool40000o`040?ooo`000?l0
oooo0?ooo`@0003o0`3oool40000o`@0oooo0P000?l20?ooo`@0003o1P3oool50000o`H0oooo1000
0?l00`3oool0003o0?ooo`020?ooo`/0003o0`3oool40000o`@0oooo0P000?l20?ooo`@0003o1@3o
ool20000o`<0oooo3@000?l20?ooo`80003o1P3oool50000o`H0oooo0P000?l20?ooo`@0003o4`3o
ool003D0oooo0P00000E0?ooo`030?l0003oool0oooo0500oooo10000?ld0?ooo`80003oE03oool2
0000oal0oooo0P000?l;0?ooo`80003o<`3oool003D0oooo0P00000E0?ooo`80o`00D`3oool40000
oc80oooo0P000?mD0?ooo`80003o7`3oool20000o`/0oooo0P000?lc0?ooo`00=@3oool2000001H0
oooo00<0o`000?ooo`3oool0DP3oool50000oc00oooo0P000?l>0?ooo`80003o0P3oool20000od00
oooo0P000?lO0?ooo`80003o303oool00`000?l0oooo0?ooo`0a0?ooo`00=@3oool2000001H0oooo
0P3o001E0?ooo`D0003o;P3oool20000o`h0oooo0P000?l20?ooo`80003o@@3oool00`000?l0oooo
0?ooo`020?ooo`80003o6@3oool20000o``0oooo00<0003o0?ooo`3oool0<@3oool003D0oooo0P00
000G0?ooo`030?l0003oool0oooo05D0oooo1@000?lZ0?ooo`H0003oD`3oool20000o`80oooo0`00
0?lG0?ooo`@0003o4P3oool20000ob`0oooo000e0?ooo`<000005P3oool20?l005P0oooo1@000?n3
0?ooo`@0003o6P3oool20000oa80oooo0P000?l/0?ooo`00=@3oool2000001P0oooo00<0o`000?oo
o`3oool0F03oool50000on40oooo000e0?ooo`800000603oool20?l005/0oooo1@000?oO0?ooo`00
=@3oool2000001T0oooo00<0o`000?ooo`3oool0F`3oool50000omd0oooo000e0?ooo`8000006@3o
ool00`3o0000oooo0?ooo`1M0?ooo`D0003of`3oool003D0oooo0P00000I0?ooo`80o`00H03oool5
0000omT0oooo000e0?ooo`8000006P3oool00`3o0000oooo0?ooo`1P0?ooo`D0003oe`3oool003D0
oooo0P00000J0?ooo`80o`00H`3oool50000omD0oooo000e0?ooo`8000006`3oool00`3o0000oooo
0?ooo`1S0?ooo`D0003od`3oool003D0oooo0`00000J0?ooo`80o`00IP3oool50000om40oooo000e
0?ooo`800000703oool00`3o0000oooo0?ooo`1V0?ooo`D0003oc`3oool003D0oooo0P00000L0?oo
o`80o`00J@3oool50000old0oooo000e0?ooo`8000007@3oool00`3o0000oooo0?ooo`1Y0?ooo`D0
003ob`3oool003D0oooo0P00000M0?ooo`80o`00K03oool50000olT0oooo000e0?ooo`8000007P3o
ool00`3o0000oooo0?ooo`1/0?ooo`D0003oa`3oool003D0oooo0P00000N0?ooo`030?l0003oool0
oooo06h0oooo1@000?o50?ooo`00=@3oool2000001h0oooo0P3o001a0?ooo`D0003o``3oool003D0
oooo0`00000N0?ooo`030?l0003oool0oooo0740oooo1@000?o10?ooo`004`3oool4000000L0oooo
0P0000050?ooo`D000002`3oool2000001l0oooo0P3o001d0?ooo`D0003o_`3oool00180oooo0P00
00030?ooo`8000001@3oool2000000@0oooo0P0000040?ooo`030000003oool0oooo00P0oooo0P00
000P0?ooo`030?l0003oool0oooo07@0oooo1@000?nm0?ooo`004P3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool01`3oool200000200oooo0P3o001g
0?ooo`D0003o^`3oool00140oooo0P0000050?ooo`8000004P3oool00`000000oooo0?ooo`060?oo
o`8000008@3oool00`3o0000oooo0?ooo`1g0?ooo`D0003o^@3oool00140oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`0@0?ooo`8000001`3oool200000240oooo0P3o001j0?ooo`@0
003o^03oool00100oooo0P0000070?ooo`8000004@3oool2000000L0oooo0P00000R0?ooo`030?l0
003oool0oooo07X0oooo10000?nf0?ooo`00403oool2000000L0oooo0P00000A0?ooo`8000001`3o
ool200000280oooo0P3o001l0?ooo`D0003o]03oool00100oooo0P0000070?ooo`8000004@3oool2
000000L0oooo0P00000S0?ooo`030?l0003oool0oooo07`0oooo1@000?nb0?ooo`00403oool20000
00L0oooo0P00000@0?ooo`<000001`3oool400000240oooo0P3o001o0?ooo`D0003o/03oool00100
oooo0P0000070?ooo`8000003`3oool3000000P0oooo0P00000T0?ooo`030?l0003oool0oooo07l0
oooo1@000?n^0?ooo`00403oool2000000L0oooo0P00000=0?ooo`@000002@3oool2000002@0oooo
0P3o00220?ooo`D0003o[03oool00100oooo0P0000070?ooo`8000002P3oool6000000X0oooo0P00
000U0?ooo`030?l0003oool0oooo0880oooo1@000?nZ0?ooo`004@3oool00`000000oooo0?ooo`05
0?ooo`030000003oool0oooo00X0oooo0`00000<0?ooo`8000009@3oool00`3o0000oooo0?ooo`24
0?ooo`D0003oZ03oool00140oooo0P0000050?ooo`800000303oool00`000000oooo0?ooo`0<0?oo
o`8000009@3oool20?l008L0oooo1@000?nV0?ooo`004P3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool2000002H0oooo00<0o`000?ooo`3o
ool0Q`3oool50000oj@0oooo000B0?ooo`8000000`3oool2000000h0oooo1P0000080?ooo`800000
9P3oool20?l008X0oooo1@000?nR0?ooo`00503oool300000140oooo1P0000070?ooo`<000009P3o
ool00`3o0000oooo0?ooo`2:0?ooo`D0003oX03oool003D0oooo0P00000W0?ooo`80o`00S@3oool5
0000oih0oooo000e0?ooo`800000:03oool00`3o0000oooo0?ooo`2=0?ooo`D0003oW03oool003D0
oooo0P00000X0?ooo`80o`00T03oool50000oiX0oooo000e0?ooo`800000:@3oool00`3o0000oooo
0?ooo`2@0?ooo`D0003oV03oool003D0oooo0P00000Y0?ooo`80o`00T`3oool50000oiH0oooo000e
0?ooo`800000:P3oool00`3o0000oooo0?ooo`2C0?ooo`D0003oU03oool003D0oooo0P00000Z0?oo
o`80o`00UP3oool50000oi80oooo000e0?ooo`800000:`3oool00`3o0000oooo0?ooo`2F0?ooo`D0
003oT03oool003D0oooo0`00000Z0?ooo`80o`00V@3oool60000ohd0oooo000e0?ooo`800000;03o
ool00`3o0000oooo0?ooo`2I0?ooo`H0003oR`3oool003D0oooo0P00000/0?ooo`80o`00W@3oool5
0000ohT0oooo000e0?ooo`800000;@3oool00`3o0000oooo0?ooo`2M0?ooo`D0003oQ`3oool003D0
oooo0P00000]0?ooo`80o`00X03oool50000ohD0oooo000e0?ooo`800000;P3oool00`3o0000oooo
0?ooo`2P0?ooo`@0003oQ03oool003D0oooo0P00000^0?ooo`80o`00X`3oool40000oh80oooo000e
0?ooo`800000;`3oool00`3o0000oooo0?ooo`2R0?ooo`D0003oP03oool003D0oooo0P00000_0?oo
o`80o`00Y@3oool50000ogh0oooo000e0?ooo`<00000;`3oool00`3o0000oooo0?ooo`2U0?ooo`@0
003oO@3oool003D0oooo0P00000`0?ooo`80o`00Z03oool40000og/0oooo000e0?ooo`800000<@3o
ool00`3o0000oooo0?ooo`2W0?ooo`D0003oN@3oool003D0oooo0P00000a0?ooo`80o`00ZP3oool5
0000ogL0oooo000e0?ooo`800000<P3oool00`3o0000oooo0?ooo`2Z0?ooo`D0003oM@3oool003D0
oooo0P00000b0?ooo`80o`00[@3oool50000og<0oooo000e0?ooo`800000<`3oool00`3o0000oooo
0?ooo`2]0?ooo`@0003oLP3oool003D0oooo0P00000c0?ooo`80o`00/03oool40000og00oooo000e
0?ooo`<00000<`3oool00`3o0000oooo0?ooo`2_0?ooo`D0003oKP3oool000H0oooo100000070?oo
o`800000203oool00`000000oooo0?ooo`070?ooo`D000002`3oool2000003@0oooo0P3o002b0?oo
o`D0003oK03oool000D0oooo0P0000030?ooo`8000001@3oool2000000P0oooo0P0000070?ooo`80
0000103oool00`000000oooo0?ooo`080?ooo`800000=@3oool00`3o0000oooo0?ooo`2b0?ooo`D0
003oJP3oool000D0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00`0oooo00<000000?ooo`3oool01`3oool2000003D0oooo0P3o002e0?ooo`D0003o
J03oool000@0oooo0P0000050?ooo`8000003`3oool00`000000oooo0?ooo`0=0?ooo`030000003o
ool0oooo00H0oooo0P00000f0?ooo`030?l0003oool0oooo0;D0oooo1@000?mV0?ooo`00103oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00d0oooo0P00000>0?ooo`8000001`3oool2
000003H0oooo0P3o002h0?ooo`D0003oI03oool000<0oooo0P0000070?ooo`8000003`3oool00`00
0000oooo0?ooo`0<0?ooo`8000001`3oool2000003L0oooo00<0o`000?ooo`3oool0^03oool50000
of80oooo00030?ooo`8000001`3oool2000000l0oooo00<000000?ooo`3oool0303oool2000000L0
oooo0P00000g0?ooo`80o`00^`3oool50000of00oooo00030?ooo`8000001`3oool2000000l0oooo
0P00000=0?ooo`8000001`3oool2000003P0oooo0P3o002l0?ooo`D0003oGP3oool000<0oooo0P00
00070?ooo`800000403oool00`000000oooo0?ooo`0:0?ooo`<000001`3oool4000003L0oooo00<0
o`000?ooo`3oool0_03oool50000oe`0oooo00030?ooo`8000001`3oool200000100oooo00<00000
0?ooo`3oool02@3oool3000000P0oooo0P00000i0?ooo`80o`00_`3oool50000oeX0oooo00030?oo
o`8000001`3oool200000100oooo0P0000080?ooo`@000002@3oool2000003X0oooo00<0o`000?oo
o`3oool0_`3oool50000oeP0oooo00030?ooo`8000001`3oool200000140oooo00<000000?ooo`3o
ool00`3oool6000000X0oooo0P00000j0?ooo`80o`00`P3oool50000oeH0oooo00040?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`040?ooo`<00000
303oool2000003/0oooo0P3o00330?ooo`D0003oE03oool000@0oooo0P0000050?ooo`8000002P3o
ool00`000000oooo0?ooo`050?ooo`8000001@3oool00`000000oooo0?ooo`0<0?ooo`800000?03o
ool00`3o0000oooo0?ooo`330?ooo`D0003oDP3oool000D0oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool0
0`000000oooo0?ooo`0;0?ooo`800000?03oool20?l00<H0oooo1@000?m@0?ooo`001@3oool20000
00<0oooo0P00000<0?ooo`T000001P3oool6000000P0oooo0P00000m0?ooo`030?l0003oool0oooo
0<H0oooo1@000?m>0?ooo`001`3oool3000000l0oooo2@0000060?ooo`H000001`3oool3000003`0
oooo0P3o00390?ooo`D0003oC03oool003D0oooo0P00000n0?ooo`80o`00bP3oool50000odX0oooo
000e0?ooo`800000?`3oool00`3o0000oooo0?ooo`3:0?ooo`H0003oA`3oool003D0oooo0P00000o
0?ooo`80o`00c@3oool60000odD0oooo000e0?ooo`800000@03oool00`3o0000oooo0?ooo`3>0?oo
o`D0003o@`3oool003D0oooo0P0000100?ooo`80o`00d@3oool50000od40oooo000e0?ooo`800000
@@3oool20?l00=80oooo1@000?lo0?ooo`00=@3oool200000480oooo00<0o`000?ooo`3oool0dP3o
ool40000och0oooo000e0?ooo`800000@P3oool20?l00=D0oooo10000?ll0?ooo`00=@3oool30000
0480oooo00<0o`000?ooo`3oool0e03oool50000ocX0oooo000e0?ooo`800000@`3oool20?l00=L0
oooo1@000?lh0?ooo`00=@3oool2000004@0oooo0P3o003H0?ooo`@0003o=`3oool003D0oooo0P00
00150?ooo`030?l0003oool0oooo0=P0oooo10000?le0?ooo`00=@3oool2000004D0oooo0P3o003J
0?ooo`D0003o<`3oool003D0oooo0P0000160?ooo`030?l0003oool0oooo0=X0oooo1@000?la0?oo
o`00=@3oool2000004H0oooo0P3o003M0?ooo`D0003o;`3oool003D0oooo0P0000170?ooo`80o`00
gP3oool50000obd0oooo000e0?ooo`800000B03oool00`3o0000oooo0?ooo`3N0?ooo`@0003o;03o
ool003D0oooo0`0000170?ooo`80o`00h@3oool40000obX0oooo000e0?ooo`800000B@3oool00`3o
0000oooo0?ooo`3P0?ooo`D0003o:03oool003D0oooo0P0000190?ooo`80o`00h`3oool50000obH0
oooo000e0?ooo`800000BP3oool00`3o0000oooo0?ooo`3S0?ooo`D0003o903oool003D0oooo0P00
001:0?ooo`80o`00iP3oool50000ob80oooo000e0?ooo`800000B`3oool00`3o0000oooo0?ooo`10
0?ooo`L0o`00W`3oool50000ob00oooo000e0?ooo`800000B`3oool20?l00400oooo0`3o00050?oo
o`030?l0003oool0oooo09h0oooo1P000?lM0?ooo`00=@3oool2000004`0oooo0P3o000n0?ooo`80
o`00203oool00`3o0000oooo0?ooo`2O0?ooo`H0003o6`3oool003D0oooo0`00001<0?ooo`030?l0
003oool0oooo03`0oooo0P3o00090?ooo`030?l0003oool0oooo0:40oooo1@000?lI0?ooo`009P3o
ool6000000T0oooo0P00001=0?ooo`80o`00?P3oool00`3o0000oooo0?ooo`070?ooo`030?l0003o
ool0oooo0:<0oooo1@000?lG0?ooo`00:03oool2000000/0oooo0P00001>0?ooo`030?l0003oool0
oooo03d0oooo00<0o`000?ooo`3oool01@3oool20?l00:L0oooo1@000?lE0?ooo`00:03oool20000
00/0oooo0P00001>0?ooo`80o`007@3oool20?l000`0oooo103o00040?ooo`H0o`001@3oool@0?l0
00@0oooo103o00040?ooo`H0o`00103oool40?l000@0oooo1P3o00020?ooo`D0o`0000@0oooo0?l0
003oool0oooo0`3o00040?ooo`H0o`00103oool40?l00080oooo0P3o00020?ooo`H0o`000P3oool;
0?l00080oooo1@3o00030?ooo`<0o`0000<0oooo0?l0003o0000103o00040?ooo`D0o`00103oool6
0?l00080oooo1@3o000H0?ooo`D0003o4`3oool002P0oooo0P00000;0?ooo`800000C`3oool00`3o
0000oooo0?ooo`0K0?ooo`80o`002`3oool70?l000@0oooo0P3o00060?ooo`X0o`000`3oool20?l0
00D0oooo1`3o00040?ooo`80o`001@3oool70?l000@0oooo0P3o00050?ooo`80o`000`3oool30?l0
00<0oooo00<0o`000?ooo`3oool00`3oool20?l000H0oooo0P3o00020?ooo`H0o`000P3oool20?l0
00D0oooo0P3o00040?ooo`80o`001@3oool20?l000@0oooo0P3o00020?ooo`030?l0003oool0oooo
0080o`001@3oool20?l000@0oooo00<0o`000?ooo`3oool00`3oool20?l000D0oooo0P3o000L0?oo
o`D0003o4@3oool002P0oooo0P00000;0?ooo`800000C`3oool20?l001`0oooo0P3o000:0?ooo`<0
o`00103oool00`3o0000oooo0?ooo`020?ooo`80o`001P3oool20?l000/0oooo0P3o00040?ooo`<0
o`00103oool00`3o0000oooo0?ooo`020?ooo`80o`00103oool30?l000@0oooo00<0o`000?ooo`3o
ool00P3oool20?l000D0oooo0P3o00030?ooo`80o`00103oool20?l000@0oooo0P3o00050?ooo`80
o`001@3oool20?l000@0oooo0P3o00050?ooo`80o`00103oool20?l000@0oooo0P3o00050?ooo`80
o`001@3oool20?l000@0oooo0P3o00060?ooo`030?l0003oool0oooo0080oooo0P3o00050?ooo`80
o`007P3oool40000oa00oooo000X0?ooo`8000002`3oool200000500oooo0P3o000J0?ooo`80o`00
00<0oooo0?l0003oool01`3oool30?l000H0oooo00@0o`000?ooo`3oool0oooo0P3o00070?ooo`03
0?l0003oool0oooo00T0oooo0P3o00030?ooo`<0o`001P3oool0103o0000oooo0?ooo`3oool20?l0
00<0oooo0`3o00050?ooo`80o`000`3oool20?l000D0oooo0P3o00030?ooo`030?l0003oool0oooo
00<0oooo0P3o00040?ooo`80o`001@3oool20?l000D0oooo0P3o00040?ooo`80o`001@3oool20?l0
00@0oooo0P3o00030?ooo`80o`001P3oool20?l000D0oooo0P3o00030?ooo`<0o`001P3oool00`3o
0000oooo0?ooo`020?ooo`80o`001@3oool20?l00200oooo10000?l>0?ooo`00:03oool2000000/0
oooo0P00001A0?ooo`030?l0003oool0oooo01P0oooo0P3o00000`3oool0o`000?ooo`070?ooo`80
o`001`3oool0103o0000oooo0?ooo`3oool20?l000P0oooo1@3o00060?ooo`80o`000`3oool20?l0
00L0oooo00@0o`000?ooo`3oool0oooo0P3o00030?ooo`80o`001`3oool0103o0000oooo0?ooo`3o
ool20?l000D0oooo0P3o00080?ooo`<0o`00103oool20?l000D0oooo0P3o00050?ooo`80o`00103o
ool20?l000D0oooo0P3o00040?ooo`80o`000P3oool20?l000L0oooo0P3o00050?ooo`80o`000`3o
ool20?l000L0oooo0P3o00030?ooo`80o`001@3oool20?l00240oooo1@000?l<0?ooo`00:03oool2
000000/0oooo0P00001A0?ooo`80o`00603oool20?l00080oooo00<0o`000?ooo`3oool01P3oool2
0?l000/0oooo0P3o00070?ooo`80o`000`3oool20?l000D0oooo0P3o00030?ooo`80o`002`3oool2
0?l000<0oooo0P3o000;0?ooo`80o`001@3oool20?l000H0oooo103o00050?ooo`80o`001@3oool2
0?l000D0oooo0P3o00040?ooo`80o`001@3oool20?l000@0oooo0P3o00000`3oool0o`000?l00008
0?ooo`80o`001@3oool20?l000<0oooo0P3o00070?ooo`80o`000`3oool20?l000D0oooo0P3o000S
0?ooo`@0003o00<0o`000?ooo`3oool0203oool002P0oooo0P00000;0?ooo`@00000D03oool00`3o
0000oooo0?ooo`0F0?ooo`80o`000`3oool00`3o0000oooo0?ooo`050?ooo`80o`002`3oool20?l0
00H0oooo0P3o00050?ooo`80o`00103oool20?l000<0oooo0P3o000;0?ooo`80o`000`3oool20?l0
00/0oooo0P3o00050?ooo`80o`00103oool50?l000H0oooo0P3o00050?ooo`80o`001@3oool20?l0
00@0oooo0P3o00050?ooo`80o`00103oool40?l000T0oooo0P3o00050?ooo`80o`000`3oool20?l0
00L0oooo0P3o00030?ooo`80o`001@3oool20?l002D0oooo0P000?l00`3o0000003o0?ooo`080?oo
o`00:03oool2000000/0oooo0P00001B0?ooo`80o`005P3oool20?l000@0oooo00<0o`000?ooo`3o
ool01@3oool:0?l000<0oooo0P3o00060?ooo`80o`001@3oool20?l000@0oooo0P3o00030?ooo`X0
o`000`3oool20?l000<0oooo0P3o000;0?ooo`80o`001@3oool20?l000<0oooo0`3o00090?ooo`80
o`001@3oool20?l000D0oooo0P3o00040?ooo`80o`001@3oool20?l000@0oooo0P3o00000`3oool0
o`000?ooo`080?ooo`80o`001@3oool20?l000<0oooo0P3o00070?ooo`80o`000`3oool20?l000D0
oooo0P3o000V0?ooo`80o`002P3oool002P0oooo0P00000;0?ooo`800000D`3oool20?l001D0oooo
0P3o00040?ooo`030?l0003oool0oooo00D0oooo0P3o00050?ooo`<0o`000`3oool20?l000H0oooo
0P3o00050?ooo`80o`00103oool20?l000<0oooo0P3o00050?ooo`<0o`000`3oool20?l000<0oooo
0P3o00060?ooo`80o`000`3oool20?l000D0oooo0P3o00030?ooo`80o`00103oool00`3o0000oooo
0?ooo`030?ooo`80o`001@3oool20?l000D0oooo0P3o00040?ooo`80o`001@3oool20?l000@0oooo
0P3o00020?ooo`030?l0003oool0oooo00H0oooo0P3o00050?ooo`80o`00103oool00`3o0000oooo
0?ooo`040?ooo`<0o`000`3oool20?l000D0oooo0P3o000U0?ooo`80o`002`3oool002P0oooo0P00
000;0?ooo`800000E03oool00`3o0000oooo0?ooo`0C0?ooo`80o`001@3oool00`3o0000oooo0?oo
o`050?ooo`030?l0003oool0oooo00<0oooo0P3o00040?ooo`80o`001P3oool20?l000D0oooo0P3o
00040?ooo`80o`00103oool00`3o0000oooo0?ooo`030?ooo`80o`00103oool20?l000@0oooo0P3o
00040?ooo`<0o`000`3oool20?l000D0oooo0P3o00030?ooo`030?l0003oool0oooo0080oooo0P3o
00050?ooo`80o`001@3oool20?l000D0oooo0P3o00040?ooo`80o`001@3oool20?l000@0oooo0P3o
00030?ooo`030?l0003oool0oooo00D0oooo0P3o00050?ooo`80o`00103oool20?l000D0oooo0P3o
00040?ooo`80o`001@3oool20?l002D0oooo00<0o`000?ooo`3oool02P3oool002P0oooo0P00000;
0?ooo`800000E03oool20?l001<0oooo0P3o00060?ooo`030?l0003oool0oooo00H0oooo00@0o`00
0?ooo`3oool0oooo0`3o00020?ooo`H0o`0000<0oooo0?l0003o00000P3oool20?l000<0oooo1@3o
00020?ooo`80o`001@3oool0103o0000oooo0?ooo`3oool30?l00080oooo103o00050?ooo`80o`00
0`3oool20?l000@0oooo103o00020?ooo`80o`00103oool00`3o0000oooo0?ooo`020?ooo`80o`00
1@3oool20?l000D0oooo0P3o00050?ooo`80o`000P3oool60?l00080oooo0`3o00040?ooo`80o`00
103oool20?l000D0oooo0P3o00030?ooo`@0o`001@3oool00`3o0000oooo0?ooo`020?ooo`80o`00
0`3oool60?l00080oooo0`3o000T0?ooo`80o`00303oool002P0oooo0P00000;0?ooo`800000E@3o
ool20?l00180oooo0P3o00060?ooo`030?l0003oool0oooo00L0oooo1@3o00050?ooo`80o`000P3o
ool30?l000<0oooo1@3o00060?ooo`80o`001P3oool50?l000D0oooo0P3o00060?ooo`D0o`001@3o
ool20?l00080oooo103o00050?ooo`@0o`0000<0oooo0?l0003oool00P3oool;0?l000<0oooo103o
00040?ooo`80o`000P3oool40?l000D0oooo0P3o00030?ooo`d0o`000P3oool20?l000H0oooo1@3o
00060?ooo`80o`000P3oool40?l002@0oooo0P3o000=0?ooo`00:03oool2000000/0oooo0P00001F
0?ooo`80o`00403oool20?l000P0oooo00<0o`000?ooo`3oool09@3oool20?l00280oooo0P3o000F
0?ooo`80o`007`3oool20?l000/0oooo0P3o00130?ooo`80o`003P3oool002D0oooo1@00000;0?oo
o`800000E`3oool00`3o0000oooo0?ooo`0>0?ooo`80o`00203oool00`3o0000oooo0?ooo`0U0?oo
o`80o`008P3oool20?l001H0oooo0P3o000O0?ooo`80o`002`3oool20?l004<0oooo00<0o`000?oo
o`3oool03@3oool002L0oooo0`00000;0?ooo`<00000EP3oool20?l000h0oooo0P3o00090?ooo`03
0?l0003oool0oooo02D0oooo0P3o000R0?ooo`80o`005P3oool20?l001l0oooo0P3o000<0?ooo`03
0?l0003oool0oooo0400oooo0P3o000?0?ooo`00=@3oool2000005P0oooo0P3o000=0?ooo`<0o`00
203oool20?l002H0oooo0P3o000R0?ooo`80o`005`3oool00`3o0000oooo0?ooo`020?ooo`80o`00
6@3oool20?l000`0oooo00<0o`000?ooo`3oool0?`3oool20?l00100oooo000e0?ooo`800000F@3o
ool00`3o0000oooo0?ooo`090?ooo`H0o`001P3oool50?l00280oooo103o000@0?ooo`80o`003P3o
ool40?l001L0oooo0P3o00020?ooo`<0o`005`3oool40?l00180oooo0P3o000j0?ooo`030?l0003o
ool0oooo00l0oooo000e0?ooo`800000F@3oool20?l003l0oooo0P3o000@0?ooo`80o`00403oool2
0?l001T0oooo103o000J0?ooo`80o`004P3oool20?l003T0oooo0P3o000A0?ooo`00=@3oool20000
05X0oooo0P3o003Y0?ooo`80o`004P3oool003D0oooo0P00001K0?ooo`80o`00j03oool00`3o0000
oooo0?ooo`0A0?ooo`00=@3oool2000005`0oooo00<0o`000?ooo`3oool0i@3oool20?l001<0oooo
000e0?ooo`800000G03oool20?l00>D0oooo0P3o000D0?ooo`00=@3oool2000005d0oooo0P3o003S
0?ooo`80o`005@3oool003D0oooo0`00001M0?ooo`030?l0003oool0oooo0>40oooo00<0o`000?oo
o`3oool0503oool003D0oooo0P00001N0?ooo`80o`00h@3oool20?l001H0oooo000e0?ooo`800000
G`3oool20?l00=l0oooo0P3o000G0?ooo`00=@3oool200000600oooo0P3o003N0?ooo`030?l0003o
ool0oooo01H0oooo000e0?ooo`800000H@3oool00`3o0000oooo0?ooo`3K0?ooo`80o`00603oool0
03D0oooo0P00001Q0?ooo`80o`00f`3oool20?l001T0oooo000e0?ooo`800000HP3oool20?l00=T0
oooo0P3o000J0?ooo`00=@3oool2000006<0oooo0P3o003G0?ooo`80o`006`3oool003D0oooo0P00
001T0?ooo`030?l0003oool0oooo0=D0oooo00<0o`000?ooo`3oool06P3oool003D0oooo0`00001S
0?ooo`80o`00e@3oool20?l001`0oooo000e0?ooo`800000I@3oool20?l00=<0oooo0P3o000M0?oo
o`00=@3oool2000006H0oooo0P3o003A0?ooo`80o`007P3oool003D0oooo0P00001W0?ooo`80o`00
d03oool00`3o0000oooo0?ooo`0M0?ooo`00=@3oool2000006P0oooo00<0o`000?ooo`3oool0c@3o
ool20?l001l0oooo000e0?ooo`800000J03oool20?l00<d0oooo0P3o000P0?ooo`00=@3oool20000
06T0oooo0P3o003;0?ooo`80o`008@3oool003D0oooo0P00001Z0?ooo`80o`00b@3oool20?l00280
oooo000e0?ooo`<00000JP3oool00`3o0000oooo0?ooo`370?ooo`030?l0003oool0oooo0240oooo
00060?ooo`H000001@3oool2000000@0oooo2P0000040?ooo`D000002`3oool2000006/0oooo0P3o
00370?ooo`80o`008`3oool000P0oooo0P0000070?ooo`8000001@3oool9000000<0oooo0P000004
0?ooo`030000003oool0oooo00P0oooo0P00001/0?ooo`80o`00a@3oool20?l002@0oooo00080?oo
o`8000003`3oool00`000000oooo0?ooo`040?ooo`8000002@3oool00`000000oooo0?ooo`070?oo
o`800000K@3oool20?l00<<0oooo0P3o000U0?ooo`00203oool200000100oooo00<000000?ooo`3o
ool03`3oool00`000000oooo0?ooo`060?ooo`800000KP3oool20?l00<40oooo0P3o000V0?ooo`00
203oool200000140oooo00<000000?ooo`3oool03P3oool2000000L0oooo0P00001_0?ooo`80o`00
_`3oool30?l002H0oooo00080?ooo`8000004P3oool00`000000oooo0?ooo`0=0?ooo`8000001`3o
ool2000006l0oooo0`3o002m0?ooo`<0o`009`3oool000P0oooo0P00000C0?ooo`030000003oool0
oooo00`0oooo0P0000070?ooo`800000L03oool30?l00;/0oooo0`3o000X0?ooo`00203oool20000
01<0oooo00<000000?ooo`3oool0303oool2000000L0oooo0P00001a0?ooo`<0o`00^P3oool20?l0
02T0oooo00080?ooo`800000503oool00`000000oooo0?ooo`0:0?ooo`<000001`3oool400000700
oooo0`3o002h0?ooo`80o`00:P3oool000P0oooo0P00000E0?ooo`030000003oool0oooo00P0oooo
0`0000080?ooo`800000L`3oool30?l00;H0oooo0`3o000Z0?ooo`00203oool2000001D0oooo00<0
00000?ooo`3oool01P3oool4000000T0oooo0P00001d0?ooo`<0o`00]03oool30?l002/0oooo0008
0?ooo`8000005@3oool2000000@0oooo1P00000:0?ooo`800000M@3oool20?l00;<0oooo0`3o000/
0?ooo`00203oool2000000d0oooo00<000000?ooo`3oool01@3oool2000000D0oooo0`00000<0?oo
o`800000MP3oool20?l00;40oooo0`3o000]0?ooo`00203oool2000000d0oooo00<000000?ooo`3o
ool01@3oool2000000D0oooo00<000000?ooo`3oool0303oool2000007H0oooo0`3o002_0?ooo`<0
o`00;P3oool000P0oooo0P00000>0?ooo`030000003oool0oooo0080oooo100000060?ooo`030000
003oool0oooo00/0oooo0P00001g0?ooo`<0o`00[@3oool30?l002l0oooo00050?ooo`D000003P3o
ool8000000L0oooo1P0000080?ooo`800000N03oool30?l00:`0oooo0P3o000`0?ooo`001`3oool3
00000100oooo1000000:0?ooo`H000001`3oool3000007P0oooo0`3o002Z0?ooo`80o`00<@3oool0
03D0oooo0P00001j0?ooo`<0o`00Z03oool30?l00340oooo000e0?ooo`800000N`3oool30?l00:H0
oooo0`3o000b0?ooo`00=@3oool2000007`0oooo0`3o002T0?ooo`<0o`00<`3oool003D0oooo0P00
001m0?ooo`<0o`00XP3oool30?l003@0oooo000e0?ooo`800000OP3oool30?l00:00oooo0`3o000e
0?ooo`00=@3oool2000007l0oooo0`3o002N0?ooo`<0o`00=P3oool003D0oooo0P0000200?ooo`<0
o`00W03oool30?l003L0oooo000e0?ooo`800000P@3oool30?l009X0oooo0`3o000h0?ooo`00=@3o
ool300000840oooo103o002F0?ooo`@0o`00>@3oool003D0oooo0P0000230?ooo`@0o`00U03oool4
0?l003X0oooo000e0?ooo`800000Q@3oool30?l00980oooo0`3o000l0?ooo`00=@3oool2000008H0
oooo0`3o002@0?ooo`<0o`00?@3oool003D0oooo0P0000270?ooo`<0o`00SP3oool30?l003h0oooo
000e0?ooo`800000R03oool30?l008`0oooo0`3o000o0?ooo`00=@3oool2000008T0oooo0`3o002:
0?ooo`<0o`00@03oool003D0oooo0P00002:0?ooo`<0o`00R03oool30?l00440oooo000e0?ooo`<0
0000RP3oool40?l008@0oooo103o00120?ooo`00=@3oool2000008`0oooo103o00220?ooo`@0o`00
@`3oool003D0oooo0P00002>0?ooo`<0o`00O`3oool40?l004D0oooo000e0?ooo`800000S`3oool3
0?l007d0oooo103o00160?ooo`00=@3oool200000900oooo103o001j0?ooo`<0o`00B03oool003D0
oooo0P00002A0?ooo`@0o`00M`3oool40?l004T0oooo000e0?ooo`800000T`3oool30?l007D0oooo
103o001:0?ooo`00=@3oool2000009@0oooo0`3o001b0?ooo`@0o`00C03oool003D0oooo0P00002E
0?ooo`@0o`00K`3oool40?l004d0oooo000e0?ooo`<00000U@3oool40?l006`0oooo103o001?0?oo
o`004`3oool6000000D0oooo0P0000050?ooo`D000002`3oool2000009P0oooo103o001Y0?ooo`@0
o`00D03oool001D0oooo0P0000070?ooo`800000103oool2000000@0oooo00<000000?ooo`3oool0
203oool2000009T0oooo103o001V0?ooo`@0o`00DP3oool001D0oooo0P00000D0?ooo`030000003o
ool0oooo00L0oooo0P00002K0?ooo`@0o`00H`3oool40?l005<0oooo000E0?ooo`8000005@3oool0
0`000000oooo0?ooo`060?ooo`800000W03oool40?l00600oooo103o001E0?ooo`005@3oool20000
01D0oooo0P0000070?ooo`800000WP3oool40?l005d0oooo103o001F0?ooo`005@3oool2000001D0
oooo0P0000070?ooo`800000W`3oool50?l005T0oooo103o001H0?ooo`005@3oool2000001D0oooo
0P0000070?ooo`800000X@3oool40?l005L0oooo103o001I0?ooo`005@3oool2000001D0oooo0P00
00070?ooo`800000X`3oool40?l005<0oooo103o001K0?ooo`005@3oool2000001@0oooo0`000007
0?ooo`@00000XP3oool60?l004d0oooo1P3o001L0?ooo`005@3oool2000001<0oooo0`0000080?oo
o`800000YP3oool60?l004T0oooo1P3o001N0?ooo`005@3oool200000140oooo100000090?ooo`80
0000Z@3oool60?l004<0oooo1P3o001Q0?ooo`005@3oool2000000h0oooo1P00000:0?ooo`800000
Z`3oool60?l003l0oooo1P3o001S0?ooo`005@3oool2000000l0oooo0`00000<0?ooo`800000[P3o
ool50?l003X0oooo1P3o001V0?ooo`005@3oool2000000l0oooo00<000000?ooo`3oool0303oool2
00000;00oooo1@3o000f0?ooo`H0o`00J03oool001D0oooo0P00000@0?ooo`030000003oool0oooo
00/0oooo0P00002b0?ooo`H0o`00<03oool60?l006/0oooo000B0?ooo`D00000403oool6000000P0
oooo0P00002d0?ooo`L0o`00:@3oool70?l006h0oooo000D0?ooo`<000004@3oool6000000L0oooo
0`00002g0?ooo`X0o`007P3oool80?l00740oooo000e0?ooo`800000^`3oool;0?l001@0oooo2P3o
001e0?ooo`00=@3oool200000<80oooo7P3o001i0?ooo`00=@3oool200000<D0oooo5P3o001n0?oo
o`00=@3oool200000?l0ooooFP3oool003D0oooo0P00003o0?oooeX0oooo000e0?ooo`800000o`3o
oomJ0?ooo`00=@3oool200000?l0ooooFP3oool003D0oooo0P00003o0?oooeX0oooo000e0?ooo`<0
0000o`3ooomI0?ooo`00=@3oool200000?l0ooooFP3oool00?l0ooooT@3oool00?l0ooooT@3oool0
0?l0ooooT@3oool00001\
\>"],
  ImageRangeCache->{{{0, 399}, {319, 0}} -> {-0.161246, -0.230022, \
0.00298095, 0.00582218}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<G:\Robert\Vorlesungen\Variationsrechnung\Pr\[ADoubleDot]\
sentation\LoesungsVergleichsfunktion.png\>", loesungsVergleichsfunktion, \ 
      ImageSize \[Rule] 400]\)], "Input"],

Cell[BoxData[
    \("G:\\Robert\\Vorlesungen\\Variationsrechnung\\Pr\[ADoubleDot]sentation\\\
LoesungsVergleichsfunktion.png"\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(\(h[x_, e_] := f1[x] + e\ w[x]\)\(\[IndentingNewLine]\)
    \)\)], "Input"],

Cell[BoxData[
    \(\(\(J[
        e_] := \[Integral]\_0\%1 Sqrt[
            1 + \((1 + 
                    8\ e\ \((0.5 - 
                          x)\))\)^2] \[DifferentialD]x\)\(\[IndentingNewLine]\
\)
    \)\)], "Input"],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"funktionalAlsFunktion", "=", 
      RowBox[{"Plot", "[", 
        RowBox[{\(J[x]\), ",", \({x, \(-0.8\), \ 0.8}\), ",", 
          RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"{", 
              RowBox[{
                FormBox["Thickness",
                  "TraditionalForm"], "[", "0.006", "]"}], "}"}]}], ",", 
          RowBox[{"PlotStyle", "\[Rule]", " ", 
            RowBox[{"{", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{
                      StyleBox["RGBColor",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      RowBox[{
                        StyleBox["1",
                          "MR"], 
                        StyleBox[",",
                          "MR"], " ", "0", 
                        StyleBox[",",
                          "MR"], " ", "0"}], 
                      StyleBox["]",
                        "MR"]}], 
                    StyleBox[",",
                      "MR"], 
                    RowBox[{
                      FormBox["Thickness",
                        "TraditionalForm"], "[", "0.006", "]"}]}], 
                  StyleBox["}",
                    "MR"]}], 
                StyleBox[",",
                  "MR"], 
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{
                      StyleBox["RGBColor",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      RowBox[{
                        StyleBox["0",
                          "MR"], 
                        StyleBox[",",
                          "MR"], " ", "0", 
                        StyleBox[",",
                          "MR"], 
                        StyleBox["0",
                          "MR"]}], 
                      StyleBox["]",
                        "MR"]}], 
                    StyleBox[",",
                      "MR"], 
                    RowBox[{
                      FormBox["Thickness",
                        "TraditionalForm"], "[", "0.006", "]"}]}], 
                  StyleBox["}",
                    "MR"]}], 
                StyleBox[",",
                  "MR"], 
                StyleBox[
                  RowBox[{"{", 
                    RowBox[{\(RGBColor[0, 0, 1]\), ",", 
                      RowBox[{
                        FormBox["Thickness",
                          "TraditionalForm"], "[", "0.006", "]"}]}], "}"}],
                  "MR"], 
                StyleBox[",",
                  "MR"]}], "}"}]}], ",", " ", \(ImageSize \[Rule] 400\), ",", 
          " ", \(AspectRatio \[Rule] 0.8\), 
          ",", \(TextStyle \[Rule] {FontFamily \[Rule] "\<Times\>", 
              FontSize \[Rule] fontSize}\)}], "]"}]}]], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .8 
%%ImageSize: 400 320 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.595238 -1.51008 1.08126 [
[.05357 .63993 -33.9688 -31.75 ]
[.05357 .63993 33.9688 0 ]
[.20238 .63993 -27.4375 -31.75 ]
[.20238 .63993 27.4375 0 ]
[.35119 .63993 -33.9688 -31.75 ]
[.35119 .63993 33.9688 0 ]
[.64881 .63993 -24.8438 -31.75 ]
[.64881 .63993 24.8438 0 ]
[.79762 .63993 -18.3125 -31.75 ]
[.79762 .63993 18.3125 0 ]
[.94643 .63993 -24.8438 -31.75 ]
[.94643 .63993 24.8438 0 ]
[.4875 .00368 -36.625 -15.875 ]
[.4875 .00368 0 15.875 ]
[.4875 .1118 -36.625 -15.875 ]
[.4875 .1118 0 15.875 ]
[.4875 .21993 -36.625 -15.875 ]
[.4875 .21993 0 15.875 ]
[.4875 .32806 -36.625 -15.875 ]
[.4875 .32806 0 15.875 ]
[.4875 .43618 -36.625 -15.875 ]
[.4875 .43618 0 15.875 ]
[.4875 .54431 -36.625 -15.875 ]
[.4875 .54431 0 15.875 ]
[.4875 .76056 -36.625 -15.875 ]
[.4875 .76056 0 15.875 ]
[ -0.003 -0.003 0 0 ]
[ 1.003 .803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.05357 .65243 m
.05357 .65868 L
s
gsave
.05357 .63993 -94.9688 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.75) show
1.000 setlinewidth
grestore
.20238 .65243 m
.20238 .65868 L
s
gsave
.20238 .63993 -88.4375 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.35119 .65243 m
.35119 .65868 L
s
gsave
.35119 .63993 -94.9688 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.25) show
1.000 setlinewidth
grestore
.64881 .65243 m
.64881 .65868 L
s
gsave
.64881 .63993 -85.8438 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.25) show
1.000 setlinewidth
grestore
.79762 .65243 m
.79762 .65868 L
s
gsave
.79762 .63993 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.94643 .65243 m
.94643 .65868 L
s
gsave
.94643 .63993 -85.8438 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.75) show
1.000 setlinewidth
grestore
.125 Mabswid
.08333 .65243 m
.08333 .65618 L
s
.1131 .65243 m
.1131 .65618 L
s
.14286 .65243 m
.14286 .65618 L
s
.17262 .65243 m
.17262 .65618 L
s
.23214 .65243 m
.23214 .65618 L
s
.2619 .65243 m
.2619 .65618 L
s
.29167 .65243 m
.29167 .65618 L
s
.32143 .65243 m
.32143 .65618 L
s
.38095 .65243 m
.38095 .65618 L
s
.41071 .65243 m
.41071 .65618 L
s
.44048 .65243 m
.44048 .65618 L
s
.47024 .65243 m
.47024 .65618 L
s
.52976 .65243 m
.52976 .65618 L
s
.55952 .65243 m
.55952 .65618 L
s
.58929 .65243 m
.58929 .65618 L
s
.61905 .65243 m
.61905 .65618 L
s
.67857 .65243 m
.67857 .65618 L
s
.70833 .65243 m
.70833 .65618 L
s
.7381 .65243 m
.7381 .65618 L
s
.76786 .65243 m
.76786 .65618 L
s
.82738 .65243 m
.82738 .65618 L
s
.85714 .65243 m
.85714 .65618 L
s
.8869 .65243 m
.8869 .65618 L
s
.91667 .65243 m
.91667 .65618 L
s
.02381 .65243 m
.02381 .65618 L
s
.97619 .65243 m
.97619 .65618 L
s
.006 w
0 .65243 m
1 .65243 L
s
.25 Mabswid
.5 .00368 m
.50625 .00368 L
s
gsave
.4875 .00368 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.4) show
1.000 setlinewidth
grestore
.5 .1118 m
.50625 .1118 L
s
gsave
.4875 .1118 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.5) show
1.000 setlinewidth
grestore
.5 .21993 m
.50625 .21993 L
s
gsave
.4875 .21993 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.6) show
1.000 setlinewidth
grestore
.5 .32806 m
.50625 .32806 L
s
gsave
.4875 .32806 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.7) show
1.000 setlinewidth
grestore
.5 .43618 m
.50625 .43618 L
s
gsave
.4875 .43618 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.8) show
1.000 setlinewidth
grestore
.5 .54431 m
.50625 .54431 L
s
gsave
.4875 .54431 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.9) show
1.000 setlinewidth
grestore
.5 .76056 m
.50625 .76056 L
s
gsave
.4875 .76056 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.1) show
1.000 setlinewidth
grestore
.125 Mabswid
.5 .0253 m
.50375 .0253 L
s
.5 .04693 m
.50375 .04693 L
s
.5 .06855 m
.50375 .06855 L
s
.5 .09018 m
.50375 .09018 L
s
.5 .13343 m
.50375 .13343 L
s
.5 .15505 m
.50375 .15505 L
s
.5 .17668 m
.50375 .17668 L
s
.5 .19831 m
.50375 .19831 L
s
.5 .24156 m
.50375 .24156 L
s
.5 .26318 m
.50375 .26318 L
s
.5 .28481 m
.50375 .28481 L
s
.5 .30643 m
.50375 .30643 L
s
.5 .34968 m
.50375 .34968 L
s
.5 .37131 m
.50375 .37131 L
s
.5 .39293 m
.50375 .39293 L
s
.5 .41456 m
.50375 .41456 L
s
.5 .45781 m
.50375 .45781 L
s
.5 .47943 m
.50375 .47943 L
s
.5 .50106 m
.50375 .50106 L
s
.5 .52268 m
.50375 .52268 L
s
.5 .56593 m
.50375 .56593 L
s
.5 .58756 m
.50375 .58756 L
s
.5 .60918 m
.50375 .60918 L
s
.5 .63081 m
.50375 .63081 L
s
.5 .67406 m
.50375 .67406 L
s
.5 .69568 m
.50375 .69568 L
s
.5 .71731 m
.50375 .71731 L
s
.5 .73893 m
.50375 .73893 L
s
.5 .78218 m
.50375 .78218 L
s
.006 w
.5 0 m
.5 .8 L
s
0 0 m
1 0 L
1 .8 L
0 .8 L
closepath
clip
newpath
1 0 0 r
.02381 .78095 m
.06244 .67341 L
.10458 .56119 L
.14415 .46165 L
.18221 .37243 L
.22272 .28597 L
.26171 .21267 L
.30316 .14722 L
.34309 .0975 L
.3815 .06212 L
.40134 .04838 L
.42237 .03691 L
.4419 .02892 L
.45065 .02614 L
.4602 .02364 L
.46558 .02248 L
.47058 .02155 L
.47576 .02074 L
.48045 .02015 L
.48506 .01969 L
.48941 .01937 L
.49181 .01924 L
.49401 .01915 L
.49516 .01911 L
.49642 .01908 L
.49774 .01906 L
.49897 .01905 L
.50023 .01905 L
.50087 .01905 L
.50157 .01905 L
.50281 .01907 L
.50398 .01909 L
.50535 .01913 L
.5066 .01917 L
.50942 .0193 L
.51173 .01944 L
.51425 .01963 L
.51932 .02012 L
.52397 .02071 L
.52894 .02147 L
.53788 .02321 L
.54812 .02579 L
.55923 .02932 L
.57938 .03774 L
.59925 .04874 L
.6203 .06352 L
.65818 .09888 L
.69852 .14961 L
.73735 .21104 L
.77863 .28868 L
Mistroke
.81839 .37377 L
.85663 .46356 L
.89733 .56615 L
.93651 .67056 L
.97619 .78095 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{400, 320},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0001@2000`400?l00000o`00003oo`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00Z03oool6000000D0oooo0P00
000;0?ooo`800000cP3oool00:X0oooo0P0000070?ooo`8000002`3oool200000<h0oooo002Z0?oo
o`800000503oool200000<h0oooo002Z0?ooo`800000503oool200000<h0oooo002Z0?ooo`800000
3@3oool;00000<`0oooo002Z0?ooo`8000003@3oool00`000000oooo0?ooo`040?ooo`800000cP3o
ool00:X0oooo0P00000>0?ooo`030000003oool0oooo00<0oooo0P0000090?ooo`800000``3oool0
0:X0oooo0P00000?0?ooo`030000003oool0oooo0080oooo0P0000090?ooo`@00000`@3oool00:X0
oooo0P00000?0?ooo`030000003oool0oooo0080oooo0P0000090?ooo`800000``3oool00:X0oooo
0P00000@0?ooo`040000003oool0oooo0?ooo`8000002@3oool200000<<0oooo002Z0?ooo`800000
4@3oool00`000000oooo0?ooo`02000000T0oooo0P0000330?ooo`00ZP3oool200000140oooo00<0
00000?ooo`3oool00P0000090?ooo`800000``3oool00:X0oooo0P00000B0?ooo`040000003oool0
0000000000T0oooo0P0000330?ooo`00ZP3oool200000180oooo00@000000?ooo`00000000000P3o
ool@0?l00;`0oooo002Z0?ooo`8000004`3ooolL0?l00;D0oooo002W0?ooo`D000003@3oool<0?l0
00H0oooo0P0000060?ooo`/0o`00/P3oool00:T0oooo0`00000:0?ooo`X0o`000P0000090?ooo`<0
0000303oool80?l00:h0oooo002c0?ooo`L0o`004@3oool200000140oooo203o002Z0?ooo`00/@3o
ool60?l001@0oooo0P00000E0?ooo`H0o`00Z03oool00:h0oooo1P3o000G0?ooo`800000603oool6
0?l00:D0oooo002/0?ooo`H0o`006@3oool2000001X0oooo1P3o002S0?ooo`00ZP3oool50?l001`0
oooo0P00000M0?ooo`@0o`00XP3oool00:P0oooo1@3o000N0?ooo`8000007`3oool40?l00:00oooo
002V0?ooo`D0o`00803oool200000200oooo1@3o002N0?ooo`00Y@3oool40?l00280oooo0`00000Q
0?ooo`@0o`00W@3oool00:@0oooo0`3o000T0?ooo`800000903oool40?l009/0oooo002R0?ooo`@0
o`009@3oool2000002D0oooo103o002J0?ooo`00X@3oool40?l002H0oooo0P00000W0?ooo`<0o`00
V@3oool00:00oooo0`3o000X0?ooo`800000:03oool40?l009L0oooo002O0?ooo`<0o`00:@3oool2
000002T0oooo103o002F0?ooo`00WP3oool30?l002X0oooo0P00000[0?ooo`<0o`00U@3oool009d0
oooo0`3o000[0?ooo`800000;03oool30?l009@0oooo002L0?ooo`<0o`00;03oool3000002`0oooo
0`3o002C0?ooo`00VP3oool40?l002d0oooo0P00000^0?ooo`@0o`00T@3oool009T0oooo103o000^
0?ooo`800000;`3oool40?l00900oooo002H0?ooo`<0o`00<03oool200000340oooo0`3o002?0?oo
o`00U`3oool30?l00340oooo0P00000b0?ooo`<0o`00SP3oool009H0oooo0`3o000b0?ooo`800000
<`3oool30?l008d0oooo002E0?ooo`<0o`00<`3oool2000003@0oooo0`3o002<0?ooo`00T`3oool4
0?l003@0oooo0P00000e0?ooo`@0o`00RP3oool00980oooo103o000e0?ooo`<00000=@3oool40?l0
08T0oooo002A0?ooo`<0o`00503oool6000000D0oooo0P0000050?ooo`D00000303oool2000003P0
oooo0`3o00280?ooo`00T03oool30?l001L0oooo0P0000070?ooo`800000103oool2000000@0oooo
00<000000?ooo`3oool02@3oool2000003T0oooo0`3o00270?ooo`00S`3oool30?l001P0oooo0P00
000D0?ooo`030000003oool0oooo00P0oooo0P00000j0?ooo`80o`00Q`3oool008h0oooo0`3o000I
0?ooo`8000005@3oool00`000000oooo0?ooo`070?ooo`800000>`3oool20?l008H0oooo002>0?oo
o`80o`006P3oool2000001D0oooo0P0000080?ooo`800000?03oool20?l008D0oooo002=0?ooo`80
o`006`3oool2000001D0oooo0P0000080?ooo`800000?@3oool20?l008@0oooo002<0?ooo`<0o`00
6`3oool2000001D0oooo0P0000080?ooo`800000?P3oool00`3o0000oooo0?ooo`220?ooo`00R`3o
ool30?l001`0oooo0P00000E0?ooo`800000203oool4000003`0oooo0P3o00230?ooo`00RP3oool3
0?l001d0oooo0P00000D0?ooo`<00000203oool2000003l0oooo0P3o00220?ooo`00RP3oool20?l0
01h0oooo0P00000C0?ooo`<000002@3oool200000400oooo0P3o00210?ooo`00R@3oool20?l001l0
oooo0P00000A0?ooo`@000002P3oool200000440oooo00<0o`000?ooo`3oool0O`3oool008P0oooo
0`3o000O0?ooo`8000003P3oool6000000/0oooo0P0000110?ooo`80o`00P03oool008L0oooo0`3o
000P0?ooo`8000003`3oool3000000d0oooo0P0000120?ooo`80o`00O`3oool008L0oooo0P3o000Q
0?ooo`8000003`3oool00`000000oooo0?ooo`0=0?ooo`800000@`3oool20?l007h0oooo00260?oo
o`80o`008P3oool200000100oooo00<000000?ooo`3oool0303oool2000004@0oooo00<0o`000?oo
o`3oool0O03oool008D0oooo0`3o000O0?ooo`D00000403oool6000000T0oooo0P0000140?ooo`80
o`00O@3oool008@0oooo0`3o000R0?ooo`<000004@3oool6000000P0oooo0`0000140?ooo`80o`00
O03oool008<0oooo0`3o00150?ooo`800000AP3oool20?l007/0oooo00230?ooo`80o`00AP3oool2
000004L0oooo00<0o`000?ooo`3oool0N@3oool00880oooo0P3o00170?ooo`800000A`3oool20?l0
07X0oooo00210?ooo`<0o`00A`3oool2000004P0oooo0P3o001i0?ooo`00P@3oool20?l004P0oooo
0P0000190?ooo`80o`00N03oool00800oooo0P3o00190?ooo`800000BP3oool00`3o0000oooo0?oo
o`1f0?ooo`00O`3oool20?l004X0oooo0P00001:0?ooo`80o`00M`3oool007l0oooo00<0o`000?oo
o`3oool0B@3oool3000004X0oooo0P3o001f0?ooo`00OP3oool20?l004/0oooo0P00001<0?ooo`03
0?l0003oool0oooo07@0oooo001m0?ooo`80o`00C03oool2000004`0oooo0P3o001e0?ooo`00O@3o
ool00`3o0000oooo0?ooo`1;0?ooo`800000C@3oool20?l007@0oooo001l0?ooo`80o`00C@3oool2
000004h0oooo00<0o`000?ooo`3oool0LP3oool007`0oooo00<0o`000?ooo`3oool0C03oool20000
04h0oooo0P3o001c0?ooo`00N`3oool20?l004h0oooo0P00001?0?ooo`80o`00LP3oool007X0oooo
0P3o001?0?ooo`800000D03oool00`3o0000oooo0?ooo`1`0?ooo`00NP3oool00`3o0000oooo0?oo
o`1>0?ooo`<00000C`3oool20?l00740oooo001i0?ooo`80o`00D03oool200000540oooo00<0o`00
0?ooo`3oool0K`3oool007P0oooo0P3o001A0?ooo`800000D@3oool20?l00700oooo001h0?ooo`03
0?l0003oool0oooo0500oooo0P00001B0?ooo`80o`00K`3oool007L0oooo0P3o001B0?ooo`800000
D`3oool00`3o0000oooo0?ooo`1]0?ooo`00MP3oool20?l005<0oooo0P00001C0?ooo`80o`00KP3o
ool007H0oooo00<0o`000?ooo`3oool0DP3oool2000005@0oooo0P3o001]0?ooo`00M@3oool20?l0
05@0oooo0P00001E0?ooo`030?l0003oool0oooo06/0oooo001e0?ooo`030?l0003oool0oooo05<0
oooo0`00001D0?ooo`80o`00K03oool007@0oooo0P3o000b0?ooo`H000001@3oool2000000L0oooo
1@00000:0?ooo`800000EP3oool20?l006/0oooo001c0?ooo`80o`00=@3oool2000000L0oooo0P00
00060?ooo`8000000`3oool2000000T0oooo0P00001G0?ooo`030?l0003oool0oooo06T0oooo001c
0?ooo`030?l0003oool0oooo03@0oooo0P00000>0?ooo`8000001@3oool2000000P0oooo0P00001G
0?ooo`80o`00JP3oool00780oooo0P3o000f0?ooo`8000003P3oool2000000H0oooo00<000000?oo
o`3oool01P3oool2000005P0oooo0P3o001Y0?ooo`00L@3oool20?l003L0oooo0P00000=0?ooo`80
00001`3oool2000000L0oooo0P00001I0?ooo`030?l0003oool0oooo06L0oooo001a0?ooo`030?l0
003oool0oooo03H0oooo0P00000=0?ooo`8000001`3oool2000000L0oooo0P00001I0?ooo`80o`00
J03oool00700oooo0P3o000h0?ooo`8000003@3oool2000000L0oooo0P0000070?ooo`800000FP3o
ool00`3o0000oooo0?ooo`1V0?ooo`00L03oool00`3o0000oooo0?ooo`0g0?ooo`8000003@3oool2
000000L0oooo0P0000070?ooo`@00000F03oool20?l006L0oooo001_0?ooo`80o`00>@3oool20000
00d0oooo0P0000060?ooo`800000203oool2000005/0oooo00<0o`000?ooo`3oool0I@3oool006h0
oooo0P3o000j0?ooo`8000003@3oool4000000<0oooo0`0000080?ooo`800000F`3oool20?l006H0
oooo001^0?ooo`030?l0003oool0oooo03T0oooo0P00000>0?ooo`80000000<0oooo000000000000
0P00000:0?ooo`800000G03oool00`3o0000oooo0?ooo`1T0?ooo`00K@3oool20?l003/0oooo0P00
000>0?ooo`8000003`3oool2000005`0oooo0P3o001U0?ooo`00K@3oool00`3o0000oooo0?ooo`0j
0?ooo`8000003`3oool2000000h0oooo0P00001M0?ooo`030?l0003oool0oooo06<0oooo001/0?oo
o`80o`00?03oool200000100oooo0P00000=0?ooo`800000G@3oool20?l006@0oooo001/0?ooo`03
0?l0003oool0oooo03/0oooo0P00000A0?ooo`800000303oool2000005h0oooo00<0o`000?ooo`3o
ool0HP3oool006/0oooo0P3o000j0?ooo`D000004P3oool3000000X0oooo0P00001N0?ooo`80o`00
H`3oool006/0oooo00<0o`000?ooo`3oool0>`3oool3000001@0oooo100000070?ooo`<00000GP3o
ool00`3o0000oooo0?ooo`1Q0?ooo`00JP3oool20?l005l0oooo0P00001O0?ooo`80o`00HP3oool0
06T0oooo0P3o001P0?ooo`800000H03oool00`3o0000oooo0?ooo`1P0?ooo`00J@3oool00`3o0000
oooo0?ooo`1O0?ooo`800000H03oool20?l00640oooo001X0?ooo`80o`00H@3oool200000640oooo
0P3o001P0?ooo`00J03oool00`3o0000oooo0?ooo`1P0?ooo`800000HP3oool00`3o0000oooo0?oo
o`1N0?ooo`00I`3oool20?l00680oooo0P00001R0?ooo`80o`00G`3oool006L0oooo00<0o`000?oo
o`3oool0H@3oool2000006<0oooo00<0o`000?ooo`3oool0G@3oool006H0oooo0P3o001S0?ooo`<0
0000HP3oool20?l005h0oooo001V0?ooo`030?l0003oool0oooo0680oooo0P00001T0?ooo`030?l0
003oool0oooo05`0oooo001U0?ooo`80o`00I03oool2000006@0oooo0P3o001M0?ooo`00I03oool2
0?l006D0oooo0P00001U0?ooo`030?l0003oool0oooo05/0oooo001T0?ooo`030?l0003oool0oooo
06@0oooo0P00001U0?ooo`80o`00G03oool006<0oooo0P3o001V0?ooo`800000IP3oool00`3o0000
oooo0?ooo`1J0?ooo`00H`3oool00`3o0000oooo0?ooo`1U0?ooo`800000IP3oool20?l005/0oooo
001R0?ooo`80o`00I`3oool2000006L0oooo00<0o`000?ooo`3oool0F@3oool00680oooo00<0o`00
0?ooo`3oool0IP3oool3000006H0oooo0P3o001J0?ooo`00H@3oool20?l006P0oooo0P00001X0?oo
o`030?l0003oool0oooo05P0oooo001Q0?ooo`030?l0003oool0oooo06L0oooo0P00001X0?ooo`80
o`00F@3oool00600oooo0P3o001Y0?ooo`800000J@3oool00`3o0000oooo0?ooo`1G0?ooo`00H03o
ool00`3o0000oooo0?ooo`1X0?ooo`800000J@3oool20?l005P0oooo001O0?ooo`80o`00JP3oool2
000006X0oooo00<0o`000?ooo`3oool0EP3oool005l0oooo00<0o`000?ooo`3oool0J@3oool20000
06X0oooo00<0o`000?ooo`3oool0EP3oool005l0oooo00<0o`000?ooo`3oool0J@3oool2000006X0
oooo0P3o001G0?ooo`00GP3oool20?l006/0oooo0`00001Z0?ooo`030?l0003oool0oooo05D0oooo
001N0?ooo`030?l0003oool0oooo04L0oooo1P0000050?ooo`800000203oool00`000000oooo0?oo
o`0;0?ooo`800000J`3oool20?l005H0oooo001M0?ooo`80o`00B`3oool2000000L0oooo0P000008
0?ooo`800000303oool2000006`0oooo00<0o`000?ooo`3oool0E03oool005d0oooo00<0o`000?oo
o`3oool0BP3oool200000180oooo00<000000?ooo`3oool02P3oool2000006`0oooo0P3o001E0?oo
o`00G03oool20?l004`0oooo0P00000B0?ooo`030000003oool0oooo00X0oooo0P00001]0?ooo`03
0?l0003oool0oooo05<0oooo001L0?ooo`030?l0003oool0oooo04/0oooo0P00000B0?ooo`800000
2`3oool2000006d0oooo0P3o001D0?ooo`00F`3oool20?l004d0oooo0P00000C0?ooo`030000003o
ool0oooo00T0oooo0P00001^0?ooo`030?l0003oool0oooo0580oooo001K0?ooo`030?l0003oool0
oooo04`0oooo0P00000C0?ooo`030000003oool0oooo00T0oooo0P00001^0?ooo`80o`00D`3oool0
05X0oooo0P3o001>0?ooo`8000004`3oool2000000X0oooo1000001]0?ooo`030?l0003oool0oooo
0540oooo001J0?ooo`030?l0003oool0oooo04d0oooo0P00000D0?ooo`030000003oool0oooo00P0
oooo0P00001_0?ooo`030?l0003oool0oooo0540oooo001J0?ooo`030?l0003oool0oooo04d0oooo
0P00000D0?ooo`030000003oool0oooo00P0oooo0P00001_0?ooo`80o`00DP3oool005T0oooo0P3o
001?0?ooo`800000503oool2000000T0oooo0P00001`0?ooo`030?l0003oool0oooo0500oooo001I
0?ooo`030?l0003oool0oooo04h0oooo0P00000E0?ooo`030000003oool0oooo00L0oooo0P00001`
0?ooo`80o`00D@3oool005P0oooo0P3o001@0?ooo`8000005@3oool00`000000oooo0?ooo`070?oo
o`800000L@3oool00`3o0000oooo0?ooo`1?0?ooo`00F03oool00`3o0000oooo0?ooo`1?0?ooo`80
00003@3oool00`000000oooo0?ooo`050?ooo`800000203oool200000740oooo0P3o001@0?ooo`00
E`3oool20?l00540oooo0P00000>0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
1P3oool200000780oooo00<0o`000?ooo`3oool0CP3oool005L0oooo00<0o`000?ooo`3oool0C@3o
ool5000000h0oooo2@0000080?ooo`800000LP3oool20?l004l0oooo001F0?ooo`80o`00D@3oool3
000000l0oooo2@0000070?ooo`<00000LP3oool00`3o0000oooo0?ooo`1=0?ooo`00EP3oool00`3o
0000oooo0?ooo`1b0?ooo`800000L`3oool20?l004h0oooo001E0?ooo`80o`00M03oool2000007@0
oooo00<0o`000?ooo`3oool0C03oool005D0oooo00<0o`000?ooo`3oool0L`3oool2000007@0oooo
00<0o`000?ooo`3oool0C03oool005D0oooo00<0o`000?ooo`3oool0L`3oool2000007@0oooo0P3o
001=0?ooo`00E03oool20?l007D0oooo0P00001e0?ooo`030?l0003oool0oooo04/0oooo001D0?oo
o`030?l0003oool0oooo07@0oooo0P00001e0?ooo`80o`00C03oool005<0oooo0P3o001f0?ooo`80
0000MP3oool00`3o0000oooo0?ooo`1:0?ooo`00DP3oool20?l007L0oooo0`00001e0?ooo`80o`00
B`3oool00580oooo0P3o001g0?ooo`800000M`3oool00`3o0000oooo0?ooo`190?ooo`00D@3oool3
0?l007L0oooo0P00001g0?ooo`80o`00BP3oool00540oooo0P3o001h0?ooo`800000N03oool00`3o
0000oooo0?ooo`180?ooo`00D@3oool20?l007P0oooo0P00001h0?ooo`80o`00B@3oool00500oooo
0`3o001h0?ooo`800000N@3oool00`3o0000oooo0?ooo`170?ooo`00D03oool20?l007T0oooo0P00
001i0?ooo`030?l0003oool0oooo04L0oooo001?0?ooo`<0o`00N@3oool2000007T0oooo0P3o0018
0?ooo`00C`3oool20?l007X0oooo0`00001i0?ooo`030?l0003oool0oooo04H0oooo001?0?ooo`80
o`00NP3oool2000007X0oooo0P3o00170?ooo`00CP3oool30?l007X0oooo0P00001k0?ooo`030?l0
003oool0oooo04D0oooo001>0?ooo`80o`00N`3oool2000007/0oooo0P3o00160?ooo`00C@3oool3
0?l007/0oooo0P00001l0?ooo`030?l0003oool0oooo04@0oooo001=0?ooo`80o`00O03oool20000
07`0oooo0P3o00150?ooo`00C@3oool20?l007`0oooo0P00001m0?ooo`030?l0003oool0oooo04<0
oooo001<0?ooo`<0o`00O03oool2000007d0oooo00<0o`000?ooo`3oool0@`3oool004`0oooo0P3o
001m0?ooo`<00000O03oool20?l004@0oooo001;0?ooo`<0o`00FP3oool6000000D0oooo0P000007
0?ooo`D000002P3oool2000007h0oooo00<0o`000?ooo`3oool0@P3oool004/0oooo0P3o001M0?oo
o`8000001`3oool2000000D0oooo0`0000040?ooo`800000203oool2000007h0oooo0P3o00130?oo
o`00BP3oool30?l005d0oooo0P00000=0?ooo`<000001P3oool2000000L0oooo0P00001o0?ooo`03
0?l0003oool0oooo0440oooo001:0?ooo`80o`00GP3oool2000000d0oooo0P0000070?ooo`800000
1`3oool2000007l0oooo0P3o00120?ooo`00BP3oool20?l005h0oooo0P00000=0?ooo`8000001`3o
ool2000000L0oooo0P0000200?ooo`030?l0003oool0oooo0400oooo00190?ooo`<0o`00GP3oool2
000000d0oooo0P0000060?ooo`<000001`3oool200000800oooo00<0o`000?ooo`3oool0@03oool0
04T0oooo0P3o001O0?ooo`8000003P3oool2000000@0oooo0`0000080?ooo`800000P03oool20?l0
0440oooo00180?ooo`<0o`00G`3oool2000000l0oooo00@000000?ooo`3oool0oooo0`0000090?oo
o`@00000O`3oool00`3o0000oooo0?ooo`0o0?ooo`00B03oool20?l00600oooo0P00000@0?ooo`D0
00002P3oool200000840oooo0P3o00100?ooo`00B03oool20?l00600oooo0P00000@0?ooo`@00000
2`3oool200000880oooo00<0o`000?ooo`3oool0?P3oool004L0oooo0`3o001P0?ooo`8000003`3o
ool300000080oooo00<000000?ooo`3oool0203oool200000880oooo0P3o000o0?ooo`00A`3oool2
0?l00640oooo0P00000>0?ooo`<00000103oool2000000P0oooo0P0000230?ooo`030?l0003oool0
oooo03d0oooo00160?ooo`<0o`00H@3oool2000000d0oooo0`0000060?ooo`8000001`3oool20000
08<0oooo0P3o000n0?ooo`00AP3oool20?l00680oooo0P00000=0?ooo`8000001`3oool2000000L0
oooo0P0000240?ooo`030?l0003oool0oooo03`0oooo00160?ooo`80o`00HP3oool2000000d0oooo
0P0000070?ooo`8000001`3oool2000008@0oooo00<0o`000?ooo`3oool0?03oool004D0oooo0`3o
001O0?ooo`D000003P3oool2000000D0oooo0P0000080?ooo`800000Q03oool20?l003d0oooo0015
0?ooo`80o`00HP3oool300000100oooo1P0000090?ooo`<00000Q03oool00`3o0000oooo0?ooo`0k
0?ooo`00A03oool30?l008@0oooo0P0000250?ooo`80o`00?03oool004@0oooo0P3o00250?ooo`80
0000QP3oool00`3o0000oooo0?ooo`0j0?ooo`00A03oool20?l008D0oooo0P0000260?ooo`80o`00
>`3oool004<0oooo0`3o00250?ooo`800000QP3oool20?l003/0oooo00130?ooo`80o`00QP3oool2
000008H0oooo0`3o000j0?ooo`00@P3oool30?l008H0oooo0P0000270?ooo`80o`00>P3oool00480
oooo0P3o00270?ooo`800000Q`3oool20?l003X0oooo00120?ooo`80o`00Q`3oool3000008L0oooo
0P3o000i0?ooo`00@@3oool30?l008L0oooo0P0000280?ooo`80o`00>@3oool00440oooo0P3o0028
0?ooo`800000R03oool30?l003P0oooo00100?ooo`<0o`00R03oool2000008T0oooo0P3o000h0?oo
o`00@03oool20?l008T0oooo0P0000290?ooo`<0o`00=`3oool00400oooo0P3o00290?ooo`800000
RP3oool20?l003L0oooo000o0?ooo`<0o`00R@3oool2000008X0oooo0P3o000g0?ooo`00?`3oool2
0?l008X0oooo0P00002:0?ooo`<0o`00=P3oool003h0oooo0`3o002:0?ooo`<00000RP3oool20?l0
03H0oooo000n0?ooo`80o`00R`3oool2000008/0oooo0P3o000f0?ooo`00?P3oool20?l008/0oooo
0P00002;0?ooo`<0o`00=@3oool003d0oooo0`3o002;0?ooo`800000S03oool20?l003D0oooo000m
0?ooo`80o`00S03oool2000008`0oooo0`3o000d0?ooo`00?03oool30?l008`0oooo0P00002=0?oo
o`80o`00=03oool003`0oooo0P3o002=0?ooo`800000S@3oool20?l003@0oooo000l0?ooo`80o`00
S@3oool2000008d0oooo0`3o000c0?ooo`00>`3oool30?l008d0oooo0`00002=0?ooo`80o`00<`3o
ool003/0oooo0P3o001[0?ooo`H000001@3oool2000000@0oooo1000000>0?ooo`800000SP3oool3
0?l00380oooo000j0?ooo`<0o`00K@3oool2000000L0oooo0P0000070?ooo`<00000303oool20000
08l0oooo0P3o000b0?ooo`00>P3oool20?l006h0oooo0P00000B0?ooo`8000002`3oool2000008l0
oooo0P3o000b0?ooo`00>P3oool20?l006h0oooo0P00000C0?ooo`8000002P3oool2000008l0oooo
0`3o000a0?ooo`00>@3oool30?l006h0oooo0P00000D0?ooo`8000002@3oool200000900oooo0P3o
000a0?ooo`00>@3oool20?l006l0oooo0P00000E0?ooo`800000203oool200000900oooo0P3o000a
0?ooo`00>03oool30?l006l0oooo0P00000@0?ooo`D0000000<0oooo0000003oool01`3oool20000
0900oooo0`3o000`0?ooo`00>03oool20?l00700oooo0P00000>0?ooo`<00000103oool3000000L0
oooo1000002?0?ooo`80o`00<03oool003P0oooo0P3o001`0?ooo`8000003P3oool2000000H0oooo
0P0000070?ooo`800000T@3oool30?l002l0oooo000g0?ooo`<0o`00L03oool2000000d0oooo0P00
00070?ooo`8000001`3oool200000980oooo0P3o000_0?ooo`00=`3oool20?l00740oooo0P00000=
0?ooo`8000001`3oool2000000L0oooo0P00002B0?ooo`80o`00;`3oool003H0oooo0`3o001a0?oo
o`8000003@3oool2000000L0oooo0P0000070?ooo`800000TP3oool30?l002h0oooo000f0?ooo`80
o`00LP3oool2000000d0oooo0P0000070?ooo`8000001`3oool2000009<0oooo0P3o000^0?ooo`00
=P3oool20?l00780oooo0P00000=0?ooo`8000001P3oool2000000P0oooo0P00002C0?ooo`<0o`00
;@3oool003D0oooo0`3o001b0?ooo`8000003P3oool2000000D0oooo0P0000080?ooo`800000U03o
ool20?l002d0oooo000e0?ooo`80o`00L03oool5000000l0oooo0P0000030?ooo`8000002@3oool2
000009@0oooo0P3o000]0?ooo`00=@3oool20?l00780oooo0`00000@0?ooo`D000002P3oool30000
09<0oooo0`3o000/0?ooo`00=03oool30?l009@0oooo0P00002E0?ooo`80o`00;03oool003@0oooo
0P3o002E0?ooo`800000U@3oool20?l002`0oooo000c0?ooo`<0o`00U@3oool2000009D0oooo0`3o
000[0?ooo`006@3oool4000000L0oooo0P0000080?ooo`030000003oool0oooo0080oooo0P3o0003
0?ooo`D000006`3oool4000000L0oooo0P0000050?ooo`D000006P3oool4000000L0oooo0P000004
0?ooo`X00000103oool5000001h0oooo0P00000T0?ooo`@000001`3oool2000000@0oooo2P000004
0?ooo`D000006`3oool4000000L0oooo0P0000050?ooo`D000006`3oool010000000o`000?l00000
00070?ooo`800000203oool00`000000oooo0?ooo`070?ooo`D000002P3oool001P0oooo0P000003
0?ooo`8000001@3oool2000000P0oooo0P0000030?ooo`80o`000P3oool2000000@0oooo00<00000
0?ooo`3oool05`3oool2000000<0oooo0P0000050?ooo`800000103oool2000000@0oooo00<00000
0?ooo`3oool05P3oool2000000<0oooo0P0000050?ooo`8000001@3oool9000000<0oooo0P000004
0?ooo`030000003oool0oooo01/0oooo0P00000S0?ooo`8000000`3oool2000000D0oooo0P000005
0?ooo`T000000`3oool2000000@0oooo00<000000?ooo`3oool05`3oool2000000<0oooo0P000005
0?ooo`800000103oool2000000@0oooo00<000000?ooo`3oool05`3oool2000000<0o`000P000005
0?ooo`800000203oool2000000L0oooo0P0000040?ooo`030000003oool0oooo00L0oooo000H0?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`030?l0
00T0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
0100oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool0103oool2000000T0oooo00<000000?ooo`3oool06P3oool20000
02<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
00@0oooo0P0000090?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`0@0?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool00P3o00000`3o
ool000000?ooo`0?0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool01P3oool001L0
oooo0P0000050?ooo`8000003`3oool00`000000oooo0?ooo`020?l000/0oooo00<000000?ooo`3o
ool0503oool2000000D0oooo0P00000B0?ooo`030000003oool0oooo01<0oooo0P0000050?ooo`80
00003@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01T0oooo0P00000R0?ooo`80
00001@3oool2000000d0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0D0?ooo`80
00001@3oool200000180oooo00<000000?ooo`3oool0503oool200000080oooo0P3o00000`3oool0
00000000000?0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool01@3oool001L0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0=0?ooo`8000000`3o000;0?ooo`800000
5@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0100oooo0P00000D0?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0>0?ooo`800000
6P3oool300000240oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0<0?ooo`030000
003oool0oooo00h0oooo0P00000E0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
403oool2000001D0oooo00@000000?ooo`3oool0oooo0`3o00000`3oool000000?ooo`0>0?ooo`80
00003P3oool2000000H0oooo00040?ooo`d000001@3oool2000000L0oooo0P00000?0?ooo`030000
003o0000o`0000`0oooo0P0000020?ooo`d000001@3oool2000000L0oooo0P00000A0?ooo`800000
0P3oool=000000@0oooo0P0000070?ooo`8000003P3oool00`000000oooo0?ooo`0=0?ooo`800000
6P3oool200000240oooo0P0000070?ooo`8000003P3oool00`000000oooo0?ooo`0=0?ooo`800000
503oool2000000L0oooo0P00000A0?ooo`800000503oool2000000@0oooo0P3o00000`3oool00000
0000000?0?ooo`030000003oool0oooo00`0oooo0P0000060?ooo`00103oool=000000D0oooo0P00
00070?ooo`8000003`3oool00`000000o`000?l0000<0?ooo`8000000P3oool=000000D0oooo0P00
00070?ooo`8000004@3oool200000080oooo3@0000040?ooo`8000001`3oool2000000l0oooo00<0
00000?ooo`3oool0303oool2000001X0oooo0P00000Q0?ooo`8000001`3oool2000000l0oooo00<0
00000?ooo`3oool0303oool2000001@0oooo0P0000070?ooo`8000004@3oool2000001@0oooo0P00
00040?ooo`<0o`000P00000?0?ooo`030000003oool0oooo00`0oooo0P0000060?ooo`005P3oool2
000000L0oooo0P00000?0?ooo`<0o`00303oool2000001@0oooo0P0000070?ooo`8000004@3oool2
000001<0oooo0P0000070?ooo`8000003`3oool00`000000oooo0?ooo`0<0?ooo`8000006P3oool2
00000240oooo0P0000070?ooo`8000003`3oool00`000000oooo0?ooo`0<0?ooo`800000503oool2
000000L0oooo0P00000A0?ooo`800000503oool2000000D0oooo0P3o0002000000l0oooo0P00000=
0?ooo`8000001P3oool001H0oooo0P0000070?ooo`8000003`3oool20?l000`0oooo0`00000D0?oo
o`8000001`3oool200000100oooo0`00000C0?ooo`8000001`3oool200000100oooo00<000000?oo
o`3oool02P3oool3000001X0oooo0P00000Q0?ooo`8000001`3oool200000100oooo00<000000?oo
o`3oool02P3oool3000001@0oooo0P0000070?ooo`800000403oool3000001@0oooo0P0000050?oo
o`80o`000P00000@0?ooo`030000003oool0oooo00X0oooo0`0000060?ooo`005P3oool2000000L0
oooo0P00000?0?ooo`80o`002`3oool3000001D0oooo0P0000070?ooo`8000003`3oool3000001@0
oooo0P0000070?ooo`8000004@3oool00`000000oooo0?ooo`080?ooo`<000006`3oool200000240
oooo0P0000070?ooo`8000004@3oool00`000000oooo0?ooo`080?ooo`<000005@3oool2000000L0
oooo0P00000?0?ooo`<000005@3oool2000000D0oooo0`3o00000`000000oooo0?ooo`0>0?ooo`03
0000003oool0oooo00T0oooo0`0000070?ooo`005P3oool2000000L0oooo0P00000>0?ooo`<0o`00
00<000000?ooo`3oool01P3oool4000001H0oooo0P0000070?ooo`8000003@3oool4000001D0oooo
0P0000070?ooo`8000004@3oool00`000000oooo0?ooo`060?ooo`@00000703oool200000240oooo
0P0000070?ooo`8000004@3oool00`000000oooo0?ooo`060?ooo`@000005P3oool2000000L0oooo
0P00000=0?ooo`@000005P3oool2000000H0oooo0P3o00000`000000oooo0?ooo`0>0?ooo`800000
203oool4000000P0oooo000F0?ooo`8000001`3oool2000000h0oooo0P3o00000`3oool000000?oo
o`040?ooo`H000005`3oool2000000L0oooo0P00000:0?ooo`H000005P3oool2000000L0oooo0P00
000A0?ooo`800000103oool6000001d0oooo0P00000Q0?ooo`8000001`3oool200000140oooo0P00
00040?ooo`H000005`3oool2000000L0oooo0P00000:0?ooo`H000005`3oool2000000H0oooo0P3o
00000`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00<0oooo1P0000090?ooo`005`3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00`0oooo0`3o00000`3oool000000?ooo`05
0?ooo`<000006P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00X0oooo0`00000I
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`05
0?ooo`8000001@3oool3000001l0oooo0`00000Q0?ooo`030000003oool0oooo00D0oooo00<00000
0?ooo`3oool0203oool00`000000oooo0?ooo`050?ooo`8000001@3oool3000001X0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`0:0?ooo`<000006P3oool00`000000oooo0?ooo`04
0?ooo`<0o`004@3oool00`000000oooo0?ooo`040?ooo`<000002`3oool001L0oooo0P0000050?oo
o`8000002P3oool010000000oooo0?ooo`3oool20?l00080oooo0P0000050?ooo`030000003oool0
oooo01X0oooo0P0000050?ooo`800000303oool00`000000oooo0?ooo`0I0?ooo`8000001@3oool2
000000X0oooo00<000000?ooo`3oool01@3oool2000000D0oooo00<000000?ooo`3oool07`3oool2
00000280oooo0P0000050?ooo`8000002P3oool00`000000oooo0?ooo`050?ooo`8000001@3oool0
0`000000oooo0?ooo`0J0?ooo`8000001@3oool2000000`0oooo00<000000?ooo`3oool06P3oool2
000000D0oooo00<000000?l0003o00002@3oool00`000000oooo0?ooo`050?ooo`8000001@3oool0
0`000000oooo0?ooo`0;0?ooo`00603oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo
00X0oooo00<000000?ooo`3oool00P3o00030?ooo`030000003oool0oooo00@0oooo00<000000?oo
o`3oool06P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool06@3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00X0oooo00<000000?oo
o`3oool00P3oool4000000H0oooo00<000000?ooo`3oool07P3oool2000002<0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0080oooo100000060?oo
o`030000003oool0oooo01X0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0<0?oo
o`030000003oool0oooo01X0oooo00<000000?ooo`3oool00`3oool010000000o`000?l0003o0009
0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0:
0?ooo`00603oool2000000<0oooo0P00000<0?ooo`8000000`3o0004000000H0oooo1P00000G0?oo
o`8000000`3oool2000000h0oooo1P00000F0?ooo`8000000`3oool2000000`0oooo200000070?oo
o`H000006`3oool2000002<0oooo0P0000030?ooo`800000303oool8000000L0oooo1P00000G0?oo
o`8000000`3oool2000000h0oooo1P00000G0?ooo`8000000`3oool2000000030?ooo`3o0000o`00
00T0oooo2@0000060?ooo`H000001`3oool001X0oooo0`00000?0?ooo`030000003o0000o`0000H0
00001P3oool6000001P0oooo0`00000A0?ooo`H000005`3oool300000100oooo1000000:0?ooo`H0
00006P3oool2000002D0oooo0`00000@0?ooo`@000002P3oool6000001P0oooo0`00000A0?ooo`H0
0000603oool3000000<0oooo0P3o000:0?ooo`T000001P3oool6000000H0oooo000]0?ooo`80o`00
W03oool2000009`0oooo0`3o000T0?ooo`00;03oool30?l009`0oooo0P00002M0?ooo`80o`00903o
ool002`0oooo0P3o002M0?ooo`800000W@3oool30?l002<0oooo000[0?ooo`<0o`00W@3oool30000
09d0oooo0P3o000S0?ooo`00:`3oool20?l009h0oooo0P00002N0?ooo`80o`008`3oool002/0oooo
0P3o002N0?ooo`800000WP3oool30?l00280oooo000Z0?ooo`<0o`00WP3oool2000009l0oooo0P3o
000R0?ooo`00:P3oool20?l009l0oooo0P00002O0?ooo`80o`008P3oool002T0oooo0`3o002O0?oo
o`800000W`3oool30?l00240oooo000Y0?ooo`80o`00X03oool200000:00oooo0P3o000Q0?ooo`00
:@3oool20?l00:00oooo0P00002P0?ooo`<0o`00803oool000d0oooo6`0000030?l00?l00000A000
00020?l001X000001P3oool000d0oooo6`0000020?l00?l00000A@0000020?l001X000001P3oool0
01L0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`030?ooo`80o`00103oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`090?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0203oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00P0oooo0P00000:0?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00T0oooo00<000000?ooo`3oool0203oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo
00T0oooo00@000000?ooo`3oool0oooo0`3o00040?ooo`030000003oool0oooo00P0oooo00<00000
0?ooo`3oool03@3oool00280oooo00<000000?ooo`3oool00P3oool30?l00340oooo00<000000?oo
o`3oool0=@3oool00`000000oooo0?ooo`0e0?ooo`800000=`3oool00`000000oooo0?ooo`0e0?oo
o`030000003oool0oooo0300oooo0P3o00040?ooo`030000003oool0oooo01P0oooo000W0?ooo`80
o`00XP3oool200000:80oooo0`3o000N0?ooo`009P3oool30?l00:80oooo0P00002S0?ooo`80o`00
7P3oool002H0oooo0P3o002S0?ooo`800000X`3oool20?l001h0oooo000V0?ooo`80o`00X`3oool2
00000:<0oooo0`3o000M0?ooo`009@3oool30?l00:<0oooo0P00002T0?ooo`80o`007@3oool002D0
oooo0P3o002T0?ooo`<00000X`3oool20?l001d0oooo000U0?ooo`80o`00Y03oool200000:@0oooo
0`3o000L0?ooo`00903oool30?l00:@0oooo0P00002U0?ooo`80o`00703oool002@0oooo0P3o002U
0?ooo`800000Y@3oool20?l001`0oooo000S0?ooo`<0o`00Y@3oool200000:D0oooo0`3o000K0?oo
o`008`3oool20?l00:H0oooo0P00002V0?ooo`80o`006`3oool002<0oooo0P3o002V0?ooo`800000
YP3oool30?l001X0oooo000R0?ooo`<0o`00YP3oool200000:L0oooo0P3o000J0?ooo`008P3oool2
0?l00:L0oooo0`00002V0?ooo`80o`006P3oool00280oooo0P3o002W0?ooo`800000Y`3oool30?l0
01T0oooo000Q0?ooo`<0o`00Y`3oool200000:P0oooo0P3o000I0?ooo`008@3oool20?l00:P0oooo
0P00002X0?ooo`80o`006@3oool00240oooo0P3o002X0?ooo`800000Z03oool30?l001P0oooo000P
0?ooo`<0o`00Z03oool200000:T0oooo0P3o000H0?ooo`00803oool20?l00:T0oooo0P00002Y0?oo
o`80o`00603oool001l0oooo0`3o002Y0?ooo`800000Z@3oool30?l001L0oooo000O0?ooo`80o`00
ZP3oool300000:T0oooo0P3o000G0?ooo`007`3oool20?l00:X0oooo0P00002Z0?ooo`80o`005`3o
ool001h0oooo0`3o002Z0?ooo`800000ZP3oool30?l001H0oooo000N0?ooo`80o`00Z`3oool20000
0:/0oooo0P3o000F0?ooo`007P3oool20?l00:/0oooo0P00002[0?ooo`<0o`005@3oool001d0oooo
0`3o002[0?ooo`800000[03oool20?l001D0oooo000M0?ooo`80o`00[03oool200000:`0oooo0P3o
000E0?ooo`007@3oool20?l00:`0oooo0P00002/0?ooo`<0o`00503oool001`0oooo0`3o002/0?oo
o`<00000[03oool20?l001@0oooo000L0?ooo`80o`00Q`3oool:000000@0oooo0P0000070?ooo`H0
00002@3oool200000:d0oooo0P3o000D0?ooo`006`3oool30?l008P0oooo2@0000040?ooo`800000
2@3oool2000000/0oooo0P00002]0?ooo`<0o`004`3oool001/0oooo0P3o002:0?ooo`030000003o
ool0oooo00@0oooo0P00000>0?ooo`8000002`3oool200000:h0oooo0P3o000C0?ooo`006`3oool2
0?l008/0oooo00<000000?ooo`3oool04`3oool2000000/0oooo0P00002^0?ooo`80o`004`3oool0
01X0oooo0`3o002<0?ooo`030000003oool0oooo0180oooo0P00000;0?ooo`800000[P3oool30?l0
0180oooo000J0?ooo`80o`00SP3oool00`000000oooo0?ooo`0A0?ooo`8000002`3oool200000:l0
oooo0P3o000B0?ooo`006P3oool20?l008l0oooo00<000000?ooo`3oool0403oool2000000/0oooo
0P00002_0?ooo`80o`004P3oool001T0oooo0`3o002?0?ooo`030000003oool0oooo0100oooo0P00
000;0?ooo`@00000[@3oool30?l00140oooo000I0?ooo`80o`00T@3oool00`000000oooo0?ooo`0?
0?ooo`8000002`3oool200000;00oooo0P3o000A0?ooo`006@3oool20?l00980oooo00<000000?oo
o`3oool03P3oool2000000/0oooo0P00002`0?ooo`<0o`00403oool001P0oooo0`3o002B0?ooo`03
0000003oool0oooo00h0oooo0P00000;0?ooo`800000/@3oool20?l00100oooo000H0?ooo`80o`00
T`3oool2000000l0oooo0P00000;0?ooo`800000/@3oool20?l00100oooo000G0?ooo`<0o`00R`3o
ool00`000000oooo0?ooo`050?ooo`8000003`3oool2000000/0oooo0P00002a0?ooo`<0o`003`3o
ool001L0oooo0P3o002<0?ooo`030000003oool0oooo00D0oooo0P00000?0?ooo`8000002`3oool2
00000;80oooo0P3o000?0?ooo`005`3oool20?l008d0oooo00<000000?ooo`3oool00P3oool40000
00l0oooo0P00000;0?ooo`800000/P3oool20?l000l0oooo000F0?ooo`<0o`00S@3oool8000000d0
oooo1@00000;0?ooo`800000/P3oool30?l000h0oooo000G0?ooo`030?l0003oool0oooo08h0oooo
1000000A0?ooo`<000002`3oool300000;80oooo00<0o`000?ooo`3oool03@3oool00</0oooo0P00
00330?ooo`00b`3oool200000<<0oooo003;0?ooo`800000``3oool00</0oooo0P0000330?ooo`00
b`3oool200000<<0oooo003;0?ooo`800000``3oool00</0oooo0P0000330?ooo`00\
\>"],
  ImageRangeCache->{{{0, 399}, {319, 0}} -> {-0.904015, 1.36128, 0.00443009, \
0.00243878}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[""], "Input"],

Cell[BoxData[
    \(\(-0.9683594683536979`\) - 
      8.326672684688674`*^-17\ \[ImaginaryI]\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<G:\Robert\Vorlesungen\Variationsrechnung\Pr\[ADoubleDot]\
sentation\FunktionalAlsFunktion.png\>", funktionalAlsFunktion, \ 
      ImageSize \[Rule] 400]\)], "Input"],

Cell[BoxData[
    \("G:\\Robert\\Vorlesungen\\Variationsrechnung\\Pr\[ADoubleDot]sentation\\\
FunktionalAlsFunktion.png"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[{1, x, x^2, x^3}, {x, \ \(-1\)\ , 1}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.309017 0.294302 [
[.02381 .29652 -6 -9 ]
[.02381 .29652 6 0 ]
[.2619 .29652 -12 -9 ]
[.2619 .29652 12 0 ]
[.7381 .29652 -9 -9 ]
[.7381 .29652 9 0 ]
[.97619 .29652 -3 -9 ]
[.97619 .29652 3 0 ]
[.4875 .01472 -12 -4.5 ]
[.4875 .01472 0 4.5 ]
[.4875 .16187 -24 -4.5 ]
[.4875 .16187 0 4.5 ]
[.4875 .45617 -18 -4.5 ]
[.4875 .45617 0 4.5 ]
[.4875 .60332 -6 -4.5 ]
[.4875 .60332 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
[(-1)] .02381 .29652 0 1 Mshowa
.2619 .30902 m
.2619 .31527 L
s
[(-0.5)] .2619 .29652 0 1 Mshowa
.7381 .30902 m
.7381 .31527 L
s
[(0.5)] .7381 .29652 0 1 Mshowa
.97619 .30902 m
.97619 .31527 L
s
[(1)] .97619 .29652 0 1 Mshowa
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.25 Mabswid
0 .30902 m
1 .30902 L
s
.5 .01472 m
.50625 .01472 L
s
[(-1)] .4875 .01472 1 0 Mshowa
.5 .16187 m
.50625 .16187 L
s
[(-0.5)] .4875 .16187 1 0 Mshowa
.5 .45617 m
.50625 .45617 L
s
[(0.5)] .4875 .45617 1 0 Mshowa
.5 .60332 m
.50625 .60332 L
s
[(1)] .4875 .60332 1 0 Mshowa
.125 Mabswid
.5 .04415 m
.50375 .04415 L
s
.5 .07358 m
.50375 .07358 L
s
.5 .10301 m
.50375 .10301 L
s
.5 .13244 m
.50375 .13244 L
s
.5 .1913 m
.50375 .1913 L
s
.5 .22073 m
.50375 .22073 L
s
.5 .25016 m
.50375 .25016 L
s
.5 .27959 m
.50375 .27959 L
s
.5 .33845 m
.50375 .33845 L
s
.5 .36788 m
.50375 .36788 L
s
.5 .39731 m
.50375 .39731 L
s
.5 .42674 m
.50375 .42674 L
s
.5 .4856 m
.50375 .4856 L
s
.5 .51503 m
.50375 .51503 L
s
.5 .54446 m
.50375 .54446 L
s
.5 .57389 m
.50375 .57389 L
s
.25 Mabswid
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.02381 .60332 m
.06244 .60332 L
.10458 .60332 L
.14415 .60332 L
.18221 .60332 L
.22272 .60332 L
.26171 .60332 L
.30316 .60332 L
.34309 .60332 L
.3815 .60332 L
.42237 .60332 L
.46172 .60332 L
.49955 .60332 L
.53984 .60332 L
.57861 .60332 L
.61984 .60332 L
.65954 .60332 L
.69774 .60332 L
.73838 .60332 L
.77751 .60332 L
.81909 .60332 L
.85916 .60332 L
.89771 .60332 L
.93871 .60332 L
.97619 .60332 L
s
.02381 .01472 m
.06244 .03859 L
.10458 .06463 L
.14415 .08909 L
.18221 .11261 L
.22272 .13765 L
.26171 .16175 L
.30316 .18736 L
.34309 .21204 L
.3815 .23578 L
.42237 .26104 L
.46172 .28536 L
.49955 .30874 L
.53984 .33364 L
.57861 .3576 L
.61984 .38308 L
.65954 .40762 L
.69774 .43123 L
.73838 .45635 L
.77751 .48053 L
.81909 .50623 L
.85916 .53099 L
.89771 .55482 L
.93871 .58016 L
.97619 .60332 L
s
.02381 .60332 m
.06244 .5575 L
.10458 .51195 L
.14415 .47336 L
.18221 .44009 L
.22272 .40881 L
.26171 .38271 L
.30316 .35931 L
.34309 .34097 L
.3815 .32724 L
.40095 .32175 L
.42237 .31684 L
.44268 .31328 L
.45178 .31203 L
.46172 .31092 L
.4671 .31042 L
.4721 .31003 L
.47727 .30969 L
.48196 .30944 L
.48658 .30925 L
.4887 .30918 L
.49093 .30912 L
.49332 .30907 L
.49438 .30906 L
.49552 .30904 L
.49675 .30903 L
.49789 .30902 L
.49859 .30902 L
.49925 .30902 L
.50049 .30902 L
.50163 .30902 L
.50286 .30903 L
.50401 .30904 L
.50508 .30905 L
.50754 .30909 L
.51014 .30915 L
.51268 .30923 L
.51504 .30931 L
.5204 .30956 L
.5293 .31013 L
.53882 .31097 L
.54906 .31214 L
.56016 .31371 L
.58032 .31739 L
.60019 .32205 L
.62123 .32809 L
.65912 .34188 L
.69946 .36065 L
.73829 .38271 L
.77956 .41045 L
Mistroke
.81932 .44136 L
.85757 .47496 L
.89827 .51488 L
.93745 .55738 L
.97619 .60332 L
Mfstroke
.02381 .01472 m
.06244 .08069 L
.10458 .14051 L
.14415 .1862 L
.18221 .22154 L
.22272 .25091 L
.26171 .27214 L
.28158 .28062 L
.30316 .28823 L
.32216 .29369 L
.34309 .29849 L
.36292 .302 L
.38395 .30476 L
.40336 .30656 L
.41426 .3073 L
.42424 .30783 L
.43408 .30824 L
.44322 .30852 L
.45325 .30874 L
.45886 .30883 L
.46395 .30889 L
.46882 .30893 L
.47149 .30895 L
.47397 .30897 L
.47837 .30899 L
.4807 .309 L
.48319 .309 L
.48587 .30901 L
.48739 .30901 L
.48879 .30901 L
.49001 .30901 L
.49136 .30902 L
.49203 .30902 L
.49276 .30902 L
.49408 .30902 L
.49529 .30902 L
.49661 .30902 L
.49727 .30902 L
.49798 .30902 L
.49926 .30902 L
.50054 .30902 L
.50175 .30902 L
.50284 .30902 L
.50401 .30902 L
.50525 .30902 L
.50637 .30902 L
.50767 .30902 L
.5089 .30902 L
.51004 .30902 L
.51109 .30902 L
Mistroke
.51348 .30902 L
.51484 .30903 L
.51613 .30903 L
.51852 .30903 L
.5211 .30904 L
.52389 .30905 L
.52923 .30909 L
.53191 .30911 L
.53486 .30913 L
.54007 .30919 L
.54493 .30926 L
.54996 .30936 L
.55541 .30948 L
.56533 .30978 L
.57498 .31017 L
.58389 .31063 L
.6026 .31196 L
.61324 .31297 L
.62321 .31412 L
.64343 .31706 L
.66195 .32059 L
.68252 .32559 L
.70163 .33136 L
.73979 .3466 L
.77889 .36814 L
.82044 .39869 L
.86047 .43668 L
.89899 .48213 L
.93996 .54113 L
.97619 .60332 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{369.563, 228.25},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40005a0000i2000`400?l00000o`00003o^03oool0
0`000000oooo0?ooo`2f0?ooo`00^03oool00`000000oooo0?ooo`2f0?ooo`00^03oool00`000000
oooo0?ooo`2f0?ooo`00^03oool00`000000oooo0?ooo`2f0?ooo`00[P3oool5000000D0oooo00<0
00000?ooo`3oool0]P3oool00;00oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`2f
0?ooo`002@3oool00`000000oooo0?ooo`2T0?ooo`030000003oool0oooo00D0oooo0`00002f0?oo
o`002P3oool2000009`0oooo100000040?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool0]P3oool000X0oooo00@000000?ooo`0000000000XP3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo0;H0oooo000;0?ooo`030000003oool0oooo00800000W`3oool2000000L0oooo
00<000000?ooo`3oool0]P3oool000/0oooo00<000000?ooo`3oool00P3oool00`000000oooo0?oo
o`2U0?ooo`030000003oool0oooo0;H0oooo000<0?ooo`030000003oool0oooo0080oooo0P00002U
0?ooo`030000003oool0oooo0;H0oooo000<0?ooo`030000003oool0oooo00@0oooo0P00002S0?oo
o`030000003oool0oooo0;H0oooo000=0?ooo`030000003oool0oooo00D0oooo0P00002Q0?ooo`03
0000003oool0oooo0;H0oooo000>0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0
WP3oool00`000000oooo0?ooo`2f0?ooo`003P3oool00`000000oooo0?ooo`070?ooo`800000WP3o
ool00`000000oooo0?ooo`2f0?ooo`003`3oool00`000000oooo0?ooo`080?ooo`030000003oool0
oooo09/0oooo0P00002g0?ooo`003`3oool00`000000oooo0?ooo`090?ooo`800000V`3oool00`00
0000oooo0?ooo`2f0?ooo`00403oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo09P0
oooo00<000000?ooo`3oool0]P3oool00140oooo00<000000?ooo`3oool02P3oool2000009P0oooo
00<000000?ooo`3oool0]P3oool00140oooo00<000000?ooo`3oool0303oool00`000000oooo0?oo
o`2E0?ooo`030000003oool0oooo0;H0oooo000B0?ooo`030000003oool0oooo00`0oooo0P00002E
0?ooo`030000003oool0oooo0;H0oooo000B0?ooo`030000003oool0oooo00h0oooo00<000000?oo
o`3oool0TP3oool00`000000oooo0?ooo`2f0?ooo`004`3oool00`000000oooo0?ooo`0>0?ooo`80
0000TP3oool00`000000oooo0?ooo`2f0?ooo`004`3oool00`000000oooo0?ooo`0@0?ooo`030000
003oool0oooo08l0oooo00<000000?ooo`3oool0]P3oool001@0oooo00<000000?ooo`3oool0403o
ool2000008l0oooo00<000000?ooo`3oool0]P3oool001D0oooo00<000000?ooo`3oool04@3oool2
000008d0oooo00<000000?ooo`3oool0]P3oool001D0oooo00<000000?ooo`3oool04`3oool00`00
0000oooo0?ooo`2:0?ooo`800000]`3oool001H0oooo00<000000?ooo`3oool04`3oool2000008X0
oooo00<000000?ooo`3oool0]P3oool001H0oooo00<000000?ooo`3oool05@3oool2000008P0oooo
00<000000?ooo`3oool0]P3oool001L0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?oo
o`250?ooo`030000003oool0oooo0;H0oooo000H0?ooo`030000003oool0oooo01H0oooo0P000025
0?ooo`030000003oool0oooo0;H0oooo000H0?ooo`030000003oool0oooo01P0oooo0P0000230?oo
o`030000003oool0oooo0;H0oooo000I0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3o
ool0P03oool00`000000oooo0?ooo`2f0?ooo`006P3oool00`000000oooo0?ooo`0I0?ooo`800000
P03oool00`000000oooo0?ooo`2f0?ooo`006P3oool00`000000oooo0?ooo`0K0?ooo`030000003o
ool0oooo07d0oooo00<000000?ooo`3oool0]P3oool001/0oooo00<000000?ooo`3oool06`3oool2
000007d0oooo00<000000?ooo`3oool0]P3oool001`0oooo00<000000?ooo`3oool0703oool00`00
0000oooo0?ooo`1j0?ooo`030000003oool0oooo0;H0oooo000L0?ooo`030000003oool0oooo01d0
oooo0P00001j0?ooo`800000]`3oool001d0oooo00<000000?ooo`3oool07P3oool2000007P0oooo
00<000000?ooo`3oool0]P3oool001h0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?oo
o`1e0?ooo`030000003oool0oooo0;H0oooo000N0?ooo`030000003oool0oooo0200oooo0P00001e
0?ooo`030000003oool0oooo0;H0oooo000O0?ooo`030000003oool0oooo0240oooo00<000000?oo
o`3oool0LP3oool00`000000oooo0?ooo`2f0?ooo`00803oool00`000000oooo0?ooo`0Q0?ooo`80
0000LP3oool00`000000oooo0?ooo`2f0?ooo`008@3oool00`000000oooo0?ooo`0R0?ooo`800000
L03oool00`000000oooo0?ooo`2f0?ooo`008@3oool00`000000oooo0?ooo`0T0?ooo`030000003o
ool0oooo06d0oooo00<000000?ooo`3oool0]P3oool00280oooo00<000000?ooo`3oool0903oool2
000006d0oooo00<000000?ooo`3oool0]P3oool002<0oooo00<000000?ooo`3oool09@3oool20000
06/0oooo00<000000?ooo`3oool0]P3oool002<0oooo00<000000?ooo`3oool09`3oool00`000000
oooo0?ooo`1X0?ooo`030000003oool0oooo0;H0oooo000T0?ooo`030000003oool0oooo02L0oooo
0P00001X0?ooo`800000]`3oool002D0oooo00<000000?ooo`3oool0:03oool2000006H0oooo00<0
00000?ooo`3oool0]P3oool002D0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`1S
0?ooo`030000003oool0oooo0;H0oooo000V0?ooo`030000003oool0oooo02X0oooo0P00001S0?oo
o`030000003oool0oooo0;H0oooo000W0?ooo`030000003oool0oooo02/0oooo00<000000?ooo`3o
ool0H03oool00`000000oooo0?ooo`2f0?ooo`00:03oool00`000000oooo0?ooo`0[0?ooo`800000
H03oool00`000000oooo0?ooo`2f0?ooo`00:@3oool00`000000oooo0?ooo`0/0?ooo`030000003o
ool0oooo05d0oooo00<000000?ooo`3oool0]P3oool002X0oooo00<000000?ooo`3oool0;03oool2
000005d0oooo00<000000?ooo`3oool0]P3oool002X0oooo00<000000?ooo`3oool0;P3oool20000
05/0oooo00<000000?ooo`3oool0]P3oool002/0oooo00<000000?ooo`3oool0;`3oool00`000000
oooo0?ooo`130?ooo`800000103oool2000000@0oooo0P0000070?ooo`030000003oool0oooo0;H0
oooo000/0?ooo`030000003oool0oooo02l0oooo0P0000120?ooo`040000003oool0oooo000000P0
oooo00@000000?ooo`3oool000001P3oool00`000000oooo0?ooo`2f0?ooo`00;@3oool00`000000
oooo0?ooo`0`0?ooo`030000003oool0oooo03l0oooo00@000000?ooo`3oool000002`3oool00`00
0000oooo0?ooo`040?ooo`<00000]P3oool002h0oooo00<000000?ooo`3oool0<03oool2000003T0
oooo100000020?ooo`040000003oool0oooo000000T0oooo0P0000070?ooo`030000003oool0oooo
0;H0oooo000_0?ooo`030000003oool0oooo0340oooo0P00000m0?ooo`040000003oool0oooo0000
00T0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`2f0?ooo`00<03oool00`000000
oooo0?ooo`0b0?ooo`030000003oool0oooo03/0oooo0P00000:0?ooo`<000001P3oool00`000000
oooo0?ooo`2f0?ooo`00<@3oool00`000000oooo0?ooo`0b0?ooo`800000D03oool00`000000oooo
0?ooo`2f0?ooo`00<@3oool00`000000oooo0?ooo`0d0?ooo`800000CP3oool00`000000oooo0?oo
o`2f0?ooo`00<P3oool00`000000oooo0?ooo`0e0?ooo`030000003oool0oooo04/0oooo00<00000
0?ooo`3oool0]P3oool003<0oooo00<000000?ooo`3oool0=@3oool2000004/0oooo00<000000?oo
o`3oool0]P3oool003@0oooo00<000000?ooo`3oool0=P3oool2000004T0oooo00<000000?ooo`3o
ool0]P3oool003D0oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`160?ooo`030000
003oool0oooo0;H0oooo000f0?ooo`030000003oool0oooo03L0oooo0P0000160?ooo`030000003o
ool0oooo0;H0oooo000g0?ooo`030000003oool0oooo03P0oooo0P0000140?ooo`800000]`3oool0
03P0oooo00<000000?ooo`3oool0>@3oool00`000000oooo0?ooo`110?ooo`030000003oool0oooo
0;H0oooo000i0?ooo`030000003oool0oooo03T0oooo0P0000110?ooo`030000003oool0oooo0;H0
oooo000j0?ooo`030000003oool0oooo03X0oooo0P00000o0?ooo`030000003oool0oooo0;H0oooo
000k0?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3oool0?03oool00`000000oooo0?oo
o`2f0?ooo`00?03oool2000003`0oooo0P00000l0?ooo`030000003oool0oooo0;H0oooo000n0?oo
o`030000003oool0oooo03/0oooo0P00000j0?ooo`030000003oool0oooo0;H0oooo000o0?ooo`03
0000003oool0oooo03`0oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`2f0?ooo`00
@03oool00`000000oooo0?ooo`0l0?ooo`800000=`3oool00`000000oooo0?ooo`2f0?ooo`00@@3o
ool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo03@0oooo00<000000?ooo`3oool0]P3o
ool00480oooo00<000000?ooo`3oool0?@3oool2000003@0oooo0P00002g0?ooo`00@`3oool00`00
0000oooo0?ooo`0n0?ooo`030000003oool0oooo0340oooo00<000000?ooo`3oool0]P3oool004@0
oooo0P00000o0?ooo`800000<@3oool00`000000oooo0?ooo`2f0?ooo`00AP3oool00`000000oooo
0?ooo`0n0?ooo`800000;`3oool00`000000oooo0?ooo`2f0?ooo`00A`3oool00`000000oooo0?oo
o`0o0?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3oool0]P3oool004P0oooo0P000010
0?ooo`800000;03oool00`000000oooo0?ooo`2f0?ooo`00BP3oool00`000000oooo0?ooo`0o0?oo
o`030000003oool0oooo02T0oooo00<000000?ooo`3oool0]P3oool004/0oooo00<000000?ooo`3o
ool0?`3oool2000002T0oooo00<000000?ooo`3oool0]P3oool004`0oooo0P0000110?ooo`800000
9`3oool00`000000oooo0?ooo`2f0?ooo`00CP3oool00`000000oooo0?ooo`100?ooo`030000003o
ool0oooo02@0oooo00<000000?ooo`3oool0]P3oool004l0oooo00<000000?ooo`3oool0@03oool2
000002@0oooo00<000000?ooo`3oool0]P3oool00500oooo0P0000120?ooo`8000008P3oool20000
0;L0oooo001B0?ooo`030000003oool0oooo0440oooo00<000000?ooo`3oool07`3oool00`000000
oooo0?ooo`2f0?ooo`00D`3oool200000480oooo0P00000O0?ooo`030000003oool0oooo0;H0oooo
001E0?ooo`800000@P3oool2000001d0oooo00<000000?ooo`3oool0]P3oool005L0oooo0P000012
0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0]P3oool005T0oooo0P0000110?oo
o`8000006P3oool00`000000oooo0?ooo`2f0?ooo`00F`3oool200000440oooo0P00000H0?ooo`03
0000003oool0oooo0;H0oooo001M0?ooo`800000@@3oool00`000000oooo0?ooo`0E0?ooo`030000
003oool0oooo0;H0oooo001O0?ooo`<00000?`3oool2000001D0oooo00<000000?ooo`3oool0]P3o
ool000X0oooo1@00001=0?ooo`800000103oool2000000@0oooo0P00000i0?ooo`8000004`3oool0
0`000000oooo0?ooo`1=0?ooo`800000103oool2000000@0oooo0P00001?0?ooo`D000001`3oool0
00`0oooo00<000000?ooo`3oool0C03oool010000000oooo0?ooo`0000050?ooo`80000000D0oooo
0000003oool0oooo0000000j0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0C03o
ool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo00000500oooo00<000000?ooo`3o
ool01`3oool000`0oooo00<000000?ooo`3oool0C03oool010000000oooo0?ooo`0000070?ooo`<0
000000<0oooo0000003oool0>P3oool200000100oooo0P00001=0?ooo`040000003oool0oooo0000
00/0oooo00<000000?ooo`3oool0CP3oool00`000000oooo0?ooo`070?ooo`00103oool4000000@0
oooo00<000000?ooo`3oool0AP3oool400000080oooo00@000000?ooo`3oool000002@3oool30000
03d0oooo0P00000>0?ooo`030000003oool0oooo04`0oooo00@000000?ooo`3oool000002@3oool2
00000540oooo00<000000?ooo`3oool01`3oool000`0oooo00<000000?ooo`3oool0C03oool01000
0000oooo0?ooo`0000090?ooo`030000003oool0oooo00<00000?03oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo04`0oooo00@000000?ooo`3oool000002@3oool00`000000oooo0?oo
o`1@0?ooo`030000003oool0oooo00L0oooo000;0?ooo`800000C`3oool2000000X0oooo0`000003
0?ooo`<00000>P3oool2000000/0oooo00<000000?ooo`3oool0C@3oool2000000X0oooo0`00001?
0?ooo`8000002@3oool00740oooo1000000h0?ooo`030000003oool0oooo00P0oooo00<000000?oo
o`3oool0]P3oool007D0oooo0`00000f0?ooo`800000203oool00`000000oooo0?ooo`2f0?ooo`00
N03oool4000003@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`2f0?ooo`00O03o
ool6000002l0oooo0P0000050?ooo`030000003oool0oooo0;H0oooo00220?ooo`L00000:P3oool2
000000<0oooo00<000000?ooo`3oool0]P3oool008T0oooo2000000T0?ooo`040000003oool0oooo
00000;P0oooo002A0?ooo`d00000603oool300000;P0oooo003o00000780000000090?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00l0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0:0?ooo`X00000
303oool3000000X0oooo1`00000?0?ooo`P000002@3oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00l0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo00L0oooo00090?ooo`030000003oool0oooo05@0oooo00<000000?ooo`3oool0>`3o
ool4000001H0oooo00@000000?ooo`3oool00000403oool600000140oooo1P00000V0?ooo`030000
003oool0oooo05D0oooo00<000000?ooo`3oool01`3oool009X0oooo1000000J0?ooo`040000003o
ool0oooo0?ooo`800000503oool500000180oooo1`0000210?ooo`00UP3oool4000001h0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`0F0?ooo`@000005@3oool5000007`0oooo002B
0?ooo`@000008P3oool00`000000oooo0?ooo`040?ooo`8000006P3oool4000001H0oooo1000001h
0?ooo`00SP3oool4000002H0oooo00<000000?ooo`3oool01P3oool2000001`0oooo1000000F0?oo
o`@00000M03oool008/0oooo0`00000Z0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3o
ool07@3oool3000001L0oooo1000001`0?ooo`00R03oool3000002d0oooo00<000000?ooo`3oool0
2@3oool200000200oooo0`00000H0?ooo`<00000K@3oool008H0oooo0P00000`0?ooo`030000003o
ool0oooo00/0oooo00<000000?ooo`3oool0803oool2000001T0oooo0P00001[0?ooo`00P`3oool3
00000380oooo00<000000?ooo`3oool0303oool200000280oooo0`00000H0?ooo`800000J@3oool0
0800oooo0`00000e0?ooo`8000003`3oool2000002<0oooo0`00000G0?ooo`<00000IP3oool007d0
oooo0`00000h0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool08`3oool3000001L0
oooo0P00001T0?ooo`00N`3oool2000003/0oooo00<000000?ooo`3oool04@3oool2000002H0oooo
0P00000G0?ooo`800000HP3oool007P0oooo0`00000m0?ooo`030000003oool0oooo01<0oooo0P00
000V0?ooo`8000005`3oool200000600oooo001f0?ooo`800000@03oool00`000000oooo0?ooo`0E
0?ooo`030000003oool0oooo02D0oooo0P00000G0?ooo`800000GP3oool007<0oooo0`0000120?oo
o`030000003oool0oooo01H0oooo0P00000W0?ooo`8000005`3oool2000005`0oooo001a0?ooo`80
0000A@3oool00`000000oooo0?ooo`0H0?ooo`8000009`3oool2000001L0oooo0P00001J0?ooo`00
K`3oool2000004L0oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`0V0?ooo`800000
5`3oool00`000000oooo0?ooo`1G0?ooo`00K@3oool2000004T0oooo00<000000?ooo`3oool06`3o
ool2000002P0oooo0P00000F0?ooo`800000E`3oool006/0oooo0P00001;0?ooo`030000003oool0
oooo01d0oooo0P00000X0?ooo`8000005P3oool2000005D0oooo001Z0?ooo`030000003oool0oooo
04/0oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`0W0?ooo`8000005P3oool20000
05<0oooo001X0?ooo`800000CP3oool200000240oooo0P00000Y0?ooo`8000005P3oool00`000000
oooo0?ooo`1@0?ooo`00IP3oool200000500oooo00<000000?ooo`3oool08P3oool2000002T0oooo
00<000000?ooo`3oool0503oool200000500oooo001U0?ooo`030000003oool0oooo0500oooo00<0
00000?ooo`3oool0903oool00`000000oooo0?ooo`0W0?ooo`8000005P3oool00`000000oooo0?oo
o`1=0?ooo`00H`3oool2000005<0oooo00<000000?ooo`3oool09@3oool2000002T0oooo0P00000E
0?ooo`800000C@3oool00640oooo0P00001E0?ooo`030000003oool0oooo02L0oooo0P00000Y0?oo
o`8000005@3oool00`000000oooo0?ooo`1:0?ooo`00H03oool00`000000oooo0?ooo`1E0?ooo`03
0000003oool0oooo02T0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`0C0?ooo`03
0000003oool0oooo04T0oooo001N0?ooo`800000F03oool00`000000oooo0?ooo`0Z0?ooo`800000
:@3oool2000001@0oooo0P0000190?ooo`00G@3oool00`000000oooo0?ooo`1H0?ooo`030000003o
ool0oooo02`0oooo00<000000?ooo`3oool0:03oool00`000000oooo0?ooo`0C0?ooo`030000003o
ool0oooo04H0oooo001L0?ooo`030000003oool0oooo05T0oooo00<000000?ooo`3oool0;@3oool2
000002T0oooo0P00000D0?ooo`800000AP3oool005X0oooo0P00001L0?ooo`030000003oool0oooo
02l0oooo00<000000?ooo`3oool0:03oool2000001@0oooo00<000000?ooo`3oool0@`3oool005T0
oooo00<000000?ooo`3oool0G03oool200000340oooo0P00000Z0?ooo`030000003oool0oooo0180
oooo0P0000130?ooo`00E`3oool2000005l0oooo00<000000?ooo`3oool0<P3oool2000002T0oooo
0P00000D0?ooo`030000003oool0oooo0400oooo001F0?ooo`030000003oool0oooo05l0oooo00<0
00000?ooo`3oool0=03oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo0180oooo00<0
00000?ooo`3oool0?`3oool005D0oooo00<000000?ooo`3oool0H03oool00`000000oooo0?ooo`0e
0?ooo`800000:@3oool2000001<0oooo00<000000?ooo`3oool0?P3oool005<0oooo0P00001S0?oo
o`030000003oool0oooo03L0oooo00<000000?ooo`3oool0:03oool200000180oooo00<000000?oo
o`3oool0?@3oool00580oooo00<000000?ooo`3oool0H`3oool00`000000oooo0?ooo`0h0?ooo`80
0000:P3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo03`0oooo001@0?ooo`800000
IP3oool00`000000oooo0?ooo`0j0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`0k0?ooo`00C`3oool00`000000oooo0?ooo`1V0?ooo`030000003o
ool0oooo03/0oooo0P00000Y0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0>P3o
ool004h0oooo00<000000?ooo`3oool0I`3oool00`000000oooo0?ooo`0m0?ooo`030000003oool0
oooo02L0oooo0P00000A0?ooo`030000003oool0oooo03T0oooo001<0?ooo`800000JP3oool00`00
0000oooo0?ooo`0n0?ooo`800000:@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo
03P0oooo001;0?ooo`030000003oool0oooo06X0oooo00<000000?ooo`3oool0@03oool2000002P0
oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0g0?ooo`00BP3oool00`000000oooo
0?ooo`1[0?ooo`800000@`3oool00`000000oooo0?ooo`0V0?ooo`030000003oool0oooo00l0oooo
00<000000?ooo`3oool0=P3oool004P0oooo0P00001^0?ooo`030000003oool0oooo04<0oooo0P00
000W0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool0=@3oool004L0oooo00<00000
0?ooo`3oool0KP3oool00`000000oooo0?ooo`150?ooo`030000003oool0oooo02D0oooo00<00000
0?ooo`3oool03`3oool00`000000oooo0?ooo`0d0?ooo`00AP3oool00`000000oooo0?ooo`1_0?oo
o`030000003oool0oooo04H0oooo0P00000V0?ooo`800000403oool00`000000oooo0?ooo`0c0?oo
o`00A03oool200000780oooo00<000000?ooo`3oool0B03oool2000002H0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0b0?ooo`00@`3oool00`000000oooo0?ooo`1b0?ooo`030000
003oool0oooo04X0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo0340oooo00120?ooo`030000003oool0oooo07<0oooo00<000000?ooo`3oool0B`3o
ool2000002D0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0`0?ooo`00@@3oool0
0`000000oooo0?ooo`1d0?ooo`030000003oool0oooo04d0oooo0P00000T0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool0<03oool003l0oooo0P00001g0?ooo`030000003oool0oooo
04l0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
02l0oooo000n0?ooo`030000003oool0oooo0680oooo0P0000040?ooo`800000103oool2000000L0
oooo00<000000?ooo`3oool0D03oool2000002<0oooo0P00000>0?ooo`030000003oool0oooo02h0
oooo000m0?ooo`030000003oool0oooo0680oooo00@000000?ooo`3oool00000203oool010000000
oooo0?ooo`0000060?ooo`030000003oool0oooo0580oooo0P00000S0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool0;@3oool003`0oooo00<000000?ooo`3oool0H`3oool010000000
oooo0?ooo`00000;0?ooo`030000003oool0oooo00@0oooo0`00001D0?ooo`030000003oool0oooo
0240oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0/0?ooo`00>`3oool00`000000
oooo0?ooo`1T0?ooo`040000003oool0oooo000000T0oooo0P0000070?ooo`030000003oool0oooo
05D0oooo0P00000R0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0:`3oool003X0
oooo00<000000?ooo`3oool0I@3oool010000000oooo0?ooo`0000090?ooo`030000003oool0oooo
00H0oooo00<000000?ooo`3oool0E`3oool200000240oooo00<000000?ooo`3oool02`3oool00`00
0000oooo0?ooo`0[0?ooo`00>03oool2000006T0oooo0P00000:0?ooo`<000001P3oool00`000000
oooo0?ooo`1I0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool02`3oool00`000000
oooo0?ooo`0Z0?ooo`00=`3oool00`000000oooo0?ooo`1n0?ooo`030000003oool0oooo05X0oooo
0P00000P0?ooo`800000303oool00`000000oooo0?ooo`0Y0?ooo`00=P3oool00`000000oooo0?oo
o`1o0?ooo`030000003oool0oooo05`0oooo0P00000P0?ooo`030000003oool0oooo00X0oooo00<0
00000?ooo`3oool0:03oool003D0oooo00<000000?ooo`3oool0P03oool00`000000oooo0?ooo`1N
0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`0W
0?ooo`00=03oool00`000000oooo0?ooo`210?ooo`030000003oool0oooo05l0oooo0P00000O0?oo
o`030000003oool0oooo00X0oooo00<000000?ooo`3oool09P3oool003<0oooo00<000000?ooo`3o
ool0PP3oool00`000000oooo0?ooo`1Q0?ooo`8000007P3oool00`000000oooo0?ooo`090?ooo`03
0000003oool0oooo02H0oooo000b0?ooo`030000003oool0oooo08<0oooo00<000000?ooo`3oool0
H`3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
9@3oool00340oooo00<000000?ooo`3oool0Q03oool00`000000oooo0?ooo`1T0?ooo`8000007@3o
ool00`000000oooo0?ooo`090?ooo`030000003oool0oooo02@0oooo000`0?ooo`030000003oool0
oooo08D0oooo0P00001W0?ooo`800000703oool00`000000oooo0?ooo`090?ooo`030000003oool0
oooo02<0oooo000_0?ooo`030000003oool0oooo08H0oooo00<000000?ooo`3oool0J03oool00`00
0000oooo0?ooo`0J0?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool08P3oool002d0
oooo0P0000290?ooo`030000003oool0oooo06T0oooo0P00000K0?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool08P3oool002`0oooo00<000000?ooo`3oool0R@3oool00`000000oooo
0?ooo`1[0?ooo`8000006P3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0240oooo
000[0?ooo`030000003oool0oooo08X0oooo00<000000?ooo`3oool0K@3oool00`000000oooo0?oo
o`0H0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0803oool002X0oooo00<00000
0?ooo`3oool0R`3oool00`000000oooo0?ooo`1^0?ooo`8000006@3oool00`000000oooo0?ooo`08
0?ooo`030000003oool0oooo01l0oooo000Y0?ooo`030000003oool0oooo08`0oooo00<000000?oo
o`3oool0L03oool2000001P0oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0O0?oo
o`00:03oool00`000000oooo0?ooo`2=0?ooo`030000003oool0oooo0780oooo00<000000?ooo`3o
ool05P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01h0oooo000W0?ooo`030000
003oool0oooo08h0oooo00<000000?ooo`3oool0L`3oool2000001L0oooo00<000000?ooo`3oool0
1`3oool00`000000oooo0?ooo`0M0?ooo`009P3oool00`000000oooo0?ooo`2?0?ooo`030000003o
ool0oooo07D0oooo0P00000F0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool0703o
ool002D0oooo00<000000?ooo`3oool0T03oool00`000000oooo0?ooo`1g0?ooo`030000003oool0
oooo01@0oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0L0?ooo`00903oool00`00
0000oooo0?ooo`2A0?ooo`800000N@3oool2000001D0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0?ooo`0K0?ooo`008`3oool00`000000oooo0?ooo`2B0?ooo`030000003oool0oooo07X0
oooo0P00000D0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool06P3oool00280oooo
00<000000?ooo`3oool0T`3oool00`000000oooo0?ooo`1l0?ooo`030000003oool0oooo0180oooo
00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0I0?ooo`008P3oool00`000000oooo0?oo
o`2C0?ooo`030000003oool0oooo07d0oooo0P00000C0?ooo`030000003oool0oooo00D0oooo00<0
00000?ooo`3oool06@3oool00240oooo00<000000?ooo`3oool0U03oool00`000000oooo0?ooo`1o
0?ooo`8000004P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo01P0oooo000P0?oo
o`030000003oool0oooo09D0oooo00<000000?ooo`3oool0P@3oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool05`3oool001l0oooo00<000000?ooo`3o
ool0UP3oool00`000000oooo0?ooo`220?ooo`8000004@3oool00`000000oooo0?ooo`050?ooo`03
0000003oool0oooo01H0oooo000N0?ooo`030000003oool0oooo09L0oooo00<000000?ooo`3oool0
Q03oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool0
5P3oool001d0oooo00<000000?ooo`3oool0V03oool00`000000oooo0?ooo`250?ooo`800000403o
ool00`000000oooo0?ooo`040?ooo`030000003oool0oooo01D0oooo000L0?ooo`030000003oool0
oooo09T0oooo00<000000?ooo`3oool0Q`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool0503oool001/0oooo00<000000?ooo`3oool0VP3oool20000
08T0oooo0P00000?0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool04`3oool001/0
oooo00<000000?ooo`3oool0VP3oool00`000000oooo0?ooo`2:0?ooo`8000003P3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo01<0oooo000J0?ooo`030000003oool0oooo09/0oooo
00<000000?ooo`3oool0S03oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00<0oooo
00<000000?ooo`3oool04P3oool001T0oooo00<000000?ooo`3oool0W03oool00`000000oooo0?oo
o`2=0?ooo`8000003@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0180oooo000H
0?ooo`030000003oool0oooo09d0oooo00<000000?ooo`3oool0S`3oool00`000000oooo0?ooo`0;
0?ooo`030000003oool0oooo0080oooo00<000000?ooo`3oool04@3oool001L0oooo00<000000?oo
o`3oool0WP3oool00`000000oooo0?ooo`2@0?ooo`800000303oool01@000000oooo0?ooo`3oool0
000001<0oooo000F0?ooo`030000003oool0oooo09l0oooo00<000000?ooo`3oool0TP3oool00`00
0000oooo0?ooo`0:0?ooo`050000003oool0oooo0?ooo`0000004P3oool001D0oooo00<000000?oo
o`3oool0X03oool00`000000oooo0?ooo`2C0?ooo`8000002`3oool01@000000oooo0?ooo`3oool0
00000140oooo000E0?ooo`030000003oool0oooo0:00oooo00<000000?ooo`3oool0U@3oool00`00
0000oooo0?ooo`080?ooo`050000003oool0oooo0?ooo`0000004@3oool001@0oooo00<000000?oo
o`3oool0X@3oool00`000000oooo0?ooo`2F0?ooo`8000002@3oool01@000000oooo0?ooo`3oool0
00000100oooo000C0?ooo`030000003oool0oooo0:80oooo00<000000?ooo`3oool0V03oool00`00
0000oooo0?ooo`070?ooo`040000003oool0oooo00000100oooo000B0?ooo`030000003oool0oooo
0:<0oooo0P00002J0?ooo`800000203oool010000000oooo0?ooo`00000?0?ooo`004@3oool00`00
0000oooo0?ooo`2T0?ooo`030000003oool0oooo09/0oooo00<000000?ooo`3oool01P3oool00`00
0000oooo0000000?0?ooo`00403oool00`000000oooo0?ooo`2U0?ooo`030000003oool0oooo09`0
oooo0P0000070?ooo`030000003oool0000000h0oooo000@0?ooo`030000003oool0oooo0:D0oooo
00<000000?ooo`3oool0WP3oool00`000000oooo0?ooo`040?ooo`030000003oool0000000h0oooo
000?0?ooo`030000003oool0oooo0:H0oooo00<000000?ooo`3oool0W`3oool2000000D0oooo00<0
00000?ooo`0000003@3oool000h0oooo00<000000?ooo`3oool0Y`3oool00`000000oooo0?ooo`2Q
0?ooo`800000103oool00`000000oooo0000000<0?ooo`003@3oool00`000000oooo0?ooo`2X0?oo
o`030000003oool0oooo0:<0oooo0P0000030?ooo`800000303oool000`0oooo00<000000?ooo`3o
ool0Z@3oool00`000000oooo0?ooo`2U0?ooo`040000003oool0oooo0?ooo`8000002`3oool000/0
oooo00<000000?ooo`3oool0ZP3oool00`000000oooo0?ooo`2V0?ooo`8000000P3oool00`000000
oooo0?ooo`090?ooo`002`3oool00`000000oooo0?ooo`2P0?ooo`D000001@3oool00`000000oooo
0?ooo`2X0?ooo`@000002P3oool000X0oooo00<000000?ooo`3oool0X`3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo0:X0oooo0P00000:0?ooo`002@3ooooo0000060000002@3oool0
0;00oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`2f0?ooo`00/03oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo0;H0oooo002_0?ooo`8000001`3oool00`000000oooo
0?ooo`2f0?ooo`00^03oool00`000000oooo0?ooo`2f0?ooo`00^03oool00`000000oooo0?ooo`2f
0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 368.563}, {227.25, 0}} -> {-1.05247, -1.05001, \
0.00571122, 0.00924095}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{
      TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
        False,
        Editable->False], \(\(Plot\)\([\)\({Sin[x], Sin[2  x], 
          Sin[3  x]}, {x, 0, 2  \[Pi]}, 
        PlotStyle \[Rule] {RGBColor[1, 0, 0], RGBColor[0, 1, 0], 
            RGBColor[0, 0, 1]}\)\)}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"basis", "=", 
      RowBox[{"Plot", "[", 
        RowBox[{\({1, x, \ x^2, x^3}\), ",", \({x, \(-1\), 1}\), ",", 
          RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"{", 
              RowBox[{
                FormBox["Thickness",
                  "TraditionalForm"], "[", "0.006", "]"}], "}"}]}], ",", 
          RowBox[{"PlotStyle", "\[Rule]", " ", 
            RowBox[{"{", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{
                      StyleBox["RGBColor",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      RowBox[{
                        StyleBox["1",
                          "MR"], 
                        StyleBox[",",
                          "MR"], " ", "0", 
                        StyleBox[",",
                          "MR"], " ", "0"}], 
                      StyleBox["]",
                        "MR"]}], 
                    StyleBox[",",
                      "MR"], 
                    RowBox[{
                      FormBox["Thickness",
                        "TraditionalForm"], "[", "0.006", "]"}]}], 
                  StyleBox["}",
                    "MR"]}], 
                StyleBox[",",
                  "MR"], 
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{
                      StyleBox["RGBColor",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      RowBox[{
                        StyleBox["0",
                          "MR"], 
                        StyleBox[",",
                          "MR"], " ", "0", 
                        StyleBox[",",
                          "MR"], 
                        StyleBox["0",
                          "MR"]}], 
                      StyleBox["]",
                        "MR"]}], 
                    StyleBox[",",
                      "MR"], 
                    RowBox[{
                      FormBox["Thickness",
                        "TraditionalForm"], "[", "0.006", "]"}]}], 
                  StyleBox["}",
                    "MR"]}], 
                StyleBox[",",
                  "MR"], 
                StyleBox[
                  RowBox[{"{", 
                    RowBox[{\(RGBColor[0, 0, 1]\), ",", 
                      RowBox[{
                        FormBox["Thickness",
                          "TraditionalForm"], "[", "0.006", "]"}]}], "}"}],
                  "MR"], 
                StyleBox[",",
                  "MR"], 
                StyleBox[
                  RowBox[{"{", 
                    RowBox[{\(RGBColor[1, 1, 0]\), ",", 
                      RowBox[{
                        FormBox["Thickness",
                          "TraditionalForm"], "[", "0.006", "]"}]}], "}"}],
                  "MR"]}], "}"}]}], ",", " ", \(ImageSize \[Rule] 400\), ",", 
          " ", \(TextStyle \[Rule] {FontFamily \[Rule] "\<Times\>", 
              FontSize \[Rule] fontSize}\)}], "]"}]}]], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
%%ImageSize: 400 247.214 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.309017 0.294302 [
[.02381 .29652 -17.6563 -31.75 ]
[.02381 .29652 17.6563 0 ]
[.2619 .29652 -27.4375 -31.75 ]
[.2619 .29652 27.4375 0 ]
[.7381 .29652 -18.3125 -31.75 ]
[.7381 .29652 18.3125 0 ]
[.97619 .29652 -8.53125 -31.75 ]
[.97619 .29652 8.53125 0 ]
[.4875 .01472 -35.3125 -15.875 ]
[.4875 .01472 0 15.875 ]
[.4875 .16187 -54.875 -15.875 ]
[.4875 .16187 0 15.875 ]
[.4875 .45617 -36.625 -15.875 ]
[.4875 .45617 0 15.875 ]
[.4875 .60332 -17.0625 -15.875 ]
[.4875 .60332 0 15.875 ]
[ -0.003 -0.003 0 0 ]
[ 1.003 .62103 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30902 m
.02381 .31527 L
s
gsave
.02381 .29652 -78.6563 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.2619 .30902 m
.2619 .31527 L
s
gsave
.2619 .29652 -88.4375 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.7381 .30902 m
.7381 .31527 L
s
gsave
.7381 .29652 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.97619 .30902 m
.97619 .31527 L
s
gsave
.97619 .29652 -69.5313 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.125 Mabswid
.07143 .30902 m
.07143 .31277 L
s
.11905 .30902 m
.11905 .31277 L
s
.16667 .30902 m
.16667 .31277 L
s
.21429 .30902 m
.21429 .31277 L
s
.30952 .30902 m
.30952 .31277 L
s
.35714 .30902 m
.35714 .31277 L
s
.40476 .30902 m
.40476 .31277 L
s
.45238 .30902 m
.45238 .31277 L
s
.54762 .30902 m
.54762 .31277 L
s
.59524 .30902 m
.59524 .31277 L
s
.64286 .30902 m
.64286 .31277 L
s
.69048 .30902 m
.69048 .31277 L
s
.78571 .30902 m
.78571 .31277 L
s
.83333 .30902 m
.83333 .31277 L
s
.88095 .30902 m
.88095 .31277 L
s
.92857 .30902 m
.92857 .31277 L
s
.006 w
0 .30902 m
1 .30902 L
s
.25 Mabswid
.5 .01472 m
.50625 .01472 L
s
gsave
.4875 .01472 -96.3125 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.5 .16187 m
.50625 .16187 L
s
gsave
.4875 .16187 -115.875 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.5 .45617 m
.50625 .45617 L
s
gsave
.4875 .45617 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.5 .60332 m
.50625 .60332 L
s
gsave
.4875 .60332 -78.0625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.125 Mabswid
.5 .04415 m
.50375 .04415 L
s
.5 .07358 m
.50375 .07358 L
s
.5 .10301 m
.50375 .10301 L
s
.5 .13244 m
.50375 .13244 L
s
.5 .1913 m
.50375 .1913 L
s
.5 .22073 m
.50375 .22073 L
s
.5 .25016 m
.50375 .25016 L
s
.5 .27959 m
.50375 .27959 L
s
.5 .33845 m
.50375 .33845 L
s
.5 .36788 m
.50375 .36788 L
s
.5 .39731 m
.50375 .39731 L
s
.5 .42674 m
.50375 .42674 L
s
.5 .4856 m
.50375 .4856 L
s
.5 .51503 m
.50375 .51503 L
s
.5 .54446 m
.50375 .54446 L
s
.5 .57389 m
.50375 .57389 L
s
.006 w
.5 0 m
.5 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
1 0 0 r
.02381 .60332 m
.06244 .60332 L
.10458 .60332 L
.14415 .60332 L
.18221 .60332 L
.22272 .60332 L
.26171 .60332 L
.30316 .60332 L
.34309 .60332 L
.3815 .60332 L
.42237 .60332 L
.46172 .60332 L
.49955 .60332 L
.53984 .60332 L
.57861 .60332 L
.61984 .60332 L
.65954 .60332 L
.69774 .60332 L
.73838 .60332 L
.77751 .60332 L
.81909 .60332 L
.85916 .60332 L
.89771 .60332 L
.93871 .60332 L
.97619 .60332 L
s
0 0 0 r
.02381 .01472 m
.06244 .03859 L
.10458 .06463 L
.14415 .08909 L
.18221 .11261 L
.22272 .13765 L
.26171 .16175 L
.30316 .18736 L
.34309 .21204 L
.3815 .23578 L
.42237 .26104 L
.46172 .28536 L
.49955 .30874 L
.53984 .33364 L
.57861 .3576 L
.61984 .38308 L
.65954 .40762 L
.69774 .43123 L
.73838 .45635 L
.77751 .48053 L
.81909 .50623 L
.85916 .53099 L
.89771 .55482 L
.93871 .58016 L
.97619 .60332 L
s
0 0 1 r
.02381 .60332 m
.06244 .5575 L
.10458 .51195 L
.14415 .47336 L
.18221 .44009 L
.22272 .40881 L
.26171 .38271 L
.30316 .35931 L
.34309 .34097 L
.3815 .32724 L
.40095 .32175 L
.42237 .31684 L
.44268 .31328 L
.45178 .31203 L
.46172 .31092 L
.4671 .31042 L
.4721 .31003 L
.47727 .30969 L
.48196 .30944 L
.48658 .30925 L
.4887 .30918 L
.49093 .30912 L
.49332 .30907 L
.49438 .30906 L
.49552 .30904 L
.49675 .30903 L
.49789 .30902 L
.49859 .30902 L
.49925 .30902 L
.50049 .30902 L
.50163 .30902 L
.50286 .30903 L
.50401 .30904 L
.50508 .30905 L
.50754 .30909 L
.51014 .30915 L
.51268 .30923 L
.51504 .30931 L
.5204 .30956 L
.5293 .31013 L
.53882 .31097 L
.54906 .31214 L
.56016 .31371 L
.58032 .31739 L
.60019 .32205 L
.62123 .32809 L
.65912 .34188 L
.69946 .36065 L
.73829 .38271 L
.77956 .41045 L
Mistroke
.81932 .44136 L
.85757 .47496 L
.89827 .51488 L
.93745 .55738 L
.97619 .60332 L
Mfstroke
1 1 0 r
.02381 .01472 m
.06244 .08069 L
.10458 .14051 L
.14415 .1862 L
.18221 .22154 L
.22272 .25091 L
.26171 .27214 L
.28158 .28062 L
.30316 .28823 L
.32216 .29369 L
.34309 .29849 L
.36292 .302 L
.38395 .30476 L
.40336 .30656 L
.41426 .3073 L
.42424 .30783 L
.43408 .30824 L
.44322 .30852 L
.45325 .30874 L
.45886 .30883 L
.46395 .30889 L
.46882 .30893 L
.47149 .30895 L
.47397 .30897 L
.47837 .30899 L
.4807 .309 L
.48319 .309 L
.48587 .30901 L
.48739 .30901 L
.48879 .30901 L
.49001 .30901 L
.49136 .30902 L
.49203 .30902 L
.49276 .30902 L
.49408 .30902 L
.49529 .30902 L
.49661 .30902 L
.49727 .30902 L
.49798 .30902 L
.49926 .30902 L
.50054 .30902 L
.50175 .30902 L
.50284 .30902 L
.50401 .30902 L
.50525 .30902 L
.50637 .30902 L
.50767 .30902 L
.5089 .30902 L
.51004 .30902 L
.51109 .30902 L
Mistroke
.51348 .30902 L
.51484 .30903 L
.51613 .30903 L
.51852 .30903 L
.5211 .30904 L
.52389 .30905 L
.52923 .30909 L
.53191 .30911 L
.53486 .30913 L
.54007 .30919 L
.54493 .30926 L
.54996 .30936 L
.55541 .30948 L
.56533 .30978 L
.57498 .31017 L
.58389 .31063 L
.6026 .31196 L
.61324 .31297 L
.62321 .31412 L
.64343 .31706 L
.66195 .32059 L
.68252 .32559 L
.70163 .33136 L
.73979 .3466 L
.77889 .36814 L
.82044 .39869 L
.86047 .43668 L
.89899 .48213 L
.93996 .54113 L
.97619 .60332 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{400, 247.188},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0000mb000`400?l00000o`00003oo`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00^`3oool600000<l0oooo002m
0?ooo`800000d@3oool00;d0oooo0P00000;0?ooo`800000a03oool00;d0oooo0P00000;0?ooo`80
0000a03oool00;d0oooo0P00000;0?ooo`800000a03oool00:L0oooo3@0000090?ooo`8000002`3o
ool200000<@0oooo000M0?ooo`030?oo003oool0oooo08L0oooo3@0000090?ooo`8000002`3oool2
00000<@0oooo000L0?ooo`040000003oo`000000000009d0oooo0P00000;0?ooo`@00000`P3oool0
01d0oooo0P3oo`02000009`0oooo0P00000;0?ooo`800000a03oool001h0oooo0P3oo`03000009X0
oooo0P00000;0?ooo`800000a03oool001l0oooo00<0ool00000000000000`00002H0?ooo`800000
2`3oool200000<@0oooo000O0?ooo`80ool000<0oooo0000000000000P00002G0?ooo`8000002`3o
ool200000<@0oooo000P0?ooo`040?oo003oool0oooo0?ooo`@00000U@3oool2000000/0oooo0P00
00340?ooo`00803oool20?oo00<0oooo1@00002C0?ooo`8000002`3oool200000<@0oooo000Q0?oo
o`80ool0103oool400000980oooo0P00000;0?ooo`800000a03oool00280oooo00<0ool00?ooo`3o
ool0103oool4000008d0oooo1@00000;0?ooo`800000a03oool00280oooo0P3oo`060?ooo`D00000
S@3oool3000000/0oooo0P0000340?ooo`008`3oool20?oo00L0oooo1000002J0?ooo`800000a03o
ool002@0oooo00<0ool00?ooo`3oool01`3oool4000009P0oooo0`0000330?ooo`00903oool20?oo
00T0oooo1@00002F0?ooo`800000a03oool002D0oooo00<0ool00?ooo`3oool02@3oool4000009D0
oooo0P0000340?ooo`009@3oool20?oo00`0oooo1000002C0?ooo`800000a03oool002H0oooo0P3o
o`0<0?ooo`D00000T@3oool200000<@0oooo000W0?ooo`030?oo003oool0oooo00`0oooo1000002@
0?ooo`800000a03oool002L0oooo0P3oo`0?0?ooo`@00000SP3oool200000<@0oooo000X0?ooo`80
ool03`3oool5000008`0oooo0P0000340?ooo`00:@3oool00`3oo`00oooo0?ooo`0?0?ooo`@00000
R`3oool200000<@0oooo000Y0?ooo`80ool04P3oool4000008T0oooo0P0000340?ooo`00:P3oool0
0`3oo`00oooo0?ooo`0A0?ooo`@00000R03oool200000<@0oooo000Z0?ooo`80ool0503oool40000
08H0oooo0`0000330?ooo`00:`3oool20?oo01@0oooo100000250?ooo`800000a03oool002`0oooo
00<0ool00?ooo`3oool0503oool4000008<0oooo0P0000340?ooo`00;03oool20?oo01H0oooo1000
00220?ooo`800000a03oool002d0oooo0P3oo`0G0?ooo`@00000P03oool200000<@0oooo000^0?oo
o`030?oo003oool0oooo01H0oooo1@00001n0?ooo`800000a03oool002h0oooo0P3oo`0I0?ooo`@0
0000O@3oool200000<@0oooo000_0?ooo`80ool06P3oool4000007/0oooo0P0000340?ooo`00<03o
ool00`3oo`00oooo0?ooo`0I0?ooo`@00000NP3oool200000<@0oooo000`0?ooo`80ool0703oool4
000007P0oooo0P0000340?ooo`00<@3oool20?oo01`0oooo1000001g0?ooo`<00000``3oool00380
oooo00<0ool00?ooo`3oool0703oool4000007D0oooo0P0000340?ooo`00<P3oool20?oo01h0oooo
1000001d0?ooo`800000a03oool003<0oooo0P3oo`0O0?ooo`@00000LP3oool200000<@0oooo000d
0?ooo`80ool07`3oool500000700oooo0P0000340?ooo`00=@3oool00`3oo`00oooo0?ooo`0O0?oo
o`@00000K`3oool200000<@0oooo000e0?ooo`80ool08P3oool4000006d0oooo0P0000340?ooo`00
=P3oool20?oo0280oooo1@00001[0?ooo`800000a03oool003L0oooo00<0ool00?ooo`3oool08P3o
ool4000006X0oooo0P0000340?ooo`00=`3oool20?oo02D0oooo1000001X0?ooo`800000a03oool0
03P0oooo0P3oo`0U0?ooo`D00000IP3oool200000<@0oooo000i0?ooo`030?oo003oool0oooo02D0
oooo1000001U0?ooo`<00000``3oool003T0oooo0P3oo`0X0?ooo`@00000H`3oool200000<@0oooo
000j0?ooo`80ool0:03oool500000640oooo0P0000340?ooo`00>`3oool20?oo02T0oooo1000000n
0?ooo`@000001`3oool2000000D0oooo1@00000;0?ooo`800000a03oool003/0oooo0`3oo`0Z0?oo
o`@00000>`3oool2000000<0oooo0P0000050?ooo`800000103oool2000000@0oooo00<000000?oo
o`3oool0203oool200000<@0oooo000l0?ooo`80ool0:`3oool4000003X0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo00L0oooo0P0000340?ooo`00
?@3oool20?oo02`0oooo1000000g0?ooo`8000001@3oool200000180oooo00<000000?ooo`3oool0
1P3oool200000<@0oooo000m0?ooo`<0ool0;03oool4000003H0oooo00<000000?ooo`3oool01@3o
ool00`000000oooo0?ooo`0@0?ooo`8000001`3oool200000<@0oooo000n0?ooo`<0ool0;@3oool4
00000280oooo3@0000040?ooo`8000001`3oool200000140oooo0P0000070?ooo`800000a03oool0
03l0oooo0`3oo`0]0?ooo`@000008@3oool=000000@0oooo0P0000070?ooo`8000004@3oool20000
00L0oooo0P0000340?ooo`00@03oool30?oo02h0oooo1000000`0?ooo`8000001`3oool200000140
oooo0P0000070?ooo`800000a03oool00440oooo0P3oo`0_0?ooo`D00000;P3oool2000000L0oooo
0P00000@0?ooo`<000001`3oool400000<80oooo00120?ooo`80ool0<03oool4000002d0oooo0P00
00070?ooo`8000003`3oool3000000P0oooo0P0000340?ooo`00@P3oool30?oo0340oooo1000000[
0?ooo`8000001`3oool2000000d0oooo100000090?ooo`800000a03oool004<0oooo0`3oo`0a0?oo
o`D00000:@3oool2000000L0oooo0P00000:0?ooo`H000002P3oool200000<@0oooo00140?ooo`<0
ool0<P3oool4000002T0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0:0?ooo`<0
0000303oool200000<@0oooo00150?ooo`<0ool0<`3oool4000002L0oooo0P0000050?ooo`800000
303oool00`000000oooo0?ooo`0<0?ooo`800000a03oool004H0oooo0P3oo`0d0?ooo`D000009P3o
ool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3o
ool200000<@0oooo00170?ooo`80ool0=@3oool4000002D0oooo0P0000030?ooo`8000003P3oool6
000000P0oooo0P0000340?ooo`00A`3oool30?oo03H0oooo1000000U0?ooo`<000004@3oool60000
00L0oooo0P0000340?ooo`00B03oool30?oo03H0oooo1@0000140?ooo`800000a03oool004T0oooo
0`3oo`0g0?ooo`@00000@`3oool200000<@0oooo001:0?ooo`<0ool0>03oool400000440oooo0`00
00330?ooo`00B`3oool30?oo03P0oooo1@00000o0?ooo`800000a03oool004`0oooo0`3oo`0i0?oo
o`@00000?P3oool200000<@0oooo001=0?ooo`<0ool0>P3oool4000003`0oooo0P0000340?ooo`00
CP3oool40?oo03T0oooo1@00000j0?ooo`800000a03oool004l0oooo103oo`0j0?ooo`@00000>@3o
ool200000<@0oooo001A0?ooo`<0ool0>`3oool4000003L0oooo0P0000340?ooo`00DP3oool30?oo
03/0oooo1@00000e0?ooo`800000a03oool005<0oooo0`3oo`0l0?ooo`@00000=03oool200000<@0
oooo001D0?ooo`<0ool0?@3oool400000380oooo0P0000340?ooo`00E@3oool30?oo03d0oooo1000
000a0?ooo`<00000``3oool005H0oooo0`3oo`0n0?ooo`@00000;`3oool200000<@0oooo001G0?oo
o`@0ool0?@3oool4000002h0oooo0P0000340?ooo`00F03oool40?oo03h0oooo1000000/0?ooo`80
0000a03oool002@0oooo1P00000`0?ooo`@0ool04`3oool4000000L0oooo0P0000050?ooo`D00000
4`3oool4000002/0oooo0P0000190?ooo`@000001`3oool2000000D0oooo1@00001:0?ooo`H00000
503oool002H0oooo0P00000c0?ooo`@0ool04@3oool2000000<0oooo0P0000050?ooo`800000103o
ool2000000@0oooo00<000000?ooo`3oool04P3oool4000002T0oooo0P0000180?ooo`8000000`3o
ool2000000D0oooo0P0000040?ooo`800000103oool00`000000oooo0?ooo`190?ooo`8000005P3o
ool002H0oooo0P00000e0?ooo`@0ool03`3oool00`000000oooo0?ooo`030?ooo`030000003oool0
oooo0100oooo00<000000?ooo`3oool04P3oool5000002L0oooo0P0000180?ooo`030000003oool0
oooo00<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`180?ooo`8000005P3oool0
02H0oooo0P00000f0?ooo`@0ool03@3oool2000000D0oooo0P00000B0?ooo`030000003oool0oooo
01<0oooo1000000V0?ooo`800000A`3oool2000000D0oooo0P00000B0?ooo`030000003oool0oooo
04L0oooo0P00000F0?ooo`009P3oool2000003P0oooo103oo`0;0?ooo`030000003oool0oooo00D0
oooo00<000000?ooo`3oool0403oool2000001H0oooo1000000T0?ooo`800000A`3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo0100oooo0P0000180?ooo`8000005P3oool00100oooo
3@0000090?ooo`800000=@3oool4000000@0ool01@0000040?ooo`8000001`3oool200000140oooo
0P00000G0?ooo`D000008P3oool2000004H0oooo0P0000070?ooo`8000004@3oool2000004P0oooo
0P00000F0?ooo`00403oool=000000T0oooo0P00000e0?ooo`H00000103oo`03000000@0oooo0P00
00070?ooo`8000004@3oool2000001T0oooo1000000Q0?ooo`800000AP3oool2000000L0oooo0P00
000A0?ooo`800000B03oool2000001H0oooo000V0?ooo`800000?03oool50?oo00D0oooo0P000007
0?ooo`8000004@3oool2000001/0oooo1000000O0?ooo`<00000A@3oool2000000L0oooo0P00000A
0?ooo`800000B03oool2000001H0oooo000V0?ooo`800000?P3oool40?oo00@0oooo0P0000070?oo
o`800000403oool3000001`0oooo1@00000M0?ooo`800000AP3oool2000000L0oooo0P00000@0?oo
o`<00000B03oool2000001H0oooo000V0?ooo`800000@03oool40?oo0080oooo0P0000070?ooo`80
00003`3oool3000001l0oooo1000000L0?ooo`800000AP3oool2000000L0oooo0P00000?0?ooo`<0
0000B@3oool2000001H0oooo000V0?ooo`800000@@3oool50?oo008000001`3oool2000000d0oooo
1000000R0?ooo`@000006P3oool2000004H0oooo0P0000070?ooo`8000003@3oool4000004X0oooo
0P00000F0?ooo`009P3oool2000004<0oooo1@3oo`070?ooo`8000002P3oool6000002@0oooo1@00
000H0?ooo`800000AP3oool2000000L0oooo0P00000:0?ooo`H00000B`3oool2000001H0oooo000V
0?ooo`800000A@3oool40?oo00H0oooo00<000000?ooo`3oool02P3oool3000002P0oooo1000000G
0?ooo`800000A`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00X0oooo0`00001=
0?ooo`8000005P3oool002H0oooo0P0000170?ooo`@0ool00`3oool2000000`0oooo00<000000?oo
o`3oool0:P3oool4000001D0oooo0P0000170?ooo`8000001@3oool2000000`0oooo00<000000?oo
o`3oool0C@3oool2000001H0oooo000V0?ooo`800000B03oool50?oo00030?ooo`000000oooo00d0
oooo00<000000?ooo`3oool0:P3oool4000001@0oooo0P0000180?ooo`030000003oool0oooo00<0
oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`1<0?ooo`8000005P3oool002<0oooo
1@0000180?ooo`8000001@3oo`0>0?ooo`H00000:@3oool400000180oooo0P0000180?ooo`800000
0`3oool2000000h0oooo1P0000160?ooo`D000005P3oool002D0oooo0`00001:0?ooo`8000001P3o
o`0<0?ooo`H00000:@3oool400000140oooo0P00001:0?ooo`<000004@3oool6000004L0oooo0`00
000F0?ooo`00MP3oool60?oo03/0oooo1000000?0?ooo`800000a03oool007T0oooo1P3oo`0i0?oo
o`@000003P3oool300000<<0oooo001k0?ooo`H0ool0>@3oool4000000`0oooo0P0000340?ooo`00
OP3oool60?oo03L0oooo1@00000:0?ooo`800000a03oool00800oooo1`3oo`0f0?ooo`@000002@3o
ool200000<@0oooo00230?ooo`L0ool0=@3oool4000000L0oooo0P0000340?ooo`00Q`3oool70?oo
0380oooo1@0000050?ooo`800000a03oool008X0oooo203oo`0`0?ooo`D000000`3oool200000<@0
oooo002>0?ooo`/0ool0:`3oool400000080oooo0P0000340?ooo`00TP3oool?0?oo02D0oooo1P00
00340?ooo`00V@3oool?0?oo01l0oooo1@0000340?ooo`00503ooon=000003d0ool0Y000000>0?oo
o`00503ooonD000004`0ool0SP00000>0?ooo`007@3oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`0>0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool0103ooolF0000o`D0oooo0P0000000`3oool00000
0000000>0000ob80ool000<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0?0?ooo`030000
003oool0oooo00h0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0E0?ooo`007@3o
ool00`000000oooo0?ooo`1D0?ooo`030000003oool0oooo03@0oooo3P000?lA0?ooo`8000000P3o
ool4000000/0oooo3`000?l80?ooo`l0ool07`3oool00`000000oooo0?ooo`1C0?ooo`030000003o
ool0oooo01D0oooo002W0?ooo`P0003o6`3oool2000000@0oooo1000000D0?ooo`L0003o403oool7
0?oo08X0oooo002T0?ooo`L0003o7`3oool2000000D0oooo1000000G0?ooo`L0003o403oool:0?oo
08<0oooo002P0?ooo`L0003o8`3oool2000000L0oooo1000000H0?ooo`P0003o3`3oool:0?oo0800
oooo002M0?ooo`L0003o9P3oool2000000P0oooo1000000K0?ooo`P0003o4P3oool60?oo07d0oooo
002J0?ooo`L0003o:@3oool2000000X0oooo1000000M0?ooo`L0003o4@3oool60?oo07/0oooo002H
0?ooo`H0003o;03oool2000000/0oooo1@00000N0?ooo`H0003o4P3oool60?oo07P0oooo002E0?oo
o`H0003o;`3oool2000000d0oooo1000000P0?ooo`H0003o4@3oool70?oo07D0oooo002B0?ooo`L0
003o<@3oool3000000h0oooo1000000P0?ooo`L0003o4@3oool60?oo07<0oooo002@0?ooo`H0003o
=03oool200000100oooo1@00000Q0?ooo`H0003o4P3oool60?oo0700oooo002>0?ooo`D0003o=`3o
ool200000180oooo1000000S0?ooo`D0003o4P3oool70?oo06d0oooo002<0?ooo`D0003o>@3oool2
000001@0oooo1000000S0?ooo`D0003o4`3oool60?oo06/0oooo00290?ooo`H0003o>`3oool20000
01D0oooo1@00000S0?ooo`H0003o4`3oool50?oo06T0oooo00270?ooo`H0003o?@3oool2000001L0
oooo1000000T0?ooo`H0003o4`3oool50?oo06L0oooo00250?ooo`D0003o@03oool2000001T0oooo
1000000U0?ooo`D0003o4`3oool40?oo06H0oooo00230?ooo`D0003o@P3oool2000001X0oooo1@00
000U0?ooo`D0003o4`3oool40?oo06@0oooo00210?ooo`D0003oA03oool2000001`0oooo1000000V
0?ooo`D0003o4P3oool50?oo0680oooo001o0?ooo`D0003oAP3oool2000001h0oooo1000000V0?oo
o`@0003o4`3oool50?oo0600oooo001m0?ooo`D0003oB03oool2000001l0oooo1@00000V0?ooo`@0
003o4`3oool50?oo05h0oooo001k0?ooo`D0003oBP3oool300000200oooo1000000V0?ooo`D0003o
4`3oool40?oo05d0oooo001j0?ooo`@0003oC03oool2000002<0oooo1000000V0?ooo`D0003o4`3o
ool40?oo05/0oooo001h0?ooo`@0003oCP3oool2000002@0oooo1@00000V0?ooo`@0003o4`3oool4
0?oo05X0oooo001f0?ooo`D0003oC`3oool2000002H0oooo1000000W0?ooo`@0003o4`3oool30?oo
05T0oooo001d0?ooo`D0003oD@3oool2000002P0oooo1000000V0?ooo`D0003o4P3oool40?oo05L0
oooo001c0?ooo`@0003oD`3oool2000002T0oooo1@00000V0?ooo`@0003o4P3oool40?oo05H0oooo
001a0?ooo`@0003oE@3oool2000002/0oooo1000000W0?ooo`@0003o4P3oool40?oo05@0oooo001`
0?ooo`@0003oEP3oool2000002d0oooo1000000V0?ooo`@0003o4P3oool40?oo05<0oooo001^0?oo
o`@0003oF03oool2000002h0oooo1000000W0?ooo`@0003o4P3oool30?oo0580oooo001]0?ooo`@0
003oF@3oool200000300oooo1000000V0?ooo`@0003o4P3oool40?oo0500oooo001/0?ooo`<0003o
F`3oool200000340oooo1000000W0?ooo`@0003o4@3oool40?oo04l0oooo001Z0?ooo`@0003oG03o
ool300000380oooo1000000V0?ooo`@0003o4P3oool30?oo04h0oooo001Y0?ooo`@0003oG@3oool2
000003@0oooo1000000W0?ooo`@0003o4@3oool30?oo04d0oooo001W0?ooo`@0003oG`3oool20000
03H0oooo1000000V0?ooo`@0003o4@3oool30?oo04`0oooo001V0?ooo`@0003oH03oool2000003L0
oooo1@00000V0?ooo`@0003o403oool30?oo04/0oooo001U0?ooo`<0003oHP3oool2000003T0oooo
1000000V0?ooo`@0003o403oool30?oo04X0oooo001S0?ooo`@0003oH`3oool2000003/0oooo1000
000V0?ooo`<0003o403oool30?oo04T0oooo001R0?ooo`@0003oI03oool2000003`0oooo1000000V
0?ooo`<0003o403oool30?oo04P0oooo001Q0?ooo`<0003oIP3oool2000003h0oooo1000000U0?oo
o`@0003o3`3oool30?oo04L0oooo001O0?ooo`@0003oI`3oool2000003l0oooo1000000U0?ooo`@0
003o3`3oool30?oo04H0oooo001N0?ooo`@0003oJ03oool200000440oooo1000000U0?ooo`<0003o
3`3oool30?oo04D0oooo001L0?ooo`@0003oJP3oool300000440oooo1000000U0?ooo`<0003o3`3o
ool30?oo04@0oooo001K0?ooo`@0003oJ`3oool2000004@0oooo1000000T0?ooo`<0003o3`3oool3
0?oo04<0oooo001J0?ooo`<0003oK@3oool2000004D0oooo1@00000S0?ooo`<0003o3`3oool30?oo
0480oooo001H0?ooo`@0003oC03oool4000000L0oooo0P0000050?ooo`D000002`3oool2000004L0
oooo1000000S0?ooo`@0003o3P3oool30?oo0440oooo001G0?ooo`@0003oC03oool2000000<0oooo
0P0000050?ooo`800000103oool2000000@0oooo00<000000?ooo`3oool0203oool2000004T0oooo
1000000R0?ooo`@0003o3P3oool30?oo0400oooo001F0?ooo`<0003oCP3oool00`000000oooo0?oo
o`030?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool01`3oool2000004X0oooo1@00
000R0?ooo`<0003o3P3oool30?oo03l0oooo001E0?ooo`<0003oCP3oool2000000D0oooo0P00000B
0?ooo`030000003oool0oooo00H0oooo0P00001<0?ooo`@000008P3oool30000o`h0oooo0`3oo`0n
0?ooo`00D`3oool40000odl0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0@0?oo
o`8000001`3oool2000004h0oooo1000000Q0?ooo`<0003o3P3oool20?oo03h0oooo001B0?ooo`@0
003oC`3oool2000000L0oooo0P00000A0?ooo`8000001`3oool2000004l0oooo1@00000P0?ooo`<0
003o3P3oool20?oo03d0oooo001A0?ooo`<0003oD@3oool2000000L0oooo0P00000A0?ooo`800000
1`3oool200000540oooo1000000P0?ooo`@0003o303oool30?oo03`0oooo001@0?ooo`<0003oDP3o
ool2000000L0oooo0P00000A0?ooo`8000001`3oool2000005<0oooo1000000O0?ooo`@0003o303o
ool30?oo03/0oooo001?0?ooo`<0003oD`3oool2000000L0oooo0P00000@0?ooo`<000001`3oool4
00000580oooo1@00000O0?ooo`<0003o303oool30?oo03X0oooo001>0?ooo`<0003oE03oool20000
00L0oooo0P00000?0?ooo`<00000203oool2000005H0oooo1000000O0?ooo`<0003o303oool30?oo
03T0oooo001<0?ooo`@0003oE@3oool2000000L0oooo0P00000=0?ooo`@000002@3oool2000005P0
oooo1000000N0?ooo`<0003o303oool30?oo03P0oooo001;0?ooo`@0003oEP3oool2000000L0oooo
0P00000:0?ooo`H000002P3oool2000005T0oooo1000000N0?ooo`<0003o303oool30?oo03L0oooo
001:0?ooo`<0003oF@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00X0oooo0`00
000<0?ooo`800000F`3oool4000001d0oooo10000?l;0?ooo`80ool0=`3oool004T0oooo0`000?mJ
0?ooo`8000001@3oool2000000`0oooo00<000000?ooo`3oool0303oool2000005`0oooo1000000M
0?ooo`@0003o2`3oool20?oo03H0oooo00180?ooo`<0003oG03oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool02`3oool2000005h0oooo1000000M0?oo
o`<0003o2P3oool30?oo03D0oooo00170?ooo`<0003oG@3oool2000000<0oooo0P00000>0?ooo`H0
0000203oool2000005l0oooo1000000M0?ooo`<0003o2P3oool30?oo03@0oooo00160?ooo`<0003o
H03oool300000140oooo1P0000070?ooo`800000H@3oool4000001`0oooo0`000?l:0?ooo`<0ool0
<`3oool004D0oooo0`000?n20?ooo`800000HP3oool5000001/0oooo0`000?l:0?ooo`80ool0<`3o
ool004@0oooo0`000?n30?ooo`800000I03oool4000001/0oooo0`000?l:0?ooo`80ool0<P3oool0
04<0oooo0`000?n40?ooo`<00000I@3oool4000001X0oooo0`000?l:0?ooo`80ool0<@3oool00480
oooo0`000?n50?ooo`800000I`3oool5000001T0oooo0`000?l:0?ooo`030?oo003oool0oooo02l0
oooo00110?ooo`<0003oQP3oool2000006T0oooo1000000I0?ooo`<0003o2@3oool20?oo0300oooo
00100?ooo`<0003oQ`3oool2000006/0oooo1000000H0?ooo`@0003o203oool20?oo02l0oooo000o
0?ooo`<0003oR03oool2000006`0oooo1@00000G0?ooo`@0003o203oool00`3oo`00oooo0?ooo`0]
0?ooo`00?P3oool30000ohT0oooo0P00001^0?ooo`@00000603oool30000o`L0oooo0P3oo`0^0?oo
o`00?@3oool30000ohX0oooo0P00001`0?ooo`@000005`3oool30000o`L0oooo0P3oo`0]0?ooo`00
?03oool30000oh/0oooo0P00001a0?ooo`D000005P3oool30000o`L0oooo00<0ool00?ooo`3oool0
:`3oool003/0oooo0`000?n<0?ooo`800000L`3oool4000001H0oooo0`000?l60?ooo`80ool0;03o
ool003X0oooo0`000?n=0?ooo`800000M@3oool4000001D0oooo0`000?l60?ooo`80ool0:`3oool0
03T0oooo0`000?n>0?ooo`<00000M@3oool5000001@0oooo0`000?l60?ooo`80ool0:P3oool003P0
oooo0`000?n?0?ooo`800000N03oool4000001@0oooo0`000?l60?ooo`030?oo003oool0oooo02P0
oooo000g0?ooo`<0003oT03oool2000007X0oooo1000000C0?ooo`<0003o1@3oool20?oo02T0oooo
000g0?ooo`80003oT@3oool2000007/0oooo1@00000B0?ooo`80003o1P3oool20?oo02P0oooo000f
0?ooo`80003oTP3oool2000007d0oooo1000000B0?ooo`80003o1P3oool00`3oo`00oooo0?ooo`0V
0?ooo`00=@3oool30000oi80oooo0P00001o0?ooo`@00000403oool30000o`D0oooo0P3oo`0W0?oo
o`00=03oool30000oi<0oooo0P0000200?ooo`D000003`3oool30000o`D0oooo0P3oo`0V0?ooo`00
<`3oool30000oi@0oooo0P0000220?ooo`@000003`3oool30000o`D0oooo00<0ool00?ooo`3oool0
903oool00380oooo0`000?nE0?ooo`800000Q03oool4000000h0oooo0`000?l40?ooo`80ool09@3o
ool00340oooo0`000?nF0?ooo`800000Q@3oool4000000h0oooo0`000?l40?ooo`80ool0903oool0
0300oooo0`000?nG0?ooo`800000Q`3oool4000000d0oooo0`000?l40?ooo`030?oo003oool0oooo
0280oooo000`0?ooo`80003oV03oool3000008L0oooo1000000=0?ooo`80003o103oool20?oo02<0
oooo000_0?ooo`80003oV@3oool2000008X0oooo1000000<0?ooo`80003o103oool00`3oo`00oooo
0?ooo`0Q0?ooo`00;P3oool30000oiT0oooo0P00002;0?ooo`@000002`3oool30000o`<0oooo0P3o
o`0R0?ooo`00;@3oool30000oiX0oooo0P00002=0?ooo`@000002P3oool30000o`<0oooo0P3oo`0Q
0?ooo`00;03oool30000oi/0oooo0P00002>0?ooo`D000002@3oool30000o`<0oooo00<0ool00?oo
o`3oool07`3oool002/0oooo0`000?nL0?ooo`800000T03oool4000000T0oooo0`000?l20?ooo`80
ool0803oool002X0oooo0`000?nM0?ooo`800000TP3oool4000000P0oooo0`000?l20?ooo`030?oo
003oool0oooo01h0oooo000Y0?ooo`<0003oWP3oool2000009<0oooo1@0000070?ooo`80003o0P3o
ool20?oo01l0oooo000X0?ooo`<0003oW`3oool2000009D0oooo100000070?ooo`80003o0P3oool0
0`3oo`00oooo0?ooo`0M0?ooo`00:03oool20000oj00oooo0P00002G0?ooo`@000001@3oool30000
o`030?ooo`3oo`00ool001h0oooo000W0?ooo`80003oX@3oool2000009P0oooo1@0000040?ooo`<0
003o00<0oooo0?oo003oo`007@3oool002H0oooo0`000?nQ0?ooo`<00000V@3oool4000000@0oooo
0`000?l00`3oool0ool00?ooo`0L0?ooo`009@3oool30000oj80oooo0P00002L0?ooo`@000000`3o
ool30000o`80ool0703oool002@0oooo0`000?nS0?ooo`800000W@3oool4000000<0oooo0P000?l0
0`3oool0ool00?ooo`0K0?ooo`008`3oool30000oiD0oooo1P0000090?ooo`800000W`3oool40000
0080oooo0P000?l20?oo01/0oooo000R0?ooo`<0003oV03oool2000000/0oooo0P00002P0?ooo`@0
000000D0oooo0000o`000?l0003o0?oo000K0?ooo`008@3oool30000oiT0oooo0P00000;0?ooo`80
0000XP3oool400000080003o0P3oo`0J0?ooo`008@3oool20000oiX0oooo0P00000;0?ooo`800000
X`3oool400000080003o00<0ool00?ooo`3oool0603oool00200oooo0P000?nK0?ooo`8000002`3o
ool200000:D0oooo0`0000000`000?l0ool00?oo000I0?ooo`007`3oool30000oi/0oooo0P00000;
0?ooo`800000YP3oool3000000030000o`3oo`00ool001P0oooo000N0?ooo`<0003oW03oool20000
00/0oooo0P00002X0?ooo`80000000<0003o0?oo003oool05`3oool001d0oooo0`000?nM0?ooo`80
00002`3oool200000:T0oooo00@000000000o`3oo`00ool05`3oool001`0oooo0`000?oo0?l005T0
o`0000<0003o0?oo000000005P3oool001`0oooo00<0o`000000o`3o0000o`3o001J0?l000030?oo
003oool0oooo01D0oooo002m0?ooo`8000002`3oool200000<@0oooo002m0?ooo`8000002`3oool2
00000<@0oooo002m0?ooo`8000002`3oool200000<@0oooo002m0?ooo`8000002`3oool200000<@0
oooo002m0?ooo`8000002`3oool200000<@0oooo002j0?ooo`D00000d@3oool00;`0oooo0`00003A
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 399}, {246.188, 0}} -> {-1.1727, -1.14806, \
0.00576425, 0.00932676}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(Export["\<G:\Robert\Vorlesungen\Variationsrechnung\Pr\[ADoubleDot]\
sentation\Basis.png\>", basis, \ 
      ImageSize \[Rule] 400]\)\(\[IndentingNewLine]\)
    \)\)], "Input"],

Cell[BoxData[
    \("G:\\Robert\\Vorlesungen\\Variationsrechnung\\Pr\[ADoubleDot]sentation\\\
Basis.png"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Options[Plot]\)], "Input"],

Cell[BoxData[
    \({AspectRatio \[Rule] 1\/GoldenRatio, Axes \[Rule] Automatic, 
      AxesLabel \[Rule] None, AxesOrigin \[Rule] Automatic, 
      AxesStyle \[Rule] Automatic, Background \[Rule] Automatic, 
      ColorOutput \[Rule] Automatic, Compiled \[Rule] True, 
      DefaultColor \[Rule] Automatic, 
      DefaultFont \[RuleDelayed] $DefaultFont, 
      DisplayFunction \[RuleDelayed] $DisplayFunction, Epilog \[Rule] {}, 
      FormatType \[RuleDelayed] $FormatType, Frame \[Rule] False, 
      FrameLabel \[Rule] None, FrameStyle \[Rule] Automatic, 
      FrameTicks \[Rule] Automatic, GridLines \[Rule] None, 
      ImageSize \[Rule] Automatic, MaxBend \[Rule] 10.`, 
      PlotDivision \[Rule] 30.`, PlotLabel \[Rule] None, 
      PlotPoints \[Rule] 25, PlotRange \[Rule] Automatic, 
      PlotRegion \[Rule] Automatic, PlotStyle \[Rule] Automatic, 
      Prolog \[Rule] {}, RotateLabel \[Rule] True, 
      TextStyle \[RuleDelayed] $TextStyle, 
      Ticks \[Rule] Automatic}\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\[IndentingNewLine]\)], "Input"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Input"],

Cell[BoxData[""], "Input"],

Cell[BoxData[
    \(l1\)], "Input"]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 699}},
WindowSize->{833, 524},
WindowMargins->{{Automatic, 87}, {Automatic, 53}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 52, 1, 50, "Input"],
Cell[1809, 54, 109, 2, 50, "Input"],

Cell[CellGroupData[{
Cell[1943, 60, 82, 1, 30, "Input"],
Cell[2028, 63, 20573, 544, 186, 4765, 344, "GraphicsData", "PostScript", \
"Graphics"],
Cell[22604, 609, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22771, 617, 63, 1, 30, "Input"],
Cell[22837, 620, 113, 2, 42, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[22987, 627, 223, 4, 63, "Input"],
Cell[23213, 633, 14225, 366, 186, 3227, 226, "GraphicsData", "PostScript", \
"Graphics"],
Cell[37441, 1001, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[37608, 1009, 223, 4, 63, "Input"],
Cell[37834, 1015, 14248, 370, 186, 3205, 229, "GraphicsData", "PostScript", \
"Graphics"],
Cell[52085, 1387, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[52252, 1395, 132, 2, 50, "Input"],
Cell[52387, 1399, 37961, 762, 379, 4788, 349, "GraphicsData", "PostScript", \
"Graphics"],
Cell[90351, 2163, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[90518, 2171, 185, 3, 50, "Input"],
Cell[90706, 2176, 367, 6, 22, "Message"],
Cell[91076, 2184, 322, 5, 22, "Message"],
Cell[91401, 2191, 323, 5, 22, "Message"],
Cell[91727, 2198, 357, 7, 29, "Output"]
}, Open  ]],
Cell[92099, 2208, 26, 0, 30, "Input"],

Cell[CellGroupData[{
Cell[92150, 2212, 328, 7, 150, "Input"],
Cell[92481, 2221, 36, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[92554, 2227, 2865, 75, 90, "Input"],
Cell[95422, 2304, 42583, 1058, 328, 14720, 709, "GraphicsData", "PostScript", \
"Graphics"],
Cell[138008, 3364, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[138175, 3372, 139, 2, 63, "Input"],
Cell[138317, 3376, 37, 1, 30, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[138391, 3382, 150, 3, 63, "Input"],
Cell[138544, 3387, 74, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[138655, 3393, 122, 3, 42, "Input"],
Cell[138780, 3398, 51, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[138868, 3404, 74, 1, 50, "Input"],
Cell[138945, 3407, 39, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[139021, 3413, 191, 4, 50, "Input"],
Cell[139215, 3419, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[139382, 3427, 191, 4, 50, "Input"],
Cell[139576, 3433, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[139743, 3441, 199, 4, 50, "Input"],
Cell[139945, 3447, 5958, 130, 186, 1515, 71, "GraphicsData", "PostScript", \
"Graphics"],
Cell[145906, 3579, 130, 3, 29, "Output"]
}, Open  ]],
Cell[146051, 3585, 129, 3, 30, "Input"],

Cell[CellGroupData[{
Cell[146205, 3592, 164, 3, 50, "Input"],
Cell[146372, 3597, 49331, 1235, 328, 18318, 848, "GraphicsData", \
"PostScript", "Graphics"],
Cell[195706, 4834, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[195873, 4842, 143, 2, 30, "Input"],
Cell[196019, 4846, 124, 2, 29, "Output"]
}, Open  ]],
Cell[196158, 4851, 26, 0, 30, "Input"],

Cell[CellGroupData[{
Cell[196209, 4855, 1427, 36, 70, "Input"],
Cell[197639, 4893, 32788, 814, 328, 12368, 558, "GraphicsData", "PostScript", \
"Graphics"],
Cell[230430, 5709, 130, 3, 29, "Output"]
}, Open  ]],
Cell[230575, 5715, 129, 3, 30, "Input"],

Cell[CellGroupData[{
Cell[230729, 5722, 153, 2, 50, "Input"],
Cell[230885, 5726, 129, 2, 29, "Output"]
}, Open  ]],
Cell[231029, 5731, 122, 2, 50, "Input"],

Cell[CellGroupData[{
Cell[231176, 5737, 2854, 75, 110, "Input"],
Cell[234033, 5814, 37512, 897, 328, 12857, 589, "GraphicsData", "PostScript", \
"Graphics"],
Cell[271548, 6713, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[271715, 6721, 2869, 75, 90, "Input"],
Cell[274587, 6798, 34855, 844, 328, 11910, 557, "GraphicsData", "PostScript", \
"Graphics"],
Cell[309445, 7644, 130, 3, 29, "Output"]
}, Open  ]],
Cell[309590, 7650, 50, 1, 30, "Input"],

Cell[CellGroupData[{
Cell[309665, 7655, 296, 5, 90, "Input"],
Cell[309964, 7662, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[310131, 7670, 330, 7, 110, "Input"],
Cell[310464, 7679, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[310631, 7687, 51, 1, 30, "Input"],
Cell[310685, 7690, 14033, 256, 262, 2423, 108, "GraphicsData", "PostScript", \
"Graphics"],
Cell[324721, 7948, 130, 3, 29, "Output"]
}, Open  ]],
Cell[324866, 7954, 52, 1, 50, "Input"],
Cell[324921, 7957, 173, 4, 50, "Input"],

Cell[CellGroupData[{
Cell[325119, 7965, 183, 3, 50, "Input"],
Cell[325305, 7970, 54395, 1262, 328, 17917, 808, "GraphicsData", \
"PostScript", "Graphics"],
Cell[379703, 9234, 130, 3, 29, "Output"]
}, Open  ]],
Cell[379848, 9240, 129, 3, 30, "Input"],

Cell[CellGroupData[{
Cell[380002, 9247, 205, 3, 50, "Input"],
Cell[380210, 9252, 139, 2, 29, "Output"]
}, Open  ]],
Cell[380364, 9257, 97, 2, 50, "Input"],
Cell[380464, 9261, 227, 7, 63, "Input"],
Cell[380694, 9270, 26, 0, 30, "Input"],

Cell[CellGroupData[{
Cell[380745, 9274, 2870, 75, 90, "Input"],
Cell[383618, 9351, 46380, 1165, 328, 17227, 802, "GraphicsData", \
"PostScript", "Graphics"],
Cell[430001, 10518, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[430168, 10526, 26, 0, 30, "Input"],
Cell[430197, 10528, 106, 2, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[430340, 10535, 195, 3, 50, "Input"],
Cell[430538, 10540, 134, 2, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[430709, 10547, 75, 1, 30, "Input"],
Cell[430787, 10550, 29501, 685, 237, 5591, 385, "GraphicsData", "PostScript", \
"Graphics"],
Cell[460291, 11237, 130, 3, 29, "Output"]
}, Open  ]],
Cell[460436, 11243, 331, 7, 50, "Input"],

Cell[CellGroupData[{
Cell[460792, 11254, 3110, 81, 90, "Input"],
Cell[463905, 11337, 33530, 931, 256, 13726, 682, "GraphicsData", \
"PostScript", "Graphics"],
Cell[497438, 12270, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[497605, 12278, 199, 4, 70, "Input"],
Cell[497807, 12284, 118, 2, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[497962, 12291, 46, 1, 30, "Input"],
Cell[498011, 12294, 1003, 17, 162, "Output"]
}, Open  ]],
Cell[499029, 12314, 52, 1, 50, "Input"],
Cell[499084, 12317, 129, 3, 30, "Input"],
Cell[499216, 12322, 26, 0, 30, "Input"],
Cell[499245, 12324, 35, 1, 30, "Input"]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

