(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    111013,       3119]*)
(*NotebookOutlinePosition[    111661,       3141]*)
(*  CellTagsIndexPosition[    111617,       3137]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(fontSize = 26\)\)\)], "Input"],

Cell[BoxData[
    \(26\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(f1[x_] := \(-2\)\ Sin[x]\[IndentingNewLine]
    f2[x_] := x^3 - 2  x^2 - 0.5\[IndentingNewLine]
    f3[x_] := Exp[x]\[IndentingNewLine]
    f4[x_] := \(-3\) x^3 + x^2 + 4  x + 2\)\)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"funktionen", "=", 
      RowBox[{"Plot", "[", 
        RowBox[{\({f1[x], f2[x], f3[x]}\), ",", \({x, \(-1\), 1}\), ",", 
          RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"{", 
              RowBox[{
                FormBox["Thickness",
                  "TraditionalForm"], "[", "0.006", "]"}], "}"}]}], ",", 
          RowBox[{"PlotStyle", "\[Rule]", " ", 
            RowBox[{"{", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{
                      StyleBox["RGBColor",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      RowBox[{
                        StyleBox["1",
                          "MR"], 
                        StyleBox[",",
                          "MR"], " ", "0", 
                        StyleBox[",",
                          "MR"], " ", "0"}], 
                      StyleBox["]",
                        "MR"]}], 
                    StyleBox[",",
                      "MR"], 
                    RowBox[{
                      FormBox["Thickness",
                        "TraditionalForm"], "[", "0.006", "]"}]}], 
                  StyleBox["}",
                    "MR"]}], 
                StyleBox[",",
                  "MR"], 
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{
                      StyleBox["RGBColor",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      RowBox[{
                        StyleBox["0",
                          "MR"], 
                        StyleBox[",",
                          "MR"], " ", "0", 
                        StyleBox[",",
                          "MR"], 
                        StyleBox["0",
                          "MR"]}], 
                      StyleBox["]",
                        "MR"]}], 
                    StyleBox[",",
                      "MR"], 
                    RowBox[{
                      FormBox["Thickness",
                        "TraditionalForm"], "[", "0.006", "]"}]}], 
                  StyleBox["}",
                    "MR"]}], 
                StyleBox[",",
                  "MR"], 
                StyleBox[
                  RowBox[{"{", 
                    RowBox[{\(RGBColor[0, 0, 1]\), ",", 
                      RowBox[{
                        FormBox["Thickness",
                          "TraditionalForm"], "[", "0.006", "]"}]}], "}"}],
                  "MR"], 
                StyleBox[",",
                  "MR"]}], "}"}]}], ",", " ", \(ImageSize \[Rule] 400\), ",", 
          " ", \(AspectRatio \[Rule] 0.8\), 
          ",", \(TextStyle \[Rule] {FontFamily \[Rule] "\<Times\>", 
              FontSize \[Rule] fontSize}\)}], "]"}]}]], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .8 
%%ImageSize: 400 320 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.447891 0.122527 [
[.02381 .43539 -17.6563 -31.75 ]
[.02381 .43539 17.6563 0 ]
[.2619 .43539 -27.4375 -31.75 ]
[.2619 .43539 27.4375 0 ]
[.7381 .43539 -18.3125 -31.75 ]
[.7381 .43539 18.3125 0 ]
[.97619 .43539 -8.53125 -31.75 ]
[.97619 .43539 8.53125 0 ]
[.4875 .08031 -35.3125 -15.875 ]
[.4875 .08031 0 15.875 ]
[.4875 .20284 -35.3125 -15.875 ]
[.4875 .20284 0 15.875 ]
[.4875 .32536 -35.3125 -15.875 ]
[.4875 .32536 0 15.875 ]
[.4875 .57042 -17.0625 -15.875 ]
[.4875 .57042 0 15.875 ]
[.4875 .69294 -17.0625 -15.875 ]
[.4875 .69294 0 15.875 ]
[ -0.003 -0.003 0 0 ]
[ 1.003 .803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .44789 m
.02381 .45414 L
s
gsave
.02381 .43539 -78.6563 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.2619 .44789 m
.2619 .45414 L
s
gsave
.2619 .43539 -88.4375 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.7381 .44789 m
.7381 .45414 L
s
gsave
.7381 .43539 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.97619 .44789 m
.97619 .45414 L
s
gsave
.97619 .43539 -69.5313 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.125 Mabswid
.07143 .44789 m
.07143 .45164 L
s
.11905 .44789 m
.11905 .45164 L
s
.16667 .44789 m
.16667 .45164 L
s
.21429 .44789 m
.21429 .45164 L
s
.30952 .44789 m
.30952 .45164 L
s
.35714 .44789 m
.35714 .45164 L
s
.40476 .44789 m
.40476 .45164 L
s
.45238 .44789 m
.45238 .45164 L
s
.54762 .44789 m
.54762 .45164 L
s
.59524 .44789 m
.59524 .45164 L
s
.64286 .44789 m
.64286 .45164 L
s
.69048 .44789 m
.69048 .45164 L
s
.78571 .44789 m
.78571 .45164 L
s
.83333 .44789 m
.83333 .45164 L
s
.88095 .44789 m
.88095 .45164 L
s
.92857 .44789 m
.92857 .45164 L
s
.006 w
0 .44789 m
1 .44789 L
s
.25 Mabswid
.5 .08031 m
.50625 .08031 L
s
gsave
.4875 .08031 -96.3125 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
1.000 setlinewidth
grestore
.5 .20284 m
.50625 .20284 L
s
gsave
.4875 .20284 -96.3125 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.5 .32536 m
.50625 .32536 L
s
gsave
.4875 .32536 -96.3125 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.5 .57042 m
.50625 .57042 L
s
gsave
.4875 .57042 -78.0625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.5 .69294 m
.50625 .69294 L
s
gsave
.4875 .69294 -78.0625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.125 Mabswid
.5 .10482 m
.50375 .10482 L
s
.5 .12932 m
.50375 .12932 L
s
.5 .15383 m
.50375 .15383 L
s
.5 .17833 m
.50375 .17833 L
s
.5 .22734 m
.50375 .22734 L
s
.5 .25185 m
.50375 .25185 L
s
.5 .27635 m
.50375 .27635 L
s
.5 .30086 m
.50375 .30086 L
s
.5 .34987 m
.50375 .34987 L
s
.5 .37437 m
.50375 .37437 L
s
.5 .39888 m
.50375 .39888 L
s
.5 .42339 m
.50375 .42339 L
s
.5 .4724 m
.50375 .4724 L
s
.5 .4969 m
.50375 .4969 L
s
.5 .52141 m
.50375 .52141 L
s
.5 .54591 m
.50375 .54591 L
s
.5 .59492 m
.50375 .59492 L
s
.5 .61943 m
.50375 .61943 L
s
.5 .64393 m
.50375 .64393 L
s
.5 .66844 m
.50375 .66844 L
s
.5 .05581 m
.50375 .05581 L
s
.5 .0313 m
.50375 .0313 L
s
.5 .00679 m
.50375 .00679 L
s
.5 .71745 m
.50375 .71745 L
s
.5 .74195 m
.50375 .74195 L
s
.5 .76646 m
.50375 .76646 L
s
.5 .79097 m
.50375 .79097 L
s
.006 w
.5 0 m
.5 .8 L
s
0 0 m
1 0 L
1 .8 L
0 .8 L
closepath
clip
newpath
1 0 0 r
.02381 .6541 m
.06244 .64269 L
.10458 .62879 L
.14415 .61444 L
.18221 .59956 L
.22272 .58266 L
.26171 .56546 L
.30316 .54633 L
.34309 .52719 L
.3815 .50825 L
.42237 .48767 L
.46172 .46757 L
.49955 .44812 L
.53984 .42741 L
.57861 .40762 L
.61984 .38687 L
.65954 .36731 L
.69774 .34903 L
.73838 .33028 L
.77751 .31303 L
.81909 .2957 L
.85916 .28009 L
.89771 .2662 L
.93871 .25273 L
.97619 .24169 L
s
0 0 0 r
.02381 .01905 m
.06244 .08467 L
.10458 .1475 L
.14415 .19865 L
.18221 .24107 L
.22272 .27935 L
.26171 .30991 L
.30316 .3361 L
.34309 .35563 L
.3815 .36956 L
.40134 .37502 L
.42237 .37958 L
.43178 .38124 L
.4419 .38276 L
.45139 .38394 L
.4602 .38484 L
.47031 .38564 L
.47564 .38597 L
.48134 .38624 L
.48394 .38634 L
.48676 .38644 L
.48925 .3865 L
.49187 .38656 L
.49424 .38659 L
.49559 .38661 L
.49685 .38662 L
.498 .38662 L
.49906 .38663 L
.50027 .38663 L
.50143 .38663 L
.50256 .38662 L
.50379 .38661 L
.50495 .3866 L
.50601 .38659 L
.50848 .38655 L
.51108 .3865 L
.51598 .38636 L
.52133 .38615 L
.53088 .38563 L
.53975 .38499 L
.56021 .38296 L
.5788 .38047 L
.61878 .37328 L
.65725 .36432 L
.69817 .35302 L
.73757 .34085 L
.77546 .32835 L
.8158 .31459 L
.85462 .30133 L
.8959 .28766 L
Mistroke
.93566 .27534 L
.9739 .26469 L
.97619 .2641 L
Mfstroke
0 0 1 r
.02381 .49297 m
.06244 .49678 L
.10458 .5013 L
.14415 .50593 L
.18221 .51075 L
.22272 .51634 L
.26171 .52218 L
.30316 .52893 L
.34309 .53602 L
.3815 .54342 L
.42237 .55198 L
.46172 .56095 L
.49955 .5703 L
.53984 .58111 L
.57861 .59241 L
.61984 .60548 L
.65954 .61918 L
.69774 .63349 L
.73838 .65002 L
.77751 .66734 L
.81909 .68736 L
.85916 .70838 L
.89771 .73035 L
.93871 .75575 L
.97619 .78095 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{400, 320},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0001@2000`400?l00000o`00003oo`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00bP3oool200000<@0oooo003:
0?ooo`800000a03oool00<X0oooo0P0000340?ooo`00bP3oool300000<<0oooo003:0?ooo`800000
a03oool00<X0oooo0P0000340?ooo`00bP3oool200000<@0oooo000A0?ooo`030000003oool0oooo
0;H0oooo0P0000340?ooo`004@3oool00`000000oooo0?ooo`2f0?ooo`800000a03oool00140oooo
0P00002g0?ooo`800000a03oool00180oooo0P00002f0?ooo`800000a03oool001<0oooo00<00000
0?ooo`3oool0]03oool200000<@0oooo000C0?ooo`800000]@3oool300000<<0oooo000D0?ooo`03
0000003oool0oooo0;<0oooo0P0000340?ooo`00503oool200000;@0oooo0P0000340?ooo`005@3o
ool200000;<0oooo0P0000340?ooo`005P3oool00`000000oooo0?ooo`2a0?ooo`800000a03oool0
01H0oooo0P00002b0?ooo`800000a03oool001L0oooo00<000000?ooo`3oool0/03oool200000<@0
oooo000G0?ooo`800000/@3oool200000<@0oooo000H0?ooo`800000/03oool200000<@0oooo000I
0?ooo`030000003oool0oooo0:h0oooo0P0000340?ooo`006@3oool200000:l0oooo0`0000330?oo
o`006P3oool00`000000oooo0?ooo`2]0?ooo`800000a03oool001X0oooo0P00002L0?ooo`L00000
2`3oool200000<@0oooo000K0?ooo`800000V`3oool3000000@0oooo00<000000?ooo`3oool0203o
ool200000<@0oooo000L0?ooo`030000003oool0oooo0:40oooo00<000000?ooo`3oool01`3oool2
00000<@0oooo000L0?ooo`800000XP3oool2000000P0oooo0P0000340?ooo`007@3oool00`000000
oooo0?ooo`2P0?ooo`800000203oool200000<@0oooo000M0?ooo`800000Q`3oool=000000d0oooo
0P0000080?ooo`800000a03oool001h0oooo0P0000260?ooo`d00000303oool3000000P0oooo0P00
00340?ooo`007`3oool00`000000oooo0?ooo`2L0?ooo`@00000203oool400000<80oooo000O0?oo
o`800000VP3oool6000000T0oooo0P0000340?ooo`00803oool00`000000oooo0?ooo`2J0?ooo`<0
00002P3oool200000<@0oooo000P0?ooo`800000W03oool2000000X0oooo0P0000340?ooo`008@3o
ool2000009`0oooo00<000000?ooo`3oool0203oool200000<@0oooo000R0?ooo`030000003oool0
oooo09X0oooo0P0000090?ooo`800000a03oool00280oooo0P00002D0?ooo`030000003oool0oooo
00@0oooo0P0000090?ooo`800000a03oool002<0oooo0P00002D0?ooo`030000003oool0oooo0080
oooo0`0000090?ooo`800000a03oool002@0oooo00<000000?ooo`3oool0TP3oool7000000X0oooo
0P0000340?ooo`00903oool2000009D0oooo1000000;0?ooo`800000a03oool002D0oooo0P00002S
0?ooo`<00000``3oool002H0oooo00<000000?ooo`3oool0X@3oool200000<@0oooo000V0?ooo`80
0000XP3oool200000<@0oooo000W0?ooo`800000X@3oool200000<@0oooo000X0?ooo`030000003o
ool0oooo09l0oooo0P0000340?ooo`00:03oool200000:00oooo0P0000340?ooo`00:@3oool20000
09l0oooo0P0000340?ooo`00:P3oool2000009h0oooo0P0000340?ooo`00:`3oool00`000000oooo
0?ooo`2L0?ooo`800000a03oool002/0oooo0P00002M0?ooo`800000a03oool002`0oooo0P00002L
0?ooo`<00000``3oool002d0oooo00<000000?ooo`3oool0VP3oool200000<@0oooo000]0?ooo`80
0000V`3oool200000<@0oooo000^0?ooo`800000VP3oool200000<@0oooo000_0?ooo`030000003o
ool0oooo09P0oooo0P0000340?ooo`00;`3oool2000009T0oooo0P0000340?ooo`00<03oool20000
09P0oooo0P0000340?ooo`00<@3oool00`000000oooo0?ooo`2F0?ooo`800000a03oool00340oooo
0P00002G0?ooo`800000a03oool00380oooo0P00002F0?ooo`<00000``3oool003<0oooo0P00002E
0?ooo`800000a03oool003@0oooo00<000000?ooo`3oool0T`3oool200000<@0oooo000d0?ooo`80
0000U03oool200000<@0oooo000e0?ooo`800000T`3oool200000<@0oooo000f0?ooo`800000TP3o
ool200000<@0oooo000g0?ooo`030000003oool0oooo0900oooo0P0000340?ooo`00=`3oool20000
0940oooo0P0000340?ooo`00>03oool200000900oooo0P0000340?ooo`00>@3oool2000008l0oooo
0P0000340?ooo`00>P3oool00`000000oooo0?ooo`2=0?ooo`<00000``3oool003X0oooo0P00002>
0?ooo`800000a03oool003/0oooo0P00001k0?ooo`X00000203oool200000<@0oooo000l0?ooo`80
0000N`3oool9000000P0oooo0P0000340?ooo`00?@3oool00`000000oooo0?ooo`1j0?ooo`030000
003oool0oooo00@0oooo0P0000070?ooo`800000a03oool003d0oooo0P00001l0?ooo`030000003o
ool0oooo00`0oooo0P0000340?ooo`00?P3oool2000007`0oooo00<000000?ooo`3oool02`3oool2
00000<@0oooo000o0?ooo`800000I@3oool=000000X0oooo00<000000?ooo`3oool02P3oool20000
0<@0oooo00100?ooo`800000I03oool=000000/0oooo00<000000?ooo`3oool02@3oool200000<@0
oooo00100?ooo`<00000N`3oool00`000000oooo0?ooo`090?ooo`@00000`P3oool00440oooo0`00
001k0?ooo`030000003oool0oooo00P0oooo0P0000340?ooo`00@P3oool3000007/0oooo00<00000
0?ooo`3oool01`3oool200000<@0oooo00130?ooo`<00000NP3oool00`000000oooo0?ooo`070?oo
o`800000a03oool004@0oooo0`00001i0?ooo`800000203oool200000<@0oooo00150?ooo`<00000
L03oool00`000000oooo0?ooo`050?ooo`800000203oool200000<@0oooo00160?ooo`800000L03o
ool00`000000oooo0?ooo`050?ooo`800000203oool200000<@0oooo00170?ooo`800000L03oool0
0`000000oooo0?ooo`020?ooo`@00000203oool200000<@0oooo00170?ooo`<00000K`3oool80000
00T0oooo0P0000340?ooo`00B03oool300000700oooo1000000;0?ooo`800000a03oool004T0oooo
0`00001n0?ooo`<00000``3oool004X0oooo0`00001m0?ooo`800000a03oool004/0oooo0`00001l
0?ooo`800000a03oool004`0oooo0`00001k0?ooo`800000a03oool004d0oooo0`00001j0?ooo`80
0000^03oool00`3o0000oooo0?ooo`090?ooo`00CP3oool3000007T0oooo0P00002e0?ooo`D0o`00
2P3oool004l0oooo0`00001h0?ooo`800000/P3oool70?l000/0oooo001@0?ooo`<00000M`3oool2
00000:l0oooo1`3o000>0?ooo`00D@3oool3000007H0oooo0P00002/0?ooo`L0o`004@3oool00580
oooo0`00001e0?ooo`<00000Z03oool70?l001@0oooo001C0?ooo`<00000M03oool200000:H0oooo
1`3o000G0?ooo`00E03oool3000007<0oooo0P00002S0?ooo`H0o`006`3oool005D0oooo1000001a
0?ooo`800000X03oool60?l001h0oooo001F0?ooo`@00000L03oool2000009d0oooo1P3o000Q0?oo
o`00F03oool3000006l0oooo0P00002I0?ooo`L0o`00503oool5000000/0oooo001I0?ooo`<00000
KP3oool2000009H0oooo1`3o000C0?ooo`T000002`3oool005X0oooo0`00001]0?ooo`800000T`3o
ool70?l00180oooo2000000@0?ooo`00F`3oool3000006`0oooo0P00002@0?ooo`L0o`004@3oool8
000001@0oooo001L0?ooo`<00000J`3oool2000008d0oooo1`3o000A0?ooo`L00000603oool005d0
oooo0`00001Z0?ooo`<00000R@3oool70?l00140oooo1`00000K0?ooo`00GP3oool3000006T0oooo
0P0000270?ooo`L0o`004@3oool7000001h0oooo001O0?ooo`<00000J03oool2000008D0oooo1P3o
000A0?ooo`L000008@3oool00600oooo1000001V0?ooo`800000PP3oool60?l00140oooo1`00000T
0?ooo`00H@3oool4000006D0oooo0P0000200?ooo`H0o`00403oool7000002L0oooo001S0?ooo`<0
0000I03oool2000007d0oooo1P3o000A0?ooo`H00000:P3oool006@0oooo0`00001S0?ooo`800000
N`3oool60?l00100oooo1P00000]0?ooo`00I@3oool400000640oooo0P00001i0?ooo`D0o`00403o
ool7000002l0oooo001V0?ooo`@00000H03oool2000007H0oooo1P3o000@0?ooo`H00000<P3oool0
06P0oooo0`00001O0?ooo`<00000L`3oool60?l000l0oooo1P00000e0?ooo`00J@3oool3000005h0
oooo0P00001b0?ooo`D0o`003`3oool7000003L0oooo001Z0?ooo`@00000C@3oool6000000T0oooo
0P00001`0?ooo`D0o`003P3oool7000003X0oooo001[0?ooo`@00000CP3oool2000000/0oooo0P00
001]0?ooo`H0o`003@3oool7000003d0oooo001]0?ooo`@00000C03oool2000000/0oooo0P00001[
0?ooo`H0o`00303oool700000400oooo001^0?ooo`@00000B`3oool2000000/0oooo0P00001Y0?oo
o`D0o`00303oool7000004<0oooo001`0?ooo`@00000B@3oool2000000/0oooo0P00001V0?ooo`H0
o`002`3oool7000004H0oooo001a0?ooo`@00000<@3oool=000000X0oooo0P00000;0?ooo`800000
I03oool60?l000X0oooo1P00001:0?ooo`00L`3oool4000002l0oooo3@00000:0?ooo`8000002`3o
ool200000680oooo1@3o000:0?ooo`H00000C@3oool007@0oooo1@0000140?ooo`8000002`3oool2
00000600oooo1@3o00090?ooo`H00000D03oool007H0oooo100000130?ooo`8000002`3oool40000
05/0oooo1P3o00070?ooo`L00000D`3oool007P0oooo100000110?ooo`8000002`3oool2000005/0
oooo1P3o00060?ooo`L00000EP3oool007T0oooo100000100?ooo`8000002`3oool2000005T0oooo
1@3o00060?ooo`L00000F@3oool007/0oooo1000000n0?ooo`8000002`3oool2000005L0oooo1@3o
00050?ooo`L00000G03oool007`0oooo1@00000l0?ooo`8000002`3oool2000005D0oooo1@3o0004
0?ooo`L00000G`3oool007h0oooo1@00000j0?ooo`8000002`3oool200000580oooo1P3o00030?oo
o`L00000HP3oool00800oooo1@00000h0?ooo`8000002`3oool200000500oooo1P3o00020?ooo`L0
0000I@3oool00880oooo1@00000c0?ooo`D000002`3oool2000004h0oooo1@3o00020?ooo`L00000
J03oool008@0oooo1@00000c0?ooo`<000002`3oool2000004`0oooo1@3o00000`3oool000000000
0005000006/0oooo00260?ooo`D00000?`3oool3000004T0oooo1@3o0007000006h0oooo00280?oo
o`D00000?@3oool2000004P0oooo103o000700000740oooo002:0?ooo`D00000>`3oool2000004H0
oooo0P3o0008000007@0oooo002<0?ooo`H00000>03oool2000004<0oooo00<0o`00000000000000
1P00001h0?ooo`00SP3oool7000003D0oooo0P0000100?ooo`P00000O03oool00940oooo1P00000c
0?ooo`800000?03oool800000800oooo002D0?ooo`H00000<03oool2000003T0oooo1`0000020?l0
0880oooo002F0?ooo`L00000;@3oool2000003D0oooo1`0000040?l008@0oooo002I0?ooo`L00000
:P3oool200000340oooo200000050?l008H0oooo002L0?ooo`P000009P3oool2000002d0oooo2000
00020?ooo`D0o`00R03oool001P0oooo1P00001=0?ooo`@000001`3oool2000000D0oooo1@00000N
0?ooo`P000008P3oool3000002@0oooo300000040?ooo`D0o`005@3oool4000000L0oooo0P000005
0?ooo`D00000D03oool6000000P0oooo000J0?ooo`800000CP3oool2000000<0oooo0P0000050?oo
o`800000103oool2000000@0oooo00<000000?ooo`3oool07`3oool8000001h0oooo0P00000M0?oo
oa0000001P3oool50?l001H0oooo0P0000030?ooo`8000001@3oool2000000@0oooo0P0000040?oo
o`030000003oool0oooo04l0oooo0P00000:0?ooo`006P3oool2000004h0oooo00<000000?ooo`3o
ool00`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0280oooo2000000J0?ooo`80
00005P3oool?000000`0oooo1@3o000H0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`1>0?ooo`8000002P3oool001X0oooo0P00001=0?ooo`800000
1@3oool200000180oooo00<000000?ooo`3oool09@3oool<00000180oooo0P00000>0?ooo`l00000
4P3oool50?l001T0oooo0P0000050?ooo`8000004P3oool00`000000oooo0?ooo`1=0?ooo`800000
2P3oool001X0oooo0P00001=0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0403o
ool2000002X0oooo4P0000080?ooo`8000001`3oool?000001L0oooo1@3o000K0?ooo`030000003o
ool0oooo00D0oooo00<000000?ooo`3oool0403oool2000004h0oooo0P00000:0?ooo`00103oool=
000000T0oooo0P00000j0?ooo`d000001@3oool2000000L0oooo0P00000A0?ooo`800000<P3ooolR
000001d0oooo1@3o000L0?ooo`8000001`3oool200000140oooo0P00001>0?ooo`8000002P3oool0
00@0oooo3@0000090?ooo`800000>P3oool=000000D0oooo0P0000070?ooo`8000004@3oool20000
03/0oooo4P00000R0?ooo`D0o`007P3oool2000000L0oooo0P00000A0?ooo`800000CP3oool20000
00X0oooo000J0?ooo`800000C03oool2000000L0oooo0P00000A0?ooo`800000A03oool2000002L0
oooo1@3o000P0?ooo`8000001`3oool200000140oooo0P00001>0?ooo`8000002P3oool001X0oooo
0P00001<0?ooo`8000001`3oool200000100oooo0`0000140?ooo`8000009@3oool50?l00280oooo
0P0000070?ooo`800000403oool3000004h0oooo0P00000:0?ooo`006P3oool2000004`0oooo0P00
00070?ooo`8000003`3oool3000004D0oooo0P00000S0?ooo`D0o`00903oool2000000L0oooo0P00
000?0?ooo`<00000C`3oool2000000X0oooo000J0?ooo`800000C03oool2000000L0oooo0P00000=
0?ooo`@00000AP3oool300000200oooo1@3o000V0?ooo`8000001`3oool2000000d0oooo1000001@
0?ooo`8000002P3oool001X0oooo0P00001<0?ooo`8000001`3oool2000000X0oooo1P0000170?oo
o`8000007`3oool50?l002P0oooo0P0000070?ooo`8000002P3oool600000540oooo0P00000:0?oo
o`006P3oool2000004d0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0:0?ooo`<0
0000B@3oool2000001d0oooo1@3o000[0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool02P3oool3000005<0oooo0P00000:0?ooo`006P3oool2000004d0oooo0P0000050?ooo`800000
303oool00`000000oooo0?ooo`190?ooo`8000006`3oool50?l002d0oooo0P0000050?ooo`800000
303oool00`000000oooo0?ooo`1C0?ooo`8000002P3oool001X0oooo0P00001>0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`180?ooo`8000006@3o
ool50?l00300oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0<0?ooo`030000003o
ool0oooo0580oooo0P00000:0?ooo`005`3oool5000004h0oooo0P0000030?ooo`8000003P3oool6
000004D0oooo0P00000G0?ooo`D0o`00<P3oool2000000<0oooo0P00000>0?ooo`H00000C03oool5
000000X0oooo000I0?ooo`<00000D03oool300000140oooo1P0000140?ooo`8000005@3oool50?l0
03H0oooo0`00000A0?ooo`H00000C@3oool3000000X0oooo003:0?ooo`800000503oool40?l00:`0
oooo003:0?ooo`8000004P3oool40?l00:h0oooo003:0?ooo`<000003`3oool50?l00:l0oooo003:
0?ooo`8000003P3oool50?l00;40oooo003:0?ooo`800000303oool50?l00;<0oooo003:0?ooo`80
00002P3oool50?l00;D0oooo003:0?ooo`800000203oool50?l00;L0oooo003:0?ooo`8000001P3o
ool50?l00;T0oooo003:0?ooo`800000103oool50?l00;/0oooo003:0?ooo`8000000P3oool50?l0
0;d0oooo003:0?ooo`8000001@3o002o0?ooo`00bP3oool50?l00<40oooo00070?oool4000001@3o
003100000080oooo00070?oookl000001@3o003300000080oooo000A0?ooo`030000003oool0oooo
05X0oooo00<000000?ooo`3oool0D`3oool50?l000030?ooo`000000000005/0oooo00<000000?oo
o`3oool0FP3oool00`000000oooo0?ooo`090?ooo`00`P3oool50?l000<0oooo0P0000340?ooo`00
`03oool50?l000D0oooo0P0000340?ooo`00_P3oool50?l000L0oooo0P0000340?ooo`00_03oool5
0?l000T0oooo0P0000340?ooo`00^P3oool50?l000/0oooo0P0000340?ooo`00^03oool50?l000d0
oooo0P0000340?ooo`00]P3oool50?l000l0oooo0`0000330?ooo`00]03oool50?l00140oooo0P00
00340?ooo`00/P3oool50?l001<0oooo0P0000340?ooo`00/03oool50?l001D0oooo0P0000340?oo
o`00[P3oool50?l001L0oooo0P0000340?ooo`00[03oool50?l001T0oooo0P0000340?ooo`00ZP3o
ool50?l001/0oooo0P0000340?ooo`00403oool00`000?l0oooo0?ooo`2E0?ooo`D0o`007@3oool2
00000<@0oooo000@0?ooo`T0003oS@3oool50?l001l0oooo0P0000340?ooo`004@3oool?0000oh@0
oooo1@3o000Q0?ooo`800000a03oool001T0oooo60000?ma0?ooo`D0o`008`3oool300000<<0oooo
000P0?oooaT0003oI`3oool50?l002D0oooo0P0000340?ooo`00<@3oool?0000oeh0oooo1@3o000W
0?ooo`800000a03oool003T0oooo3`000?mD0?ooo`D0o`00:@3oool200000<@0oooo00100?ooo`l0
003oB`3oool50?l002/0oooo0P0000340?ooo`00B03oool?0000od40oooo1@3o000]0?ooo`800000
a03oool004l0oooo40000?lh0?ooo`@0o`00;`3oool200000<@0oooo001G0?ooo`d0003o<@3oool4
0?l00340oooo0P0000340?ooo`00G`3oool:0000obX0oooo1@3o000b0?ooo`800000a03oool006@0
oooo2P000?lS0?ooo`D0o`00=03oool300000<<0oooo001Y0?ooo`d0003o6P3oool40?l003H0oooo
0P0000340?ooo`00KP3oool@0000oa00oooo103o000h0?ooo`800000a03oool007H0oooo3P000?l8
0?ooo`D0o`00>@3oool200000<@0oooo001n0?ooo`/0003o1P3o000k0?ooo`800000a03oool008@0
oooo2P000?ll0?ooo`800000a03oool008D0oooo103o000:0000ocL0oooo0P0000340?ooo`00P`3o
ool50?l000H0oooo2P000?lb0?ooo`800000a03oool00800oooo1P3o000=0?ooo`T0003o;P3oool2
00000<@0oooo001n0?ooo`H0o`00503oool:0000obP0oooo0P0000340?ooo`00O03oool50?l001/0
oooo2`000?lS0?ooo`<00000``3oool007T0oooo1P3o000S0?ooo`X0003o7P3oool200000<@0oooo
001g0?ooo`H0o`00:P3oool90000o`/0oooo1P0000090?ooo`800000a03oool007D0oooo1@3o000b
0?ooo`P0003o2@3oool2000000/0oooo0P0000340?ooo`00L`3oool50?l003P0oooo20000?l50?oo
o`8000002`3oool200000<@0oooo001`0?ooo`H0o`00?P3oool80000o`030?ooo`000000000000/0
oooo0P0000340?ooo`00KP3oool60?l004@0oooo2@000?l90?ooo`800000a03oool006`0oooo1@3o
001;0?ooo`X0003o103oool200000<@0oooo001Z0?ooo`D0o`00CP3oool200000080oooo2@000?l2
00000<@0oooo001X0?ooo`D0o`00D03oool2000000L0oooo20000?o20?ooo`00I@3oool60?l00580
oooo0P00000;0?ooo`L0003o_`3oool006<0oooo1P3o001D0?ooo`8000002`3oool200000080oooo
1P000?nl0?ooo`00H@3oool50?l005L0oooo0P00000;0?ooo`8000001@3oool60000okT0oooo001O
0?ooo`D0o`00F@3oool2000000/0oooo0P0000080?ooo`H0003o]P3oool005d0oooo1@3o001K0?oo
o`8000002`3oool2000000/0oooo1`000?nb0?ooo`00FP3oool60?l005d0oooo0P00000;0?ooo`80
00003P3oool80000ojh0oooo001H0?ooo`H0o`00G`3oool2000000/0oooo0P00000B0?ooo`P0003o
ZP3oool005H0oooo1@3o001O0?ooo`D000002`3oool2000001H0oooo1`000?nW0?ooo`00E03oool5
0?l006<0oooo0`00000;0?ooo`8000006P3oool70000oj<0oooo001A0?ooo`H0o`00L`3oool30000
01`0oooo1`000?nP0?ooo`00C`3oool60?l007D0oooo0P00000Q0?ooo`H0003oW@3oool004`0oooo
1P3o001h0?ooo`800000903oool60000oiX0oooo001:0?ooo`H0o`00NP3oool2000002L0oooo1P00
0?nG0?ooo`00A`3oool60?l007d0oooo0P00000Z0?ooo`L0003oT`3oool004D0oooo1P3o001o0?oo
o`800000;@3oool70000oi00oooo00120?ooo`H0o`00PP3oool200000340oooo1P000?n=0?ooo`00
@03oool60?l008@0oooo0P00000d0?ooo`H0003oRP3oool003d0oooo1P3o00270?ooo`800000=`3o
ool60000ohL0oooo000j0?ooo`L0o`00R@3oool3000003T0oooo1P000?n40?ooo`00=`3oool70?l0
08`0oooo0P00000m0?ooo`H0003oP@3oool003@0oooo1`3o002?0?ooo`800000?`3oool60000ogl0
oooo000a0?ooo`L0o`00TP3oool200000480oooo1P000?ml0?ooo`00;P3oool70?l009D0oooo0P00
00140?ooo`H0003oNP3oool002/0oooo1`3o002H0?ooo`800000A`3oool60000ogL0oooo000X0?oo
o`L0o`00V`3oool2000004T0oooo1P000?me0?ooo`009P3oool60?l009h0oooo0P00001<0?ooo`H0
003oLP3oool002<0oooo1P3o002Q0?ooo`800000CP3oool60000og00oooo000P0?ooo`L0o`00X`3o
ool200000540oooo1P000?m]0?ooo`007@3oool70?l00:H0oooo0`00001B0?ooo`H0003oJ`3oool0
01T0oooo1`3o002Z0?ooo`800000EP3oool60000ofP0oooo000E0?ooo`P0o`00[@3oool2000005P0
oooo1P000?mV0?ooo`004@3oool80?l00;40oooo0P00001K0?ooo`H0003oH`3oool00140oooo103o
002e0?ooo`800000G@3oool60000of40oooo003:0?ooo`800000H03oool50000oel0oooo003:0?oo
o`800000HP3oool50000oed0oooo003:0?ooo`800000I03oool60000oeX0oooo003:0?ooo`800000
IP3oool60000oeP0oooo003:0?ooo`800000J@3oool50000oeH0oooo003:0?ooo`<00000JP3oool5
0000oe@0oooo002h0?ooo`X00000203oool2000006d0oooo1@000?mB0?ooo`00^@3oool9000000P0
oooo0P00001_0?ooo`D0003oD03oool00;X0oooo00<000000?ooo`3oool0103oool2000000L0oooo
0P00001a0?ooo`D0003oCP3oool00;/0oooo00<000000?ooo`3oool0303oool2000007<0oooo1@00
0?m<0?ooo`00_03oool00`000000oooo0?ooo`0;0?ooo`800000M@3oool50000odX0oooo002m0?oo
o`030000003oool0oooo00X0oooo0P00001g0?ooo`D0003oB03oool00;h0oooo00<000000?ooo`3o
ool02@3oool2000007T0oooo1@000?m60?ooo`00_P3oool00`000000oooo0?ooo`090?ooo`800000
N`3oool50000od@0oooo002o0?ooo`030000003oool0oooo00P0oooo1000001k0?ooo`D0003o@P3o
ool00<00oooo00<000000?ooo`3oool01`3oool2000007l0oooo10000?m10?ooo`00`03oool00`00
0000oooo0?ooo`070?ooo`800000P@3oool40000ocl0oooo00300?ooo`800000203oool200000880
oooo1@000?lm0?ooo`00^03oool00`000000oooo0?ooo`050?ooo`800000203oool2000008@0oooo
1@000?lk0?ooo`00^03oool00`000000oooo0?ooo`050?ooo`800000203oool2000008H0oooo1@00
0?li0?ooo`00^@3oool00`000000oooo0?ooo`020?ooo`@00000203oool2000008P0oooo1@000?lg
0?ooo`00^@3oool8000000T0oooo0P00002:0?ooo`@0003o=P3oool00;/0oooo1000000;0?ooo`80
0000S03oool40000oc@0oooo003:0?ooo`800000S@3oool50000oc80oooo003:0?ooo`<00000SP3o
ool40000oc40oooo003:0?ooo`800000T@3oool40000obl0oooo003:0?ooo`800000TP3oool50000
obd0oooo003:0?ooo`800000U03oool40000ob`0oooo003:0?ooo`800000UP3oool40000obX0oooo
003:0?ooo`800000U`3oool50000obP0oooo003:0?ooo`800000V@3oool40000obL0oooo003:0?oo
o`800000V`3oool40000obD0oooo003:0?ooo`800000W03oool40000ob@0oooo003:0?ooo`<00000
W@3oool40000ob80oooo003:0?ooo`800000W`3oool50000ob00oooo003:0?ooo`800000X@3oool4
0000oal0oooo003:0?ooo`800000X`3oool40000oad0oooo003:0?ooo`800000Y03oool40000oa`0
oooo003:0?ooo`800000YP3oool40000oaX0oooo003:0?ooo`800000Y`3oool50000oaP0oooo003:
0?ooo`800000Z@3oool40000oaL0oooo003:0?ooo`800000Z`3oool40000oaD0oooo003:0?ooo`80
0000[03oool50000oa<0oooo003:0?ooo`<00000[@3oool40000oa80oooo003:0?ooo`800000/03o
ool40000oa00oooo003:0?ooo`800000/@3oool50000o`h0oooo003:0?ooo`800000/`3oool40000
o`d0oooo003:0?ooo`800000]@3oool40000o`/0oooo003:0?ooo`800000]P3oool40000o`X0oooo
003:0?ooo`800000^03oool00`000?l0oooo0?ooo`090?ooo`00bP3oool200000<@0oooo003:0?oo
o`800000a03oool00<X0oooo0`0000330?ooo`00bP3oool200000<@0oooo003:0?ooo`800000a03o
ool00<X0oooo0P0000340?ooo`00bP3oool200000<@0oooo003:0?ooo`800000a03oool00?l0oooo
T@3oool00?l0ooooT@3oool00001\
\>"],
  ImageRangeCache->{{{0, 399}, {319, 0}} -> {-1.09522, -3.73345, 0.00539229, \
0.0209567}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[""], "Input"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Lf1 = 
      N[\[Integral]\_0\%1 Sqrt[1 + \(f1'\)[x]^2] \[DifferentialD]x, 
        3]\)], "Input"],

Cell[BoxData[
    \(1.9632851047756384343`2.9999999999999996\)], "Output"]
}, Open  ]],

Cell[BoxData[""], "Input"],

Cell[BoxData[""], "Input"],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Lf2 = 
      N[\[Integral]\_0\%1 Sqrt[1 + \(f2'\)[x]^2] \[DifferentialD]x, 
        3]\)], "Input"],

Cell[BoxData[
    \(1.4445891309315532683`2.9999999999999996\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Lf3 = 
      Re[N[\[Integral]\_0\%1 Sqrt[1 + \(f3'\)[x]^2] \[DifferentialD]x, 
          3]]\)], "Input"],

Cell[BoxData[
    \(2.0034971116273525086`3.0108528162560226\)], "Output"]
}, Open  ]],

Cell[BoxData[
    \(\(\(Lf3 = \ 2.0034971\)\(\[IndentingNewLine]\)
    \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(labelf1 = 
      Graphics[Text[
          StyleForm[Lf1, FontSize \[Rule] fontSize, 
            FontColor \[Rule] RGBColor[1, 0, 0]], {0.6, 
            f1[0.6] - 0.5}, {\(-1\), 1}]]\)\)\)], "Input"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(labelf2 = 
      Graphics[Text[
          StyleForm[Lf2, FontSize \[Rule] fontSize, 
            FontColor \[Rule] RGBColor[0, 0, 0]], {\(-0.6\), 
            f2[0.6] - 0.5}, {\(-1\), 1}]]\)], "Input"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(labelf3 = 
      Graphics[Text[
          StyleForm[Lf3, FontSize \[Rule] fontSize, 
            FontColor \[Rule] RGBColor[0, 0, 1]], {0.6, f3[0.6]}, {\(-1\), 
            1}]]\)], "Input"],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(funktionaleMitBL = 
      Show[funktionen, labelf1, labelf2, labelf3]\)\(\[IndentingNewLine]\)
    \)\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .8 
%%ImageSize: 400 320 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.447891 0.122527 [
[.02381 .43539 -17.6563 -31.75 ]
[.02381 .43539 17.6563 0 ]
[.2619 .43539 -27.4375 -31.75 ]
[.2619 .43539 27.4375 0 ]
[.7381 .43539 -18.3125 -31.75 ]
[.7381 .43539 18.3125 0 ]
[.97619 .43539 -8.53125 -31.75 ]
[.97619 .43539 8.53125 0 ]
[.4875 .08031 -35.3125 -15.875 ]
[.4875 .08031 0 15.875 ]
[.4875 .20284 -35.3125 -15.875 ]
[.4875 .20284 0 15.875 ]
[.4875 .32536 -35.3125 -15.875 ]
[.4875 .32536 0 15.875 ]
[.4875 .57042 -17.0625 -15.875 ]
[.4875 .57042 0 15.875 ]
[.4875 .69294 -17.0625 -15.875 ]
[.4875 .69294 0 15.875 ]
[ -0.003 -0.003 0 0 ]
[ 1.003 .803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .44789 m
.02381 .45414 L
s
gsave
.02381 .43539 -78.6563 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.2619 .44789 m
.2619 .45414 L
s
gsave
.2619 .43539 -88.4375 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.7381 .44789 m
.7381 .45414 L
s
gsave
.7381 .43539 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.97619 .44789 m
.97619 .45414 L
s
gsave
.97619 .43539 -69.5313 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.125 Mabswid
.07143 .44789 m
.07143 .45164 L
s
.11905 .44789 m
.11905 .45164 L
s
.16667 .44789 m
.16667 .45164 L
s
.21429 .44789 m
.21429 .45164 L
s
.30952 .44789 m
.30952 .45164 L
s
.35714 .44789 m
.35714 .45164 L
s
.40476 .44789 m
.40476 .45164 L
s
.45238 .44789 m
.45238 .45164 L
s
.54762 .44789 m
.54762 .45164 L
s
.59524 .44789 m
.59524 .45164 L
s
.64286 .44789 m
.64286 .45164 L
s
.69048 .44789 m
.69048 .45164 L
s
.78571 .44789 m
.78571 .45164 L
s
.83333 .44789 m
.83333 .45164 L
s
.88095 .44789 m
.88095 .45164 L
s
.92857 .44789 m
.92857 .45164 L
s
.006 w
0 .44789 m
1 .44789 L
s
.25 Mabswid
.5 .08031 m
.50625 .08031 L
s
gsave
.4875 .08031 -96.3125 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
1.000 setlinewidth
grestore
.5 .20284 m
.50625 .20284 L
s
gsave
.4875 .20284 -96.3125 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.5 .32536 m
.50625 .32536 L
s
gsave
.4875 .32536 -96.3125 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.5 .57042 m
.50625 .57042 L
s
gsave
.4875 .57042 -78.0625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.5 .69294 m
.50625 .69294 L
s
gsave
.4875 .69294 -78.0625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.125 Mabswid
.5 .10482 m
.50375 .10482 L
s
.5 .12932 m
.50375 .12932 L
s
.5 .15383 m
.50375 .15383 L
s
.5 .17833 m
.50375 .17833 L
s
.5 .22734 m
.50375 .22734 L
s
.5 .25185 m
.50375 .25185 L
s
.5 .27635 m
.50375 .27635 L
s
.5 .30086 m
.50375 .30086 L
s
.5 .34987 m
.50375 .34987 L
s
.5 .37437 m
.50375 .37437 L
s
.5 .39888 m
.50375 .39888 L
s
.5 .42339 m
.50375 .42339 L
s
.5 .4724 m
.50375 .4724 L
s
.5 .4969 m
.50375 .4969 L
s
.5 .52141 m
.50375 .52141 L
s
.5 .54591 m
.50375 .54591 L
s
.5 .59492 m
.50375 .59492 L
s
.5 .61943 m
.50375 .61943 L
s
.5 .64393 m
.50375 .64393 L
s
.5 .66844 m
.50375 .66844 L
s
.5 .05581 m
.50375 .05581 L
s
.5 .0313 m
.50375 .0313 L
s
.5 .00679 m
.50375 .00679 L
s
.5 .71745 m
.50375 .71745 L
s
.5 .74195 m
.50375 .74195 L
s
.5 .76646 m
.50375 .76646 L
s
.5 .79097 m
.50375 .79097 L
s
.006 w
.5 0 m
.5 .8 L
s
0 0 m
1 0 L
1 .8 L
0 .8 L
closepath
clip
newpath
1 0 0 r
.02381 .6541 m
.06244 .64269 L
.10458 .62879 L
.14415 .61444 L
.18221 .59956 L
.22272 .58266 L
.26171 .56546 L
.30316 .54633 L
.34309 .52719 L
.3815 .50825 L
.42237 .48767 L
.46172 .46757 L
.49955 .44812 L
.53984 .42741 L
.57861 .40762 L
.61984 .38687 L
.65954 .36731 L
.69774 .34903 L
.73838 .33028 L
.77751 .31303 L
.81909 .2957 L
.85916 .28009 L
.89771 .2662 L
.93871 .25273 L
.97619 .24169 L
s
0 0 0 r
.02381 .01905 m
.06244 .08467 L
.10458 .1475 L
.14415 .19865 L
.18221 .24107 L
.22272 .27935 L
.26171 .30991 L
.30316 .3361 L
.34309 .35563 L
.3815 .36956 L
.40134 .37502 L
.42237 .37958 L
.43178 .38124 L
.4419 .38276 L
.45139 .38394 L
.4602 .38484 L
.47031 .38564 L
.47564 .38597 L
.48134 .38624 L
.48394 .38634 L
.48676 .38644 L
.48925 .3865 L
.49187 .38656 L
.49424 .38659 L
.49559 .38661 L
.49685 .38662 L
.498 .38662 L
.49906 .38663 L
.50027 .38663 L
.50143 .38663 L
.50256 .38662 L
.50379 .38661 L
.50495 .3866 L
.50601 .38659 L
.50848 .38655 L
.51108 .3865 L
.51598 .38636 L
.52133 .38615 L
.53088 .38563 L
.53975 .38499 L
.56021 .38296 L
.5788 .38047 L
.61878 .37328 L
.65725 .36432 L
.69817 .35302 L
.73757 .34085 L
.77546 .32835 L
.8158 .31459 L
.85462 .30133 L
.8959 .28766 L
Mistroke
.93566 .27534 L
.9739 .26469 L
.97619 .2641 L
Mfstroke
0 0 1 r
.02381 .49297 m
.06244 .49678 L
.10458 .5013 L
.14415 .50593 L
.18221 .51075 L
.22272 .51634 L
.26171 .52218 L
.30316 .52893 L
.34309 .53602 L
.3815 .54342 L
.42237 .55198 L
.46172 .56095 L
.49955 .5703 L
.53984 .58111 L
.57861 .59241 L
.61984 .60548 L
.65954 .61918 L
.69774 .63349 L
.73838 .65002 L
.77751 .66734 L
.81909 .68736 L
.85916 .70838 L
.89771 .73035 L
.93871 .75575 L
.97619 .78095 L
s
0 g
gsave
.78571 .24826 -61 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
1.000 0.000 0.000 setrgbcolor
(1.96) show
1.000 setlinewidth
grestore
gsave
.21429 .26361 -61 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.44) show
1.000 setlinewidth
grestore
gsave
.78571 .67115 -61 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 1.000 setrgbcolor
(2.00) show
1.000 setlinewidth
grestore
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{400, 320},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0001@2000`400?l00000o`00003oo`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00bP3oool200000<@0oooo003:
0?ooo`800000a03oool00<X0oooo0P0000340?ooo`00bP3oool300000<<0oooo003:0?ooo`800000
a03oool00<X0oooo0P0000340?ooo`00bP3oool200000<@0oooo000A0?ooo`030000003oool0oooo
0;H0oooo0P0000340?ooo`004@3oool00`000000oooo0?ooo`2f0?ooo`800000a03oool00140oooo
0P00002g0?ooo`800000a03oool00180oooo0P00002f0?ooo`800000a03oool001<0oooo00<00000
0?ooo`3oool0]03oool200000<@0oooo000C0?ooo`800000]@3oool300000<<0oooo000D0?ooo`03
0000003oool0oooo0;<0oooo0P0000340?ooo`00503oool200000;@0oooo0P0000340?ooo`005@3o
ool200000;<0oooo0P0000340?ooo`005P3oool00`000000oooo0?ooo`2a0?ooo`800000a03oool0
01H0oooo0P00002b0?ooo`800000a03oool001L0oooo00<000000?ooo`3oool0/03oool200000<@0
oooo000G0?ooo`800000/@3oool200000<@0oooo000H0?ooo`800000/03oool200000<@0oooo000I
0?ooo`030000003oool0oooo0:h0oooo0P0000340?ooo`006@3oool200000:l0oooo0`0000330?oo
o`006P3oool00`000000oooo0?ooo`2]0?ooo`800000a03oool001X0oooo0P00002L0?ooo`L00000
2`3oool200000<@0oooo000K0?ooo`800000V`3oool3000000@0oooo00<000000?ooo`3oool0203o
ool200000<@0oooo000L0?ooo`030000003oool0oooo0:40oooo00<000000?ooo`3oool01`3oool2
00000<@0oooo000L0?ooo`800000XP3oool2000000P0oooo0P0000340?ooo`007@3oool00`000000
oooo0?ooo`2P0?ooo`800000203oool200000<@0oooo000M0?ooo`800000Q`3oool=000000d0oooo
0P0000080?ooo`800000a03oool001h0oooo0P0000260?ooo`d00000303oool3000000P0oooo0P00
00340?ooo`007`3oool00`000000oooo0?ooo`2L0?ooo`@00000203oool400000<80oooo000O0?oo
o`800000VP3oool6000000T0oooo0P0000340?ooo`00803oool00`000000oooo0?ooo`2J0?ooo`<0
00002P3oool200000<@0oooo000P0?ooo`800000W03oool2000000X0oooo0P0000340?ooo`008@3o
ool2000009`0oooo00<000000?ooo`3oool0203oool200000<@0oooo000R0?ooo`030000003oool0
oooo09X0oooo0P0000090?ooo`800000a03oool00280oooo0P00002D0?ooo`030000003oool0oooo
00@0oooo0P0000090?ooo`800000a03oool002<0oooo0P00002D0?ooo`030000003oool0oooo0080
oooo0`0000090?ooo`800000a03oool002@0oooo00<000000?ooo`3oool0TP3oool7000000X0oooo
0P0000340?ooo`00903oool2000009D0oooo1000000;0?ooo`800000a03oool002D0oooo0P00002S
0?ooo`<00000``3oool002H0oooo00<000000?ooo`3oool0X@3oool200000<@0oooo000V0?ooo`80
0000XP3oool200000<@0oooo000W0?ooo`800000X@3oool200000<@0oooo000X0?ooo`030000003o
ool0oooo09l0oooo0P0000340?ooo`00:03oool200000:00oooo0P0000340?ooo`00:@3oool20000
09l0oooo0P0000340?ooo`00:P3oool2000009h0oooo0P0000340?ooo`00:`3oool00`000000oooo
0?ooo`2L0?ooo`800000a03oool002/0oooo0P00002M0?ooo`800000a03oool002`0oooo0P00002L
0?ooo`<00000``3oool002d0oooo00<000000?ooo`3oool0VP3oool200000<@0oooo000]0?ooo`80
0000V`3oool200000<@0oooo000^0?ooo`800000VP3oool200000<@0oooo000_0?ooo`030000003o
ool0oooo09P0oooo0P0000340?ooo`00;`3oool2000009T0oooo0P0000340?ooo`00<03oool20000
09P0oooo0P0000340?ooo`00<@3oool00`000000oooo0?ooo`2F0?ooo`800000a03oool00340oooo
0P00002G0?ooo`800000a03oool00380oooo0P00002F0?ooo`<00000``3oool003<0oooo0P00002E
0?ooo`800000a03oool003@0oooo00<000000?ooo`3oool0T`3oool200000<@0oooo000d0?ooo`80
0000U03oool200000<@0oooo000e0?ooo`800000T`3oool200000<@0oooo000f0?ooo`800000TP3o
ool200000<@0oooo000g0?ooo`030000003oool0oooo0900oooo0P0000340?ooo`00=`3oool20000
0940oooo0P0000340?ooo`00>03oool200000900oooo0P0000340?ooo`00>@3oool2000008l0oooo
0P0000340?ooo`00>P3oool00`000000oooo0?ooo`2=0?ooo`<00000``3oool003X0oooo0P00002>
0?ooo`800000a03oool003/0oooo0P00001k0?ooo`X00000203oool200000<@0oooo000l0?ooo`80
0000N`3oool9000000P0oooo0P00001d0?ooo`H0o`001@3oool20?l000@0oooo103o000<0?ooo`D0
o`00:P3oool003d0oooo00<000000?ooo`3oool0NP3oool00`000000oooo0?ooo`040?ooo`800000
1`3oool2000007H0oooo0P3o00070?ooo`80o`001`3oool30?l000T0oooo0P3o00030?ooo`80o`00
:@3oool003d0oooo0P00001l0?ooo`030000003oool0oooo00`0oooo0P00001f0?ooo`80o`004P3o
ool20?l000L0oooo0P3o00050?ooo`80o`00:03oool003h0oooo0P00001l0?ooo`030000003oool0
oooo00/0oooo0P00001f0?ooo`80o`004`3oool20?l000H0oooo0P3o00060?ooo`030?l0003oool0
oooo02H0oooo000o0?ooo`800000I@3oool=000000X0oooo00<000000?ooo`3oool02P3oool20000
07H0oooo0P3o000D0?ooo`80o`00103oool20?l000L0oooo0P3o000W0?ooo`00@03oool2000006@0
oooo3@00000;0?ooo`030000003oool0oooo00T0oooo0P00001f0?ooo`80o`005@3oool20?l000<0
oooo0P3o00070?ooo`80o`009`3oool00400oooo0`00000N0?ooo`H000001@3oool2000000/0oooo
0P00000;0?ooo`800000=P3oool00`000000oooo0?ooo`090?ooo`@00000M03oool20?l00100oooo
1@3o00000`3oool0o`000?ooo`020?ooo`80o`001`3oool20?l002L0oooo00110?ooo`<000007`3o
ool2000000L0oooo0P00000;0?ooo`8000002`3oool2000003L0oooo00<000000?ooo`3oool0203o
ool2000007H0oooo0P3o000>0?ooo`<0o`00103oool30?l00080oooo0P3o00070?ooo`80o`009`3o
ool00480oooo0`00000N0?ooo`800000503oool2000000/0oooo0P00000h0?ooo`030000003oool0
oooo00L0oooo0P00001f0?ooo`80o`003P3oool20?l000H0oooo0P3o00020?ooo`80o`001P3oool2
0?l002P0oooo00130?ooo`<000007@3oool2000001@0oooo0P00000;0?ooo`800000>03oool00`00
0000oooo0?ooo`070?ooo`800000MP3oool20?l000d0oooo0P3o00070?ooo`80o`000P3oool40?l0
00<0oooo0`3o000X0?ooo`00A03oool3000001`0oooo0P00000=0?ooo`/000000P3oool;000003H0
oooo0P0000080?ooo`800000MP3oool20?l000d0oooo0P3o00070?ooo`80o`000`3oool20?l00003
0?ooo`3o0000o`000080o`00:P3oool004D0oooo0`00000K0?ooo`8000003@3oool00`000000oooo
0?ooo`040?ooo`800000103oool00`000000oooo0?ooo`040?ooo`800000<03oool00`000000oooo
0?ooo`050?ooo`800000203oool2000007H0oooo0P3o000=0?ooo`80o`001`3oool20?l000<0oooo
0P3o000_0?ooo`00AP3oool2000001/0oooo0P00000>0?ooo`030000003oool0oooo00<0oooo0P00
00050?ooo`030000003oool0oooo00<0oooo0P00000`0?ooo`030000003oool0oooo00D0oooo0P00
00080?ooo`800000MP3oool20?l000d0oooo0P3o00070?ooo`80o`00103oool20?l002h0oooo0017
0?ooo`8000006P3oool2000000l0oooo00<000000?ooo`3oool00P3oool2000000H0oooo00<00000
0?ooo`3oool00P3oool200000340oooo00<000000?ooo`3oool00P3oool4000000P0oooo0P00001f
0?ooo`80o`003@3oool20?l000H0oooo0P3o00060?ooo`80o`00;@3oool004L0oooo0`00000I0?oo
o`8000003`3oool00`000000oooo0?ooo`020?ooo`8000001P3oool00`000000oooo0?ooo`020?oo
o`800000<@3oool8000000T0oooo0P00001f0?ooo`80o`003P3oool20?l000D0oooo0P3o00070?oo
o`80o`00;03oool004P0oooo0`00000H0?ooo`800000403oool010000000oooo0?ooo`3oool20000
00L0oooo00@000000?ooo`3oool0oooo0P00000c0?ooo`@000002`3oool2000007<0oooo1@3o000?
0?ooo`80o`000`3oool20?l000T0oooo0`3o000Z0?ooo`00B@3oool3000001L0oooo0P00000A0?oo
o`030000003oool0oooo00800000203oool00`000000oooo0?ooo`0200000480oooo0`00001d0?oo
o`<0o`00403oool50?l000`0oooo103o000W0?ooo`00BP3oool3000001H0oooo0P00000A0?ooo`03
0000003oool0oooo00800000203oool00`000000oooo0?ooo`0200000480oooo0P0000340?ooo`00
B`3oool3000001D0oooo0P00000B0?ooo`040000003oool00000000000T0oooo00@000000?ooo`00
00000000@P3oool200000<@0oooo001<0?ooo`<00000503oool200000180oooo00@000000?ooo`00
000000002@3oool010000000oooo0000000000120?ooo`800000a03oool004d0oooo0`00000C0?oo
o`8000004`3oool3000000X0oooo0`0000120?ooo`800000^03oool00`3o0000oooo0?ooo`090?oo
o`00CP3oool3000000l0oooo1@00000D0?ooo`8000002`3oool200000480oooo0P00002e0?ooo`D0
o`002P3oool004l0oooo0`00000@0?ooo`<00000503oool2000000/0oooo0P0000120?ooo`800000
/P3oool70?l000/0oooo001@0?ooo`<00000M`3oool200000:l0oooo1`3o000>0?ooo`00D@3oool3
000007H0oooo0P00002/0?ooo`L0o`004@3oool00580oooo0`00001e0?ooo`<00000Z03oool70?l0
01@0oooo001C0?ooo`<00000M03oool200000:H0oooo1`3o000G0?ooo`00E03oool3000007<0oooo
0P00002S0?ooo`H0o`006`3oool005D0oooo1000001a0?ooo`800000X03oool60?l001h0oooo001F
0?ooo`@00000L03oool2000009d0oooo1P3o000Q0?ooo`00F03oool3000006l0oooo0P00002I0?oo
o`L0o`00503oool5000000/0oooo001I0?ooo`<00000KP3oool2000009H0oooo1`3o000C0?ooo`T0
00002`3oool005X0oooo0`00001]0?ooo`800000T`3oool70?l00180oooo2000000@0?ooo`00F`3o
ool3000006`0oooo0P00002@0?ooo`L0o`004@3oool8000001@0oooo001L0?ooo`<00000J`3oool2
000008d0oooo1`3o000A0?ooo`L00000603oool005d0oooo0`00001Z0?ooo`<00000R@3oool70?l0
0140oooo1`00000K0?ooo`00GP3oool3000006T0oooo0P0000270?ooo`L0o`004@3oool7000001h0
oooo001O0?ooo`<00000J03oool2000008D0oooo1P3o000A0?ooo`L000008@3oool00600oooo1000
001V0?ooo`800000PP3oool60?l00140oooo1`00000T0?ooo`00H@3oool4000006D0oooo0P000020
0?ooo`H0o`00403oool7000002L0oooo001S0?ooo`<00000I03oool2000007d0oooo1P3o000A0?oo
o`H00000:P3oool006@0oooo0`00001S0?ooo`800000N`3oool60?l00100oooo1P00000]0?ooo`00
I@3oool400000640oooo0P00001i0?ooo`D0o`00403oool7000002l0oooo001V0?ooo`@00000H03o
ool2000007H0oooo1P3o000@0?ooo`H00000<P3oool006P0oooo0`00001O0?ooo`<00000L`3oool6
0?l000l0oooo1P00000e0?ooo`00J@3oool3000005h0oooo0P00001b0?ooo`D0o`003`3oool70000
03L0oooo001Z0?ooo`@00000C@3oool6000000T0oooo0P00001`0?ooo`D0o`003P3oool7000003X0
oooo001[0?ooo`@00000CP3oool2000000/0oooo0P00001]0?ooo`H0o`003@3oool7000003d0oooo
001]0?ooo`@00000C03oool2000000/0oooo0P00001[0?ooo`H0o`00303oool700000400oooo001^
0?ooo`@00000B`3oool2000000/0oooo0P00001Y0?ooo`D0o`00303oool7000004<0oooo001`0?oo
o`@00000B@3oool2000000/0oooo0P00001V0?ooo`H0o`002`3oool7000004H0oooo001a0?ooo`@0
0000<@3oool=000000X0oooo0P00000;0?ooo`800000I03oool60?l000X0oooo1P00001:0?ooo`00
L`3oool4000002l0oooo3@00000:0?ooo`8000002`3oool200000680oooo1@3o000:0?ooo`H00000
C@3oool007@0oooo1@0000140?ooo`8000002`3oool200000600oooo1@3o00090?ooo`H00000D03o
ool007H0oooo100000130?ooo`8000002`3oool4000005/0oooo1P3o00070?ooo`L00000D`3oool0
07P0oooo100000110?ooo`8000002`3oool2000005/0oooo1P3o00060?ooo`L00000EP3oool007T0
oooo100000100?ooo`8000002`3oool2000005T0oooo1@3o00060?ooo`L00000F@3oool007/0oooo
1000000n0?ooo`8000002`3oool2000005L0oooo1@3o00050?ooo`L00000G03oool007`0oooo1@00
000l0?ooo`8000002`3oool2000005D0oooo1@3o00040?ooo`L00000G`3oool007h0oooo1@00000j
0?ooo`8000002`3oool200000580oooo1P3o00030?ooo`L00000HP3oool00800oooo1@00000h0?oo
o`8000002`3oool200000500oooo1P3o00020?ooo`L00000I@3oool00880oooo1@00000c0?ooo`D0
00002`3oool2000004h0oooo1@3o00020?ooo`L00000J03oool008@0oooo1@00000c0?ooo`<00000
2`3oool2000004`0oooo1@3o00000`3oool0000000000005000006/0oooo00260?ooo`D00000?`3o
ool3000004T0oooo1@3o0007000006h0oooo00280?ooo`D00000?@3oool2000004P0oooo103o0007
00000740oooo002:0?ooo`D00000>`3oool2000004H0oooo0P3o0008000007@0oooo002<0?ooo`H0
0000>03oool2000004<0oooo00<0o`000000000000001P00001h0?ooo`00SP3oool7000003D0oooo
0P0000100?ooo`P00000O03oool00940oooo1P00000c0?ooo`800000?03oool800000800oooo002D
0?ooo`H00000<03oool2000003T0oooo1`0000020?l00880oooo002F0?ooo`L00000;@3oool20000
03D0oooo1`0000040?l008@0oooo002I0?ooo`L00000:P3oool200000340oooo200000050?l008H0
oooo002L0?ooo`P000009P3oool2000002d0oooo200000020?ooo`D0o`00R03oool001P0oooo1P00
001=0?ooo`@000001`3oool2000000D0oooo1@00000N0?ooo`P000008P3oool3000002@0oooo3000
00040?ooo`D0o`005@3oool4000000L0oooo0P0000050?ooo`D00000D03oool6000000P0oooo000J
0?ooo`800000CP3oool2000000<0oooo0P0000050?ooo`800000103oool2000000@0oooo00<00000
0?ooo`3oool07`3oool8000001h0oooo0P00000M0?oooa0000001P3oool50?l001H0oooo0P000003
0?ooo`8000001@3oool2000000@0oooo0P0000040?ooo`030000003oool0oooo04l0oooo0P00000:
0?ooo`006P3oool2000004h0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0@0?oo
o`030000003oool0oooo0280oooo2000000J0?ooo`8000005P3oool?000000`0oooo1@3o000H0?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`1>0?oo
o`8000002P3oool001X0oooo0P00001=0?ooo`8000001@3oool200000180oooo00<000000?ooo`3o
ool09@3oool<00000180oooo0P00000>0?ooo`l000004P3oool50?l001T0oooo0P0000050?ooo`80
00004P3oool00`000000oooo0?ooo`1=0?ooo`8000002P3oool001X0oooo0P00001=0?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0403oool2000002X0oooo4P0000080?ooo`800000
1`3oool?000001L0oooo1@3o000K0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0
403oool2000004h0oooo0P00000:0?ooo`00103oool=000000T0oooo0P00000j0?ooo`d000001@3o
ool2000000L0oooo0P00000A0?ooo`800000<P3ooolR000001d0oooo1@3o000L0?ooo`8000001`3o
ool200000140oooo0P00001>0?ooo`8000002P3oool000@0oooo3@0000090?ooo`800000>P3oool=
000000D0oooo0P0000070?ooo`8000004@3oool2000003/0oooo4P00000R0?ooo`D0o`007P3oool2
000000L0oooo0P00000A0?ooo`800000CP3oool2000000X0oooo000J0?ooo`800000C03oool20000
00L0oooo0P00000A0?ooo`800000A03oool2000002L0oooo1@3o000P0?ooo`8000001`3oool20000
0140oooo0P00001>0?ooo`8000002P3oool001X0oooo0P00001<0?ooo`8000001`3oool200000100
oooo0`0000140?ooo`8000009@3oool50?l00280oooo0P0000070?ooo`800000403oool3000004h0
oooo0P00000:0?ooo`006P3oool2000004`0oooo0P0000070?ooo`8000003`3oool3000004D0oooo
0P00000S0?ooo`D0o`00903oool2000000L0oooo0P00000?0?ooo`<00000C`3oool2000000X0oooo
000J0?ooo`800000C03oool2000000L0oooo0P00000=0?ooo`@00000AP3oool300000200oooo1@3o
000V0?ooo`8000001`3oool2000000d0oooo1000001@0?ooo`8000002P3oool001X0oooo0P00001<
0?ooo`8000001`3oool2000000X0oooo1P0000170?ooo`8000007`3oool50?l002P0oooo0P000007
0?ooo`8000002P3oool600000540oooo0P00000:0?ooo`006P3oool2000004d0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`0:0?ooo`<00000B@3oool2000001d0oooo1@3o000[0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool02P3oool3000005<0oooo0P00000:0?oo
o`006P3oool2000004d0oooo0P0000050?ooo`800000303oool00`000000oooo0?ooo`190?ooo`80
00006`3oool50?l002d0oooo0P0000050?ooo`800000303oool00`000000oooo0?ooo`1C0?ooo`80
00002P3oool001X0oooo0P00001>0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`180?ooo`8000006@3oool50?l00300oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo0580oooo0P00000:0?ooo`005`3o
ool5000004h0oooo0P0000030?ooo`8000003P3oool6000004D0oooo0P00000G0?ooo`D0o`00<P3o
ool2000000<0oooo0P00000>0?ooo`H00000C03oool5000000X0oooo000I0?ooo`<00000D03oool3
00000140oooo1P0000140?ooo`8000005@3oool50?l003H0oooo0`00000A0?ooo`H00000C@3oool3
000000X0oooo003:0?ooo`800000503oool40?l00:`0oooo003:0?ooo`8000004P3oool40?l00:h0
oooo003:0?ooo`<000003`3oool50?l00:l0oooo003:0?ooo`8000003P3oool50?l00;40oooo003:
0?ooo`800000303oool50?l00;<0oooo003:0?ooo`8000002P3oool50?l00;D0oooo003:0?ooo`80
0000203oool50?l00;L0oooo003:0?ooo`8000001P3oool50?l00;T0oooo003:0?ooo`800000103o
ool50?l00;/0oooo003:0?ooo`8000000P3oool50?l00;d0oooo003:0?ooo`8000001@3o002o0?oo
o`00bP3oool50?l00<40oooo00070?oool4000001@3o003100000080oooo00070?oookl000001@3o
003300000080oooo000A0?ooo`030000003oool0oooo05X0oooo00<000000?ooo`3oool0D`3oool5
0?l000030?ooo`000000000005/0oooo00<000000?ooo`3oool0FP3oool00`000000oooo0?ooo`09
0?ooo`00`P3oool50?l000<0oooo0P0000340?ooo`00`03oool50?l000D0oooo0P0000340?ooo`00
_P3oool50?l000L0oooo0P0000340?ooo`00_03oool50?l000T0oooo0P0000340?ooo`00^P3oool5
0?l000/0oooo0P0000340?ooo`00^03oool50?l000d0oooo0P0000340?ooo`00]P3oool50?l000l0
oooo0`0000330?ooo`00]03oool50?l00140oooo0P0000340?ooo`00/P3oool50?l001<0oooo0P00
00340?ooo`00/03oool50?l001D0oooo0P0000340?ooo`00[P3oool50?l001L0oooo0P0000340?oo
o`00[03oool50?l001T0oooo0P0000340?ooo`00ZP3oool50?l001/0oooo0P0000340?ooo`00403o
ool00`000?l0oooo0?ooo`2E0?ooo`D0o`007@3oool200000<@0oooo000@0?ooo`T0003oS@3oool5
0?l001l0oooo0P0000340?ooo`004@3oool?0000oh@0oooo1@3o000Q0?ooo`800000a03oool001T0
oooo60000?ma0?ooo`D0o`008`3oool300000<<0oooo000P0?oooaT0003oI`3oool50?l002D0oooo
0P0000340?ooo`00<@3oool?0000oeh0oooo1@3o000W0?ooo`800000a03oool003T0oooo3`000?mD
0?ooo`D0o`00:@3oool200000<@0oooo00100?ooo`l0003oB`3oool50?l002/0oooo0P0000340?oo
o`00B03oool?0000od40oooo1@3o000]0?ooo`800000a03oool004l0oooo40000?lh0?ooo`@0o`00
;`3oool200000<@0oooo001G0?ooo`d0003o<@3oool40?l00340oooo0P0000340?ooo`00G`3oool:
0000obX0oooo1@3o000b0?ooo`800000a03oool006@0oooo2P000?lS0?ooo`D0o`00=03oool30000
0<<0oooo001Y0?ooo`d0003o6P3oool40?l003H0oooo0P0000340?ooo`00KP3oool@0000oa00oooo
103o000h0?ooo`800000a03oool007H0oooo3P000?l80?ooo`D0o`00>@3oool200000<@0oooo001n
0?ooo`/0003o1P3o000k0?ooo`800000a03oool008@0oooo2P000?ll0?ooo`800000a03oool008D0
oooo103o000:0000ocL0oooo0P0000340?ooo`00P`3oool50?l000H0oooo2P000?lb0?ooo`800000
a03oool00800oooo1P3o000=0?ooo`T0003o;P3oool200000<@0oooo001n0?ooo`H0o`00503oool:
0000obP0oooo0P0000340?ooo`00O03oool50?l001/0oooo2`000?lS0?ooo`<00000``3oool007T0
oooo1P3o000S0?ooo`X0003o7P3oool200000<@0oooo001g0?ooo`H0o`00:P3oool90000o`/0oooo
1P0000090?ooo`800000a03oool007D0oooo1@3o000b0?ooo`P0003o2@3oool2000000/0oooo0P00
00340?ooo`00L`3oool50?l003P0oooo20000?l50?ooo`8000002`3oool200000<@0oooo001`0?oo
o`H0o`00?P3oool80000o`030?ooo`000000000000/0oooo0P0000340?ooo`00KP3oool60?l004@0
oooo2@000?l90?ooo`800000a03oool006`0oooo1@3o001;0?ooo`X0003o103oool200000<@0oooo
001Z0?ooo`D0o`00CP3oool200000080oooo2@000?l200000<@0oooo001X0?ooo`D0o`00D03oool2
000000L0oooo20000?o20?ooo`00I@3oool60?l00580oooo0P00000;0?ooo`L0003o_`3oool006<0
oooo1P3o001D0?ooo`8000002`3oool200000080oooo1P000?nl0?ooo`00H@3oool50?l005L0oooo
0P00000;0?ooo`8000001@3oool60000okT0oooo001O0?ooo`D0o`00F@3oool2000000/0oooo0P00
00080?ooo`H0003o]P3oool005d0oooo1@3o001K0?ooo`8000002`3oool2000000/0oooo1`000?nb
0?ooo`00FP3oool60?l005d0oooo0P00000;0?ooo`8000003P3oool80000ojh0oooo001H0?ooo`H0
o`00G`3oool2000000/0oooo0P00000B0?ooo`P0003oZP3oool005H0oooo1@3o001O0?ooo`D00000
2`3oool2000001H0oooo1`000?nW0?ooo`00E03oool50?l006<0oooo0`00000;0?ooo`8000006P3o
ool70000oj<0oooo001A0?ooo`H0o`00L`3oool3000001`0oooo1`000?nP0?ooo`00C`3oool60?l0
07D0oooo0P00000Q0?ooo`H0003oW@3oool004`0oooo1P3o001h0?ooo`800000903oool60000oiX0
oooo001:0?ooo`H0o`00NP3oool2000002L0oooo1P000?nG0?ooo`00A`3oool60?l007d0oooo0P00
000Z0?ooo`L0003oT`3oool004D0oooo1P3o001o0?ooo`800000;@3oool70000oi00oooo00120?oo
o`H0o`00PP3oool200000340oooo1P000?lj0?ooo`X0003o103oool20000o`L0oooo10000?l90?oo
o`@0003o:`3oool00400oooo1P3o00240?ooo`800000=03oool60000ocP0oooo2@000?l40?ooo`80
003o1P3oool20000o`<0oooo0P000?l60?ooo`80003o0`3oool20000obT0oooo000m0?ooo`H0o`00
Q`3oool2000003L0oooo1P000?lf0?ooo`030000o`3oool0oooo00@0oooo0P000?l;0?ooo`030000
o`3oool0oooo00<0oooo00<0003o0?ooo`3oool0103oool00`000?l0oooo0?ooo`030?ooo`030000
o`3oool0oooo02L0oooo000j0?ooo`L0o`00R@3oool3000003T0oooo1P000?ld0?ooo`030000o`3o
ool0oooo00l0oooo0P000?l50?ooo`80003o103oool20000o`D0oooo0P000?lX0?ooo`00=`3oool7
0?l008`0oooo0P00000m0?ooo`H0003o<P3oool00`000?l0oooo0?ooo`0>0?ooo`030000o`3oool0
oooo00D0oooo00<0003o0?ooo`3oool00P3oool00`000?l0oooo0?ooo`050?ooo`030000o`3oool0
oooo02H0oooo000d0?ooo`L0o`00S`3oool2000003l0oooo1P000?la0?ooo`030000o`3oool0oooo
00`0oooo0P000?l70?ooo`80003o0P3oool20000o`L0oooo0P000?lW0?ooo`00<@3oool70?l00980
oooo0P0000120?ooo`H0003o;`3oool00`000?l0oooo0?ooo`0;0?ooo`80003o1`3oool20000o`80
oooo0P000?l70?ooo`80003o9`3oool002h0oooo1`3o002E0?ooo`800000A03oool60000obd0oooo
00<0003o0?ooo`3oool02`3oool20000o`L0oooo0P000?l20?ooo`80003o1`3oool20000obL0oooo
000[0?ooo`L0o`00V03oool2000004L0oooo1P000?l[0?ooo`030000o`3oool0oooo00X0oooo0P00
0?l70?ooo`80003o0P3oool20000o`L0oooo0P000?lW0?ooo`00:03oool70?l009/0oooo0P000019
0?ooo`H0003o:P3oool00`000?l0oooo0?ooo`090?ooo`80003o1`3oool20000o`80oooo0P000?l7
0?ooo`80003o9`3oool002H0oooo1P3o002N0?ooo`800000C03oool60000obL0oooo00<0003o0?oo
o`3oool02@3oool20000o`L0oooo0P000?l20?ooo`80003o1`3oool20000obL0oooo000S0?ooo`H0
o`00X@3oool2000004h0oooo1P000?lU0?ooo`80003o2P3oool20000o`L0oooo0P000?l20?ooo`80
003o1`3oool20000obL0oooo000P0?ooo`L0o`00X`3oool200000540oooo1P000?lJ0?ooo`030000
o`3oool0oooo00D0oooo0P000?l;0?ooo`030000o`3oool0oooo00D0oooo00<0003o0?ooo`3oool0
0P3oool00`000?l0oooo0?ooo`050?ooo`030000o`3oool0oooo02H0oooo000M0?ooo`L0o`00YP3o
ool300000580oooo1P000?lH0?ooo`030000o`3oool0oooo00D0oooo0P000?l;0?ooo`80003o1@3o
ool20000o`@0oooo0P000?l50?ooo`80003o:03oool001T0oooo1`3o002Z0?ooo`800000EP3oool6
0000oaH0oooo00<0003o0?ooo`3oool00P3oool40000o``0oooo00<0003o0?ooo`3oool00`3oool0
0`000?l0oooo0?ooo`040?ooo`030000o`3oool0oooo00<0oooo00<0003o0?ooo`3oool09`3oool0
01D0oooo203o002]0?ooo`800000F03oool60000oa@0oooo20000?l=0?ooo`80003o0`3oool20000
o`H0oooo0P000?l30?ooo`80003o:@3oool00140oooo203o002a0?ooo`800000F`3oool60000oa<0
oooo10000?lA0?ooo`<0003o2P3oool30000ob/0oooo000A0?ooo`@0o`00]@3oool2000005d0oooo
1P000?mQ0?ooo`00bP3oool200000600oooo1@000?mO0?ooo`00bP3oool200000680oooo1@000?mM
0?ooo`00bP3oool2000006@0oooo1P000?mJ0?ooo`00bP3oool2000006H0oooo1P000?mH0?ooo`00
bP3oool2000006T0oooo1@000?mF0?ooo`00bP3oool3000006X0oooo1@000?mD0?ooo`00^03oool:
000000P0oooo0P00001]0?ooo`D0003oDP3oool00;T0oooo2@0000080?ooo`800000K`3oool50000
oe00oooo002j0?ooo`030000003oool0oooo00@0oooo0P0000070?ooo`800000L@3oool50000odh0
oooo002k0?ooo`030000003oool0oooo00`0oooo0P00001c0?ooo`D0003oC03oool00;`0oooo00<0
00000?ooo`3oool02`3oool2000007D0oooo1@000?m:0?ooo`00_@3oool00`000000oooo0?ooo`0:
0?ooo`800000M`3oool50000odP0oooo002n0?ooo`030000003oool0oooo00T0oooo0P00001i0?oo
o`D0003oAP3oool00;h0oooo00<000000?ooo`3oool02@3oool2000007/0oooo1@000?m40?ooo`00
_`3oool00`000000oooo0?ooo`080?ooo`@00000N`3oool50000od80oooo00300?ooo`030000003o
ool0oooo00L0oooo0P00001o0?ooo`@0003o@@3oool00<00oooo00<000000?ooo`3oool01`3oool2
00000840oooo10000?lo0?ooo`00`03oool2000000P0oooo0P0000220?ooo`D0003o?@3oool00;P0
oooo00<000000?ooo`3oool01@3oool2000000P0oooo0P0000240?ooo`D0003o>`3oool00;P0oooo
00<000000?ooo`3oool01@3oool2000000P0oooo0P0000260?ooo`D0003o>@3oool00;T0oooo00<0
00000?ooo`3oool00P3oool4000000P0oooo0P0000280?ooo`D0003o=`3oool00;T0oooo20000009
0?ooo`800000RP3oool40000ocH0oooo002k0?ooo`@000002`3oool2000008`0oooo10000?ld0?oo
o`00bP3oool2000008d0oooo1@000?lb0?ooo`00bP3oool3000008h0oooo10000?la0?ooo`00bP3o
ool200000940oooo10000?l_0?ooo`00bP3oool200000980oooo1@000?l]0?ooo`00bP3oool20000
09@0oooo10000?l/0?ooo`00bP3oool2000009H0oooo10000?lZ0?ooo`00bP3oool2000009L0oooo
1@000?lX0?ooo`00bP3oool2000009T0oooo10000?lW0?ooo`00bP3oool2000009/0oooo10000?lU
0?ooo`00bP3oool2000009`0oooo10000?lT0?ooo`00bP3oool3000009d0oooo10000?lR0?ooo`00
bP3oool2000009l0oooo1@000?lP0?ooo`00bP3oool200000:40oooo10000?lO0?ooo`00bP3oool2
00000:<0oooo10000?lM0?ooo`00bP3oool200000:@0oooo10000?lL0?ooo`00bP3oool200000:H0
oooo10000?lJ0?ooo`00bP3oool200000:L0oooo1@000?lH0?ooo`00bP3oool200000:T0oooo1000
0?lG0?ooo`00bP3oool200000:/0oooo10000?lE0?ooo`00bP3oool200000:`0oooo1@000?lC0?oo
o`00bP3oool300000:d0oooo10000?lB0?ooo`00bP3oool200000;00oooo10000?l@0?ooo`00bP3o
ool200000;40oooo1@000?l>0?ooo`00bP3oool200000;<0oooo10000?l=0?ooo`00bP3oool20000
0;D0oooo10000?l;0?ooo`00bP3oool200000;H0oooo10000?l:0?ooo`00bP3oool200000;P0oooo
00<0003o0?ooo`3oool02@3oool00<X0oooo0P0000340?ooo`00bP3oool200000<@0oooo003:0?oo
o`<00000``3oool00<X0oooo0P0000340?ooo`00bP3oool200000<@0oooo003:0?ooo`800000a03o
ool00<X0oooo0P0000340?ooo`00bP3oool200000<@0oooo003o0?oooi40oooo003o0?oooi40oooo
0000\
\>"],
  ImageRangeCache->{{{0, 399}, {319, 0}} -> {-1.09522, -3.73345, 0.00539229, \
0.0209567}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<G:\Robert\Vorlesungen\Variationsrechnung\Pr\[ADoubleDot]\
sentation\FunktionaleMitBL.png\>", funktionaleMitBL, \ 
      ImageSize \[Rule] 400]\)], "Input"],

Cell[BoxData[
    \("G:\\Robert\\Vorlesungen\\Variationsrechnung\\Pr\[ADoubleDot]sentation\\\
FunktionaleMitBL.png"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"funktion", "=", 
      RowBox[{"Plot", "[", 
        RowBox[{\({f4[x]}\), ",", \({x, \(-1\), 1}\), ",", 
          RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"{", 
              RowBox[{
                FormBox["Thickness",
                  "TraditionalForm"], "[", "0.006", "]"}], "}"}]}], ",", 
          RowBox[{"PlotStyle", "\[Rule]", " ", 
            RowBox[{"{", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{
                      StyleBox["RGBColor",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      RowBox[{
                        StyleBox["1",
                          "MR"], 
                        StyleBox[",",
                          "MR"], " ", "0", 
                        StyleBox[",",
                          "MR"], " ", "0"}], 
                      StyleBox["]",
                        "MR"]}], 
                    StyleBox[",",
                      "MR"], 
                    RowBox[{
                      FormBox["Thickness",
                        "TraditionalForm"], "[", "0.006", "]"}]}], 
                  StyleBox["}",
                    "MR"]}], 
                StyleBox[",",
                  "MR"], 
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{
                      StyleBox["RGBColor",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      RowBox[{
                        StyleBox["0",
                          "MR"], 
                        StyleBox[",",
                          "MR"], " ", "0", 
                        StyleBox[",",
                          "MR"], 
                        StyleBox["0",
                          "MR"]}], 
                      StyleBox["]",
                        "MR"]}], 
                    StyleBox[",",
                      "MR"], 
                    RowBox[{
                      FormBox["Thickness",
                        "TraditionalForm"], "[", "0.006", "]"}]}], 
                  StyleBox["}",
                    "MR"]}], 
                StyleBox[",",
                  "MR"], 
                StyleBox[
                  RowBox[{"{", 
                    RowBox[{\(RGBColor[0, 0, 1]\), ",", 
                      RowBox[{
                        FormBox["Thickness",
                          "TraditionalForm"], "[", "0.006", "]"}]}], "}"}],
                  "MR"], 
                StyleBox[",",
                  "MR"]}], "}"}]}], ",", " ", \(ImageSize \[Rule] 400\), ",", 
          " ", \(AspectRatio \[Rule] 0.8\), 
          ",", \(TextStyle \[Rule] {FontFamily \[Rule] "\<Times\>", 
              FontSize \[Rule] fontSize}\)}], "]"}]}]], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .8 
%%ImageSize: 400 320 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.0190476 0.17698 [
[.02381 .00655 -17.6563 -31.75 ]
[.02381 .00655 17.6563 0 ]
[.2619 .00655 -27.4375 -31.75 ]
[.2619 .00655 27.4375 0 ]
[.7381 .00655 -18.3125 -31.75 ]
[.7381 .00655 18.3125 0 ]
[.97619 .00655 -8.53125 -31.75 ]
[.97619 .00655 8.53125 0 ]
[.4875 .19603 -17.0625 -15.875 ]
[.4875 .19603 0 15.875 ]
[.4875 .37301 -17.0625 -15.875 ]
[.4875 .37301 0 15.875 ]
[.4875 .54999 -17.0625 -15.875 ]
[.4875 .54999 0 15.875 ]
[.4875 .72697 -17.0625 -15.875 ]
[.4875 .72697 0 15.875 ]
[ -0.003 -0.003 0 0 ]
[ 1.003 .803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .01905 m
.02381 .0253 L
s
gsave
.02381 .00655 -78.6563 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.2619 .01905 m
.2619 .0253 L
s
gsave
.2619 .00655 -88.4375 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.7381 .01905 m
.7381 .0253 L
s
gsave
.7381 .00655 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.97619 .01905 m
.97619 .0253 L
s
gsave
.97619 .00655 -69.5313 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.125 Mabswid
.07143 .01905 m
.07143 .0228 L
s
.11905 .01905 m
.11905 .0228 L
s
.16667 .01905 m
.16667 .0228 L
s
.21429 .01905 m
.21429 .0228 L
s
.30952 .01905 m
.30952 .0228 L
s
.35714 .01905 m
.35714 .0228 L
s
.40476 .01905 m
.40476 .0228 L
s
.45238 .01905 m
.45238 .0228 L
s
.54762 .01905 m
.54762 .0228 L
s
.59524 .01905 m
.59524 .0228 L
s
.64286 .01905 m
.64286 .0228 L
s
.69048 .01905 m
.69048 .0228 L
s
.78571 .01905 m
.78571 .0228 L
s
.83333 .01905 m
.83333 .0228 L
s
.88095 .01905 m
.88095 .0228 L
s
.92857 .01905 m
.92857 .0228 L
s
.006 w
0 .01905 m
1 .01905 L
s
.25 Mabswid
.5 .19603 m
.50625 .19603 L
s
gsave
.4875 .19603 -78.0625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.5 .37301 m
.50625 .37301 L
s
gsave
.4875 .37301 -78.0625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.5 .54999 m
.50625 .54999 L
s
gsave
.4875 .54999 -78.0625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
1.000 setlinewidth
grestore
.5 .72697 m
.50625 .72697 L
s
gsave
.4875 .72697 -78.0625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(4) show
1.000 setlinewidth
grestore
.125 Mabswid
.5 .05444 m
.50375 .05444 L
s
.5 .08984 m
.50375 .08984 L
s
.5 .12524 m
.50375 .12524 L
s
.5 .16063 m
.50375 .16063 L
s
.5 .23142 m
.50375 .23142 L
s
.5 .26682 m
.50375 .26682 L
s
.5 .30222 m
.50375 .30222 L
s
.5 .33761 m
.50375 .33761 L
s
.5 .4084 m
.50375 .4084 L
s
.5 .4438 m
.50375 .4438 L
s
.5 .4792 m
.50375 .4792 L
s
.5 .51459 m
.50375 .51459 L
s
.5 .58538 m
.50375 .58538 L
s
.5 .62078 m
.50375 .62078 L
s
.5 .65618 m
.50375 .65618 L
s
.5 .69157 m
.50375 .69157 L
s
.5 .76236 m
.50375 .76236 L
s
.5 .79776 m
.50375 .79776 L
s
.006 w
.5 0 m
.5 .8 L
s
0 0 m
1 0 L
1 .8 L
0 .8 L
closepath
clip
newpath
1 0 0 r
.02381 .37301 m
.06244 .28386 L
.08255 .24611 L
.10458 .2112 L
.1253 .18422 L
.14415 .16439 L
.16372 .14833 L
.17461 .14131 L
.18466 .13601 L
.19395 .13208 L
.20381 .12892 L
.20891 .12767 L
.2137 .12675 L
.21895 .126 L
.22189 .12569 L
.22328 .12558 L
.22459 .12549 L
.22579 .12542 L
.22709 .12537 L
.22827 .12533 L
.22936 .1253 L
.23053 .12529 L
.23183 .12529 L
.23248 .1253 L
.23318 .12531 L
.23444 .12534 L
.23561 .12539 L
.23689 .12545 L
.23922 .1256 L
.24148 .1258 L
.24358 .12602 L
.24835 .12668 L
.25362 .12765 L
.2643 .13035 L
.27439 .1338 L
.28365 .1377 L
.3045 .14894 L
.34413 .17887 L
.38223 .21679 L
.4228 .26515 L
.46184 .31769 L
.50334 .37798 L
.54332 .43847 L
.58179 .49712 L
.62271 .55809 L
.66211 .61357 L
.7 .66221 L
.74034 .70712 L
.77916 .74187 L
.80033 .75669 L
Mistroke
.82044 .76774 L
.83005 .77191 L
.84028 .77551 L
.84526 .77695 L
.84994 .77811 L
.85446 .77904 L
.85868 .77975 L
.86335 .78034 L
.86582 .78058 L
.86847 .78077 L
.8698 .78084 L
.8705 .78087 L
.87125 .7809 L
.8719 .78091 L
.87261 .78093 L
.87388 .78095 L
.8751 .78095 L
.87642 .78094 L
.87766 .78091 L
.8788 .78087 L
.87988 .78083 L
.88103 .78076 L
.88311 .78062 L
.88557 .78039 L
.88781 .78013 L
.89269 .7794 L
.89728 .77849 L
.90703 .77584 L
.91734 .77196 L
.9358 .76214 L
.95542 .74748 L
.97374 .72966 L
.97619 .72697 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{400, 320},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0001@2000`400?l00000o`00003oo`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`009P3oool6000004H0oooo1000
00070?ooo`8000001@3oool5000008`0oooo100000070?ooo`8000001@3oool5000004P0oooo1P00
000F0?ooo`00:03oool2000004L0oooo0P0000030?ooo`8000001@3oool2000000@0oooo0P000004
0?ooo`030000003oool0oooo08P0oooo0P0000030?ooo`8000001@3oool2000000@0oooo0P000004
0?ooo`030000003oool0oooo04L0oooo0P00000H0?ooo`00:03oool2000004L0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo08L0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo04H0oooo0P00000H0?oo
o`00:03oool2000004H0oooo0P0000050?ooo`8000004P3oool00`000000oooo0?ooo`250?ooo`80
00001@3oool200000180oooo00<000000?ooo`3oool0A@3oool2000001P0oooo000X0?ooo`800000
AP3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0100oooo0P0000260?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0403oool2000004H0oooo0P00000H0?ooo`004P3o
ool=000000T0oooo0P00000d0?ooo`d00000103oool2000000L0oooo0P00000A0?ooo`800000Q@3o
ool2000000L0oooo0P00000A0?ooo`800000AP3oool2000001P0oooo000B0?ooo`d000002@3oool2
000003@0oooo3@0000040?ooo`8000001`3oool200000140oooo0P0000250?ooo`8000001`3oool2
00000140oooo0P0000160?ooo`800000603oool002P0oooo0P0000150?ooo`8000001`3oool20000
0140oooo0P0000250?ooo`8000001`3oool200000140oooo0P0000160?ooo`800000603oool002P0
oooo0P0000150?ooo`8000001`3oool200000100oooo0`0000250?ooo`8000001`3oool200000100
oooo0`0000160?ooo`800000603oool002P0oooo0P0000150?ooo`8000001`3oool2000000l0oooo
0`0000260?ooo`8000001`3oool2000000l0oooo0`0000170?ooo`800000603oool002P0oooo0P00
00150?ooo`8000001`3oool2000000d0oooo100000270?ooo`8000001`3oool2000000d0oooo1000
00180?ooo`800000603oool002P0oooo0P0000150?ooo`8000001`3oool2000000X0oooo1P000028
0?ooo`8000001`3oool2000000X0oooo1P0000190?ooo`800000603oool002P0oooo0P0000160?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool02P3oool3000008/0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`0:0?ooo`<00000B`3oool2000001P0oooo000X0?ooo`80
0000AP3oool2000000D0oooo0P00000<0?ooo`030000003oool0oooo08/0oooo0P0000050?ooo`80
0000303oool00`000000oooo0?ooo`1;0?ooo`800000603oool002P0oooo0P0000170?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`2;0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`1:0?ooo`800000
603oool002D0oooo1@0000170?ooo`8000000`3oool2000000h0oooo1P0000280?ooo`8000000`3o
ool2000000h0oooo1P0000140?ooo`D00000603oool002L0oooo0`0000190?ooo`<000004@3oool6
000008T0oooo0`00000A0?ooo`H00000A@3oool3000001P0oooo003o0?oooi40oooo003o0?oooi40
oooo003o0?oooi40oooo003o0?oooi40oooo003:0?ooo`800000a03oool00<X0oooo0P0000340?oo
o`00bP3oool200000<@0oooo003:0?ooo`800000a03oool00<X0oooo0P0000340?ooo`00bP3oool2
00000<@0oooo003:0?ooo`800000a03oool001H0ooooo`00001[00000100oooo000F0?ooool00000
J`00000@0?ooo`007`3oool00`000000oooo0?ooo`1C0?ooo`030000003oool0oooo0580oooo0P00
001E0?ooo`030000003oool0oooo05<0oooo00<000000?ooo`3oool05P3oool00<X0oooo0P000034
0?ooo`00bP3oool200000<@0oooo003:0?ooo`800000a03oool00<X0oooo0P0000340?ooo`00bP3o
ool200000<@0oooo003:0?ooo`800000a03oool00<X0oooo0P0000340?ooo`00bP3oool200000<@0
oooo003:0?ooo`800000a03oool00<X0oooo0P0000340?ooo`00bP3oool300000<<0oooo003:0?oo
o`800000a03oool00<X0oooo0P0000340?ooo`00bP3oool200000<@0oooo003:0?ooo`800000a03o
ool00<X0oooo0P0000340?ooo`00bP3oool200000<@0oooo003:0?ooo`800000a03oool00<X0oooo
0P0000340?ooo`00bP3oool200000<@0oooo003:0?ooo`800000a03oool00<X0oooo0P0000340?oo
o`00bP3oool300000<<0oooo003:0?ooo`800000a03oool00<X0oooo0P0000340?ooo`00bP3oool2
00000<@0oooo003:0?ooo`800000a03oool00<X0oooo0P0000340?ooo`00bP3oool200000<@0oooo
003:0?ooo`800000a03oool00<X0oooo0P0000340?ooo`00bP3oool200000<@0oooo003:0?ooo`80
0000a03oool00<X0oooo0P0000340?ooo`00bP3oool200000<@0oooo001T0?ooo`d0o`00F@3oool3
00000<<0oooo001N0?oooaP0o`00E03oool200000<@0oooo001M0?ooo`P0o`002`3oool:0?l00500
oooo0P0000340?ooo`00F@3oool60?l001L0oooo1P3o001>0?ooo`800000a03oool005L0oooo1P3o
000M0?ooo`@0o`00C03oool200000<@0oooo001F0?ooo`@0o`008@3oool50?l004X0oooo0P000034
0?ooo`00E03oool40?l002D0oooo103o00190?ooo`800000a03oool00580oooo1@3o000X0?ooo`@0
o`00A`3oool200000<@0oooo001A0?ooo`@0o`00:`3oool50?l004D0oooo0P0000340?ooo`00D03o
ool30?l002l0oooo103o00140?ooo`800000a03oool004h0oooo103o000b0?ooo`@0o`00@P3oool2
00000<@0oooo001=0?ooo`@0o`00=03oool40?l00440oooo0P0000340?ooo`00C03oool30?l003P0
oooo103o000o0?ooo`800000a03oool004/0oooo0`3o000j0?ooo`@0o`00?P3oool300000<<0oooo
001:0?ooo`<0o`00?@3oool40?l003`0oooo0P0000340?ooo`00B@3oool30?l003l0oooo103o000k
0?ooo`800000a03oool004P0oooo0`3o00120?ooo`@0o`00>@3oool200000<@0oooo00170?ooo`<0
o`00A03oool40?l003P0oooo0P0000340?ooo`00AP3oool30?l004L0oooo103o000W0?ooo`H00000
2@3oool200000<@0oooo00150?ooo`<0o`00B@3oool40?l002P0oooo0P00000;0?ooo`800000a03o
ool004@0oooo0`3o001<0?ooo`<0o`009`3oool2000000/0oooo0P0000340?ooo`00@`3oool30?l0
04h0oooo0`3o000V0?ooo`8000002`3oool200000<@0oooo00120?ooo`<0o`00D03oool30?l002D0
oooo0P00000;0?ooo`800000a03oool00480oooo0P3o001B0?ooo`<0o`00903oool2000000/0oooo
0P0000340?ooo`00@@3oool20?l005@0oooo0`3o000S0?ooo`8000002`3oool200000<@0oooo0010
0?ooo`<0o`00E@3oool30?l00280oooo0P00000;0?ooo`800000a03oool003l0oooo0`3o001G0?oo
o`<0o`008@3oool2000000/0oooo100000320?ooo`00?P3oool30?l005T0oooo0`3o000P0?ooo`80
00002`3oool200000<@0oooo000n0?ooo`80o`00F`3oool30?l001l0oooo0P00000;0?ooo`800000
a03oool003d0oooo0P3o001M0?ooo`<0o`007P3oool2000000/0oooo0P0000340?ooo`00?03oool3
0?l005h0oooo0`3o000M0?ooo`8000002`3oool200000<@0oooo000l0?ooo`80o`00H03oool30?l0
01`0oooo0P00000;0?ooo`800000a03oool003/0oooo0P3o001R0?ooo`<0o`006`3oool2000000/0
oooo0P0000340?ooo`00>P3oool20?l006@0oooo0P3o000H0?ooo`D000002`3oool200000<@0oooo
000j0?ooo`030?l0003oool0oooo06@0oooo0P3o000I0?ooo`<000002`3oool200000<@0oooo000i
0?ooo`80o`00I`3oool20?l002H0oooo0P0000340?ooo`00>@3oool00`3o0000oooo0?ooo`1W0?oo
o`80o`009@3oool200000<@0oooo000h0?ooo`80o`00JP3oool00`3o0000oooo0?ooo`0S0?ooo`80
0000a03oool003L0oooo0P3o001[0?ooo`80o`00903oool300000<<0oooo000g0?ooo`030?l0003o
ool0oooo06/0oooo0P3o000S0?ooo`800000a03oool003H0oooo0P3o001^0?ooo`80o`008P3oool2
00000<@0oooo000f0?ooo`030?l0003oool0oooo06h0oooo0P3o000Q0?ooo`800000a03oool003D0
oooo0P3o001a0?ooo`030?l0003oool0oooo01l0oooo0P0000340?ooo`00=03oool20?l00780oooo
0P3o000P0?ooo`800000a03oool003@0oooo00<0o`000?ooo`3oool0LP3oool20?l001l0oooo0P00
00340?ooo`00<`3oool20?l007D0oooo0P3o000N0?ooo`800000a03oool003<0oooo00<0o`000?oo
o`3oool0M@3oool00`3o0000oooo0?ooo`0L0?ooo`800000a03oool00380oooo0P3o001g0?ooo`80
o`007@3oool200000<@0oooo000b0?ooo`030?l0003oool0oooo07L0oooo0P3o000L0?ooo`800000
a03oool00340oooo0P3o001j0?ooo`80o`006`3oool200000<@0oooo000`0?ooo`80o`00O03oool2
0?l001X0oooo0P0000340?ooo`00<03oool00`3o0000oooo0?ooo`1l0?ooo`030?l0003oool0oooo
01P0oooo0`0000330?ooo`00;`3oool20?l007h0oooo0P3o000I0?ooo`800000a03oool002l0oooo
00<0o`000?ooo`3oool0OP3oool20?l001P0oooo0P0000340?ooo`00;P3oool20?l00840oooo0P3o
000G0?ooo`800000a03oool002h0oooo00<0o`000?ooo`3oool0P@3oool00`3o0000oooo0?ooo`0E
0?ooo`800000a03oool002d0oooo0P3o00230?ooo`80o`005P3oool200000<@0oooo000]0?ooo`03
0?l0003oool0oooo08<0oooo0P3o000E0?ooo`800000a03oool002`0oooo0P3o00260?ooo`80o`00
503oool200000<@0oooo000/0?ooo`030?l0003oool0oooo08H0oooo0P3o000C0?ooo`800000a03o
ool002/0oooo0P3o00290?ooo`030?l0003oool0oooo0140oooo0P0000340?ooo`00:`3oool00`3o
0000oooo0?ooo`280?ooo`80o`004P3oool200000<@0oooo000[0?ooo`030?l0003oool0oooo08T0
oooo0P3o000A0?ooo`800000a03oool002X0oooo0P3o002<0?ooo`80o`00403oool200000<@0oooo
000Z0?ooo`030?l0003oool0oooo08`0oooo00<0o`000?ooo`3oool03P3oool300000<<0oooo000Y
0?ooo`80o`00SP3oool20?l000l0oooo0P0000340?ooo`00:@3oool00`3o0000oooo0?ooo`2>0?oo
o`80o`003P3oool200000<@0oooo000X0?ooo`80o`00T@3oool20?l000d0oooo0P0000340?ooo`00
:03oool00`3o0000oooo0?ooo`2A0?ooo`80o`00303oool200000<@0oooo000X0?ooo`030?l0003o
ool0oooo0980oooo00<0o`000?ooo`3oool02P3oool200000<@0oooo000W0?ooo`80o`00U03oool2
0?l000/0oooo0P0000340?ooo`009`3oool00`3o0000oooo0?ooo`2D0?ooo`80o`002P3oool20000
0<@0oooo000V0?ooo`80o`00U`3oool00`3o0000oooo0?ooo`080?ooo`800000a03oool002H0oooo
00<0o`000?ooo`3oool0UP3oool20?l000T0oooo0P0000340?ooo`009@3oool20?l009T0oooo0P3o
00080?ooo`800000a03oool002D0oooo00<0o`000?ooo`3oool0V@3oool00`3o0000oooo0?ooo`06
0?ooo`800000a03oool002@0oooo0P3o002K0?ooo`80o`001`3oool200000<@0oooo000T0?ooo`03
0?l0003oool0oooo09/0oooo0P3o00060?ooo`<00000``3oool002@0oooo00<0o`000?ooo`3oool0
W03oool00`3o0000oooo0?ooo`040?ooo`800000a03oool002<0oooo0P3o002N0?ooo`80o`001@3o
ool200000<@0oooo000S0?ooo`030?l0003oool0oooo09h0oooo0P3o00040?ooo`800000a03oool0
0280oooo0P3o002Q0?ooo`80o`000`3oool200000<@0oooo000R0?ooo`030?l0003oool0oooo09<0
oooo2P0000040?ooo`040?l0003oool0oooo0?ooo`800000a03oool00240oooo0P3o002F0?ooo`T0
0000103oool20?l00080oooo0P0000340?ooo`008@3oool00`3o0000oooo0?ooo`2F0?ooo`030000
003oool0oooo00@0oooo0P0000040?ooo`80o`0000<0oooo000000000000a03oool00240oooo00<0
o`000?ooo`3oool0U`3oool00`000000oooo0?ooo`0:0?ooo`040?l0003oool0000000000<@0oooo
000P0?ooo`80o`00VP3oool00`000000oooo0?ooo`090?ooo`80o`000P0000340?ooo`00803oool0
0`3o0000oooo0?ooo`2J0?ooo`030000003oool0oooo00T0oooo0P3o00000`000000oooo0?ooo`32
0?ooo`007`3oool20?l009d0oooo00<000000?ooo`3oool02@3oool00`3o000000000?ooo`330?oo
o`007`3oool00`3o0000oooo0?ooo`2L0?ooo`030000003oool0oooo00T0oooo0P3o000200000<80
oooo000O0?ooo`030?l0003oool0oooo09d0oooo00<000000?ooo`3oool0203oool00`000000o`00
0?l000330?ooo`00`03oool00`000000oooo0?ooo`070?ooo`80000000<0o`000?ooo`3oool0`@3o
ool00<00oooo00<000000?ooo`3oool01`3oool200000080o`00`P3oool00<00oooo0P0000080?oo
o`80000000<0oooo0?l0003o0000`@3oool00;P0oooo00<000000?ooo`3oool01@3oool2000000P0
oooo0P0000020?ooo`030?l0003oool0oooo0;l0oooo002h0?ooo`030000003oool0oooo00D0oooo
0P0000080?ooo`8000000P3oool20?l00<00oooo002i0?ooo`030000003oool0oooo0080oooo1000
00080?ooo`8000000`3oool20?l00;l0oooo002i0?ooo`P000002@3oool2000000@0oooo00<0o`00
0?ooo`3oool0_@3oool00;/0oooo1000000;0?ooo`800000103oool20?l00;h0oooo003:0?ooo`80
00001@3oool20?l00;d0oooo003:0?ooo`8000001P3oool00`3o0000oooo0?ooo`2k0?ooo`00bP3o
ool2000000H0oooo0P3o002l0?ooo`00bP3oool3000000H0oooo0P3o002k0?ooo`00bP3oool20000
00P0oooo0P3o002j0?ooo`00bP3oool2000000T0oooo00<0o`000?ooo`3oool0^03oool00<X0oooo
0P0000090?ooo`80o`00^@3oool00<X0oooo0P00000:0?ooo`80o`00^03oool00<X0oooo0P00000;
0?ooo`030?l0003oool0oooo0;H0oooo003:0?ooo`8000002`3oool20?l00;L0oooo003:0?ooo`80
0000303oool20?l00;H0oooo003:0?ooo`8000003@3oool00`3o0000oooo0?ooo`2d0?ooo`00bP3o
ool2000000d0oooo0P3o002e0?ooo`00bP3oool2000000h0oooo0P3o002d0?ooo`00bP3oool20000
00l0oooo00<0o`000?ooo`3oool0/P3oool00<X0oooo0P00000?0?ooo`80o`00/`3oool00<X0oooo
0`00000?0?ooo`80o`00/P3oool00<X0oooo0P00000A0?ooo`030?l0003oool0oooo0;00oooo003:
0?ooo`8000004@3oool20?l00;40oooo003:0?ooo`8000004P3oool00`3o0000oooo0?ooo`2_0?oo
o`00bP3oool200000180oooo0P3o002`0?ooo`00bP3oool2000001<0oooo0P3o002_0?ooo`00bP3o
ool2000001@0oooo00<0o`000?ooo`3oool0[@3oool00<X0oooo0P00000D0?ooo`80o`00[P3oool0
0<X0oooo0P00000E0?ooo`030?l0003oool0oooo0:`0oooo003:0?ooo`8000005@3oool20?l00:d0
oooo003:0?ooo`8000005P3oool20?l00:`0oooo003:0?ooo`8000005`3oool00`3o0000oooo0?oo
o`2Z0?ooo`00bP3oool2000001L0oooo0P3o002[0?ooo`00bP3oool3000001L0oooo0P3o002Z0?oo
o`00bP3oool2000001T0oooo00<0o`000?ooo`3oool0Z03oool00<X0oooo0P00000I0?ooo`80o`00
Z@3oool00<X0oooo0P00000J0?ooo`030?l0003oool0oooo0:L0oooo003:0?ooo`8000006P3oool2
0?l00:P0oooo003:0?ooo`8000006`3oool20?l00:L0oooo003:0?ooo`800000703oool00`3o0000
oooo0?ooo`2U0?ooo`00bP3oool2000001`0oooo0P3o002V0?ooo`00bP3oool2000001d0oooo0P3o
002U0?ooo`00bP3oool2000001h0oooo00<0o`000?ooo`3oool0X`3oool00<X0oooo0P00000N0?oo
o`80o`00Y03oool00<X0oooo0P00000O0?ooo`80o`00X`3oool00<X0oooo0`00000O0?ooo`030?l0
003oool0oooo0:40oooo003:0?ooo`800000803oool20?l00:80oooo003:0?ooo`8000008@3oool2
0?l00:40oooo003:0?ooo`8000008P3oool00`3o0000oooo0?ooo`2O0?ooo`00bP3oool200000280
oooo0P3o002P0?ooo`00bP3oool2000002<0oooo0P3o002O0?ooo`00^03oool7000000/0oooo0P00
000T0?ooo`80o`00WP3oool00;P0oooo0`0000040?ooo`030000003oool0oooo00P0oooo0P00000U
0?ooo`030?l0003oool0oooo09`0oooo00300?ooo`030000003oool0oooo00L0oooo0P00000U0?oo
o`80o`00W@3oool00<00oooo0P0000080?ooo`8000009P3oool20?l009`0oooo00300?ooo`800000
203oool2000002L0oooo00<0o`000?ooo`3oool0VP3oool00<00oooo0P0000080?ooo`8000009`3o
ool20?l009/0oooo002o0?ooo`<00000203oool2000002P0oooo0P3o002J0?ooo`00_P3oool40000
00P0oooo1000000W0?ooo`030?l0003oool0oooo09P0oooo002k0?ooo`H000002@3oool2000002T0
oooo0P3o002I0?ooo`00_@3oool3000000X0oooo0P00000Z0?ooo`80o`00V03oool00;h0oooo0P00
000:0?ooo`800000:`3oool00`3o0000oooo0?ooo`2F0?ooo`00_`3oool00`000000oooo0?ooo`08
0?ooo`800000:`3oool20?l009L0oooo002o0?ooo`8000002@3oool2000002`0oooo0P3o002F0?oo
o`00^03oool00`000000oooo0?ooo`040?ooo`8000002@3oool2000002d0oooo00<0o`000?ooo`3o
ool0U03oool00;T0oooo00<000000?ooo`3oool00P3oool3000000T0oooo0P00000]0?ooo`80o`00
U@3oool00;T0oooo1`00000:0?ooo`800000;P3oool20?l009@0oooo002k0?ooo`@000002`3oool2
000002l0oooo0P3o002C0?ooo`00bP3oool200000300oooo00<0o`000?ooo`3oool0T@3oool00<X0
oooo0P00000`0?ooo`80o`00TP3oool00<X0oooo0P00000a0?ooo`80o`00T@3oool00<X0oooo0`00
000a0?ooo`030?l0003oool0oooo08l0oooo003:0?ooo`800000<P3oool20?l00900oooo003:0?oo
o`800000<`3oool20?l008l0oooo003:0?ooo`800000=03oool00`3o0000oooo0?ooo`2=0?ooo`00
bP3oool2000003@0oooo0P3o002>0?ooo`00bP3oool2000003D0oooo0P3o002=0?ooo`00bP3oool2
000003H0oooo0P3o002<0?ooo`00bP3oool2000003L0oooo00<0o`000?ooo`3oool0RP3oool00<X0
oooo0P00000g0?ooo`80o`00R`3oool00<X0oooo0P00000h0?ooo`80o`00RP3oool00<X0oooo0P00
000i0?ooo`030?l0003oool0oooo08P0oooo003:0?ooo`800000>@3oool20?l008T0oooo003:0?oo
o`800000>P3oool20?l008P0oooo003:0?ooo`<00000>P3oool20?l008L0oooo003:0?ooo`800000
?03oool00`3o0000oooo0?ooo`250?ooo`00bP3oool2000003`0oooo0P3o00260?ooo`00bP3oool2
000003d0oooo0P3o00250?ooo`00bP3oool2000003h0oooo0P3o00240?ooo`00bP3oool2000003l0
oooo0P3o00230?ooo`00bP3oool200000400oooo00<0o`000?ooo`3oool0P@3oool00<X0oooo0P00
00100?ooo`80o`00PP3oool00<X0oooo0P0000110?ooo`80o`00P@3oool00<X0oooo0P0000120?oo
o`80o`00P03oool00<X0oooo0P0000130?ooo`030?l0003oool0oooo07h0oooo003:0?ooo`800000
@`3oool20?l007l0oooo003:0?ooo`800000A03oool20?l007h0oooo003:0?ooo`<00000A03oool2
0?l007d0oooo003:0?ooo`800000AP3oool20?l007`0oooo003:0?ooo`800000A`3oool20?l007/0
oooo003:0?ooo`800000A`3oool30?l007X0oooo003:0?ooo`800000B03oool30?l007T0oooo003:
0?ooo`800000B@3oool30?l007P0oooo003:0?ooo`800000BP3oool30?l007L0oooo003:0?ooo`80
0000B`3oool30?l007H0oooo003:0?ooo`800000C03oool30?l007D0oooo003:0?ooo`800000C@3o
ool20?l007D0oooo003:0?ooo`800000CP3oool20?l007@0oooo003:0?ooo`800000CP3oool30?l0
07<0oooo003:0?ooo`<00000CP3oool30?l00780oooo003:0?ooo`800000D03oool30?l00740oooo
003:0?ooo`800000D@3oool30?l00700oooo003:0?ooo`800000DP3oool30?l006l0oooo003:0?oo
o`800000D`3oool30?l006h0oooo002o0?ooo`8000002@3oool2000005@0oooo0`3o001]0?ooo`00
_`3oool2000000T0oooo0P00001E0?ooo`<0o`00K03oool00;l0oooo0P0000090?ooo`800000EP3o
ool30?l006/0oooo002o0?ooo`8000002@3oool2000005L0oooo0`3o001Z0?ooo`00^03oool;0000
00L0oooo0P00001H0?ooo`@0o`00J03oool00;P0oooo00<000000?ooo`3oool0103oool2000000T0
oooo0P00001I0?ooo`@0o`00I`3oool00;T0oooo00<000000?ooo`3oool00`3oool2000000T0oooo
0P00001K0?ooo`<0o`00IP3oool00;X0oooo00<000000?ooo`3oool00P3oool2000000T0oooo0P00
001L0?ooo`<0o`00C03oool00`3o0000oooo0?ooo`0F0?ooo`00^P3oool00`000000oooo0?ooo`02
0?ooo`8000002@3oool4000005/0oooo0`3o001:0?ooo`<0o`005`3oool00;/0oooo00@000000?oo
o`3oool0oooo0P0000090?ooo`800000GP3oool30?l004P0oooo0`3o000H0?ooo`00_03oool00`00
0000oooo0?ooo`02000000T0oooo0P00001O0?ooo`@0o`00A@3oool30?l001T0oooo002l0?ooo`03
0000003oool0oooo008000002@3oool200000600oooo103o00120?ooo`@0o`006P3oool00;d0oooo
00@000000?ooo`00000000002@3oool200000680oooo0`3o00100?ooo`@0o`006`3oool00;d0oooo
00@000000?ooo`00000000002@3oool2000006<0oooo0`3o000n0?ooo`<0o`007@3oool00;h0oooo
0`0000090?ooo`800000I03oool30?l003`0oooo0`3o000N0?ooo`00_`3oool2000000T0oooo0P00
001U0?ooo`@0o`00>@3oool30?l001l0oooo002o0?ooo`8000002@3oool2000006H0oooo103o000g
0?ooo`<0o`00803oool00<X0oooo0P00001X0?ooo`<0o`00=03oool40?l00240oooo003:0?ooo`80
0000J@3oool30?l00380oooo103o000R0?ooo`00bP3oool2000006X0oooo103o000_0?ooo`<0o`00
903oool00<X0oooo0P00001[0?ooo`D0o`00;03oool30?l002D0oooo003:0?ooo`<00000K03oool5
0?l002P0oooo103o000V0?ooo`00bP3oool2000006l0oooo1@3o000T0?ooo`D0o`009`3oool00<X0
oooo0P00001a0?ooo`H0o`007`3oool50?l002T0oooo003:0?ooo`800000L`3oool60?l001/0oooo
1@3o000[0?ooo`00bP3oool2000007H0oooo1@3o000G0?ooo`D0o`00;@3oool00<X0oooo0P00001h
0?ooo`H0o`00403oool70?l002l0oooo003:0?ooo`800000NP3oool;0?l00080oooo2`3o000b0?oo
o`00bP3oool2000007d0oooo4@3o000f0?ooo`00bP3oool2000008<0oooo1P3o000k0?ooo`00bP3o
ool200000<@0oooo003:0?ooo`800000a03oool00<X0oooo0P0000340?ooo`00bP3oool200000<@0
oooo003:0?ooo`<00000``3oool00<X0oooo0P0000340?ooo`00\
\>"],
  ImageRangeCache->{{{0, 399}, {319, 0}} -> {-1.18487, -0.568057, 0.00582266, \
0.0156667}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<G:\Robert\Vorlesungen\Variationsrechnung\Pr\[ADoubleDot]\
sentation\Funktion.png\>", funktion, \ ImageSize \[Rule] 400]\)], "Input"],

Cell[BoxData[
    \("G:\\Robert\\Vorlesungen\\Variationsrechnung\\Pr\[ADoubleDot]sentation\\\
Funktion.png"\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1024}, {0, 699}},
WindowSize->{496, 599},
WindowMargins->{{Automatic, 253}, {-109, Automatic}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1776, 53, 77, 1, 50, "Input"],
Cell[1856, 56, 36, 1, 29, "Output"]
}, Open  ]],
Cell[1907, 60, 241, 4, 110, "Input"],

Cell[CellGroupData[{
Cell[2173, 68, 2870, 75, 90, "Input"],
Cell[5046, 145, 32234, 907, 328, 13908, 676, "GraphicsData", "PostScript", \
"Graphics"],
Cell[37283, 1054, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[37450, 1062, 26, 0, 30, "Input"],
Cell[37479, 1064, 130, 3, 29, "Output"]
}, Open  ]],
Cell[37624, 1070, 26, 0, 30, "Input"],

Cell[CellGroupData[{
Cell[37675, 1074, 119, 3, 42, "Input"],
Cell[37797, 1079, 74, 1, 29, "Output"]
}, Open  ]],
Cell[37886, 1083, 26, 0, 30, "Input"],
Cell[37915, 1085, 26, 0, 30, "Input"],
Cell[37944, 1087, 26, 0, 30, "Input"],

Cell[CellGroupData[{
Cell[37995, 1091, 119, 3, 42, "Input"],
Cell[38117, 1096, 74, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[38228, 1102, 125, 3, 42, "Input"],
Cell[38356, 1107, 74, 1, 29, "Output"]
}, Open  ]],
Cell[38445, 1111, 86, 2, 50, "Input"],

Cell[CellGroupData[{
Cell[38556, 1117, 247, 5, 50, "Input"],
Cell[38806, 1124, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[38973, 1132, 221, 5, 30, "Input"],
Cell[39197, 1139, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[39364, 1147, 210, 5, 30, "Input"],
Cell[39577, 1154, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[39744, 1162, 138, 3, 50, "Input"],
Cell[39885, 1167, 38718, 1056, 328, 16690, 779, "GraphicsData", "PostScript", \
"Graphics"],
Cell[78606, 2225, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[78773, 2233, 185, 3, 90, "Input"],
Cell[78961, 2238, 129, 2, 48, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[79127, 2245, 2854, 75, 170, "Input"],
Cell[81984, 2322, 28557, 778, 328, 11664, 565, "GraphicsData", "PostScript", \
"Graphics"],
Cell[110544, 3102, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[110711, 3110, 162, 2, 90, "Input"],
Cell[110876, 3114, 121, 2, 48, "Output"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

