(************** Content-type: application/mathematica **************
                     CreatedBy='Mathematica 5.0'

                    Mathematica-Compatible Notebook

This notebook can be used with any Mathematica-compatible
application, such as Mathematica, MathReader or Publicon. The data
for the notebook starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do
one of the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the
  application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing
the word CacheID, otherwise Mathematica-compatible applications may
try to use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
*******************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[    416425,       9850]*)
(*NotebookOutlinePosition[    417069,       9872]*)
(*  CellTagsIndexPosition[    417025,       9868]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    RowBox[{\(Solve::"tdep"\), \(\(:\)\(\ \)\), "\<\"The equations appear to \
involve the variables to be solved for in an essentially non-algebraic way. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"Solve::tdep\\\"]\\)\"\>"}]], \
"Message"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(fontSize = 26\)\)\)], "Input"],

Cell[BoxData[
    \(26\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(FindRoot[c\ Cosh[1\/c] \[Equal] 1.75, {c, 0.25, 2}]\)], "Input"],

Cell[BoxData[
    \({c \[Rule] 1.367906461543592`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(FindRoot[
      c\ Cosh[1\/c] \[Equal] 1.75, {c, 0.25, 0.83}]\)\)\)], "Input"],

Cell[BoxData[
    \({c \[Rule] 0.5452157113930056`}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Plot[c\ Cosh[1/c], {c, 0.1, 2}, \ 
      PlotRange \[Rule] {{0, 2}, {0, 2}}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .61803 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0 0.5 0 0.309017 [
[.125 -0.0125 -12 -9 ]
[.125 -0.0125 12 0 ]
[.25 -0.0125 -9 -9 ]
[.25 -0.0125 9 0 ]
[.375 -0.0125 -12 -9 ]
[.375 -0.0125 12 0 ]
[.5 -0.0125 -3 -9 ]
[.5 -0.0125 3 0 ]
[.625 -0.0125 -12 -9 ]
[.625 -0.0125 12 0 ]
[.75 -0.0125 -9 -9 ]
[.75 -0.0125 9 0 ]
[.875 -0.0125 -12 -9 ]
[.875 -0.0125 12 0 ]
[1 -0.0125 -3 -9 ]
[1 -0.0125 3 0 ]
[-0.0125 .07725 -24 -4.5 ]
[-0.0125 .07725 0 4.5 ]
[-0.0125 .15451 -18 -4.5 ]
[-0.0125 .15451 0 4.5 ]
[-0.0125 .23176 -24 -4.5 ]
[-0.0125 .23176 0 4.5 ]
[-0.0125 .30902 -6 -4.5 ]
[-0.0125 .30902 0 4.5 ]
[-0.0125 .38627 -24 -4.5 ]
[-0.0125 .38627 0 4.5 ]
[-0.0125 .46353 -18 -4.5 ]
[-0.0125 .46353 0 4.5 ]
[-0.0125 .54078 -24 -4.5 ]
[-0.0125 .54078 0 4.5 ]
[-0.0125 .61803 -6 -4.5 ]
[-0.0125 .61803 0 4.5 ]
[ 0 0 0 0 ]
[ 1 .61803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.125 0 m
.125 .00625 L
s
[(0.25)] .125 -0.0125 0 1 Mshowa
.25 0 m
.25 .00625 L
s
[(0.5)] .25 -0.0125 0 1 Mshowa
.375 0 m
.375 .00625 L
s
[(0.75)] .375 -0.0125 0 1 Mshowa
.5 0 m
.5 .00625 L
s
[(1)] .5 -0.0125 0 1 Mshowa
.625 0 m
.625 .00625 L
s
[(1.25)] .625 -0.0125 0 1 Mshowa
.75 0 m
.75 .00625 L
s
[(1.5)] .75 -0.0125 0 1 Mshowa
.875 0 m
.875 .00625 L
s
[(1.75)] .875 -0.0125 0 1 Mshowa
1 0 m
1 .00625 L
s
[(2)] 1 -0.0125 0 1 Mshowa
.125 Mabswid
.025 0 m
.025 .00375 L
s
.05 0 m
.05 .00375 L
s
.075 0 m
.075 .00375 L
s
.1 0 m
.1 .00375 L
s
.15 0 m
.15 .00375 L
s
.175 0 m
.175 .00375 L
s
.2 0 m
.2 .00375 L
s
.225 0 m
.225 .00375 L
s
.275 0 m
.275 .00375 L
s
.3 0 m
.3 .00375 L
s
.325 0 m
.325 .00375 L
s
.35 0 m
.35 .00375 L
s
.4 0 m
.4 .00375 L
s
.425 0 m
.425 .00375 L
s
.45 0 m
.45 .00375 L
s
.475 0 m
.475 .00375 L
s
.525 0 m
.525 .00375 L
s
.55 0 m
.55 .00375 L
s
.575 0 m
.575 .00375 L
s
.6 0 m
.6 .00375 L
s
.65 0 m
.65 .00375 L
s
.675 0 m
.675 .00375 L
s
.7 0 m
.7 .00375 L
s
.725 0 m
.725 .00375 L
s
.775 0 m
.775 .00375 L
s
.8 0 m
.8 .00375 L
s
.825 0 m
.825 .00375 L
s
.85 0 m
.85 .00375 L
s
.9 0 m
.9 .00375 L
s
.925 0 m
.925 .00375 L
s
.95 0 m
.95 .00375 L
s
.975 0 m
.975 .00375 L
s
.25 Mabswid
0 0 m
1 0 L
s
0 .07725 m
.00625 .07725 L
s
[(0.25)] -0.0125 .07725 1 0 Mshowa
0 .15451 m
.00625 .15451 L
s
[(0.5)] -0.0125 .15451 1 0 Mshowa
0 .23176 m
.00625 .23176 L
s
[(0.75)] -0.0125 .23176 1 0 Mshowa
0 .30902 m
.00625 .30902 L
s
[(1)] -0.0125 .30902 1 0 Mshowa
0 .38627 m
.00625 .38627 L
s
[(1.25)] -0.0125 .38627 1 0 Mshowa
0 .46353 m
.00625 .46353 L
s
[(1.5)] -0.0125 .46353 1 0 Mshowa
0 .54078 m
.00625 .54078 L
s
[(1.75)] -0.0125 .54078 1 0 Mshowa
0 .61803 m
.00625 .61803 L
s
[(2)] -0.0125 .61803 1 0 Mshowa
.125 Mabswid
0 .01545 m
.00375 .01545 L
s
0 .0309 m
.00375 .0309 L
s
0 .04635 m
.00375 .04635 L
s
0 .0618 m
.00375 .0618 L
s
0 .09271 m
.00375 .09271 L
s
0 .10816 m
.00375 .10816 L
s
0 .12361 m
.00375 .12361 L
s
0 .13906 m
.00375 .13906 L
s
0 .16996 m
.00375 .16996 L
s
0 .18541 m
.00375 .18541 L
s
0 .20086 m
.00375 .20086 L
s
0 .21631 m
.00375 .21631 L
s
0 .24721 m
.00375 .24721 L
s
0 .26266 m
.00375 .26266 L
s
0 .27812 m
.00375 .27812 L
s
0 .29357 m
.00375 .29357 L
s
0 .32447 m
.00375 .32447 L
s
0 .33992 m
.00375 .33992 L
s
0 .35537 m
.00375 .35537 L
s
0 .37082 m
.00375 .37082 L
s
0 .40172 m
.00375 .40172 L
s
0 .41717 m
.00375 .41717 L
s
0 .43262 m
.00375 .43262 L
s
0 .44807 m
.00375 .44807 L
s
0 .47898 m
.00375 .47898 L
s
0 .49443 m
.00375 .49443 L
s
0 .50988 m
.00375 .50988 L
s
0 .52533 m
.00375 .52533 L
s
0 .55623 m
.00375 .55623 L
s
0 .57168 m
.00375 .57168 L
s
0 .58713 m
.00375 .58713 L
s
0 .60258 m
.00375 .60258 L
s
.25 Mabswid
0 0 m
0 .61803 L
s
0 0 m
1 0 L
1 .61803 L
0 .61803 L
closepath
clip
newpath
.5 Mabswid
.23537 .61803 m
.2405 .60358 L
.25052 .58018 L
.27008 .54458 L
.29098 .51744 L
.31012 .49964 L
.31999 .49249 L
.33086 .48594 L
.35069 .47697 L
.36153 .47343 L
.37168 .47086 L
.38206 .46889 L
.38717 .46814 L
.39191 .46757 L
.39656 .46711 L
.40076 .46679 L
.40543 .46653 L
.40799 .46642 L
.4104 .46635 L
.41157 .46632 L
.41282 .4663 L
.41399 .46628 L
.41506 .46628 L
.41632 .46627 L
.41703 .46627 L
.41769 .46627 L
.41889 .46628 L
.42017 .46629 L
.42139 .46631 L
.4227 .46634 L
.42507 .4664 L
.42789 .4665 L
.43047 .46662 L
.43477 .46686 L
.43946 .4672 L
.44891 .46808 L
.45919 .46933 L
.46851 .47071 L
.48942 .47454 L
.52936 .48428 L
.56778 .49599 L
.60865 .51039 L
.648 .52574 L
.68585 .5416 L
.72614 .55944 L
.76492 .57739 L
.80614 .59717 L
.84586 .61679 L
s
.84586 .61679 m
.84831 .61803 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{398.813, 246.5},
  ImageMargins->{{37, 0}, {0, 12}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006>0000mR000`400?l00000o`00003oo`3ooon?
0?ooo`00o`3ooon?0?ooo`00@03oool2000000@0oooo0P0000030?ooo`@000000`3oool2000001d0
oooo0P0000040?ooo`800000103oool2000001`0oooo0P0000040?ooo`8000001@3oool00`000000
oooo0?ooo`020?ooo`8000008P3oool500000200oooo1@0000020?ooo`8000000`3oool4000000<0
oooo0P00000L0?ooo`D000000P3oool2000000@0oooo0P00000L0?ooo`D000000P3oool2000000D0
oooo00<000000?ooo`3oool00P3oool200000240oooo100000020?ooo`00?`3oool010000000oooo
0?ooo`0000080?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool000006`3oool01000
0000oooo0?ooo`0000080?ooo`040000003oool0oooo000001X0oooo00@000000?ooo`3oool00000
2P3oool01@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool08@3oool00`000000
oooo0?ooo`0R0?ooo`030000003oool0oooo00L0oooo00<000000?ooo`3oool00`3oool010000000
oooo0?ooo`00000M0?ooo`030000003oool0oooo00L0oooo00@000000?ooo`3oool000007@3oool0
0`000000oooo0?ooo`090?ooo`050000003oool0oooo0?ooo`0000000P3oool00`000000oooo0?oo
o`0N0?ooo`030000003oool0oooo00<0oooo000o0?ooo`040000003oool0oooo000000T0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`0I0?ooo`040000003oool0oooo000000/0oooo
00<000000?ooo`3oool0603oool010000000oooo0?ooo`00000:0?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool08@3oool00`000000oooo0?ooo`0R0?ooo`030000003oool0oooo00P0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo00X0
oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo00@0
oooo00<000000?ooo`3oool07`3oool00`000000oooo0?ooo`020?ooo`00?`3oool010000000oooo
0?ooo`00000:0?ooo`030000003oool0oooo0080oooo0P00000L0?ooo`040000003oool0oooo0000
00T0oooo0P00000K0?ooo`040000003oool0oooo000000/0oooo00@000000?ooo`3oool0oooo0P00
000T0?ooo`030000003oool0oooo0280oooo00<000000?ooo`3oool02@3oool00`000000oooo0?oo
o`020?ooo`8000007P3oool00`000000oooo0?ooo`080?ooo`8000007P3oool00`000000oooo0?oo
o`0:0?ooo`040000003oool0oooo0?ooo`8000008`3oool00`000000oooo0?ooo`010?ooo`00?`3o
ool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000<0oooo00<000000?ooo`3o
ool06`3oool010000000oooo0?ooo`0000090?ooo`030000003oool0oooo01X0oooo00@000000?oo
o`3oool00000203oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo02<0oooo00<0
00000?ooo`3oool08P3oool00`000000oooo0?ooo`070?ooo`040000003oool0oooo000000<0oooo
00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo01d0oooo
00<000000?ooo`3oool01`3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo0200
oooo00@000000?ooo`3oool000000P3oool00400oooo0P00000:0?ooo`800000103oool3000001`0
oooo0P00000:0?ooo`<000006`3oool2000000T0oooo100000030?ooo`<000008P3oool2000002<0
oooo0P00000:0?ooo`800000103oool3000001`0oooo0P00000:0?ooo`<00000703oool2000000T0
oooo100000030?ooo`<000008@3oool2000000<0oooo003o0?ooohl0oooo003o0?ooohl0oooo003o
0?ooohl0oooo003o0?ooohl0oooo003o0?ooohl0oooo003o0?ooohl0oooo000L0?ooool00000L000
00030?ooo`00703oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo00H0oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo0040oooo000L0?oo
o`030000003oool0oooo02/0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`0Z0?oo
o`030000003oool0oooo02/0oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`0[0?oo
o`030000003oool0oooo02/0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`010?oo
o`00703oool00`000000oooo0?ooo`3o0?ooog00oooo000L0?ooo`030000003oool0oooo0?l0oooo
L03oool001`0oooo00<000000?ooo`3oool0o`3ooom`0?ooo`00703oool200000?l0ooooL@3oool0
01`0oooo00<000000?ooo`3oool0o`3ooom`0?ooo`00703oool00`000000oooo0?ooo`3o0?ooog00
oooo000L0?ooo`030000003oool0oooo0?l0ooooL03oool001`0oooo00<000000?ooo`3oool0o`3o
oom`0?ooo`00703oool200000?l0ooooL@3oool001`0oooo00<000000?ooo`3oool0o`3ooom`0?oo
o`00703oool00`000000oooo0?ooo`3o0?ooog00oooo000L0?ooo`030000003oool0oooo0?l0oooo
L03oool001`0oooo00<000000?ooo`3oool0o`3ooom`0?ooo`00703oool00`000000oooo0?ooo`3o
0?ooog00oooo000L0?ooo`800000o`3oooma0?ooo`00703oool00`000000oooo0?ooo`3o0?ooog00
oooo000L0?ooo`030000003oool0oooo0?l0ooooL03oool001`0oooo00<000000?ooo`3oool0o`3o
oom`0?ooo`00703oool00`000000oooo0?ooo`3o0?ooog00oooo000L0?ooo`030000003oool0oooo
0?l0ooooL03oool001`0oooo0P00003o0?ooog40oooo000L0?ooo`030000003oool0oooo0?l0oooo
L03oool001`0oooo00<000000?ooo`3oool0o`3ooom`0?ooo`000P3oool2000000@0oooo0P000003
0?ooo`@000000`3oool2000000H0oooo00<000000?ooo`3oool0o`3ooom`0?ooo`0000D0oooo0000
003oool0oooo000000080?ooo`030000003oool0oooo00<0oooo00@000000?ooo`3oool000001@3o
ool00`000000oooo0?ooo`3o0?ooog00oooo00001@3oool000000?ooo`3oool0000000T0oooo00<0
00000?ooo`3oool01@3oool00`000000oooo0?ooo`030?ooo`<00000o`3ooom`0?ooo`0000D0oooo
0000003oool0oooo0000000:0?ooo`030000003oool0oooo0080oooo0P0000060?ooo`030000003o
ool0oooo0?l0ooooL03oool000050?ooo`000000oooo0?ooo`000000203oool010000000oooo0?oo
o`0000030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool0o`3ooom`0?ooo`000P3o
ool2000000X0oooo0P0000040?ooo`<000001@3oool00`000000oooo0?ooo`3o0?ooog00oooo000L
0?ooo`030000003oool0oooo0?l0ooooL03oool001`0oooo00<000000?ooo`3oool0o`3ooom`0?oo
o`00703oool200000?l0ooooL@3oool001`0oooo00<000000?ooo`3oool0o`3ooom`0?ooo`00703o
ool00`000000oooo0?ooo`3o0?ooog00oooo000L0?ooo`030000003oool0oooo0?l0ooooL03oool0
01`0oooo00<000000?ooo`3oool0o`3ooom`0?ooo`00703oool00`000000oooo0?ooo`3o0?ooog00
oooo000L0?ooo`800000o`3oooma0?ooo`00703oool00`000000oooo0?ooo`3o0?ooog00oooo000L
0?ooo`030000003oool0oooo0?l0ooooL03oool001`0oooo00<000000?ooo`3oool0o`3ooom`0?oo
o`00703oool00`000000oooo0?ooo`3o0?ooog00oooo000L0?ooo`800000o`3oooma0?ooo`00703o
ool00`000000oooo0?ooo`3o0?ooog00oooo000L0?ooo`030000003oool0oooo0?l0ooooL03oool0
01`0oooo00<000000?ooo`3oool0o`3ooom`0?ooo`00703oool00`000000oooo0?ooo`3o0?ooog00
oooo000L0?ooo`030000003oool0oooo0?l0ooooL03oool001`0oooo0P00003o0?ooog40oooo000L
0?ooo`030000003oool0oooo0?l0ooooL03oool001`0oooo00<000000?ooo`3oool0o`3ooom`0?oo
o`00703oool00`000000oooo0?ooo`3o0?ooog00oooo00080?ooo`800000103oool2000000@0oooo
0P0000060?ooo`030000003oool0oooo0?l0ooooL03oool000L0oooo00@000000?ooo`3oool00000
203oool010000000oooo0?ooo`0000050?ooo`030000003oool0oooo0?l0ooooL03oool000L0oooo
00@000000?ooo`3oool000002`3oool00`000000oooo0?ooo`030?ooo`<00000o`3ooom`0?ooo`00
1`3oool010000000oooo0?ooo`0000090?ooo`8000001P3oool00`000000oooo0?ooo`3o0?ooog00
oooo00070?ooo`040000003oool0oooo000000T0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`3o0?ooog00oooo00080?ooo`8000002P3oool3000000D0oooo00<000000?ooo`3oool0
o`3ooom`0?ooo`00703oool00`000000oooo0?ooo`3o0?ooog00oooo000L0?ooo`800000o`3oooma
0?ooo`00703oool00`000000oooo0?ooo`3o0?ooog00oooo000L0?ooo`030000003oool0oooo0?l0
ooooL03oool001`0oooo00<000000?ooo`3oool0o`3ooom`0?ooo`00703oool00`000000oooo0?oo
o`3o0?ooog00oooo000L0?ooo`030000003oool0oooo0?l0ooooL03oool001`0oooo0P00003o0?oo
og40oooo000L0?ooo`030000003oool0oooo0?l0ooooL03oool001`0oooo00<000000?ooo`3oool0
o`3ooom`0?ooo`00703oool00`000000oooo0?ooo`3o0?ooog00oooo000L0?ooo`030000003oool0
oooo0?l0ooooL03oool001`0oooo00<000000?ooo`3oool0o`3ooom`0?ooo`00703oool200000?l0
ooooL@3oool001`0oooo00<000000?ooo`3oool0o`3ooom`0?ooo`00703oool00`000000oooo0?oo
o`3o0?ooog00oooo000L0?ooo`030000003oool0oooo0?l0ooooL03oool001`0oooo00<000000?oo
o`3oool0o`3ooom`0?ooo`00703oool200000?l0ooooL@3oool001`0oooo00<000000?ooo`3oool0
o`3ooom`0?ooo`00703oool00`000000oooo0?ooo`3o0?ooog00oooo000L0?ooo`030000003oool0
oooo0?l0ooooL03oool00080oooo0P0000040?ooo`8000001@3oool00`000000oooo0?ooo`020?oo
o`8000001P3oool00`000000oooo0?ooo`3o0?ooog00oooo00001@3oool000000?ooo`3oool00000
00X0oooo00D000000?ooo`3oool0oooo000000020?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool0o`3ooom`0?ooo`0000D0oooo0000003oool0oooo0000000:0?ooo`030000003oool0
oooo00@0oooo00<000000?ooo`3oool00`3oool300000?l0ooooL03oool000050?ooo`000000oooo
0?ooo`0000002`3oool010000000oooo0?ooo`3oool2000000H0oooo00<000000?ooo`3oool0o`3o
oom`0?ooo`0000D0oooo0000003oool0oooo000000080?ooo`040000003oool0oooo000000<0oooo
00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`3o0?ooog00oooo00020?ooo`8000002@3o
ool4000000<0oooo0`0000050?ooo`030000003oool0oooo0?l0ooooL03oool001`0oooo00<00000
0?ooo`3oool0o`3ooom`0?ooo`00703oool00`000000oooo0?ooo`3o0?ooog00oooo000L0?ooo`80
0000o`3oooma0?ooo`00703oool00`000000oooo0?ooo`3o0?ooog00oooo000L0?ooo`030000003o
ool0oooo0?l0ooooL03oool001`0oooo00<000000?ooo`3oool0o`3ooom`0?ooo`00703oool00`00
0000oooo0?ooo`3o0?ooog00oooo000L0?ooo`800000o`3oooma0?ooo`00703oool00`000000oooo
0?ooo`3o0?ooog00oooo000L0?ooo`030000003oool0oooo0?l0ooooL03oool001`0oooo00<00000
0?ooo`3oool0o`3ooom`0?ooo`00703oool00`000000oooo0?ooo`3o0?ooog00oooo000L0?ooo`03
0000003oool0oooo0?l0ooooL03oool001`0oooo0P00003o0?ooog40oooo000L0?ooo`030000003o
ool0oooo0?l0ooooL03oool001`0oooo00<000000?ooo`3oool0o`3ooom`0?ooo`00703oool00`00
0000oooo0?ooo`3o0?ooog00oooo000L0?ooo`030000003oool0oooo0?l0ooooL03oool001`0oooo
00<000000?ooo`3oool0o`3ooom`0?ooo`00703oool200000?l0ooooL@3oool001`0oooo00<00000
0?ooo`3oool0o`3ooom`0?ooo`00703oool00`000000oooo0?ooo`3o0?ooog00oooo000C0?ooo`D0
0000103oool00`000000oooo0?ooo`3o0?ooog00oooo000E0?ooo`030000003oool0oooo00@0oooo
00<000000?ooo`3oool0o`3ooom`0?ooo`005@3oool00`000000oooo0?ooo`040?ooo`<00000o`3o
oom`0?ooo`005@3oool00`000000oooo0?ooo`040?ooo`030000003oool0oooo0?l0ooooL03oool0
01D0oooo00<000000?ooo`3oool0103oool00`000000oooo0?ooo`3o0?ooog00oooo000D0?ooo`80
00001P3oool00`000000oooo0?ooo`3o0?ooog00oooo000L0?ooo`030000003oool0oooo0?l0oooo
L03oool001`0oooo00<000000?ooo`3oool0o`3ooom`0?ooo`00703oool200000?l0ooooL@3oool0
01`0oooo00<000000?ooo`3oool0o`3ooom`0?ooo`00703oool00`000000oooo0?ooo`3o0?ooog00
oooo000L0?ooo`030000003oool0oooo0?l0ooooL03oool001`0oooo00<000000?ooo`3oool0o`3o
oom`0?ooo`00703oool00`000000oooo0?ooo`3o0?ooog00oooo000L0?ooo`800000o`3oooma0?oo
o`00703oool00`000000oooo0?ooo`3o0?ooog00oooo000L0?ooo`030000003oool0oooo0?l0oooo
L03oool001`0oooo00<000000?ooo`3oool0o`3ooom`0?ooo`00703oool00`000000oooo0?ooo`3o
0?ooog00oooo000L0?ooo`800000o`3oooma0?ooo`00703oool00`000000oooo0?ooo`3o0?ooog00
oooo000L0?ooo`030000003oool0oooo0?l0ooooL03oool001`0oooo00<000000?ooo`3oool0o`3o
oom`0?ooo`00703oool00`000000oooo0?ooo`3o0?ooog00oooo000L0?ooo`030000003oool0oooo
0?l0ooooL03oool001`0oooo0P00003o0?ooog40oooo000L0?ooo`030000003oool0oooo0?l0oooo
L03oool001`0oooo00<000000?ooo`3oool0o`3ooom`0?ooo`00703oool00`000000oooo0?ooo`3o
0?ooog00oooo00000`3oool000000000000300000080oooo0P0000030?ooo`@000000`3oool20000
00H0oooo00<000000?ooo`3oool0o`3ooom`0?ooo`000`3oool00`000000oooo0?ooo`070?ooo`03
0000003oool0oooo00<0oooo00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`3o0?oo
og00oooo00030?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`030?ooo`<00000o`3ooom`0?ooo`000`3oool00`000000oooo0?ooo`090?ooo`030000
003oool0oooo0080oooo0P0000060?ooo`030000003oool0oooo0?l0ooooL03oool000<0oooo00<0
00000?ooo`3oool01`3oool010000000oooo0?ooo`0000030?ooo`030000003oool0oooo00D0oooo
00<000000?ooo`3oool0o`3ooom`0?ooo`000P3oool2000000X0oooo0P0000040?ooo`<000001@3o
ool00`000000oooo0?ooo`3o0?ooog00oooo000L0?ooo`030000003oool0oooo0?l0ooooL03oool0
01`0oooo0P00003o0?ooog40oooo000L0?ooo`030000003oool0oooo0?l0ooooL03oool001`0oooo
00<000000?ooo`3oool0o`3ooom`0?ooo`00703oool00`000000oooo0?ooo`3o0?ooog00oooo000L
0?ooo`030000003oool0oooo0?l0ooooL03oool001`0oooo00<000000?ooo`3oool0o`3ooom`0?oo
o`00703oool200000?l0ooooL@3oool001`0oooo00<000000?ooo`3oool0o`3ooom`0?ooo`00703o
ool00`000000oooo0?ooo`3o0?ooog00oooo000L0?ooo`030000003oool0oooo0?l0ooooL03oool0
01`0oooo00<000000?ooo`3oool0o`3ooom`0?ooo`00703oool00`000000oooo0?ooo`3o0?ooog00
oooo000L0?ooo`800000o`3oooma0?ooo`00703oool00`000000oooo0?ooo`3o0?ooog00oooo000L
0?ooo`030000003oool0oooo0?l0ooooL03oool001`0oooo00<000000?ooo`3oool0o`3ooom`0?oo
o`00703oool00`000000oooo0?ooo`3o0?ooog00oooo000L0?ooo`800000o`3oooma0?ooo`00703o
ool00`000000oooo0?ooo`3o0?ooog00oooo000L0?ooo`030000003oool0oooo0?l0ooooL03oool0
01`0oooo00<000000?ooo`3oool0o`3ooom`0?ooo`001`3oool500000080oooo0P0000040?ooo`80
00001P3oool00`000000oooo0?ooo`3o0?ooog00oooo00090?ooo`030000003oool0oooo00L0oooo
00@000000?ooo`3oool000001@3oool00`000000oooo0?ooo`3o0?ooog00oooo00090?ooo`030000
003oool0oooo00X0oooo00<000000?ooo`3oool00`3oool300000?l0ooooL03oool000T0oooo00<0
00000?ooo`3oool0203oool2000000H0oooo00<000000?ooo`3oool0S@3ooolC00000<l0oooo0009
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`28
0?ooo`D000004`3oool700000<P0oooo00080?ooo`8000002P3oool3000000D0oooo00<000000?oo
o`3oool0Q03oool4000001l0oooo1P0000320?ooo`00703oool00`000000oooo0?ooo`200?ooo`@0
0000:@3oool600000;`0oooo000L0?ooo`030000003oool0oooo07d0oooo0`00000c0?ooo`D00000
]`3oool001`0oooo0P00001l0?ooo`800000>`3oool500000;80oooo000L0?ooo`030000003oool0
oooo07P0oooo0`0000120?ooo`@00000[P3oool001`0oooo00<000000?ooo`3oool0MP3oool20000
04T0oooo0`00002[0?ooo`00703oool00`000000oooo0?ooo`1d0?ooo`800000CP3oool200000:T0
oooo000L0?ooo`030000003oool0oooo0780oooo0P00001B0?ooo`<00000YP3oool001`0oooo0P00
001b0?ooo`030000003oool0oooo05D0oooo0`00002S0?ooo`00703oool00`000000oooo0?ooo`1`
0?ooo`030000003oool0oooo05T0oooo0`00002P0?ooo`00703oool00`000000oooo0?ooo`1_0?oo
o`030000003oool0oooo05d0oooo0`00002M0?ooo`00703oool00`000000oooo0?ooo`1^0?ooo`03
0000003oool0oooo0640oooo0`00002J0?ooo`00703oool00`000000oooo0?ooo`1]0?ooo`030000
003oool0oooo06D0oooo0`00002G0?ooo`00703oool00`000000oooo0?ooo`1/0?ooo`030000003o
ool0oooo06T0oooo0`00002D0?ooo`00703oool2000006`0oooo00<000000?ooo`3oool0K@3oool3
00000940oooo000L0?ooo`030000003oool0oooo06X0oooo00<000000?ooo`3oool0L@3oool20000
08l0oooo000L0?ooo`030000003oool0oooo06T0oooo00<000000?ooo`3oool0M03oool2000008d0
oooo000L0?ooo`030000003oool0oooo06P0oooo00<000000?ooo`3oool0M`3oool3000008X0oooo
000L0?ooo`030000003oool0oooo06L0oooo00<000000?ooo`3oool0N`3oool2000008P0oooo000L
0?ooo`030000003oool0oooo06H0oooo00<000000?ooo`3oool0OP3oool2000008H0oooo000L0?oo
o`800000I`3oool00`000000oooo0?ooo`200?ooo`<00000P`3oool001`0oooo00<000000?ooo`3o
ool0I@3oool00`000000oooo0?ooo`240?ooo`<00000P03oool001`0oooo00<000000?ooo`3oool0
I03oool00`000000oooo0?ooo`280?ooo`800000OP3oool000030?ooo`000000000000<000000P3o
ool2000000D0oooo00<000000?ooo`3oool00P3oool2000000H0oooo00<000000?ooo`3oool0H`3o
ool00`000000oooo0?ooo`2;0?ooo`<00000N`3oool000<0oooo00<000000?ooo`3oool02@3oool0
1@000000oooo0?ooo`3oool000000080oooo00<000000?ooo`3oool00`3oool00`000000oooo0?oo
o`1R0?ooo`030000003oool0oooo08l0oooo0`00001h0?ooo`000`3oool00`000000oooo0?ooo`09
0?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3oool00`3oool300000680oooo00<00000
0?ooo`3oool0TP3oool3000007D0oooo00030?ooo`030000003oool0oooo00X0oooo00@000000?oo
o`3oool0oooo0P0000060?ooo`030000003oool0oooo0640oooo00<000000?ooo`3oool0UP3oool2
000007<0oooo00030?ooo`030000003oool0oooo00L0oooo00@000000?ooo`3oool000000`3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo0600oooo00<000000?ooo`3oool0V@3oool2
00000740oooo00020?ooo`8000002@3oool4000000<0oooo0`0000050?ooo`030000003oool0oooo
05l0oooo00<000000?ooo`3oool0W03oool2000006l0oooo000L0?ooo`030000003oool0oooo05l0
oooo00<000000?ooo`3oool0WP3oool2000006d0oooo000L0?ooo`030000003oool0oooo05h0oooo
00<000000?ooo`3oool0X@3oool2000006/0oooo000L0?ooo`800000G`3oool00`000000oooo0?oo
o`2S0?ooo`800000J@3oool001`0oooo00<000000?ooo`3oool0G@3oool00`000000oooo0?ooo`2V
0?ooo`800000I`3oool001`0oooo00<000000?ooo`3oool0G@3oool00`000000oooo0?ooo`2X0?oo
o`800000I@3oool001`0oooo00<000000?ooo`3oool0G03oool00`000000oooo0?ooo`2[0?ooo`80
0000H`3oool001`0oooo00<000000?ooo`3oool0G03oool00`000000oooo0?ooo`2]0?ooo`800000
H@3oool001`0oooo0P00001L0?ooo`030000003oool0oooo0;00oooo0P00001O0?ooo`00703oool0
0`000000oooo0?ooo`1K0?ooo`030000003oool0oooo0;80oooo0P00001M0?ooo`00703oool00`00
0000oooo0?ooo`1J0?ooo`030000003oool0oooo0;D0oooo0P00001K0?ooo`00703oool00`000000
oooo0?ooo`1J0?ooo`030000003oool0oooo0;L0oooo0`00001H0?ooo`00703oool00`000000oooo
0?ooo`1I0?ooo`030000003oool0oooo0;/0oooo0P00001F0?ooo`00703oool00`000000oooo0?oo
o`1H0?ooo`030000003oool0oooo0;h0oooo0P00001D0?ooo`00703oool2000005T0oooo00<00000
0?ooo`3oool0`03oool200000580oooo000L0?ooo`030000003oool0oooo05L0oooo00<000000?oo
o`3oool0``3oool200000500oooo000L0?ooo`030000003oool0oooo05L0oooo00<000000?ooo`3o
ool0a@3oool2000004h0oooo000L0?ooo`030000003oool0oooo05H0oooo00<000000?ooo`3oool0
b03oool2000004`0oooo000L0?ooo`030000003oool0oooo05H0oooo00<000000?ooo`3oool0bP3o
ool3000004T0oooo000L0?ooo`030000003oool0oooo05D0oooo00<000000?ooo`3oool0cP3oool2
000004L0oooo000L0?ooo`800000EP3oool00`000000oooo0?ooo`3@0?ooo`800000A@3oool001`0
oooo00<000000?ooo`3oool0E@3oool00`000000oooo0?ooo`3B0?ooo`800000@`3oool001`0oooo
00<000000?ooo`3oool0E03oool00`000000oooo0?ooo`3E0?ooo`800000@@3oool001<0oooo1000
00050?ooo`030000003oool0oooo05@0oooo00<000000?ooo`3oool0e`3oool2000003l0oooo000C
0?ooo`030000003oool0oooo00H0oooo00<000000?ooo`3oool0D`3oool00`000000oooo0?ooo`3J
0?ooo`800000?@3oool001@0oooo00<000000?ooo`3oool01@3oool3000005<0oooo00<000000?oo
o`3oool0g03oool3000003X0oooo000E0?ooo`030000003oool0oooo0?l0ooooM`3oool001<0oooo
00@000000?ooo`3oool00000o`3ooomh0?ooo`00503oool200000?l0ooooN@3oool00?l0ooooS`3o
ool00?l0ooooS`3oool00001\
\>"],
  ImageRangeCache->{{{0, 397.813}, {245.5, 0}} -> {-0.156075, -0.12475, \
0.00546104, 0.00883614}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(c1 = 0.5452157113930056`\)], "Input"],

Cell[BoxData[
    \(0.5452157113930056`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(c2 = 1.367906461543592`\)], "Input"],

Cell[BoxData[
    \(1.367906461543592`\)], "Output"]
}, Open  ]],

Cell[BoxData[{
    \(y1[x_] := c1*Cosh[x/c1]\), "\[IndentingNewLine]", 
    \(y2[x_] := c2*Cosh[x/c2]\)}], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"\[IndentingNewLine]", 
      RowBox[{"loesungenRotationskoerper1", "=", 
        RowBox[{"Plot", "[", 
          RowBox[{\({y1[x], y2[x]}\), ",", \({x, \(-1\), 1}\), ",", 
            RowBox[{"AxesStyle", "\[Rule]", 
              RowBox[{"{", 
                RowBox[{
                  FormBox["Thickness",
                    "TraditionalForm"], "[", "0.006", "]"}], "}"}]}], ",", 
            RowBox[{"PlotStyle", "\[Rule]", " ", 
              RowBox[{"{", 
                RowBox[{
                  RowBox[{"{", 
                    RowBox[{
                      RowBox[{
                        StyleBox["RGBColor",
                          "MR"], 
                        StyleBox["[",
                          "MR"], 
                        RowBox[{
                          StyleBox["1",
                            "MR"], 
                          StyleBox[",",
                            "MR"], " ", "0", 
                          StyleBox[",",
                            "MR"], " ", "0"}], 
                        StyleBox["]",
                          "MR"]}], 
                      StyleBox[",",
                        "MR"], 
                      RowBox[{
                        FormBox["Thickness",
                          "TraditionalForm"], "[", "0.006", "]"}]}], 
                    StyleBox["}",
                      "MR"]}], 
                  StyleBox[",",
                    "MR"], 
                  RowBox[{"{", 
                    RowBox[{
                      RowBox[{
                        StyleBox["RGBColor",
                          "MR"], 
                        StyleBox["[",
                          "MR"], 
                        RowBox[{
                          StyleBox["0",
                            "MR"], 
                          StyleBox[",",
                            "MR"], " ", "0", 
                          StyleBox[",",
                            "MR"], 
                          StyleBox["0",
                            "MR"]}], 
                        StyleBox["]",
                          "MR"]}], 
                      StyleBox[",",
                        "MR"], 
                      RowBox[{
                        FormBox["Thickness",
                          "TraditionalForm"], "[", "0.006", "]"}]}], 
                    StyleBox["}",
                      "MR"]}]}], "}"}]}], ",", " ", \(ImageSize \[Rule] 400\),
             ",", " ", \(AspectRatio \[Rule] 0.8\), 
            ",", \(TextStyle \[Rule] {FontFamily \[Rule] "\<Times\>", 
                FontSize \[Rule] fontSize}\)}], "]"}]}]}]], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .8 
%%ImageSize: 400 320 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 -0.325747 0.6324 [
[.02381 .29415 -17.6563 -31.75 ]
[.02381 .29415 17.6563 0 ]
[.2619 .29415 -27.4375 -31.75 ]
[.2619 .29415 27.4375 0 ]
[.7381 .29415 -18.3125 -31.75 ]
[.7381 .29415 18.3125 0 ]
[.97619 .29415 -8.53125 -31.75 ]
[.97619 .29415 8.53125 0 ]
[.4875 .05369 -36.625 -15.875 ]
[.4875 .05369 0 15.875 ]
[.4875 .18017 -36.625 -15.875 ]
[.4875 .18017 0 15.875 ]
[.4875 .43313 -36.625 -15.875 ]
[.4875 .43313 0 15.875 ]
[.4875 .55961 -36.625 -15.875 ]
[.4875 .55961 0 15.875 ]
[.4875 .68609 -36.625 -15.875 ]
[.4875 .68609 0 15.875 ]
[ -0.003 -0.003 0 0 ]
[ 1.003 .803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30665 m
.02381 .3129 L
s
gsave
.02381 .29415 -78.6563 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.2619 .30665 m
.2619 .3129 L
s
gsave
.2619 .29415 -88.4375 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.7381 .30665 m
.7381 .3129 L
s
gsave
.7381 .29415 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.97619 .30665 m
.97619 .3129 L
s
gsave
.97619 .29415 -69.5313 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.125 Mabswid
.07143 .30665 m
.07143 .3104 L
s
.11905 .30665 m
.11905 .3104 L
s
.16667 .30665 m
.16667 .3104 L
s
.21429 .30665 m
.21429 .3104 L
s
.30952 .30665 m
.30952 .3104 L
s
.35714 .30665 m
.35714 .3104 L
s
.40476 .30665 m
.40476 .3104 L
s
.45238 .30665 m
.45238 .3104 L
s
.54762 .30665 m
.54762 .3104 L
s
.59524 .30665 m
.59524 .3104 L
s
.64286 .30665 m
.64286 .3104 L
s
.69048 .30665 m
.69048 .3104 L
s
.78571 .30665 m
.78571 .3104 L
s
.83333 .30665 m
.83333 .3104 L
s
.88095 .30665 m
.88095 .3104 L
s
.92857 .30665 m
.92857 .3104 L
s
.006 w
0 .30665 m
1 .30665 L
s
.25 Mabswid
.5 .05369 m
.50625 .05369 L
s
gsave
.4875 .05369 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
1.000 setlinewidth
grestore
.5 .18017 m
.50625 .18017 L
s
gsave
.4875 .18017 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
1.000 setlinewidth
grestore
.5 .43313 m
.50625 .43313 L
s
gsave
.4875 .43313 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.2) show
1.000 setlinewidth
grestore
.5 .55961 m
.50625 .55961 L
s
gsave
.4875 .55961 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.4) show
1.000 setlinewidth
grestore
.5 .68609 m
.50625 .68609 L
s
gsave
.4875 .68609 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.6) show
1.000 setlinewidth
grestore
.125 Mabswid
.5 .08531 m
.50375 .08531 L
s
.5 .11693 m
.50375 .11693 L
s
.5 .14855 m
.50375 .14855 L
s
.5 .21179 m
.50375 .21179 L
s
.5 .24341 m
.50375 .24341 L
s
.5 .27503 m
.50375 .27503 L
s
.5 .33827 m
.50375 .33827 L
s
.5 .36989 m
.50375 .36989 L
s
.5 .40151 m
.50375 .40151 L
s
.5 .46475 m
.50375 .46475 L
s
.5 .49637 m
.50375 .49637 L
s
.5 .52799 m
.50375 .52799 L
s
.5 .59123 m
.50375 .59123 L
s
.5 .62285 m
.50375 .62285 L
s
.5 .65447 m
.50375 .65447 L
s
.5 .02207 m
.50375 .02207 L
s
.5 .71771 m
.50375 .71771 L
s
.5 .74933 m
.50375 .74933 L
s
.5 .78095 m
.50375 .78095 L
s
.006 w
.5 0 m
.5 .8 L
s
0 0 m
1 0 L
1 .8 L
0 .8 L
closepath
clip
newpath
1 0 0 r
.02381 .78095 m
.06244 .63616 L
.10458 .50248 L
.14415 .39689 L
.18221 .31125 L
.22272 .23511 L
.26171 .17476 L
.30316 .12299 L
.34309 .08396 L
.3815 .05559 L
.40134 .04425 L
.42237 .03458 L
.4419 .02772 L
.4602 .02311 L
.47058 .02126 L
.4757 .02056 L
.48045 .02003 L
.48473 .01964 L
.4893 .01934 L
.49192 .01921 L
.4932 .01917 L
.49438 .01913 L
.49543 .0191 L
.49658 .01908 L
.49775 .01906 L
.49897 .01905 L
.50028 .01905 L
.50148 .01905 L
.50211 .01906 L
.50281 .01907 L
.50353 .01908 L
.50421 .01909 L
.5066 .01916 L
.50795 .01921 L
.50918 .01926 L
.51371 .01953 L
.51848 .01992 L
.52366 .02048 L
.52847 .02112 L
.5394 .02302 L
.54992 .02544 L
.55985 .02825 L
.57844 .0349 L
.59846 .04414 L
.61691 .0546 L
.65631 .08345 L
.6942 .12008 L
.73454 .16957 L
.77336 .22849 L
.81464 .30479 L
Mistroke
.8544 .39336 L
.89265 .49448 L
.93334 .62171 L
.97252 .76621 L
.97619 .78095 L
Mfstroke
0 0 0 r
.02381 .78095 m
.06244 .74194 L
.10458 .70366 L
.14415 .67164 L
.18221 .64433 L
.22272 .61888 L
.26171 .59785 L
.30316 .57912 L
.34309 .56454 L
.3815 .55367 L
.40095 .54934 L
.42237 .54547 L
.44268 .54267 L
.45178 .54169 L
.46172 .54081 L
.4671 .54042 L
.4721 .54011 L
.47727 .53984 L
.48196 .53965 L
.48658 .5395 L
.4887 .53945 L
.49093 .5394 L
.49332 .53936 L
.49438 .53935 L
.49552 .53934 L
.49675 .53933 L
.49789 .53932 L
.49859 .53932 L
.49925 .53932 L
.50049 .53932 L
.50163 .53932 L
.50286 .53932 L
.50401 .53933 L
.50508 .53934 L
.50754 .53937 L
.51014 .53942 L
.51268 .53948 L
.51504 .53955 L
.5204 .53974 L
.5293 .54019 L
.53882 .54085 L
.54906 .54177 L
.56016 .54301 L
.58032 .5459 L
.60019 .54957 L
.62123 .55434 L
.65912 .56526 L
.69946 .58019 L
.73829 .59785 L
.77956 .62022 L
Mistroke
.81932 .64536 L
.85757 .67296 L
.89827 .70611 L
.93745 .74183 L
.97619 .78095 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{400, 320},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0001@2000`400?l00000o`00003oo`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00bP3oool200000<@0oooo003:
0?ooo`800000a03oool00<X0oooo0P0000340?ooo`00bP3oool200000<@0oooo003:0?ooo`800000
a03oool00<X0oooo0P0000340?ooo`00bP3oool200000<@0oooo003:0?ooo`800000a03oool00;/0
oooo7`3o002f0?ooo`00^03ooolV0?l00;80oooo002d0?ooo`L0o`003`3oool2000000h0oooo203o
002^0?ooo`00/@3oool70?l00180oooo0P00000B0?ooo`L0o`00Z`3oool00:l0oooo1P3o000E0?oo
o`8000005P3oool60?l00:P0oooo002/0?ooo`H0o`00603oool2000001P0oooo1P3o002V0?ooo`00
Y`3oool2000000L0o`000P3oool2000000L0oooo1@00000:0?ooo`8000006`3oool60?l00:<0oooo
002V0?ooo`030000003o0000o`0000@0o`001@3oool2000000H0oooo0P0000030?ooo`8000002@3o
ool2000001d0oooo1P3o002Q0?ooo`00Y03oool60?l00080oooo00<000000?ooo`3oool02P3oool2
000000D0oooo0P0000080?ooo`800000803oool60?l009h0oooo002R0?ooo`H0o`00103oool20000
00/0oooo0P0000060?ooo`030000003oool0oooo00H0oooo0P00000R0?ooo`H0o`00W03oool00:40
oooo103o00000`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo0P0000070?ooo`80
00001`3oool2000002D0oooo103o002K0?ooo`00W`3oool40?l000030?ooo`000000000000L0oooo
0P0000090?ooo`8000001`3oool2000000L0oooo0P00000W0?ooo`@0o`00V@3oool009h0oooo103o
00020?ooo`8000001`3oool2000000T0oooo0P0000070?ooo`8000001`3oool2000002P0oooo1@3o
002G0?ooo`00W03oool40?l000@0oooo0P0000070?ooo`8000002@3oool2000000L0oooo0P000007
0?ooo`@00000:03oool40?l009H0oooo002K0?ooo`@0o`001@3oool2000000L0oooo0P0000090?oo
o`8000001P3oool2000000P0oooo0P00000/0?ooo`<0o`00U@3oool009T0oooo103o00070?ooo`80
00001`3oool2000000T0oooo100000030?ooo`<00000203oool2000002d0oooo103o002C0?ooo`00
V03oool40?l000P0oooo0P0000070?ooo`8000002P3oool2000000030?ooo`000000000000800000
2P3oool2000002h0oooo103o002B0?ooo`00U`3oool30?l000X0oooo0P0000070?ooo`8000002P3o
ool2000000l0oooo0P00000`0?ooo`<0o`00T@3oool009H0oooo0`3o000<0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool02P3oool2000000h0oooo0P00000a0?ooo`<0o`00T03oool0
09@0oooo103o000=0?ooo`8000001@3oool2000000d0oooo0P00000=0?ooo`800000<P3oool40?l0
08h0oooo002C0?ooo`@0o`003`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00d0
oooo0P00000<0?ooo`800000<`3oool40?l008d0oooo002B0?ooo`<0o`004@3oool2000000<0oooo
0P00000@0?ooo`<000002P3oool2000003D0oooo0`3o002<0?ooo`00T@3oool30?l001@0oooo0`00
000D0?ooo`@000001`3oool2000003H0oooo0`3o002;0?ooo`00S`3oool40?l003L0oooo0P00000g
0?ooo`@0o`00R@3oool008h0oooo103o000h0?ooo`800000>03oool40?l008P0oooo002=0?ooo`<0
o`00>P3oool3000003T0oooo0`3o00270?ooo`00S03oool30?l003/0oooo0P00000k0?ooo`<0o`00
QP3oool008/0oooo0`3o000l0?ooo`800000?03oool30?l008D0oooo002:0?ooo`<0o`00?@3oool2
000003d0oooo0`3o00240?ooo`00R@3oool30?l003h0oooo0P00000n0?ooo`<0o`00P`3oool008P0
oooo0`3o000o0?ooo`800000?`3oool30?l00880oooo00270?ooo`<0o`00@03oool200000400oooo
0`3o00210?ooo`00Q@3oool40?l00440oooo0P0000110?ooo`@0o`00O`3oool008@0oooo103o0012
0?ooo`800000@P3oool40?l007h0oooo00230?ooo`<0o`00A03oool2000004@0oooo0`3o001m0?oo
o`00PP3oool30?l004D0oooo0P0000150?ooo`<0o`00O03oool00840oooo0`3o00160?ooo`800000
AP3oool30?l007/0oooo00200?ooo`<0o`00A`3oool2000004L0oooo0`3o001j0?ooo`00O`3oool3
0?l004P0oooo0`0000170?ooo`<0o`00N@3oool007h0oooo0`3o00190?ooo`800000B@3oool30?l0
07P0oooo001m0?ooo`<0o`00BP3oool2000004X0oooo0`3o001g0?ooo`00O03oool30?l004/0oooo
0P00001;0?ooo`<0o`00MP3oool007`0oooo0P3o001<0?ooo`800000C03oool20?l007H0oooo001k
0?ooo`80o`00C@3oool2000004d0oooo0P3o001e0?ooo`00NP3oool30?l004d0oooo0P00001=0?oo
o`<0o`00M03oool007T0oooo0`3o001>0?ooo`800000CP3oool30?l007<0oooo001h0?ooo`<0o`00
C`3oool2000004l0oooo0`3o001b0?ooo`00N03oool20?l00500oooo0P00001@0?ooo`<0o`00L@3o
ool007L0oooo0P3o001A0?ooo`800000D@3oool20?l00740oooo001f0?ooo`<0o`00D@3oool20000
0580oooo0P3o001`0?ooo`00M@3oool30?l00580oooo0`00001A0?ooo`<0o`00K`3oool007@0oooo
0`3o001C0?ooo`800000D`3oool30?l006h0oooo001d0?ooo`80o`00E03oool2000005@0oooo0`3o
001]0?ooo`00L`3oool20?l005D0oooo0P00001E0?ooo`<0o`00K03oool00780oooo0`3o001E0?oo
o`800000EP3oool20?l006`0oooo001a0?ooo`<0o`00<`3oool4000000L0oooo0P0000070?ooo`D0
00002P3oool2000005L0oooo0P3o001[0?ooo`00L03oool30?l003<0oooo0P0000030?ooo`800000
1@3oool2000000D0oooo0`0000040?ooo`800000203oool2000005L0oooo0`3o001Z0?ooo`00L03o
ool20?l003@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`090?ooo`<000001P3o
ool2000000L0oooo0P00001H0?ooo`<0o`00J@3oool006l0oooo0P3o000d0?ooo`8000001@3oool2
000000X0oooo0P0000070?ooo`8000001`3oool2000005T0oooo0P3o001Y0?ooo`00KP3oool30?l0
03@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`8000001`3oool20000
00L0oooo0P00001J0?ooo`80o`00J03oool006h0oooo0P3o000d0?ooo`8000001`3oool2000000T0
oooo0P0000060?ooo`<000001`3oool2000005/0oooo0P3o001W0?ooo`00K@3oool20?l003D0oooo
0P0000070?ooo`8000002P3oool2000000@0oooo0`0000080?ooo`800000G03oool00`3o0000oooo
0?ooo`1U0?ooo`00K03oool20?l003H0oooo0P0000070?ooo`8000002`3oool010000000oooo0?oo
o`3oool3000000T0oooo1000001J0?ooo`80o`00IP3oool006`0oooo00<0o`000?ooo`3oool0=@3o
ool2000000L0oooo0P00000<0?ooo`D000002P3oool2000005d0oooo0P3o001U0?ooo`00J`3oool2
0?l003L0oooo0P0000070?ooo`800000303oool4000000/0oooo0P00001N0?ooo`030?l0003oool0
oooo06<0oooo001[0?ooo`030?l0003oool0oooo03H0oooo0P0000070?ooo`8000002`3oool30000
0080oooo00<000000?ooo`3oool0203oool2000005h0oooo0P3o001T0?ooo`00JP3oool20?l003P0
oooo0P0000070?ooo`8000002P3oool3000000@0oooo0P0000080?ooo`800000G`3oool20?l006<0
oooo001Y0?ooo`80o`00>P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo
0`0000060?ooo`8000001`3oool200000600oooo00<0o`000?ooo`3oool0H@3oool006T0oooo00<0
o`000?ooo`3oool0>@3oool2000000D0oooo0P00000:0?ooo`8000001`3oool2000000L0oooo0P00
001P0?ooo`80o`00HP3oool006P0oooo0P3o000l0?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool02@3oool2000000L0oooo0P0000070?ooo`800000H@3oool00`3o0000oooo0?ooo`1P
0?ooo`00I`3oool20?l003d0oooo0P0000030?ooo`800000303oool2000000D0oooo0P0000080?oo
o`800000H@3oool20?l00640oooo001W0?ooo`030?l0003oool0oooo03h0oooo0`00000@0?ooo`H0
00002@3oool200000680oooo0P3o001P0?ooo`00IP3oool20?l00680oooo0P00001S0?ooo`030?l0
003oool0oooo05h0oooo001V0?ooo`030?l0003oool0oooo0640oooo0P00001S0?ooo`80o`00G`3o
ool006D0oooo0P3o001S0?ooo`800000I03oool20?l005h0oooo001T0?ooo`80o`00I03oool30000
06@0oooo00<0o`000?ooo`3oool0G03oool006@0oooo00<0o`000?ooo`3oool0H`3oool2000006D0
oooo0P3o001M0?ooo`00H`3oool20?l006D0oooo0P00001V0?ooo`80o`00G03oool00680oooo0P3o
001V0?ooo`800000I`3oool00`3o0000oooo0?ooo`1J0?ooo`00HP3oool00`3o0000oooo0?ooo`1U
0?ooo`800000I`3oool20?l005/0oooo001Q0?ooo`80o`00I`3oool2000006P0oooo0P3o001J0?oo
o`00H@3oool00`3o0000oooo0?ooo`1V0?ooo`800000J@3oool00`3o0000oooo0?ooo`1H0?ooo`00
H03oool20?l006P0oooo0P00001Y0?ooo`80o`00F@3oool001P0oooo1P0000110?ooo`80o`002P3o
ool4000000L0oooo0P0000050?ooo`D00000B03oool2000004l0oooo100000070?ooo`8000001@3o
ool5000000@0oooo00<0o`000?ooo`3oool0B@3oool6000000P0oooo000J0?ooo`800000@`3oool0
0`3o0000oooo0?ooo`080?ooo`8000000`3oool2000000D0oooo0P0000040?ooo`800000103oool0
0`000000oooo0?ooo`150?ooo`800000CP3oool2000000<0oooo0P0000050?ooo`800000103oool2
000000@0oooo00@000000?ooo`3oool0oooo0P3o001<0?ooo`8000002P3oool001X0oooo0P000012
0?ooo`80o`002P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool0A03oool2000004h0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0@
0?ooo`050000003oool0oooo0?ooo`3o0000C03oool2000000X0oooo000J0?ooo`800000@P3oool0
0`3o0000oooo0?ooo`080?ooo`8000001@3oool200000180oooo00<000000?ooo`3oool0@`3oool2
000004d0oooo0P0000050?ooo`8000004P3oool00`000000oooo0?ooo`020?l004/0oooo0P00000:
0?ooo`006P3oool200000440oooo0P3o000:0?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0403oool2000004@0oooo0`00001<0?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0403oool200000080oooo00<0o`000?ooo`3oool0B@3oool2000000X0oooo00040?ooo`d0
00002@3oool2000003X0oooo1`0000000`3o0000000000000003000000D0oooo0P0000070?ooo`80
00004@3oool2000004@0oooo0P00001<0?ooo`8000001`3oool200000140oooo0P0000020?ooo`80
o`00BP3oool2000000X0oooo00040?ooo`d000002@3oool2000003X0oooo1P0000020?l000D00000
1@3oool2000000L0oooo0P00000A0?ooo`800000A03oool2000004`0oooo0P0000070?ooo`800000
4@3oool2000000<0oooo0P3o00190?ooo`8000002P3oool001X0oooo0P00000o0?ooo`80o`002`3o
ool2000000L0oooo0P00000A0?ooo`800000A03oool2000004`0oooo0P0000070?ooo`8000004@3o
ool2000000@0oooo00<0o`000?ooo`3oool0A`3oool2000000X0oooo000J0?ooo`800000?`3oool0
0`3o0000oooo0?ooo`0:0?ooo`8000001`3oool200000100oooo0`0000140?ooo`800000C03oool2
000000L0oooo0P00000@0?ooo`<00000103oool20?l004P0oooo0P00000:0?ooo`006P3oool20000
03h0oooo0P3o000<0?ooo`8000001`3oool2000000l0oooo0`0000150?ooo`800000C03oool20000
00L0oooo0P00000?0?ooo`<000001P3oool00`3o0000oooo0?ooo`160?ooo`8000002P3oool001X0
oooo0P00000n0?ooo`030?l0003oool0oooo00/0oooo0P0000070?ooo`8000003@3oool4000004H0
oooo0P00001<0?ooo`8000001`3oool2000000d0oooo100000070?ooo`80o`00A`3oool2000000X0
oooo000J0?ooo`800000?@3oool20?l000d0oooo0P0000070?ooo`8000002P3oool6000004L0oooo
0P00001<0?ooo`8000001`3oool2000000X0oooo1P0000090?ooo`030?l0003oool0oooo04D0oooo
0P00000:0?ooo`006P3oool2000003d0oooo00<0o`000?ooo`3oool03@3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00X0oooo0`0000190?ooo`800000C@3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00X0oooo0`00000;0?ooo`80o`00AP3oool2000000X0oooo000J
0?ooo`800000?03oool20?l000l0oooo0P0000050?ooo`800000303oool00`000000oooo0?ooo`19
0?ooo`800000C@3oool2000000D0oooo0P00000<0?ooo`030000003oool0oooo00`0oooo00<0o`00
0?ooo`3oool0A03oool2000000X0oooo000J0?ooo`800000?03oool00`3o0000oooo0?ooo`0?0?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`180?oo
o`800000CP3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool02`3oool20?l004D0oooo0P00000:0?ooo`005`3oool5000003/0oooo0P3o000A0?ooo`80
00000`3oool2000000h0oooo1P0000150?ooo`800000CP3oool2000000<0oooo0P00000>0?ooo`H0
00002@3oool00`3o0000oooo0?ooo`100?ooo`D000002P3oool001T0oooo0`00000j0?ooo`80o`00
503oool300000140oooo1P0000140?ooo`<00000C`3oool300000140oooo1P0000080?ooo`80o`00
@`3oool3000000X0oooo001F0?ooo`030?l0003oool0oooo0740oooo0P00001c0?ooo`030?l0003o
ool0oooo04h0oooo001E0?ooo`80o`00L`3oool2000007<0oooo0P3o001?0?ooo`00E@3oool00`3o
0000oooo0?ooo`1b0?ooo`800000M03oool00`3o0000oooo0?ooo`1=0?ooo`00E03oool20?l007@0
oooo0P00001d0?ooo`80o`00CP3oool005@0oooo00<0o`000?ooo`3oool0L`3oool2000007D0oooo
0P3o001=0?ooo`00D`3oool20?l007D0oooo0P00001f0?ooo`030?l0003oool0oooo04/0oooo001C
0?ooo`030?l0003oool0oooo07@0oooo0P00001f0?ooo`80o`00C03oool00580oooo0P3o001f0?oo
o`800000M`3oool00`3o0000oooo0?ooo`1:0?ooo`00D@3oool20?l007L0oooo0P00001g0?ooo`80
o`00B`3oool00540oooo00<0o`000?ooo`3oool0MP3oool2000007P0oooo00<0o`000?ooo`3oool0
B@3oool00500oooo0P3o001h0?ooo`800000N03oool20?l004X0oooo001@0?ooo`030?l0003oool0
oooo07L0oooo0P00001i0?ooo`030?l0003oool0oooo04P0oooo00070?ooodP000000P3o003d0000
0080o`00A`0000020?ooo`001`3ooom8000000030?l00000000000000?@0000000<0o`0000000000
0000A@0000020?ooo`004@3oool00`000000oooo0?ooo`0j0?ooo`80o`007P3oool00`000000oooo
0?ooo`1I0?ooo`800000F`3oool00`000000oooo0?ooo`0L0?ooo`80o`00?03oool00`000000oooo
0?ooo`090?ooo`00CP3oool00`3o0000oooo0?ooo`1i0?ooo`800000N`3oool00`3o0000oooo0?oo
o`160?ooo`00C@3oool20?l007/0oooo0P00001k0?ooo`80o`00A`3oool004d0oooo00<0o`000?oo
o`3oool0NP3oool2000007`0oooo00<0o`000?ooo`3oool0A@3oool004d0oooo00<0o`000?ooo`3o
ool0NP3oool2000007`0oooo0P3o00160?ooo`00C03oool20?l007`0oooo0P00001m0?ooo`030?l0
003oool0oooo04@0oooo001<0?ooo`030?l0003oool0oooo07/0oooo0P00001m0?ooo`030?l0003o
ool0oooo04@0oooo001;0?ooo`80o`00O@3oool2000007d0oooo0P3o00150?ooo`00B`3oool00`3o
0000oooo0?ooo`1l0?ooo`800000OP3oool00`3o0000oooo0?ooo`130?ooo`00BP3oool20?l007h0
oooo0P00001n0?ooo`80o`00A03oool004X0oooo00<0o`000?ooo`3oool0O@3oool3000007h0oooo
00<0o`000?ooo`3oool0@P3oool004T0oooo0P3o001o0?ooo`800000O`3oool20?l004<0oooo0019
0?ooo`030?l0003oool0oooo07h0oooo0P0000200?ooo`030?l0003oool0oooo0440oooo00190?oo
o`030?l0003oool0oooo07h0oooo0P0000200?ooo`80o`00@P3oool004P0oooo0P3o00200?ooo`80
0000P@3oool00`3o0000oooo0?ooo`100?ooo`00B03oool00`3o0000oooo0?ooo`1o0?ooo`800000
P@3oool20?l00440oooo00170?ooo`80o`00P@3oool200000880oooo00<0o`000?ooo`3oool0?`3o
ool004L0oooo00<0o`000?ooo`3oool0P03oool200000880oooo0P3o00100?ooo`00AP3oool20?l0
0880oooo0P0000230?ooo`030?l0003oool0oooo03h0oooo00160?ooo`030?l0003oool0oooo0840
oooo0P0000230?ooo`80o`00?`3oool004H0oooo00<0o`000?ooo`3oool0P@3oool2000008@0oooo
00<0o`000?ooo`3oool0?@3oool004D0oooo0P3o00230?ooo`800000Q03oool20?l003h0oooo0015
0?ooo`030?l0003oool0oooo0880oooo0`0000240?ooo`030?l0003oool0oooo03`0oooo00140?oo
o`80o`00Q03oool2000008D0oooo00<0o`000?ooo`3oool0?03oool004@0oooo00<0o`000?ooo`3o
ool0P`3oool2000008D0oooo0P3o000m0?ooo`00@`3oool20?l008D0oooo0P0000260?ooo`030?l0
003oool0oooo03/0oooo00130?ooo`030?l0003oool0oooo08@0oooo0P0000260?ooo`80o`00?03o
ool00480oooo0P3o00260?ooo`800000Q`3oool00`3o0000oooo0?ooo`0j0?ooo`00@P3oool00`3o
0000oooo0?ooo`250?ooo`800000Q`3oool20?l003/0oooo00120?ooo`030?l0003oool0oooo08D0
oooo0P0000280?ooo`030?l0003oool0oooo03T0oooo00110?ooo`80o`00Q`3oool2000008P0oooo
0P3o000j0?ooo`00@@3oool00`3o0000oooo0?ooo`260?ooo`800000R@3oool00`3o0000oooo0?oo
o`0h0?ooo`00@03oool20?l008P0oooo0P0000290?ooo`80o`00>@3oool00400oooo00<0o`000?oo
o`3oool0Q`3oool2000008T0oooo0P3o000i0?ooo`00?`3oool20?l008T0oooo0P0000290?ooo`<0
o`00>03oool003l0oooo0P3o00290?ooo`<00000R@3oool20?l003P0oooo000n0?ooo`<0o`00R@3o
ool2000008X0oooo0`3o000g0?ooo`00?P3oool20?l008X0oooo0P00002;0?ooo`80o`00=`3oool0
03h0oooo0P3o002:0?ooo`800000R`3oool20?l003L0oooo000m0?ooo`80o`00J03oool6000000D0
oooo0P0000040?ooo`X00000203oool2000008/0oooo0`3o000f0?ooo`00?@3oool20?l006X0oooo
0P0000070?ooo`8000001@3oool9000000P0oooo0P00002<0?ooo`80o`00=P3oool003`0oooo0`3o
001Z0?ooo`8000003`3oool00`000000oooo0?ooo`040?ooo`8000001`3oool2000008`0oooo0P3o
000f0?ooo`00?03oool20?l006/0oooo0P00000@0?ooo`030000003oool0oooo00`0oooo0P00002<
0?ooo`<0o`00=@3oool003`0oooo0P3o001[0?ooo`8000004@3oool00`000000oooo0?ooo`0;0?oo
o`800000S@3oool20?l003D0oooo000k0?ooo`<0o`00J`3oool200000180oooo00<000000?ooo`3o
ool02P3oool2000008d0oooo0`3o000d0?ooo`00>`3oool20?l006`0oooo0P00000C0?ooo`030000
003oool0oooo00T0oooo0P00002>0?ooo`80o`00=03oool003/0oooo0P3o001/0?ooo`8000004`3o
ool00`000000oooo0?ooo`090?ooo`800000SP3oool20?l003@0oooo000j0?ooo`<0o`00K03oool2
000001@0oooo00<000000?ooo`3oool0203oool4000008`0oooo0`3o000c0?ooo`00>P3oool20?l0
06d0oooo0P00000E0?ooo`030000003oool0oooo00L0oooo0P00002?0?ooo`80o`00<`3oool003T0
oooo0`3o001]0?ooo`8000005@3oool00`000000oooo0?ooo`070?ooo`800000S`3oool20?l003<0
oooo000i0?ooo`80o`00KP3oool2000001D0oooo0P0000080?ooo`800000S`3oool30?l00380oooo
000i0?ooo`80o`00KP3oool2000000d0oooo00<000000?ooo`3oool01@3oool2000000P0oooo0P00
002@0?ooo`80o`00<P3oool003P0oooo0`3o001^0?ooo`8000003@3oool00`000000oooo0?ooo`05
0?ooo`800000203oool200000900oooo0`3o000a0?ooo`00>03oool20?l006l0oooo0P00000>0?oo
o`030000003oool0oooo0080oooo100000080?ooo`800000T@3oool20?l00340oooo000h0?ooo`80
o`00K03oool5000000h0oooo200000090?ooo`800000T@3oool20?l00340oooo000g0?ooo`<0o`00
KP3oool300000100oooo1000000;0?ooo`800000T@3oool30?l00300oooo000g0?ooo`80o`00T@3o
ool200000980oooo0P3o000`0?ooo`00=`3oool20?l00940oooo0P00002B0?ooo`80o`00<03oool0
03H0oooo0`3o002A0?ooo`800000TP3oool30?l002l0oooo000f0?ooo`80o`00TP3oool300000980
oooo0P3o000_0?ooo`00=@3oool30?l00980oooo0P00002C0?ooo`<0o`00;P3oool003D0oooo0P3o
002C0?ooo`800000U03oool20?l002h0oooo000e0?ooo`80o`00T`3oool2000009@0oooo0P3o000^
0?ooo`00=03oool30?l009<0oooo0P00002D0?ooo`<0o`00;@3oool003@0oooo0P3o002D0?ooo`80
0000U@3oool20?l002d0oooo000d0?ooo`80o`00U03oool2000009D0oooo0P3o000]0?ooo`00<`3o
ool30?l009@0oooo0P00002E0?ooo`<0o`00;03oool003<0oooo0P3o002E0?ooo`800000UP3oool2
0?l002`0oooo000c0?ooo`80o`00U@3oool2000009H0oooo0`3o000[0?ooo`00<P3oool30?l009D0
oooo0P00002G0?ooo`80o`00:`3oool00380oooo0P3o002F0?ooo`800000U`3oool20?l002/0oooo
000a0?ooo`<0o`00UP3oool2000009L0oooo0`3o000Z0?ooo`00<@3oool20?l009L0oooo0`00002G
0?ooo`80o`00:P3oool00340oooo0P3o002G0?ooo`800000V03oool20?l002X0oooo000`0?ooo`<0
o`00U`3oool2000009P0oooo0`3o000Y0?ooo`00<03oool20?l009P0oooo0P00002I0?ooo`80o`00
:@3oool00300oooo0P3o002H0?ooo`800000V@3oool20?l002T0oooo000_0?ooo`<0o`00V03oool2
000009T0oooo0P3o000Y0?ooo`00;`3oool20?l009T0oooo0P00002I0?ooo`<0o`00:03oool002l0
oooo0P3o002I0?ooo`800000VP3oool20?l002P0oooo000^0?ooo`<0o`00V@3oool2000009X0oooo
0P3o000X0?ooo`00;P3oool20?l009X0oooo0P00002J0?ooo`<0o`009`3oool002h0oooo0P3o002J
0?ooo`800000V`3oool20?l002L0oooo000]0?ooo`<0o`00VP3oool2000009/0oooo0P3o000W0?oo
o`00;@3oool20?l009/0oooo0`00002J0?ooo`<0o`009P3oool002d0oooo0P3o002K0?ooo`800000
W03oool20?l002H0oooo000/0?ooo`<0o`00V`3oool2000009`0oooo0P3o000V0?ooo`00;03oool2
0?l009`0oooo0P00002L0?ooo`<0o`009@3oool002`0oooo0P3o002B0?oooaL00000TP3oool20?l0
02D0oooo000[0?ooo`<0o`00N@3oool6000000D0oooo<00000270?ooo`80o`009@3oool002/0oooo
0P3o001l0?ooo`80000000<0oooo0000000000004`0000090?ooo`8000002P3ooolD000007l0oooo
0P3o000U0?ooo`00:`3oool20?l007L0oooo4000000;0?ooo`8000002@3oool2000001H0oooo4000
001g0?ooo`<0o`00903oool002X0oooo0`3o001c0?ooo``000004`3oool2000000T0oooo0P00000N
0?ooo``00000M03oool20?l002@0oooo000Z0?ooo`80o`00L03oool8000000D0oooo0P00000=0?oo
o`/000001`3oool2000002H0oooo2000001`0?ooo`80o`00903oool002X0oooo0P3o001]0?ooo`L0
00002@3oool2000000d0oooo00<000000?ooo`3oool0103oool2000000T0oooo0P00000Z0?ooo`P0
0000K03oool30?l002<0oooo000Y0?ooo`<0o`00J@3oool7000000d0oooo0P00000>0?ooo`030000
003oool0oooo00<0oooo0P0000090?ooo`800000;P3oool8000006T0oooo0P3o000S0?ooo`00:@3o
ool20?l006L0oooo1`00000@0?ooo`8000003`3oool00`000000oooo0?ooo`020?ooo`8000002@3o
ool400000300oooo2000001U0?ooo`80o`008`3oool002T0oooo0P3o001S0?ooo`L00000503oool2
000000l0oooo00<000000?ooo`3oool00P3oool2000000T0oooo0P00000f0?ooo`L00000HP3oool3
0?l00280oooo000X0?ooo`<0o`00H03oool7000001L0oooo0P00000@0?ooo`040000003oool0oooo
0?ooo`8000002@3oool2000003X0oooo1P00001P0?ooo`80o`008P3oool002P0oooo0P3o001O0?oo
o`H000006P3oool200000140oooo00<000000?ooo`3oool00P0000090?ooo`800000?@3oool60000
05d0oooo0P3o000R0?ooo`00:03oool20?l005`0oooo1P00000M0?ooo`8000004@3oool00`000000
oooo0?ooo`02000000T0oooo0P00000o0?ooo`H00000F`3oool30?l00240oooo000X0?ooo`80o`00
F@3oool7000001l0oooo0P00000B0?ooo`040000003oool00000000000T0oooo0P0000120?ooo`H0
0000F@3oool20?l00240oooo000W0?ooo`<0o`00E`3oool600000280oooo0P00000B0?ooo`040000
003oool00000000000T0oooo0P0000140?ooo`H00000E`3oool20?l00240oooo000W0?ooo`80o`00
E@3oool6000002D0oooo0P00000C0?ooo`<000002@3oool2000004L0oooo1P00001D0?ooo`80o`00
8@3oool002L0oooo0P3o001C0?ooo`H00000903oool5000001@0oooo0P0000090?ooo`800000B@3o
ool600000580oooo0`3o000P0?ooo`009P3oool30?l00500oooo1P00000Y0?ooo`<00000503oool2
000000T0oooo0P00001<0?ooo`D00000D@3oool20?l00200oooo000V0?ooo`80o`00C`3oool60000
04d0oooo0P00001>0?ooo`D00000C`3oool20?l00200oooo000V0?ooo`80o`00C@3oool500000500
oooo0P00001@0?ooo`H00000C03oool30?l001l0oooo000U0?ooo`<0o`00B`3oool500000580oooo
0`00001A0?ooo`H00000B`3oool20?l001l0oooo000U0?ooo`80o`00B@3oool6000005@0oooo0P00
001E0?ooo`D00000B@3oool20?l001l0oooo000U0?ooo`80o`00A`3oool6000005H0oooo0P00001G
0?ooo`D00000A`3oool30?l001h0oooo000T0?ooo`<0o`00A@3oool5000005T0oooo0P00001I0?oo
o`D00000AP3oool20?l001h0oooo000T0?ooo`80o`00A03oool5000005/0oooo0P00001K0?ooo`D0
0000A03oool20?l001h0oooo000T0?ooo`80o`00@P3oool5000005d0oooo0P00001M0?ooo`@00000
@`3oool30?l001d0oooo000S0?ooo`<0o`00@03oool5000005l0oooo0P00001O0?ooo`@00000@P3o
ool20?l001d0oooo000S0?ooo`80o`00@03oool400000640oooo0P00001P0?ooo`D00000@03oool2
0?l001d0oooo000S0?ooo`80o`00?P3oool4000006<0oooo0P00001R0?ooo`D00000?P3oool20?l0
01d0oooo000R0?ooo`<0o`00?03oool5000006@0oooo0P00001T0?ooo`@00000?@3oool30?l001`0
oooo000R0?ooo`80o`00>`3oool5000006H0oooo0P00001V0?ooo`@00000?03oool20?l001`0oooo
000R0?ooo`80o`00>@3oool5000006P0oooo0P00001W0?ooo`D00000>P3oool20?l001`0oooo000Q
0?ooo`<0o`00>03oool4000006X0oooo0P00001Y0?ooo`D00000>03oool30?l001/0oooo000Q0?oo
o`80o`00=`3oool4000006`0oooo0`00001Z0?ooo`@00000>03oool20?l001/0oooo000Q0?ooo`80
o`00=P3oool4000006d0oooo0P00001]0?ooo`@00000=P3oool20?l001/0oooo000P0?ooo`<0o`00
=03oool4000006l0oooo0P00001^0?ooo`@00000=@3oool20?l001/0oooo000P0?ooo`80o`00<`3o
ool500000700oooo0P00001`0?ooo`@00000<`3oool30?l001X0oooo000P0?ooo`80o`00<P3oool4
00000780oooo0P00001a0?ooo`D00000<P3oool20?l001X0oooo000O0?ooo`<0o`00<03oool40000
07@0oooo0P00001c0?ooo`@00000<@3oool20?l001X0oooo000O0?ooo`80o`00<03oool4000007D0
oooo0P00001e0?ooo`@00000;`3oool30?l001T0oooo000O0?ooo`80o`00;P3oool4000007L0oooo
0P00001f0?ooo`@00000;`3oool20?l001T0oooo000O0?ooo`80o`00;@3oool4000007P0oooo0P00
001h0?ooo`@00000;@3oool20?l001T0oooo000N0?ooo`<0o`00:`3oool4000007X0oooo0P00001i
0?ooo`@00000;03oool20?l001T0oooo000N0?ooo`80o`00:`3oool4000007/0oooo0P00001k0?oo
o`@00000:P3oool30?l001P0oooo000N0?ooo`80o`00:P3oool3000007d0oooo0P00001l0?ooo`@0
0000:P3oool20?l001P0oooo000M0?ooo`<0o`00:03oool4000007h0oooo0`00001m0?ooo`@00000
:03oool20?l001P0oooo000M0?ooo`80o`00:03oool4000007l0oooo0P00001o0?ooo`@000009`3o
ool30?l001L0oooo000M0?ooo`80o`009P3oool400000840oooo0P0000210?ooo`@000009P3oool2
0?l001L0oooo000M0?ooo`80o`009@3oool400000880oooo0P0000220?ooo`@000009@3oool20?l0
01L0oooo000L0?ooo`<0o`00903oool3000008@0oooo0P0000240?ooo`@000008`3oool20?l001L0
oooo000L0?ooo`80o`008`3oool400000680oooo1P0000050?ooo`8000001`3oool5000000X0oooo
0P0000250?ooo`@000008P3oool30?l001H0oooo000L0?ooo`80o`008P3oool4000006D0oooo0P00
00070?ooo`8000001P3oool2000000<0oooo0P0000090?ooo`800000Q`3oool400000240oooo0P3o
000F0?ooo`00703oool20?l00240oooo0`00001W0?ooo`8000003P3oool2000000D0oooo0P000008
0?ooo`800000R03oool400000200oooo0P3o000F0?ooo`006`3oool30?l001l0oooo1000001X0?oo
o`8000003P3oool2000000H0oooo00<000000?ooo`3oool01P3oool2000008X0oooo0`00000O0?oo
o`<0o`005@3oool001/0oooo0P3o000O0?ooo`@00000J@3oool2000000d0oooo0P0000070?ooo`80
00001`3oool2000008/0oooo1000000N0?ooo`80o`005@3oool001/0oooo0P3o000N0?ooo`<00000
J`3oool2000000d0oooo0P0000070?ooo`8000001`3oool2000008`0oooo1000000M0?ooo`80o`00
5@3oool001/0oooo0P3o000M0?ooo`<00000K03oool2000000d0oooo0P0000070?ooo`8000001`3o
ool2000008h0oooo0`00000L0?ooo`80o`005@3oool001X0oooo0`3o000K0?ooo`@00000K@3oool2
000000d0oooo0P0000070?ooo`8000001`3oool4000008d0oooo0`00000K0?ooo`<0o`00503oool0
01X0oooo0P3o000K0?ooo`@00000KP3oool2000000d0oooo0P0000060?ooo`800000203oool20000
0900oooo1000000J0?ooo`80o`00503oool001X0oooo0P3o000J0?ooo`<00000L03oool2000000d0
oooo100000030?ooo`<00000203oool200000940oooo1000000I0?ooo`80o`00503oool001T0oooo
0`3o000I0?ooo`<00000L@3oool2000000h0oooo0P0000000`3oool0000000000002000000X0oooo
0P00002C0?ooo`<00000603oool20?l001@0oooo000I0?ooo`80o`00603oool400000780oooo0P00
000>0?ooo`8000003`3oool2000009@0oooo0`00000G0?ooo`<0o`004`3oool001T0oooo0P3o000G
0?ooo`@00000L`3oool2000000l0oooo0P00000>0?ooo`800000U@3oool4000001H0oooo0P3o000C
0?ooo`006@3oool20?l001H0oooo0`00001e0?ooo`800000403oool2000000d0oooo0P00002F0?oo
o`@000005@3oool20?l001<0oooo000H0?ooo`<0o`005@3oool3000007H0oooo0P00000A0?ooo`80
0000303oool2000009P0oooo0`00000D0?ooo`<0o`004P3oool001P0oooo0P3o000E0?ooo`<00000
M03oool500000180oooo0`00000:0?ooo`800000V@3oool3000001@0oooo0P3o000B0?ooo`00603o
ool20?l001@0oooo0`00001g0?ooo`<00000503oool4000000L0oooo0P00002J0?ooo`<000004`3o
ool20?l00180oooo000H0?ooo`80o`004P3oool4000009X0oooo0P00002K0?ooo`<000004P3oool2
0?l00180oooo000G0?ooo`<0o`004@3oool4000009/0oooo0P00002L0?ooo`<000004@3oool30?l0
0140oooo000G0?ooo`80o`004@3oool3000009d0oooo0P00002M0?ooo`<000004@3oool20?l00140
oooo000G0?ooo`80o`00403oool3000009h0oooo0`00002M0?ooo`<00000403oool20?l00140oooo
000G0?ooo`80o`003`3oool3000009l0oooo0P00002O0?ooo`<000003`3oool30?l00100oooo000F
0?ooo`<0o`003P3oool300000:00oooo0P00002P0?ooo`@000003P3oool20?l00100oooo000F0?oo
o`80o`003P3oool300000:40oooo0P00002Q0?ooo`@000003@3oool20?l00100oooo000F0?ooo`80
o`003@3oool300000:80oooo0P00002S0?ooo`<00000303oool20?l00100oooo000E0?ooo`<0o`00
2`3oool400000:<0oooo0P00002T0?ooo`<000002`3oool30?l000l0oooo000E0?ooo`80o`002`3o
ool400000:@0oooo0P00002U0?ooo`<000002`3oool20?l000l0oooo000E0?ooo`80o`002P3oool3
00000:H0oooo0P00002V0?ooo`<000002P3oool20?l000l0oooo000E0?ooo`80o`002@3oool30000
0:L0oooo0P00002W0?ooo`<000002@3oool30?l000h0oooo000D0?ooo`<0o`00203oool300000:P0
oooo0P00002X0?ooo`<000002@3oool20?l000h0oooo000D0?ooo`80o`00203oool300000:T0oooo
0P00002Y0?ooo`<00000203oool20?l000h0oooo000D0?ooo`80o`001`3oool300000:X0oooo0P00
002Z0?ooo`<000001`3oool20?l000h0oooo000D0?ooo`80o`001P3oool300000:/0oooo0`00002Z
0?ooo`<000001P3oool30?l000d0oooo000C0?ooo`<0o`001@3oool300000:`0oooo0P00002/0?oo
o`<000001P3oool20?l000d0oooo000C0?ooo`80o`001@3oool300000:d0oooo0P00002]0?ooo`<0
00001@3oool20?l000d0oooo000C0?ooo`80o`00103oool300000:h0oooo0P00002^0?ooo`<00000
103oool30?l000`0oooo000C0?ooo`80o`000`3oool300000:l0oooo0P00002_0?ooo`<00000103o
ool20?l000`0oooo000B0?ooo`<0o`000P3oool300000;00oooo0P00002`0?ooo`<000000`3oool2
0?l000`0oooo000B0?ooo`80o`000P3oool300000;40oooo0P00002a0?ooo`<000000P3oool20?l0
00`0oooo000B0?ooo`80o`0000@0oooo0000000000000000/P3oool200000;80oooo0`0000000`3o
ool0o`000?l0000<0?ooo`004@3oool30?l000<00000/`3oool200000;<0oooo0`0000000`3oool0
o`000?l0000;0?ooo`004@3oool20?l000<00000]03oool200000;@0oooo0`0000020?l000/0oooo
000A0?ooo`040?l000000000000000000;D0oooo0P00002e0?ooo`<0000000<0o`000?ooo`3oool0
2@3oool00140oooo0`00002f0?ooo`800000]P3oool3000000/0oooo000@0?ooo`<00000]`3oool3
00000;H0oooo0`00000:0?ooo`004@3oool00`000000oooo0?ooo`2f0?ooo`800000^03oool00`00
0000o`000?ooo`090?ooo`00bP3oool200000<@0oooo003:0?ooo`800000a03oool00<X0oooo0P00
00340?ooo`00bP3oool200000<@0oooo003:0?ooo`800000a03oool00<X0oooo0P0000340?ooo`00
bP3oool200000<@0oooo003:0?ooo`800000a03oool00?l0ooooT@3oool00?l0ooooT@3oool00001
\
\>"],
  ImageRangeCache->{{{0, 399}, {319, 0}} -> {-1.09522, 0.499983, 0.00539229, \
0.00406034}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(Export["\<G:\Robert\Vorlesungen\V\
ariationsrechnung\Pr\[ADoubleDot]sentation\LoesungenRotionskoerper.png\>", 
      loesungenRotationskoerper, \ ImageSize \[Rule] 400]\)\)\)], "Input"],

Cell[BoxData[
    RowBox[{\(Export::"type"\), \(\(:\)\(\ \)\), \
"\<\"\\!\\(loesungenRotationskoerper\\) cannot be exported to the \
\\!\\(\\\"PNG\\\"\\) format. \\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", \
ButtonStyle->\\\"RefGuideLinkText\\\", ButtonFrame->None, \
ButtonData:>\\\"Export::type\\\"]\\)\"\>"}]], "Message"],

Cell[BoxData[
    \($Failed\)], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{
      TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
        False,
        Editable->False], "\[IndentingNewLine]"}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(endpunkte = 
      ListPlot[{{\(-1\), 1.75}, {1, 1.75}}, 
        PlotStyle \[Rule] \ {Hue[0.67], \ \ AbsolutePointSize[14]}, 
        ImageSize \[Rule] 400, \ AspectRatio \[Rule] 0.8, 
        TextStyle \[Rule] {FontFamily \[Rule] "\<Times\>", 
            FontSize \[Rule] fontSize}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .8 
%%ImageSize: 400 320 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 0.0190476 0.217687 [
[.02381 .00655 -17.6563 -31.75 ]
[.02381 .00655 17.6563 0 ]
[.2619 .00655 -27.4375 -31.75 ]
[.2619 .00655 27.4375 0 ]
[.7381 .00655 -18.3125 -31.75 ]
[.7381 .00655 18.3125 0 ]
[.97619 .00655 -8.53125 -31.75 ]
[.97619 .00655 8.53125 0 ]
[.4875 .12789 -36.625 -15.875 ]
[.4875 .12789 0 15.875 ]
[.4875 .23673 -17.0625 -15.875 ]
[.4875 .23673 0 15.875 ]
[.4875 .34558 -36.625 -15.875 ]
[.4875 .34558 0 15.875 ]
[.4875 .45442 -17.0625 -15.875 ]
[.4875 .45442 0 15.875 ]
[.4875 .56327 -36.625 -15.875 ]
[.4875 .56327 0 15.875 ]
[.4875 .67211 -17.0625 -15.875 ]
[.4875 .67211 0 15.875 ]
[.4875 .78095 -36.625 -15.875 ]
[.4875 .78095 0 15.875 ]
[ 0 0 0 0 ]
[ 1 .8 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .01905 m
.02381 .0253 L
s
gsave
.02381 .00655 -78.6563 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.2619 .01905 m
.2619 .0253 L
s
gsave
.2619 .00655 -88.4375 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.7381 .01905 m
.7381 .0253 L
s
gsave
.7381 .00655 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.97619 .01905 m
.97619 .0253 L
s
gsave
.97619 .00655 -69.5313 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.125 Mabswid
.07143 .01905 m
.07143 .0228 L
s
.11905 .01905 m
.11905 .0228 L
s
.16667 .01905 m
.16667 .0228 L
s
.21429 .01905 m
.21429 .0228 L
s
.30952 .01905 m
.30952 .0228 L
s
.35714 .01905 m
.35714 .0228 L
s
.40476 .01905 m
.40476 .0228 L
s
.45238 .01905 m
.45238 .0228 L
s
.54762 .01905 m
.54762 .0228 L
s
.59524 .01905 m
.59524 .0228 L
s
.64286 .01905 m
.64286 .0228 L
s
.69048 .01905 m
.69048 .0228 L
s
.78571 .01905 m
.78571 .0228 L
s
.83333 .01905 m
.83333 .0228 L
s
.88095 .01905 m
.88095 .0228 L
s
.92857 .01905 m
.92857 .0228 L
s
.25 Mabswid
0 .01905 m
1 .01905 L
s
.5 .12789 m
.50625 .12789 L
s
gsave
.4875 .12789 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.5 .23673 m
.50625 .23673 L
s
gsave
.4875 .23673 -78.0625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.5 .34558 m
.50625 .34558 L
s
gsave
.4875 .34558 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.5) show
1.000 setlinewidth
grestore
.5 .45442 m
.50625 .45442 L
s
gsave
.4875 .45442 -78.0625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2) show
1.000 setlinewidth
grestore
.5 .56327 m
.50625 .56327 L
s
gsave
.4875 .56327 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(2.5) show
1.000 setlinewidth
grestore
.5 .67211 m
.50625 .67211 L
s
gsave
.4875 .67211 -78.0625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3) show
1.000 setlinewidth
grestore
.5 .78095 m
.50625 .78095 L
s
gsave
.4875 .78095 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(3.5) show
1.000 setlinewidth
grestore
.125 Mabswid
.5 .04082 m
.50375 .04082 L
s
.5 .06259 m
.50375 .06259 L
s
.5 .08435 m
.50375 .08435 L
s
.5 .10612 m
.50375 .10612 L
s
.5 .14966 m
.50375 .14966 L
s
.5 .17143 m
.50375 .17143 L
s
.5 .1932 m
.50375 .1932 L
s
.5 .21497 m
.50375 .21497 L
s
.5 .2585 m
.50375 .2585 L
s
.5 .28027 m
.50375 .28027 L
s
.5 .30204 m
.50375 .30204 L
s
.5 .32381 m
.50375 .32381 L
s
.5 .36735 m
.50375 .36735 L
s
.5 .38912 m
.50375 .38912 L
s
.5 .41088 m
.50375 .41088 L
s
.5 .43265 m
.50375 .43265 L
s
.5 .47619 m
.50375 .47619 L
s
.5 .49796 m
.50375 .49796 L
s
.5 .51973 m
.50375 .51973 L
s
.5 .5415 m
.50375 .5415 L
s
.5 .58503 m
.50375 .58503 L
s
.5 .6068 m
.50375 .6068 L
s
.5 .62857 m
.50375 .62857 L
s
.5 .65034 m
.50375 .65034 L
s
.5 .69388 m
.50375 .69388 L
s
.5 .71565 m
.50375 .71565 L
s
.5 .73741 m
.50375 .73741 L
s
.5 .75918 m
.50375 .75918 L
s
.25 Mabswid
.5 0 m
.5 .8 L
s
0 0 m
1 0 L
1 .8 L
0 .8 L
closepath
clip
newpath
.02 0 1 r
14 Mabswid
.02381 .4 Mdot
.97619 .4 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{400, 320},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0001@2000`400?l00000o`00003oo`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00:`3oool6000004@0oooo1000
00070?ooo`8000001@3oool5000008L0oooo100000070?ooo`8000001@3oool5000004H0oooo1P00
000J0?ooo`00;@3oool2000004D0oooo0P0000030?ooo`8000001@3oool2000000@0oooo0P000004
0?ooo`030000003oool0oooo08<0oooo0P0000030?ooo`8000001@3oool2000000@0oooo0P000004
0?ooo`030000003oool0oooo04D0oooo0P00000L0?ooo`00;@3oool2000004D0oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo0880oooo00<000000?oo
o`3oool00`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0oooo04@0oooo0P00000L0?oo
o`00;@3oool2000004@0oooo0P0000050?ooo`8000004P3oool00`000000oooo0?ooo`200?ooo`80
00001@3oool200000180oooo00<000000?ooo`3oool0@`3oool2000001`0oooo000]0?ooo`800000
A03oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0100oooo0P0000210?ooo`030000
003oool0oooo00D0oooo00<000000?ooo`3oool0403oool2000004@0oooo0P00000L0?ooo`005`3o
ool=000000T0oooo0P00000b0?ooo`d00000103oool2000000L0oooo0P00000A0?ooo`800000P03o
ool2000000L0oooo0P00000A0?ooo`800000A03oool2000001`0oooo000G0?ooo`d000002@3oool2
00000380oooo3@0000040?ooo`8000001`3oool200000140oooo0P0000200?ooo`8000001`3oool2
00000140oooo0P0000140?ooo`800000703oool002d0oooo0P0000130?ooo`8000001`3oool20000
0140oooo0P0000200?ooo`8000001`3oool200000140oooo0P0000140?ooo`800000703oool002d0
oooo0P0000130?ooo`8000001`3oool200000100oooo0`0000200?ooo`8000001`3oool200000100
oooo0`0000140?ooo`800000703oool002d0oooo0P0000130?ooo`8000001`3oool2000000l0oooo
0`0000210?ooo`8000001`3oool2000000l0oooo0`0000150?ooo`800000703oool002d0oooo0P00
00130?ooo`8000001`3oool2000000d0oooo100000220?ooo`8000001`3oool2000000d0oooo1000
00160?ooo`800000703oool002d0oooo0P0000130?ooo`8000001`3oool2000000X0oooo1P000023
0?ooo`8000001`3oool2000000X0oooo1P0000170?ooo`800000703oool002d0oooo0P0000140?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool02P3oool3000008H0oooo00<000000?oo
o`3oool01@3oool00`000000oooo0?ooo`0:0?ooo`<00000B@3oool2000001`0oooo000]0?ooo`80
0000A03oool2000000D0oooo0P00000<0?ooo`030000003oool0oooo08H0oooo0P0000050?ooo`80
0000303oool00`000000oooo0?ooo`190?ooo`800000703oool002d0oooo0P0000150?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`260?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`180?ooo`800000
703oool002X0oooo1@0000150?ooo`8000000`3oool2000000h0oooo1P0000230?ooo`8000000`3o
ool2000000h0oooo1P0000120?ooo`D00000703oool002`0oooo0`0000170?ooo`<000004@3oool6
000008@0oooo0`00000A0?ooo`H00000@`3oool3000001`0oooo003o0?oooi40oooo003o0?oooi40
oooo003o0?oooi40oooo003o0?oooi40oooo003<0?ooo`030000003oool0oooo0<40oooo003<0?oo
o`030000003oool0oooo0<40oooo003<0?ooo`030000003oool0oooo0<40oooo003<0?ooo`030000
003oool0oooo0<40oooo003<0?ooo`030000003oool0oooo0<40oooo003<0?ooo`030000003oool0
oooo0<40oooo003<0?ooo`030000003oool0oooo0<40oooo000L0?ooool00000H@00000D0?ooo`00
9@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00h0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
3P3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0
6`3oool002D0oooo00<000000?ooo`3oool0D03oool00`000000oooo0?ooo`1A0?ooo`030000003o
ool0oooo0500oooo00<000000?ooo`3oool0D03oool00`000000oooo0?ooo`0K0?ooo`00c03oool0
0`000000oooo0?ooo`310?ooo`00c03oool00`000000oooo0?ooo`310?ooo`00c03oool00`000000
oooo0?ooo`310?ooo`00c03oool00`000000oooo0?ooo`310?ooo`00c03oool200000<80oooo003<
0?ooo`030000003oool0oooo0<40oooo003<0?ooo`030000003oool0oooo0<40oooo003<0?ooo`03
0000003oool0oooo0<40oooo003<0?ooo`030000003oool0oooo0<40oooo003<0?ooo`030000003o
ool0oooo0<40oooo003<0?ooo`030000003oool0oooo0<40oooo003<0?ooo`030000003oool0oooo
0<40oooo003<0?ooo`800000`P3oool00<`0oooo00<000000?ooo`3oool0`@3oool00<`0oooo00<0
00000?ooo`3oool0`@3oool00<`0oooo00<000000?ooo`3oool0`@3oool00<`0oooo00<000000?oo
o`3oool0`@3oool00<`0oooo00<000000?ooo`3oool0`@3oool00<`0oooo00<000000?ooo`3oool0
`@3oool00<`0oooo00<000000?ooo`3oool0`@3oool00<`0oooo0P0000320?ooo`00c03oool00`00
0000oooo0?ooo`310?ooo`00c03oool00`000000oooo0?ooo`310?ooo`00c03oool00`000000oooo
0?ooo`310?ooo`00c03oool00`000000oooo0?ooo`310?ooo`00c03oool00`000000oooo0?ooo`31
0?ooo`00c03oool00`000000oooo0?ooo`310?ooo`00Z@3oool4000000L0oooo0P0000050?ooo`D0
0000303oool200000<80oooo002X0?ooo`8000000`3oool2000000D0oooo0P0000040?ooo`800000
103oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo0<40oooo002X0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`080?ooo`030000003o
ool0oooo0<40oooo002W0?ooo`8000001@3oool200000180oooo00<000000?ooo`3oool01`3oool0
0`000000oooo0?ooo`310?ooo`00Y`3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
0100oooo0P0000080?ooo`030000003oool0oooo0<40oooo002V0?ooo`8000001`3oool200000140
oooo0P0000080?ooo`030000003oool0oooo0<40oooo002V0?ooo`8000001`3oool200000140oooo
0P0000080?ooo`030000003oool0oooo0<40oooo002V0?ooo`8000001`3oool200000140oooo0P00
00080?ooo`030000003oool0oooo0<40oooo002V0?ooo`8000001`3oool200000100oooo0`000008
0?ooo`<00000`@3oool00:H0oooo0P0000070?ooo`8000003`3oool3000000T0oooo00<000000?oo
o`3oool0`@3oool00:H0oooo0P0000070?ooo`8000003@3oool4000000X0oooo00<000000?ooo`3o
ool0`@3oool00:H0oooo0P0000070?ooo`8000002P3oool6000000/0oooo00<000000?ooo`3oool0
`@3oool00:L0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0:0?ooo`<000003@3o
ool00`000000oooo0?ooo`310?ooo`00Y`3oool2000000D0oooo0P00000<0?ooo`030000003oool0
oooo00d0oooo00<000000?ooo`3oool0`@3oool00:P0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0`@3oool00:P0
oooo0P0000030?ooo`8000003P3oool6000000T0oooo0P0000320?ooo`00ZP3oool300000140oooo
1P0000080?ooo`030000003oool0oooo0<40oooo003<0?ooo`030000003oool0oooo0<40oooo003<
0?ooo`030000003oool0oooo0<40oooo003<0?ooo`030000003oool0oooo0<40oooo003<0?ooo`03
0000003oool0oooo0<40oooo003<0?ooo`030000003oool0oooo0<40oooo003<0?ooo`030000003o
ool0oooo0<40oooo003<0?ooo`800000`P3oool00<`0oooo00<000000?ooo`3oool0`@3oool00<`0
oooo00<000000?ooo`3oool0`@3oool00<`0oooo00<000000?ooo`3oool0`@3oool00<`0oooo00<0
00000?ooo`3oool0`@3oool00<`0oooo00<000000?ooo`3oool0`@3oool00<`0oooo00<000000?oo
o`3oool0`@3oool00<`0oooo00<000000?ooo`3oool0`@3oool00<`0oooo0P0000320?ooo`00c03o
ool00`000000oooo0?ooo`310?ooo`00c03oool00`000000oooo0?ooo`310?ooo`00c03oool00`00
0000oooo0?ooo`310?ooo`00c03oool00`000000oooo0?ooo`310?ooo`00c03oool00`000000oooo
0?ooo`310?ooo`00c03oool00`000000oooo0?ooo`310?ooo`00_03oool6000000X0oooo0P000032
0?ooo`00_P3oool2000000`0oooo00<000000?ooo`3oool0`@3oool00;h0oooo0P00000<0?ooo`03
0000003oool0oooo0<40oooo002n0?ooo`800000303oool00`000000oooo0?ooo`310?ooo`00_P3o
ool2000000`0oooo00<000000?ooo`3oool0`@3oool00;h0oooo0P00000<0?ooo`030000003oool0
oooo0<40oooo002n0?ooo`800000303oool00`000000oooo0?ooo`310?ooo`00_P3oool2000000`0
oooo00<000000?ooo`3oool0`@3oool00;h0oooo0P00000<0?ooo`<00000`@3oool00;h0oooo0P00
000<0?ooo`030000003oool0oooo0<40oooo002n0?ooo`800000303oool00`000000oooo0?ooo`31
0?ooo`00_P3oool2000000`0oooo00<000000?ooo`3oool0`@3oool00;h0oooo0P00000<0?ooo`03
0000003oool0oooo0<40oooo002n0?ooo`800000303oool00`000000oooo0?ooo`310?ooo`00_P3o
ool2000000`0oooo00<000000?ooo`3oool0`@3oool00;/0oooo1@00000<0?ooo`030000003oool0
oooo0<40oooo002m0?ooo`<00000303oool200000<80oooo003<0?ooo`030000003oool0oooo0<40
oooo003<0?ooo`030000003oool0oooo0<40oooo003<0?ooo`030000003oool0oooo0<40oooo003<
0?ooo`030000003oool0oooo0<40oooo003<0?ooo`030000003oool0oooo0<40oooo003<0?ooo`03
0000003oool0oooo0<40oooo003<0?ooo`800000`P3oool00<`0oooo00<000000?ooo`3oool0`@3o
ool00<`0oooo00<000000?ooo`3oool0`@3oool00<`0oooo00<000000?ooo`3oool0`@3oool00<`0
oooo00<000000?ooo`3oool0`@3oool00<`0oooo00<000000?ooo`3oool0`@3oool00<`0oooo00<0
00000?ooo`3oool0`@3oool00<`0oooo00<000000?ooo`3oool0`@3oool00<`0oooo0P0000320?oo
o`00c03oool00`000000oooo0?ooo`310?ooo`00c03oool00`000000oooo0?ooo`310?ooo`00c03o
ool00`000000oooo0?ooo`310?ooo`00c03oool00`000000oooo0?ooo`310?ooo`00c03oool00`00
0000oooo0?ooo`310?ooo`00c03oool00`000000oooo0?ooo`310?ooo`00Z@3oool6000000D0oooo
0P0000050?ooo`D00000303oool200000<80oooo002[0?ooo`8000001`3oool2000000@0oooo0P00
00040?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0`@3oool00:/0oooo0P00000D
0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0`@3oool00:/0oooo0P00000E0?oo
o`030000003oool0oooo00L0oooo00<000000?ooo`3oool0`@3oool00:/0oooo0P00000E0?ooo`80
0000203oool00`000000oooo0?ooo`310?ooo`00Z`3oool2000001D0oooo0P0000080?ooo`030000
003oool0oooo0<40oooo002[0?ooo`8000005@3oool2000000P0oooo00<000000?ooo`3oool0`@3o
ool00:/0oooo0P00000E0?ooo`800000203oool00`000000oooo0?ooo`310?ooo`00Z`3oool20000
01@0oooo0`0000080?ooo`<00000`@3oool00:/0oooo0P00000C0?ooo`<000002@3oool00`000000
oooo0?ooo`310?ooo`00Z`3oool200000140oooo1000000:0?ooo`030000003oool0oooo0<40oooo
002[0?ooo`8000003P3oool6000000/0oooo00<000000?ooo`3oool0`@3oool00:/0oooo0P00000?
0?ooo`<000003@3oool00`000000oooo0?ooo`310?ooo`00Z`3oool2000000l0oooo00<000000?oo
o`3oool03@3oool00`000000oooo0?ooo`310?ooo`00Z`3oool200000100oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`310?ooo`00Z03oool500000100oooo1P0000090?ooo`030000
003oool0oooo0<40oooo002Z0?ooo`<000004@3oool6000000P0oooo0P0000320?ooo`00c03oool0
0`000000oooo0?ooo`310?ooo`00c03oool00`000000oooo0?ooo`310?ooo`00c03oool00`000000
oooo0?ooo`310?ooo`00c03oool00`000000oooo0?ooo`310?ooo`008P3oool600D0oj@0oooo00<0
00000?ooo`3oool0X@3oool600D0oaX0oooo000Q0?ooo`P01@3oX`3oool00`000000oooo0?ooo`2P
0?ooo`P01@3o6@3oool00200oooo2P050?nR0?ooo`800000X03oool:00D0oaP0oooo000O0?ooo``0
1@3oX@3oool00`000000oooo0?ooo`2N0?ooo``01@3o5`3oool001h0oooo3@050?nQ0?ooo`030000
003oool0oooo09d0oooo3@050?lG0?ooo`007P3oool>00D0oj00oooo00<000000?ooo`3oool0W@3o
ool>00D0oaH0oooo000N0?ooo`h01@3oX03oool00`000000oooo0?ooo`2M0?ooo`h01@3o5P3oool0
01h0oooo3P050?nP0?ooo`030000003oool0oooo09d0oooo3P050?lF0?ooo`007P3oool>00D0oj00
oooo00<000000?ooo`3oool0W@3oool>00D0oaH0oooo000N0?ooo`d01@3oX@3oool00`000000oooo
0?ooo`2M0?ooo`d01@3o5`3oool001l0oooo30050?nQ0?ooo`800000W`3oool<00D0oaL0oooo000P
0?ooo`X01@3oXP3oool00`000000oooo0?ooo`2O0?ooo`X01@3o603oool00240oooo20050?nS0?oo
o`030000003oool0oooo0:00oooo20050?lI0?ooo`008P3oool600D0oj@0oooo00<000000?ooo`3o
ool0X@3oool600D0oaX0oooo003<0?ooo`030000003oool0oooo0<40oooo003<0?ooo`030000003o
ool0oooo0<40oooo003<0?ooo`030000003oool0oooo0<40oooo003<0?ooo`030000003oool0oooo
0<40oooo002i0?ooo`X000002@3oool200000<80oooo002j0?ooo`T000002@3oool00`000000oooo
0?ooo`310?ooo`00^`3oool00`000000oooo0?ooo`040?ooo`800000203oool00`000000oooo0?oo
o`310?ooo`00_03oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0<40oooo002m0?oo
o`030000003oool0oooo00`0oooo00<000000?ooo`3oool0`@3oool00;h0oooo00<000000?ooo`3o
ool02`3oool00`000000oooo0?ooo`310?ooo`00_`3oool00`000000oooo0?ooo`0:0?ooo`030000
003oool0oooo0<40oooo002o0?ooo`030000003oool0oooo00X0oooo0`0000310?ooo`00`03oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo0<40oooo00310?ooo`030000003oool0oooo
00P0oooo00<000000?ooo`3oool0`@3oool00<40oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`310?ooo`00`@3oool2000000T0oooo00<000000?ooo`3oool0`@3oool00;T0oooo00<0
00000?ooo`3oool01@3oool2000000T0oooo00<000000?ooo`3oool0`@3oool00;T0oooo00<00000
0?ooo`3oool01@3oool2000000T0oooo00<000000?ooo`3oool0`@3oool00;X0oooo00<000000?oo
o`3oool00P3oool4000000T0oooo00<000000?ooo`3oool0`@3oool00;X0oooo2000000:0?ooo`80
0000`P3oool00;`0oooo1000000<0?ooo`030000003oool0oooo0<40oooo003<0?ooo`030000003o
ool0oooo0<40oooo003<0?ooo`030000003oool0oooo0<40oooo003<0?ooo`030000003oool0oooo
0<40oooo003<0?ooo`030000003oool0oooo0<40oooo003<0?ooo`030000003oool0oooo0<40oooo
003<0?ooo`800000`P3oool00<`0oooo00<000000?ooo`3oool0`@3oool00<`0oooo00<000000?oo
o`3oool0`@3oool00<`0oooo00<000000?ooo`3oool0`@3oool00<`0oooo00<000000?ooo`3oool0
`@3oool00<`0oooo00<000000?ooo`3oool0`@3oool00<`0oooo00<000000?ooo`3oool0`@3oool0
0<`0oooo00<000000?ooo`3oool0`@3oool00<`0oooo0P0000320?ooo`00c03oool00`000000oooo
0?ooo`310?ooo`00c03oool00`000000oooo0?ooo`310?ooo`00c03oool00`000000oooo0?ooo`31
0?ooo`00c03oool00`000000oooo0?ooo`310?ooo`00c03oool00`000000oooo0?ooo`310?ooo`00
c03oool00`000000oooo0?ooo`310?ooo`00c03oool00`000000oooo0?ooo`310?ooo`00YP3oool:
000000@0oooo0P0000050?ooo`D00000303oool200000<80oooo002W0?ooo`T00000103oool20000
00@0oooo0P0000040?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0`@3oool00:P0
oooo00<000000?ooo`3oool0103oool200000100oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`310?ooo`00Z@3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo00L0oooo
00<000000?ooo`3oool0`@3oool00:X0oooo00<000000?ooo`3oool05@3oool2000000P0oooo00<0
00000?ooo`3oool0`@3oool00:/0oooo00<000000?ooo`3oool0503oool2000000P0oooo00<00000
0?ooo`3oool0`@3oool00:`0oooo00<000000?ooo`3oool04`3oool2000000P0oooo00<000000?oo
o`3oool0`@3oool00:`0oooo00<000000?ooo`3oool04`3oool2000000P0oooo0`0000310?ooo`00
[@3oool00`000000oooo0?ooo`0A0?ooo`<00000203oool00`000000oooo0?ooo`310?ooo`00[P3o
ool00`000000oooo0?ooo`0?0?ooo`<000002@3oool00`000000oooo0?ooo`310?ooo`00[P3oool0
0`000000oooo0?ooo`0=0?ooo`@000002P3oool00`000000oooo0?ooo`310?ooo`00[P3oool20000
00/0oooo1P00000;0?ooo`030000003oool0oooo0<40oooo002V0?ooo`030000003oool0oooo00D0
oooo0P00000<0?ooo`<000003@3oool00`000000oooo0?ooo`310?ooo`00YP3oool00`000000oooo
0?ooo`050?ooo`800000303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0<40oooo
002W0?ooo`030000003oool0oooo0080oooo1000000=0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool0`@3oool00:L0oooo2000000>0?ooo`H000002@3oool200000<80oooo002Y0?oo
o`@000004@3oool6000000P0oooo00<000000?ooo`3oool0`@3oool00<`0oooo00<000000?ooo`3o
ool0`@3oool00<`0oooo00<000000?ooo`3oool0`@3oool00<`0oooo00<000000?ooo`3oool0`@3o
ool00<`0oooo00<000000?ooo`3oool0`@3oool00<`0oooo00<000000?ooo`3oool0`@3oool00<`0
oooo00<000000?ooo`3oool0`@3oool00<`0oooo0P0000320?ooo`00c03oool00`000000oooo0?oo
o`310?ooo`00c03oool00`000000oooo0?ooo`310?ooo`00c03oool00`000000oooo0?ooo`310?oo
o`00c03oool00`000000oooo0?ooo`310?ooo`00c03oool00`000000oooo0?ooo`310?ooo`00c03o
ool00`000000oooo0?ooo`310?ooo`00c03oool200000<80oooo003<0?ooo`030000003oool0oooo
0<40oooo003<0?ooo`030000003oool0oooo0<40oooo003<0?ooo`030000003oool0oooo0<40oooo
003<0?ooo`030000003oool0oooo0<40oooo003<0?ooo`030000003oool0oooo0<40oooo003<0?oo
o`030000003oool0oooo0<40oooo003<0?ooo`030000003oool0oooo0<40oooo002i0?ooo`L00000
303oool200000<80oooo002i0?ooo`<00000103oool00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo0<40oooo00310?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0`@3oool0
0<40oooo0P0000090?ooo`030000003oool0oooo0<40oooo00310?ooo`8000002@3oool00`000000
oooo0?ooo`310?ooo`00`@3oool2000000T0oooo00<000000?ooo`3oool0`@3oool00<00oooo0`00
00090?ooo`030000003oool0oooo0<40oooo002o0?ooo`@000002@3oool300000<40oooo002l0?oo
o`H000002P3oool00`000000oooo0?ooo`310?ooo`00_P3oool3000000/0oooo00<000000?ooo`3o
ool0`@3oool00;l0oooo0P00000;0?ooo`030000003oool0oooo0<40oooo00300?ooo`030000003o
ool0oooo00T0oooo00<000000?ooo`3oool0`@3oool00<00oooo0P00000:0?ooo`030000003oool0
oooo0<40oooo002i0?ooo`030000003oool0oooo00@0oooo0P00000:0?ooo`030000003oool0oooo
0<40oooo002j0?ooo`030000003oool0oooo0080oooo0`00000:0?ooo`030000003oool0oooo0<40
oooo002j0?ooo`L000002`3oool200000<80oooo002l0?ooo`@00000303oool00`000000oooo0?oo
o`310?ooo`00c03oool00`000000oooo0?ooo`310?ooo`00c03oool00`000000oooo0?ooo`310?oo
o`00c03oool00`000000oooo0?ooo`310?ooo`00c03oool00`000000oooo0?ooo`310?ooo`00c03o
ool00`000000oooo0?ooo`310?ooo`00c03oool00`000000oooo0?ooo`310?ooo`00c03oool20000
0<80oooo003<0?ooo`030000003oool0oooo0<40oooo003<0?ooo`030000003oool0oooo0<40oooo
003<0?ooo`030000003oool0oooo0<40oooo003<0?ooo`030000003oool0oooo0<40oooo003<0?oo
o`030000003oool0oooo0<40oooo003<0?ooo`030000003oool0oooo0<40oooo003<0?ooo`800000
`P3oool00<`0oooo00<000000?ooo`3oool0`@3oool00<`0oooo00<000000?ooo`3oool0`@3oool0
0<`0oooo00<000000?ooo`3oool0`@3oool00<`0oooo00<000000?ooo`3oool0`@3oool00<`0oooo
00<000000?ooo`3oool0`@3oool00<`0oooo00<000000?ooo`3oool0`@3oool00<`0oooo00<00000
0?ooo`3oool0`@3oool00:H0oooo1`0000070?ooo`8000001@3oool5000000`0oooo0P0000320?oo
o`00YP3oool3000000@0oooo00<000000?ooo`3oool0103oool2000000@0oooo0P0000040?ooo`03
0000003oool0oooo00T0oooo00<000000?ooo`3oool0`@3oool00:h0oooo00<000000?ooo`3oool0
403oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo0<40oooo002^0?ooo`8000004P3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo0<40oooo002^0?ooo`8000004P3oool2
000000P0oooo00<000000?ooo`3oool0`@3oool00:h0oooo0P00000B0?ooo`800000203oool00`00
0000oooo0?ooo`310?ooo`00[@3oool300000180oooo0P0000080?ooo`030000003oool0oooo0<40
oooo002/0?ooo`@000004P3oool2000000P0oooo00<000000?ooo`3oool0`@3oool00:T0oooo1P00
000B0?ooo`<00000203oool300000<40oooo002[0?ooo`<000004P3oool3000000T0oooo00<00000
0?ooo`3oool0`@3oool00:`0oooo0P00000@0?ooo`@000002P3oool00`000000oooo0?ooo`310?oo
o`00[@3oool00`000000oooo0?ooo`0;0?ooo`H000002`3oool00`000000oooo0?ooo`310?ooo`00
[@3oool2000000d0oooo0`00000=0?ooo`030000003oool0oooo0<40oooo002V0?ooo`030000003o
ool0oooo00@0oooo0P00000=0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool0`@3o
ool00:L0oooo00<000000?ooo`3oool00P3oool3000000h0oooo00<000000?ooo`3oool0303oool0
0`000000oooo0?ooo`310?ooo`00Y`3oool7000000l0oooo1P00003=0?ooo`00Z@3oool400000140
oooo1P00003<0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?oo
o`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 399}, {319, 0}} -> {-1.22288, -0.473637, 0.00599266, \
0.0131089}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(rot = Show[loesungenRotationskoerper1, endpunkte]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .8 
%%ImageSize: 400 320 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.47619 -0.325747 0.632399 [
[.02381 .29415 -17.6563 -31.75 ]
[.02381 .29415 17.6563 0 ]
[.2619 .29415 -27.4375 -31.75 ]
[.2619 .29415 27.4375 0 ]
[.7381 .29415 -18.3125 -31.75 ]
[.7381 .29415 18.3125 0 ]
[.97619 .29415 -8.53125 -31.75 ]
[.97619 .29415 8.53125 0 ]
[.4875 .05369 -36.625 -15.875 ]
[.4875 .05369 0 15.875 ]
[.4875 .18017 -36.625 -15.875 ]
[.4875 .18017 0 15.875 ]
[.4875 .43313 -36.625 -15.875 ]
[.4875 .43313 0 15.875 ]
[.4875 .55961 -36.625 -15.875 ]
[.4875 .55961 0 15.875 ]
[.4875 .68609 -36.625 -15.875 ]
[.4875 .68609 0 15.875 ]
[ -0.003 -0.003 0 0 ]
[ 1.003 .803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .30665 m
.02381 .3129 L
s
gsave
.02381 .29415 -78.6563 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.2619 .30665 m
.2619 .3129 L
s
gsave
.2619 .29415 -88.4375 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.7381 .30665 m
.7381 .3129 L
s
gsave
.7381 .29415 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.97619 .30665 m
.97619 .3129 L
s
gsave
.97619 .29415 -69.5313 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.125 Mabswid
.07143 .30665 m
.07143 .3104 L
s
.11905 .30665 m
.11905 .3104 L
s
.16667 .30665 m
.16667 .3104 L
s
.21429 .30665 m
.21429 .3104 L
s
.30952 .30665 m
.30952 .3104 L
s
.35714 .30665 m
.35714 .3104 L
s
.40476 .30665 m
.40476 .3104 L
s
.45238 .30665 m
.45238 .3104 L
s
.54762 .30665 m
.54762 .3104 L
s
.59524 .30665 m
.59524 .3104 L
s
.64286 .30665 m
.64286 .3104 L
s
.69048 .30665 m
.69048 .3104 L
s
.78571 .30665 m
.78571 .3104 L
s
.83333 .30665 m
.83333 .3104 L
s
.88095 .30665 m
.88095 .3104 L
s
.92857 .30665 m
.92857 .3104 L
s
.006 w
0 .30665 m
1 .30665 L
s
.25 Mabswid
.5 .05369 m
.50625 .05369 L
s
gsave
.4875 .05369 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.6) show
1.000 setlinewidth
grestore
.5 .18017 m
.50625 .18017 L
s
gsave
.4875 .18017 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.8) show
1.000 setlinewidth
grestore
.5 .43313 m
.50625 .43313 L
s
gsave
.4875 .43313 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.2) show
1.000 setlinewidth
grestore
.5 .55961 m
.50625 .55961 L
s
gsave
.4875 .55961 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.4) show
1.000 setlinewidth
grestore
.5 .68609 m
.50625 .68609 L
s
gsave
.4875 .68609 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1.6) show
1.000 setlinewidth
grestore
.125 Mabswid
.5 .08531 m
.50375 .08531 L
s
.5 .11693 m
.50375 .11693 L
s
.5 .14855 m
.50375 .14855 L
s
.5 .21179 m
.50375 .21179 L
s
.5 .24341 m
.50375 .24341 L
s
.5 .27503 m
.50375 .27503 L
s
.5 .33827 m
.50375 .33827 L
s
.5 .36989 m
.50375 .36989 L
s
.5 .40151 m
.50375 .40151 L
s
.5 .46475 m
.50375 .46475 L
s
.5 .49637 m
.50375 .49637 L
s
.5 .52799 m
.50375 .52799 L
s
.5 .59123 m
.50375 .59123 L
s
.5 .62285 m
.50375 .62285 L
s
.5 .65447 m
.50375 .65447 L
s
.5 .02207 m
.50375 .02207 L
s
.5 .71771 m
.50375 .71771 L
s
.5 .74933 m
.50375 .74933 L
s
.5 .78095 m
.50375 .78095 L
s
.006 w
.5 0 m
.5 .8 L
s
0 0 m
1 0 L
1 .8 L
0 .8 L
closepath
clip
newpath
1 0 0 r
.02381 .78095 m
.06244 .63616 L
.10458 .50248 L
.14415 .39689 L
.18221 .31125 L
.22272 .23511 L
.26171 .17476 L
.30316 .12299 L
.34309 .08396 L
.3815 .05559 L
.40134 .04425 L
.42237 .03458 L
.4419 .02772 L
.4602 .02311 L
.47058 .02126 L
.4757 .02056 L
.48045 .02003 L
.48473 .01964 L
.4893 .01934 L
.49192 .01921 L
.4932 .01917 L
.49438 .01913 L
.49543 .0191 L
.49658 .01908 L
.49775 .01906 L
.49897 .01905 L
.50028 .01905 L
.50148 .01905 L
.50211 .01906 L
.50281 .01907 L
.50353 .01908 L
.50421 .01909 L
.5066 .01916 L
.50795 .01921 L
.50918 .01926 L
.51371 .01953 L
.51848 .01992 L
.52366 .02048 L
.52847 .02112 L
.5394 .02302 L
.54992 .02544 L
.55985 .02825 L
.57844 .0349 L
.59846 .04414 L
.61691 .0546 L
.65631 .08345 L
.6942 .12008 L
.73454 .16957 L
.77336 .22849 L
.81464 .30479 L
Mistroke
.8544 .39336 L
.89265 .49448 L
.93334 .62171 L
.97252 .76621 L
.97619 .78095 L
Mfstroke
0 0 0 r
.02381 .78095 m
.06244 .74194 L
.10458 .70366 L
.14415 .67164 L
.18221 .64433 L
.22272 .61888 L
.26171 .59785 L
.30316 .57912 L
.34309 .56454 L
.3815 .55367 L
.40095 .54934 L
.42237 .54547 L
.44268 .54267 L
.45178 .54169 L
.46172 .54081 L
.4671 .54042 L
.4721 .54011 L
.47727 .53984 L
.48196 .53965 L
.48658 .5395 L
.4887 .53945 L
.49093 .5394 L
.49332 .53936 L
.49438 .53935 L
.49552 .53934 L
.49675 .53933 L
.49789 .53932 L
.49859 .53932 L
.49925 .53932 L
.50049 .53932 L
.50163 .53932 L
.50286 .53932 L
.50401 .53933 L
.50508 .53934 L
.50754 .53937 L
.51014 .53942 L
.51268 .53948 L
.51504 .53955 L
.5204 .53974 L
.5293 .54019 L
.53882 .54085 L
.54906 .54177 L
.56016 .54301 L
.58032 .5459 L
.60019 .54957 L
.62123 .55434 L
.65912 .56526 L
.69946 .58019 L
.73829 .59785 L
.77956 .62022 L
Mistroke
.81932 .64536 L
.85757 .67296 L
.89827 .70611 L
.93745 .74183 L
.97619 .78095 L
Mfstroke
.02 0 1 r
14 Mabswid
.02381 .78095 Mdot
.97619 .78095 Mdot
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{400, 320},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0001@2000`400?l00000o`00003oo`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00bP3oool200000<@0oooo003:
0?ooo`800000a03oool00<X0oooo0P0000340?ooo`00bP3oool200000<@0oooo003:0?ooo`800000
a03oool00<X0oooo0P0000340?ooo`00bP3oool200000<@0oooo003:0?ooo`800000a03oool00;/0
oooo7`3o002f0?ooo`00^03ooolV0?l00;80oooo002d0?ooo`L0o`003`3oool2000000h0oooo203o
002^0?ooo`00/@3oool70?l00180oooo0P00000B0?ooo`L0o`00Z`3oool00:l0oooo1P3o000E0?oo
o`8000005P3oool60?l00:P0oooo002/0?ooo`H0o`00603oool2000001P0oooo1P3o002V0?ooo`00
Y`3oool2000000L0o`000P3oool2000000L0oooo1@00000:0?ooo`8000006`3oool60?l00:<0oooo
002V0?ooo`030000003o0000o`0000@0o`001@3oool2000000H0oooo0P0000030?ooo`8000002@3o
ool2000001d0oooo1P3o002Q0?ooo`00Y03oool60?l00080oooo00<000000?ooo`3oool02P3oool2
000000D0oooo0P0000080?ooo`800000803oool60?l009h0oooo002R0?ooo`H0o`00103oool20000
00/0oooo0P0000060?ooo`030000003oool0oooo00H0oooo0P00000R0?ooo`H0o`00W03oool00:40
oooo103o00000`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo0P0000070?ooo`80
00001`3oool2000002D0oooo103o002K0?ooo`00W`3oool40?l000030?ooo`000000000000L0oooo
0P0000090?ooo`8000001`3oool2000000L0oooo0P00000W0?ooo`@0o`00V@3oool009h0oooo103o
00020?ooo`8000001`3oool2000000T0oooo0P0000070?ooo`8000001`3oool2000002P0oooo1@3o
002G0?ooo`00W03oool40?l000@0oooo0P0000070?ooo`8000002@3oool2000000L0oooo0P000007
0?ooo`@00000:03oool40?l009H0oooo002K0?ooo`@0o`001@3oool2000000L0oooo0P0000090?oo
o`8000001P3oool2000000P0oooo0P00000/0?ooo`<0o`00U@3oool009T0oooo103o00070?ooo`80
00001`3oool2000000T0oooo100000030?ooo`<00000203oool2000002d0oooo103o002C0?ooo`00
V03oool40?l000P0oooo0P0000070?ooo`8000002P3oool2000000030?ooo`000000000000800000
2P3oool2000002h0oooo103o002B0?ooo`00U`3oool30?l000X0oooo0P0000070?ooo`8000002P3o
ool2000000l0oooo0P00000`0?ooo`<0o`00T@3oool009H0oooo0`3o000<0?ooo`030000003oool0
oooo00D0oooo00<000000?ooo`3oool02P3oool2000000h0oooo0P00000a0?ooo`<0o`00T03oool0
09@0oooo103o000=0?ooo`8000001@3oool2000000d0oooo0P00000=0?ooo`800000<P3oool40?l0
08h0oooo002C0?ooo`@0o`003`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00d0
oooo0P00000<0?ooo`800000<`3oool40?l008d0oooo002B0?ooo`<0o`004@3oool2000000<0oooo
0P00000@0?ooo`<000002P3oool2000003D0oooo0`3o002<0?ooo`00T@3oool30?l001@0oooo0`00
000D0?ooo`@000001`3oool2000003H0oooo0`3o002;0?ooo`00S`3oool40?l003L0oooo0P00000g
0?ooo`@0o`00R@3oool008h0oooo103o000h0?ooo`800000>03oool40?l008P0oooo002=0?ooo`<0
o`00>P3oool3000003T0oooo0`3o00270?ooo`00S03oool30?l003/0oooo0P00000k0?ooo`<0o`00
QP3oool008/0oooo0`3o000l0?ooo`800000?03oool30?l008D0oooo002:0?ooo`<0o`00?@3oool2
000003d0oooo0`3o00240?ooo`00R@3oool30?l003h0oooo0P00000n0?ooo`<0o`00P`3oool008P0
oooo0`3o000o0?ooo`800000?`3oool30?l00880oooo00270?ooo`<0o`00@03oool200000400oooo
0`3o00210?ooo`00Q@3oool40?l00440oooo0P0000110?ooo`@0o`00O`3oool008@0oooo103o0012
0?ooo`800000@P3oool40?l007h0oooo00230?ooo`<0o`00A03oool2000004@0oooo0`3o001m0?oo
o`00PP3oool30?l004D0oooo0P0000150?ooo`<0o`00O03oool00840oooo0`3o00160?ooo`800000
AP3oool30?l007/0oooo00200?ooo`<0o`00A`3oool2000004L0oooo0`3o001j0?ooo`00O`3oool3
0?l004P0oooo0`0000170?ooo`<0o`00N@3oool007h0oooo0`3o00190?ooo`800000B@3oool30?l0
07P0oooo001m0?ooo`<0o`00BP3oool2000004X0oooo0`3o001g0?ooo`00O03oool30?l004/0oooo
0P00001;0?ooo`<0o`00MP3oool007`0oooo0P3o001<0?ooo`800000C03oool20?l007H0oooo001k
0?ooo`80o`00C@3oool2000004d0oooo0P3o001e0?ooo`00NP3oool30?l004d0oooo0P00001=0?oo
o`<0o`00M03oool007T0oooo0`3o001>0?ooo`800000CP3oool30?l007<0oooo001h0?ooo`<0o`00
C`3oool2000004l0oooo0`3o001b0?ooo`00N03oool20?l00500oooo0P00001@0?ooo`<0o`00L@3o
ool007L0oooo0P3o001A0?ooo`800000D@3oool20?l00740oooo001f0?ooo`<0o`00D@3oool20000
0580oooo0P3o001`0?ooo`00M@3oool30?l00580oooo0`00001A0?ooo`<0o`00K`3oool007@0oooo
0`3o001C0?ooo`800000D`3oool30?l006h0oooo001d0?ooo`80o`00E03oool2000005@0oooo0`3o
001]0?ooo`00L`3oool20?l005D0oooo0P00001E0?ooo`<0o`00K03oool00780oooo0`3o001E0?oo
o`800000EP3oool20?l006`0oooo001a0?ooo`<0o`00<`3oool4000000L0oooo0P0000070?ooo`D0
00002P3oool2000005L0oooo0P3o001[0?ooo`00L03oool30?l003<0oooo0P0000030?ooo`800000
1@3oool2000000D0oooo0`0000040?ooo`800000203oool2000005L0oooo0`3o001Z0?ooo`00L03o
ool20?l003@0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`090?ooo`<000001P3o
ool2000000L0oooo0P00001H0?ooo`<0o`00J@3oool006l0oooo0P3o000d0?ooo`8000001@3oool2
000000X0oooo0P0000070?ooo`8000001`3oool2000005T0oooo0P3o001Y0?ooo`00KP3oool30?l0
03@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`080?ooo`8000001`3oool20000
00L0oooo0P00001J0?ooo`80o`00J03oool006h0oooo0P3o000d0?ooo`8000001`3oool2000000T0
oooo0P0000060?ooo`<000001`3oool2000005/0oooo0P3o001W0?ooo`00K@3oool20?l003D0oooo
0P0000070?ooo`8000002P3oool2000000@0oooo0`0000080?ooo`800000G03oool00`3o0000oooo
0?ooo`1U0?ooo`00K03oool20?l003H0oooo0P0000070?ooo`8000002`3oool010000000oooo0?oo
o`3oool3000000T0oooo1000001J0?ooo`80o`00IP3oool006`0oooo00<0o`000?ooo`3oool0=@3o
ool2000000L0oooo0P00000<0?ooo`D000002P3oool2000005d0oooo0P3o001U0?ooo`00J`3oool2
0?l003L0oooo0P0000070?ooo`800000303oool4000000/0oooo0P00001N0?ooo`030?l0003oool0
oooo06<0oooo001[0?ooo`030?l0003oool0oooo03H0oooo0P0000070?ooo`8000002`3oool30000
0080oooo00<000000?ooo`3oool0203oool2000005h0oooo0P3o001T0?ooo`00JP3oool20?l003P0
oooo0P0000070?ooo`8000002P3oool3000000@0oooo0P0000080?ooo`800000G`3oool20?l006<0
oooo001Y0?ooo`80o`00>P3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00P0oooo
0`0000060?ooo`8000001`3oool200000600oooo00<0o`000?ooo`3oool0H@3oool006T0oooo00<0
o`000?ooo`3oool0>@3oool2000000D0oooo0P00000:0?ooo`8000001`3oool2000000L0oooo0P00
001P0?ooo`80o`00HP3oool006P0oooo0P3o000l0?ooo`030000003oool0oooo00<0oooo00<00000
0?ooo`3oool02@3oool2000000L0oooo0P0000070?ooo`800000H@3oool00`3o0000oooo0?ooo`1P
0?ooo`00I`3oool20?l003d0oooo0P0000030?ooo`800000303oool2000000D0oooo0P0000080?oo
o`800000H@3oool20?l00640oooo001W0?ooo`030?l0003oool0oooo03h0oooo0`00000@0?ooo`H0
00002@3oool200000680oooo0P3o001P0?ooo`00IP3oool20?l00680oooo0P00001S0?ooo`030?l0
003oool0oooo05h0oooo001V0?ooo`030?l0003oool0oooo0640oooo0P00001S0?ooo`80o`00G`3o
ool006D0oooo0P3o001S0?ooo`800000I03oool20?l005h0oooo001T0?ooo`80o`00I03oool30000
06@0oooo00<0o`000?ooo`3oool0G03oool006@0oooo00<0o`000?ooo`3oool0H`3oool2000006D0
oooo0P3o001M0?ooo`00H`3oool20?l006D0oooo0P00001V0?ooo`80o`00G03oool00680oooo0P3o
001V0?ooo`800000I`3oool00`3o0000oooo0?ooo`1J0?ooo`00HP3oool00`3o0000oooo0?ooo`1U
0?ooo`800000I`3oool20?l005/0oooo001Q0?ooo`80o`00I`3oool2000006P0oooo0P3o001J0?oo
o`00H@3oool00`3o0000oooo0?ooo`1V0?ooo`800000J@3oool00`3o0000oooo0?ooo`1H0?ooo`00
H03oool20?l006P0oooo0P00001Y0?ooo`80o`00F@3oool001P0oooo1P0000110?ooo`80o`002P3o
ool4000000L0oooo0P0000050?ooo`D00000B03oool2000004l0oooo100000070?ooo`8000001@3o
ool5000000@0oooo00<0o`000?ooo`3oool0B@3oool6000000P0oooo000J0?ooo`800000@`3oool0
0`3o0000oooo0?ooo`080?ooo`8000000`3oool2000000D0oooo0P0000040?ooo`800000103oool0
0`000000oooo0?ooo`150?ooo`800000CP3oool2000000<0oooo0P0000050?ooo`800000103oool2
000000@0oooo00@000000?ooo`3oool0oooo0P3o001<0?ooo`8000002P3oool001X0oooo0P000012
0?ooo`80o`002P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo0100oooo00<00000
0?ooo`3oool0A03oool2000004h0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0@
0?ooo`050000003oool0oooo0?ooo`3o0000C03oool2000000X0oooo000J0?ooo`800000@P3oool0
0`3o0000oooo0?ooo`080?ooo`8000001@3oool200000180oooo00<000000?ooo`3oool0@`3oool2
000004d0oooo0P0000050?ooo`8000004P3oool00`000000oooo0?ooo`020?l004/0oooo0P00000:
0?ooo`006P3oool200000440oooo0P3o000:0?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0403oool2000004@0oooo0`00001<0?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0403oool200000080oooo00<0o`000?ooo`3oool0B@3oool2000000X0oooo00040?ooo`d0
00002@3oool2000003X0oooo1`0000000`3o0000000000000003000000D0oooo0P0000070?ooo`80
00004@3oool2000004@0oooo0P00001<0?ooo`8000001`3oool200000140oooo0P0000020?ooo`80
o`00BP3oool2000000X0oooo00040?ooo`d000002@3oool2000003X0oooo1P0000020?l000D00000
1@3oool2000000L0oooo0P00000A0?ooo`800000A03oool2000004`0oooo0P0000070?ooo`800000
4@3oool2000000<0oooo0P3o00190?ooo`8000002P3oool001X0oooo0P00000o0?ooo`80o`002`3o
ool2000000L0oooo0P00000A0?ooo`800000A03oool2000004`0oooo0P0000070?ooo`8000004@3o
ool2000000@0oooo00<0o`000?ooo`3oool0A`3oool2000000X0oooo000J0?ooo`800000?`3oool0
0`3o0000oooo0?ooo`0:0?ooo`8000001`3oool200000100oooo0`0000140?ooo`800000C03oool2
000000L0oooo0P00000@0?ooo`<00000103oool20?l004P0oooo0P00000:0?ooo`006P3oool20000
03h0oooo0P3o000<0?ooo`8000001`3oool2000000l0oooo0`0000150?ooo`800000C03oool20000
00L0oooo0P00000?0?ooo`<000001P3oool00`3o0000oooo0?ooo`160?ooo`8000002P3oool001X0
oooo0P00000n0?ooo`030?l0003oool0oooo00/0oooo0P0000070?ooo`8000003@3oool4000004H0
oooo0P00001<0?ooo`8000001`3oool2000000d0oooo100000070?ooo`80o`00A`3oool2000000X0
oooo000J0?ooo`800000?@3oool20?l000d0oooo0P0000070?ooo`8000002P3oool6000004L0oooo
0P00001<0?ooo`8000001`3oool2000000X0oooo1P0000090?ooo`030?l0003oool0oooo04D0oooo
0P00000:0?ooo`006P3oool2000003d0oooo00<0o`000?ooo`3oool03@3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00X0oooo0`0000190?ooo`800000C@3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo00X0oooo0`00000;0?ooo`80o`00AP3oool2000000X0oooo000J
0?ooo`800000?03oool20?l000l0oooo0P0000050?ooo`800000303oool00`000000oooo0?ooo`19
0?ooo`800000C@3oool2000000D0oooo0P00000<0?ooo`030000003oool0oooo00`0oooo00<0o`00
0?ooo`3oool0A03oool2000000X0oooo000J0?ooo`800000?03oool00`3o0000oooo0?ooo`0?0?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`180?oo
o`800000CP3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00`0oooo00<000000?oo
o`3oool02`3oool20?l004D0oooo0P00000:0?ooo`005`3oool5000003/0oooo0P3o000A0?ooo`80
00000`3oool2000000h0oooo1P0000150?ooo`800000CP3oool2000000<0oooo0P00000>0?ooo`H0
00002@3oool00`3o0000oooo0?ooo`100?ooo`D000002P3oool001T0oooo0`00000j0?ooo`80o`00
503oool300000140oooo1P0000140?ooo`<00000C`3oool300000140oooo1P0000080?ooo`80o`00
@`3oool3000000X0oooo001F0?ooo`030?l0003oool0oooo0740oooo0P00001c0?ooo`030?l0003o
ool0oooo04h0oooo001E0?ooo`80o`00L`3oool2000007<0oooo0P3o001?0?ooo`00E@3oool00`3o
0000oooo0?ooo`1b0?ooo`800000M03oool00`3o0000oooo0?ooo`1=0?ooo`00E03oool20?l007@0
oooo0P00001d0?ooo`80o`00CP3oool005@0oooo00<0o`000?ooo`3oool0L`3oool2000007D0oooo
0P3o001=0?ooo`00D`3oool20?l007D0oooo0P00001f0?ooo`030?l0003oool0oooo04/0oooo001C
0?ooo`030?l0003oool0oooo07@0oooo0P00001f0?ooo`80o`00C03oool00580oooo0P3o001f0?oo
o`800000M`3oool00`3o0000oooo0?ooo`1:0?ooo`00D@3oool20?l007L0oooo0P00001g0?ooo`80
o`00B`3oool00540oooo00<0o`000?ooo`3oool0MP3oool2000007P0oooo00<0o`000?ooo`3oool0
B@3oool00500oooo0P3o001h0?ooo`800000N03oool20?l004X0oooo001@0?ooo`030?l0003oool0
oooo07L0oooo0P00001i0?ooo`030?l0003oool0oooo04P0oooo00070?ooodP000000P3o003d0000
0080o`00A`0000020?ooo`001`3ooom8000000030?l00000000000000?@0000000<0o`0000000000
0000A@0000020?ooo`004@3oool00`000000oooo0?ooo`0j0?ooo`80o`007P3oool00`000000oooo
0?ooo`1I0?ooo`800000F`3oool00`000000oooo0?ooo`0L0?ooo`80o`00?03oool00`000000oooo
0?ooo`090?ooo`00CP3oool00`3o0000oooo0?ooo`1i0?ooo`800000N`3oool00`3o0000oooo0?oo
o`160?ooo`00C@3oool20?l007/0oooo0P00001k0?ooo`80o`00A`3oool004d0oooo00<0o`000?oo
o`3oool0NP3oool2000007`0oooo00<0o`000?ooo`3oool0A@3oool004d0oooo00<0o`000?ooo`3o
ool0NP3oool2000007`0oooo0P3o00160?ooo`00C03oool20?l007`0oooo0P00001m0?ooo`030?l0
003oool0oooo04@0oooo001<0?ooo`030?l0003oool0oooo07/0oooo0P00001m0?ooo`030?l0003o
ool0oooo04@0oooo001;0?ooo`80o`00O@3oool2000007d0oooo0P3o00150?ooo`00B`3oool00`3o
0000oooo0?ooo`1l0?ooo`800000OP3oool00`3o0000oooo0?ooo`130?ooo`00BP3oool20?l007h0
oooo0P00001n0?ooo`80o`00A03oool004X0oooo00<0o`000?ooo`3oool0O@3oool3000007h0oooo
00<0o`000?ooo`3oool0@P3oool004T0oooo0P3o001o0?ooo`800000O`3oool20?l004<0oooo0019
0?ooo`030?l0003oool0oooo07h0oooo0P0000200?ooo`030?l0003oool0oooo0440oooo00190?oo
o`030?l0003oool0oooo07h0oooo0P0000200?ooo`80o`00@P3oool004P0oooo0P3o00200?ooo`80
0000P@3oool00`3o0000oooo0?ooo`100?ooo`00B03oool00`3o0000oooo0?ooo`1o0?ooo`800000
P@3oool20?l00440oooo00170?ooo`80o`00P@3oool200000880oooo00<0o`000?ooo`3oool0?`3o
ool004L0oooo00<0o`000?ooo`3oool0P03oool200000880oooo0P3o00100?ooo`00AP3oool20?l0
0880oooo0P0000230?ooo`030?l0003oool0oooo03h0oooo00160?ooo`030?l0003oool0oooo0840
oooo0P0000230?ooo`80o`00?`3oool004H0oooo00<0o`000?ooo`3oool0P@3oool2000008@0oooo
00<0o`000?ooo`3oool0?@3oool004D0oooo0P3o00230?ooo`800000Q03oool20?l003h0oooo0015
0?ooo`030?l0003oool0oooo0880oooo0`0000240?ooo`030?l0003oool0oooo03`0oooo00140?oo
o`80o`00Q03oool2000008D0oooo00<0o`000?ooo`3oool0?03oool004@0oooo00<0o`000?ooo`3o
ool0P`3oool2000008D0oooo0P3o000m0?ooo`00@`3oool20?l008D0oooo0P0000260?ooo`030?l0
003oool0oooo03/0oooo00130?ooo`030?l0003oool0oooo08@0oooo0P0000260?ooo`80o`00?03o
ool00480oooo0P3o00260?ooo`800000Q`3oool00`3o0000oooo0?ooo`0j0?ooo`00@P3oool00`3o
0000oooo0?ooo`250?ooo`800000Q`3oool20?l003/0oooo00120?ooo`030?l0003oool0oooo08D0
oooo0P0000280?ooo`030?l0003oool0oooo03T0oooo00110?ooo`80o`00Q`3oool2000008P0oooo
0P3o000j0?ooo`00@@3oool00`3o0000oooo0?ooo`260?ooo`800000R@3oool00`3o0000oooo0?oo
o`0h0?ooo`00@03oool20?l008P0oooo0P0000290?ooo`80o`00>@3oool00400oooo00<0o`000?oo
o`3oool0Q`3oool2000008T0oooo0P3o000i0?ooo`00?`3oool20?l008T0oooo0P0000290?ooo`<0
o`00>03oool003l0oooo0P3o00290?ooo`<00000R@3oool20?l003P0oooo000n0?ooo`<0o`00R@3o
ool2000008X0oooo0`3o000g0?ooo`00?P3oool20?l008X0oooo0P00002;0?ooo`80o`00=`3oool0
03h0oooo0P3o002:0?ooo`800000R`3oool20?l003L0oooo000m0?ooo`80o`00J03oool6000000D0
oooo0P0000040?ooo`X00000203oool2000008/0oooo0`3o000f0?ooo`00?@3oool20?l006X0oooo
0P0000070?ooo`8000001@3oool9000000P0oooo0P00002<0?ooo`80o`00=P3oool003`0oooo0`3o
001Z0?ooo`8000003`3oool00`000000oooo0?ooo`040?ooo`8000001`3oool2000008`0oooo0P3o
000f0?ooo`00?03oool20?l006/0oooo0P00000@0?ooo`030000003oool0oooo00`0oooo0P00002<
0?ooo`<0o`00=@3oool003`0oooo0P3o001[0?ooo`8000004@3oool00`000000oooo0?ooo`0;0?oo
o`800000S@3oool20?l003D0oooo000k0?ooo`<0o`00J`3oool200000180oooo00<000000?ooo`3o
ool02P3oool2000008d0oooo0`3o000d0?ooo`00>`3oool20?l006`0oooo0P00000C0?ooo`030000
003oool0oooo00T0oooo0P00002>0?ooo`80o`00=03oool003/0oooo0P3o001/0?ooo`8000004`3o
ool00`000000oooo0?ooo`090?ooo`800000SP3oool20?l003@0oooo000j0?ooo`<0o`00K03oool2
000001@0oooo00<000000?ooo`3oool0203oool4000008`0oooo0`3o000c0?ooo`00>P3oool20?l0
06d0oooo0P00000E0?ooo`030000003oool0oooo00L0oooo0P00002?0?ooo`80o`00<`3oool003T0
oooo0`3o001]0?ooo`8000005@3oool00`000000oooo0?ooo`070?ooo`800000S`3oool20?l003<0
oooo000i0?ooo`80o`00KP3oool2000001D0oooo0P0000080?ooo`800000S`3oool30?l00380oooo
000i0?ooo`80o`00KP3oool2000000d0oooo00<000000?ooo`3oool01@3oool2000000P0oooo0P00
002@0?ooo`80o`00<P3oool003P0oooo0`3o001^0?ooo`8000003@3oool00`000000oooo0?ooo`05
0?ooo`800000203oool200000900oooo0`3o000a0?ooo`00>03oool20?l006l0oooo0P00000>0?oo
o`030000003oool0oooo0080oooo100000080?ooo`800000T@3oool20?l00340oooo000h0?ooo`80
o`00K03oool5000000h0oooo200000090?ooo`800000T@3oool20?l00340oooo000g0?ooo`<0o`00
KP3oool300000100oooo1000000;0?ooo`800000T@3oool30?l00300oooo000g0?ooo`80o`00T@3o
ool200000980oooo0P3o000`0?ooo`00=`3oool20?l00940oooo0P00002B0?ooo`80o`00<03oool0
03H0oooo0`3o002A0?ooo`800000TP3oool30?l002l0oooo000f0?ooo`80o`00TP3oool300000980
oooo0P3o000_0?ooo`00=@3oool30?l00980oooo0P00002C0?ooo`<0o`00;P3oool003D0oooo0P3o
002C0?ooo`800000U03oool20?l002h0oooo000e0?ooo`80o`00T`3oool2000009@0oooo0P3o000^
0?ooo`00=03oool30?l009<0oooo0P00002D0?ooo`<0o`00;@3oool003@0oooo0P3o002D0?ooo`80
0000U@3oool20?l002d0oooo000d0?ooo`80o`00U03oool2000009D0oooo0P3o000]0?ooo`00<`3o
ool30?l009@0oooo0P00002E0?ooo`<0o`00;03oool003<0oooo0P3o002E0?ooo`800000UP3oool2
0?l002`0oooo000c0?ooo`80o`00U@3oool2000009H0oooo0`3o000[0?ooo`00<P3oool30?l009D0
oooo0P00002G0?ooo`80o`00:`3oool00380oooo0P3o002F0?ooo`800000U`3oool20?l002/0oooo
000a0?ooo`<0o`00UP3oool2000009L0oooo0`3o000Z0?ooo`00<@3oool20?l009L0oooo0`00002G
0?ooo`80o`00:P3oool00340oooo0P3o002G0?ooo`800000V03oool20?l002X0oooo000`0?ooo`<0
o`00U`3oool2000009P0oooo0`3o000Y0?ooo`00<03oool20?l009P0oooo0P00002I0?ooo`80o`00
:@3oool00300oooo0P3o002H0?ooo`800000V@3oool20?l002T0oooo000_0?ooo`<0o`00V03oool2
000009T0oooo0P3o000Y0?ooo`00;`3oool20?l009T0oooo0P00002I0?ooo`<0o`00:03oool002l0
oooo0P3o002I0?ooo`800000VP3oool20?l002P0oooo000^0?ooo`<0o`00V@3oool2000009X0oooo
0P3o000X0?ooo`00;P3oool20?l009X0oooo0P00002J0?ooo`<0o`009`3oool002h0oooo0P3o002J
0?ooo`800000V`3oool20?l002L0oooo000]0?ooo`<0o`00VP3oool2000009/0oooo0P3o000W0?oo
o`00;@3oool20?l009/0oooo0`00002J0?ooo`<0o`009P3oool002d0oooo0P3o002K0?ooo`800000
W03oool20?l002H0oooo000/0?ooo`<0o`00V`3oool2000009`0oooo0P3o000V0?ooo`00;03oool2
0?l009`0oooo0P00002L0?ooo`<0o`009@3oool002`0oooo0P3o002B0?oooaL00000TP3oool20?l0
02D0oooo000[0?ooo`<0o`00N@3oool6000000D0oooo<00000270?ooo`80o`009@3oool002/0oooo
0P3o001l0?ooo`80000000<0oooo0000000000004`0000090?ooo`8000002P3ooolD000007l0oooo
0P3o000U0?ooo`00:`3oool20?l007L0oooo4000000;0?ooo`8000002@3oool2000001H0oooo4000
001g0?ooo`<0o`00903oool002X0oooo0`3o001c0?ooo``000004`3oool2000000T0oooo0P00000N
0?ooo``00000M03oool20?l002@0oooo000Z0?ooo`80o`00L03oool8000000D0oooo0P00000=0?oo
o`/000001`3oool2000002H0oooo2000001`0?ooo`80o`00903oool002X0oooo0P3o001]0?ooo`L0
00002@3oool2000000d0oooo00<000000?ooo`3oool0103oool2000000T0oooo0P00000Z0?ooo`P0
0000K03oool30?l002<0oooo000Y0?ooo`<0o`00J@3oool7000000d0oooo0P00000>0?ooo`030000
003oool0oooo00<0oooo0P0000090?ooo`800000;P3oool8000006T0oooo0P3o000S0?ooo`00:@3o
ool20?l006L0oooo1`00000@0?ooo`8000003`3oool00`000000oooo0?ooo`020?ooo`8000002@3o
ool400000300oooo2000001U0?ooo`80o`008`3oool002T0oooo0P3o001S0?ooo`L00000503oool2
000000l0oooo00<000000?ooo`3oool00P3oool2000000T0oooo0P00000f0?ooo`L00000HP3oool3
0?l00280oooo000X0?ooo`<0o`00H03oool7000001L0oooo0P00000@0?ooo`040000003oool0oooo
0?ooo`8000002@3oool2000003X0oooo1P00001P0?ooo`80o`008P3oool002P0oooo0P3o001O0?oo
o`H000006P3oool200000140oooo00<000000?ooo`3oool00P0000090?ooo`800000?@3oool60000
05d0oooo0P3o000R0?ooo`00:03oool20?l005`0oooo1P00000M0?ooo`8000004@3oool00`000000
oooo0?ooo`02000000T0oooo0P00000o0?ooo`H00000F`3oool30?l00240oooo000X0?ooo`80o`00
F@3oool7000001l0oooo0P00000B0?ooo`040000003oool00000000000T0oooo0P0000120?ooo`H0
0000F@3oool20?l00240oooo000W0?ooo`<0o`00E`3oool600000280oooo0P00000B0?ooo`040000
003oool00000000000T0oooo0P0000140?ooo`H00000E`3oool20?l00240oooo000W0?ooo`80o`00
E@3oool6000002D0oooo0P00000C0?ooo`<000002@3oool2000004L0oooo1P00001D0?ooo`80o`00
8@3oool002L0oooo0P3o001C0?ooo`H00000903oool5000001@0oooo0P0000090?ooo`800000B@3o
ool600000580oooo0`3o000P0?ooo`009P3oool30?l00500oooo1P00000Y0?ooo`<00000503oool2
000000T0oooo0P00001<0?ooo`D00000D@3oool20?l00200oooo000V0?ooo`80o`00C`3oool60000
04d0oooo0P00001>0?ooo`D00000C`3oool20?l00200oooo000V0?ooo`80o`00C@3oool500000500
oooo0P00001@0?ooo`H00000C03oool30?l001l0oooo000U0?ooo`<0o`00B`3oool500000580oooo
0`00001A0?ooo`H00000B`3oool20?l001l0oooo000U0?ooo`80o`00B@3oool6000005@0oooo0P00
001E0?ooo`D00000B@3oool20?l001l0oooo000U0?ooo`80o`00A`3oool6000005H0oooo0P00001G
0?ooo`D00000A`3oool30?l001h0oooo000T0?ooo`<0o`00A@3oool5000005T0oooo0P00001I0?oo
o`D00000AP3oool20?l001h0oooo000T0?ooo`80o`00A03oool5000005/0oooo0P00001K0?ooo`D0
0000A03oool20?l001h0oooo000T0?ooo`80o`00@P3oool5000005d0oooo0P00001M0?ooo`@00000
@`3oool30?l001d0oooo000S0?ooo`<0o`00@03oool5000005l0oooo0P00001O0?ooo`@00000@P3o
ool20?l001d0oooo000S0?ooo`80o`00@03oool400000640oooo0P00001P0?ooo`D00000@03oool2
0?l001d0oooo000S0?ooo`80o`00?P3oool4000006<0oooo0P00001R0?ooo`D00000?P3oool20?l0
01d0oooo000R0?ooo`<0o`00?03oool5000006@0oooo0P00001T0?ooo`@00000?@3oool30?l001`0
oooo000R0?ooo`80o`00>`3oool5000006H0oooo0P00001V0?ooo`@00000?03oool20?l001`0oooo
000R0?ooo`80o`00>@3oool5000006P0oooo0P00001W0?ooo`D00000>P3oool20?l001`0oooo000Q
0?ooo`<0o`00>03oool4000006X0oooo0P00001Y0?ooo`D00000>03oool30?l001/0oooo000Q0?oo
o`80o`00=`3oool4000006`0oooo0`00001Z0?ooo`@00000>03oool20?l001/0oooo000Q0?ooo`80
o`00=P3oool4000006d0oooo0P00001]0?ooo`@00000=P3oool20?l001/0oooo000P0?ooo`<0o`00
=03oool4000006l0oooo0P00001^0?ooo`@00000=@3oool20?l001/0oooo000P0?ooo`80o`00<`3o
ool500000700oooo0P00001`0?ooo`@00000<`3oool30?l001X0oooo000P0?ooo`80o`00<P3oool4
00000780oooo0P00001a0?ooo`D00000<P3oool20?l001X0oooo000O0?ooo`<0o`00<03oool40000
07@0oooo0P00001c0?ooo`@00000<@3oool20?l001X0oooo000O0?ooo`80o`00<03oool4000007D0
oooo0P00001e0?ooo`@00000;`3oool30?l001T0oooo000O0?ooo`80o`00;P3oool4000007L0oooo
0P00001f0?ooo`@00000;`3oool20?l001T0oooo000O0?ooo`80o`00;@3oool4000007P0oooo0P00
001h0?ooo`@00000;@3oool20?l001T0oooo000N0?ooo`<0o`00:`3oool4000007X0oooo0P00001i
0?ooo`@00000;03oool20?l001T0oooo000N0?ooo`80o`00:`3oool4000007/0oooo0P00001k0?oo
o`@00000:P3oool30?l001P0oooo000N0?ooo`80o`00:P3oool3000007d0oooo0P00001l0?ooo`@0
0000:P3oool20?l001P0oooo000M0?ooo`<0o`00:03oool4000007h0oooo0`00001m0?ooo`@00000
:03oool20?l001P0oooo000M0?ooo`80o`00:03oool4000007l0oooo0P00001o0?ooo`@000009`3o
ool30?l001L0oooo000M0?ooo`80o`009P3oool400000840oooo0P0000210?ooo`@000009P3oool2
0?l001L0oooo000M0?ooo`80o`009@3oool400000880oooo0P0000220?ooo`@000009@3oool20?l0
01L0oooo000L0?ooo`<0o`00903oool3000008@0oooo0P0000240?ooo`@000008`3oool20?l001L0
oooo000L0?ooo`80o`008`3oool400000680oooo1P0000050?ooo`8000001`3oool5000000X0oooo
0P0000250?ooo`@000008P3oool30?l001H0oooo000L0?ooo`80o`008P3oool4000006D0oooo0P00
00070?ooo`8000001P3oool2000000<0oooo0P0000090?ooo`800000Q`3oool400000240oooo0P3o
000F0?ooo`00703oool20?l00240oooo0`00001W0?ooo`8000003P3oool2000000D0oooo0P000008
0?ooo`800000R03oool400000200oooo0P3o000F0?ooo`006`3oool30?l001l0oooo1000001X0?oo
o`8000003P3oool2000000H0oooo00<000000?ooo`3oool01P3oool2000008X0oooo0`00000O0?oo
o`<0o`005@3oool001/0oooo0P3o000O0?ooo`@00000J@3oool2000000d0oooo0P0000070?ooo`80
00001`3oool2000008/0oooo1000000N0?ooo`80o`005@3oool001/0oooo0P3o000N0?ooo`<00000
J`3oool2000000d0oooo0P0000070?ooo`8000001`3oool2000008`0oooo1000000M0?ooo`80o`00
5@3oool001/0oooo0P3o000M0?ooo`<00000K03oool2000000d0oooo0P0000070?ooo`8000001`3o
ool2000008h0oooo0`00000L0?ooo`80o`005@3oool001X0oooo0`3o000K0?ooo`@00000K@3oool2
000000d0oooo0P0000070?ooo`8000001`3oool4000008d0oooo0`00000K0?ooo`<0o`00503oool0
01X0oooo0P3o000K0?ooo`@00000KP3oool2000000d0oooo0P0000060?ooo`800000203oool20000
0900oooo1000000J0?ooo`80o`00503oool001X0oooo0P3o000J0?ooo`<00000L03oool2000000d0
oooo100000030?ooo`<00000203oool200000940oooo1000000I0?ooo`80o`00503oool001T0oooo
0`3o000I0?ooo`<00000L@3oool2000000h0oooo0P0000000`3oool0000000000002000000X0oooo
0P00002C0?ooo`<00000603oool20?l001@0oooo000I0?ooo`80o`00603oool400000780oooo0P00
000>0?ooo`8000003`3oool2000009@0oooo0`00000G0?ooo`<0o`004`3oool001T0oooo0P3o000G
0?ooo`@00000L`3oool2000000l0oooo0P00000>0?ooo`800000U@3oool4000001H0oooo0P3o000C
0?ooo`006@3oool20?l001H0oooo0`00001e0?ooo`800000403oool2000000d0oooo0P00002F0?oo
o`@000005@3oool20?l001<0oooo000H0?ooo`<0o`005@3oool3000007H0oooo0P00000A0?ooo`80
0000303oool2000009P0oooo0`00000D0?ooo`<0o`004P3oool001P0oooo0P3o000E0?ooo`<00000
M03oool500000180oooo0`00000:0?ooo`800000V@3oool3000001@0oooo0P3o000B0?ooo`00603o
ool20?l001@0oooo0`00001g0?ooo`<00000503oool4000000L0oooo0P00002J0?ooo`<000004`3o
ool20?l00180oooo000H0?ooo`80o`004P3oool4000009X0oooo0P00002K0?ooo`<000004P3oool2
0?l00180oooo000G0?ooo`<0o`004@3oool4000009/0oooo0P00002L0?ooo`<000004@3oool30?l0
0140oooo000G0?ooo`80o`004@3oool3000009d0oooo0P00002M0?ooo`<000004@3oool20?l00140
oooo000G0?ooo`80o`00403oool3000009h0oooo0`00002M0?ooo`<00000403oool20?l00140oooo
000G0?ooo`80o`003`3oool3000009l0oooo0P00002O0?ooo`<000003`3oool30?l00100oooo000F
0?ooo`<0o`003P3oool300000:00oooo0P00002P0?ooo`@000003P3oool20?l00100oooo000F0?oo
o`80o`003P3oool300000:40oooo0P00002Q0?ooo`@000003@3oool20?l00100oooo000F0?ooo`80
o`003@3oool300000:80oooo0P00002S0?ooo`<00000303oool20?l00100oooo000E0?ooo`<0o`00
2`3oool400000:<0oooo0P00002T0?ooo`<000002`3oool30?l000l0oooo000E0?ooo`80o`002`3o
ool400000:@0oooo0P00002U0?ooo`<000002`3oool20?l000l0oooo000E0?ooo`80o`002P3oool3
00000:H0oooo0P00002V0?ooo`<000002P3oool20?l000l0oooo000E0?ooo`80o`002@3oool30000
0:L0oooo0P00002W0?ooo`<000002@3oool30?l000h0oooo000D0?ooo`<0o`00203oool300000:P0
oooo0P00002X0?ooo`<000002@3oool20?l000h0oooo000D0?ooo`80o`00203oool300000:T0oooo
0P00002Y0?ooo`<00000203oool20?l000h0oooo000D0?ooo`80o`001`3oool300000:X0oooo0P00
002Z0?ooo`<000001`3oool20?l000h0oooo000D0?ooo`80o`001P3oool300000:/0oooo0`00002Z
0?ooo`<000001P3oool30?l000d0oooo000C0?ooo`<0o`001@3oool300000:`0oooo0P00002/0?oo
o`<000001P3oool20?l000d0oooo000C0?ooo`80o`001@3oool300000:d0oooo0P00002]0?ooo`<0
00001@3oool20?l000d0oooo000C0?ooo`80o`00103oool300000:h0oooo0P00002^0?ooo`<00000
103oool30?l000`0oooo000C0?ooo`80o`000`3oool300000:l0oooo0P00002_0?ooo`<00000103o
ool20?l000`0oooo000B0?ooo`<0o`000P3oool300000;00oooo0P00002`0?ooo`<000000`3oool2
0?l000`0oooo000?0?ooo`H01@3o00@0oooo0000000000000000/@3oool200000;40oooo0`000002
0?ooo`H01@3o203oool000h0oooo20050?l200000;80oooo0P00002b0?ooo`<0000020050?l70?oo
o`003@3oool:00D0ok<0oooo0P00002c0?ooo`03000000050?l01@3o00P01@3o1P3oool000`0oooo
30050?nb0?ooo`800000/`3oool<00D0o`D0oooo000;0?ooo`d01@3o/P3oool200000;80oooo3@05
0?l50?ooo`002`3oool>00D0ok40oooo0P00002b0?ooo`h01@3o103oool000/0oooo3P050?na0?oo
o`<00000/@3oool>00D0o`@0oooo000;0?ooo`h01@3o/@3oool200000;80oooo3P050?l40?ooo`00
2`3oool>00D0ok40oooo0P00002b0?ooo`h01@3o103oool000/0oooo3@050?nb0?ooo`800000/P3o
ool=00D0o`D0oooo000<0?ooo``01@3o/P3oool200000;<0oooo30050?l50?ooo`003@3oool:00D0
ok<0oooo0P00002d0?ooo`X01@3o1P3oool000h0oooo20050?nd0?ooo`800000]@3oool800D0o`L0
oooo000?0?ooo`H01@3o]@3oool200000;H0oooo1P050?l80?ooo`00bP3oool200000<@0oooo003:
0?ooo`800000a03oool00?l0ooooT@3oool00?l0ooooT@3oool00001\
\>"],
  ImageRangeCache->{{{0, 399}, {319, 0}} -> {-1.09522, 0.499983, 0.00539231, \
0.00406035}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<G:\Robert\Vorlesungen\Variationsrechnung\Pr\[ADoubleDot]\
sentation\Rot.png\>", rot, \ ImageSize \[Rule] 400]\)], "Input"],

Cell[BoxData[
    \("G:\\Robert\\Vorlesungen\\Variationsrechnung\\Pr\[ADoubleDot]sentation\\\
Rot.png"\)], "Output"]
}, Open  ]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<G:\Robert\Vorlesungen\Variationsrechnung\Pr\[ADoubleDot]\
sentation\endpunkte.png\>", endpunkte, \ ImageSize \[Rule] 400]\)], "Input"],

Cell[BoxData[
    \("G:\\Robert\\Vorlesungen\\Variationsrechnung\\Pr\[ADoubleDot]sentation\\\
endpunkte.png"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(My1 = 
      N[2\ Pi\ \(\[Integral]\_\(-1\)\%1 y1[x]\ Sqrt[
                1 + \(y1'\)[x]^2] \[DifferentialD]x\), 2]\)], "Input"],

Cell[BoxData[
    \(21.710243130421947`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(My2 = 
      N[2\ Pi\ \(\[Integral]\_\(-1\)\%1 y2[x]\ Sqrt[
                1 + \(y2'\)[x]^2] \[DifferentialD]x\), 2]\)\)\)], "Input"],

Cell[BoxData[
    \(20.596275937405895`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(20.596275937405895`\)\(\[IndentingNewLine]\)
    \)\)], "Input"],

Cell[BoxData[
    \(20.596275937405895`\)], "Output"]
}, Open  ]],

Cell[BoxData[
    RowBox[{
      StyleBox[\(<< Graphics`Graphics`\),
        FormatType->StandardForm,
        FontFamily->"ArialMT",
        FontSize->14], 
      StyleBox["\n",
        FormatType->StandardForm,
        FontFamily->"ArialMT",
        FontSize->10]}]], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ImplicitPlot\)], "Input"],

Cell[BoxData[
    \(ImplicitPlot\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\(\(\[IndentingNewLine]\)\(x1[t_] = \(-Sin[t]\)\[IndentingNewLine]
    y1[t_] = \(-Cos[t]\)\[IndentingNewLine]
    z1 = t/3\[IndentingNewLine]
    \)\)\)], "Input"],

Cell[BoxData[
    \(\(-Sin[t]\)\)], "Output"],

Cell[BoxData[
    \(\(-Cos[t]\)\)], "Output"],

Cell[BoxData[
    \(t\/3\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(pp1 = 
      ParametricPlot3D[{x1[t], y1[t], z1[t]}\[IndentingNewLine]{t, 0, 
            3\ Pi}]\)], "Input"],

Cell[BoxData[
    RowBox[{\(ParametricPlot3D::"argtu"\), \(\(:\)\(\ \)\), \
"\<\"\\!\\(ParametricPlot3D\\) called with 1 argument; \\!\\(2\\) or \
\\!\\(3\\) arguments are expected. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"General::argtu\\\"]\\)\"\>"}]], \
"Message"],

Cell[BoxData[
    \(ParametricPlot3D[{x1[t], y1[t], z1[t]}\ {t, 0, 3\ \[Pi]}]\)], "Output"]
}, Open  ]],

Cell[BoxData[""], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(ParametricPlot3D[{t, t^2, 1 - t}, {t, 0, 1}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: 1.0855 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics3D
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
-0.0567234 1.16608 1.51571e-016 1.16608 [
[.09072 .22988 -5.91576 -9 ]
[.09072 .22988 .08424 0 ]
[.21906 .17566 -22.6146 -9 ]
[.21906 .17566 1.38537 0 ]
[.3545 .11847 -16.1747 -9 ]
[.3545 .11847 1.82534 0 ]
[.49765 .05807 -20.5178 -9 ]
[.49765 .05807 3.48221 0 ]
[.64919 -0.00583 -4.86734 -9 ]
[.64919 -0.00583 1.13266 0 ]
[.00955 .82643 -3.46362 0 ]
[.00955 .82643 2.53638 9 ]
[.12079 .90442 -13.4221 0 ]
[.12079 .90442 10.5779 9 ]
[.22056 .97437 -9.78807 0 ]
[.22056 .97437 8.21193 9 ]
[.31055 1.03745 -12.7284 0 ]
[.31055 1.03745 11.2717 9 ]
[.39213 1.09464 -3.11145 0 ]
[.39213 1.09464 2.88855 9 ]
[.07325 .26228 -6 -2.6177 ]
[.07325 .26228 0 6.3823 ]
[.05474 .37813 -24 -2.72059 ]
[.05474 .37813 0 6.27941 ]
[.03462 .5041 -18 -2.83339 ]
[.03462 .5041 0 6.16661 ]
[.01266 .64157 -24 -2.95759 ]
[.01266 .64157 0 6.04241 ]
[-0.01139 .79218 -6 -3.09501 ]
[-0.01139 .79218 0 5.90499 ]
[ 0 0 0 0 ]
[ 1 1.0855 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.08846 .24555 m
.67245 0 L
s
.10087 .24033 m
.10595 .24556 L
s
[(0)] .09072 .22988 .97192 1 Mshowa
.22871 .18658 m
.23354 .19204 L
s
[(0.25)] .21906 .17566 .88455 1 Mshowa
.36358 .12987 m
.36813 .13557 L
s
[(0.5)] .3545 .11847 .79718 1 Mshowa
.50609 .06995 m
.51031 .07589 L
s
[(0.75)] .49765 .05807 .70982 1 Mshowa
.65689 .00654 m
.66074 .01273 L
s
[(1)] .64919 -0.00583 .62245 1 Mshowa
.125 Mabswid
.12591 .22981 m
.12892 .23297 L
s
.1512 .21917 m
.15419 .22236 L
s
.17676 .20842 m
.17972 .21164 L
s
.2026 .19756 m
.20553 .20081 L
s
.25511 .17548 m
.25797 .17879 L
s
.28179 .16426 m
.28462 .1676 L
s
.30875 .15292 m
.31155 .15628 L
s
.33602 .14146 m
.33878 .14485 L
s
.39145 .11815 m
.39414 .1216 L
s
.41963 .1063 m
.42229 .10978 L
s
.44813 .09432 m
.45074 .09783 L
s
.47695 .0822 m
.47952 .08574 L
s
.53556 .05756 m
.53805 .06115 L
s
.56537 .04502 m
.56782 .04865 L
s
.59553 .03235 m
.59793 .036 L
s
.62603 .01952 m
.62839 .0232 L
s
.25 Mabswid
0 .80374 m
.40037 1.0855 L
s
.01178 .81203 m
.01289 .80482 L
s
[(0)] .00955 .82643 .15454 -1 Mshowa
.1225 .88995 m
.12336 .88271 L
s
[(0.25)] .12079 .90442 .11851 -1 Mshowa
.22183 .95985 m
.22246 .95259 L
s
[(0.5)] .22056 .97437 .08756 -1 Mshowa
.31143 1.0229 m
.31187 1.01563 L
s
[(0.75)] .31055 1.03745 .0607 -1 Mshowa
.39267 1.08007 m
.39294 1.07279 L
s
[(1)] .39213 1.09464 .03715 -1 Mshowa
.125 Mabswid
.03493 .82832 m
.03556 .82399 L
s
.05756 .84424 m
.05816 .83991 L
s
.07969 .85982 m
.08026 .85548 L
s
.10133 .87505 m
.10187 .87071 L
s
.14322 .90453 m
.14371 .90018 L
s
.1635 .9188 m
.16396 .91445 L
s
.18335 .93277 m
.18378 .92842 L
s
.20279 .94645 m
.2032 .9421 L
s
.24048 .97297 m
.24084 .96861 L
s
.25875 .98583 m
.25909 .98147 L
s
.27666 .99844 m
.27697 .99407 L
s
.29422 1.01079 m
.29451 1.00643 L
s
.32831 1.03478 m
.32855 1.03041 L
s
.34486 1.04643 m
.34508 1.04206 L
s
.3611 1.05786 m
.3613 1.05349 L
s
.37703 1.06907 m
.37721 1.0647 L
s
.25 Mabswid
.08846 .24555 m
0 .80374 L
s
.0867 .25665 m
.09342 .25384 L
s
[(0)] .07325 .26228 1 -0.41829 Mshowa
.0683 .37277 m
.07507 .37009 L
s
[(0.25)] .05474 .37813 1 -0.39542 Mshowa
.04829 .49904 m
.05512 .49651 L
s
[(0.5)] .03462 .5041 1 -0.37036 Mshowa
.02645 .63684 m
.03334 .63448 L
s
[(0.75)] .01266 .64157 1 -0.34276 Mshowa
.00252 .78784 m
.00948 .78567 L
s
[(1)] -0.01139 .79218 1 -0.31222 Mshowa
.125 Mabswid
.08314 .27912 m
.08718 .27745 L
s
.07952 .30196 m
.08356 .30031 L
s
.07584 .32518 m
.07989 .32354 L
s
.0721 .34878 m
.07616 .34715 L
s
.06443 .39717 m
.0685 .39558 L
s
.0605 .42199 m
.06458 .42042 L
s
.0565 .44723 m
.06058 .44568 L
s
.05243 .47291 m
.05652 .47137 L
s
.04407 .52563 m
.04818 .52413 L
s
.03978 .55269 m
.0439 .55121 L
s
.03542 .58024 m
.03954 .57878 L
s
.03097 .60828 m
.0351 .60685 L
s
.02184 .66593 m
.02598 .66453 L
s
.01714 .69556 m
.0213 .69418 L
s
.01236 .72574 m
.01652 .72439 L
s
.00749 .7565 m
.01165 .75517 L
s
.25 Mabswid
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
.41799 .58158 m
.08846 .24555 L
s
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.41799 .58158 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.40037 1.0855 L
s
.40037 1.0855 m
.41799 .58158 L
s
0 0 m
1 0 L
1 1.0855 L
0 1.0855 L
closepath
clip
newpath
.5 Mabswid
.89827 .42161 m
.91022 .42206 L
s
.88627 .42127 m
.89827 .42161 L
s
.87421 .42105 m
.88627 .42127 L
s
.8621 .42094 m
.87421 .42105 L
s
.84994 .42096 m
.8621 .42094 L
s
.83773 .4211 m
.84994 .42096 L
s
.82548 .42136 m
.83773 .4211 L
s
.81318 .42175 m
.82548 .42136 L
s
.80083 .42226 m
.81318 .42175 L
s
.78844 .42291 m
.80083 .42226 L
s
.77601 .42369 m
.78844 .42291 L
s
.76354 .4246 m
.77601 .42369 L
s
.75104 .42564 m
.76354 .4246 L
s
.7385 .42683 m
.75104 .42564 L
s
.72593 .42815 m
.7385 .42683 L
s
.71333 .42961 m
.72593 .42815 L
s
.7007 .43122 m
.71333 .42961 L
s
.68805 .43296 m
.7007 .43122 L
s
.67537 .43486 m
.68805 .43296 L
s
.66267 .4369 m
.67537 .43486 L
s
.64995 .43909 m
.66267 .4369 L
s
.63722 .44143 m
.64995 .43909 L
s
.62448 .44393 m
.63722 .44143 L
s
.61172 .44657 m
.62448 .44393 L
s
.59895 .44938 m
.61172 .44657 L
s
.58618 .45234 m
.59895 .44938 L
s
.57341 .45545 m
.58618 .45234 L
s
.56064 .45873 m
.57341 .45545 L
s
.54787 .46217 m
.56064 .45873 L
s
.53511 .46577 m
.54787 .46217 L
s
.52235 .46953 m
.53511 .46577 L
s
.50961 .47346 m
.52235 .46953 L
s
.49688 .47755 m
.50961 .47346 L
s
.48417 .48181 m
.49688 .47755 L
s
.47148 .48624 m
.48417 .48181 L
s
.45882 .49083 m
.47148 .48624 L
s
.44618 .4956 m
.45882 .49083 L
s
.43357 .50053 m
.44618 .4956 L
s
.421 .50563 m
.43357 .50053 L
s
.40846 .51091 m
.421 .50563 L
s
.39597 .51636 m
.40846 .51091 L
s
.38352 .52198 m
.39597 .51636 L
s
.37111 .52777 m
.38352 .52198 L
s
.35876 .53374 m
.37111 .52777 L
s
.34646 .53988 m
.35876 .53374 L
s
.33422 .5462 m
.34646 .53988 L
s
.32204 .55268 m
.33422 .5462 L
s
.30992 .55935 m
.32204 .55268 L
s
.29787 .56618 m
.30992 .55935 L
s
.28589 .57319 m
.29787 .56618 L
s
.27399 .58038 m
.28589 .57319 L
s
.26217 .58773 m
.27399 .58038 L
s
.25043 .59526 m
.26217 .58773 L
s
.23877 .60296 m
.25043 .59526 L
s
.2272 .61084 m
.23877 .60296 L
s
.21572 .61888 m
.2272 .61084 L
s
.20434 .6271 m
.21572 .61888 L
s
.19306 .63548 m
.20434 .6271 L
s
.18188 .64403 m
.19306 .63548 L
s
.17081 .65276 m
.18188 .64403 L
s
.15985 .66164 m
.17081 .65276 L
s
.149 .6707 m
.15985 .66164 L
s
.13827 .67991 m
.149 .6707 L
s
.12765 .68929 m
.13827 .67991 L
s
.11716 .69883 m
.12765 .68929 L
s
.10679 .70854 m
.11716 .69883 L
s
.09656 .71839 m
.10679 .70854 L
s
.08645 .72841 m
.09656 .71839 L
s
.07648 .73858 m
.08645 .72841 L
s
.06665 .7489 m
.07648 .73858 L
s
.05696 .75937 m
.06665 .7489 L
s
.04742 .76999 m
.05696 .75937 L
s
.03802 .78076 m
.04742 .76999 L
s
.02877 .79167 m
.03802 .78076 L
s
.25 Mabswid
.67245 0 m
.92713 .41497 L
s
.92713 .41497 m
1 .94814 L
s
1 .94814 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.08846 .24555 m
0 .80374 L
s
0 .80374 m
.70644 .58546 L
s
.70644 .58546 m
.67245 0 L
s
.67245 0 m
.08846 .24555 L
s
.08846 .24555 m
.67245 0 L
s
.10087 .24033 m
.10595 .24556 L
s
[(0)] .09072 .22988 .97192 1 Mshowa
.22871 .18658 m
.23354 .19204 L
s
[(0.25)] .21906 .17566 .88455 1 Mshowa
.36358 .12987 m
.36813 .13557 L
s
[(0.5)] .3545 .11847 .79718 1 Mshowa
.50609 .06995 m
.51031 .07589 L
s
[(0.75)] .49765 .05807 .70982 1 Mshowa
.65689 .00654 m
.66074 .01273 L
s
[(1)] .64919 -0.00583 .62245 1 Mshowa
.125 Mabswid
.12591 .22981 m
.12892 .23297 L
s
.1512 .21917 m
.15419 .22236 L
s
.17676 .20842 m
.17972 .21164 L
s
.2026 .19756 m
.20553 .20081 L
s
.25511 .17548 m
.25797 .17879 L
s
.28179 .16426 m
.28462 .1676 L
s
.30875 .15292 m
.31155 .15628 L
s
.33602 .14146 m
.33878 .14485 L
s
.39145 .11815 m
.39414 .1216 L
s
.41963 .1063 m
.42229 .10978 L
s
.44813 .09432 m
.45074 .09783 L
s
.47695 .0822 m
.47952 .08574 L
s
.53556 .05756 m
.53805 .06115 L
s
.56537 .04502 m
.56782 .04865 L
s
.59553 .03235 m
.59793 .036 L
s
.62603 .01952 m
.62839 .0232 L
s
.25 Mabswid
0 .80374 m
.40037 1.0855 L
s
.01178 .81203 m
.01289 .80482 L
s
[(0)] .00955 .82643 .15454 -1 Mshowa
.1225 .88995 m
.12336 .88271 L
s
[(0.25)] .12079 .90442 .11851 -1 Mshowa
.22183 .95985 m
.22246 .95259 L
s
[(0.5)] .22056 .97437 .08756 -1 Mshowa
.31143 1.0229 m
.31187 1.01563 L
s
[(0.75)] .31055 1.03745 .0607 -1 Mshowa
.39267 1.08007 m
.39294 1.07279 L
s
[(1)] .39213 1.09464 .03715 -1 Mshowa
.125 Mabswid
.03493 .82832 m
.03556 .82399 L
s
.05756 .84424 m
.05816 .83991 L
s
.07969 .85982 m
.08026 .85548 L
s
.10133 .87505 m
.10187 .87071 L
s
.14322 .90453 m
.14371 .90018 L
s
.1635 .9188 m
.16396 .91445 L
s
.18335 .93277 m
.18378 .92842 L
s
.20279 .94645 m
.2032 .9421 L
s
.24048 .97297 m
.24084 .96861 L
s
.25875 .98583 m
.25909 .98147 L
s
.27666 .99844 m
.27697 .99407 L
s
.29422 1.01079 m
.29451 1.00643 L
s
.32831 1.03478 m
.32855 1.03041 L
s
.34486 1.04643 m
.34508 1.04206 L
s
.3611 1.05786 m
.3613 1.05349 L
s
.37703 1.06907 m
.37721 1.0647 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{265.313, 287.938},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40004900017b000`400?l00000o`00003oo`3oool:
0?ooo`00[`3oool5000005D0oooo002a0?ooo`030000003oool0oooo05D0oooo002a0?ooo`030000
003oool0oooo05D0oooo002a0?ooo`030000003oool0oooo05D0oooo002a0?ooo`030000003oool0
oooo05D0oooo002`0?ooo`800000E`3oool00?l0oooo2P3oool00?l0oooo2P3oool00?l0oooo2P3o
ool00?l0oooo2P3oool00;L0oooo0P00001@0?ooo`00]03oool3000000030?ooo`000000000004l0
oooo002b0?ooo`<000000`3oool2000004l0oooo002`0?ooo`8000000`3oool01P000000oooo0?oo
o`000000oooo000004h0oooo002]0?ooo`<00000203oool00`000000oooo0000001>0?ooo`00Z`3o
ool3000000X0oooo00@000000?ooo`3oool00000C@3oool007/0oooo0P0000040?ooo`8000001@3o
ool00`000000oooo0?ooo`020?ooo`8000006P3oool2000000d0oooo00D000000?ooo`3oool0oooo
0000001<0?ooo`00NP3oool010000000oooo0?ooo`00000:0?ooo`050000003oool0oooo0?ooo`00
00000P3oool00`000000oooo0?ooo`0C0?ooo`@000003`3oool01@000000oooo0?ooo`3oool00000
04`0oooo001j0?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool0103oool00`00
0000oooo0?ooo`0B0?ooo`<000004@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo
04T0oooo001j0?ooo`040000003oool0oooo000000/0oooo00@000000?ooo`3oool0oooo0P00000C
0?ooo`8000005@3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo04P0oooo001j0?oo
o`040000003oool0oooo000000P0oooo00@000000?ooo`3oool000000`3oool00`000000oooo0?oo
o`0>0?ooo`@000005`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo04P0oooo001k
0?ooo`8000002@3oool4000000<0oooo0`00000=0?ooo`<000006@3oool00`000000oooo0?ooo`03
0?ooo`030000003oool0oooo04L0oooo002J0?ooo`<00000703oool00`000000oooo0?ooo`030?oo
o`030000003oool0oooo04L0oooo002H0?ooo`8000007`3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo04H0oooo002F0?ooo`8000008@3oool00`000000oooo0?ooo`050?ooo`030000
003oool0oooo04D0oooo002C0?ooo`<000008`3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo04D0oooo002A0?ooo`8000009P3oool00`000000oooo0?ooo`060?ooo`030000003oool0
oooo04@0oooo002>0?ooo`<00000:03oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo
04@0oooo002<0?ooo`8000000`3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo00L0
oooo00<000000?ooo`3oool0@`3oool008X0oooo0P00000]0?ooo`030000003oool0oooo00P0oooo
00<000000?ooo`3oool0@P3oool005d0oooo0P0000040?ooo`800000103oool2000001`0oooo0`00
000_0?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0@P3oool005`0oooo00@00000
0?ooo`3oool00000203oool010000000oooo0?ooo`00000I0?ooo`800000<P3oool00`000000oooo
0?ooo`090?ooo`030000003oool0oooo0440oooo001L0?ooo`040000003oool0oooo000000/0oooo
00<000000?ooo`3oool04`3oool4000003@0oooo00<000000?ooo`3oool02P3oool00`000000oooo
0?ooo`100?ooo`00G03oool010000000oooo0?ooo`0000090?ooo`8000005@3oool3000003H0oooo
00<000000?ooo`3oool02P3oool00`000000oooo0?ooo`100?ooo`00G03oool010000000oooo0?oo
o`0000090?ooo`030000003oool0oooo0180oooo0P00000i0?ooo`030000003oool0oooo00/0oooo
00<000000?ooo`3oool0?`3oool005d0oooo0P00000:0?ooo`<000003`3oool3000003/0oooo00<0
00000?ooo`3oool02`3oool00`000000oooo0?ooo`0o0?ooo`00N@3oool3000003d0oooo00<00000
0?ooo`3oool0303oool00`000000oooo0?ooo`0n0?ooo`00MP3oool300000440oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0m0?ooo`00M03oool2000004@0oooo00<000000?ooo`3o
ool0303oool00`000000oooo0?ooo`0m0?ooo`00LP3oool3000004D0oooo00<000000?ooo`3oool0
3@3oool00`000000oooo0?ooo`0l0?ooo`00K`3oool3000004P0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`0l0?ooo`00K@3oool2000004/0oooo00<000000?ooo`3oool03P3oool0
0`000000oooo0?ooo`0k0?ooo`00JP3oool4000004`0oooo00<000000?ooo`3oool03`3oool00`00
0000oooo0?ooo`0j0?ooo`00J03oool2000000@0oooo00<000000?ooo`3oool0B@3oool00`000000
oooo0?ooo`0?0?ooo`030000003oool0oooo03X0oooo000e0?ooo`800000103oool2000000<0oooo
100000030?ooo`800000703oool300000580oooo00<000000?ooo`3oool0403oool00`000000oooo
0?ooo`0i0?ooo`00=03oool010000000oooo0?ooo`0000080?ooo`030000003oool0oooo00<0oooo
00@000000?ooo`3oool000006@3oool200000080oooo00<000000?ooo`3oool0D03oool00`000000
oooo0?ooo`0@0?ooo`030000003oool0oooo03T0oooo000d0?ooo`040000003oool0oooo000000T0
oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0E0?ooo`800000E`3oool00`000000
oooo0?ooo`0A0?ooo`030000003oool0oooo03P0oooo000d0?ooo`040000003oool0oooo000000X0
oooo00<000000?ooo`3oool00P3oool2000001D0oooo0`00001I0?ooo`030000003oool0oooo0180
oooo00<000000?ooo`3oool0=`3oool003@0oooo00@000000?ooo`3oool00000203oool010000000
oooo0?ooo`0000030?ooo`030000003oool0oooo0180oooo0P0000020?ooo`030000003oool0oooo
05L0oooo00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0g0?ooo`00=@3oool2000000X0
oooo0P0000040?ooo`<000003`3oool3000005h0oooo00<000000?ooo`3oool04`3oool00`000000
oooo0?ooo`0f0?ooo`00E`3oool4000005l0oooo00<000000?ooo`3oool0503oool00`000000oooo
0?ooo`0e0?ooo`00E@3oool2000006<0oooo00<000000?ooo`3oool0503oool00`000000oooo0?oo
o`0e0?ooo`00DP3oool3000006D0oooo00<000000?ooo`3oool05@3oool00`000000oooo0?ooo`0d
0?ooo`00D03oool2000000030?ooo`000000oooo06D0oooo00<000000?ooo`3oool05@3oool00`00
0000oooo0?ooo`0d0?ooo`00C@3oool3000006X0oooo00<000000?ooo`3oool05P3oool00`000000
oooo0?ooo`0c0?ooo`00B`3oool2000006h0oooo00<000000?ooo`3oool05P3oool00`000000oooo
0?ooo`0b0?ooo`00B@3oool200000080oooo00<000000?ooo`3oool0J`3oool00`000000oooo0?oo
o`0F0?ooo`030000003oool0oooo0380oooo000W0?ooo`8000007@3oool300000780oooo00<00000
0?ooo`3oool05`3oool00`000000oooo0?ooo`0a0?ooo`009P3oool010000000oooo0?ooo`00000J
0?ooo`<00000M03oool00`000000oooo0?ooo`0G0?ooo`030000003oool0oooo0340oooo000V0?oo
o`040000003oool0oooo000001L0oooo0`00001g0?ooo`030000003oool0oooo01P0oooo00<00000
0?ooo`3oool0<03oool002H0oooo00@000000?ooo`3oool000005@3oool2000007X0oooo00<00000
0?ooo`3oool06@3oool00`000000oooo0?ooo`0_0?ooo`009P3oool010000000oooo0?ooo`00000C
0?ooo`80000000<0oooo0000003oool0N@3oool00`000000oooo0?ooo`0I0?ooo`030000003oool0
oooo02l0oooo000W0?ooo`8000004@3oool3000007h0oooo00<000000?ooo`3oool06P3oool00`00
0000oooo0?ooo`0^0?ooo`00>03oool200000840oooo00<000000?ooo`3oool06`3oool00`000000
oooo0?ooo`0]0?ooo`00=@3oool300000080oooo00<000000?ooo`3oool0OP3oool00`000000oooo
0?ooo`0K0?ooo`030000003oool0oooo02d0oooo000c0?ooo`800000QP3oool00`000000oooo0?oo
o`0L0?ooo`030000003oool0oooo02`0oooo000a0?ooo`80000000<0oooo0000003oool0Q@3oool0
0`000000oooo0?ooo`0L0?ooo`030000003oool0oooo02`0oooo000^0?ooo`<00000RP3oool00`00
0000oooo0?ooo`0M0?ooo`030000003oool0oooo02/0oooo000/0?ooo`800000S@3oool00`000000
oooo0?ooo`0N0?ooo`030000003oool0oooo02X0oooo000Z0?ooo`8000000P3oool00`000000oooo
0?ooo`2:0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3oool0:P3oool002X0oooo0P00
002?0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0:@3oool002X0oooo0`00002>
0?ooo`030000003oool0oooo01l0oooo00<000000?ooo`3oool0:@3oool002X0oooo00@000000?oo
o`3oool00000S@3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo02P0oooo000Y0?oo
o`030000003oool0oooo0080oooo00<000000?ooo`3oool0R`3oool00`000000oooo0?ooo`0P0?oo
o`030000003oool0oooo02L0oooo000R0?ooo`8000001@3oool00`000000oooo0?ooo`030?ooo`03
0000003oool0oooo08X0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`0W0?ooo`00
8@3oool010000000oooo0?ooo`0000040?ooo`030000003oool0oooo00@0oooo00<000000?ooo`3o
ool0R@3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo02H0oooo000Q0?ooo`040000
003oool0oooo000000@0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`280?ooo`03
0000003oool0oooo0280oooo00<000000?ooo`3oool09@3oool00240oooo00@000000?ooo`3oool0
0000103oool2000000L0oooo00<000000?ooo`3oool0Q`3oool00`000000oooo0?ooo`0R0?ooo`03
0000003oool0oooo02D0oooo000Q0?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`260?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3o
ool0903oool00280oooo0P0000040?ooo`030000003oool0oooo00T0oooo00<000000?ooo`3oool0
Q@3oool00`000000oooo0?ooo`0S0?ooo`030000003oool0oooo02@0oooo000X0?ooo`030000003o
ool0oooo00X0oooo00<000000?ooo`3oool0Q03oool00`000000oooo0?ooo`0T0?ooo`030000003o
ool0oooo02<0oooo000X0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0P`3oool0
0`000000oooo0?ooo`0U0?ooo`030000003oool0oooo0280oooo000X0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool0PP3oool00`000000oooo0?ooo`0U0?ooo`030000003oool0oooo
0280oooo000X0?ooo`8000003P3oool00`000000oooo0?ooo`210?ooo`030000003oool0oooo02H0
oooo00<000000?ooo`3oool08@3oool002P0oooo00<000000?ooo`3oool03P3oool00`000000oooo
0?ooo`200?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool08@3oool002L0oooo00<0
00000?ooo`3oool0403oool00`000000oooo0?ooo`1o0?ooo`030000003oool0oooo02L0oooo00<0
00000?ooo`3oool0803oool002L0oooo00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`1n
0?ooo`030000003oool0oooo02P0oooo00<000000?ooo`3oool07`3oool002L0oooo00<000000?oo
o`3oool04P3oool00`000000oooo0?ooo`1m0?ooo`030000003oool0oooo02P0oooo00<000000?oo
o`3oool07`3oool002L0oooo0P00000D0?ooo`030000003oool0oooo07`0oooo00<000000?ooo`3o
ool0:@3oool00`000000oooo0?ooo`0N0?ooo`009`3oool00`000000oooo0?ooo`0D0?ooo`030000
003oool0oooo07/0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`0N0?ooo`009`3o
ool00`000000oooo0?ooo`0D0?ooo`030000003oool0oooo07`0oooo00<000000?ooo`3oool0:@3o
ool00`000000oooo0?ooo`0M0?ooo`009P3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0
oooo07/0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`0L0?ooo`009P3oool00`00
0000oooo0?ooo`0G0?ooo`030000003oool0oooo07X0oooo00<000000?ooo`3oool0:P3oool00`00
0000oooo0?ooo`0L0?ooo`009P3oool00`000000oooo0?ooo`0H0?ooo`030000003oool0oooo07T0
oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`0K0?ooo`009P3oool2000001X0oooo
00<000000?ooo`3oool0N03oool00`000000oooo0?ooo`0/0?ooo`030000003oool0oooo01X0oooo
000V0?ooo`030000003oool0oooo01X0oooo00<000000?ooo`3oool0M`3oool00`000000oooo0?oo
o`0/0?ooo`030000003oool0oooo01X0oooo000V0?ooo`030000003oool0oooo01/0oooo00<00000
0?ooo`3oool0MP3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo01T0oooo000U0?oo
o`030000003oool0oooo01d0oooo00<000000?ooo`3oool0M@3oool00`000000oooo0?ooo`0]0?oo
o`030000003oool0oooo01T0oooo000U0?ooo`030000003oool0oooo01h0oooo00<000000?ooo`3o
ool0M03oool00`000000oooo0?ooo`0^0?ooo`030000003oool0oooo01P0oooo000U0?ooo`030000
003oool0oooo01l0oooo00<000000?ooo`3oool0L`3oool00`000000oooo0?ooo`0_0?ooo`030000
003oool0oooo01L0oooo000U0?ooo`<00000803oool00`000000oooo0?ooo`1b0?ooo`030000003o
ool0oooo02l0oooo00<000000?ooo`3oool05`3oool002D0oooo00<000000?ooo`3oool08@3oool0
0`000000oooo0?ooo`1a0?ooo`030000003oool0oooo0300oooo00<000000?ooo`3oool05P3oool0
00`0oooo0P0000040?ooo`8000000`3oool4000000<0oooo0P0000050?ooo`030000003oool0oooo
0280oooo00<000000?ooo`3oool0L03oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo
01H0oooo000;0?ooo`040000003oool0oooo000000P0oooo00<000000?ooo`3oool00`3oool01000
0000oooo0?ooo`0000030?ooo`030000003oool0oooo02@0oooo00<000000?ooo`3oool0K`3oool0
0`000000oooo0?ooo`0a0?ooo`030000003oool0oooo01D0oooo000;0?ooo`040000003oool0oooo
000000T0oooo00<000000?ooo`3oool01@3oool01@000000oooo0?ooo`3oool0000002L0oooo00<0
00000?ooo`3oool0KP3oool00`000000oooo0?ooo`0b0?ooo`030000003oool0oooo01@0oooo000;
0?ooo`040000003oool0oooo000000X0oooo00<000000?ooo`3oool00P3oool2000000@0oooo00<0
00000?ooo`3oool09P3oool00`000000oooo0?ooo`1]0?ooo`030000003oool0oooo0380oooo00<0
00000?ooo`3oool0503oool000/0oooo00@000000?ooo`3oool00000203oool010000000oooo0?oo
o`0000030?ooo`030000003oool0oooo00<0oooo0P00000X0?ooo`030000003oool0oooo06`0oooo
00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0C0?ooo`00303oool2000000X0oooo0P00
00040?ooo`<000000`3oool00`000000oooo0?ooo`0X0?ooo`030000003oool0oooo06/0oooo00<0
00000?ooo`3oool0=03oool00`000000oooo0?ooo`0B0?ooo`00903oool00`000000oooo0?ooo`0Y
0?ooo`030000003oool0oooo06/0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`0B
0?ooo`00903oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0oooo06X0oooo00<000000?oo
o`3oool0=03oool00`000000oooo0?ooo`0A0?ooo`008`3oool00`000000oooo0?ooo`0/0?ooo`03
0000003oool0oooo06T0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`0A0?ooo`00
8`3oool00`000000oooo0?ooo`0]0?ooo`030000003oool0oooo06P0oooo00<000000?ooo`3oool0
=03oool200000180oooo000S0?ooo`800000;`3oool00`000000oooo0?ooo`1W0?ooo`030000003o
ool0oooo0180oooo8P0000000`3oool000000?ooo`0A0?ooo`008`3oool00`000000oooo0?ooo`0_
0?ooo`030000003oool0oooo06H0oooo00<000000?ooo`3oool01P3oool<000001`0oooo0`000004
0?ooo`030000003oool0oooo0100oooo000S0?ooo`030000003oool0oooo0300oooo00<000000?oo
o`3oool0I@3oool9000002D0oooo0`0000070?ooo`030000003oool0oooo0100oooo000S0?ooo`03
0000003oool0oooo0340oooo00<000000?ooo`3oool0GP3oool7000002X0oooo0`00000;0?ooo`03
0000003oool0oooo00l0oooo000R0?ooo`030000003oool0oooo03<0oooo00<000000?ooo`3oool0
E`3oool6000000H0oooo00<000000?ooo`3oool0903oool4000000h0oooo00<000000?ooo`3oool0
3`3oool00280oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`1C0?ooo`<00000303o
ool00`000000oooo0?ooo`0Q0?ooo`<000004P3oool00`000000oooo0?ooo`0?0?ooo`008P3oool2
000003H0oooo00<000000?ooo`3oool0B`3oool7000000l0oooo00<000000?ooo`3oool07P3oool3
000001D0oooo00<000000?ooo`3oool03`3oool00280oooo00<000000?ooo`3oool0=P3oool00`00
0000oooo0?ooo`170?ooo`<000005P3oool00`000000oooo0?ooo`0K0?ooo`<00000603oool00`00
0000oooo0?ooo`0?0?ooo`008P3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo0400
oooo1P00000I0?ooo`030000003oool0oooo01P0oooo0`00000K0?ooo`030000003oool0oooo00l0
oooo000R0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool0?03oool3000001l0oooo
00<000000?ooo`3oool05@3oool3000001h0oooo00<000000?ooo`3oool03`3oool00240oooo00<0
00000?ooo`3oool0>P3oool00`000000oooo0?ooo`0h0?ooo`<000008P3oool00`000000oooo0?oo
o`0B0?ooo`<000008P3oool00`000000oooo0?ooo`0>0?ooo`008@3oool00`000000oooo0?ooo`0k
0?ooo`030000003oool0oooo03@0oooo0`00000U0?ooo`030000003oool0oooo00l0oooo0`00000U
0?ooo`030000003oool0oooo00h0oooo000Q0?ooo`800000?@3oool00`000000oooo0?ooo`0`0?oo
o`<00000:03oool00`000000oooo0?ooo`0<0?ooo`<00000:03oool00`000000oooo0?ooo`0>0?oo
o`008@3oool00`000000oooo0?ooo`0m0?ooo`030000003oool0oooo02/0oooo1000000[0?ooo`03
0000003oool0oooo00T0oooo0`00000[0?ooo`030000003oool0oooo00h0oooo000Q0?ooo`030000
003oool0oooo03h0oooo00<000000?ooo`3oool09`3oool300000300oooo00<000000?ooo`3oool0
103oool4000002h0oooo00<000000?ooo`3oool03P3oool00240oooo00<000000?ooo`3oool0?`3o
ool00`000000oooo0?ooo`0S0?ooo`<00000<`3oool010000000oooo0?ooo`3oool300000380oooo
00<000000?ooo`3oool03P3oool00200oooo00<000000?ooo`3oool0@@3oool00`000000oooo0?oo
o`0O0?ooo`<00000=P3oool4000003D0oooo00<000000?ooo`3oool03P3oool00200oooo00<00000
0?ooo`3oool0@P3oool00`000000oooo0?ooo`0K0?ooo`<00000=`3oool3000003T0oooo00<00000
0?ooo`3oool03@3oool00200oooo00<000000?ooo`000000@`3oool00`000000oooo0?ooo`0G0?oo
o`<00000=`3oool300000080oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`0=0?oo
o`00803oool2000004@0oooo00<000000?ooo`3oool05@3oool2000003L0oooo0`0000050?ooo`03
0000003oool0oooo03L0oooo00<000000?ooo`3oool03@3oool000d0oooo0P0000040?ooo`800000
103oool2000000D0oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`0B0?ooo`800000
=P3oool3000000P0oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`0=0?ooo`00303o
ool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000@0oooo00<000000?ooo`3o
ool0A@3oool00`000000oooo0?ooo`0?0?ooo`800000=@3oool3000000/0oooo00<000000?ooo`3o
ool0=`3oool00`000000oooo0?ooo`0=0?ooo`00303oool010000000oooo0?ooo`00000;0?ooo`05
0000003oool0oooo0?ooo`000000B@3oool00`000000oooo0?ooo`0;0?ooo`<00000=03oool30000
00h0oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`0=0?ooo`00303oool010000000
oooo0?ooo`0000090?ooo`800000103oool00`000000oooo0?ooo`180?ooo`030000003oool0oooo
00P0oooo0P00000d0?ooo`<000004@3oool00`000000oooo0?ooo`0g0?ooo`030000003oool0oooo
00d0oooo000<0?ooo`040000003oool0oooo000000T0oooo00<000000?ooo`3oool00`3oool00`00
0000oooo0?ooo`190?ooo`030000003oool0oooo00D0oooo0P00000b0?ooo`@00000503oool00`00
0000oooo0?ooo`0g0?ooo`030000003oool0oooo00d0oooo000=0?ooo`8000002P3oool3000000<0
oooo0P00001;0?ooo`030000003oool0oooo0080oooo0P00000a0?ooo`<00000603oool00`000000
oooo0?ooo`0h0?ooo`030000003oool0oooo00`0oooo000O0?ooo`030000003oool0oooo04/0oooo
1000000`0?ooo`<000006`3oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo00`0oooo
000O0?ooo`030000003oool0oooo04X0oooo0`00000_0?ooo`<000007P3oool00`000000oooo0?oo
o`0h0?ooo`030000003oool0oooo00`0oooo000O0?ooo`030000003oool0oooo04P0oooo0P000003
0?ooo`030000003oool0oooo02T0oooo0`00000Q0?ooo`030000003oool0oooo03P0oooo00<00000
0?ooo`3oool0303oool001h0oooo00<000000?ooo`3oool0A`3oool2000000H0oooo00<000000?oo
o`3oool09@3oool3000002@0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`0<0?oo
o`007P3oool00`000000oooo0?ooo`150?ooo`8000002@3oool00`000000oooo0?ooo`0Q0?ooo`<0
00009`3oool00`000000oooo0?ooo`0h0?ooo`030000003oool0oooo00`0oooo000N0?ooo`030000
003oool0oooo04<0oooo0P00000<0?ooo`030000003oool0oooo01d0oooo0`00000Z0?ooo`030000
003oool0oooo03P0oooo00<000000?ooo`3oool0303oool001h0oooo0P0000130?ooo`030000003o
ool0oooo00d0oooo00<000000?ooo`3oool06@3oool3000002h0oooo00<000000?ooo`3oool0>03o
ool00`000000oooo0?ooo`0;0?ooo`007P3oool00`000000oooo0?ooo`100?ooo`8000004@3oool0
0`000000oooo0?ooo`0E0?ooo`<00000<@3oool00`000000oooo0?ooo`0h0?ooo`030000003oool0
oooo00/0oooo000N0?ooo`030000003oool0oooo03h0oooo0P00000D0?ooo`030000003oool0oooo
0100oooo1000000d0?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool02`3oool001d0
oooo00<000000?ooo`3oool0?@3oool2000001L0oooo00<000000?ooo`3oool0303oool3000003P0
oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`0;0?ooo`007@3oool00`000000oooo
0?ooo`0k0?ooo`8000006P3oool00`000000oooo0?ooo`080?ooo`<00000>`3oool00`000000oooo
0?ooo`0h0?ooo`030000003oool0oooo00/0oooo000M0?ooo`030000003oool0oooo03X0oooo00<0
00000?ooo`3oool06`3oool00`000000oooo0?ooo`040?ooo`<00000?P3oool00`000000oooo0?oo
o`0h0?ooo`030000003oool0oooo00/0oooo000M0?ooo`800000>@3oool2000001l0oooo00<00000
0?ooo`3oool00`0000110?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool02`3oool0
01d0oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`0P0?ooo`800000A03oool00`00
0000oooo0?ooo`0i0?ooo`030000003oool0oooo00X0oooo000M0?ooo`030000003oool0oooo03D0
oooo0P00000S0?ooo`030000003oool0oooo0480oooo0P00000k0?ooo`030000003oool0oooo00X0
oooo000L0?ooo`030000003oool0oooo03@0oooo0P00000U0?ooo`030000003oool0oooo03l0oooo
0`0000020?ooo`030000003oool0oooo03P0oooo00<000000?ooo`3oool02P3oool001`0oooo00<0
00000?ooo`3oool0<P3oool2000002L0oooo00<000000?ooo`3oool0>`3oool4000000H0oooo00<0
00000?ooo`3oool0=`3oool00`000000oooo0?ooo`0:0?ooo`00703oool00`000000oooo0?ooo`0a
0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0>03oool3000000X0oooo00<00000
0?ooo`3oool0=`3oool00`000000oooo0?ooo`0:0?ooo`00703oool00`000000oooo0?ooo`0`0?oo
o`030000003oool0oooo02P0oooo00<000000?ooo`3oool0=@3oool3000000h0oooo00<000000?oo
o`3oool0=P3oool00`000000oooo0?ooo`0:0?ooo`00703oool2000002l0oooo0P00000[0?ooo`03
0000003oool0oooo0380oooo0`00000B0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3o
ool02P3oool001`0oooo00<000000?ooo`3oool0;@3oool00`000000oooo0?ooo`0[0?ooo`030000
003oool0oooo02h0oooo1000000F0?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0
2@3oool001/0oooo00<000000?ooo`3oool0;03oool2000002h0oooo00<000000?ooo`3oool0:`3o
ool3000001/0oooo00<000000?ooo`3oool0=03oool00`000000oooo0?ooo`090?ooo`006`3oool0
0`000000oooo0?ooo`0[0?ooo`030000003oool0oooo02h0oooo00<000000?ooo`3oool0:03oool3
000001l0oooo00<000000?ooo`3oool0<`3oool00`000000oooo0?ooo`090?ooo`006`3oool00`00
0000oooo0?ooo`0Y0?ooo`800000<@3oool00`000000oooo0?ooo`0U0?ooo`<000008P3oool00`00
0000oooo0?ooo`0c0?ooo`030000003oool0oooo00T0oooo000K0?ooo`030000003oool0oooo02P0
oooo00<000000?ooo`3oool0<@3oool00`000000oooo0?ooo`0Q0?ooo`@000009P3oool00`000000
oooo0?ooo`0b0?ooo`030000003oool0oooo00T0oooo000K0?ooo`030000003oool0oooo02H0oooo
0P00000d0?ooo`030000003oool0oooo01h0oooo0`00000[0?ooo`030000003oool0oooo0340oooo
00<000000?ooo`3oool02@3oool001/0oooo00<000000?ooo`0000009@3oool00`000000oooo0?oo
o`0d0?ooo`030000003oool0oooo01/0oooo0`00000_0?ooo`030000003oool0oooo0300oooo00<0
00000?ooo`3oool02@3oool001X0oooo0`00000U0?ooo`030000003oool0oooo03D0oooo00<00000
0?ooo`3oool0603oool3000003<0oooo00<000000?ooo`3oool0<03oool00`000000oooo0?ooo`08
0?ooo`000P3oool2000000@0oooo0P0000050?ooo`030000003oool0oooo0080oooo0P0000040?oo
o`030000003oool0oooo02@0oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0D0?oo
o`@00000=P3oool00`000000oooo0?ooo`0`0?ooo`030000003oool0oooo00P0oooo00001@3oool0
00000?ooo`3oool0000000X0oooo00D000000?ooo`3oool0oooo000000020?ooo`050000003oool0
oooo0?ooo`000000903oool2000003P0oooo00<000000?ooo`3oool04P3oool3000003/0oooo00<0
00000?ooo`3oool0;`3oool00`000000oooo0?ooo`080?ooo`0000D0oooo0000003oool0oooo0000
000:0?ooo`030000003oool0oooo00@0oooo00D000000?ooo`3oool0oooo0000000S0?ooo`030000
003oool0oooo03P0oooo00<000000?ooo`3oool03`3oool3000003l0oooo00<000000?ooo`3oool0
;P3oool00`000000oooo0?ooo`080?ooo`0000D0oooo0000003oool0oooo0000000;0?ooo`040000
003oool0oooo0?ooo`800000103oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo03T0
oooo00<000000?ooo`3oool0303oool3000004<0oooo00<000000?ooo`3oool0;@3oool00`000000
oooo0?ooo`080?ooo`0000D0oooo0000003oool0oooo000000080?ooo`040000003oool0oooo0000
00<0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo
03X0oooo00<000000?ooo`3oool0203oool4000004L0oooo00<000000?ooo`3oool0;03oool00`00
0000oooo0?ooo`080?ooo`000P3oool2000000T0oooo100000030?ooo`<000000P3oool00`000000
oooo0000000O0?ooo`030000003oool0oooo03/0oooo00<000000?ooo`3oool01@3oool3000004`0
oooo00<000000?ooo`3oool0:`3oool00`000000oooo0?ooo`080?ooo`006@3oool2000001l0oooo
00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`020?ooo`<00000C`3oool00`000000oooo
0?ooo`0/0?ooo`030000003oool0oooo00L0oooo000I0?ooo`030000003oool0oooo01d0oooo00<0
00000?ooo`3oool0?@3oool00`000000oooo00000002000005<0oooo00<000000?ooo`3oool0:`3o
ool00`000000oooo0?ooo`070?ooo`006@3oool00`000000oooo0?ooo`0K0?ooo`800000?P3oool4
000005L0oooo00<000000?ooo`3oool0:P3oool00`000000oooo0?ooo`070?ooo`006@3oool00`00
0000oooo0?ooo`0J0?ooo`030000003oool0oooo03/0oooo0`0000020?ooo`030000003oool0oooo
05L0oooo00<000000?ooo`3oool0:@3oool00`000000oooo0?ooo`070?ooo`006@3oool00`000000
oooo0?ooo`0H0?ooo`800000>`3oool3000000D0oooo00<000000?ooo`3oool0F03oool00`000000
oooo0?ooo`0X0?ooo`030000003oool0oooo00L0oooo000I0?ooo`030000003oool0oooo01L0oooo
00<000000?ooo`3oool0>03oool3000000P0oooo00<000000?ooo`3oool0F03oool00`000000oooo
0?ooo`0X0?ooo`030000003oool0oooo00L0oooo000H0?ooo`030000003oool0000001L0oooo00<0
00000?ooo`3oool0=P3oool3000000/0oooo00<000000?ooo`3oool0F@3oool00`000000oooo0?oo
o`0W0?ooo`030000003oool0oooo00L0oooo000H0?ooo`800000603oool00`000000oooo0?ooo`0b
0?ooo`@000003P3oool00`000000oooo0?ooo`1J0?ooo`030000003oool0oooo02H0oooo00<00000
0?ooo`3oool01`3oool001P0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0`0?oo
o`<000004P3oool00`000000oooo0?ooo`1K0?ooo`030000003oool0oooo02H0oooo00<000000?oo
o`3oool01P3oool001P0oooo00<000000?ooo`3oool0503oool200000300oooo0`00000E0?ooo`03
0000003oool0oooo05`0oooo00<000000?ooo`3oool09@3oool00`000000oooo0?ooo`060?ooo`00
603oool00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo02d0oooo0`00000H0?ooo`030000
003oool0oooo05d0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`060?ooo`00603o
ool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo02X0oooo1000000K0?ooo`030000003o
ool0oooo05d0oooo00<000000?ooo`3oool0903oool00`000000oooo0?ooo`060?ooo`005`3oool0
0`000000oooo0?ooo`0B0?ooo`030000003oool0oooo02P0oooo0`00000O0?ooo`030000003oool0
oooo05h0oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`060?ooo`005`3oool00`00
0000oooo0?ooo`0A0?ooo`030000003oool0oooo02H0oooo0`00000R0?ooo`030000003oool0oooo
05l0oooo00<000000?ooo`3oool08P3oool00`000000oooo0?ooo`060?ooo`005`3oool200000140
oooo00<000000?ooo`3oool0903oool3000002D0oooo00<000000?ooo`3oool0H03oool00`000000
oooo0?ooo`0Q0?ooo`030000003oool0oooo00H0oooo000G0?ooo`030000003oool0oooo00l0oooo
00<000000?ooo`3oool08@3oool4000002P0oooo00<000000?ooo`3oool0H@3oool00`000000oooo
0?ooo`0Q0?ooo`030000003oool0oooo00D0oooo000G0?ooo`030000003oool0oooo00h0oooo00<0
00000?ooo`3oool07`3oool3000002`0oooo00<000000?ooo`3oool0H@3oool00`000000oooo0?oo
o`0Q0?ooo`030000003oool0oooo00D0oooo000G0?ooo`030000003oool0oooo00d0oooo00<00000
0?ooo`3oool07@3oool3000002l0oooo00<000000?ooo`3oool0HP3oool00`000000oooo0?ooo`0P
0?ooo`030000003oool0oooo00D0oooo000F0?ooo`030000003oool0oooo00d0oooo00<000000?oo
o`3oool06`3oool300000380oooo00<000000?ooo`3oool0H`3oool00`000000oooo0?ooo`0O0?oo
o`030000003oool0oooo00D0oooo000F0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3o
ool05`3oool4000003D0oooo00<000000?ooo`3oool0I03oool00`000000oooo0?ooo`0N0?ooo`03
0000003oool0oooo00D0oooo000F0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0
5@3oool3000003T0oooo00<000000?ooo`3oool0I@3oool00`000000oooo0?ooo`0M0?ooo`030000
003oool0oooo00D0oooo000F0?ooo`8000002`3oool2000001D0oooo0`00000l0?ooo`030000003o
ool0oooo06H0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`050?ooo`005P3oool0
0`000000oooo0?ooo`090?ooo`030000003oool0oooo0180oooo0`00000o0?ooo`030000003oool0
oooo06H0oooo00<000000?ooo`3oool07@3oool00`000000oooo0?ooo`040?ooo`005P3oool00`00
0000oooo0?ooo`080?ooo`030000003oool0oooo00l0oooo100000120?ooo`030000003oool0oooo
06L0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`040?ooo`005@3oool00`000000
oooo0?ooo`090?ooo`030000003oool0oooo00`0oooo0`0000160?ooo`030000003oool0oooo06P0
oooo00<000000?ooo`3oool06`3oool00`000000oooo0?ooo`040?ooo`005@3oool00`000000oooo
0?ooo`080?ooo`030000003oool0oooo00X0oooo0`0000190?ooo`030000003oool0oooo06T0oooo
00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`040?ooo`005@3oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00P0oooo0`00001;0?ooo`030000003oool0oooo06/0oooo00<0
00000?ooo`3oool06@3oool00`000000oooo0?ooo`040?ooo`005@3oool00`000000oooo0?ooo`07
0?ooo`030000003oool0oooo00@0oooo1000001>0?ooo`030000003oool0oooo06/0oooo00<00000
0?ooo`3oool06@3oool00`000000oooo0?ooo`040?ooo`005@3oool00`000000oooo0?ooo`060?oo
o`030000003oool0oooo0080oooo0`00001B0?ooo`030000003oool0oooo06`0oooo00<000000?oo
o`3oool0603oool00`000000oooo0?ooo`040?ooo`005@3oool3000000@0oooo0P0000020?ooo`<0
0000E@3oool00`000000oooo0?ooo`1]0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3o
ool00`3oool000d0oooo1@0000020?ooo`030000003oool0oooo00@0oooo00<000000?ooo`000000
0P00001H0?ooo`030000003oool0oooo06h0oooo00<000000?ooo`3oool05`3oool00`000000oooo
0?ooo`030?ooo`003`3oool00`000000oooo0?ooo`020?ooo`030000003oool0oooo0080oooo1000
001K0?ooo`030000003oool0oooo06l0oooo00<000000?ooo`3oool05P3oool00`000000oooo0?oo
o`030?ooo`003`3oool00`000000oooo0?ooo`020?ooo`030000003oool0000000800000G`3oool0
0`000000oooo0?ooo`1`0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool00`3oool0
00l0oooo00<000000?ooo`3oool00P3oool200000080oooo00<000000?ooo`3oool0G@3oool00`00
0000oooo0?ooo`1`0?ooo`030000003oool0oooo01D0oooo00<000000?ooo`3oool00`3oool000l0
oooo00<000000?ooo`3oool00`3oool300000600oooo00<000000?ooo`3oool0L@3oool00`000000
oooo0?ooo`0D0?ooo`030000003oool0oooo00<0oooo000>0?ooo`8000001`3oool00`000000oooo
0?ooo`1N0?ooo`030000003oool0oooo0780oooo00<000000?ooo`3oool04`3oool00`000000oooo
0?ooo`030?ooo`00603oool00`000000oooo0?ooo`1M0?ooo`030000003oool0oooo07<0oooo00<0
00000?ooo`3oool04`3oool00`000000oooo0?ooo`020?ooo`006@3oool2000005d0oooo00<00000
0?ooo`3oool0M03oool00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo0080oooo000K0?oo
o`030000003oool0000005X0oooo00<000000?ooo`3oool0M03oool00`000000oooo0?ooo`0B0?oo
o`030000003oool0oooo0080oooo000L0?ooo`800000FP3oool00`000000oooo0?ooo`1e0?ooo`03
0000003oool0oooo0140oooo00<000000?ooo`3oool00P3oool001h0oooo00<000000?ooo`3oool0
E`3oool00`000000oooo0?ooo`1f0?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0
0P3oool001l0oooo0P00001G0?ooo`030000003oool0oooo07L0oooo00<000000?ooo`3oool03`3o
ool00`000000oooo0?ooo`020?ooo`008@3oool00`000000oooo0000001D0?ooo`030000003oool0
oooo07P0oooo00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`020?ooo`005@3oool20000
00/0oooo00<000000?ooo`3oool0D`3oool00`000000oooo0?ooo`1i0?ooo`030000003oool0oooo
00h0oooo00<000000?ooo`3oool00@3oool001@0oooo00@000000?ooo`3oool000002`3oool20000
05<0oooo00<000000?ooo`3oool0N@3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo
0040oooo000D0?ooo`040000003oool0oooo000000d0oooo00<000000?ooo`3oool0D03oool00`00
0000oooo0?ooo`1j0?ooo`030000003oool0oooo00d0oooo00<000000?ooo`3oool00@3oool001@0
oooo00@000000?ooo`3oool000003P3oool3000004l0oooo00<000000?ooo`3oool0N`3oool00`00
0000oooo0?ooo`0<0?ooo`030000003oool0oooo0040oooo000D0?ooo`040000003oool0oooo0000
0100oooo00<000000?ooo`3oool0C@3oool00`000000oooo0?ooo`1l0?ooo`030000003oool0oooo
00/0oooo00<000000?ooo`3oool00@3oool001D0oooo0P00000B0?ooo`800000C@3oool00`000000
oooo0?ooo`1m0?ooo`030000003oool0oooo00X0oooo00<000000?ooo`3oool00@3oool002/0oooo
00<000000?ooo`000000BP3oool00`000000oooo0?ooo`1m0?ooo`030000003oool0oooo00X0oooo
00<000000?ooo`3oool00@3oool002`0oooo0P00001:0?ooo`030000003oool0oooo07h0oooo00<0
00000?ooo`3oool02@3oool00`000000oooo0?ooo`010?ooo`00;@3oool2000004T0oooo00<00000
0?ooo`3oool0O`3oool00`000000oooo0?ooo`090?ooo`4000000@3oool10?ooo`00;`3oool01000
0000oooo0?ooo`0000150?ooo`030000003oool0oooo0800oooo00<000000?ooo`3oool0203oool1
00000040oooo0@3oool00300oooo0`0000150?ooo`030000003oool0oooo0840oooo00<000000?oo
o`3oool01`3oool100000040oooo0@3oool00380oooo00<000000?ooo`3oool0@`3oool00`000000
oooo0?ooo`220?ooo`030000003oool0oooo00H0oooo0@0000010?ooo`40oooo000c0?ooo`030000
003oool0oooo0480oooo00<000000?ooo`3oool0PP3oool00`000000oooo0?ooo`060?ooo`400000
0@3oool10?ooo`00=03oool200000440oooo00<000000?ooo`3oool0Q03oool00`000000oooo0?oo
o`050?ooo`4000000@3oool10?ooo`00=P3oool2000003l0oooo00<000000?ooo`3oool0Q@3oool0
0`000000oooo0?ooo`040?ooo`4000000@3oool10?ooo`00=`3oool2000003h0oooo00<000000?oo
o`3oool0QP3oool00`000000oooo0?ooo`040?ooo`4000000@3oool003T0oooo00<000000?ooo`3o
ool0>`3oool00`000000oooo0?ooo`270?ooo`030000003oool0oooo00<0oooo0@0000010?ooo`00
>P3oool3000003X0oooo00<000000?ooo`3oool0Q`3oool00`000000oooo0?ooo`030?ooo`400000
0@3oool003`0oooo00<000000?ooo`3oool0>03oool00`000000oooo0?ooo`280?ooo`030000003o
ool0oooo0080oooo0@0000010?ooo`009P3oool2000000@0oooo0P0000030?ooo`@000000`3oool2
000000<0oooo00<000000?ooo`3oool0=`3oool00`000000oooo0?ooo`290?ooo`050000003oool0
oooo0?ooo`0000000@3oool002D0oooo00@000000?ooo`3oool00000203oool00`000000oooo0?oo
o`030?ooo`040000003oool0oooo000000<0oooo0P0000000`3oool000000?ooo`0d0?ooo`030000
003oool0oooo08X0oooo00@000000?ooo`3oool000000@3oool002D0oooo00@000000?ooo`3oool0
00002@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0oooo0P00000e0?ooo`03
0000003oool0oooo08/0oooo00<000000?ooo`0000000@3oool002D0oooo00@000000?ooo`3oool0
00002P3oool00`000000oooo0?ooo`020?ooo`8000001`3oool2000003@0oooo00<000000?ooo`3o
ool0S03oool100000040oooo0@00000002D0oooo00@000000?ooo`3oool00000203oool010000000
oooo0?ooo`0000030?ooo`030000003oool0oooo00P0oooo00<000000?ooo`3oool0<@3oool00`00
0000oooo0?ooo`2<0?ooo`4000000@3oool1000000009P3oool2000000X0oooo0P0000040?ooo`<0
00002@3oool00`000000oooo0000000`0?ooo`030000003oool0oooo08d0oooo0P00000004D0oooo
0P00000`0?ooo`030000003oool0oooo08`0oooo0`00000004L0oooo00D000000?ooo`3oool0oooo
0000000[0?ooo`030000003oool0oooo08P0oooo100000030?ooo`00B03oool3000002`0oooo00<0
00000?ooo`3oool0Q03oool4000000L0oooo001:0?ooo`030000003oool0oooo02X0oooo00<00000
0?ooo`3oool0O`3oool5000000/0oooo001;0?ooo`800000:P3oool00`000000oooo0?ooo`1k0?oo
o`@00000403oool004d0oooo00<000000?ooo`0000009`3oool00`000000oooo0?ooo`1g0?ooo`@0
0000503oool004h0oooo0P00000W0?ooo`030000003oool0oooo07<0oooo1000000H0?ooo`00C`3o
ool2000002H0oooo00<000000?ooo`3oool0KP3oool5000001`0oooo001A0?ooo`030000003oool0
000002<0oooo00<000000?ooo`3oool0JP3oool400000240oooo001B0?ooo`8000008`3oool00`00
0000oooo0?ooo`1V0?ooo`@000009@3oool005@0oooo00<000000?ooo`3oool0803oool00`000000
oooo0?ooo`1Q0?ooo`D00000:@3oool00480oooo0P0000040?ooo`800000103oool2000000D0oooo
0P0000000`3oool000000?ooo`0M0?ooo`030000003oool0oooo05d0oooo1000000^0?ooo`00@@3o
ool010000000oooo0?ooo`0000080?ooo`040000003oool0oooo000000H0oooo0P00000N0?ooo`03
0000003oool0oooo05T0oooo1000000b0?ooo`00@@3oool010000000oooo0?ooo`00000;0?ooo`03
0000003oool0oooo00D0oooo00<000000?ooo`3oool0703oool00`000000oooo0?ooo`1E0?ooo`@0
0000=P3oool00440oooo00@000000?ooo`3oool000002@3oool2000000T0oooo0P0000000`3oool0
00000?ooo`0I0?ooo`030000003oool0oooo0500oooo1@00000j0?ooo`00@@3oool010000000oooo
0?ooo`0000090?ooo`030000003oool0oooo00X0oooo0P00000J0?ooo`030000003oool0oooo04`0
oooo1000000o0?ooo`00@P3oool2000000X0oooo0`00000;0?ooo`8000006@3oool00`000000oooo
0?ooo`180?ooo`@00000@`3oool005h0oooo00<000000?ooo`0000005P3oool00`000000oooo0?oo
o`130?ooo`D00000A`3oool005l0oooo0P00000F0?ooo`030000003oool0oooo03l0oooo1000001<
0?ooo`00H03oool2000001@0oooo00<000000?ooo`3oool0?03oool400000500oooo001R0?ooo`03
0000003oool000000140oooo00<000000?ooo`3oool0=`3oool5000005@0oooo001S0?ooo`800000
4@3oool00`000000oooo0?ooo`0c0?ooo`@00000F@3oool006D0oooo00<000000?ooo`3oool03P3o
ool00`000000oooo0?ooo`0_0?ooo`@00000G@3oool006H0oooo0`00000=0?ooo`030000003oool0
oooo02/0oooo1000001Q0?ooo`00J03oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo
02H0oooo1@00001U0?ooo`00J@3oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo0280
oooo1000001Z0?ooo`00E@3oool2000000@0oooo0P0000050?ooo`030000003oool0oooo0080oooo
0P000000103oool000000000000000090?ooo`030000003oool0oooo01h0oooo1000001^0?ooo`00
E03oool010000000oooo0?ooo`00000:0?ooo`050000003oool0oooo0?ooo`0000000P3oool01000
0000oooo0?ooo`0000090?ooo`030000003oool0oooo01T0oooo1@00001b0?ooo`00E03oool01000
0000oooo0?ooo`00000:0?ooo`030000003oool0oooo00@0oooo00@000000?ooo`3oool0oooo0P00
00070?ooo`030000003oool0oooo01D0oooo1000001g0?ooo`00E03oool010000000oooo0?ooo`00
000;0?ooo`040000003oool0oooo0?ooo`8000001P3oool2000000D0oooo00<000000?ooo`3oool0
4@3oool4000007/0oooo001D0?ooo`040000003oool0oooo000000P0oooo00@000000?ooo`3oool0
00000`3oool00`000000oooo0?ooo`060?ooo`800000103oool00`000000oooo0?ooo`0=0?ooo`@0
0000O`3oool005D0oooo0P0000090?ooo`@000000`3oool3000000P0oooo00D000000?ooo`000000
oooo0000000:0?ooo`D00000P`3oool007<0oooo0P0000000`3oool000000?ooo`050?ooo`@00000
R03oool007@0oooo0`0000020?ooo`@00000S03oool007H0oooo0`00002@0?ooo`00o`3oool:0?oo
o`00o`3oool:0?ooo`00o`3oool:0?ooo`00o`3oool:0?ooo`00o`3oool:0?ooo`00LP3oool50000
0980oooo001d0?ooo`030000003oool0oooo0980oooo001d0?ooo`030000003oool0oooo0980oooo
001d0?ooo`030000003oool0oooo0980oooo001d0?ooo`030000003oool0oooo0980oooo001c0?oo
o`800000U03oool00001\
\>"],
  ImageRangeCache->{{{0, 264.313}, {286.938, 0}} -> {-0.0250653, -0.0386353, \
0.00352344, 0.00352344}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics3D  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(DSolve[{\(x''\)[t] + 2  x[t] - y[t] \[Equal] 
          0, \ \(y''\)[t] + 2  y[t] - x[t] \[Equal] 0}, {y[t], x[t], 
        t}]\)], "Input"],

Cell[BoxData[
    RowBox[{\(DSolve::"argm"\), \(\(:\)\(\ \)\), "\<\"\\!\\(DSolve\\) called \
with \\!\\(2\\) arguments; \\!\\(3\\) or more arguments are expected. \
\\!\\(\\*ButtonBox[\\\"More\[Ellipsis]\\\", ButtonStyle->\\\"RefGuideLinkText\
\\\", ButtonFrame->None, ButtonData:>\\\"General::argm\\\"]\\)\"\>"}]], \
"Message"],

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{\(2\ x[t]\), "-", \(y[t]\), "+", 
                RowBox[{
                  SuperscriptBox["x", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
              "0"}], ",", 
            RowBox[{
              RowBox[{\(-x[t]\), "+", \(2\ y[t]\), "+", 
                RowBox[{
                  SuperscriptBox["y", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
              "0"}]}], "}"}], ",", \({y[t], x[t], t}\)}], "]"}]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"DSolve", "[", 
      RowBox[{
        RowBox[{"{", 
          RowBox[{
            RowBox[{
              RowBox[{\(2\ x[t]\), "-", \(y[t]\), "+", 
                RowBox[{
                  SuperscriptBox["x", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
              "0"}], ",", 
            RowBox[{
              RowBox[{\(-x[t]\), "+", \(2\ y[t]\), "+", 
                RowBox[{
                  SuperscriptBox["y", "\[Prime]\[Prime]",
                    MultilineFunction->None], "[", "t", "]"}]}], "\[Equal]", 
              "0"}]}], "}"}], ",", \({y[t], x[t]}\), " ", ",", "t"}], 
      "]"}]], "Input"],

Cell[BoxData[
    \({{x[t] \[Rule] 
          1\/2\ C[4]\ \((Cos[t] - Cos[\@3\ t])\) + 
            1\/2\ C[3]\ \((Cos[t] + Cos[\@3\ t])\) + 
            1\/6\ C[2]\ \((3\ Sin[t] - \@3\ Sin[\@3\ t])\) + 
            1\/6\ C[1]\ \((3\ Sin[t] + \@3\ Sin[\@3\ t])\), 
        y[t] \[Rule] 
          1\/2\ C[3]\ \((Cos[t] - Cos[\@3\ t])\) + 
            1\/2\ C[4]\ \((Cos[t] + Cos[\@3\ t])\) + 
            1\/6\ C[1]\ \((3\ Sin[t] - \@3\ Sin[\@3\ t])\) + 
            1\/6\ C[2]\ \((3\ Sin[t] + \@3\ Sin[\@3\ t])\)}}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    RowBox[{"param", "=", 
      RowBox[{"ParametricPlot", "[", 
        RowBox[{\({Sin[t], Cos[t]}\), ",", \({t, 0, 8}\), ",", 
          " ", \(AxesLabel \[Rule] {"\<f1(x)\>", "\<f2(x)\>"}\), ",", 
          RowBox[{"AxesStyle", "\[Rule]", 
            RowBox[{"{", 
              RowBox[{
                FormBox["Thickness",
                  "TraditionalForm"], "[", "0.006", "]"}], "}"}]}], ",", 
          RowBox[{"PlotStyle", "\[Rule]", " ", 
            RowBox[{"{", 
              RowBox[{
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{
                      StyleBox["RGBColor",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      RowBox[{
                        StyleBox["1",
                          "MR"], 
                        StyleBox[",",
                          "MR"], " ", "0", 
                        StyleBox[",",
                          "MR"], " ", "0"}], 
                      StyleBox["]",
                        "MR"]}], 
                    StyleBox[",",
                      "MR"], 
                    RowBox[{
                      FormBox["Thickness",
                        "TraditionalForm"], "[", "0.006", "]"}]}], 
                  StyleBox["}",
                    "MR"]}], 
                StyleBox[",",
                  "MR"], 
                RowBox[{"{", 
                  RowBox[{
                    RowBox[{
                      StyleBox["RGBColor",
                        "MR"], 
                      StyleBox["[",
                        "MR"], 
                      RowBox[{
                        StyleBox["0",
                          "MR"], 
                        StyleBox[",",
                          "MR"], " ", "0", 
                        StyleBox[",",
                          "MR"], 
                        StyleBox["0",
                          "MR"]}], 
                      StyleBox["]",
                        "MR"]}], 
                    StyleBox[",",
                      "MR"], 
                    RowBox[{
                      FormBox["Thickness",
                        "TraditionalForm"], "[", "0.006", "]"}]}], 
                  StyleBox["}",
                    "MR"]}]}], "}"}]}], ",", " ", \(ImageSize \[Rule] 400\), 
          ",", " ", \(AspectRatio \[Rule] 0.8\), 
          ",", \(TextStyle \[Rule] {FontFamily \[Rule] "\<Times\>", 
              FontSize \[Rule] fontSize}\)}], "]"}]}]], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .8 
%%ImageSize: 400 320 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% Graphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
0.5 0.476191 0.4 0.380953 [
[.02381 .3875 -17.6563 -31.75 ]
[.02381 .3875 17.6563 0 ]
[.2619 .3875 -27.4375 -31.75 ]
[.2619 .3875 27.4375 0 ]
[.7381 .3875 -18.3125 -31.75 ]
[.7381 .3875 18.3125 0 ]
[.97619 .3875 -8.53125 -31.75 ]
[.97619 .3875 8.53125 0 ]
[1.025 .4 0 -15.875 ]
[1.025 .4 55.9375 15.875 ]
[.4875 .01905 -35.3125 -15.875 ]
[.4875 .01905 0 15.875 ]
[.4875 .20952 -54.875 -15.875 ]
[.4875 .20952 0 15.875 ]
[.4875 .59048 -36.625 -15.875 ]
[.4875 .59048 0 15.875 ]
[.4875 .78095 -17.0625 -15.875 ]
[.4875 .78095 0 15.875 ]
[.5 .825 -27.9688 0 ]
[.5 .825 27.9688 31.75 ]
[ -0.003 -0.003 0 0 ]
[ 1.003 .803 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.02381 .4 m
.02381 .40625 L
s
gsave
.02381 .3875 -78.6563 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.2619 .4 m
.2619 .40625 L
s
gsave
.2619 .3875 -88.4375 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.7381 .4 m
.7381 .40625 L
s
gsave
.7381 .3875 -79.3125 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.97619 .4 m
.97619 .40625 L
s
gsave
.97619 .3875 -69.5313 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.125 Mabswid
.07143 .4 m
.07143 .40375 L
s
.11905 .4 m
.11905 .40375 L
s
.16667 .4 m
.16667 .40375 L
s
.21428 .4 m
.21428 .40375 L
s
.30952 .4 m
.30952 .40375 L
s
.35714 .4 m
.35714 .40375 L
s
.40476 .4 m
.40476 .40375 L
s
.45238 .4 m
.45238 .40375 L
s
.54762 .4 m
.54762 .40375 L
s
.59524 .4 m
.59524 .40375 L
s
.64286 .4 m
.64286 .40375 L
s
.69048 .4 m
.69048 .40375 L
s
.78571 .4 m
.78571 .40375 L
s
.83333 .4 m
.83333 .40375 L
s
.88095 .4 m
.88095 .40375 L
s
.92857 .4 m
.92857 .40375 L
s
.006 w
0 .4 m
1 .4 L
s
gsave
1.025 .4 -61 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(f1) show
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
85.000 28.500 moveto
(H) show
93.438 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
106.500 28.500 moveto
(L) show
114.938 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
.25 Mabswid
.5 .01905 m
.50625 .01905 L
s
gsave
.4875 .01905 -96.3125 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.5 .20952 m
.50625 .20952 L
s
gsave
.4875 .20952 -115.875 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.5 .59048 m
.50625 .59048 L
s
gsave
.4875 .59048 -97.625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.5 .78095 m
.50625 .78095 L
s
gsave
.4875 .78095 -78.0625 -19.875 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.125 Mabswid
.5 .05714 m
.50375 .05714 L
s
.5 .09524 m
.50375 .09524 L
s
.5 .13333 m
.50375 .13333 L
s
.5 .17143 m
.50375 .17143 L
s
.5 .24762 m
.50375 .24762 L
s
.5 .28571 m
.50375 .28571 L
s
.5 .32381 m
.50375 .32381 L
s
.5 .3619 m
.50375 .3619 L
s
.5 .43809 m
.50375 .43809 L
s
.5 .47619 m
.50375 .47619 L
s
.5 .51429 m
.50375 .51429 L
s
.5 .55238 m
.50375 .55238 L
s
.5 .62857 m
.50375 .62857 L
s
.5 .66667 m
.50375 .66667 L
s
.5 .70476 m
.50375 .70476 L
s
.5 .74286 m
.50375 .74286 L
s
.006 w
.5 0 m
.5 .8 L
s
gsave
.5 .825 -88.9688 -4 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(f2) show
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
85.000 28.500 moveto
(H) show
93.438 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(x) show
%%IncludeResource: font Mathematica2
%%IncludeFont: Mathematica2
/Mathematica2 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
106.500 28.500 moveto
(L) show
114.938 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
0.000 0.000 rmoveto
1.000 setlinewidth
grestore
0 0 m
1 0 L
1 .8 L
0 .8 L
closepath
clip
newpath
1 0 0 r
.5 .78095 m
.5047 .78093 L
.50898 .78088 L
.51392 .78079 L
.51858 .78066 L
.52688 .78035 L
.53587 .77987 L
.54576 .77919 L
.55622 .77829 L
.57492 .77621 L
.59409 .77344 L
.61191 .77028 L
.65184 .76107 L
.69138 .74883 L
.72623 .73522 L
.765 .71651 L
.79886 .69658 L
.85394 .65485 L
.88103 .62848 L
.90376 .60196 L
.92326 .57455 L
.94108 .54356 L
.95422 .51439 L
.96364 .48688 L
.96757 .47218 L
.97096 .45629 L
.97231 .44855 L
.9734 .4412 L
.97422 .43464 L
.97496 .42739 L
.97557 .41943 L
.97582 .41506 L
.97599 .41096 L
.97611 .40714 L
.97617 .40364 L
.97619 .39979 L
.97616 .39574 L
.97608 .39162 L
.976 .38932 L
.97592 .38722 L
.97572 .38314 L
.97549 .3793 L
.97478 .37068 L
.97373 .36136 L
.97135 .34583 L
.9684 .33138 L
.95912 .29891 L
.9467 .26802 L
.92975 .2359 L
.91076 .20727 L
Mistroke
.88668 .17766 L
.83447 .12884 L
.77403 .08845 L
.73688 .06953 L
.70148 .05483 L
.66688 .04321 L
.62926 .03335 L
.6092 .0292 L
.58698 .02546 L
.5666 .02279 L
.54749 .02095 L
.53709 .0202 L
.52746 .01968 L
.52243 .01947 L
.51688 .01929 L
.51409 .01921 L
.51109 .01915 L
.50825 .0191 L
.50565 .01907 L
.50086 .01905 L
.49641 .01906 L
.49153 .01911 L
.48632 .0192 L
.48369 .01927 L
.48084 .01936 L
.47568 .01954 L
.46603 .02002 L
.4571 .0206 L
.44731 .02139 L
.42761 .02347 L
.40947 .02599 L
.39265 .02885 L
.35245 .0378 L
.31538 .04884 L
.2495 .07602 L
.21757 .09328 L
.18566 .11384 L
.13431 .156 L
.11149 .17971 L
.08957 .20682 L
.05748 .25929 L
.0448 .28813 L
.03429 .32052 L
.03034 .33711 L
.02857 .34629 L
.02714 .35498 L
.02605 .36311 L
.0251 .37195 L
.02477 .37585 L
.02447 .37999 L
Mistroke
.02424 .38385 L
.02407 .38742 L
.02393 .39128 L
.02384 .3955 L
.02381 .39921 L
.02382 .40317 L
.02389 .40706 L
.024 .41072 L
.02413 .41401 L
.02431 .41756 L
.0249 .42576 L
.02575 .43441 L
.0279 .44984 L
.0306 .46412 L
.03373 .47737 L
.04301 .50709 L
.05653 .53877 L
.07248 .56777 L
.11023 .61885 L
.16124 .66773 L
.21688 .70631 L
.28019 .73794 L
.31874 .75228 L
.35623 .76318 L
.39421 .77143 L
.41359 .77463 L
.43495 .77738 L
.45338 .77912 L
.46372 .77985 L
.47313 .78035 L
.4774 .78052 L
.48192 .78068 L
.48689 .78081 L
.49147 .78089 L
.49573 .78094 L
.49972 .78095 L
.50409 .78094 L
.50878 .78089 L
.51154 .78084 L
.51414 .78078 L
.51898 .78065 L
.52419 .78046 L
.52982 .7802 L
.53996 .77961 L
.54926 .77891 L
.5706 .77674 L
.59295 .77363 L
.63024 .76643 L
.67013 .75581 L
.70771 .7428 L
Mistroke
.74059 .72875 L
.80877 .69001 L
.86282 .64673 L
.88715 .62181 L
.91087 .59258 L
.92884 .56562 L
.94509 .53542 L
.95865 .50244 L
.96387 .48609 L
.96791 .47075 L
.97103 .45592 L
.97356 .44002 L
.97462 .4309 L
.97504 .42642 L
.97537 .42229 L
.97562 .41861 L
.97584 .41455 L
.97601 .41048 L
.97608 .40825 L
.97613 .40617 L
.97618 .40234 L
.97619 .39816 L
.97614 .39422 L
.97604 .39058 L
.97593 .3873 L
.97575 .38369 L
.97527 .37637 L
.97456 .36845 L
.97355 .35993 L
.97112 .34457 L
Mfstroke
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{400, 320},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0001@2000`400?l00000o`00003oo`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00W@3oool600000>d0oooo002O0?ooo`800000k`3o
ool009l0oooo0P00000;0?ooo`030000003oool0oooo0>40oooo002O0?ooo`8000002`3oool00`00
0000oooo0?ooo`3Q0?ooo`00W`3oool2000000/0oooo00<000000?ooo`3oool0h@3oool008T0oooo
3@0000090?ooo`8000002`3oool00`000000oooo0?ooo`3Q0?ooo`00R@3oool=000000T0oooo0P00
000;0?ooo`030000003oool0oooo0>40oooo002O0?ooo`8000002`3oool00`000000oooo0?ooo`3Q
0?ooo`00W`3oool00`000000o`000?l0000H0?l00=H0oooo002H0?ooo`P0o`0000<000000?ooo`3o
ool02@3oool00`000000oooo0?ooo`0;0?ooo`/0o`00b`3oool008d0oooo2`3o00070?ooo`800000
2`3oool00`000000oooo0?ooo`0F0?ooo`L0o`00a03oool008L0oooo1P3o000B0?ooo`8000002`3o
ool00`000000oooo0?ooo`0M0?ooo`D0o`00_`3oool008<0oooo103o000H0?ooo`8000002`3oool0
0`000000oooo0?ooo`0R0?ooo`@0o`00^`3oool007l0oooo103o000L0?ooo`8000002`3oool00`00
0000oooo0?ooo`0V0?ooo`<0o`00^03oool007/0oooo103o000P0?ooo`8000002`3oool00`000000
oooo0?ooo`0Y0?ooo`@0o`00]03oool007P0oooo0`3o000Q0?ooo`D000002`3oool00`000000oooo
0?ooo`0]0?ooo`@0o`00/03oool007D0oooo0`3o000V0?ooo`<000002`3oool00`000000oooo0?oo
o`0a0?ooo`@0o`00[03oool00780oooo0`3o000g0?ooo`030000003oool0oooo03D0oooo0`3o002Y
0?ooo`00K`3oool30?l003X0oooo00<000000?ooo`3oool0>03oool20?l00:L0oooo001]0?ooo`80
o`00?@3oool00`000000oooo0?ooo`0j0?ooo`<0o`00Y03oool006/0oooo0P3o000o0?ooo`800000
?P3oool30?l00:40oooo001X0?ooo`<0o`00@@3oool00`000000oooo0?ooo`100?ooo`<0o`00WP3o
ool006H0oooo0P3o00140?ooo`030000003oool0oooo04<0oooo0`3o002K0?ooo`00I03oool20?l0
04H0oooo00<000000?ooo`3oool0AP3oool30?l009P0oooo001Q0?ooo`<0o`00B03oool00`000000
oooo0?ooo`190?ooo`80o`00UP3oool005l0oooo0P3o001;0?ooo`030000003oool0oooo04/0oooo
0P3o002D0?ooo`00G@3oool20?l004d0oooo00<000000?ooo`3oool0C@3oool20?l00980oooo001J
0?ooo`<0o`00C`3oool00`000000oooo0?ooo`1?0?ooo`030?l0003oool0oooo08l0oooo001H0?oo
o`80o`00DP3oool00`000000oooo0?ooo`1@0?ooo`80o`00S`3oool005H0oooo0P3o001D0?ooo`03
0000003oool0oooo0580oooo0P3o002=0?ooo`00E03oool20?l005H0oooo00<000000?ooo`3oool0
E03oool20?l008/0oooo001B0?ooo`80o`00F03oool00`000000oooo0?ooo`1F0?ooo`030?l0003o
ool0oooo08P0oooo001@0?ooo`80o`00FP3oool00`000000oooo0?ooo`1G0?ooo`80o`00R03oool0
04h0oooo0P3o001L0?ooo`800000FP3oool00`3o0000oooo0?ooo`250?ooo`00C@3oool00`3o0000
oooo0?ooo`1L0?ooo`030000003oool0oooo05X0oooo0P3o00250?ooo`00C03oool00`3o0000oooo
0?ooo`1M0?ooo`030000003oool0oooo05`0oooo00<0o`000?ooo`3oool0PP3oool004X0oooo0P3o
001P0?ooo`030000003oool0oooo05d0oooo0P3o00220?ooo`00B@3oool00`3o0000oooo0?ooo`1P
0?ooo`030000003oool0oooo05l0oooo00<0o`000?ooo`3oool0O`3oool004L0oooo0P3o001S0?oo
o`030000003oool0oooo0600oooo0P3o001o0?ooo`00AP3oool00`3o0000oooo0?ooo`1S0?ooo`03
0000003oool0oooo0680oooo0P3o001m0?ooo`00A@3oool00`3o0000oooo0?ooo`1T0?ooo`030000
003oool0oooo06@0oooo00<0o`000?ooo`3oool0NP3oool004<0oooo0P3o001W0?ooo`030000003o
ool0oooo06D0oooo0P3o001j0?ooo`00@P3oool00`3o0000oooo0?ooo`1W0?ooo`030000003oool0
oooo06L0oooo00<0o`000?ooo`3oool0M`3oool00440oooo00<0o`000?ooo`3oool0J03oool00`00
0000oooo0?ooo`1X0?ooo`80o`00M`3oool00400oooo00<0o`000?ooo`3oool0J@3oool00`000000
oooo0?ooo`1Z0?ooo`030?l0003oool0oooo07@0oooo000o0?ooo`030?l0003oool0oooo06X0oooo
0P00001/0?ooo`030?l0003oool0oooo07<0oooo000m0?ooo`80o`00K@3oool00`000000oooo0?oo
o`1/0?ooo`030?l0003oool0oooo0780oooo000l0?ooo`030?l0003oool0oooo06d0oooo00<00000
0?ooo`3oool0K@3oool00`3o0000oooo0?ooo`1a0?ooo`00>`3oool00`3o0000oooo0?ooo`1^0?oo
o`030000003oool0oooo06h0oooo00<0o`000?ooo`3oool0L03oool003X0oooo00<0o`000?ooo`3o
ool0K`3oool00`000000oooo0?ooo`1_0?ooo`030?l0003oool0oooo06l0oooo000i0?ooo`030?l0
003oool0oooo0700oooo00<000000?ooo`3oool0L03oool00`3o0000oooo0?ooo`1^0?ooo`00=`3o
ool20?l007<0oooo00<000000?ooo`3oool0L@3oool00`3o0000oooo0?ooo`1]0?ooo`00=P3oool0
0`3o0000oooo0?ooo`1c0?ooo`030000003oool0oooo0780oooo0P3o001]0?ooo`00=@3oool00`3o
0000oooo0?ooo`1d0?ooo`030000003oool0oooo07@0oooo00<0o`000?ooo`3oool0JP3oool003@0
oooo00<0o`000?ooo`3oool0M@3oool00`000000oooo0?ooo`1e0?ooo`030?l0003oool0oooo06T0
oooo000c0?ooo`030?l0003oool0oooo07H0oooo00<000000?ooo`3oool0MP3oool00`3o0000oooo
0?ooo`1X0?ooo`00<P3oool00`3o0000oooo0?ooo`1g0?ooo`030000003oool0oooo07L0oooo00<0
o`000?ooo`3oool0I`3oool00340oooo00<0o`000?ooo`3oool0N03oool00`000000oooo0?ooo`1h
0?ooo`030?l0003oool0oooo06H0oooo000`0?ooo`030?l0003oool0oooo07T0oooo0P00001j0?oo
o`030?l0003oool0oooo06D0oooo000_0?ooo`030?l0003oool0oooo07X0oooo00<000000?ooo`3o
ool0NP3oool00`3o0000oooo0?ooo`1T0?ooo`00;P3oool00`3o0000oooo0?ooo`1k0?ooo`030000
003oool0oooo07/0oooo00<0o`000?ooo`3oool0H`3oool002d0oooo00<0o`000?ooo`3oool0O03o
ool00`000000oooo0?ooo`1l0?ooo`030?l0003oool0oooo0680oooo000/0?ooo`030?l0003oool0
oooo05X0oooo100000070?ooo`8000001@3oool5000000`0oooo00<000000?ooo`3oool0O@3oool0
0`3o0000oooo0?ooo`1Q0?ooo`00;03oool00`3o0000oooo0?ooo`1I0?ooo`8000000`3oool20000
00D0oooo0P0000040?ooo`800000103oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo
07d0oooo00<0o`000?ooo`3oool0H@3oool002/0oooo00<0o`000?ooo`3oool0FP3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo0100oooo00<000000?ooo`3oool0203oool00`000000
oooo0?ooo`1n0?ooo`030?l0003oool0oooo0600oooo000Z0?ooo`030?l0003oool0oooo05X0oooo
0P0000050?ooo`8000004P3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo07l0oooo
00<0o`000?ooo`3oool0G`3oool002T0oooo00<0o`000?ooo`3oool0F`3oool00`000000oooo0?oo
o`050?ooo`030000003oool0oooo0100oooo0P0000080?ooo`030000003oool0oooo0800oooo00<0
o`000?ooo`3oool0GP3oool002T0oooo00<0o`000?ooo`3oool0B@3oool=000000@0oooo0P000007
0?ooo`8000004@3oool2000000P0oooo00<000000?ooo`3oool0P03oool00`3o0000oooo0?ooo`1N
0?ooo`00:03oool00`3o0000oooo0?ooo`1:0?ooo`d00000103oool2000000L0oooo0P00000A0?oo
o`800000203oool00`000000oooo0?ooo`210?ooo`030?l0003oool0oooo05d0oooo000W0?ooo`03
0?l0003oool0oooo05`0oooo0P0000070?ooo`8000004@3oool2000000P0oooo00<000000?ooo`3o
ool0PP3oool00`3o0000oooo0?ooo`1L0?ooo`009P3oool00`3o0000oooo0?ooo`1M0?ooo`800000
1`3oool200000100oooo0`0000080?ooo`<00000P`3oool00`3o0000oooo0?ooo`1K0?ooo`009P3o
ool00`3o0000oooo0?ooo`1M0?ooo`8000001`3oool2000000l0oooo0`0000090?ooo`030000003o
ool0oooo08<0oooo00<0o`000?ooo`3oool0F`3oool002D0oooo00<0o`000?ooo`3oool0GP3oool2
000000L0oooo0P00000=0?ooo`@000002P3oool00`000000oooo0?ooo`240?ooo`030?l0003oool0
oooo05X0oooo000T0?ooo`030?l0003oool0oooo05l0oooo0P0000070?ooo`8000002P3oool60000
00/0oooo00<000000?ooo`3oool0Q@3oool00`3o0000oooo0?ooo`1I0?ooo`00903oool00`3o0000
oooo0?ooo`1P0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool02P3oool3000000d0
oooo00<000000?ooo`3oool0Q@3oool00`3o0000oooo0?ooo`1I0?ooo`008`3oool00`3o0000oooo
0?ooo`1Q0?ooo`8000001@3oool2000000`0oooo00<000000?ooo`3oool03@3oool00`000000oooo
0?ooo`260?ooo`030?l0003oool0oooo05P0oooo000R0?ooo`030?l0003oool0oooo06<0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo00`0oooo00<0
00000?ooo`3oool0Q`3oool00`3o0000oooo0?ooo`1G0?ooo`008P3oool00`3o0000oooo0?ooo`1S
0?ooo`8000000`3oool2000000h0oooo1P0000090?ooo`030000003oool0oooo08P0oooo00<0o`00
0?ooo`3oool0EP3oool00240oooo00<0o`000?ooo`3oool0IP3oool300000140oooo1P0000080?oo
o`030000003oool0oooo08P0oooo00<0o`000?ooo`3oool0EP3oool00240oooo00<0o`000?ooo`3o
ool0R03oool00`000000oooo0?ooo`290?ooo`030?l0003oool0oooo05D0oooo000P0?ooo`030?l0
003oool0oooo08T0oooo00<000000?ooo`3oool0R@3oool00`3o0000oooo0?ooo`1E0?ooo`007`3o
ool00`3o0000oooo0?ooo`2:0?ooo`030000003oool0oooo08X0oooo00<0o`000?ooo`3oool0E03o
ool001l0oooo00<0o`000?ooo`3oool0RP3oool2000008/0oooo00<0o`000?ooo`3oool0E03oool0
01h0oooo00<0o`000?ooo`3oool0R`3oool00`000000oooo0?ooo`2;0?ooo`030?l0003oool0oooo
05<0oooo000M0?ooo`030?l0003oool0oooo08`0oooo00<000000?ooo`3oool0R`3oool00`3o0000
oooo0?ooo`1C0?ooo`007@3oool00`3o0000oooo0?ooo`2<0?ooo`030000003oool0oooo08`0oooo
00<0o`000?ooo`3oool0DP3oool001`0oooo00<0o`000?ooo`3oool0S@3oool00`000000oooo0?oo
o`2<0?ooo`030?l0003oool0oooo0580oooo000L0?ooo`030?l0003oool0oooo08d0oooo00<00000
0?ooo`3oool0S@3oool00`3o0000oooo0?ooo`1A0?ooo`006`3oool00`3o0000oooo0?ooo`2>0?oo
o`030000003oool0oooo08d0oooo00<0o`000?ooo`3oool0D@3oool001/0oooo00<0o`000?ooo`3o
ool0SP3oool00`000000oooo0?ooo`2>0?ooo`030?l0003oool0oooo0500oooo000J0?ooo`030?l0
003oool0oooo08l0oooo00<000000?ooo`3oool0SP3oool00`3o0000oooo0?ooo`1@0?ooo`006P3o
ool00`3o0000oooo0?ooo`2?0?ooo`030000003oool0oooo08l0oooo00<0o`000?ooo`3oool0C`3o
ool001X0oooo00<0o`000?ooo`3oool0S`3oool00`000000oooo0?ooo`2?0?ooo`030?l0003oool0
oooo04l0oooo000I0?ooo`030?l0003oool0oooo0900oooo00<000000?ooo`3oool0T03oool00`3o
0000oooo0?ooo`1>0?ooo`006@3oool00`3o0000oooo0?ooo`2@0?ooo`030000003oool0oooo0900
oooo00<0o`000?ooo`3oool0CP3oool001P0oooo00<0o`000?ooo`3oool0T@3oool200000940oooo
00<0o`000?ooo`3oool0CP3oool001P0oooo00<0o`000?ooo`3oool0T@3oool00`000000oooo0?oo
o`2A0?ooo`030?l0003oool0oooo04d0oooo000H0?ooo`030?l0003oool0oooo0940oooo00<00000
0?ooo`3oool0T@3oool00`3o0000oooo0?ooo`1=0?ooo`005`3oool00`3o0000oooo0?ooo`2B0?oo
o`030000003oool0oooo0980oooo00<0o`000?ooo`3oool0C03oool001L0oooo00<0o`000?ooo`3o
ool0TP3oool00`000000oooo0?ooo`2B0?ooo`030?l0003oool0oooo04`0oooo000G0?ooo`030?l0
003oool0oooo0980oooo00<000000?ooo`3oool0TP3oool00`3o0000oooo0?ooo`1<0?ooo`005P3o
ool00`3o0000oooo0?ooo`2C0?ooo`030000003oool0oooo09<0oooo00<0o`000?ooo`3oool0B`3o
ool001H0oooo00<0o`000?ooo`3oool0T`3oool00`000000oooo0?ooo`2C0?ooo`030?l0003oool0
oooo04/0oooo000F0?ooo`030?l0003oool0oooo09<0oooo00<000000?ooo`3oool0T`3oool00`3o
0000oooo0?ooo`1;0?ooo`005P3oool00`3o0000oooo00000005000003d0oooo100000070?ooo`80
00001@3oool5000003X0oooo00<000000?ooo`3oool0?P3oool4000000L0oooo0P0000050?ooo`D0
0000?P3oool00`3o0000oooo00000005000004H0oooo000E0?ooo`030?l0003oool0oooo0080oooo
0P00000n0?ooo`8000000`3oool2000000D0oooo0P0000040?ooo`800000103oool00`000000oooo
0?ooo`0g0?ooo`030000003oool0oooo03d0oooo0P0000030?ooo`8000001@3oool2000000@0oooo
0P0000040?ooo`030000003oool0oooo03`0oooo00<0o`000?ooo`3oool00P0000180?ooo`005@3o
ool00`3o0000oooo0?ooo`020?ooo`800000?P3oool00`000000oooo0?ooo`030?ooo`030000003o
ool0oooo0100oooo00<000000?ooo`3oool0=P3oool00`000000oooo0?ooo`0m0?ooo`030000003o
ool0oooo00<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`0k0?ooo`030?l0003o
ool0oooo00800000B03oool001D0oooo00<0o`000?ooo`3oool00P3oool2000003d0oooo0P000005
0?ooo`8000004P3oool00`000000oooo0?ooo`0e0?ooo`800000?@3oool2000000D0oooo0P00000B
0?ooo`030000003oool0oooo03X0oooo00<0o`000?ooo`3oool00P0000180?ooo`00503oool00`3o
0000oooo0?ooo`030?ooo`800000?@3oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo
0100oooo0P00000f0?ooo`030000003oool0oooo03`0oooo00<000000?ooo`3oool01@3oool00`00
0000oooo0?ooo`0@0?ooo`800000>`3oool00`3o0000oooo0?ooo`02000004P0oooo00040?ooo`d0
00000`3oool00`3o0000oooo0?ooo`030?ooo`800000:`3oool=000000@0oooo0P0000070?ooo`80
00004@3oool2000003H0oooo00<000000?ooo`3oool0>`3oool2000000L0oooo0P00000A0?ooo`80
0000?03oool0103o0000oooo0000000000180?ooo`00103oool=00000080oooo00<0o`000?ooo`3o
ool0103oool2000002/0oooo3@0000040?ooo`8000001`3oool200000140oooo0P00000f0?ooo`03
0000003oool0oooo03/0oooo0P0000070?ooo`8000004@3oool2000003`0oooo00@0o`000?ooo`00
00000000B03oool001<0oooo00<0o`000?ooo`3oool0103oool2000003`0oooo0P0000070?ooo`80
00004@3oool2000003H0oooo00<000000?ooo`3oool0>`3oool2000000L0oooo0P00000A0?ooo`80
0000?03oool0103o0000oooo0000000000180?ooo`004`3oool00`3o0000oooo0?ooo`040?ooo`80
0000?03oool2000000L0oooo0P00000@0?ooo`<00000=P3oool00`000000oooo0?ooo`0k0?ooo`80
00001`3oool200000100oooo0`00000l0?ooo`040?l0003oool00000000004P0oooo000C0?ooo`03
0?l0003oool0oooo00@0oooo0P00000l0?ooo`8000001`3oool2000000l0oooo0`00000g0?ooo`03
0000003oool0oooo03/0oooo0P0000070?ooo`8000003`3oool3000003h0oooo00<0o`0000000000
0000B03oool001<0oooo00<0o`000?ooo`3oool0103oool2000003`0oooo0P0000070?ooo`800000
3@3oool4000003P0oooo00<000000?ooo`3oool0>`3oool2000000L0oooo0P00000=0?ooo`@00000
?`3oool00`3o00000000000000180?ooo`004`3oool00`3o0000oooo0?ooo`040?ooo`800000?03o
ool2000000L0oooo0P00000:0?ooo`H00000>@3oool00`000000oooo0?ooo`0k0?ooo`8000001`3o
ool2000000X0oooo1P0000100?ooo`030?l000000000000004P0oooo000B0?ooo`030?l0003oool0
oooo00D0oooo0P00000m0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool02P3oool3
000003/0oooo00<000000?ooo`3oool0?03oool00`000000oooo0?ooo`050?ooo`030000003oool0
oooo00X0oooo0`0000120?ooo`030?l000000000000004P0oooo000B0?ooo`030?l0003oool0oooo
00D0oooo0P00000m0?ooo`8000001@3oool2000000`0oooo00<000000?ooo`3oool0>`3oool00`00
0000oooo0?ooo`0l0?ooo`8000001@3oool2000000`0oooo00<000000?ooo`3oool0@`3oool00`3o
000000000?ooo`170?ooo`004P3oool00`3o0000oooo0?ooo`050?ooo`800000?P3oool00`000000
oooo0?ooo`030?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool0>P3oool00`000000
oooo0?ooo`0m0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0303oool00`000000
oooo0?ooo`120?ooo`030?l000000000oooo04L0oooo000B0?ooo`030?l0003oool0oooo0080oooo
1@00000n0?ooo`8000000`3oool2000000h0oooo1P00000g0?ooo`030000003oool0oooo03d0oooo
0P0000030?ooo`8000003P3oool6000003`0oooo0`0000000`3o000000000?ooo`170?ooo`004P3o
ool00`3o0000oooo0?ooo`040?ooo`<00000@03oool300000140oooo1P00000f0?ooo`800000@03o
ool300000140oooo1P00000m0?ooo`030000003o0000000002d0oooo00<000000?ooo`3oool03@3o
ool00`000000oooo0?ooo`080?ooo`004P3oool00`3o0000oooo0?ooo`2G0?ooo`030000003oool0
oooo09L0oooo00<0o`000?ooo`3oool0:`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0
oooo00L0oooo000B0?ooo`030?l0003oool0oooo09L0oooo00<000000?ooo`3oool0U`3oool00`3o
0000oooo0?ooo`0Z0?ooo`030000003oool0oooo0140oooo00<000000?ooo`3oool01P3oool00180
oooo00<0o`000?ooo`3oool0U`3oool00`000000oooo0?ooo`2G0?ooo`030?l0003oool0oooo02T0
oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`050?ooo`004@3oool00`3o0000oooo
0?ooo`2H0?ooo`030000003oool0oooo09L0oooo00<0o`000?ooo`3oool04@3oool6000000D0oooo
1P0000060?ooo`800000103oool4000000@0oooo1@0000040?ooo`8000001P3oool00140oooo00<0
o`000?ooo`3oool0V03oool00`000000oooo0?ooo`2G0?ooo`030?l0003oool0oooo01<0oooo0P00
00090?ooo`800000203oool2000000D0oooo0P0000060?ooo`8000001P3oool2000000H0oooo000A
0?ooo`030?l0003oool0oooo09P0oooo00<000000?ooo`3oool0V03oool00`3o0000oooo0?ooo`0B
0?ooo`8000002@3oool2000000P0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`03
0?ooo`800000203oool00`000000oooo0?ooo`040?ooo`004@3oool00`3o0000oooo0?ooo`2H0?oo
o`030000003oool0oooo09P0oooo00<0o`000?ooo`3oool04P3oool2000000T0oooo0P0000070?oo
o`800000203oool010000000oooo0?ooo`3oool3000000P0oooo0P0000050?ooo`004@3oool00`3o
0000oooo0?ooo`2H0?ooo`030000003oool0oooo09P0oooo00<0o`000?ooo`3oool04P3oool20000
00T0oooo0P0000070?ooo`8000002@3oool00`000000oooo0?ooo`02000000T0oooo0P0000050?oo
o`004@3oool00`3o0000oooo0?ooo`2H0?ooo`030000003oool0oooo09P0oooo00<0o`000?ooo`3o
ool04P3oool2000000T0oooo0P0000070?ooo`8000002P3oool3000000X0oooo0P0000050?ooo`00
4@3oool00`3o0000oooo0?ooo`2H0?ooo`030000003oool0oooo09P0oooo00<0o`000?ooo`3oool0
4P3oool2000000T0oooo0P0000070?ooo`8000002P3oool2000000/0oooo0P0000050?ooo`004@3o
ool00`3o0000oooo0?ooo`2H0?ooo`030000003oool0oooo09P0oooo00<0o`000?ooo`3oool04P3o
ool2000000T0oooo0P0000070?ooo`8000002@3oool4000000X0oooo0P0000050?ooo`002@3oool8
000000030?l00000000000000?l00000=00000000`3o0000000000000005000000d0oooo0P000009
0?ooo`8000001`3oool2000000P0oooo0`0000000`3oool000000?ooo`090?ooo`8000001@3oool0
0140oooo00<0o`000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo
00`0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
00d0oooo00<000000?ooo`3oool0303oool00`000000oooo0?ooo`0=0?ooo`030?l0003oool0oooo
0180oooo0P0000090?ooo`8000001`3oool2000000P0oooo0P0000030?ooo`030000003oool0oooo
00L0oooo0P0000050?ooo`004@3oool00`3o0000oooo0?ooo`1;0?ooo`030000003oool0oooo04X0
oooo00<000000?ooo`3oool0BP3oool00`000000oooo0?ooo`1;0?ooo`030?l0003oool0oooo0180
oooo0P0000090?ooo`8000001`3oool2000000L0oooo0P0000050?ooo`030000003oool0oooo00H0
oooo0P0000050?ooo`004@3oool00`3o0000oooo0?ooo`2H0?ooo`030000003oool0oooo09P0oooo
00<0o`000?ooo`3oool0403oool7000000H0oooo0P0000080?ooo`030000003oool0oooo00<0oooo
1@0000030?ooo`@000001P3oool00`000000oooo0?ooo`040?ooo`004@3oool00`3o0000oooo0?oo
o`2H0?ooo`030000003oool0oooo09P0oooo00<0o`000?ooo`3oool04P3oool2000000T0oooo0P00
00080?ooo`8000005@3oool2000000H0oooo000A0?ooo`030?l0003oool0oooo09P0oooo00<00000
0?ooo`3oool0V03oool00`3o0000oooo0?ooo`0B0?ooo`8000002@3oool2000000P0oooo0P00000E
0?ooo`8000001P3oool00140oooo00<0o`000?ooo`3oool0V03oool00`000000oooo0?ooo`2G0?oo
o`80o`00503oool2000000T0oooo0P0000090?ooo`030000003oool0oooo01<0oooo00<000000?oo
o`3oool01@3oool00140oooo00<0o`000?ooo`3oool0V03oool00`000000oooo0?ooo`2G0?ooo`03
0?l0003oool0oooo01@0oooo00<000000?ooo`3oool00P3oool7000000X0oooo00<000000?ooo`3o
ool04@3oool00`000000oooo0?ooo`060?ooo`004P3oool00`3o0000oooo0?ooo`2G0?ooo`030000
003oool0oooo09L0oooo00<0o`000?ooo`3oool0503oool200000080oooo0`0000020?ooo`<00000
2`3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo00L0oooo000B0?ooo`030?l0003o
ool0oooo09L0oooo00<000000?ooo`3oool0U`3oool00`3o0000oooo0?ooo`0F0?ooo`@000004P3o
ool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo00P0oooo000B0?ooo`030?l0003oool0
oooo09L0oooo00<000000?ooo`3oool0U`3oool00`3o0000oooo0?ooo`170?ooo`004P3oool00`3o
0000oooo0?ooo`2G0?ooo`030000003oool0oooo09L0oooo00<0o`000?ooo`3oool0A`3oool00180
oooo00<0o`000?ooo`3oool0U`3oool2000009P0oooo00<0o`000?ooo`3oool0A`3oool00180oooo
00<0o`000?ooo`3oool0U`3oool00`000000oooo0?ooo`2G0?ooo`030?l0003oool0oooo04L0oooo
000B0?ooo`030?l0003oool0oooo09L0oooo00<000000?ooo`3oool0U`3oool00`3o0000oooo0?oo
o`170?ooo`004P3oool00`3o0000oooo0?ooo`2G0?ooo`030000003oool0oooo09H0oooo0P3o0019
0?ooo`004P3oool00`3o0000oooo0?ooo`2G0?ooo`030000003oool0oooo09H0oooo00<0o`000?oo
o`3oool0B03oool00180oooo00<0o`000?ooo`3oool0U`3oool00`000000oooo0?ooo`2F0?ooo`03
0?l0003oool0oooo04P0oooo000B0?ooo`030?l0003oool0oooo09L0oooo00<000000?ooo`3oool0
UP3oool00`3o0000oooo0?ooo`180?ooo`004`3oool00`3o0000oooo0?ooo`2F0?ooo`030000003o
ool0oooo09H0oooo00<0o`000?ooo`3oool0B03oool001<0oooo00<0o`000?ooo`3oool0UP3oool0
0`000000oooo0?ooo`2F0?ooo`030?l0003oool0oooo04P0oooo000C0?ooo`030?l0003oool0oooo
09H0oooo00<000000?ooo`3oool0U@3oool00`3o0000oooo0?ooo`190?ooo`004`3oool00`3o0000
oooo0?ooo`2F0?ooo`030000003oool0oooo09D0oooo00<0o`000?ooo`3oool0B@3oool001<0oooo
00<0o`000?ooo`3oool0UP3oool00`000000oooo0?ooo`2E0?ooo`030?l0003oool0oooo04T0oooo
000D0?ooo`030?l0003oool0oooo09D0oooo00<000000?ooo`3oool0U@3oool00`3o0000oooo0?oo
o`190?ooo`00503oool00`3o0000oooo0?ooo`2E0?ooo`800000UP3oool00`3o0000oooo0?ooo`19
0?ooo`00503oool00`3o0000oooo0?ooo`2E0?ooo`030000003oool0oooo09@0oooo00<0o`000?oo
o`3oool0BP3oool001D0oooo00<0o`000?ooo`3oool0U03oool00`000000oooo0?ooo`2D0?ooo`03
0?l0003oool0oooo04X0oooo000E0?ooo`030?l0003oool0oooo09@0oooo00<000000?ooo`3oool0
U03oool00`3o0000oooo0?ooo`1:0?ooo`005@3oool00`3o0000oooo0?ooo`2D0?ooo`030000003o
ool0oooo09@0oooo00<0o`000?ooo`3oool0BP3oool001D0oooo00<0o`000?ooo`3oool0U03oool0
0`000000oooo0?ooo`2C0?ooo`030?l0003oool0oooo04/0oooo000F0?ooo`030?l0003oool0oooo
09<0oooo00<000000?ooo`3oool0T`3oool00`3o0000oooo0?ooo`1;0?ooo`005P3oool00`3o0000
oooo0?ooo`2C0?ooo`030000003oool0oooo0980oooo0P3o001=0?ooo`005P3oool00`3o0000oooo
0?ooo`2C0?ooo`030000003oool0oooo0980oooo00<0o`000?ooo`3oool0C03oool001L0oooo00<0
o`000?ooo`3oool0TP3oool00`000000oooo0?ooo`2B0?ooo`030?l0003oool0oooo04`0oooo000G
0?ooo`030?l0003oool0oooo0980oooo00<000000?ooo`3oool0T@3oool20?l004h0oooo000G0?oo
o`030?l0003oool0oooo0980oooo00<000000?ooo`3oool0T@3oool00`3o0000oooo0?ooo`1=0?oo
o`00603oool00`3o0000oooo0?ooo`2A0?ooo`800000TP3oool00`3o0000oooo0?ooo`1=0?ooo`00
603oool00`3o0000oooo0?ooo`2A0?ooo`030000003oool0oooo0900oooo00<0o`000?ooo`3oool0
CP3oool001T0oooo00<0o`000?ooo`3oool0T03oool00`000000oooo0?ooo`2@0?ooo`030?l0003o
ool0oooo04h0oooo000I0?ooo`030?l0003oool0oooo0900oooo00<000000?ooo`3oool0S`3oool0
0`3o0000oooo0?ooo`1?0?ooo`006P3oool00`3o0000oooo0?ooo`2?0?ooo`030000003oool0oooo
08l0oooo00<0o`000?ooo`3oool0C`3oool001X0oooo00<0o`000?ooo`3oool0S`3oool00`000000
oooo0?ooo`2>0?ooo`80o`00D@3oool001/0oooo00<0o`000?ooo`3oool0SP3oool00`000000oooo
0?ooo`2>0?ooo`030?l0003oool0oooo0500oooo000K0?ooo`030?l0003oool0oooo08h0oooo00<0
00000?ooo`3oool0S@3oool20?l00580oooo000L0?ooo`030?l0003oool0oooo08d0oooo00<00000
0?ooo`3oool0S@3oool00`3o0000oooo0?ooo`1A0?ooo`007@3oool00`3o0000oooo0?ooo`2<0?oo
o`030000003oool0oooo08`0oooo0P3o001C0?ooo`007@3oool00`3o0000oooo0?ooo`2<0?ooo`03
0000003oool0oooo08`0oooo00<0o`000?ooo`3oool0DP3oool001h0oooo00<0o`000?ooo`3oool0
R`3oool00`000000oooo0?ooo`2;0?ooo`80o`00E03oool001h0oooo00<0o`000?ooo`3oool0R`3o
ool2000008`0oooo00<0o`000?ooo`3oool0D`3oool001l0oooo00<0o`000?ooo`3oool0RP3oool0
0`000000oooo0?ooo`2:0?ooo`030?l0003oool0oooo05@0oooo000O0?ooo`030?l0003oool0oooo
08X0oooo00<000000?ooo`3oool0RP3oool00`3o0000oooo0?ooo`1D0?ooo`00803oool00`3o0000
oooo0?ooo`290?ooo`030000003oool0oooo08T0oooo00<0o`000?ooo`3oool0E@3oool00200oooo
00<0o`000?ooo`3oool0R@3oool00`000000oooo0?ooo`280?ooo`80o`00E`3oool00240oooo00<0
o`000?ooo`3oool0I@3oool4000000L0oooo0P0000050?ooo`D00000303oool00`000000oooo0?oo
o`280?ooo`030?l0003oool0oooo05H0oooo000R0?ooo`030?l0003oool0oooo06<0oooo0P000003
0?ooo`8000001@3oool2000000@0oooo0P0000040?ooo`030000003oool0oooo00T0oooo00<00000
0?ooo`3oool0Q`3oool00`3o0000oooo0?ooo`1G0?ooo`008P3oool00`3o0000oooo0?ooo`1S0?oo
o`030000003oool0oooo00<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?ooo`080?oo
o`030000003oool0oooo08H0oooo0P3o001I0?ooo`008`3oool00`3o0000oooo0?ooo`1Q0?ooo`80
00001@3oool200000180oooo00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`260?ooo`03
0?l0003oool0oooo05P0oooo000T0?ooo`030?l0003oool0oooo0600oooo00<000000?ooo`3oool0
1@3oool00`000000oooo0?ooo`0@0?ooo`800000203oool00`000000oooo0?ooo`250?ooo`030?l0
003oool0oooo05T0oooo000U0?ooo`030?l0003oool0oooo05h0oooo0P0000070?ooo`8000004@3o
ool2000000P0oooo00<000000?ooo`3oool0Q03oool20?l005/0oooo000U0?ooo`030?l0003oool0
oooo05h0oooo0P0000070?ooo`8000004@3oool2000000P0oooo00<000000?ooo`3oool0P`3oool2
0?l005`0oooo000V0?ooo`030?l0003oool0oooo05d0oooo0P0000070?ooo`8000004@3oool20000
00P0oooo00<000000?ooo`3oool0P`3oool00`3o0000oooo0?ooo`1K0?ooo`009`3oool00`3o0000
oooo0?ooo`1L0?ooo`8000001`3oool200000100oooo0`0000080?ooo`<00000PP3oool20?l005d0
oooo000W0?ooo`030?l0003oool0oooo05`0oooo0P0000070?ooo`8000003`3oool3000000T0oooo
00<000000?ooo`3oool0P@3oool20?l005h0oooo000X0?ooo`030?l0003oool0oooo05/0oooo0P00
00070?ooo`8000003@3oool4000000X0oooo00<000000?ooo`3oool0P@3oool00`3o0000oooo0?oo
o`1M0?ooo`00:@3oool00`3o0000oooo0?ooo`1J0?ooo`8000001`3oool2000000X0oooo1P00000;
0?ooo`030000003oool0oooo0800oooo0P3o001O0?ooo`00:@3oool00`3o0000oooo0?ooo`1K0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool02P3oool3000000d0oooo00<000000?oo
o`3oool0O`3oool20?l00600oooo000Z0?ooo`030?l0003oool0oooo05X0oooo0P0000050?ooo`80
0000303oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo07h0oooo0P3o001Q0?ooo`00
:`3oool00`3o0000oooo0?ooo`1J0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0
303oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo07h0oooo00<0o`000?ooo`3oool0
H03oool002`0oooo00<0o`000?ooo`3oool0F@3oool2000000<0oooo0P00000>0?ooo`H000002@3o
ool00`000000oooo0?ooo`1m0?ooo`030?l0003oool0oooo0640oooo000/0?ooo`030?l0003oool0
oooo05/0oooo0`00000A0?ooo`H00000203oool00`000000oooo0?ooo`1l0?ooo`030?l0003oool0
oooo0680oooo000]0?ooo`030?l0003oool0oooo07`0oooo00<000000?ooo`3oool0O03oool00`3o
0000oooo0?ooo`1R0?ooo`00;P3oool00`3o0000oooo0?ooo`1k0?ooo`030000003oool0oooo07/0
oooo00<0o`000?ooo`3oool0H`3oool002l0oooo00<0o`000?ooo`3oool0NP3oool00`000000oooo
0?ooo`1j0?ooo`030?l0003oool0oooo06@0oooo000`0?ooo`030?l0003oool0oooo07T0oooo0P00
001j0?ooo`030?l0003oool0oooo06D0oooo000a0?ooo`030?l0003oool0oooo07P0oooo00<00000
0?ooo`3oool0N03oool00`3o0000oooo0?ooo`1V0?ooo`00<P3oool00`3o0000oooo0?ooo`1g0?oo
o`030000003oool0oooo07L0oooo00<0o`000?ooo`3oool0I`3oool003<0oooo00<0o`000?ooo`3o
ool0MP3oool00`000000oooo0?ooo`1f0?ooo`030?l0003oool0oooo06P0oooo000d0?ooo`030?l0
003oool0oooo07D0oooo00<000000?ooo`3oool0M@3oool00`3o0000oooo0?ooo`1Y0?ooo`00=@3o
ool20?l007D0oooo00<000000?ooo`3oool0M03oool00`3o0000oooo0?ooo`1Z0?ooo`00=`3oool0
0`3o0000oooo0?ooo`1b0?ooo`030000003oool0oooo07<0oooo00<0o`000?ooo`3oool0J`3oool0
03P0oooo00<0o`000?ooo`3oool0L@3oool00`000000oooo0?ooo`1b0?ooo`030?l0003oool0oooo
06`0oooo000i0?ooo`030?l0003oool0oooo0700oooo00<000000?ooo`3oool0L03oool20?l006l0
oooo000j0?ooo`030?l0003oool0oooo06l0oooo00<000000?ooo`3oool0K`3oool20?l00700oooo
000k0?ooo`030?l0003oool0oooo06h0oooo00<000000?ooo`3oool0KP3oool20?l00740oooo000l
0?ooo`030?l0003oool0oooo06d0oooo00<000000?ooo`3oool0K03oool20?l007<0oooo000m0?oo
o`030?l0003oool0oooo06`0oooo00<000000?ooo`3oool0J`3oool20?l007@0oooo000n0?ooo`03
0?l0003oool0oooo06/0oooo0P00001[0?ooo`80o`00M@3oool003l0oooo0P3o001[0?ooo`030000
003oool0oooo06T0oooo00<0o`000?ooo`3oool0M@3oool00440oooo00<0o`000?ooo`3oool0J03o
ool00`000000oooo0?ooo`1W0?ooo`80o`00N03oool00480oooo0P3o001X0?ooo`030000003oool0
oooo06H0oooo0P3o001i0?ooo`00A03oool00`3o0000oooo0?ooo`1U0?ooo`030000003oool0oooo
06D0oooo00<0o`000?ooo`3oool0N@3oool004D0oooo0P3o001U0?ooo`030000003oool0oooo06<0
oooo0P3o001l0?ooo`00A`3oool00`3o0000oooo0?ooo`1R0?ooo`030000003oool0oooo0680oooo
00<0o`000?ooo`3oool0O03oool004P0oooo0P3o001R0?ooo`030000003oool0oooo0640oooo00<0
o`000?ooo`3oool0O@3oool004X0oooo00<0o`000?ooo`3oool0G`3oool00`000000oooo0?ooo`1O
0?ooo`80o`00P03oool004/0oooo0P3o001O0?ooo`030000003oool0oooo05d0oooo0P3o00220?oo
o`00C@3oool00`3o0000oooo0?ooo`1L0?ooo`030000003oool0oooo05`0oooo0P3o00230?ooo`00
CP3oool20?l005`0oooo00<000000?ooo`3oool0FP3oool20?l008D0oooo001@0?ooo`030?l0003o
ool0oooo05T0oooo0P00001I0?ooo`<0o`00QP3oool00540oooo0P3o001I0?ooo`030000003oool0
oooo05L0oooo0P3o00280?ooo`00D`3oool20?l005L0oooo00<000000?ooo`3oool0E@3oool20?l0
08X0oooo001E0?ooo`80o`00E@3oool00`000000oooo0?ooo`1C0?ooo`<0o`00R`3oool005L0oooo
0P3o001C0?ooo`030000003oool0oooo0540oooo0`3o002=0?ooo`00F@3oool00`3o0000oooo0?oo
o`1@0?ooo`030000003oool0oooo0500oooo0P3o002?0?ooo`00FP3oool20?l00500oooo00<00000
0?ooo`3oool0CP3oool20?l00940oooo001L0?ooo`80o`00CP3oool00`000000oooo0?ooo`1<0?oo
o`80o`00T`3oool005h0oooo0P3o001<0?ooo`030000003oool0oooo04X0oooo0P3o002E0?ooo`00
H03oool20?l004X0oooo00<000000?ooo`3oool0A`3oool30?l009L0oooo001R0?ooo`80o`00B03o
ool00`000000oooo0?ooo`150?ooo`<0o`00V@3oool006@0oooo0P3o00160?ooo`030000003oool0
oooo0480oooo0`3o002L0?ooo`00IP3oool30?l004<0oooo0P0000100?ooo`<0o`00W`3oool006T0
oooo103o000o0?ooo`030000003oool0oooo03d0oooo0`3o002Q0?ooo`00K@3oool30?l003`0oooo
00<000000?ooo`3oool0>P3oool30?l00:@0oooo001`0?ooo`<0o`00>@3oool00`000000oooo0?oo
o`0g0?ooo`@0o`00YP3oool007<0oooo0`3o000f0?ooo`030000003oool0oooo03<0oooo1@3o002Y
0?ooo`00MP3oool30?l002@0oooo1P0000090?ooo`030000003oool0oooo0300oooo1P3o002[0?oo
o`00N@3oool30?l002<0oooo0P00000;0?ooo`030000003oool0oooo02`0oooo1P3o002_0?ooo`00
O03oool40?l001l0oooo0P00000;0?ooo`030000003oool0oooo02P0oooo1P3o002c0?ooo`00P03o
ool40?l001/0oooo0P00000;0?ooo`030000003oool0oooo02@0oooo1P3o002g0?ooo`00Q03oool4
0?l001L0oooo0P00000;0?ooo`030000003oool0oooo01l0oooo1P3o002l0?ooo`00R03oool50?l0
0180oooo0P00000;0?ooo`030000003oool0oooo01P0oooo1`3o00320?ooo`00S@3oool70?l000/0
oooo0P00000;0?ooo`030000003oool0oooo0140oooo203o00380?ooo`00U03oool>0?l000X0oooo
00<000000?ooo`3oool01`3oool<0?l00<h0oooo002O0?ooo`80000000<0oooo0?l0003o00004`3o
003I0?ooo`00W`3oool2000000/0oooo00<000000?ooo`3oool0h@3oool009l0oooo0P00000;0?oo
o`030000003oool0oooo0>40oooo002O0?ooo`8000002`3oool00`000000oooo0?ooo`3Q0?ooo`00
W`3oool2000000/0oooo00<000000?ooo`3oool0h@3oool009l0oooo0P00000;0?ooo`030000003o
ool0oooo0>40oooo002O0?ooo`8000002`3oool00`000000oooo0?ooo`3Q0?ooo`00W03oool50000
0>l0oooo002N0?ooo`<00000k`3oool00?l0ooooT@3oool00?l0ooooT@3oool00?l0ooooT@3oool0
0?l0ooooT@3oool00?l0ooooT@3oool00?l0ooooT@3oool00?l0ooooT@3oool00?l0ooooT@3oool0
0?l0ooooT@3oool00:h0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`3?0?ooo`00
[@3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0<h0oooo002/0?ooo`030000003o
ool0oooo0140oooo00<000000?ooo`3oool0c@3oool00:/0oooo00<000000?ooo`3oool04`3oool0
0`000000oooo0?ooo`3<0?ooo`00T`3oool600000080oooo2P0000050?ooo`800000103oool40000
00@0oooo1@0000040?ooo`800000c@3oool009D0oooo0P0000050?ooo`T000001@3oool2000000D0
oooo0P0000060?ooo`8000001P3oool200000<d0oooo002E0?ooo`8000001P3oool00`000000oooo
0?ooo`040?ooo`800000103oool00`000000oooo0?ooo`050?ooo`030000003oool0oooo00<0oooo
0P0000080?ooo`030000003oool0oooo0</0oooo002E0?ooo`8000001`3oool00`000000oooo0?oo
o`080?ooo`800000203oool010000000oooo0?ooo`3oool3000000P0oooo0P00003<0?ooo`00U@3o
ool2000000P0oooo00<000000?ooo`3oool01`3oool2000000T0oooo00<000000?ooo`3oool00P00
00090?ooo`800000c03oool009D0oooo0P0000090?ooo`030000003oool0oooo00H0oooo0P00000:
0?ooo`<000002P3oool200000<`0oooo002E0?ooo`8000002P3oool00`000000oooo0?ooo`050?oo
o`8000002P3oool2000000/0oooo0P00003<0?ooo`00U@3oool2000000X0oooo00<000000?ooo`3o
ool01@3oool2000000T0oooo1000000:0?ooo`800000c03oool009D0oooo0P00000;0?ooo`030000
003oool0oooo00@0oooo0P0000080?ooo`<0000000<0oooo0000003oool02@3oool200000<`0oooo
002E0?ooo`800000303oool00`000000oooo0?ooo`030?ooo`800000203oool2000000<0oooo00<0
00000?ooo`3oool01`3oool200000<`0oooo002E0?ooo`800000303oool00`000000oooo0?ooo`03
0?ooo`8000001`3oool2000000D0oooo00<000000?ooo`3oool01P3oool200000<`0oooo002C0?oo
o`L000002@3oool2000000D0oooo00<000000?ooo`3oool00`3oool5000000<0oooo100000060?oo
o`030000003oool0oooo0</0oooo002E0?ooo`800000103oool00`000000oooo0?ooo`050?ooo`80
00001@3oool2000001D0oooo0P00003=0?ooo`00U@3oool2000000@0oooo00<000000?ooo`3oool0
1@3oool2000000D0oooo0P00000E0?ooo`800000c@3oool009D0oooo0P0000050?ooo`030000003o
ool0oooo0080oooo100000060?ooo`030000003oool0oooo01<0oooo00<000000?ooo`3oool0c03o
ool009H0oooo00<000000?ooo`3oool00P3oool9000000P0oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`3=0?ooo`00UP3oool200000080oooo0`0000000`3oool00000000000020000
00/0oooo00<000000?ooo`3oool03`3oool00`000000oooo0?ooo`3>0?ooo`00V03oool400000180
oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`3?0?ooo`00o`3ooonA0?ooo`00o`3o
oonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3o
oonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00\
\>"],
  ImageRangeCache->{{{0, 399}, {319, 0}} -> {-1.11409, -1.16628, 0.00646121, \
0.00807651}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  Graphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<G:\Robert\Vorlesungen\Variationsrechnung\Pr\[ADoubleDot]\
sentation\Param.png\>", param, \ ImageSize \[Rule] 400]\)], "Input"],

Cell[BoxData[
    \("G:\\Robert\\Vorlesungen\\Variationsrechnung\\Pr\[ADoubleDot]sentation\\\
Param.png"\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Options[ParametricPlot]\)], "Input"],

Cell[BoxData[
    \({AspectRatio \[Rule] 1\/GoldenRatio, Axes \[Rule] Automatic, 
      AxesLabel \[Rule] None, AxesOrigin \[Rule] Automatic, 
      AxesStyle \[Rule] Automatic, Background \[Rule] Automatic, 
      ColorOutput \[Rule] Automatic, Compiled \[Rule] True, 
      DefaultColor \[Rule] Automatic, 
      DefaultFont \[RuleDelayed] $DefaultFont, 
      DisplayFunction \[RuleDelayed] $DisplayFunction, Epilog \[Rule] {}, 
      FormatType \[RuleDelayed] $FormatType, Frame \[Rule] False, 
      FrameLabel \[Rule] None, FrameStyle \[Rule] Automatic, 
      FrameTicks \[Rule] Automatic, GridLines \[Rule] None, 
      ImageSize \[Rule] Automatic, MaxBend \[Rule] 10.`, 
      PlotDivision \[Rule] 30.`, PlotLabel \[Rule] None, 
      PlotPoints \[Rule] 25, PlotRange \[Rule] Automatic, 
      PlotRegion \[Rule] Automatic, PlotStyle \[Rule] Automatic, 
      Prolog \[Rule] {}, RotateLabel \[Rule] True, 
      TextStyle \[RuleDelayed] $TextStyle, 
      Ticks \[Rule] Automatic}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(zweidvar = 
      Plot3D[Sin[x]*y^2, {x, \(-1\), 1}, {y, \(-1\), 1}, 
        ImageSize \[Rule] 400, \ AspectRatio \[Rule] 0.8, 
        TextStyle \[Rule] {FontFamily \[Rule] "\<Times\>", 
            FontSize \[Rule] fontSize}]\)], "Input"],

Cell[GraphicsData["PostScript", "\<\
%!
%%Creator: Mathematica
%%AspectRatio: .8 
%%ImageSize: 400 320 
MathPictureStart
/Mabs {
Mgmatrix idtransform
Mtmatrix dtransform
} bind def
/Mabsadd { Mabs
3 -1 roll add
3 1 roll add
exch } bind def
%% SurfaceGraphics
%%IncludeResource: font Courier
%%IncludeFont: Courier
/Courier findfont 10  scalefont  setfont
% Scaling calculations
3.1984e-017 1.04977 -0.0670257 1.03536 [
[.02757 .2428 -35.3125 -30.7014 ]
[.02757 .2428 0 1.04861 ]
[.17646 .18501 -53.9553 -31.75 ]
[.17646 .18501 .91971 0 ]
[.3345 .12369 -15.8872 -31.75 ]
[.3345 .12369 1.17532 0 ]
[.50253 .05854 -32.1932 -31.75 ]
[.50253 .05854 4.43185 0 ]
[.68156 -0.01083 -14.1085 -31.75 ]
[.68156 -0.01083 2.95402 0 ]
[.70096 -0.00472 0 -22.0912 ]
[.70096 -0.00472 35.3125 9.65884 ]
[.78313 .11938 0 -21.6555 ]
[.78313 .11938 54.875 10.0945 ]
[.8565 .23018 0 -21.277 ]
[.8565 .23018 17.0625 10.473 ]
[.9224 .32972 0 -20.945 ]
[.9224 .32972 36.625 10.8051 ]
[.98191 .41962 0 -20.6514 ]
[.98191 .41962 17.0625 11.0986 ]
[.01729 .30363 -54.875 -9.80175 ]
[.01729 .30363 0 21.9483 ]
[.00696 .36752 -17.0625 -9.99558 ]
[.00696 .36752 0 21.7544 ]
[-0.00382 .43412 -36.625 -10.1985 ]
[-0.00382 .43412 0 21.5515 ]
[ 0 0 0 0 ]
[ 1 .8 0 0 ]
] MathScale
% Start of Graphics
1 setlinecap
1 setlinejoin
newpath
0 g
.25 Mabswid
[ ] 0 setdash
.03716 .25163 m
.68874 0 L
s
.03716 .25163 m
.04196 .25605 L
s
gsave
.02757 .2428 -96.3125 -34.7014 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.18558 .19431 m
.19014 .19897 L
s
gsave
.17646 .18501 -114.955 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.34306 .1335 m
.34735 .1384 L
s
gsave
.3345 .12369 -76.8872 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0) show
1.000 setlinewidth
grestore
.51046 .06885 m
.51442 .07401 L
s
gsave
.50253 .05854 -93.1932 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.68874 0 m
.69233 .00542 L
s
gsave
.68156 -0.01083 -75.1085 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.125 Mabswid
.06616 .24044 m
.06901 .24311 L
s
.09549 .22911 m
.09832 .23181 L
s
.12517 .21765 m
.12797 .22038 L
s
.1552 .20605 m
.15797 .20881 L
s
.21633 .18244 m
.21903 .18526 L
s
.24744 .17042 m
.25012 .17328 L
s
.27893 .15826 m
.28157 .16114 L
s
.3108 .14595 m
.31341 .14887 L
s
.37572 .12088 m
.37826 .12386 L
s
.40878 .10812 m
.41128 .11112 L
s
.44225 .09519 m
.44471 .09822 L
s
.47614 .0821 m
.47856 .08517 L
s
.54521 .05543 m
.54755 .05855 L
s
.58041 .04184 m
.5827 .04499 L
s
.61605 .02807 m
.6183 .03126 L
s
.65216 .01413 m
.65436 .01734 L
s
.25 Mabswid
.68874 0 m
.96935 .42335 L
s
.68874 0 m
.68263 .00236 L
s
gsave
.70096 -0.00472 -61 -26.0912 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.7708 .12381 m
.76464 .12602 L
s
gsave
.78313 .11938 -61 -25.6555 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.84407 .23435 m
.83786 .23644 L
s
gsave
.8565 .23018 -61 -25.277 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0) show
1.000 setlinewidth
grestore
.9099 .33365 m
.90365 .33562 L
s
gsave
.9224 .32972 -61 -24.945 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.96935 .42335 m
.96306 .42521 L
s
gsave
.98191 .41962 -61 -24.6514 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.125 Mabswid
.70593 .02594 m
.70226 .02733 L
s
.72272 .05126 m
.71904 .05264 L
s
.73912 .07601 m
.73543 .07737 L
s
.75514 .10018 m
.75145 .10153 L
s
.78611 .14691 m
.78241 .14822 L
s
.80108 .16949 m
.79737 .17079 L
s
.81573 .19159 m
.81201 .19287 L
s
.83006 .2132 m
.82633 .21447 L
s
.8578 .25505 m
.85407 .25629 L
s
.87123 .27532 m
.8675 .27654 L
s
.88439 .29517 m
.88065 .29638 L
s
.89727 .31461 m
.89353 .3158 L
s
.92227 .35231 m
.91851 .35348 L
s
.93439 .3706 m
.93063 .37176 L
s
.94627 .38853 m
.94251 .38967 L
s
.95792 .40611 m
.95416 .40724 L
s
.25 Mabswid
.03716 .25163 m
0 .48291 L
s
.02955 .29901 m
.03568 .29669 L
s
gsave
.01729 .30363 -115.875 -13.8018 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.01926 .36303 m
.02541 .36078 L
s
gsave
.00696 .36752 -78.0625 -13.9956 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0) show
1.000 setlinewidth
grestore
.00854 .42976 m
.01472 .42758 L
s
gsave
-0.00382 .43412 -97.625 -14.1985 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.125 Mabswid
.02752 .3116 m
.0312 .31022 L
s
.02548 .3243 m
.02917 .32293 L
s
.02343 .3371 m
.02711 .33574 L
s
.02135 .35001 m
.02504 .34865 L
s
.01715 .37615 m
.02085 .37481 L
s
.01503 .38939 m
.01872 .38805 L
s
.01288 .40273 m
.01658 .40141 L
s
.01072 .41619 m
.01442 .41488 L
s
.03156 .28651 m
.03523 .28512 L
s
.03355 .27412 m
.03722 .27272 L
s
.03552 .26183 m
.03919 .26042 L
s
.00634 .44345 m
.01005 .44215 L
s
.00412 .45726 m
.00783 .45597 L
s
.00188 .47118 m
.0056 .4699 L
s
.25 Mabswid
.03716 .25163 m
0 .48291 L
s
0 .48291 m
.39787 .8 L
s
.39787 .8 m
.40529 .59073 L
s
.40529 .59073 m
.03716 .25163 L
s
.68874 0 m
.96935 .42335 L
s
.96935 .42335 m
1 .64453 L
s
1 .64453 m
.70298 .24207 L
s
.70298 .24207 m
.68874 0 L
s
.03716 .25163 m
0 .48291 L
s
0 .48291 m
.70298 .24207 L
s
.70298 .24207 m
.68874 0 L
s
.68874 0 m
.03716 .25163 L
s
.40529 .59073 m
.96935 .42335 L
s
.96935 .42335 m
1 .64453 L
s
1 .64453 m
.39787 .8 L
s
.39787 .8 m
.40529 .59073 L
s
0 0 m
1 0 L
1 .8 L
0 .8 L
closepath
clip
newpath
.5 Mabswid
.09 0 0 r
.39176 .59886 .40512 .59542 .42635 .59447 .4132 .59704 Metetra
.074 0 0 r
.4132 .59704 .42635 .59447 .4478 .59413 .43485 .59574 Metetra
.048 0 0 r
.43485 .59574 .4478 .59413 .4695 .59437 .45674 .59491 Metetra
.01 0 0 r
.45674 .59491 .4695 .59437 .49145 .59516 .47887 .59454 Metetra
.039 .608 .754 r
.47887 .59454 .49145 .59516 .51367 .59644 .50127 .59458 Metetra
.097 .646 .827 r
.50127 .59458 .51367 .59644 .53618 .59819 .52394 .595 Metetra
.162 .678 .891 r
.52394 .595 .53618 .59819 .55899 .60035 .54689 .59576 Metetra
.229 .7 .941 r
.54689 .59576 .55899 .60035 .58211 .60287 .57014 .5968 Metetra
.291 .711 .972 r
.57014 .5968 .58211 .60287 .60556 .6057 .5937 .59809 Metetra
.347 .71 .985 r
.5937 .59809 .60556 .6057 .62935 .60877 .61758 .59956 Metetra
.394 .701 .983 r
.61758 .59956 .62935 .60877 .65348 .61202 .64179 .60117 Metetra
.432 .688 .972 r
.64179 .60117 .65348 .61202 .67796 .61539 .66632 .60287 Metetra
.462 .672 .954 r
.66632 .60287 .67796 .61539 .7028 .61881 .6912 .60459 Metetra
.487 .655 .934 r
.6912 .60459 .7028 .61881 .72801 .62221 .71642 .60627 Metetra
.507 .64 .914 r
.71642 .60627 .72801 .62221 .75358 .62552 .74198 .60785 Metetra
.523 .625 .894 r
.74198 .60785 .75358 .62552 .77951 .62866 .76788 .60928 Metetra
.536 .613 .876 r
.76788 .60928 .77951 .62866 .8058 .63156 .79413 .61048 Metetra
.548 .601 .859 r
.79413 .61048 .8058 .63156 .83244 .63414 .82071 .6114 Metetra
.558 .592 .844 r
.82071 .6114 .83244 .63414 .85944 .63633 .84763 .61197 Metetra
.566 .584 .831 r
.84763 .61197 .85944 .63633 .88677 .63805 .87487 .61214 Metetra
.574 .577 .819 r
.87487 .61214 .88677 .63805 .91443 .63924 .90243 .61183 Metetra
.581 .572 .808 r
.90243 .61183 .91443 .63924 .9424 .63982 .9303 .611 Metetra
.588 .568 .799 r
.9303 .611 .9424 .63982 .97067 .63973 .95845 .60959 Metetra
.594 .565 .791 r
.95845 .60959 .97067 .63973 .99922 .63891 .98689 .60755 Metetra
.37814 .60103 .39176 .59886 .4132 .59704 .39978 .59841 Metetra
.39978 .59841 .4132 .59704 .43485 .59574 .42164 .59619 Metetra
.102 .658 .755 r
.42164 .59619 .43485 .59574 .45674 .59491 .44372 .59437 Metetra
.141 .685 .81 r
.44372 .59437 .45674 .59491 .47887 .59454 .46604 .59291 Metetra
.187 .711 .865 r
.46604 .59291 .47887 .59454 .50127 .59458 .48861 .59178 Metetra
.238 .732 .914 r
.48861 .59178 .50127 .59458 .52394 .595 .51144 .59096 Metetra
.29 .747 .953 r
.51144 .59096 .52394 .595 .54689 .59576 .53455 .5904 Metetra
.339 .753 .979 r
.53455 .5904 .54689 .59576 .57014 .5968 .55794 .59006 Metetra
.384 .75 .992 r
.55794 .59006 .57014 .5968 .5937 .59809 .58162 .58992 Metetra
.423 .74 .992 r
.58162 .58992 .5937 .59809 .61758 .59956 .6056 .58991 Metetra
.456 .726 .984 r
.6056 .58991 .61758 .59956 .64179 .60117 .62989 .59 Metetra
.482 .709 .97 r
.62989 .59 .64179 .60117 .66632 .60287 .6545 .59014 Metetra
.504 .691 .952 r
.6545 .59014 .66632 .60287 .6912 .60459 .67942 .59029 Metetra
.521 .674 .933 r
.67942 .59029 .6912 .60459 .71642 .60627 .70467 .59038 Metetra
.536 .658 .914 r
.70467 .59038 .71642 .60627 .74198 .60785 .73025 .59038 Metetra
.547 .643 .896 r
.73025 .59038 .74198 .60785 .76788 .60928 .75615 .59023 Metetra
.557 .63 .879 r
.75615 .59023 .76788 .60928 .79413 .61048 .78237 .58987 Metetra
.566 .618 .863 r
.78237 .58987 .79413 .61048 .82071 .6114 .80892 .58926 Metetra
.574 .608 .849 r
.80892 .58926 .82071 .6114 .84763 .61197 .83579 .58835 Metetra
.58 .6 .837 r
.83579 .58835 .84763 .61197 .87487 .61214 .86297 .58708 Metetra
.586 .592 .825 r
.86297 .58708 .87487 .61214 .90243 .61183 .89046 .58541 Metetra
.592 .587 .815 r
.89046 .58541 .90243 .61183 .9303 .611 .91825 .58329 Metetra
.597 .582 .806 r
.91825 .58329 .9303 .611 .95845 .60959 .94633 .58068 Metetra
.602 .578 .799 r
.94633 .58068 .95845 .60959 .98689 .60755 .97468 .57752 Metetra
.196 .726 .795 r
.36426 .60191 .37814 .60103 .39978 .59841 .38611 .59852 Metetra
.218 .74 .83 r
.38611 .59852 .39978 .59841 .42164 .59619 .40816 .59545 Metetra
.246 .755 .868 r
.40816 .59545 .42164 .59619 .44372 .59437 .43044 .5927 Metetra
.279 .77 .905 r
.43044 .5927 .44372 .59437 .46604 .59291 .45295 .59023 Metetra
.316 .781 .94 r
.45295 .59023 .46604 .59291 .48861 .59178 .4757 .58802 Metetra
.355 .788 .967 r
.4757 .58802 .48861 .59178 .51144 .59096 .4987 .58604 Metetra
.392 .789 .986 r
.4987 .58604 .51144 .59096 .53455 .5904 .52196 .58426 Metetra
.426 .784 .996 r
.52196 .58426 .53455 .5904 .55794 .59006 .54549 .58265 Metetra
.457 .773 .997 r
.54549 .58265 .55794 .59006 .58162 .58992 .5693 .58118 Metetra
.483 .759 .991 r
.5693 .58118 .58162 .58992 .6056 .58991 .5934 .57981 Metetra
.505 .742 .98 r
.5934 .57981 .6056 .58991 .62989 .59 .61779 .5785 Metetra
.523 .724 .965 r
.61779 .5785 .62989 .59 .6545 .59014 .64248 .57721 Metetra
.538 .706 .948 r
.64248 .57721 .6545 .59014 .67942 .59029 .66747 .57591 Metetra
.55 .689 .931 r
.66747 .57591 .67942 .59029 .70467 .59038 .69277 .57455 Metetra
.561 .673 .914 r
.69277 .57455 .70467 .59038 .73025 .59038 .71838 .5731 Metetra
.569 .659 .897 r
.71838 .5731 .73025 .59038 .75615 .59023 .7443 .5715 Metetra
.576 .646 .882 r
.7443 .5715 .75615 .59023 .78237 .58987 .77053 .56972 Metetra
.583 .634 .868 r
.77053 .56972 .78237 .58987 .80892 .58926 .79707 .56772 Metetra
.588 .624 .855 r
.79707 .56772 .80892 .58926 .83579 .58835 .82391 .56546 Metetra
.593 .615 .843 r
.82391 .56546 .83579 .58835 .86297 .58708 .85106 .56289 Metetra
.598 .607 .832 r
.85106 .56289 .86297 .58708 .89046 .58541 .87851 .55997 Metetra
.602 .601 .823 r
.87851 .55997 .89046 .58541 .91825 .58329 .90625 .55668 Metetra
.606 .596 .814 r
.90625 .55668 .91825 .58329 .94633 .58068 .93428 .55296 Metetra
.61 .592 .807 r
.93428 .55296 .94633 .58068 .97468 .57752 .96258 .5488 Metetra
.328 .807 .897 r
.35013 .60143 .36426 .60191 .38611 .59852 .37218 .59733 Metetra
.346 .813 .92 r
.37218 .59733 .38611 .59852 .40816 .59545 .39443 .59348 Metetra
.368 .818 .942 r
.39443 .59348 .40816 .59545 .43044 .5927 .4169 .58987 Metetra
.393 .821 .964 r
.4169 .58987 .43044 .5927 .45295 .59023 .4396 .58646 Metetra
.419 .821 .981 r
.4396 .58646 .45295 .59023 .4757 .58802 .46253 .58325 Metetra
.446 .818 .993 r
.46253 .58325 .4757 .58802 .4987 .58604 .4857 .58021 Metetra
.47 .811 .999 r
.4857 .58021 .4987 .58604 .52196 .58426 .50913 .57732 Metetra
.493 .8 .999 r
.50913 .57732 .52196 .58426 .54549 .58265 .53281 .57454 Metetra
.513 .786 .994 r
.53281 .57454 .54549 .58265 .5693 .58118 .55676 .57186 Metetra
.53 .77 .985 r
.55676 .57186 .5693 .58118 .5934 .57981 .58098 .56924 Metetra
.545 .753 .973 r
.58098 .56924 .5934 .57981 .61779 .5785 .60548 .56665 Metetra
.557 .735 .959 r
.60548 .56665 .61779 .5785 .64248 .57721 .63027 .56407 Metetra
.567 .718 .944 r
.63027 .56407 .64248 .57721 .66747 .57591 .65534 .56145 Metetra
.575 .702 .928 r
.65534 .56145 .66747 .57591 .69277 .57455 .68071 .55877 Metetra
.582 .687 .913 r
.68071 .55877 .69277 .57455 .71838 .5731 .70637 .556 Metetra
.588 .673 .899 r
.70637 .556 .71838 .5731 .7443 .5715 .73233 .5531 Metetra
.593 .66 .885 r
.73233 .5531 .7443 .5715 .77053 .56972 .75859 .55003 Metetra
.598 .649 .872 r
.75859 .55003 .77053 .56972 .79707 .56772 .78514 .54677 Metetra
.602 .639 .86 r
.78514 .54677 .79707 .56772 .82391 .56546 .81199 .54328 Metetra
.605 .63 .849 r
.81199 .54328 .82391 .56546 .85106 .56289 .83913 .53953 Metetra
.609 .622 .839 r
.83913 .53953 .85106 .56289 .87851 .55997 .86656 .5355 Metetra
.612 .616 .831 r
.86656 .5355 .87851 .55997 .90625 .55668 .89429 .53114 Metetra
.615 .61 .823 r
.89429 .53114 .90625 .55668 .93428 .55296 .92229 .52643 Metetra
.618 .606 .816 r
.92229 .52643 .93428 .55296 .96258 .5488 .95057 .52135 Metetra
.435 .852 .959 r
.33576 .59955 .35013 .60143 .37218 .59733 .35801 .59481 Metetra
.448 .851 .971 r
.35801 .59481 .37218 .59733 .39443 .59348 .38046 .59024 Metetra
.463 .848 .982 r
.38046 .59024 .39443 .59348 .4169 .58987 .40312 .58584 Metetra
.48 .844 .991 r
.40312 .58584 .4169 .58987 .4396 .58646 .426 .58159 Metetra
.496 .838 .997 r
.426 .58159 .4396 .58646 .46253 .58325 .44911 .57747 Metetra
.513 .83 1 r
.44911 .57747 .46253 .58325 .4857 .58021 .47246 .57347 Metetra
.529 .818 .999 r
.47246 .57347 .4857 .58021 .50913 .57732 .49605 .56956 Metetra
.543 .805 .994 r
.49605 .56956 .50913 .57732 .53281 .57454 .51989 .56573 Metetra
.555 .791 .987 r
.51989 .56573 .53281 .57454 .55676 .57186 .54398 .56195 Metetra
.566 .775 .977 r
.54398 .56195 .55676 .57186 .58098 .56924 .56834 .5582 Metetra
.576 .759 .965 r
.56834 .5582 .58098 .56924 .60548 .56665 .59296 .55446 Metetra
.583 .743 .952 r
.59296 .55446 .60548 .56665 .63027 .56407 .61786 .55071 Metetra
.59 .728 .939 r
.61786 .55071 .63027 .56407 .65534 .56145 .64303 .54691 Metetra
.596 .713 .926 r
.64303 .54691 .65534 .56145 .68071 .55877 .66848 .54304 Metetra
.6 .699 .912 r
.66848 .54304 .68071 .55877 .70637 .556 .69421 .53909 Metetra
.604 .686 .9 r
.69421 .53909 .70637 .556 .73233 .5531 .72023 .53501 Metetra
.608 .674 .888 r
.72023 .53501 .73233 .5531 .75859 .55003 .74653 .53079 Metetra
.611 .663 .876 r
.74653 .53079 .75859 .55003 .78514 .54677 .77312 .5264 Metetra
.614 .654 .866 r
.77312 .5264 .78514 .54677 .81199 .54328 .8 .52182 Metetra
.616 .645 .856 r
.8 .52182 .81199 .54328 .83913 .53953 .82716 .51702 Metetra
.619 .637 .847 r
.82716 .51702 .83913 .53953 .86656 .5355 .85461 .51197 Metetra
.621 .631 .839 r
.85461 .51197 .86656 .5355 .89429 .53114 .88234 .50666 Metetra
.623 .625 .832 r
.88234 .50666 .89429 .53114 .92229 .52643 .91035 .50107 Metetra
.625 .621 .826 r
.91035 .50107 .92229 .52643 .95057 .52135 .93864 .49517 Metetra
.514 .867 .989 r
.32116 .59624 .33576 .59955 .35801 .59481 .3436 .59091 Metetra
.523 .862 .993 r
.3436 .59091 .35801 .59481 .38046 .59024 .36624 .58569 Metetra
.532 .856 .997 r
.36624 .58569 .38046 .59024 .40312 .58584 .38909 .58059 Metetra
.542 .849 .998 r
.38909 .58059 .40312 .58584 .426 .58159 .41216 .57557 Metetra
.552 .84 .998 r
.41216 .57557 .426 .58159 .44911 .57747 .43545 .57064 Metetra
.562 .83 .996 r
.43545 .57064 .44911 .57747 .47246 .57347 .45897 .56578 Metetra
.571 .818 .991 r
.45897 .56578 .47246 .57347 .49605 .56956 .48273 .56096 Metetra
.58 .805 .985 r
.48273 .56096 .49605 .56956 .51989 .56573 .50673 .55619 Metetra
.587 .791 .977 r
.50673 .55619 .51989 .56573 .54398 .56195 .53097 .55144 Metetra
.594 .777 .968 r
.53097 .55144 .54398 .56195 .56834 .5582 .55547 .54669 Metetra
.6 .763 .957 r
.55547 .54669 .56834 .5582 .59296 .55446 .58022 .54192 Metetra
.605 .749 .946 r
.58022 .54192 .59296 .55446 .61786 .55071 .60524 .53713 Metetra
.609 .735 .935 r
.60524 .53713 .61786 .55071 .64303 .54691 .63052 .53228 Metetra
.613 .722 .923 r
.63052 .53228 .64303 .54691 .66848 .54304 .65606 .52736 Metetra
.616 .709 .912 r
.65606 .52736 .66848 .54304 .69421 .53909 .68189 .52236 Metetra
.618 .698 .901 r
.68189 .52236 .69421 .53909 .72023 .53501 .70798 .51724 Metetra
.621 .687 .891 r
.70798 .51724 .72023 .53501 .74653 .53079 .73435 .512 Metetra
.623 .677 .881 r
.73435 .512 .74653 .53079 .77312 .5264 .761 .50661 Metetra
.624 .668 .871 r
.761 .50661 .77312 .5264 .8 .52182 .78793 .50106 Metetra
.626 .66 .863 r
.78793 .50106 .8 .52182 .82716 .51702 .81514 .49533 Metetra
.628 .652 .855 r
.81514 .49533 .82716 .51702 .85461 .51197 .84263 .48939 Metetra
.629 .646 .848 r
.84263 .48939 .85461 .51197 .88234 .50666 .8704 .48324 Metetra
.631 .641 .842 r
.8704 .48324 .88234 .50666 .91035 .50107 .89844 .47686 Metetra
.632 .636 .836 r
.89844 .47686 .91035 .50107 .93864 .49517 .92676 .47022 Metetra
.57 .864 .996 r
.30635 .59144 .32116 .59624 .3436 .59091 .32897 .58559 Metetra
.574 .857 .996 r
.32897 .58559 .3436 .59091 .36624 .58569 .3518 .57981 Metetra
.579 .85 .995 r
.3518 .57981 .36624 .58569 .38909 .58059 .37483 .57407 Metetra
.585 .842 .993 r
.37483 .57407 .38909 .58059 .41216 .57557 .39808 .56839 Metetra
.591 .833 .99 r
.39808 .56839 .41216 .57557 .43545 .57064 .42155 .56274 Metetra
.596 .823 .986 r
.42155 .56274 .43545 .57064 .45897 .56578 .44524 .55712 Metetra
.602 .812 .981 r
.44524 .55712 .45897 .56578 .48273 .56096 .46917 .55151 Metetra
.607 .801 .974 r
.46917 .55151 .48273 .56096 .50673 .55619 .49333 .54591 Metetra
.611 .789 .966 r
.49333 .54591 .50673 .55619 .53097 .55144 .51772 .5403 Metetra
.615 .777 .958 r
.51772 .5403 .53097 .55144 .55547 .54669 .54237 .53468 Metetra
.618 .764 .949 r
.54237 .53468 .55547 .54669 .58022 .54192 .56726 .52902 Metetra
.622 .752 .94 r
.56726 .52902 .58022 .54192 .60524 .53713 .5924 .52332 Metetra
.624 .74 .93 r
.5924 .52332 .60524 .53713 .63052 .53228 .61781 .51756 Metetra
.626 .729 .921 r
.61781 .51756 .63052 .53228 .65606 .52736 .64347 .51172 Metetra
.628 .718 .912 r
.64347 .51172 .65606 .52736 .68189 .52236 .66939 .5058 Metetra
.63 .708 .903 r
.66939 .5058 .68189 .52236 .70798 .51724 .69559 .49979 Metetra
.631 .699 .894 r
.69559 .49979 .70798 .51724 .73435 .512 .72205 .49366 Metetra
.633 .69 .885 r
.72205 .49366 .73435 .512 .761 .50661 .74878 .4874 Metetra
.634 .682 .878 r
.74878 .4874 .761 .50661 .78793 .50106 .77578 .48101 Metetra
.635 .674 .87 r
.77578 .48101 .78793 .50106 .81514 .49533 .80306 .47446 Metetra
.636 .668 .864 r
.80306 .47446 .81514 .49533 .84263 .48939 .83061 .46775 Metetra
.637 .662 .857 r
.83061 .46775 .84263 .48939 .8704 .48324 .85844 .46086 Metetra
.638 .656 .852 r
.85844 .46086 .8704 .48324 .89844 .47686 .88655 .45378 Metetra
.639 .652 .847 r
.88655 .45378 .89844 .47686 .92676 .47022 .91493 .44651 Metetra
.606 .849 .99 r
.29132 .58512 .30635 .59144 .32897 .58559 .31412 .57882 Metetra
.609 .843 .988 r
.31412 .57882 .32897 .58559 .3518 .57981 .33713 .57254 Metetra
.611 .836 .986 r
.33713 .57254 .3518 .57981 .37483 .57407 .36034 .56627 Metetra
.614 .829 .983 r
.36034 .56627 .37483 .57407 .39808 .56839 .38377 .56 Metetra
.617 .821 .979 r
.38377 .56 .39808 .56839 .42155 .56274 .40741 .55374 Metetra
.62 .812 .974 r
.40741 .55374 .42155 .56274 .44524 .55712 .43127 .54747 Metetra
.623 .803 .969 r
.43127 .54747 .44524 .55712 .46917 .55151 .45537 .54118 Metetra
.626 .794 .963 r
.45537 .54118 .46917 .55151 .49333 .54591 .47969 .53488 Metetra
.628 .784 .956 r
.47969 .53488 .49333 .54591 .51772 .5403 .50424 .52854 Metetra
.631 .774 .949 r
.50424 .52854 .51772 .5403 .54237 .53468 .52904 .52217 Metetra
.633 .764 .942 r
.52904 .52217 .54237 .53468 .56726 .52902 .55407 .51575 Metetra
.634 .754 .934 r
.55407 .51575 .56726 .52902 .5924 .52332 .57936 .50928 Metetra
.636 .745 .927 r
.57936 .50928 .5924 .52332 .61781 .51756 .60489 .50274 Metetra
.637 .735 .919 r
.60489 .50274 .61781 .51756 .64347 .51172 .63068 .49612 Metetra
.638 .726 .912 r
.63068 .49612 .64347 .51172 .66939 .5058 .65672 .48943 Metetra
.639 .718 .905 r
.65672 .48943 .66939 .5058 .69559 .49979 .68303 .48264 Metetra
.64 .71 .897 r
.68303 .48264 .69559 .49979 .72205 .49366 .7096 .47576 Metetra
.641 .702 .891 r
.7096 .47576 .72205 .49366 .74878 .4874 .73643 .46876 Metetra
.641 .695 .884 r
.73643 .46876 .74878 .4874 .77578 .48101 .76353 .46165 Metetra
.642 .689 .878 r
.76353 .46165 .77578 .48101 .80306 .47446 .7909 .45441 Metetra
.643 .683 .873 r
.7909 .45441 .80306 .47446 .83061 .46775 .81855 .44703 Metetra
.643 .677 .867 r
.81855 .44703 .83061 .46775 .85844 .46086 .84647 .43951 Metetra
.644 .673 .863 r
.84647 .43951 .85844 .46086 .88655 .45378 .87466 .43184 Metetra
.644 .669 .858 r
.87466 .43184 .88655 .45378 .91493 .44651 .90314 .42401 Metetra
.63 .829 .977 r
.27611 .57725 .29132 .58512 .31412 .57882 .29908 .57057 Metetra
.631 .824 .975 r
.29908 .57057 .31412 .57882 .33713 .57254 .32225 .56387 Metetra
.632 .819 .972 r
.32225 .56387 .33713 .57254 .36034 .56627 .34563 .55714 Metetra
.634 .813 .969 r
.34563 .55714 .36034 .56627 .38377 .56 .36923 .5504 Metetra
.635 .807 .965 r
.36923 .5504 .38377 .56 .40741 .55374 .39304 .54362 Metetra
.637 .8 .961 r
.39304 .54362 .40741 .55374 .43127 .54747 .41707 .53681 Metetra
.638 .793 .957 r
.41707 .53681 .43127 .54747 .45537 .54118 .44132 .52997 Metetra
.639 .785 .952 r
.44132 .52997 .45537 .54118 .47969 .53488 .46581 .52308 Metetra
.641 .778 .947 r
.46581 .52308 .47969 .53488 .50424 .52854 .49052 .51614 Metetra
.642 .77 .941 r
.49052 .51614 .50424 .52854 .52904 .52217 .51547 .50915 Metetra
.643 .763 .936 r
.51547 .50915 .52904 .52217 .55407 .51575 .54066 .5021 Metetra
.644 .755 .93 r
.54066 .5021 .55407 .51575 .57936 .50928 .56609 .49499 Metetra
.645 .748 .924 r
.56609 .49499 .57936 .50928 .60489 .50274 .59176 .48782 Metetra
.646 .74 .918 r
.59176 .48782 .60489 .50274 .63068 .49612 .61769 .48056 Metetra
.646 .733 .913 r
.61769 .48056 .63068 .49612 .65672 .48943 .64387 .47323 Metetra
.647 .727 .907 r
.64387 .47323 .65672 .48943 .68303 .48264 .6703 .46581 Metetra
.647 .72 .902 r
.6703 .46581 .68303 .48264 .7096 .47576 .69699 .4583 Metetra
.647 .714 .896 r
.69699 .4583 .7096 .47576 .73643 .46876 .72395 .4507 Metetra
.648 .708 .891 r
.72395 .4507 .73643 .46876 .76353 .46165 .75117 .44299 Metetra
.648 .703 .887 r
.75117 .44299 .76353 .46165 .7909 .45441 .77866 .43517 Metetra
.648 .698 .882 r
.77866 .43517 .7909 .45441 .81855 .44703 .80642 .42724 Metetra
.649 .693 .878 r
.80642 .42724 .81855 .44703 .84647 .43951 .83445 .4192 Metetra
.649 .689 .874 r
.83445 .4192 .84647 .43951 .87466 .43184 .86276 .41103 Metetra
.649 .686 .871 r
.86276 .41103 .87466 .43184 .90314 .42401 .89135 .40273 Metetra
.644 .807 .961 r
.26071 .56778 .27611 .57725 .29908 .57057 .28384 .56079 Metetra
.644 .803 .959 r
.28384 .56079 .29908 .57057 .32225 .56387 .30717 .55375 Metetra
.645 .8 .957 r
.30717 .55375 .32225 .56387 .34563 .55714 .33071 .54667 Metetra
.646 .795 .954 r
.33071 .54667 .34563 .55714 .36923 .5504 .35447 .53954 Metetra
.646 .791 .952 r
.35447 .53954 .36923 .5504 .39304 .54362 .37844 .53236 Metetra
.647 .786 .948 r
.37844 .53236 .39304 .54362 .41707 .53681 .40263 .52513 Metetra
.648 .781 .945 r
.40263 .52513 .41707 .53681 .44132 .52997 .42705 .51784 Metetra
.648 .776 .942 r
.42705 .51784 .44132 .52997 .46581 .52308 .45169 .51049 Metetra
.649 .771 .938 r
.45169 .51049 .46581 .52308 .49052 .51614 .47656 .50308 Metetra
.65 .766 .934 r
.47656 .50308 .49052 .51614 .51547 .50915 .50167 .49561 Metetra
.65 .76 .93 r
.50167 .49561 .51547 .50915 .54066 .5021 .52701 .48807 Metetra
.651 .755 .926 r
.52701 .48807 .54066 .5021 .56609 .49499 .55259 .48047 Metetra
.651 .75 .922 r
.55259 .48047 .56609 .49499 .59176 .48782 .57841 .47279 Metetra
.651 .745 .918 r
.57841 .47279 .59176 .48782 .61769 .48056 .60449 .46503 Metetra
.652 .739 .914 r
.60449 .46503 .61769 .48056 .64387 .47323 .63081 .4572 Metetra
.652 .735 .91 r
.63081 .4572 .64387 .47323 .6703 .46581 .65739 .44929 Metetra
.652 .73 .906 r
.65739 .44929 .6703 .46581 .69699 .4583 .68422 .44129 Metetra
.652 .725 .902 r
.68422 .44129 .69699 .4583 .72395 .4507 .71132 .4332 Metetra
.652 .721 .899 r
.71132 .4332 .72395 .4507 .75117 .44299 .73868 .42502 Metetra
.653 .717 .895 r
.73868 .42502 .75117 .44299 .77866 .43517 .7663 .41675 Metetra
.653 .713 .892 r
.7663 .41675 .77866 .43517 .80642 .42724 .7942 .40838 Metetra
.653 .71 .889 r
.7942 .40838 .80642 .42724 .83445 .4192 .82237 .39991 Metetra
.653 .707 .887 r
.82237 .39991 .83445 .4192 .86276 .41103 .85083 .39134 Metetra
.653 .704 .884 r
.85083 .39134 .86276 .41103 .89135 .40273 .87956 .38266 Metetra
.652 .784 .945 r
.24515 .55669 .26071 .56778 .28384 .56079 .26842 .54946 Metetra
.652 .782 .943 r
.26842 .54946 .28384 .56079 .30717 .55375 .2919 .54217 Metetra
.652 .78 .942 r
.2919 .54217 .30717 .55375 .33071 .54667 .31559 .53482 Metetra
.652 .778 .94 r
.31559 .53482 .33071 .54667 .35447 .53954 .3395 .52741 Metetra
.653 .775 .938 r
.3395 .52741 .35447 .53954 .37844 .53236 .36363 .51993 Metetra
.653 .772 .936 r
.36363 .51993 .37844 .53236 .40263 .52513 .38797 .51239 Metetra
.653 .77 .934 r
.38797 .51239 .40263 .52513 .42705 .51784 .41254 .50478 Metetra
.654 .767 .932 r
.41254 .50478 .42705 .51784 .45169 .51049 .43734 .4971 Metetra
.654 .764 .93 r
.43734 .4971 .45169 .51049 .47656 .50308 .46236 .48936 Metetra
.654 .76 .928 r
.46236 .48936 .47656 .50308 .50167 .49561 .48762 .48154 Metetra
.654 .757 .925 r
.48762 .48154 .50167 .49561 .52701 .48807 .51312 .47365 Metetra
.654 .754 .923 r
.51312 .47365 .52701 .48807 .55259 .48047 .53886 .46569 Metetra
.655 .751 .921 r
.53886 .46569 .55259 .48047 .57841 .47279 .56484 .45765 Metetra
.655 .748 .918 r
.56484 .45765 .57841 .47279 .60449 .46503 .59107 .44954 Metetra
.655 .745 .916 r
.59107 .44954 .60449 .46503 .63081 .4572 .61755 .44134 Metetra
.655 .742 .914 r
.61755 .44134 .63081 .4572 .65739 .44929 .64428 .43307 Metetra
.655 .739 .911 r
.64428 .43307 .65739 .44929 .68422 .44129 .67127 .42471 Metetra
.655 .736 .909 r
.67127 .42471 .68422 .44129 .71132 .4332 .69852 .41627 Metetra
.655 .733 .907 r
.69852 .41627 .71132 .4332 .73868 .42502 .72604 .40775 Metetra
.655 .731 .905 r
.72604 .40775 .73868 .42502 .7663 .41675 .75383 .39914 Metetra
.655 .728 .903 r
.75383 .39914 .7663 .41675 .7942 .40838 .78189 .39044 Metetra
.655 .726 .901 r
.78189 .39044 .7942 .40838 .82237 .39991 .81023 .38165 Metetra
.655 .724 .9 r
.81023 .38165 .82237 .39991 .85083 .39134 .83884 .37277 Metetra
.655 .722 .898 r
.83884 .37277 .85083 .39134 .87956 .38266 .86775 .36379 Metetra
.655 .762 .928 r
.22944 .54394 .24515 .55669 .26842 .54946 .25284 .53656 Metetra
.655 .761 .928 r
.25284 .53656 .26842 .54946 .2919 .54217 .27646 .5291 Metetra
.655 .761 .927 r
.27646 .5291 .2919 .54217 .31559 .53482 .30029 .52157 Metetra
.655 .76 .927 r
.30029 .52157 .31559 .53482 .3395 .52741 .32433 .51398 Metetra
.655 .759 .926 r
.32433 .51398 .3395 .52741 .36363 .51993 .3486 .50632 Metetra
.655 .758 .925 r
.3486 .50632 .36363 .51993 .38797 .51239 .37309 .49859 Metetra
.655 .757 .925 r
.37309 .49859 .38797 .51239 .41254 .50478 .3978 .49078 Metetra
.656 .756 .924 r
.3978 .49078 .41254 .50478 .43734 .4971 .42275 .48291 Metetra
.656 .756 .923 r
.42275 .48291 .43734 .4971 .46236 .48936 .44792 .47496 Metetra
.656 .755 .923 r
.44792 .47496 .46236 .48936 .48762 .48154 .47334 .46693 Metetra
.656 .753 .922 r
.47334 .46693 .48762 .48154 .51312 .47365 .49899 .45883 Metetra
.656 .752 .921 r
.49899 .45883 .51312 .47365 .53886 .46569 .52489 .45066 Metetra
.656 .751 .92 r
.52489 .45066 .53886 .46569 .56484 .45765 .55103 .4424 Metetra
.656 .75 .919 r
.55103 .4424 .56484 .45765 .59107 .44954 .57742 .43407 Metetra
.656 .749 .919 r
.57742 .43407 .59107 .44954 .61755 .44134 .60407 .42565 Metetra
.656 .748 .918 r
.60407 .42565 .61755 .44134 .64428 .43307 .63097 .41716 Metetra
.656 .747 .917 r
.63097 .41716 .64428 .43307 .67127 .42471 .65813 .40858 Metetra
.656 .746 .916 r
.65813 .40858 .67127 .42471 .69852 .41627 .68556 .39992 Metetra
.656 .745 .916 r
.68556 .39992 .69852 .41627 .72604 .40775 .71325 .39118 Metetra
.656 .745 .915 r
.71325 .39118 .72604 .40775 .75383 .39914 .74122 .38235 Metetra
.656 .744 .914 r
.74122 .38235 .75383 .39914 .78189 .39044 .76946 .37343 Metetra
.656 .743 .914 r
.76946 .37343 .78189 .39044 .81023 .38165 .79799 .36442 Metetra
.656 .742 .913 r
.79799 .36442 .81023 .38165 .83884 .37277 .8268 .35532 Metetra
.656 .742 .913 r
.8268 .35532 .83884 .37277 .86775 .36379 .8559 .34614 Metetra
.655 .741 .913 r
.2136 .52952 .22944 .54394 .25284 .53656 .23712 .52205 Metetra
.655 .741 .913 r
.23712 .52205 .25284 .53656 .27646 .5291 .26085 .51451 Metetra
.655 .742 .914 r
.26085 .51451 .27646 .5291 .30029 .52157 .2848 .50691 Metetra
.655 .743 .914 r
.2848 .50691 .30029 .52157 .32433 .51398 .30897 .49924 Metetra
.655 .743 .915 r
.30897 .49924 .32433 .51398 .3486 .50632 .33336 .49151 Metetra
.655 .744 .915 r
.33336 .49151 .3486 .50632 .37309 .49859 .35799 .4837 Metetra
.655 .745 .916 r
.35799 .4837 .37309 .49859 .3978 .49078 .38284 .47583 Metetra
.655 .746 .917 r
.38284 .47583 .3978 .49078 .42275 .48291 .40792 .46788 Metetra
.655 .747 .918 r
.40792 .46788 .42275 .48291 .44792 .47496 .43325 .45986 Metetra
.655 .748 .918 r
.43325 .45986 .44792 .47496 .47334 .46693 .45881 .45177 Metetra
.655 .749 .919 r
.45881 .45177 .47334 .46693 .49899 .45883 .48462 .4436 Metetra
.655 .75 .92 r
.48462 .4436 .49899 .45883 .52489 .45066 .51067 .43535 Metetra
.655 .751 .921 r
.51067 .43535 .52489 .45066 .55103 .4424 .53697 .42703 Metetra
.655 .752 .921 r
.53697 .42703 .55103 .4424 .57742 .43407 .56354 .41862 Metetra
.655 .753 .922 r
.56354 .41862 .57742 .43407 .60407 .42565 .59035 .41013 Metetra
.655 .754 .923 r
.59035 .41013 .60407 .42565 .63097 .41716 .61743 .40155 Metetra
.654 .755 .924 r
.61743 .40155 .63097 .41716 .65813 .40858 .64478 .39289 Metetra
.654 .756 .924 r
.64478 .39289 .65813 .40858 .68556 .39992 .6724 .38414 Metetra
.654 .757 .925 r
.6724 .38414 .68556 .39992 .71325 .39118 .70029 .3753 Metetra
.654 .758 .926 r
.70029 .3753 .71325 .39118 .74122 .38235 .72846 .36637 Metetra
.654 .759 .926 r
.72846 .36637 .74122 .38235 .76946 .37343 .75691 .35735 Metetra
.655 .76 .927 r
.75691 .35735 .76946 .37343 .79799 .36442 .78564 .34823 Metetra
.655 .76 .927 r
.78564 .34823 .79799 .36442 .8268 .35532 .81467 .33901 Metetra
.655 .761 .928 r
.81467 .33901 .8268 .35532 .8559 .34614 .84399 .3297 Metetra
.653 .721 .898 r
.19765 .51339 .2136 .52952 .23712 .52205 .22126 .50591 Metetra
.653 .722 .899 r
.22126 .50591 .23712 .52205 .26085 .51451 .24509 .49838 Metetra
.653 .724 .901 r
.24509 .49838 .26085 .51451 .2848 .50691 .26915 .4908 Metetra
.652 .726 .903 r
.26915 .4908 .2848 .50691 .30897 .49924 .29343 .48316 Metetra
.652 .728 .905 r
.29343 .48316 .30897 .49924 .33336 .49151 .31794 .47547 Metetra
.652 .73 .906 r
.31794 .47547 .33336 .49151 .35799 .4837 .34268 .46772 Metetra
.652 .733 .909 r
.34268 .46772 .35799 .4837 .38284 .47583 .36765 .4599 Metetra
.652 .735 .911 r
.36765 .4599 .38284 .47583 .40792 .46788 .39287 .45202 Metetra
.651 .738 .913 r
.39287 .45202 .40792 .46788 .43325 .45986 .41833 .44407 Metetra
.651 .741 .915 r
.41833 .44407 .43325 .45986 .45881 .45177 .44403 .43605 Metetra
.651 .744 .917 r
.44403 .43605 .45881 .45177 .48462 .4436 .46999 .42795 Metetra
.651 .747 .92 r
.46999 .42795 .48462 .4436 .51067 .43535 .4962 .41978 Metetra
.651 .75 .922 r
.4962 .41978 .51067 .43535 .53697 .42703 .52267 .41153 Metetra
.651 .753 .924 r
.52267 .41153 .53697 .42703 .56354 .41862 .5494 .40319 Metetra
.651 .756 .927 r
.5494 .40319 .56354 .41862 .59035 .41013 .5764 .39477 Metetra
.651 .759 .929 r
.5764 .39477 .59035 .41013 .61743 .40155 .60367 .38625 Metetra
.651 .762 .931 r
.60367 .38625 .61743 .40155 .64478 .39289 .63121 .37765 Metetra
.65 .765 .933 r
.63121 .37765 .64478 .39289 .6724 .38414 .65903 .36894 Metetra
.65 .768 .935 r
.65903 .36894 .6724 .38414 .70029 .3753 .68713 .36014 Metetra
.65 .771 .937 r
.68713 .36014 .70029 .3753 .72846 .36637 .71552 .35123 Metetra
.65 .774 .939 r
.71552 .35123 .72846 .36637 .75691 .35735 .7442 .34221 Metetra
.65 .776 .94 r
.7442 .34221 .75691 .35735 .78564 .34823 .77317 .33308 Metetra
.65 .779 .942 r
.77317 .33308 .78564 .34823 .81467 .33901 .80243 .32385 Metetra
.65 .781 .943 r
.80243 .32385 .81467 .33901 .84399 .3297 .832 .31449 Metetra
.649 .701 .885 r
.1816 .49555 .19765 .51339 .22126 .50591 .20529 .48814 Metetra
.648 .703 .887 r
.20529 .48814 .22126 .50591 .24509 .49838 .22921 .4807 Metetra
.648 .706 .889 r
.22921 .4807 .24509 .49838 .26915 .4908 .25335 .47324 Metetra
.648 .709 .892 r
.25335 .47324 .26915 .4908 .29343 .48316 .27772 .46574 Metetra
.647 .712 .895 r
.27772 .46574 .29343 .48316 .31794 .47547 .30232 .4582 Metetra
.647 .716 .898 r
.30232 .4582 .31794 .47547 .34268 .46772 .32716 .45061 Metetra
.646 .72 .902 r
.32716 .45061 .34268 .46772 .36765 .4599 .35225 .44298 Metetra
.646 .724 .905 r
.35225 .44298 .36765 .4599 .39287 .45202 .37758 .4353 Metetra
.646 .728 .909 r
.37758 .4353 .39287 .45202 .41833 .44407 .40317 .42756 Metetra
.646 .733 .913 r
.40317 .42756 .41833 .44407 .44403 .43605 .42901 .41975 Metetra
.645 .738 .916 r
.42901 .41975 .44403 .43605 .46999 .42795 .45511 .41188 Metetra
.645 .743 .92 r
.45511 .41188 .46999 .42795 .4962 .41978 .48147 .40393 Metetra
.645 .748 .924 r
.48147 .40393 .4962 .41978 .52267 .41153 .5081 .3959 Metetra
.645 .753 .928 r
.5081 .3959 .52267 .41153 .5494 .40319 .53501 .38778 Metetra
.644 .758 .932 r
.53501 .38778 .5494 .40319 .5764 .39477 .56219 .37957 Metetra
.644 .763 .935 r
.56219 .37957 .5764 .39477 .60367 .38625 .58966 .37126 Metetra
.644 .768 .939 r
.58966 .37126 .60367 .38625 .63121 .37765 .6174 .36285 Metetra
.643 .774 .942 r
.6174 .36285 .63121 .37765 .65903 .36894 .64544 .35432 Metetra
.643 .779 .946 r
.64544 .35432 .65903 .36894 .68713 .36014 .67377 .34568 Metetra
.643 .783 .949 r
.67377 .34568 .68713 .36014 .71552 .35123 .70239 .33691 Metetra
.643 .788 .952 r
.70239 .33691 .71552 .35123 .7442 .34221 .73132 .32802 Metetra
.643 .792 .954 r
.73132 .32802 .7442 .34221 .77317 .33308 .76054 .319 Metetra
.643 .797 .956 r
.76054 .319 .77317 .33308 .80243 .32385 .79008 .30983 Metetra
.643 .8 .959 r
.79008 .30983 .80243 .32385 .832 .31449 .81992 .30053 Metetra
.643 .683 .872 r
.16547 .47597 .1816 .49555 .20529 .48814 .18922 .46871 Metetra
.642 .685 .875 r
.18922 .46871 .20529 .48814 .22921 .4807 .2132 .46146 Metetra
.642 .689 .879 r
.2132 .46146 .22921 .4807 .25335 .47324 .23741 .4542 Metetra
.641 .693 .883 r
.23741 .4542 .25335 .47324 .27772 .46574 .26185 .44694 Metetra
.64 .697 .887 r
.26185 .44694 .27772 .46574 .30232 .4582 .28653 .43967 Metetra
.64 .702 .891 r
.28653 .43967 .30232 .4582 .32716 .45061 .31146 .43239 Metetra
.639 .707 .896 r
.31146 .43239 .32716 .45061 .35225 .44298 .33663 .42507 Metetra
.639 .712 .901 r
.33663 .42507 .35225 .44298 .37758 .4353 .36207 .41772 Metetra
.638 .718 .906 r
.36207 .41772 .37758 .4353 .40317 .42756 .38776 .41033 Metetra
.637 .724 .911 r
.38776 .41033 .40317 .42756 .42901 .41975 .41373 .40288 Metetra
.637 .731 .916 r
.41373 .40288 .42901 .41975 .45511 .41188 .43996 .39537 Metetra
.636 .738 .922 r
.43996 .39537 .45511 .41188 .48147 .40393 .46647 .38779 Metetra
.636 .745 .927 r
.46647 .38779 .48147 .40393 .5081 .3959 .49327 .38013 Metetra
.635 .752 .932 r
.49327 .38013 .5081 .3959 .53501 .38778 .52035 .37238 Metetra
.635 .759 .937 r
.52035 .37238 .53501 .38778 .56219 .37957 .54772 .36453 Metetra
.634 .766 .943 r
.54772 .36453 .56219 .37957 .58966 .37126 .57538 .35657 Metetra
.634 .774 .947 r
.57538 .35657 .58966 .37126 .6174 .36285 .60334 .34849 Metetra
.633 .781 .952 r
.60334 .34849 .6174 .36285 .64544 .35432 .63161 .34029 Metetra
.632 .788 .957 r
.63161 .34029 .64544 .35432 .67377 .34568 .66018 .33194 Metetra
.632 .795 .961 r
.66018 .33194 .67377 .34568 .70239 .33691 .68905 .32345 Metetra
.631 .801 .964 r
.68905 .32345 .70239 .33691 .73132 .32802 .71824 .3148 Metetra
.631 .808 .967 r
.71824 .3148 .73132 .32802 .76054 .319 .74775 .30598 Metetra
.63 .813 .97 r
.74775 .30598 .76054 .319 .79008 .30983 .77757 .29699 Metetra
.63 .819 .973 r
.77757 .29699 .79008 .30983 .81992 .30053 .80771 .28782 Metetra
.636 .665 .861 r
.14929 .45465 .16547 .47597 .18922 .46871 .17308 .44761 Metetra
.635 .668 .865 r
.17308 .44761 .18922 .46871 .2132 .46146 .1971 .44063 Metetra
.634 .672 .869 r
.1971 .44063 .2132 .46146 .23741 .4542 .22135 .43369 Metetra
.633 .676 .874 r
.22135 .43369 .23741 .4542 .26185 .44694 .24583 .42678 Metetra
.632 .682 .879 r
.24583 .42678 .26185 .44694 .28653 .43967 .27057 .41989 Metetra
.631 .687 .885 r
.27057 .41989 .28653 .43967 .31146 .43239 .29556 .41302 Metetra
.63 .693 .89 r
.29556 .41302 .31146 .43239 .33663 .42507 .32081 .40614 Metetra
.629 .7 .897 r
.32081 .40614 .33663 .42507 .36207 .41772 .34633 .39926 Metetra
.628 .707 .903 r
.34633 .39926 .36207 .41772 .38776 .41033 .37212 .39235 Metetra
.627 .715 .91 r
.37212 .39235 .38776 .41033 .41373 .40288 .39819 .38541 Metetra
.626 .723 .917 r
.39819 .38541 .41373 .40288 .43996 .39537 .42455 .37842 Metetra
.625 .732 .924 r
.42455 .37842 .43996 .39537 .46647 .38779 .4512 .37136 Metetra
.624 .74 .93 r
.4512 .37136 .46647 .38779 .49327 .38013 .47815 .36422 Metetra
.623 .75 .937 r
.47815 .36422 .49327 .38013 .52035 .37238 .5054 .35699 Metetra
.622 .759 .944 r
.5054 .35699 .52035 .37238 .54772 .36453 .53296 .34965 Metetra
.621 .768 .95 r
.53296 .34965 .54772 .36453 .57538 .35657 .56082 .34219 Metetra
.62 .778 .957 r
.56082 .34219 .57538 .35657 .60334 .34849 .58901 .33459 Metetra
.619 .787 .962 r
.58901 .33459 .60334 .34849 .63161 .34029 .61751 .32684 Metetra
.617 .796 .967 r
.61751 .32684 .63161 .34029 .66018 .33194 .64633 .31893 Metetra
.616 .805 .972 r
.64633 .31893 .66018 .33194 .68905 .32345 .67548 .31083 Metetra
.615 .813 .976 r
.67548 .31083 .68905 .32345 .71824 .3148 .70496 .30255 Metetra
.614 .821 .98 r
.70496 .30255 .71824 .3148 .74775 .30598 .73476 .29406 Metetra
.613 .828 .983 r
.73476 .29406 .74775 .30598 .77757 .29699 .7649 .28535 Metetra
.612 .835 .985 r
.7649 .28535 .77757 .29699 .80771 .28782 .79537 .27641 Metetra
.628 .647 .85 r
.13308 .43158 .14929 .45465 .17308 .44761 .15688 .42484 Metetra
.626 .651 .855 r
.15688 .42484 .17308 .44761 .1971 .44063 .18091 .41821 Metetra
.624 .655 .86 r
.18091 .41821 .1971 .44063 .22135 .43369 .20518 .41168 Metetra
.623 .66 .866 r
.20518 .41168 .22135 .43369 .24583 .42678 .22969 .40522 Metetra
.621 .666 .872 r
.22969 .40522 .24583 .42678 .27057 .41989 .25446 .39883 Metetra
.62 .672 .879 r
.25446 .39883 .27057 .41989 .29556 .41302 .27949 .3925 Metetra
.618 .679 .886 r
.27949 .3925 .29556 .41302 .32081 .40614 .30479 .3862 Metetra
.617 .687 .893 r
.30479 .3862 .32081 .40614 .34633 .39926 .33037 .37991 Metetra
.615 .695 .901 r
.33037 .37991 .34633 .39926 .37212 .39235 .35624 .37363 Metetra
.614 .705 .909 r
.35624 .37363 .37212 .39235 .39819 .38541 .38241 .36734 Metetra
.612 .714 .918 r
.38241 .36734 .39819 .38541 .42455 .37842 .40887 .36101 Metetra
.611 .724 .926 r
.40887 .36101 .42455 .37842 .4512 .37136 .43565 .35462 Metetra
.609 .735 .935 r
.43565 .35462 .4512 .37136 .47815 .36422 .46274 .34816 Metetra
.607 .746 .943 r
.46274 .34816 .47815 .36422 .5054 .35699 .49016 .3416 Metetra
.605 .757 .951 r
.49016 .3416 .5054 .35699 .53296 .34965 .5179 .33493 Metetra
.603 .768 .959 r
.5179 .33493 .53296 .34965 .56082 .34219 .54597 .32812 Metetra
.601 .78 .966 r
.54597 .32812 .56082 .34219 .58901 .33459 .57438 .32115 Metetra
.599 .791 .972 r
.57438 .32115 .58901 .33459 .61751 .32684 .60313 .314 Metetra
.597 .802 .978 r
.60313 .314 .61751 .32684 .64633 .31893 .63222 .30666 Metetra
.595 .812 .983 r
.63222 .30666 .64633 .31893 .67548 .31083 .66165 .29909 Metetra
.592 .822 .987 r
.66165 .29909 .67548 .31083 .70496 .30255 .69143 .2913 Metetra
.59 .832 .99 r
.69143 .2913 .70496 .30255 .73476 .29406 .72156 .28325 Metetra
.588 .841 .993 r
.72156 .28325 .73476 .29406 .7649 .28535 .75203 .27492 Metetra
.587 .849 .994 r
.75203 .27492 .7649 .28535 .79537 .27641 .78285 .26631 Metetra
.619 .63 .84 r
.11685 .40676 .13308 .43158 .15688 .42484 .14064 .4004 Metetra
.616 .634 .845 r
.14064 .4004 .15688 .42484 .18091 .41821 .16466 .39421 Metetra
.614 .638 .851 r
.16466 .39421 .18091 .41821 .20518 .41168 .18892 .38818 Metetra
.611 .644 .858 r
.18892 .38818 .20518 .41168 .22969 .40522 .21343 .38228 Metetra
.609 .65 .865 r
.21343 .38228 .22969 .40522 .25446 .39883 .2382 .3765 Metetra
.607 .657 .873 r
.2382 .3765 .25446 .39883 .27949 .3925 .26324 .37082 Metetra
.604 .665 .882 r
.26324 .37082 .27949 .3925 .30479 .3862 .28857 .36521 Metetra
.602 .673 .89 r
.28857 .36521 .30479 .3862 .33037 .37991 .3142 .35967 Metetra
.6 .683 .9 r
.3142 .35967 .33037 .37991 .35624 .37363 .34012 .35416 Metetra
.597 .693 .909 r
.34012 .35416 .35624 .37363 .38241 .36734 .36636 .34865 Metetra
.595 .704 .919 r
.36636 .34865 .38241 .36734 .40887 .36101 .39292 .34313 Metetra
.593 .715 .929 r
.39292 .34313 .40887 .36101 .43565 .35462 .41981 .33757 Metetra
.59 .728 .939 r
.41981 .33757 .43565 .35462 .46274 .34816 .44704 .33194 Metetra
.587 .74 .949 r
.44704 .33194 .46274 .34816 .49016 .3416 .47461 .32621 Metetra
.584 .753 .958 r
.47461 .32621 .49016 .3416 .5179 .33493 .50253 .32036 Metetra
.581 .767 .967 r
.50253 .32036 .5179 .33493 .54597 .32812 .53081 .31435 Metetra
.578 .78 .975 r
.53081 .31435 .54597 .32812 .57438 .32115 .55944 .30816 Metetra
.574 .793 .982 r
.55944 .30816 .57438 .32115 .60313 .314 .58844 .30177 Metetra
.57 .805 .988 r
.58844 .30177 .60313 .314 .63222 .30666 .61781 .29514 Metetra
.566 .817 .992 r
.61781 .29514 .63222 .30666 .66165 .29909 .64754 .28824 Metetra
.562 .828 .995 r
.64754 .28824 .66165 .29909 .69143 .2913 .67764 .28107 Metetra
.559 .838 .997 r
.67764 .28107 .69143 .2913 .72156 .28325 .70811 .27357 Metetra
.555 .848 .998 r
.70811 .27357 .72156 .28325 .75203 .27492 .73895 .26575 Metetra
.553 .856 .997 r
.73895 .26575 .75203 .27492 .78285 .26631 .77015 .25757 Metetra
.609 .614 .83 r
.10064 .38019 .11685 .40676 .14064 .4004 .12438 .37429 Metetra
.605 .617 .837 r
.12438 .37429 .14064 .4004 .16466 .39421 .14836 .36862 Metetra
.602 .622 .843 r
.14836 .36862 .16466 .39421 .18892 .38818 .17258 .36317 Metetra
.598 .627 .851 r
.17258 .36317 .18892 .38818 .21343 .38228 .19706 .35793 Metetra
.595 .633 .859 r
.19706 .35793 .21343 .38228 .2382 .3765 .22181 .35287 Metetra
.592 .641 .868 r
.22181 .35287 .2382 .3765 .26324 .37082 .24684 .34797 Metetra
.588 .649 .878 r
.24684 .34797 .26324 .37082 .28857 .36521 .27217 .34319 Metetra
.585 .658 .888 r
.27217 .34319 .28857 .36521 .3142 .35967 .2978 .33851 Metetra
.582 .668 .898 r
.2978 .33851 .3142 .35967 .34012 .35416 .32376 .33391 Metetra
.578 .68 .91 r
.32376 .33391 .34012 .35416 .36636 .34865 .35005 .32935 Metetra
.574 .692 .921 r
.35005 .32935 .36636 .34865 .39292 .34313 .37669 .32479 Metetra
.571 .705 .932 r
.37669 .32479 .39292 .34313 .41981 .33757 .40367 .3202 Metetra
.567 .718 .944 r
.40367 .3202 .41981 .33757 .44704 .33194 .43102 .31556 Metetra
.562 .733 .955 r
.43102 .31556 .44704 .33194 .47461 .32621 .45874 .31082 Metetra
.558 .747 .965 r
.45874 .31082 .47461 .32621 .50253 .32036 .48683 .30594 Metetra
.553 .762 .975 r
.48683 .30594 .50253 .32036 .53081 .31435 .51531 .3009 Metetra
.547 .777 .983 r
.51531 .3009 .53081 .31435 .55944 .30816 .54417 .29565 Metetra
.542 .791 .99 r
.54417 .29565 .55944 .30816 .58844 .30177 .57343 .29015 Metetra
.536 .804 .995 r
.57343 .29015 .58844 .30177 .61781 .29514 .60308 .28439 Metetra
.53 .817 .998 r
.60308 .28439 .61781 .29514 .64754 .28824 .63312 .2783 Metetra
.524 .829 1 r
.63312 .2783 .64754 .28824 .67764 .28107 .66356 .27188 Metetra
.518 .839 .999 r
.66356 .27188 .67764 .28107 .70811 .27357 .69439 .26508 Metetra
.513 .849 .997 r
.69439 .26508 .70811 .27357 .73895 .26575 .72561 .25786 Metetra
.508 .857 .993 r
.72561 .25786 .73895 .26575 .77015 .25757 .75722 .25021 Metetra
.598 .597 .822 r
.08446 .3519 .10064 .38019 .12438 .37429 .10813 .34651 Metetra
.593 .6 .828 r
.10813 .34651 .12438 .37429 .14836 .36862 .13204 .34144 Metetra
.589 .605 .836 r
.13204 .34144 .14836 .36862 .17258 .36317 .15619 .33668 Metetra
.584 .61 .844 r
.15619 .33668 .17258 .36317 .19706 .35793 .18061 .33219 Metetra
.579 .616 .853 r
.18061 .33219 .19706 .35793 .22181 .35287 .2053 .32796 Metetra
.574 .624 .863 r
.2053 .32796 .22181 .35287 .24684 .34797 .23029 .32394 Metetra
.57 .632 .874 r
.23029 .32394 .24684 .34797 .27217 .34319 .25558 .32012 Metetra
.565 .642 .885 r
.25558 .32012 .27217 .34319 .2978 .33851 .28121 .31644 Metetra
.56 .653 .897 r
.28121 .31644 .2978 .33851 .32376 .33391 .30717 .31288 Metetra
.555 .664 .91 r
.30717 .31288 .32376 .33391 .35005 .32935 .33348 .3094 Metetra
.55 .678 .923 r
.33348 .3094 .35005 .32935 .37669 .32479 .36017 .30596 Metetra
.544 .692 .936 r
.36017 .30596 .37669 .32479 .40367 .3202 .38723 .30251 Metetra
.538 .706 .948 r
.38723 .30251 .40367 .3202 .43102 .31556 .41468 .29901 Metetra
.532 .722 .961 r
.41468 .29901 .43102 .31556 .45874 .31082 .44253 .29541 Metetra
.525 .738 .972 r
.44253 .29541 .45874 .31082 .48683 .30594 .47078 .29168 Metetra
.517 .754 .982 r
.47078 .29168 .48683 .30594 .51531 .3009 .49946 .28775 Metetra
.509 .769 .99 r
.49946 .28775 .51531 .3009 .54417 .29565 .52855 .2836 Metetra
.501 .784 .996 r
.52855 .2836 .54417 .29565 .57343 .29015 .55806 .27917 Metetra
.492 .798 .999 r
.55806 .27917 .57343 .29015 .60308 .28439 .588 .27442 Metetra
.483 .811 1 r
.588 .27442 .60308 .28439 .63312 .2783 .61836 .2693 Metetra
.474 .822 .998 r
.61836 .2693 .63312 .2783 .66356 .27188 .64915 .26377 Metetra
.466 .832 .993 r
.64915 .26377 .66356 .27188 .69439 .26508 .68037 .25778 Metetra
.458 .84 .986 r
.68037 .25778 .69439 .26508 .72561 .25786 .71199 .25131 Metetra
.452 .847 .977 r
.71199 .25131 .72561 .25786 .75722 .25021 .74403 .2443 Metetra
.586 .58 .813 r
.06833 .32188 .08446 .3519 .10813 .34651 .09191 .31707 Metetra
.58 .583 .82 r
.09191 .31707 .10813 .34651 .13204 .34144 .11571 .31268 Metetra
.574 .587 .829 r
.11571 .31268 .13204 .34144 .15619 .33668 .13976 .30869 Metetra
.568 .592 .838 r
.13976 .30869 .15619 .33668 .18061 .33219 .16408 .30506 Metetra
.561 .598 .848 r
.16408 .30506 .18061 .33219 .2053 .32796 .18868 .30175 Metetra
.555 .605 .858 r
.18868 .30175 .2053 .32796 .23029 .32394 .21359 .29874 Metetra
.549 .614 .87 r
.21359 .29874 .23029 .32394 .25558 .32012 .23883 .29599 Metetra
.542 .624 .883 r
.23883 .29599 .25558 .32012 .28121 .31644 .2644 .29345 Metetra
.535 .635 .896 r
.2644 .29345 .28121 .31644 .30717 .31288 .29034 .29107 Metetra
.528 .647 .91 r
.29034 .29107 .30717 .31288 .33348 .3094 .31665 .28882 Metetra
.52 .661 .924 r
.31665 .28882 .33348 .3094 .36017 .30596 .34336 .28663 Metetra
.512 .675 .938 r
.34336 .28663 .36017 .30596 .38723 .30251 .37047 .28447 Metetra
.504 .691 .952 r
.37047 .28447 .38723 .30251 .41468 .29901 .398 .28227 Metetra
.494 .707 .965 r
.398 .28227 .41468 .29901 .44253 .29541 .42597 .27999 Metetra
.484 .724 .977 r
.42597 .27999 .44253 .29541 .47078 .29168 .45437 .27756 Metetra
.474 .741 .986 r
.45437 .27756 .47078 .29168 .49946 .28775 .48323 .27493 Metetra
.462 .757 .993 r
.48323 .27493 .49946 .28775 .52855 .2836 .51254 .27204 Metetra
.45 .772 .997 r
.51254 .27204 .52855 .2836 .55806 .27917 .54231 .26884 Metetra
.438 .785 .997 r
.54231 .26884 .55806 .27917 .588 .27442 .57254 .26526 Metetra
.425 .797 .994 r
.57254 .26526 .588 .27442 .61836 .2693 .60324 .26125 Metetra
.413 .806 .987 r
.60324 .26125 .61836 .2693 .64915 .26377 .63439 .25676 Metetra
.402 .814 .976 r
.63439 .25676 .64915 .26377 .68037 .25778 .66601 .25174 Metetra
.392 .82 .964 r
.66601 .25174 .68037 .25778 .71199 .25131 .69807 .24613 Metetra
.384 .825 .949 r
.69807 .24613 .71199 .25131 .74403 .2443 .73056 .23989 Metetra
.573 .564 .805 r
.05228 .29016 .06833 .32188 .09191 .31707 .07573 .286 Metetra
.566 .566 .813 r
.07573 .286 .09191 .31707 .11571 .31268 .09939 .28236 Metetra
.558 .569 .821 r
.09939 .28236 .11571 .31268 .13976 .30869 .12331 .27922 Metetra
.55 .574 .831 r
.12331 .27922 .13976 .30869 .16408 .30506 .1475 .27653 Metetra
.541 .579 .842 r
.1475 .27653 .16408 .30506 .18868 .30175 .17197 .27426 Metetra
.533 .586 .854 r
.17197 .27426 .18868 .30175 .21359 .29874 .19677 .27236 Metetra
.524 .594 .866 r
.19677 .27236 .21359 .29874 .23883 .29599 .2219 .2708 Metetra
.515 .604 .88 r
.2219 .2708 .23883 .29599 .2644 .29345 .2474 .26951 Metetra
.506 .615 .894 r
.2474 .26951 .2644 .29345 .29034 .29107 .27327 .26846 Metetra
.496 .627 .909 r
.27327 .26846 .29034 .29107 .31665 .28882 .29955 .26757 Metetra
.486 .641 .924 r
.29955 .26757 .31665 .28882 .34336 .28663 .32625 .2668 Metetra
.474 .656 .94 r
.32625 .2668 .34336 .28663 .37047 .28447 .35339 .26609 Metetra
.462 .672 .954 r
.35339 .26609 .37047 .28447 .398 .28227 .38098 .26536 Metetra
.449 .688 .968 r
.38098 .26536 .398 .28227 .42597 .27999 .40903 .26455 Metetra
.435 .705 .979 r
.40903 .26455 .42597 .27999 .45437 .27756 .43757 .26359 Metetra
.42 .721 .987 r
.43757 .26359 .45437 .27756 .48323 .27493 .4666 .26242 Metetra
.404 .737 .992 r
.4666 .26242 .48323 .27493 .51254 .27204 .49612 .26097 Metetra
.388 .75 .992 r
.49612 .26097 .51254 .27204 .54231 .26884 .52615 .25916 Metetra
.371 .762 .988 r
.52615 .25916 .54231 .26884 .57254 .26526 .55668 .25693 Metetra
.355 .772 .978 r
.55668 .25693 .57254 .26526 .60324 .26125 .58771 .2542 Metetra
.339 .778 .964 r
.58771 .2542 .60324 .26125 .63439 .25676 .61924 .25091 Metetra
.325 .783 .947 r
.61924 .25091 .63439 .25676 .66601 .25174 .65127 .24699 Metetra
.314 .786 .927 r
.65127 .24699 .66601 .25174 .69807 .24613 .68379 .24239 Metetra
.305 .788 .906 r
.68379 .24239 .69807 .24613 .73056 .23989 .71677 .23704 Metetra
.559 .547 .797 r
.03634 .25676 .05228 .29016 .07573 .286 .05962 .25331 Metetra
.55 .548 .805 r
.05962 .25331 .07573 .286 .09939 .28236 .08311 .25049 Metetra
.54 .551 .814 r
.08311 .25049 .09939 .28236 .12331 .27922 .10686 .24828 Metetra
.53 .554 .825 r
.10686 .24828 .12331 .27922 .1475 .27653 .13087 .24662 Metetra
.519 .559 .836 r
.13087 .24662 .1475 .27653 .17197 .27426 .15519 .24548 Metetra
.508 .565 .848 r
.15519 .24548 .17197 .27426 .19677 .27236 .17983 .2448 Metetra
.497 .572 .862 r
.17983 .2448 .19677 .27236 .2219 .2708 .20483 .24454 Metetra
.485 .581 .876 r
.20483 .24454 .2219 .2708 .2474 .26951 .2302 .24464 Metetra
.472 .592 .892 r
.2302 .24464 .2474 .26951 .27327 .26846 .25598 .24504 Metetra
.459 .604 .907 r
.25598 .24504 .27327 .26846 .29955 .26757 .28218 .24567 Metetra
.444 .617 .923 r
.28218 .24567 .29955 .26757 .32625 .2668 .30884 .24646 Metetra
.429 .631 .939 r
.30884 .24646 .32625 .2668 .35339 .26609 .33597 .24734 Metetra
.413 .647 .954 r
.33597 .24734 .35339 .26609 .38098 .26536 .36359 .24824 Metetra
.395 .663 .967 r
.36359 .24824 .38098 .26536 .40903 .26455 .39171 .24908 Metetra
.376 .679 .976 r
.39171 .24908 .40903 .26455 .43757 .26359 .42036 .24977 Metetra
.355 .694 .982 r
.42036 .24977 .43757 .26359 .4666 .26242 .44954 .25024 Metetra
.334 .707 .983 r
.44954 .25024 .4666 .26242 .49612 .26097 .47927 .2504 Metetra
.313 .719 .978 r
.47927 .2504 .49612 .26097 .52615 .25916 .50954 .25017 Metetra
.292 .728 .967 r
.50954 .25017 .52615 .25916 .55668 .25693 .54037 .24945 Metetra
.272 .734 .95 r
.54037 .24945 .55668 .25693 .58771 .2542 .57174 .24817 Metetra
.253 .737 .928 r
.57174 .24817 .58771 .2542 .61924 .25091 .60367 .24625 Metetra
.238 .738 .903 r
.60367 .24625 .61924 .25091 .65127 .24699 .63613 .2436 Metetra
.226 .738 .876 r
.63613 .2436 .65127 .24699 .68379 .24239 .66912 .24015 Metetra
.217 .738 .848 r
.66912 .24015 .68379 .24239 .71677 .23704 .70262 .23582 Metetra
0 g
.25 Mabswid
.68874 0 m
.96935 .42335 L
s
.96935 .42335 m
1 .64453 L
s
1 .64453 m
.70298 .24207 L
s
.70298 .24207 m
.68874 0 L
s
.03716 .25163 m
0 .48291 L
s
0 .48291 m
.70298 .24207 L
s
.70298 .24207 m
.68874 0 L
s
.68874 0 m
.03716 .25163 L
s
.03716 .25163 m
.68874 0 L
s
.03716 .25163 m
.04196 .25605 L
s
gsave
.02757 .2428 -96.3125 -34.7014 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.18558 .19431 m
.19014 .19897 L
s
gsave
.17646 .18501 -114.955 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Mathematica1
%%IncludeFont: Mathematica1
/Mathematica1 findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(-) show
81.250 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.34306 .1335 m
.34735 .1384 L
s
gsave
.3345 .12369 -76.8872 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0) show
1.000 setlinewidth
grestore
.51046 .06885 m
.51442 .07401 L
s
gsave
.50253 .05854 -93.1932 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(0.5) show
1.000 setlinewidth
grestore
.68874 0 m
.69233 .00542 L
s
gsave
.68156 -0.01083 -75.1085 -35.75 Mabsadd m
1 1 Mabs scale
currentpoint translate
0 39.75 translate 1 -1 scale
/g { setgray} bind def
/k { setcmykcolor} bind def
/p { gsave} bind def
/r { setrgbcolor} bind def
/w { setlinewidth} bind def
/C { curveto} bind def
/F { fill} bind def
/L { lineto} bind def
/rL { rlineto} bind def
/P { grestore} bind def
/s { stroke} bind def
/S { show} bind def
/N {currentpoint 3 -1 roll show moveto} bind def
/Msf { findfont exch scalefont [1 0 0 -1 0 0 ] makefont setfont} bind def
/m { moveto} bind def
/Mr { rmoveto} bind def
/Mx {currentpoint exch pop moveto} bind def
/My {currentpoint pop exch moveto} bind def
/X {0 rmoveto} bind def
/Y {0 exch rmoveto} bind def
63.000 28.500 moveto
%%IncludeResource: font Times-Roman
%%IncludeFont: Times-Roman
/Times-Roman findfont 26.000 scalefont
[1 0 0 -1 0 0 ] makefont setfont
0.000 0.000 0.000 setrgbcolor
(1) show
1.000 setlinewidth
grestore
.125 Mabswid
.06616 .24044 m
.06901 .24311 L
s
.09549 .22911 m
.09832 .23181 L
s
.12517 .21765 m
.12797 .22038 L
s
.1552 .20605 m
.15797 .20881 L
s
.21633 .18244 m
.21903 .18526 L
s
.24744 .17042 m
.25012 .17328 L
s
.27893 .15826 m
.28157 .16114 L
s
.3108 .14595 m
.31341 .14887 L
s
.37572 .12088 m
.37826 .12386 L
s
.40878 .10812 m
.41128 .11112 L
s
.44225 .09519 m
.44471 .09822 L
s
.47614 .0821 m
.47856 .08517 L
s
.54521 .05543 m
.54755 .05855 L
s
.58041 .04184 m
.5827 .04499 L
s
.61605 .02807 m
.6183 .03126 L
s
.65216 .01413 m
.65436 .01734 L
s
% End of Graphics
MathPictureEnd
\
\>"], "Graphics",
  ImageSize->{400, 320},
  ImageMargins->{{43, 0}, {0, 0}},
  ImageRegion->{{0, 1}, {0, 1}},
  ImageCache->GraphicsData["Bitmap", "\<\
CF5dJ6E]HGAYHf4PAg9QL6QYHg<PAVmbKF5d0`40006@0001@2000`400?l00000o`00003oo`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA
0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3ooonA0?ooo`00o`3oool@
0?ooo`H00000N`3oool00?l0oooo4P3oool2000007d0oooo003o0?oooa80oooo0P00001m0?ooo`00
o`3ooolB0?ooo`800000O@3oool00?l0oooo4P3oool2000007d0oooo003o0?oooa80oooo0P00001m
0?ooo`00o`3ooolB0?ooo`800000O@3oool00?l0oooo4P3oool2000007d0oooo003o0?oooa80oooo
0P00001m0?ooo`00o`3ooolB0?ooo`800000O@3oool00?l0oooo4P3oool2000007d0oooo003o0?oo
oa80oooo0P00001m0?ooo`00o`3ooolB0?ooo`8000008`3oool6000005@0oooo003o0?oooa80oooo
0P00000U0?ooo`800000EP3oool00?l0oooo4P3oool2000002D0oooo0P00001F0?ooo`00o`3oool?
0?ooo`D000009@3oool2000005H0oooo003o0?oooa40oooo0`00000U0?ooo`800000EP3oool00?l0
oooo8`3oool=000000T0oooo0P00001F0?ooo`00o`3ooolS0?ooo`d000002@3oool2000005H0oooo
003o0?ooocT0oooo0P00001F0?ooo`00o`3oooli0?ooo`800000EP3oool00?l0oooo>@3oool20000
05H0oooo003o0?ooocT0oooo0P00001F0?ooo`00`@3oool4000000L0oooo0P0000050?ooo`D00000
H03oool2000005H0oooo00300?ooo`8000000`3oool2000000D0oooo0P0000040?ooo`800000103o
ool00`000000oooo0?ooo`1M0?ooo`800000EP3oool00<00oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`0@0?ooo`030000003oool0oooo05`0oooo0P00001F0?ooo`00_`3oool20000
00D0oooo0P00000B0?ooo`030000003oool0oooo05/0oooo0P00001F0?ooo`00_`3oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo0100oooo0P00000m0?ooo`8000006P3oool5000005H0
oooo002n0?ooo`8000001`3oool200000140oooo0P00000k0?ooo`D000006`3oool3000005H0oooo
002n0?ooo`8000001`3oool200000140oooo0P00000h0?ooo`<000000`3oool2000007@0oooo002n
0?ooo`8000001`3oool200000140oooo0P00000e0?ooo`<000001P3oool00`000000oooo0000001c
0?ooo`00_P3oool2000000L0oooo0P00000@0?ooo`<00000<`3oool2000000T0oooo00@000000?oo
o`3oool00000LP3oool00;h0oooo0P0000070?ooo`8000003`3oool300000340oooo0`00000;0?oo
o`040000003oool0oooo00000780oooo002n0?ooo`8000001`3oool2000000d0oooo1000000`0?oo
o`8000000P3oool00`000000oooo0?ooo`090?ooo`050000003oool0oooo0?ooo`000000L@3oool0
0;h0oooo0P0000070?ooo`8000002P3oool6000002h0oooo0`00000@0?ooo`030000003oool0oooo
0080oooo00<000000?ooo`3oool0KP3oool00;l0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`0:0?ooo`<00000;@3oool3000001<0oooo00<000000?ooo`3oool00P3oool00`000000
oooo0?ooo`1^0?ooo`00_`3oool2000000D0oooo0P00000<0?ooo`030000003oool0oooo02/0oooo
0P00000G0?ooo`040000003oool0oooo0?ooo`800000K`3oool00<00oooo00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo02L0oooo0`00000I0?ooo`030000
003oool0oooo00<0oooo00<000000?ooo`3oool0K03oool00<00oooo0P0000030?ooo`8000003P3o
ool600000280oooo0P0000030?ooo`030000003oool0oooo01H0oooo00<000000?ooo`3oool00`3o
ool00`000000oooo0?ooo`1/0?ooo`00`P3oool300000140oooo1P00000N0?ooo`<000007P3oool0
0`000000oooo0?ooo`040?ooo`030000003oool0oooo06/0oooo003g0?ooo`<000008@3oool00`00
0000oooo0?ooo`050?ooo`030000003oool0oooo06X0oooo003e0?ooo`800000903oool00`000000
oooo0?ooo`050?ooo`030000003oool0oooo06X0oooo003b0?ooo`<0000000<0oooo0000003oool0
8`3oool00`000000oooo0?ooo`060?ooo`030000003oool0oooo06T0oooo003`0?ooo`800000:@3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo06P0oooo003]0?ooo`<00000:`3oool0
0`000000oooo0?ooo`070?ooo`800000J@3oool00>X0oooo0`00000^0?ooo`030000003oool0oooo
00H0oooo0`00001Y0?ooo`00V03oool4000004`0oooo0P00000a0?ooo`030000003oool0oooo00T0
oooo00<000000?ooo`3oool0IP3oool009L0oooo0P0000030?ooo`800000A`3oool300000080oooo
00<000000?ooo`3oool0;P3oool00`000000oooo0?ooo`090?ooo`030000003oool0oooo06H0oooo
002G0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0@`3oool2000003H0oooo00<0
00000?ooo`3oool02P3oool00`000000oooo0?ooo`1U0?ooo`00UP3oool2000000D0oooo0P000011
0?ooo`<00000>03oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo06@0oooo002F0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool0?03oool3000003/0oooo00<000000?oo
o`3oool02`3oool00`000000oooo0?ooo`1T0?ooo`00U@3oool2000000L0oooo0P00000k0?ooo`80
000000<0oooo0000003oool0>`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo06<0
oooo002E0?ooo`8000001`3oool2000003P0oooo0`0000040?ooo`030000003oool0oooo03X0oooo
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`1S0?ooo`00U@3oool2000000L0oooo0P00
000f0?ooo`800000A03oool00`000000oooo0?ooo`0;0?ooo`800000I03oool009D0oooo0P000007
0?ooo`800000<`3oool3000004H0oooo00<000000?ooo`3oool03@3oool00`000000oooo0?ooo`0S
0?ooo`@000001`3oool2000000D0oooo1@00000W0?ooo`00U@3oool2000000L0oooo0P00000`0?oo
o`<00000B@3oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0280oooo0P0000030?oo
o`8000001@3oool2000000@0oooo0P0000040?ooo`030000003oool0oooo02@0oooo002E0?ooo`80
00001`3oool2000002h0oooo0P0000030?ooo`030000003oool0oooo04H0oooo00<000000?ooo`3o
ool03P3oool00`000000oooo0?ooo`0Q0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3o
ool0403oool00`000000oooo0?ooo`0S0?ooo`00U@3oool2000000L0oooo0P00000[0?ooo`<00000
CP3oool00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo01l0oooo0P0000050?ooo`800000
4P3oool00`000000oooo0?ooo`0R0?ooo`00UP3oool00`000000oooo0?ooo`050?ooo`030000003o
ool0oooo02P0oooo0P00001A0?ooo`030000003oool0oooo00l0oooo00<000000?ooo`3oool07`3o
ool00`000000oooo0?ooo`050?ooo`030000003oool0oooo0100oooo0P00000S0?ooo`00UP3oool2
000000D0oooo0P00000W0?ooo`<00000D`3oool00`000000oooo0?ooo`0@0?ooo`030000003oool0
oooo00`0oooo3@0000040?ooo`8000001`3oool200000140oooo0P00000S0?ooo`00U`3oool00`00
0000oooo0?ooo`030?ooo`030000003oool0oooo02<0oooo0`0000000`3oool000000?ooo`1C0?oo
o`030000003oool0oooo0140oooo00<000000?ooo`3oool02`3oool=000000@0oooo0P0000070?oo
o`8000004@3oool2000002<0oooo002G0?ooo`8000000`3oool2000002<0oooo0P00001I0?ooo`03
0000003oool0oooo0140oooo0P00000M0?ooo`8000001`3oool200000140oooo0P00000S0?ooo`00
V@3oool300000280oooo0`00001K0?ooo`030000003oool0oooo0100oooo0`00000M0?ooo`800000
1`3oool200000100oooo0`00000S0?ooo`00_03oool2000005h0oooo00<000000?ooo`3oool04`3o
ool00`000000oooo0?ooo`0J0?ooo`8000001`3oool2000000l0oooo0`00000T0?ooo`00^@3oool3
00000600oooo00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0J0?ooo`8000001`3oool2
000000d0oooo1000000U0?ooo`00]P3oool3000000<0oooo00<000000?ooo`3oool0G@3oool00`00
0000oooo0?ooo`0D0?ooo`030000003oool0oooo01T0oooo0P0000070?ooo`8000002P3oool60000
02H0oooo001?0?ooo`@000001`3oool2000000D0oooo1@00001>0?ooo`800000IP3oool00`000000
oooo0?ooo`0E0?ooo`030000003oool0oooo01T0oooo00<000000?ooo`3oool01@3oool00`000000
oooo0?ooo`0:0?ooo`<00000:03oool004h0oooo0P0000030?ooo`8000001@3oool2000000@0oooo
0P0000040?ooo`030000003oool0oooo04P0oooo0`00001X0?ooo`030000003oool0oooo01D0oooo
00<000000?ooo`3oool06@3oool2000000D0oooo0P00000<0?ooo`030000003oool0oooo02P0oooo
001>0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`150?ooo`800000J`3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01T0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo02L0oooo001=
0?ooo`8000001@3oool200000180oooo00<000000?ooo`3oool0@@3oool300000080oooo00<00000
0?ooo`3oool0J@3oool00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo01P0oooo0P000003
0?ooo`8000003P3oool6000002@0oooo001=0?ooo`030000003oool0oooo00D0oooo00<000000?oo
o`3oool0403oool2000003l0oooo0`00001a0?ooo`030000003oool0oooo01@0oooo0`00000L0?oo
o`<000004@3oool6000002<0oooo000j0?ooo`d000001@3oool2000000L0oooo0P00000A0?ooo`80
0000?@3oool2000007@0oooo00<000000?ooo`3oool05`3oool00`000000oooo0?ooo`1F0?ooo`00
>P3oool=000000D0oooo0P0000070?ooo`8000004@3oool2000003X0oooo0`00001f0?ooo`030000
003oool0oooo01P0oooo00<000000?ooo`3oool0E@3oool004`0oooo0P0000070?ooo`8000004@3o
ool2000003P0oooo0P0000000`3oool000000?ooo`1f0?ooo`030000003oool0oooo01P0oooo00<0
00000?ooo`3oool0E@3oool004`0oooo0P0000070?ooo`800000403oool3000003D0oooo0`000004
0?ooo`030000003oool0oooo07@0oooo00<000000?ooo`3oool06@3oool00`000000oooo0?ooo`1D
0?ooo`00C03oool2000000L0oooo0P00000?0?ooo`<00000<`3oool3000007h0oooo00<000000?oo
o`3oool06P3oool00`000000oooo0?ooo`1C0?ooo`00C03oool2000000L0oooo0P00000=0?ooo`@0
0000<P3oool200000840oooo00<000000?ooo`3oool06P3oool00`000000oooo0?ooo`1C0?ooo`00
C03oool2000000L0oooo0P00000:0?ooo`H00000<03oool400000880oooo00<000000?ooo`3oool0
6P3oool2000005@0oooo001=0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool02P3o
ool300000300oooo0P0000040?ooo`030000003oool0oooo07l0oooo00<000000?ooo`3oool0703o
ool00`000000oooo0?ooo`1A0?ooo`00C@3oool2000000D0oooo0P00000<0?ooo`030000003oool0
oooo02d0oooo0`0000280?ooo`030000003oool0oooo01`0oooo00<000000?ooo`3oool0D@3oool0
04h0oooo00<000000?ooo`3oool00`3oool00`000000oooo0?ooo`0<0?ooo`030000003oool0oooo
02T0oooo0`00002;0?ooo`030000003oool0oooo01d0oooo00<000000?ooo`3oool0D03oool004h0
oooo0P0000030?ooo`8000003P3oool6000002@0oooo0`00002=0?ooo`030000003oool0oooo01h0
oooo00<000000?ooo`3oool0C`3oool00500oooo0`00000A0?ooo`H00000803oool3000000<0oooo
00<000000?ooo`3oool0RP3oool00`000000oooo0?ooo`0N0?ooo`030000003oool0oooo04l0oooo
00280?ooo`800000T`3oool00`000000oooo0?ooo`0O0?ooo`030000003oool0oooo04h0oooo0025
0?ooo`<00000U@3oool00`000000oooo0?ooo`0P0?ooo`030000003oool0oooo04d0oooo00220?oo
o`<00000V@3oool00`000000oooo0?ooo`0N0?ooo`800000C`3oool00800oooo0P0000030?ooo`03
0000003oool0oooo09H0oooo00<000000?ooo`3oool0803oool00`000000oooo0?ooo`1<0?ooo`00
;`3oool6000004P0oooo0`00002N0?ooo`030000003oool0oooo0240oooo00<000000?ooo`3oool0
B`3oool00340oooo0P0000180?ooo`800000X@3oool00`000000oooo0?ooo`0Q0?ooo`030000003o
ool0oooo04/0oooo000a0?ooo`800000A@3oool300000:<0oooo00<000000?ooo`3oool08P3oool0
0`000000oooo0?ooo`1:0?ooo`00<@3oool200000480oooo0`0000030?ooo`030000003oool0oooo
0:00oooo00<000000?ooo`3oool08`3oool00`000000oooo0?ooo`190?ooo`00<@3oool200000400
oooo0P00002Y0?ooo`030000003oool0oooo02<0oooo00<000000?ooo`3oool0B@3oool001/0oooo
3@0000090?ooo`800000?@3oool300000:/0oooo00<000000?ooo`3oool08`3oool2000001<0oooo
1000000c0?ooo`006`3oool=000000T0oooo0P00000k0?ooo`800000[P3oool00`000000oooo0?oo
o`0U0?ooo`030000003oool0oooo00l0oooo0P0000030?ooo`800000<@3oool00340oooo0P00000h
0?ooo`<000000P3oool00`000000oooo0?ooo`2[0?ooo`030000003oool0oooo02D0oooo00<00000
0?ooo`3oool03`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo02l0oooo000a0?oo
o`800000=@3oool3000000H0oooo00<000000?ooo`3oool0ZP3oool00`000000oooo0?ooo`0V0?oo
o`030000003oool0oooo00d0oooo0P0000050?ooo`800000<03oool00340oooo0P00000c0?ooo`80
0000]P3oool00`000000oooo0?ooo`0W0?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`0^0?ooo`00<@3oool200000300oooo0`00002h0?ooo`030000
003oool0oooo02L0oooo00<000000?ooo`3oool02`3oool2000000L0oooo0P00000_0?ooo`00<@3o
ool2000002h0oooo0P0000030?ooo`030000003oool0oooo0;D0oooo00<000000?ooo`3oool0:03o
ool00`000000oooo0?ooo`0:0?ooo`8000001`3oool2000002l0oooo000a0?ooo`800000:`3oool3
00000;d0oooo00<000000?ooo`3oool0:03oool2000000/0oooo0P0000070?ooo`800000;`3oool0
0340oooo0P00000X0?ooo`<00000`03oool00`000000oooo0?ooo`0X0?ooo`8000002`3oool20000
00L0oooo0P00000_0?ooo`00<@3oool2000002H0oooo0`0000330?ooo`030000003oool0oooo02T0
oooo00<000000?ooo`3oool0203oool2000000L0oooo0P00000_0?ooo`00;P3oool5000002<0oooo
0`0000030?ooo`030000003oool0oooo0<00oooo00<000000?ooo`3oool0:@3oool00`000000oooo
0?ooo`080?ooo`8000001`3oool2000002l0oooo000`0?ooo`<000008@3oool200000<T0oooo00<0
00000?ooo`3oool0:P3oool00`000000oooo0?ooo`070?ooo`8000001`3oool2000002l0oooo001A
0?ooo`<00000b`3oool00`000000oooo0?ooo`0[0?ooo`030000003oool0oooo00L0oooo00<00000
0?ooo`3oool01@3oool00`000000oooo0?ooo`0^0?ooo`00CP3oool400000<d0oooo00<000000?oo
o`3oool0:`3oool00`000000oooo0?ooo`070?ooo`8000001@3oool200000300oooo001<0?ooo`80
0000103oool00`000000oooo0?ooo`3:0?ooo`030000003oool0oooo02`0oooo00<000000?ooo`3o
ool01`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo02l0oooo00190?ooo`<00000
d@3oool9000002L0oooo0`0000080?ooo`8000000`3oool200000340oooo00170?ooo`800000cP3o
ool;000000@0C/WW1000000U0?ooo`030000003oool0oooo00P0oooo0`00000c0?ooo`00A03oool4
00000<H0oooo3P00000204k9i`8000000`1>bNL4000000<0H]?b0P00000T0?ooo`030000003oool0
oooo03d0oooo00110?ooo`<00000103oool00`000000oooo0?ooo`0G0?oooc<00000KP3oool;0000
0080>KcP1P0000040539k@@0000000<0C/WW0000000000000P00000806;ClP<000008`3oool00`00
0000oooo0?ooo`0l0?ooo`00?`3oool200000140oooo4000000408B?eP0300000022T=T0PY3I00D0
PY3I00<0000007nBg01oT]`01P1oT]`00`000000O9CP07bDh00607bDh0030000001hUn@0N9OT00D0
N9OT00<0000007FJj01eV^P01P1eV^P010000000LIg/076Mk01aWN`L000003d0oooo5@00000503bl
i`P00000201@bNd9000000@0H]?b1P00000307?HnP8000008@3oool00`000000oooo0?ooo`0l0?oo
o`00?@3oool2000000/0oooo2000000308Z=d00300000027SM<0QhgC00H0QhgC00<0000008B?eP24
SmH01@24SmH00`000000PY3I08:@f@0508:@f@030000001oT]`0Oi;L00H0Oi;L00<0000007bDh01l
U>001P1lU>000`000000N9OT07RGi00507RGi0030000001eV^P0MI[X00H0MI[X00<00000076Mk01a
WN`01P1aWN`00`000000KJ7`06fQl00606fQl0030000001YYO@0JJGd00L0JJGd00@0000006FYm`1U
ZOL0IJWg?@00000604Fkl`<000001`10_>d:000000P0DlSb2000000806CAmPD000002`1cf?X30000
01l0oooo00<000000?ooo`3oool0>`3oool003d0oooo0P0000030?ooo`P000000`2<S<h00`000000
RXg@08Z=d00608Z=d00300000027SM<0QhgC00D0QhgC00<0000008B?eP24SmH01P24SmH00`000000
PY3I08:@f@0508:@f@030000001oT]`0Oi;L00H0Oi;L00<0000007bDh01lU>001P1lU>000`000000
N9OT07RGi00507RGi0030000001eV^P0MI[X00H0MI[X00<00000076Mk01aWN`01P1aWN`00`000000
KJ7`06fQl00606fQl0030000001YYO@0JJGd00L0JJGd00<0000006FYm`1UZOL01@1UZOL00`000000
H:gi062]n@07062]n@800000201J/O/2000000P0EKCk0P000008052hnP8000002P1:^_L2000000L0
AK_c2`00000605K7mP<00000101Cb?8500000080I]3i1000000406CAmPH000000P1eeo`3000000P0
LmSj0`00000308;KoP8000007P3oool00`000000oooo0?ooo`0j0?ooo`00?@3oool5000000<0Shc<
00<0000008b<cP2<S<h01P2<S<h00`000000RXg@08Z=d00508Z=d00300000027SM<0QhgC00H0QhgC
00<0000008B?eP24SmH01@24SmH00`000000PY3I08:@f@0608:@f@030000001oT]`0Oi;L00H0Oi;L
00<0000007bDh01lU>001@1lU>000`000000N9OT07RGi00607RGi0030000001eV^P0MI[X00H0MI[X
00<00000076Mk01aWN`01P1aWN`00`000000KJ7`06fQl00606fQl0030000001YYO@0JJGd00L0JJGd
00<0000006FYm`1UZOL01@1UZOL00`000000H:gi062]n@08062]n@030000001J/O/0F[7k00L0F[7k
00<0000005Fdn`1E]?/01`1E]?/00`000000D;Sj052hnP07052hnP8000001`1:^_L:000000H0F/Gj
0P00000;05K7mPD000001@1Vd?T2000000@0I]3i1000000907GGo0040000001eeo`0000000000080
LmSj1000000808;KoP8000006`3oool2000003`0oooo000m0?ooo`030000002?S<`0Shc<00H0Shc<
00<0000008b<cP2<S<h01@2<S<h00`000000RXg@08Z=d00608Z=d00300000027SM<0QhgC00D0QhgC
00<0000008B?eP24SmH01P24SmH00`000000PY3I08:@f@0508:@f@030000001oT]`0Oi;L00H0Oi;L
00<0000007bDh01lU>001P1lU>000`000000N9OT07RGi00607RGi0030000001eV^P0MI[X00H0MI[X
00<00000076Mk01aWN`01@1aWN`00`000000KJ7`06fQl00706fQl0030000001YYO@0JJGd00L0JJGd
00<0000006FYm`1UZOL01@1UZOL2000000T0H:gi0P00000805Zan`800000201E]?/2000000H0D;Sj
2P00000505k3o08000002`1JaOX2000000<0E/Of1P00000306W>o08000000P1Vd?T3000000<0I]3i
0`00000207ODoP8000002@1eeo`00`000000MMOl00000003000000P0P]_n1000000208gKo`030000
003oool0oooo01X0oooo00<000000?ooo`3oool0>@3oool003`0oooo0`00000708n<c0030000002<
S<h0S8c>00H0S8c>00<0000008Z=d02:SM001@2:SM000`000000QhgC08N=d`0608N=d`0300000024
SmH0Q8oF00H0Q8oF00<0000008:@f@22T=T01@22T=T00`000000Oi;L07nBg00607nBg0030000001l
U>00O9CP00H0O9CP00<0000007RGi01hUn@01@1hUn@00`000000MI[X07FJj00607FJj0030000001a
WN`0LIg/00H0LIg/00<0000006fQl01]XO001`1]XO000`000000JJGd06VUm00706VUm0030000001U
ZOL0IJWg00H0IJWg00<00000062]n@1P[OT0101P[OTN000000D0Hkom0P00000:05k3o08000001`1J
aOX7000000X0JLkl0`00000206K@n@@000001`1ge?h2000000<0MMOl1P00000308?Io`8000000`22
foh4000000L0SM_o0P00000K0?ooo`030000003oool0oooo03P0oooo000l0?ooo`030000003oool0
000000P0Shc<00<0000008b<cP2<S<h01@2<S<h00`000000RXg@08Z=d00608Z=d00300000027SM<0
QhgC00H0QhgC00<0000008B?eP24SmH01@24SmH00`000000PY3I08:@f@0608:@f@030000001oT]`0
Oi;L00H0Oi;L00<0000007bDh01lU>001@1lU>000`000000N9OT07RGi00607RGi0030000001eV^P0
MI[X00H0MI[X00<00000076Mk01aWN`01P1aWN`00`000000KJ7`06fQl00306fQl1d000001@1_]?X0
0`000000JkSl06^ho00706^ho0030000001W_?d0Ikcm00L0Ikcm0P00000:06>oo@8000001P1N`o`;
000000H0K<cn0P00000606W>o0P000002`1ge?h5000000H0PmWo00<0000008?Io`23fOl00P23fOl3
000000`0SM_o0P00000J0?ooo`030000003oool0oooo03P0oooo000l0?ooo`040000003oool0oooo
000000L0Shc<00<0000008b<cP2<S<h01P2<S<h00`000000RXg@08Z=d00508Z=d00300000027SM<0
QhgC00H0QhgC00<0000008B?eP24SmH01P24SmH00`000000PY3I08:@f@0508:@f@030000001oT]`0
Oi;L00H0Oi;L00<0000007bDh01lU>000`1lU>0S000000D0NJO`00<0000007J/m01f[?@01`1f[?@0
0`000000L[3g07:`m`0607:`m`030000001_]?X0KkCj00P0KkCj00<0000006^ho01[^?`01`1[^?`2
000000T0Ikcm0P00000606>oo@X000001P1`b?l2000000X0K<cn2000000607WBo`800000101ge?h6
000000<0Q=Ko0P00000708?Io`@000000P2>fOl00`000000SM_o08gKo`0608gKo`@000000P2FfOh0
0`000000oooo0?ooo`0H0?ooo`030000003oool0oooo03L0oooo000l0?ooo`040000003oool0oooo
000000P0Shc<00<0000008b<cP2<S<h01@2<S<h00`000000RXg@08Z=d00608Z=d00300000027SM<0
QhgC00H0QhgC00<0000008B?eP24SmH01@24SmH00`000000PY3I08:@f@0308:@fA4000001023V^40
0`000000PIgT086Mi006086Mi0030000001nX>P0OZ3X00H0OZ3X00<0000007bTk01lY>`01P1lY>`0
0`000000NJO`07VWl00707VWl0030000001f[?@0MZcd00L0MZcd00<0000007:`m`1b/?L01P1b/?L0
0`000000KkCj06ndnP0806ndnP8000002@1[^?`00`000000Ikcm06Nlo@0406Nlo@X000001@1caOl2
000000/0L<So0P00000306c<oPD0000000<0Nloo0000000000000P00000:07WBo`D000002`24e_l2
00000080PmWo1000000608kIo`8000000P2=fol4000000L0U]Wn00<000000?ooo`3oool0603oool0
0`000000oooo0?ooo`0f0?ooo`00?03oool200000080oooo00<0000008n<c02?S<`01@2?S<`00`00
0000S8c>08b<cP0608b<cP030000002:SM00RXg@00D0RXg@00<0000008N=d`27SM<01P27SM<00`00
0000Q8oF08B?eP0308B?ePP000001028U]X00`000000QYSM08JHg@0608JHg@0300000023V^40Pi[Q
00D0Pi[Q00<00000086Mi021WN@01P21WN@00`000000OZ3X07jPj00707jPj0030000001lY>`0O:C/
00H0O:C/00<0000007VWl01iYo001`1iYo000`000000MZcd07J/m00607J/m0030000001b/?L0L[3g
00L0L[3g0P00000:06ndnP030000001[^?`0JkSl00<0JkSl2P00000507K1oP8000002P1caOl00`00
0000L<So0738o`080738o`D000000`1kcol3000000@0Nloo0P00000307WBo`D000000`26e?l20000
00/0Q=Ko1000000408kIo`030000002>fOl0S]Wo00@0S]Wo0`00000<09KIoP030000003oool0oooo
01L0oooo0P00000g0?ooo`00?03oool01@000000oooo0?ooo`3oool0000000P0Shc<00<0000008b<
cP2<S<h01@2<S<h00`000000RXg@08Z=d00608Z=d00300000027SM<0QhgC0080QhgC2@00000408ZD
e`0300000028U]X0R9KJ00D0R9KJ00<0000008JHg@26V=d01P26V=d00`000000Pi[Q08>Jh@0608>J
h@0300000021WN@0PIgT00H0PIgT00<0000007jPj01nX>P01`1nX>P00`000000O:C/07bTk00607bT
k0030000001iYo00NJO`00H0NJO`00<0000007J/m01f[?@01`1f[?@00`000000L[3g07:`m`0807:`
m`030000001_]?X0KkCj00@0KkCj2@00000507Vmo0030000001f`Oh0M/7n00T0M/7n00<0000007?5
o`1caOl0201caOl2000000<0L<So1@00000307g<o`030000001kcol0000000800000201kcol40000
00X0Q]Co0P00000308CFo`H000000`2?e_l00`000000S]Wo08kIo`0308kIo`030000002>fOl0S]Wo
00<000000P2Feoh00`000000U]Wn09KIoP0:09KIoP800000603oool2000003L0oooo000k0?ooo`03
0000003oool0oooo00<0oooo00<0000008n<c02?S<`01@2?S<`00`000000S8c>08b<cP0608b<cP03
0000002:SM00RXg@0080RXg@2000000408bBe0030000002:U=L0RYCG00H0RYCG00<0000008RFfP28
U]X01P28U]X00`000000QYSM08JHg@0608JHg@0300000023V^40Pi[Q00H0Pi[Q00<00000086Mi021
WN@01P21WN@00`000000OZ3X07jPj00607jPj0030000001lY>`0O:C/00L0O:C/00<0000007VWl01i
Yo001P1iYo000`000000MZcd07J/m00707J/m0030000001b/?L0L[3g00@0L[3g2P00000507^inP03
0000001i_O`0NKgl00L0NKgl00<0000007K1oP1f`Oh02@1f`Oh2000000H0LlGo1`00000707g<o`@0
00001`1kcol300000080Qm7o00<0000008KDo`26e?l02P26e?l4000000X0SmKo0P00000208kIo`@0
00001P2Feoh2000000L0U]Wn0`00000209cEo0030000003oool0oooo01L0oooo00<000000?ooo`3o
ool0=03oool003/0oooo00<000000?ooo`3oool00`3oool00`000000Shc<08n<c00608n<c0030000
002<S<h0S8c>0080S8c>2000000408jAdP030000002<T]@0S9;D00H0S9;D00<0000008ZDe`2:U=L0
1P2:U=L00`000000R9KJ08RFfP0608RFfP0300000026V=d0QYSM00D0QYSM00<0000008>Jh@23V^40
1P23V^400`000000PIgT086Mi007086Mi0030000001nX>P0OZ3X00H0OZ3X00<0000007bTk01lY>`0
1`1lY>`00`000000NJO`07VWl00607VWl0030000001f[?@0MZcd00<0MZcd2P00000507jdm`030000
001k^OX0NkWj00P0NkWj00<0000007Vmo01i_O`01`1i_O`2000000T0M/7n200000050838oP800000
101mc?l3000000@0OLco00<0000007_?o`1kcol01000000608OAo`8000001`26e?l300000080Sm?n
00<0000008oFo`2?e_l02P2?e_l300000080U]On00<0000009KGoP2Feoh01`2Feoh00`000000U]Wn
09KIoP04000000H0W=Gl00<000000?ooo`3oool05P3oool00`000000oooo0?ooo`0d0?ooo`00>`3o
ool2000000D0oooo00<0000008n<c02?S<`00P2?S<`8000000@0T93@00<0000008jAdP2>TM801@2>
TM800`000000S9;D08bBe00608bBe0030000002:U=L0RYCG00H0RYCG00<0000008RFfP28U]X01P28
U]X00`000000QYSM08JHg@0608JHg@0300000023V^40Pi[Q00H0Pi[Q00<00000086Mi021WN@01P21
WN@00`000000OZ3X07jPj00707jPj0030000001lY>`0O:C/00<0O:C/4P000005086`l`030000001n
]?L0O[Cg00P0O[Cg00<0000007^inP1k^OX0201k^OX00`000000NKgl07Vmo00807Vmo0040000001f
`Oh0M/7n07K1oPD000000`22a?d00`000000P<Sn0838oP090838oP@00000101mc?l6000000`0Qm7o
00<0000008KDo`26e?l01000000608oCoP8000001`2?e_l300000080UmCm00D0000009KGoP2Feoh0
U]On0000000809KGoP<000002`2LeO`00`000000oooo0?ooo`0F0?ooo`030000003oool0oooo03<0
oooo000k0?ooo`030000003oool0oooo00@0oooo1@00000409:@cP030000002@T=00T93@00D0T93@
00<0000008jAdP2>TM801P2>TM800`000000S9;D08bBe00608bBe0030000002:U=L0RYCG00H0RYCG
00<0000008RFfP28U]X01P28U]X00`000000QYSM08JHg@0608JHg@0300000023V^40Pi[Q00H0Pi[Q
00<00000086Mi021WN@01P21WN@00`000000OZ3X07jPj00307jPj0T000001@25ZN`00`000000Pjc`
08>/l00608>/l00300000021/?<0PK3c00L0PK3c00<0000007jdm`1n]?L0201n]?L2000000T0NkWj
00<0000007Vmo01i_O`0101i_O`7000000T0P/Cm0P0000080838oPT000001@29cOh2000000X0Qm7o
1000000<08oCoP030000002?e_l0SmKo00@000001P2Ge?d200000080U]On00<0000009KGoP2Feoh0
0P2Feoh300000080W=?k00<0000009cEo02LeO`02@2LeO`2000001P0oooo00<000000?ooo`3oool0
<P3oool003/0oooo00<000000?ooo`3oool01@3oool00`000000TY3>09:@cP0509:@cP030000002@
T=00T93@00H0T93@00<0000008jAdP2>TM801@2>TM800`000000S9;D08bBe00608bBe0030000002:
U=L0RYCG00H0RYCG00<0000008RFfP28U]X01`28U]X00`000000QYSM08JHg@0508JHg@0300000023
V^40Pi[Q00H0Pi[Q00<00000086Mi021WN@00`21WN@9000000D0QjGX00<0000008FYk025ZN`01`25
ZN`00`000000Pjc`08>/l00608>/l00300000021/?<0PK3c00L0PK3c0P00000:07jdm`030000001k
^OX0NkWj00<0NkWj2P00000508C1n`0300000022a?d0P/Cm00X0P/Cm00@000000838oP20b?h0P<Sn
1@00000308[:o@0300000029cOh0RLgn00T0RLgn0P00000308OAo`D000000`2@dOd2000000X0Sm?n
1000000<09ODo@030000002Feoh0U]On00@000001P2Ldo/00`000000W=Gl09cEo00509cEo0<00000
0P2QdOT00`000000oooo0?ooo`0E0?ooo`030000003oool0oooo0140oooo100000070?ooo`800000
1@3oool5000000X0oooo000k0?ooo`030000003oool0oooo00D0oooo00<0000009:@cP2BT<h01P2B
T<h00`000000T93@092@d005092@d0030000002>TM80SY7B00H0SY7B00<0000008bBe02<T]@01P2<
T]@00`000000RYCG08ZDe`0608ZDe`0300000028U]X0R9KJ00H0R9KJ00<0000008JHg@26V=d00`26
V=dA000000D0R:;U00<0000008NUj027YNP01`27YNP00`000000QJW/08FYk00708FYk00300000023
[?00Pjc`00H0Pjc`00<00000086`l`21/?<02021/?<00`000000O[Cg07jdm`0407jdm`T000001@26
_?P00`000000Q<7k08C1n`0808C1n`8000002@22a?d6000000P0R/[m0P00000908W=oPD000002P2@
dOd2000000<0Sm?n1@00000309OBo0030000002Ge?d0UmCm00X0UmCm1000000:09cCn`030000002L
eO`0W=Gl00@000001P2QdOT2000001H0oooo00<000000?ooo`3oool03`3oool2000000<0oooo0P00
00050?ooo`800000103oool2000000@0oooo00<000000?ooo`3oool01`3oool001P0oooo10000007
0?ooo`8000001@3oool5000000`0oooo0`0000060?ooo`030000002BT<h0TY3>00D0TY3>00<00000
092@d02@T=001P2@T=000`000000SY7B08jAdP0608jAdP030000002<T]@0S9;D00D0S9;D00<00000
08ZDe`2:U=L01P2:U=L00`000000R9KJ08RFfP0308RFfPT00000102<WMh00`000000RYoR08ZOhP06
08ZOhP0300000028X^D0R:;U00L0R:;U00<0000008NUj027YNP01`27YNP00`000000QJW/08FYk006
08FYk00300000023[?00Pjc`00L0Pjc`00<00000086`l`21/?<01P21/?<8000000D0R;Sf00<00000
08Jln026_?P01`26_?P00`000000Q<7k08C1n`0908C1n`0400000022a?d0P/Cm08;4o@T00000302:
b_d010000000RLgn08W=oP29cOh5000000<0TLkl00<00000093Ao@2@dOd02P2@dOd4000000T0Um;l
0P00000709ODo@<000000P2Md_X00`000000W=?k0000000909cCn`<00000302QdOT00`000000oooo
0?ooo`0B0?ooo`030000003oool000000100oooo00<000000?ooo`3oool00`3oool00`000000oooo
0?ooo`0@0?ooo`030000003oool0oooo00H0oooo000G0?ooo`8000000`3oool2000000D0oooo0P00
00040?ooo`800000103oool00`000000oooo0?ooo`080?ooo`030000003oool0oooo00L0oooo00<0
000009:@cP2BT<h01P2BT<h00`000000T93@092@d006092@d0030000002>TM80SY7B00D0SY7B00<0
000008bBe02<T]@01P2<T]@00`000000RYCG08ZDe`0508ZDe`H000001@2>V]/00`000000S9gN08bM
gP0508bMgP030000002:Wn80RYoR00L0RYoR00<0000008RRi@28X^D01`28X^D00`000000QjGX08NU
j00608NUj00300000025ZN`0QJW/00L0QJW/00<0000008>/l023[?001`23[?0010000000PK3c086`
l`21/?<4000000<0RKCb00<0000008RhmP28^?H02028^?H00`000000Q[ch08Jln00708Jln0800000
2024`O/500000080S<Kk0`00000408c6n`030000002:b_d0R/[m00T0R/[m10000009097>o0800000
1`2@dOd300000080V<ok00<0000009OBo02Gd_`02P2Gd_`00`000000UmCm09ODo@04000000H0WM;j
00<0000009cCn`0000001@2Ldo/300000080XM3h00<000000:7An@2QdOT02P2QdOT2000001D0oooo
00<000000?ooo`3oool03@3oool2000000D0oooo0P00000B0?ooo`030000003oool0oooo00D0oooo
000G0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0403oool00`000000oooo0?oo
o`070?ooo`030000003oool0oooo00P0oooo00<0000009:@cP2BT<h01@2BT<h00`000000T93@092@
d006092@d0030000002>TM80SY7B00H0SY7B00<0000008bBe02<T]@01@2<T]@010000000RYCG08ZD
e`2:U=L400000080SiWI00<0000008jJf`2>V]/01P2>V]/00`000000S9gN08bMgP0608bMgP030000
002:Wn80RYoR00L0RYoR00<0000008RRi@28X^D01P28X^D00`000000QjGX08NUj00708NUj0030000
0025ZN`0QJW/00L0QJW/00<0000008>/l023[?000`23[?07000000P0RKCb00<0000008RhmP28^?H0
2028^?H00`000000Q[ch08Jln00808Jln00400000024`O/0Q<7k08C1n`@000000`2=`oT4000000P0
S<Kk00<0000008[:o@2:b_d01@2:b_d300000080T/_k00<00000097>o02Ac_`02P2Ac_`00`000000
T=7m093Ao@04000000H0V<ok0P00000909OBo0@000002`2Md_X20000000309cCn`00000000000080
00001P2Qd?P00`000000XM7i0:7An@050:7An@@000000P2Tc?D00`000000oooo0?ooo`0C0?ooo`03
0000003oool0oooo00`0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`0@0?ooo`80
00001P3oool001H0oooo0P0000050?ooo`8000004P3oool00`000000oooo0?ooo`060?ooo`030000
003oool0oooo00P0oooo00<0000009:@cP2BT<h01P2BT<h00`000000T93@092@d006092@d0030000
002>TM80SY7B00D0SY7B00<0000008bBe02<T]@00`2<T]@6000000H0SiWI00<0000008jJf`2>V]/0
1`2>V]/00`000000S9gN08bMgP0608bMgP030000002:Wn80RYoR00H0RYoR00<0000008RRi@28X^D0
1`28X^D00`000000QjGX08NUj00708NUj00300000025ZN`0QJW/00<0QJW/2@00000508^ak`030000
0029]?80RKCb00P0RKCb00<0000008RhmP28^?H02028^?H00`000000Q[ch08Jln00408Jln0L00000
1@2=`oT4000000/0S<Kk00<0000008[:o@2:b_d01000000609;;n`030000002Ac_`0TLkl00T0TLkl
0`00000<09S?n`040000002Gd_`0Um;l09OBo0D000000`2Md?T00`000000WM;j09gBnP0909gBnP<0
00002`2Qd?P00`000000XM7i0:7An@04000000L0Y<ce00<000000?ooo`3oool04`3oool00`000000
oooo0?ooo`0:0?ooo`8000001`3oool200000140oooo0P0000060?ooo`005P3oool00`000000oooo
0?ooo`050?ooo`030000003oool0oooo0100oooo0P0000070?ooo`8000002P3oool00`000000TY3>
09:@cP0509:@cP030000002@T=00T93@00H0T93@00<0000008jAdP2>TM800`2>TM88000000@0TIOF
00<0000008nIf@2?VMT01P2?VMT00`000000SY[K08jJf`0708jJf`030000002<WMh0S9gN00D0S9gN
00<0000008ZOhP2:Wn801`2:Wn800`000000R:;U08RRi@0708RRi@0300000027YNP0QjGX00<0QjGX
2@00000508b]k0030000002;/Nl0Rk7_00L0Rk7_00<0000008VdlP29]?802029]?800`000000R;Sf
08RhmP0608RhmPP000001@2>_oL010000000SL?i08g3n@2=`oT3000000@0SL?i00<0000008c6n`2<
a_/01`2<a_/4000000/0T/_k00<00000097>o02Ac_`01@2Ac_`300000080V<gj00<0000009S?n`2H
co/02P2Hco/4000000T0WM3i00<0000009gBnP2Md_X01@2Md_X300000080XLkg0P00000:0:7@n0<0
00002`2Tc?D00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00X0oooo0P0000070?ooo`80
00004@3oool2000000H0oooo00040?ooo`d00000103oool2000000L0oooo0P00000A0?ooo`800000
1`3oool00`000000oooo0?ooo`090?ooo`030000002BT<h0TY3>00H0TY3>00<00000092@d02@T=00
1@2@T=06000000@0TYKD00<00000096GeP2AUmH01@2AUmH00`000000SiWI08nIf@0708nIf@030000
002>V]/0SY[K00H0SY[K00<0000008bMgP2<WMh01P2<WMh00`000000RYoR08ZOhP0708ZOhP030000
0028X^D0R:;U00<0R:;U2@00000508jYj0030000002<[N`0S:g/00L0S:g/00<0000008^ak`2;/Nl0
1P2;/Nl00`000000RKCb08VdlP0908VdlP0400000028^?H0R;Sf08RhmP@000000`2?^o@00`000000
S[og08jom`0808jom`<00000202=`oT010000000S<Kk08c6n`2<a_/5000000<0TlOi00<0000009;;
n`2Bbo/02P2Bbo/00`000000TLkl097>o004000000H0V<gj0P00000709S?n`<000000P2Mc_P00`00
0000WM3i09g@n@0909g@n@030000002Md_X0WM;j00@000001P2Qc_L2000000H0XM3h0`0000020:C<
m0030000002Tc?D0Y<ce00X0Y<ce00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`090?oo
o`8000001`3oool200000140oooo0P0000060?ooo`00103oool=000000@0oooo0P0000070?ooo`80
00004@3oool2000000L0oooo00<000000?ooo`3oool02P3oool00`000000TY3>09:@cP0509:@cP04
0000002@T=00T93@092@d0@0000000<0U9GA0000002BU]@01`2BU]@00`000000TIOF096GeP06096G
eP030000002?VMT0SiWI00H0SiWI00<0000008jJf`2>V]/01`2>V]/00`000000S9gN08bMgP0608bM
gP030000002:Wn80RYoR00D0RYoR1`00000508nWi@030000002>ZNP0SZWX00H0SZWX00<0000008b]
k02<[N`01`2<[N`00`000000Rk7_08^ak`0708^ak`0300000029]?80RKCb00L0RKCb1@00000808nk
m0030000002>_oL0S[og00@0S[og0`0000000`2>_oL0000008g3n@0708g3n@D000002@2CaoT20000
00T0T/_k1000000<09S=nP030000002Hco/0V<ok00@000001P2Mc_P00`000000WM3i09g@n@0809g@
n@<000002`2Qc_L00`000000XM3h0:7@n004000000H0Y<cd00<000000:C<m@2Tc?D02@2Tc?D20000
01<0oooo0`00000:0?ooo`8000001`3oool200000100oooo0`0000060?ooo`005@3oool2000000L0
oooo0P00000A0?ooo`8000001`3oool00`000000oooo0?ooo`0:0?ooo`030000002BT<h0TY3>00<0
TY3>1P00000609BEd@030000002BU]@0TYKD00H0TYKD00<00000096GeP2AUmH01P2AUmH00`000000
SiWI08nIf@0608nIf@030000002>V]/0SY[K00L0SY[K00<0000008bMgP2<WMh01@2<WMh010000000
RYoR08ZOhP2:Wn84000000<0T:CR00<0000008nWi@2?YnD01P2?YnD00`000000SZWX08jYj00708jY
j0030000002<[N`0S:g/00L0S:g/00<0000008^ak`2;/Nl01`2;/Nl010000000RKCb08VdlP29]?85
000000<0TKOa00<0000008nkm02?^o@01`2?^o@00`000000S[og08jom`0208jom`8000001@2>_oL0
10000000SL?i08g3n@2=`oT4000000<0U<Cg0P00000;09?7n@040000002Bbo/0T/_k09;;n`D00000
0`2Ib_P00`000000V<gj09S=nP0:09S=nP<000002P2Mc_P00`000000WM3i09g@n@0509g@n@<00000
0P2QcOH00`000000XLkg0:7>m`090:7>m`<000002`2Tc?@00`000000Y<ce0:C<m@050:C<m@<00000
0P2Vao400`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00P0oooo0P0000070?ooo`800000
3`3oool3000000L0oooo000E0?ooo`8000001`3oool200000100oooo0`0000060?ooo`030000003o
ool0oooo00`0oooo1@00000309JDd0030000002DUM40U9GA00H0U9GA00<0000009:Fe02BU]@01P2B
U]@00`000000TIOF096GeP06096GeP030000002?VMT0SiWI00L0SiWI00<0000008jJf`2>V]/01P2>
V]/00`000000S9gN08bMgP0308bMgPH000001`2@Y>800`000000SjOU08nWi@0708nWi@030000002>
ZNP0SZWX00L0SZWX00<0000008b]k02<[N`01`2<[N`00`000000Rk7_08^ak`0308^ak`L000002@2A
]o400`000000Sk_d08nkm00708nkm0@000001P2>_oL5000000T0U<Cg00<0000009?7n@2CaoT01`2C
aoT5000000T0VL[h0P00000709S=nP<000000P2MboL00`000000WLkh09g>n00909g>n0030000002M
d?T0WM3i00@000001P2QcOH00`000000XLkg0:7>m`050:7>m`<000000P2Tb_@00`000000Y<cd0:C<
m00:0:C<m0030000002Tc?D0Y<ce00@000001P2Vao400`000000oooo0?ooo`0B0?ooo`030000003o
ool0oooo00L0oooo0P0000070?ooo`8000003@3oool4000000P0oooo000E0?ooo`8000001`3oool2
000000l0oooo0`0000070?ooo`8000003@3oool00`000000UYC@09JDd00609JDd0030000002DUM40
U9GA00H0U9GA00<0000009:Fe02BU]@01P2BU]@00`000000TIOF096GeP06096GeP030000002?VMT0
SiWI00H0SiWI00<0000008jJf`2>V]/00`2>V]/9000000@0TJ7O00<00000092ThP2@Y>801`2@Y>80
0`000000SjOU08nWi@0708nWi@030000002>ZNP0SZWX00L0SZWX00<0000008b]k02<[N`01@2<[N`7
000000D0T[C^00<00000096gl@2A]o40202A]o400`000000Sk_d08nkm00508nkm0@000000`2>_oL5
000000<0UL3e00<0000009C4m`2Da?L02@2Da?L2000000<0TlOi1000000309W7m`030000002Ib_P0
VL[h00X0VL[h00<0000009S=nP2HcOX01000000609g;m`030000002Mc_P0WLkh00P0WLkh0`00000;
0:7=mP030000002Qc_L0XLkg00@000001P2Tb_@00`000000Y<cd0:C<m0090:C<m0<000002P2Vao40
0`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00H0oooo0P0000070?ooo`8000002P3oool6
000000T0oooo000E0?ooo`8000001`3oool2000000d0oooo100000080?ooo`030000003oool0oooo
00d0oooo00<0000009JDd02FU=001@2FU=000`000000U9GA09BEd@0609BEd@030000002BU]@0TYKD
00H0TYKD00<00000096GeP2AUmH01`2AUmH00`000000SiWI08nIf@0508nIf@H000001@2BWm`00`00
0000TJ7O096Qg`06096Qg`030000002@Y>80T:CR00H0T:CR00<0000008nWi@2?YnD0202?YnD00`00
0000SZWX08jYj00608jYj0040000002<[N`0S:g/08b]k0@000000`2B/N/00`000000T[C^09:dkP07
09:dkP030000002A]o40TKOa00P0TKOa00@0000008nkm02?^o@0Sk_d0`00000208nkm0D000002@2E
`?D00`000000U<Cg09C4m`0909C4m`@00000202IaoL00`000000VL[h09W:n00909W:n0<000002P2M
boL00`000000WLkh09g>n00509g>n0<000000P2QboH00`000000XLgf0:7=mP090:7=mP<000002P2T
b_@2000000L0Y<cd0`0000020:K7l@030000002Vao40Y/Oa00T0Y/Oa00<000000?ooo`3oool04P3o
ool00`000000oooo0?ooo`070?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool02P3o
ool3000000/0oooo000E0?ooo`8000001`3oool2000000X0oooo1P0000090?ooo`030000003oool0
oooo00d0oooo00<0000009JDd02FU=001P2FU=000`000000U9GA09BEd@0609BEd@030000002BU]@0
TYKD00H0TYKD00<00000096GeP2AUmH01P2AUmH010000000SiWI08nIf@2?VMT400000080U9gJ00<0
000009:Og02BWm`01P2BWm`00`000000TJ7O096Qg`07096Qg`030000002@Y>80T:CR00H0T:CR00<0
000008nWi@2?YnD01`2?YnD00`000000SZWX08jYj00308jYj0L00000202B/N/00`000000T[C^09:d
kP0709:dkP030000002A]o40TKOa00P0TKOa0`0000000`2?^o@0000000000002000000<0U[gb00<0
000009G0m@2E`?D02@2E`?D00`000000U<Cg09C4m`0509C4m`<000000P2Ja?D00`000000VLOg09W7
m`0809W7m`030000002Ib_P0VL[h00D0VL[h0`00000209k9mP030000002MboL0WL_g00T0WL_g00<0
000009g>n02Mc_P0100000060:7;mP8000001P2QcOH300000080Y<Wc00<000000:C:m02Tb_@02@2T
b_@200000080Y<cd100000060:K7l@030000002Vao40Y/Oa00P0Y/Oa0P00000D0?ooo`030000003o
ool0oooo00H0oooo0P0000050?ooo`800000303oool00`000000oooo0?ooo`0;0?ooo`005P3oool0
0`000000oooo0?ooo`050?ooo`030000003oool0oooo00X0oooo0`00000;0?ooo`030000003oool0
oooo00h0oooo00<0000009JDd02FU=001@2FU=000`000000U9GA09BEd@0609BEd@030000002BU]@0
TYKD00H0TYKD00<00000096GeP2AUmH00`2AUmH7000000H0U9gJ00<0000009:Og02BWm`01`2BWm`0
0`000000TJ7O096Qg`06096Qg`030000002@Y>80T:CR00L0T:CR00<0000008nWi@2?YnD01@2?YnD7
000000D0TjkX00<0000009:aj`2B/N/0202B/N/00`000000T[C^09:dkP0709:dkP030000002A]o40
TKOa00@0TKOa1`00000809JmlP030000002E`?D0UL3e00T0UL3e00<0000009C4m`2Da?L010000006
09[4m@030000002IaoL0VLOg00P0VLOg00<0000009W:n02Ib_P01000000609k9mP800000202MboL4
000000`0XL_f00<000000:7=mP2QcOH00`0000060:C9l`030000002Tb_@0Y<[d00T0Y<[d0`00000:
0:K7l@030000002Vao40Y/Oa00D0Y/Oa0`0000020:O2k@030000003oool0oooo0180oooo00<00000
0?ooo`3oool01P3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00`0oooo00<00000
0?ooo`3oool02P3oool001H0oooo0P0000050?ooo`800000303oool00`000000oooo0?ooo`0:0?oo
o`<000003`3oool00`000000UYC@09JDd00609JDd0030000002DUM40U9GA00H0U9GA00<0000009:F
e02BU]@01@2BU]@6000000D0UIcH00<0000009BMfP2DWMX01P2DWMX00`000000TYoL09:Og00609:O
g0030000002AXMl0TJ7O00L0TJ7O00<00000092ThP2@Y>801P2@Y>8010000000SjOU08nWi@2?YnD4
000000<0U:_U00<0000009>^j02C[^P01`2C[^P00`000000T[7[09:aj`0809:aj`030000002B]>h0
T[C^00L0T[C^00<00000096gl@2A]o401@00000309Njl0030000002F_O80U[gb00P0U[gb0P000008
09G0m@@000002`2Ja?D00`000000VLOg09W7m`0609W7m`@00000302NbOH010000000WL_g09g;m`2M
boL4000000<0XLWd00<000000:7;mP2QboH02P2QboH3000000X0Y<Wc00<000000:C:m02Tb_@01@2T
b_@3000000030:K6l0000000000000/0Y/Oa00<000000:K7l@2Vao40100000060:O2k@030000003o
ool0oooo00l0oooo0`0000080?ooo`8000000`3oool2000000h0oooo1P0000070?ooo`005`3oool0
0`000000oooo0?ooo`030?ooo`030000003oool0oooo00`0oooo00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0@0?ooo`030000002FU=00UYC@00D0UYC@00<0000009BEd@2DUM401P2DUM40
10000000TYKD09:Fe02BU]@400000080UY[F00<0000009FLf02EW=P01P2EW=P00`000000U9gJ09BM
fP0709BMfP030000002BWm`0TYoL00H0TYoL00<00000096Qg`2AXMl01`2AXMl00`000000T:CR092T
hP03092ThPH00000202DZnD00`000000TjkX09>^j00709>^j0030000002B/N/0T[7[00P0T[7[00<0
000009:dkP2B]>h00`2B]>h7000000P0Uk[`00<0000009JmlP2F_O802@2F_O8010000000UL3e09G0
m@2E`?D4000000<0V/7c00<0000009[4m@2Ja?D02P2Ja?D010000000VLOg09W7m`2IaoL4000000<0
W/Od00<0000009k9mP2NbOH02P2NbOH4000000P0XLWd0P0000070:7;mP<000000P2Tb?800`000000
Y<Wc0:C9l`090:C9l`030000002Tb_@0Y<[d00@00000102Va_000`000000Y/K`0000000:0:K7l@<0
00002P2W`^d00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo00L0oooo0`00000A0?ooo`H0
00001P3oool001L0oooo0P0000030?ooo`8000003P3oool6000000H0oooo00<000000?ooo`3oool0
403oool00`000000UYC@09JDd00609JDd0030000002DUM40U9GA00D0U9GA1000000609JJeP030000
002EW=P0UIcH00L0UIcH00<0000009BMfP2DWMX01P2DWMX00`000000TYoL09:Og00709:Og0030000
002AXMl0TJ7O00D0TJ7O1`00000409FXh`030000002DZnD0U:_U00P0U:_U00<0000009>^j02C[^P0
1`2C[^P00`000000T[7[09:aj`0609:aj`X000000P2G]nd00`000000Uk[`09Njl00809Njl0030000
002F_O80U[gb00L0U[gb1@00000809[1l`030000002Ja?D0V/Ce00T0V/Ce1000000809k7m0800000
1`2NbOH300000080X/Oc00<000000:79m02QbO@02@2QbO@00`000000XL_f0:7;mP04000000H0Y<Sb
00<000000:C9l`2TbO<0202TbO<3000000T0Y/K`0P0000070:K7l@<000000P2W`^d00`000000Yl;]
0:O2k@090:O2k@030000003oool0oooo0180oooo00<000000?ooo`3oool09P3oool001T0oooo0`00
000A0?ooo`H000001@3oool00`000000oooo0?ooo`0A0?ooo`030000002FU=00UYC@00D0UYC@00@0
000009BEd@2DUM40U9GA1000000209NId`030000002FV]H0UY[F00H0UY[F00<0000009FLf02EW=P0
1P2EW=P00`000000U9gJ09BMfP0709BMfP030000002BWm`0TYoL00H0TYoL00@00000096Qg`2AXMl0
TJ7O1000000309JVh0030000002EZ><0UJSS00H0UJSS00<0000009B[i@2DZnD01`2DZnD00`000000
TjkX09>^j00809>^j0040000002B/N/0T[7[09:aj`@000000`2H]>/4000000H0UkO]00<0000009Nj
l02G^_00202G^_0010000000U[gb09JmlP2F_O85000000<0Vkka00<0000009[1l`2J`O<0202J`O<0
0`000000V/Ce09[4m@0509[4m@<000000P2Na?<00`000000W/Od09k7m00909k7m0030000002NbOH0
W/Wf00@000001P2Rao<00`000000XLWd0:79m0080:79m0<000002P2Tb?800`000000Y<Wc0:C9l`05
0:C9l`<000000P2Va_000`000000Y/K`0:K6l0080:K6l08000000P2Vao44000000D0Yl;]00<00000
0:O2k@2W`^d02@2W`^d2000001<0oooo00<000000?ooo`3oool09P3oool003P0oooo0P00000B0?oo
o`030000002FU=00UYC@00<0UYC@1P00000609NId`030000002FV]H0UY[F00L0UY[F00<0000009FL
f02EW=P01P2EW=P00`000000U9gJ09BMfP0709BMfP030000002BWm`0TYoL00D0TYoL1000000709JV
h0030000002EZ><0UJSS00L0UJSS00<0000009B[i@2DZnD01`2DZnD00`000000TjkX09>^j00609>^
j0D000001P2H]>/3000000T0UkO]00<0000009Njl02G^_001P2G^_05000000T0Vkka00<0000009[1
l`2J`O<0202J`O<00`000000V/Ce09[4m@04000000H0W/Cc00<0000009k7m02Nao@0202Nao@30000
00X0X/Oc00<000000:79m02QbO@01@2QbO@300000080Y<Ob00<000000:C8lP2Tb?802@2Tb?800`00
0000Y<Wc0:C9l`04000000H0Y/K`00<000000:K6l02Va_00202Va_03000000X0Yl;]00<000000:O2
k@2W`^d01P2W`^d200000080YkgY00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0U0?oo
o`00>03oool00`000000oooo0?ooo`0B0?ooo`D00000102IV=800`000000UiWC09NId`0609NId`03
0000002FV]H0UY[F00H0UY[F00<0000009FLf02EW=P01`2EW=P00`000000U9gJ09BMfP0609BMfP04
0000002BWm`0TYoL09:Og0@000000P2GY=h00`000000UZKP09JVh00709JVh0030000002EZ><0UJSS
00H0UJSS00<0000009B[i@2DZnD0202DZnD010000000TjkX09>^j02C[^P4000000<0V;7X00<00000
09Rdj`2H]>/00P2H]>/300000080V;C[00<0000009Ngk@2G]nd0202G]nd010000000Uk[`09Njl02G
^_04000000<0Vkc_00<0000009^nl@2K__402@2K__400`000000V/7c09[1l`0609[1l`@000002`2N
a?<00`000000W/Od09k7m00409k7m0<000000P2Ra_800`000000X/Oc0:;7l`090:;7l`030000002Q
bO@0XLWd00@000001P2Tao800`000000Y<Sb0:C8lP080:C8lP<000002P2Va_000`000000Y/K`0:K6
l0050:K6l0@0000000<0Yl;]0000002W`^d02P2W`^d00`000000Yl;]0:O2k@020:O2k@<00000102W
_NT00`000000oooo0?ooo`0B0?ooo`030000003oool0oooo02@0oooo000h0?ooo`030000003oool0
oooo01<0oooo00<0000009VHdP2IV=801@2IV=800`000000UiWC09NId`0709NId`030000002FV]H0
UY[F00H0UY[F00<0000009FLf02EW=P01P2EW=P00`000000U9gJ09BMfP0309BMfPL000001P2GY=h0
0`000000UZKP09JVh00709JVh0030000002EZ><0UJSS00L0UJSS00<0000009B[i@2DZnD01P2DZnD5
000000L0V;7X00<0000009Rdj`0000000P00000609Rdj`030000002G]nd0UkO]00H0UkO]1@000008
09^lk`030000002K__40Vkka00T0Vkka00@0000009[1l`2J`O<0V/7c1000000309o2l@030000002N
a?<0W/Cc00X0W/Cc00<0000009k7m02Nao@00`0000060:;6lP030000002Rao<0X/Oc00P0X/Oc0`00
000:0:C7lP030000002Tb?80Y<Sb00D0Y<Sb0`0000020:K5k`030000002Va_00Y/K`00T0Y/K`00<0
00000:K6l02Va_00100000040:O2k@8000002`2W`^d00`000000Yl;]0:O2k@02000000P0YkgY00<0
00000?ooo`3oool0403oool2000002H0oooo000h0?ooo`030000003oool0oooo01<0oooo00<00000
09VHdP2IV=801P2IV=800`000000UiWC09NId`0609NId`030000002FV]H0UY[F00L0UY[F00<00000
09FLf02EW=P01@2EW=P6000000D0V:;K00<0000009NTgP2GY=h01P2GY=h00`000000UZKP09JVh007
09JVh0030000002EZ><0UJSS00L0UJSS00@0000009B[i@2DZnD0U:_U1000000309V^iP030000002H
/NP0V;7X00D0V;7X0`00000:09Rdj`040000002G]nd0UkO]09Ngk@@000000`2L^Nd00`000000Vkc_
09^lk`0809^lk`030000002K__40Vkka00P0Vkka1000000809o2l@030000002Na?<0W/Cc00T0W/Cc
0`00000:0:;6lP030000002Rao<0X/Oc00@0X/Oc0`0000020:C6l@030000002Tao80Y<Ob00T0Y<Ob
00<000000:C8lP2Tb?80100000060:K5k`030000002Va_00Y/K`00P0Y/K`0`0000090:O2k@800000
2P2W`^d3000000/0YkgY00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0S0?ooo`00=`3o
ool00`000000oooo0000000E0?ooo`030000002IV=80VISB00H0VISB00<0000009NId`2GVM<01P2G
VM<00`000000UY[F09JJeP0609JJeP040000002EW=P0UIcH09FLf0@000000P2IX=T00`000000V:;K
09RRf`0609RRf`030000002GY=h0UjCN00L0UjCN00<0000009JVh02FY^001`2FY^000`000000UJSS
09FXh`0509FXh`D000001`2I[^H00`000000V;7X09Raj00209Raj0<000000`2H/NP00`000000V;C[
09Rdj`0709Rdj`@00000202L^Nd00`000000Vkc_09^lk`0809^lk`030000002K__40Vkka00@0Vkka
0`00000209nok`030000002O`_40Wl;a00P0Wl;a00<0000009k4l`2Na?<01@2Na?<300000080X/Ca
00<000000:;6lP2Ra_802@2Ra_800`000000X/Oc0:;7l`03000000H0Y<Ka00<000000:C7lP2Tao80
202Tao83000000/0Y/G_00<000000:K6l02Va_00102Va_0300000080Yl;]00<000000:O2k@2W`^d0
1`2W`^d00`000000Yl;]000000060:O2k@<000000P2W_NT00`000000YkgY0:Nmj@090:Nmj@030000
003oool0oooo0140oooo00<000000?ooo`3oool08`3oool002P0oooo1000000;0?ooo`8000005P3o
ool00`000000VISB09VHdP0609VHdP030000002GVM<0UiWC00L0UiWC00<0000009JJeP2FV]H01@2F
V]H4000000H0VJ3I00<0000009RRf`2HX]/01`2HX]/00`000000UjCN09NTgP0709NTgP030000002F
Y^00UZKP00H0UZKP00@0000009FXh`2EZ><0UJSS1000000309Z/h`030000002I[^H0VJkV00L0VJkV
1000000709Raj0030000002H]>/0V;C[00<0V;C[0`00000209bfj`030000002L^Nd0W;W]00L0W;W]
00<0000009^lk`2K_>l02@2K_>l00`000000Vkka09^nl@03000000H0Wko_00<0000009o2l@2O`_40
202O`_400`000000W/Cc09k4l`04000000H0X/Ca00<000000:;6lP2Ra_80202Ra_83000000X0Y<Ka
00<000000:C7lP2Tao80102Tao8300000080Y/C_00<000000:K5k`2VaNl02P2VaNl00`000000Y/K`
0:K6l003000000D0Yl;]00<000000:O2k@2W`^d0202W`^d200000080Yl;]100000060:Nmj@030000
002W_NT0YkgY00P0YkgY0P00000C0?ooo`030000003oool0oooo0280oooo000W0?ooo`8000000`3o
ool2000000T0oooo00<000000?ooo`3oool05P3oool00`000000VISB09VHdP0609VHdP030000002G
VM<0UiWC00H0UiWC00@0000009JJeP2FV]H0UY[F1000000209ZOe`030000002IX=T0VJ3I00H0VJ3I
00<0000009RRf`2HX]/01P2HX]/00`000000UjCN09NTgP0709NTgP030000002FY^00UZKP00H0UZKP
1000000809Z/h`030000002I[^H0VJkV00@0VJkV1000000909Raj0030000002H]>/0V;C[00<00000
1P2L]^/00`000000W;W]09bik@0709bik@030000002K_>l0Vkc_00L0Vkc_1000000:09nok`030000
002O`_40Wl;a00H0Wl;a1000000:0:;4l@030000002Ra_80X/Kb00D0X/Kb0`0000020:C4l0030000
002Ta_40Y<Ka00T0Y<Ka00<000000:C7lP2Tao800`0000060:K4k`030000002VaNl0Y/G_00T0Y/G_
0`0000090:O2k@030000002W`^d0Yl;]00P0Yl;]0`00000:0:Nmj@030000002W_NT0YkgY00D0YkgY
0`0000020:Nhi@030000003oool0oooo0140oooo00<000000?ooo`3oool08@3oool002L0oooo00<0
00000?ooo`3oool00`3oool00`000000oooo0?ooo`070?ooo`030000003oool0oooo01L0oooo00<0
000009VHdP2IV=801P2IV=800`000000UiWC09NId`0509NId`@000001P2JWmL00`000000VJ3I09VP
f@0709VPf@030000002HX]/0V:;K00H0V:;K00<0000009NTgP2GY=h01`2GY=h010000000UZKP09JV
h02FY^0400000080VZ[Q00<0000009Z/h`2J[><0202J[><00`000000VJkV09V^iP03000000@0VJkV
00<0000009Raj02H/NP01@2H/NP4000000T0W;K[00<0000009bik@2L^Nd0202L^Nd010000000Vkc_
09^lk`2K_>l5000000<0Wkg^00<0000009nok`2O_nl02@2O_nl010000000Wl;a09o2l@2O`_440000
00<0X/;_00<000000:;4l@2Ra?402@2Ra?400`000000X/Kb0:;6lP04000000H0Y<C`00<000000:C6
l@2Ta_40202Ta_43000000X0Y/C_00<000000:K5k`2VaNl01@2VaNl300000080Yl;]00<000000:O2
k@2W`^d0202W`^d00`000000Yl;]0:O2k@040:O2k@<0000000<0YkkY0000000000002`2W_NT00`00
0000YkgY0:Nmj@04000000D0YkSU00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0Q0?oo
o`009P3oool2000000D0oooo0P0000080?ooo`030000003oool0oooo01L0oooo00<0000009VHdP2I
V=801P2IV=8010000000UiWC09NId`2GVM<400000080VYgF00<0000009ZOe`2JWmL01P2JWmL00`00
0000VJ3I09VPf@0609VPf@030000002HX]/0V:;K00L0V:;K00<0000009NTgP2GY=h01@2GY=h50000
00L0VZ[Q00<0000009Z/h`2J[><01`2J[><3000000L0VJkV00@0000009Raj02H/NP0V;7X10000003
09fdj0030000002L]^/0W;K[00P0W;K[00<0000009bik@2L^Nd01P2L^Nd5000000T0Wkg^00<00000
09nok`2O_nl0202O_nl4000000P0X/;_00<000000:;4l@2Ra?40202Ra?43000000/0Y<C`00<00000
0:C6l@2Ta_40102Ta_4300000080Y/?^00<000000:K4k`2Va>l02@2Va>l00`000000Y/G_0:K5k`04
000000D0Yl;]00<000000:O2k@2W`^d0202W`^d00`000000Yl;]0:O2k@04000000@0YkkY00<00000
0:Nnj@0000002P2W_NT3000000X0YkSU00<000000?ooo`3oool0403oool200000280oooo000V0?oo
o`030000003oool0oooo00D0oooo00<000000?ooo`3oool01P3oool2000001T0oooo00<0000009VH
dP2IV=801@2IV=84000000H0VYgF00<0000009ZOe`2JWmL01`2JWmL00`000000VJ3I09VPf@0609VP
f@030000002HX]/0V:;K00H0V:;K00@0000009NTgP2GY=h0UjCN1000000309^Xg`030000002JZ^40
VZ[Q00L0VZ[Q00<0000009Z/h`2J[><00`2J[><30000000309Z/h`000000VJkV00L0VJkV10000008
09fdj0030000002L]^/0W;K[00P0W;K[00@0000009bik@2L^Nd0W;W]1000000309nkk0030000002O
_Nh0Wkg^00T0Wkg^00<0000009nok`2O_nl0102O_nl300000080X/3^00<000000:;2k`2R`^l0202R
`^l00`000000X/Ca0:;4l@040:;4l@<000000P2T`nl00`000000Y<C`0:C4l00:0:C4l0030000002T
a_40Y<Ka00<000001P2V`nh00`000000Y/C_0:K4k`080:K4k`<000002P2W`^d00`000000Yl;]0:O2
k@070:O2k@<000002@2W_^T2000000L0YkgY0`0000020:NiiP030000002W^>D0YkSU00P0YkSU00<0
00000?ooo`3oool04P3oool00`000000oooo0?ooo`0O0?ooo`009@3oool2000000L0oooo0P000006
0?ooo`8000006P3oool010000000VISB09VHdP2IV=8400000080VigD00<0000009ZMeP2JWMH01P2J
WMH00`000000VYoG09ZOe`0609ZOe`030000002IX=T0VJ3I00L0VJ3I00<0000009RRf`2HX]/01@2H
X]/4000000L0VjSO00<0000009ZZh@2JZ^401`2JZ^4010000000VZcS09Z/h`2J[><2000000D0VZcS
00@0000009V^iP2I[^H0VJkV1000000209faiP030000002M]>P0WKCX00P0WKCX00<0000009bfj`2L
]^/01`2L]^/4000000P0Wk_/00<0000009nmkP2O_Nh02@2O_Nh00`000000Wko_09nok`03000000H0
X/3^00<000000:;2k`2R`^l0202R`^l00`000000X/Ca0:;4l@03000000H0Y<?_00<000000:C4l02T
a?002@2Ta?03000000T0Y/?^00<000000:K4k`2Va>l01@2Va>l300000080Yl7/00<000000:O2k@2W
`^d02@2W`^d00`000000Yl;]0:O2k@030:O2k@<000000P2W_^T00`000000YkkY0:Nnj@080:Nnj@80
00000P2W_NT4000000D0YkWV00<000000:Nhi@2W^>D02@2W^>D00`000000oooo0?ooo`0A0?ooo`03
0000003oool0oooo01l0oooo000U0?ooo`8000001`3oool2000000H0oooo00<000000?ooo`3oool0
6P3oool3000000H0VigD00<0000009ZMeP2JWMH01P2JWMH00`000000VYoG09ZOe`0709ZOe`030000
002IX=T0VJ3I00H0VJ3I00@0000009RRf`2HX]/0V:;K1000000209^Vg@030000002KZ=l0VjSO00L0
VjSO00<0000009ZZh@2JZ^401`2JZ^43000000H0VZcS1@00000709faiP030000002M]>P0WKCX00P0
WKCX00<0000009bfj`2L]^/0102L]^/200000080X;WZ00<0000009nkk02O^n`0202O^n`00`000000
Wkg^09nmkP0809nmkP<000002@2R`>h00`000000X/;_0:;2k`080:;2k`<000002P2T`nl00`000000
Y<C`0:C4l0050:C4l0<000000P2V`nh00`000000Y/?^0:K3kP080:K3kP030000002Va>l0Y/C_00@0
00001@2W`N`00`000000Yl;]0:O2k@090:O2k@030000002W`^d0Yl;]00<000001P2W_^T00`000000
YkkY0:Nnj@080:Nnj@<000002P2W^NH00`000000YkSU0:Nhi@080:Nhi@030000003oool0oooo0180
oooo00<000000?ooo`3oool07P3oool002D0oooo0P0000070?ooo`8000001P3oool00`000000oooo
0?ooo`0K0?ooo`030000002KWM@0VigD00H0VigD00<0000009ZMeP2JWMH01P2JWMH00`000000VYoG
09ZOe`0709ZOe`030000002IX=T0VJ3I00D0VJ3I1000000709^Vg@030000002KZ=l0VjSO00L0VjSO
00<0000009ZZh@2JZ^400`2JZ^430000000309ZZh@000000VZcS0080VZcS1000000309f_i0030000
002M/NH0WK7V00L0WK7V00<0000009fdj02M]>P0202M]>P00`000000W;K[09bfj`03000000D0X;WZ
00<0000009nkk02O^n`0202O^n`00`000000Wkg^09nmkP0409nmkP<000000P2R_^d00`000000X/3^
0:;0kP080:;0kP030000002R`^l0X/;_00@0X/;_0`0000020:C2kP030000002T`nl0Y<?_00T0Y<?_
00<000000:C4l02Ta?00100000060:K3kP030000002V`nh0Y/?^00L0Y/?^0`00000:0:O1k0030000
002W`^d0Yl;]00P0Yl;]0`00000:0:Nnj@030000002W_^T0YkkY00@0YkkY100000000`2W^NH00000
0:NiiP090:NiiP030000002W^>D0YkSU00P0YkSU0P00000D0?ooo`030000003oool0oooo0100oooo
1P0000070?ooo`009@3oool2000000L0oooo0P0000060?ooo`030000003oool0oooo01/0oooo00<0
000009^Me02KWM@01P2KWM@00`000000VYgF09ZMeP0609ZMeP030000002JWmL0VYoG00L0VYoG00@0
000009VPf@2IX=T0VJ3I1000000209bTf`030000002KY]d0VjKM00L0VjKM00<0000009^Xg`2KZ=l0
1`2KZ=l00`000000VZ[Q00000002000000<0VZ[Q1@00000809f_i0030000002M/NH0WK7V00L0WK7V
00<0000009fdj02M]>P01P2M]>P4000000T0X;WZ00<0000009nkk02O^n`0202O^n`00`000000Wkg^
09nmkP03000000H0X[k]00<000000:;0kP2R`>h0202R`>h00`000000X/;_0:;2k`03000000H0Y<;^
00<000000:C3k`2T`nl0202T`nl3000000X0Y/?^00<000000:K3kP2V`nh0102V`nh300000080Yl7/
00<000000:O1k02W`N`02@2W`N`00`000000Yl;]0:O2k@040:O2k@<000000P2W_^X00`000000YkkY
0:Nnj@090:Nnj@030000002W_^T0YkkY00<00000102W^NH2000000/0YkWV00<000000:Nhi@2W^>D0
102W^>D300000080YkCR00<000000?ooo`3oool04@3oool00`000000oooo0?ooo`0B0?ooo`800000
2@3oool002D0oooo0P0000070?ooo`8000001P3oool2000001d0oooo00<0000009^Me02KWM@01P2K
WM@00`000000VYgF09ZMeP0609ZMeP030000002JWmL0VYoG00D0VYoG1@00000609bTf`030000002K
Y]d0VjKM00L0VjKM00<0000009^Xg`2KZ=l01P2KZ=l300000080VZ[Q1000000309j]hP030000002M
[n@0WJoT00L0WJoT00<0000009faiP2M/NH0202M/NH010000000WKCX09fdj02M]>P4000000<0X;OX
00<000000:2ijP2P^NX0202P^NX00`000000Wk_/09nkk00609nkk0@000002P2R_^d00`000000X/3^
0:;0kP060:;0kP@000002P2T`^h00`000000Y<?_0:C3k`040:C3k`<000000P2V`^d00`000000Y/?^
0:K3kP090:K3kP030000002V`nh0Y/?^00<000001P2W`N`00`000000Yl7/0:O1k0080:O1k0030000
002W`^d0Yl;]00@000001P2W_^X00`000000YkkY0:Nnj@080:Nnj@<00000202W^NH2000000X0YkWV
00<000000:Nhi@2W^>D0100000050:NdhP030000003oool0oooo0140oooo0P00000C0?ooo`800000
2@3oool002D0oooo0P0000070?ooo`8000001P3oool00`000000oooo0?ooo`0L0?ooo`030000002K
WM@0VigD00H0VigD00<0000009ZMeP2JWMH01P2JWMH010000000VYoG09ZOe`2JWmL4000000<0WJ?I
00<0000009bTf`2LY=/01P2LY=/00`000000VjKM09^Vg@0709^Vg@030000002KZ=l0VjSO0080VjSO
0`0000000`2KZ=l0000000000002000000L0WZgR00<0000009f_i02M[n@0202M[n@00`000000WK7V
09faiP0609faiPD00000202P]nP00`000000X;WZ0:2ijP080:2ijP040000002O^n`0Wk_/09nkk0@0
00000`2R_>`00`000000X[k]0::nk@090::nk@040000002R`>h0X/3^0:;0kP@000000`2U`>d00`00
0000Y<;^0:C2kP090:C2kP030000002T`nl0Y<?_00<000001P2V`^d00`000000Y/?^0:K3kP080:K3
kP<000002@2W`N`00`000000Yl7/0:O1k0080:O1k0<000002P2W_^X00`000000YkkY0:Nnj@050:Nn
j@<000000P2W^^L00`000000YkWV0:NiiP070:NiiP030000002W^NH0YkWV00P0YkWV0`00000:0:Nd
hP030000003oool0oooo0180oooo00<000000?ooo`3oool0403oool2000000T0oooo000U0?ooo`80
00001`3oool2000000H0oooo00<000000?ooo`3oool07@3oool00`000000VigD09^Me00609^Me003
0000002JWMH0VYgF00D0VYgF1000000709fSf@030000002LY=/0W:CK00L0W:CK00<0000009^Vg@2K
Y]d01`2KY]d800000080WZcQ00<0000009j]hP2N[N801`2N[N800`000000WJoT09f_i00809f_i004
0000002M/NH0WK7V09faiP@000000`2P]>L00`000000X;OX0:2gj0070:2gj0030000002P^NX0X;WZ
00P0X;WZ100000080::lk0030000002R_^d0X[k]00P0X[k]100000080:G0k@030000002T`^h0Y<;^
00P0Y<;^0`00000:0:K2k@030000002V`nh0Y/?^00@0Y/?^0`0000020:O1k0030000002W`N`0Yl7/
00P0Yl7/00<000000:O1k02W`N`0102W`N`300000080YkkZ00<000000:NnjP2W_^X02@2W_^X00`00
0000YkkY0:Nnj@04000000D0Yk[W00<000000:NiiP2W^NH01`2W^NH2000000H0YkWV0`0000020:Nd
h`030000002W]>80YkCR00P0YkCR00<000000?ooo`3oool04P3oool00`000000oooo0?ooo`0@0?oo
o`8000002@3oool002H0oooo00<000000?ooo`3oool01@3oool00`000000oooo0?ooo`040?ooo`03
0000003oool0oooo01h0oooo00<0000009^Me02KWM@01P2KWM@010000000VYgF09ZMeP2JWMH40000
0080WJ;H00<0000009fSf@2MXmT01`2MXmT00`000000W:CK09bTf`0709bTf`030000002KY]d0VjKM
00@0VjKM1P00000709j/h@030000002N[N80WZgR00L0WZgR00<0000009f_i02M[n@01`2M[n@40000
00P0X;CW00<000000:2gj02P]nP01`2P]nP00`000000X;WZ0:2ijP040:2ijP<000000P2S^nX00`00
0000X[c/0::lk0080::lk0030000002R_^d0X[k]00@0X[k]0`0000020:Fok0030000002U`>d0YL3]
00P0YL3]00<000000:C2kP2T`^h0102T`^h300000080Y/7]00<000000:K2k@2V`^d02@2V`^d00`00
0000Y/?^0:K3kP03000000H0Yl7/00<000000:O1k02W`N`0202W`N`00`000000Yl7/0:O1k0030000
00H0YkkZ00<000000:NnjP2W_^X0202W_^X3000000X0Yk[W00<000000:NiiP2W^NH01`2W^NH00`00
0000YkWV0:NiiP04000000D0YkCS00<000000:NdhP2W]>802@2W]>800`000000oooo0?ooo`0B0?oo
o`030000003oool0oooo00l0oooo0P0000090?ooo`009P3oool2000000D0oooo0P0000060?ooo`80
0000803oool00`000000VigD09^Me00509^Me0@000001P2MX]P00`000000WJ?I09fSf@0709fSf@03
0000002LY=/0W:CK00L0W:CK00@0000009^Vg@2KY]d0VjKM1000000309jZg`030000002N[>40WZcQ
00L0WZcQ00<0000009j]hP2N[N801`2N[N800`000000WJoT09f_i00309f_i0<000000P2Q/nD00`00
0000X;CW0:2di`070:2di`030000002P]nP0X;OX00P0X;OX00<000000:2ijP2P^NX00`0000060:>k
jP030000002R_>`0X[c/00P0X[c/00<000000::nk@2R_^d00`0000060:Fok0030000002U`>d0YL3]
00P0YL3]00<000000:C2kP2T`^h00`0000060:K1k@030000002V`^d0Y/;]00P0Y/;]0`0000090:O1
k0030000002W`N`0Yl7/00P0Yl7/0`00000:0:NnjP030000002W_^X0YkkZ00@0YkkZ0`0000020:Nk
i`030000002W^^L0Yk[W00P0Yk[W00<000000:NiiP2W^NH01`2W^NH3000000X0YkCS00<000000:Nd
hP2W]>80202W]>800`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00h0oooo0P0000090?oo
o`009`3oool00`000000oooo0?ooo`030?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3o
ool07`3oool010000000VigD09^Me02KWM@400000080WZ7G00<0000009fRf02MX]P01P2MX]P00`00
0000WJ?I09fSf@0709fSf@030000002LY=/0W:CK00H0W:CK1000000709jZg`030000002N[>40WZcQ
00L0WZcQ00<0000009j]hP2N[N801`2N[N800`000000WJoT09f_i003000000D0XK?U00<000000:2d
i`2P]>L0202P]>L00`000000X;OX0:2gj0060:2gj0@000002@2S^nX00`000000X[c/0::lk0080::l
k0<000002@2U_n`00`000000YL3]0:G0k@080:G0k@<000002P2V`Nd00`000000Y/;]0:K2k@040:K2
k@<000000P2W`N`00`000000Yl7/0:O1k0080:O1k0030000002W`N`0Yl7/00@0Yl7/0`0000020:Nn
jP030000002W_^X0YkkZ00T0YkkZ00<000000:NnjP2W_^X00`0000050:Nki`030000002W^^L0Yk[W
00T0Yk[W00<000000:NiiP2W^NH00`2W^NH300000080YkGS00<000000:Ndh`2W]><02@2W]><00`00
0000YkCR0:NdhP060:NdhP<00000503oool00`000000oooo0?ooo`0>0?ooo`8000002@3oool002L0
oooo0P0000030?ooo`8000001`3oool00`000000oooo0?ooo`0P0?ooo`<000001P2NXML00`000000
WJ;H09fRf00709fRf0030000002MXmT0WJ?I00L0WJ?I00<0000009bTf`2LY=/00`2LY=/300000003
09nXg@000000WZ[O00P0WZ[O00<0000009j/h@2N[>401`2N[>400`000000WZgR09j]hP0609j]hP<0
00002@2Q/nD00`000000X;CW0:2di`080:2di`040000002P]nP0X;OX0:2gj0@000000`2S^NT00`00
0000Xk_Z0:>kjP080:>kjP030000002R_>`0X[c/00@0X[c/0`0000020:Fnj`030000002U_n`0YKo/
00P0YKo/00<000000:G0k@2U`>d0102U`>d300000080Y/3/00<000000:K1k@2V`Nd02@2V`Nd00`00
0000Y/;]0:K2k@03000000D0Yl7/00<000000:O1k02W`N`02@2W`N`00`000000Yl7/0:O1k0030000
00H0YkkZ00<000000:NnjP2W_^X0202W_^X3000000T0Yk_W00<000000:Nji`2W^^L0202W^^L00`00
0000YkWV0:NiiP03000000D0YkGS00<000000:Ndh`2W]><02@2W]><010000000YkCR0:NdhP2W]>85
000000<0YZoN00<000000?ooo`3oool04@3oool2000000l0oooo0P0000090?ooo`00:@3oool30000
00T0oooo00<000000?ooo`3oool08@3oool00`000000WZ7G09jQe`0609jQe`030000002MX]P0WJ;H
00L0WJ;H00<0000009fSf@2MXmT01P2MXmT00`000000W:CK09bTf`04000000<0WjSM00<0000009jZ
g`2NZ]l0202NZ]l00`000000WZcQ09j/h@0709j/h@040000002N[N80WZgR09j]hP@000000P2Q/N<0
0`000000XK?U0:6ci@080:6ci@030000002P]>L0X;CW00L0X;CW100000080:>ij@030000002S^nX0
Xk_Z00P0Xk_Z00<000000::lk02R_>`00`0000060:Fnj`030000002U_n`0YKo/00P0YKo/00<00000
0:G0k@2U`>d00`0000060:K0k0030000002V`Nd0Y/7]00P0Y/7]0`0000090:O1k0030000002W`N`0
Yl7/00P0Yl7/0`0000090:NnjP030000002W_^X0YkkZ00D0YkkZ0`0000020:Nkj0030000002W^nL0
Yk_W00P0Yk_W00<000000:Nji`2W^^L01P2W^^L4000000T0YkGS00<000000:Ndh`2W]><0202W]><4
000000P0YZoN00<000000?ooo`3oool04`3oool00`000000oooo0?ooo`0<0?ooo`8000002@3oool0
03D0oooo00<000000?ooo`3oool08@3oool00`000000WZ7G09jQe`0709jQe`030000002MX]P0WJ;H
00H0WJ;H00<0000009fSf@2MXmT01P2MXmT4000000L0WjSM00<0000009jZg`2NZ]l0202NZ]l00`00
0000WZcQ09j/h@0509j/h@D000001`2Q/N<00`000000XK?U0:6ci@080:6ci@030000002P]>L0X;CW
00<0X;CW0`0000020:>gi`030000002S^NT0XkWY00P0XkWY00<000000:>kjP2S^nX01P2S^nX40000
00X0YKk[00<000000:Fok02U_n`01P2U_n`4000000X0Y/3/00<000000:K1k@2V`Nd0102V`Nd30000
0080Yl3/00<000000:O1k02W`N`0202W`N`00`000000Yl7/0:O1k0040:O1k0<000000P2W_nX00`00
0000YkkZ0:NnjP080:NnjP030000002W_^X0YkkZ00@000001@2W^nP00`000000Yk_W0:Nki`080:Nk
i`040000002W^^L0Yk[W0:Nji`D000000`2W]^@00`000000YkGS0:Neh`080:Neh`030000002W]><0
YkCS00@0YkCS0`0000000`2V/=l000000:J_gP0:0:J_gP030000003oool0oooo0180oooo00<00000
0?ooo`3oool0303oool2000000T0oooo000d0?ooo`800000903oool00`000000WZ7G09jQe`0709jQ
e`030000002MX]P0WJ;H00H0WJ;H00@0000009fSf@2MXmT0WJ?I1@0000000`2OYm`0000009nXg@08
09nXg@030000002NZ]l0WZ[O00L0WZ[O00@0000009j/h@2N[>40WZcQ100000030:6_hP030000002Q
/N<0XK7S00L0XK7S00<000000:6ci@2Q/nD01`2Q/nD00`000000X;CW0:2di`03000000H0XkOW00<0
00000:>ij@2S^NT0202S^NT010000000Xk_Z0:>kjP2S^nX4000000<0YKcZ00<000000:Fnj`2U_^/0
2@2U_^/010000000YKo/0:Fok02U_n`4000000<0Y[o/00<000000:K0k02V`>`02@2V`>`00`000000
Y/7]0:K1k@03000000H0Yl3/00<000000:O1k02W`N`01`2W`N`00`000000Yl7/0:O1k004000000H0
YkoZ00<000000:NnjP2W_^X01`2W_^X3000000X0Yk_X00<000000:Nki`2W^nL01`2W^nL4000000P0
YkKT00<000000:Neh`2W]N<0202W]N<00`000000YkCS0:Ndh`04000000D0Y[3O00<000000:J_gP2V
[mh0202V[mh00`000000oooo0?ooo`0C0?ooo`030000003oool0oooo00/0oooo0P0000090?ooo`00
=03oool00`000000oooo0?ooo`0T0?ooo`030000002NXML0WZ7G00H0WZ7G00<0000009fRf02MX]P0
1P2MX]P6000000D0WjOL00<0000009nXg@2OZ=d01`2OZ=d00`000000WZ[O09jZg`0609jZg`@00000
1`2Q[n800`000000XK7S0:6ah`080:6ah`030000002Q/nD0XK?U00H0XK?U0`0000090:>gi`030000
002S^NT0XkWY00P0XkWY100000080:FljP030000002U_^/0YKk[00P0YKk[100000080:Jok0030000
002V`>`0Y/3/00P0Y/3/0`0000090:O0k0030000002W`N`0Yl7/00H0Yl7/1000000:0:NojP030000
002W_^X0YkkZ00@0YkkZ0`0000020:Nlj0030000002W^nP0Yk_X00T0Yk_X00<000000:Nki`2W^nL0
0`2W^nL300000080YkOU00<000000:Nfi02W]^@0202W]^@00`000000YkGS0:Neh`070:Neh`<00000
2@2V/=l00`000000YZoN0:J_gP090:J_gP030000003oool0oooo01<0oooo00<000000?ooo`3oool0
2P3oool2000000T0oooo000d0?ooo`030000003oool0oooo02D0oooo00<0000009jQe`2NXML01P2N
XML010000000WJ;H09fRf02MX]P7000000T0WjOL00<0000009nXg@2OZ=d01P2OZ=d00`000000WZ[O
09jZg`0409jZg`8000000P2Q[^400`000000XJoR0:6_hP070:6_hP030000002Q/N<0XK7S00P0XK7S
00@000000:6ci@2Q/nD0XK?U100000020:>fiP030000002S]nL0XkOW00P0XkOW00<000000:>ij@2S
^NT0102S^NT300000080YK_Y00<000000:FljP2U_>X0202U_>X00`000000YKk[0:Fnj`040:Fnj`<0
00000P2V_n/00`000000Y[o/0:Jok0080:Jok0030000002V`>`0Y/3/00@0Y/3/0`0000020:O0j`03
0000002W`>`0Yl3/00P0Yl3/00@000000:O1k02W`N`0Yl7/100000030:Noj`030000002W_nX0YkoZ
00T0YkoZ00<000000:NnjP2W_^X00`0000060:Nlj0030000002W^nP0Yk_X00P0Yk_X00<000000:Nk
i`2W^nL00`0000050:Ngi@030000002W]^@0YkKT00T0YkKT00<000000:Neh`2W]N<00`2W]N<30000
0080Y[7P00<000000:J`g`2V/=l0202V/=l00`000000YZoN0:J_gP080:J_gP030000003oool0oooo
01<0oooo00<000000?ooo`3oool02P3oool2000000T0oooo000d0?ooo`030000003oool0oooo02D0
oooo00<0000009jQe`2NXML01P2NXML4000000040:2VfP000000000000000080X:KJ00<0000009nW
g02OYm`01`2OYm`00`000000WjSM09nXg@0709nXg@030000002NZ]l0WZ[O00<000001@2Q[^400`00
0000XJoR0:6_hP070:6_hP030000002Q/N<0XK7S00L0XK7S100000070:>fiP030000002S]nL0XkOW
00P0XkOW00<000000:>ij@2S^NT00`0000060:Fkj@030000002U_>X0YKcZ00P0YKcZ00<000000:Fn
j`2U_^/00`0000060:Joj`030000002V_n`0Y[o/00P0Y[o/00<000000:K0k02V`>`00`0000060:O0
j`030000002W`>`0Yl3/00L0Yl3/100000080:Noj`030000002W_nX0YkoZ00P0YkoZ0`0000090:Nl
j0030000002W^nP0Yk_X00P0Yk_X0`0000090:Ngi@030000002W]^@0YkKT00P0YkKT00<000000:Ne
h`2W]N<00`0000050:Jah08000002@2V/=l00`000000YZoN0:J_gP080:J_gP8000004`3oool30000
00/0oooo0P0000090?ooo`004@3oool4000000L0oooo0P0000050?ooo`D00000303oool3000002H0
oooo00@0000009jQe`2NXML0WZ7G100000020:2Uf@<000001P2PY]X00`000000WjOL09nWg00709nW
g0030000002OZ=d0WjSM00H0WjSM0`0000090:6^h@030000002Q[n80XJoR00L0XJoR00<000000:6a
h`2Q/N<00`2Q/N<300000080XkCU00<000000:>fiP2S]^H01`2S]^H00`000000XkOW0:>gi`070:>g
i`<000002@2U^nT00`000000YKcZ0:FljP080:FljP<000002@2V_n/00`000000Y[o/0:Jok0080:Jo
k0<000002@2W`>/00`000000Yl3/0:O0k0040:O0k0<000000P2W_n/00`000000Yko[0:Noj`080:No
j`030000002W_nX0YkoZ00@0YkoZ0`0000020:Nmj@030000002W_>P0YkcX00P0YkcX00<000000:Nk
j02W^nP0102W^nP300000080Y[SV00<000000:Ngi@2W]nD0202W]nD00`000000YkKT0:Nfi0070:Nf
i0<000002@2V/N000`000000Y[3O0:J`g`080:J`g`030000002V[mh0YZoN00@0YZoN0`0000020:B[
f`030000003oool0oooo00d0oooo100000000`3oool000000?ooo`070?ooo`D000002@3oool00100
oooo0P0000030?ooo`8000001@3oool2000000@0oooo0P0000040?ooo`030000003oool0oooo00P0
oooo0P00000Y0?ooo`<000000`2PYMT4000000T0X:KJ00<0000009nWg02OYm`01`2OYm`010000000
WjSM09nXg@2OZ=d400000080XZgO00<000000:6^h@2Q[^401`2Q[^400`000000XJoR0:6_hP070:6_
hP030000002Q/N<0XK7S00<000001P2S]>D00`000000XkKV0:>fiP070:>fiP030000002S]nL0XkOW
00@0XkOW0P0000020:Fjj0030000002U^nT0YK_Y00P0YK_Y00<000000:FljP2U_>X0102U_>X30000
0080Y[kZ00<000000:Joj`2V_n/0202V_n/00`000000Y[o/0:Jok0040:Jok0<000000P2W`>/00`00
0000Yl3[0:O0j`080:O0j`030000002W`>`0Yl3/00<000001P2W_n/00`000000Yko[0:Noj`080:No
j`030000002W_nX0YkoZ00<000001P2W_NT00`000000YkcX0:Nlj0080:Nlj0030000002W^nP0Yk_X
00<000001@2V^>H00`000000YkOU0:Ngi@090:Ngi@030000002W]^@0YkKT00<0YkKT0`0000020:Fb
h@030000002V/N00Y[7P00P0Y[7P00<000000:J`g`2V/=l01`2V/=l00`000000YZoN0:J_gP040000
00D0Y:_K00<000000?ooo`3oool02P3oool3000000D0oooo00<000000?ooo`3oool0203oool30000
00T0oooo000@0?ooo`030000003oool0oooo00<0oooo00<000000?ooo`3oool0403oool00`000000
oooo0?ooo`080?ooo`030000003oool0oooo02P0oooo00<000000:2Uf@0000000P0000040:2Uf@03
0000002PY]X0X:KJ00L0X:KJ00<0000009nWg02OYm`01@2OYm`5000000H0XZgO00<000000:6^h@2Q
[^40202Q[^400`000000XJoR0:6_hP060:6_hP<000002@2S]>D00`000000XkKV0:>fiP080:>fiP03
0000002S]nL0XkOW00<000001@2U^^P00`000000YK_Y0:Fkj@080:Fkj@030000002U_>X0YKcZ00<0
00001P2V_^X00`000000Y[o[0:Joj`080:Joj`030000002V_n`0Y[o/00<000001P2W`>/00`000000
Yl3[0:O0j`070:O0j`<000002@2W_n/00`000000Yko[0:Noj`080:Noj`<000002@2W_NT00`000000
YkcX0:Nlj0080:Nlj0<000002@2V^>H00`000000YkOU0:Ngi@080:Ngi@030000002W]^@0YkKT00<0
00001@2U/^400`000000Y[7P0:Jah0090:Jah0030000002V/=l0Y[3O00D0Y[3O1000000:0:B[f`03
0000003oool0oooo00H0oooo0`0000080?ooo`030000003oool0oooo01@0oooo000?0?ooo`800000
1@3oool200000180oooo00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0X0?ooo`<00000
1`2PYMT00`000000X:KJ0:2VfP070:2VfP040000002OYm`0WjOL09nWg0@000000`2R[=h00`000000
XZgO0::]g`060::]g`030000002Q[^40XJkQ00P0XJkQ00@000000:6_hP2Q[n80XJoR100000020:>c
i0030000002S]>D0XkCU00P0XkCU00<000000:>fiP2S]^H01P2S]^H4000000P0YK[X00<000000:Fk
j@2U^nT0202U^nT3000000X0Y[kZ00<000000:Joj`2V_n/01P2V_n/4000000T0Yl3[00<000000:O0
j`2W`>/0102W`>/300000080Yko[00<000000:Noj`2W_n/0202W_n/00`000000Yko[0:Noj`040:No
j`<000000P2W_NT00`000000YkgY0:Nmj@080:Nmj@030000002W_>P0YkcX00@0YkcX0`0000020:Ji
iP030000002V^>H0Y[SV00P0Y[SV00<000000:Ngi@2W]nD01P2W]nD4000000T0YK;Q00<000000:Ja
h02V/N00202V/N0200000080Y[3O100000030:B/g0030000002TZm/0Y:_K00P0Y:_K00<000000?oo
o`3oool00P3oool4000000`0oooo00<000000?ooo`3oool04`3oool000l0oooo00<000000?ooo`3o
ool01@3oool00`000000oooo0?ooo`0@0?ooo`8000001`3oool00`000000oooo0?ooo`0V0?ooo`80
00000P3oool00`000000X:GI0:2Uf@060:2Uf@030000002PY]X0X:KJ00H0X:KJ100000070::/gP03
0000002R[Ml0XZgO00L0XZgO00<000000:6^h@2Q[^401`2Q[^44000000L0Xk?T00<000000:>di@2S
]>D0202S]>D010000000XkKV0:>fiP2S]^H4000000<0YKWW00<000000:Fjj02U^^P01`2U^^P00`00
0000YK_Y0:Fkj@040:Fkj@<000000P2V_NX00`000000Y[kZ0:JnjP090:JnjP040000002V_n/0Y[o[
0:Joj`@000000`2W_n/00`000000Yl3[0:O0j`080:O0j`030000002W`>/0Yl3[00<000001P2W_n/0
0`000000Yko[0:Noj`080:Noj`030000002W_n/0Yko[00<000001P2W_NT00`000000YkgY0:Nmj@08
0:Nmj@030000002W_>P0YkcX00<000001@2V^NH00`000000Y[SV0:JhiP080:JhiP040000002W]nD0
YkOU0:Ngi@D000000`2U/n<00`000000YK;Q0:Fbh@070:Fbh@030000002V/N00Y[7P00P0Y[7P1000
00070:B/g0030000002TZm/0Y:_K00T0Y:_K1000000@0?ooo`030000003oool0oooo01<0oooo000>
0?ooo`8000001`3oool200000140oooo0P0000070?ooo`800000903oool3000000@0oooo00<00000
0:2Uf@2PYMT01`2PYMT00`000000X:KJ0:2VfP030:2VfP8000000P2RZmd00`000000XZcN0::/gP07
0::/gP030000002R[Ml0XZgO00L0XZgO00<000000:6^h@2Q[^400`2Q[^4300000080Xk;S00<00000
0:>ci02S/n@01P2S/n@00`000000XkCU0:>di@080:>di@@00000202U^NL00`000000YK[X0:Fjj007
0:Fjj0030000002U^nT0YK_Y00<000001P2V_NX00`000000Y[kZ0:JnjP080:JnjP@00000202W_n/0
0`000000Yl3[0:O0j`070:O0j`<000002@2W_n/00`000000Yko[0:Noj`080:Noj`<000002@2W_NT0
0`000000YkgY0:Nmj@070:Nmj@@000002@2V^NH00`000000Y[SV0:JhiP070:JhiP@00000202U/n<0
0`000000YK;Q0:Fbh@080:Fbh@030000002V/N00Y[7P00@0Y[7P0`0000020:B]g@030000002T[=`0
Y:cL00L0Y:cL00<000000:B[f`2TZm/0202TZm/00`000000oooo0?ooo`0A0?ooo`030000003oool0
oooo01<0oooo000>0?ooo`8000001`3oool200000140oooo0P0000070?ooo`030000003oool0oooo
0200oooo0`0000080?ooo`030000002PYMT0X:GI00H0X:GI00<000000:2VfP2PY]X00`0000040::[
g@030000002R[=h0XZcN00P0XZcN00<000000::]g`2R[Ml01P2R[Ml00`000000XJkQ0:6^h@030000
00H0Xk;S00<000000:>ci02S/n@01P2S/n@00`000000XkCU0:>di@040:>di@<000000P2U^>H00`00
0000YKWW0:Fii`080:Fii`030000002U^^P0YK[X00H0YK[X0`00000:0:JmjP030000002V_^X0Y[kZ
00@0Y[kZ0`0000020:Noj`030000002W_n/0Yko[00L0Yko[00<000000:O0j`2W`>/0102W`>/30000
0080Yl3[00<000000:Noj`2W_n/0202W_n/00`000000Yko[0:Noj`040:Noj`<000000P2W_^X00`00
0000YkgY0:Nmj@080:Nmj@040000002W_NT0YkgY0:Nmj@D000000`2V^^L00`000000Y[WV0:JiiP08
0:JiiP030000002V^>H0Y[SV00<0Y[SV0`0000020:Fei0030000002U/n<0YK?S00P0YK?S00<00000
0:Fbh@2U/^401`2U/^400`000000Y[7P0:Jah004000000D0Y:gM0P0000080:B/g0030000002TZm/0
Y:_K00P0Y:_K0P00000B0?ooo`030000003oool0oooo01<0oooo000>0?ooo`8000001`3oool20000
0140oooo0P0000070?ooo`030000003oool0oooo01d0oooo0`00000<0?ooo`030000002PYMT0X:GI
00D0X:GI0`0000080::[g@030000002R[=h0XZcN00P0XZcN00<000000::]g`2R[Ml01@2R[Ml30000
00T0Xk;S00<000000:>ci02S/n@01`2S/n@00`000000XkCU0:>di@03000000H0YKSV00<000000:Fi
i`2U^NL0202U^NL010000000YK[X0:Fjj02U^^P400000080Y[cY00<000000:JmjP2V_NX02@2V_NX0
0`000000Y[kZ0:JnjP03000000H0Yko[00<000000:Noj`2W_n/01`2W_n/00`000000Yl3[0:O0j`03
000000H0Yl3[00<000000:Noj`2W_n/0202W_n/00`000000Yko[0:Noj`03000000H0YkkZ00<00000
0:Nmj@2W_NT01`2W_NT4000000T0Y[[W00<000000:JiiP2V^NH01`2V^NH00`000000Y[SV0:JhiP03
000000D0YKGT00<000000:Fch`2U/n<02@2U/n<00`000000YK;Q0:Fbh@050:Fbh@@000002P2T[Md2
000000P0Y:cL00<000000:B[f`2TZm/0102TZm/3000000030:>Vf0000000oooo0140oooo00<00000
0?ooo`3oool04`3oool000h0oooo0P0000070?ooo`800000403oool3000000L0oooo00<000000?oo
o`3oool06P3oool3000000l0oooo00@000000:2Uf@2PYMT0X:GI100000020::Zg0030000002RZmd0
XZ_M00L0XZ_M00<000000::/gP2R[=h01`2R[=h010000000XZgO0::]g`2R[Ml400000080Y;7R00<0
00000:>bh`2S/^<0202S/^<00`000000Xk?T0:>ci0060:>ci0<000002@2U^>H00`000000YKWW0:Fi
i`080:Fii`@000001`2V_>T00`000000Y[gZ0:JmjP080:JmjP<000002@2W_n/00`000000Yko[0:No
j`070:Noj`<000002P2W`>/00`000000Yko[0:Noj`060:Noj`@000002@2W_^X00`000000YkgY0:Nm
j@040:Nmj@<000000P2V_>P00`000000Y[[W0:Jji`080:Jji`030000002V^NH0Y[WV00H0Y[WV1000
00090:Fei0030000002U/n<0YK?S00P0YK?S00@000000:Fbh@2U/^40YK;Q100000030:B^g`030000
002T[Md0Y:gM00P0Y:gM0P0000080:B/g0030000002TZm/0Y:_K00@000001@2SY]P00`000000oooo
0?ooo`0?0?ooo`030000003oool0oooo01<0oooo000>0?ooo`8000001`3oool2000000l0oooo0`00
00080?ooo`030000003oool0oooo01L0oooo0`00000C0?ooo`<000001`2RZ]`00`000000XZ_M0::[
g@070::[g@030000002R[=h0XZcN00H0XZcN100000070:BahP030000002S/^<0Xk;S00P0Xk;S00@0
00000:>ci02S/n@0Xk?T100000020:Fgi@030000002U^>H0YKSV00P0YKSV00<000000:Fii`2U^NL0
102U^NL300000080Y[cY00<000000:Jlj@2V_>T01`2V_>T00`000000Y[gZ0:JmjP040:JmjP<00000
0P2W_n/00`000000Yko[0:Noj`080:Noj`030000002W_n/0Yko[00@0Yko[0P0000020:O0j`030000
002W`>/0Yl3[00T0Yl3[00@000000:Noj`2W_n/0Yko[100000030:Noj`030000002W_^X0YkkZ00P0
YkkZ00<000000:Nmj@2W_NT00`0000060:Jlj0030000002V^^L0Y[[W00P0Y[[W00@000000:JiiP2V
^NH0Y[WV100000030:Ffi@030000002U]N@0YKGT00L0YKGT00<000000:Fch`2U/n<0202U/n<40000
00L0Y:kO00<000000:B]g@2T[Md02@2T[Md2000000H0Y:cL100000090:>Vf0030000003oool0oooo
00l0oooo00<000000?ooo`3oool04`3oool000h0oooo0P0000070?ooo`8000003@3oool4000000P0
oooo0P00000F0?ooo`<000005`3oool00`000000XZ[L0::Zg0070::Zg0030000002RZmd0XZ_M00H0
XZ_M00<000000::/gP2R[=h0102R[=h200000080Y;3Q00<000000:BahP2T/N801`2T/N800`000000
Xk;S0:>bh`070:>bh`@000001`2U]nD00`000000YKSV0:FhiP080:FhiP030000002U^NL0YKWW00<0
00001P2V_>T00`000000Y[cY0:Jlj@070:Jlj@030000002V_NX0Y[gZ00<000001P2W_n/00`000000
Yko[0:Noj`080:Noj`030000002W_n/0Yko[00<000001@2W`>/00`000000Yl3[0:O0j`080:O0j`@0
0000202W_n/00`000000YkkZ0:NnjP070:NnjP<000002@2V_>P00`000000Y[[W0:Jji`080:Jji`@0
00001`2U]^D00`000000YKGT0:Fei0080:Fei0030000002U/n<0YK?S00@0YK?S0`0000020:B`h003
0000002T[]l0Y:kO00L0Y:kO00<000000:B]g@2T[Md0202T[Md010000000Y:cL0000002T[=`40000
0080XjOJ00<000000:>Vf02SY]P02@2SY]P00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo
0180oooo000>0?ooo`8000001`3oool2000000X0oooo1P0000090?ooo`030000003oool0oooo0180
oooo0`00000K0?ooo`030000002RZ]`0XZ[L00H0XZ[L00<000000::[g@2RZmd01`2RZmd00`000000
XZcN0::/gP03000000@0Y;3Q00<000000:BahP2T/N80202T/N800`000000Xk;S0:>bh`040:>bh`80
00000P2U]^D00`000000YKOU0:Fgi@070:Fgi@030000002U^>H0YKSV00L0YKSV0`0000090:Jlj@03
0000002V_>T0Y[cY00L0Y[cY0`00000:0:Noj`030000002W_n/0Yko[00H0Yko[100000090:O0j`03
0000002W`>/0Yl3[00@0Yl3[0`0000020:O0j`030000002W_n/0Yko[00L0Yko[00<000000:NnjP2W
_^X0102W_^X300000080Y[gY00<000000:Jlj02V_>P0202V_>P00`000000Y[[W0:Jji`040:Jji`<0
00000P2U^>H00`000000YKKU0:Ffi@070:Ffi@030000002U]N@0YKGT00L0YKGT00<000000:Fch`2U
/n<0100000050:B`h0030000002T[]l0Y:kO00L0Y:kO00<000000:B]g@2T[Md0202T[Md4000000L0
XjOJ00<000000:>Vf02SY]P0202SY]P00`000000oooo0?ooo`0?0?ooo`030000003oool0oooo0180
oooo000?0?ooo`030000003oool0oooo00D0oooo00<000000?ooo`3oool02P3oool3000000/0oooo
00<000000?ooo`3oool03`3oool3000001l0oooo00<000000::Zg02RZ]`01P2RZ]`00`000000XZ_M
0::[g@060::[g@<00000202T/>400`000000Y;7R0:BahP080:BahP030000002S/^<0Xk;S00<00000
1@2U]^D00`000000YKOU0:Fgi@070:Fgi@030000002U^>H0YKSV00@0YKSV0P0000020:Jkj0030000
002V_>T0Y[cY00P0Y[cY00<000000:Jlj@2V_>T0102V_>T200000080Yko[00<000000:Noj`2W_n/0
2@2W_n/010000000Yko[0:Noj`2W_n/4000000<0Yl3/00<000000:O0j`2W`>/0202W`>/00`000000
Yl3[0:O0j`03000000H0Yl3[00<000000:Noj`2W_n/01`2W_n/00`000000YkkZ0:NnjP03000000H0
Y[gY00<000000:Jlj02V_>P0202V_>P00`000000Y[[W0:Jji`03000000D0YKSV00<000000:Ffi@2U
]^D0202U]^D00`000000YKGT0:Fei0050:Fei0@000002P2T/>000`000000Y:kO0:B^g`070:B^g`03
0000002T[Md0Y:gM00@0Y:gM0`000000102SZM/000000:>WfP0000070:>WfP030000002SY]P0XjKH
00T0XjKH00<000000?ooo`3oool03P3oool00`000000oooo0?ooo`0B0?ooo`003`3oool2000000D0
oooo0P00000<0?ooo`030000003oool0oooo00/0oooo00<000000?ooo`3oool0303oool300000280
oooo00<000000::Zg02RZ]`01`2RZ]`010000000XZ_M0::[g@2RZmd400000080Y:oO00<000000:B`
h@2T/>401`2T/>400`000000Y;7R0:BahP070:BahP<00000202U]^D00`000000YKOU0:Fgi@080:Fg
i@030000002U^>H0YKSV00<000001@2V^nP00`000000Y[cY0:Jlj@080:Jlj@030000002V_>T0Y[cY
00<000001@2W_n/00`000000Yko[0:Noj`080:Noj`@00000202W`>`00`000000Yl3[0:O0j`070:O0
j`<000002P2W`>/00`000000Yko[0:Noj`060:Noj`<000002@2V_NT00`000000Y[cX0:Jlj0080:Jl
j0<000002@2U^>H00`000000YKKU0:Ffi@070:Ffi@040000002U]N@0YKGT0:Fei0@000000`2T/N80
0`000000Y;3P0:B`h0080:B`h0030000002T[]l0Y:kO00L0Y:kO00<000000:B]g@2T[Md010000005
0:>Yf`030000002SYmX0000000L0XjOJ00<000000:>Vf02SY]P0202SY]P00`000000oooo0?ooo`0>
0?ooo`030000003oool0oooo0180oooo000@0?ooo`030000003oool0oooo00<0oooo00<000000?oo
o`3oool0303oool00`000000oooo0?ooo`0:0?ooo`030000003oool0oooo00X0oooo0P00000V0?oo
o`030000002RZ]`0XZ[L00H0XZ[L100000070:B_g`030000002T/>40Y;3Q00L0Y;3Q00<000000:Ba
hP2T/N800`2T/N8300000080YKGT00<000000:Ffi@2U]^D01`2U]^D00`000000YKOU0:Fgi@060:Fg
i@@000002@2V^nP00`000000Y[cY0:Jlj@060:Jlj@@000002@2W_n/00`000000Yko[0:Noj`040:No
j`<000000P2W`N`00`000000Yl3/0:O0k0070:O0k0030000002W`>/0Yl3[00@0Yl3[0`0000020:O1
k0030000002W`>/0Yl3[00T0Yl3[00@000000:Noj`2W_n/0Yko[100000020:Jnj`030000002V_NT0
Y[gY00P0Y[gY00<000000:Jlj02V_>P0102V_>P300000080YK[X00<000000:FhiP2U^>H0202U^>H0
0`000000YKKU0:Ffi@050:Ffi@D00000202T/N800`000000Y;3P0:B`h0080:B`h0030000002T[]l0
Y:kO00D0Y:kO100000090:>Yf`040000002SYmX0XjOJ000000H0XjOJ00<000000:>Vf02SY]P02@2S
Y]P00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0180oooo000@0?ooo`8000000`3oool2
000000h0oooo1P0000060?ooo`8000002@3oool3000002T0oooo00@000000::Zg02RZ]`0XZ[L1000
00020:B^g`030000002T[ml0Y:oO00H0Y:oO00<000000:B`h@2T/>401`2T/>400`000000Y;7R0:Ba
hP03000000H0YKGT00<000000:Ffi@2U]^D01`2U]^D010000000YKOU0:Fgi@2U]nD4000000<0Y[[W
00<000000:Jkj02V^nP0202V^nP010000000Y[cY0:Jlj@2V_>T4000000<0YkkZ00<000000:Noj`2W
_n/0202W_n/00`000000Yko[0:Noj`03000000H0Yl7/00<000000:O0k02W`>`01`2W`>`00`000000
Yl3[0:O0j`03000000H0Yl7/00<000000:O0j`2W`>/0202W`>/4000000L0Y[k[00<000000:Jmj@2V
_NT0202V_NT00`000000Y[cX0:Jlj003000000D0YK[X00<000000:FhiP2U^>H0202U^>H010000000
YKKU0:Ffi@2U]^D4000000<0Y;?T00<000000:BahP2T/N801`2T/N800`000000Y;3P0:B`h0080:B`
h0040000002T[]l0Y:kO0:B^g`@000000`2RZmd00`000000XjWK0:>Yf`080:>Yf`040000002SYmX0
XjOJ000000H0XjOJ00<000000:>Vf02SY]P01P2SY]P3000000l0oooo00<000000?ooo`3oool04P3o
ool00180oooo0`00000A0?ooo`H000001@3oool00`000000oooo0?ooo`050?ooo`<00000;@3oool3
000000H0Y:kO00<000000:B_g`2T[ml01`2T[ml00`000000Y;3Q0:B`h@060:B`h@<000002@2U]N@0
0`000000YKKU0:Ffi@070:Ffi@@00000202V^^L00`000000Y[_X0:Jkj0070:Jkj0@00000202W_^X0
0`000000Yko[0:Noj`070:Noj`<000002P2W`N`00`000000Yl3/0:O0k0060:O0k0<000002P2W`N`0
0`000000Yl3[0:O0j`040:O0j`<000000P2V_n`00`000000Y[k[0:Jnj`070:Jnj`030000002V_NT0
Y[gY00H0Y[gY100000090:Fjj0030000002U^>H0YKSV00L0YKSV100000070:Bci0030000002T/N80
Y;7R00P0Y;7R00<000000:B`h02T/>001P2T/>05000000L0XZ_M00<000000:>Yf`2SZM/0202SZM/0
10000000XjOJ0:>WfP0000060:>WfP040000002SY]P0XjKH0:>Vf0D000000P2QX]H00`000000oooo
0?ooo`0=0?ooo`030000003oool0oooo0180oooo000a0?ooo`030000003oool0oooo0080oooo0`00
000a0?ooo`030000002T[]l0Y:kO00H0Y:kO00<000000:B_g`2T[ml01`2T[ml010000000Y;3Q0:B`
h@2T/>4400000080YKCS00<000000:Fei02U]N@0202U]N@00`000000YKKU0:Ffi@040:Ffi@800000
0P2V^^L00`000000Y[[W0:Jji`080:Jji`030000002V^nP0Y[_X00@0Y[_X0P0000020:NnjP030000
002W_^X0YkkZ00P0YkkZ00<000000:Noj`2W_n/0102W_n/200000080Yl7/00<000000:O1k02W`N`0
2@2W`N`010000000Yl3/0:O0k02W`>`400000080Yl7/00<000000:O1k02W`N`02@2W`N`00`000000
Yl3[0:O0j`03000000H0Y[o/00<000000:Jnj`2V_^/01`2V_^/010000000Y[gY0:Jmj@2V_NT40000
00<0YK_Y00<000000:Fjj02U^^P0202U^^P00`000000YKSV0:FhiP030:FhiP<000000P2S]ND00`00
0000Y;?T0:Bci0070:Bci0030000002T/N80Y;7R00P0Y;7R00@000000:B`h02T/>00Y;3P10000003
0::/gP030000002RZmd0XZ_M00L0XZ_M00<000000:>Yf`2SZM/0202SZM/010000000XjOJ0:>WfP00
00040:>WfPD00000202QX]H00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo0140oooo000a
0?ooo`030000003oool0000000800000=03oool00`000000Y:kO0:B^g`070:B^g`030000002T[ml0
Y:oO00H0Y:oO100000070:Fdh`030000002U]N@0YKGT00P0YKGT00<000000:Ffi@2U]^D00`000005
0:Jji`030000002V^^L0Y[[W00P0Y[[W00<000000:Jkj02V^nP00`0000050:NnjP030000002W_^X0
YkkZ00P0YkkZ00<000000:Noj`2W_n/00`0000050:O1k0030000002W`N`0Yl7/00P0Yl7/10000007
0:O1k0030000002W`N`0Yl7/00P0Yl7/0`0000090:Jok0030000002V_^/0Y[k[00H0Y[k[1@000008
0:Fkj@030000002U^^P0YK[X00L0YK[X00<000000:FhiP2U^>H00`0000050:>ei@030000002T/n@0
Y;?T00P0Y;?T00<000000:BahP2T/N801P2T/N85000000L0XZcN00<000000::[g@2RZmd01`2RZmd0
0`000000XjWK0:>Yf`080:>Yf`040000002SYmX0XjOJ0:>WfP@000000P2QY=L00`000000XJ;F0:6R
eP080:6ReP030000003oool0oooo00d0oooo00<000000?ooo`3oool04@3oool00340oooo0P00000h
0?ooo`030000002T[]l0Y:kO00L0Y:kO00<000000:B_g`2T[ml00`2T[ml200000080YK?S00<00000
0:Fdh`2U]><01`2U]><2000000P0YKGT0`0000090:Jji`030000002V^^L0Y[[W00L0Y[[W0`000009
0:NnjP030000002W_^X0YkkZ00H0YkkZ100000090:O1k0030000002W`N`0Yl7/00@0Yl7/0`000002
0:O2k@030000002W`N`0Yl7/00L0Yl7/00<000000:O1k02W`N`0102W`N`300000080Y/7]00<00000
0:Jok02V_n`0202V_n`010000000Y[k[0:Jnj`2V_^/4000000<0YKg[00<000000:Fkj@2U^nT01`2U
^nT00`000000YK[X0:Fjj0060:Fjj0@000002@2S]ND00`000000Y;?T0:Bci0070:Bci0040000002T
/N80Y;7R0:BahPD000000`2R[^000`000000XZcN0::/gP070::/gP030000002RZmd0XZ_M00L0XZ_M
00<000000:>Yf`2SZM/01P2SZM/6000000H0XJCG00<000000:6ReP2QX]H0202QX]H00`000000oooo
0?ooo`0<0?ooo`030000003oool0oooo0140oooo000b0?ooo`030000003oool0oooo03L0oooo00<0
00000:B^g`2T[]l01P2T[]l00`000000Y:oO0:B_g`03000000D0YK?S00<000000:Fdh`2U]><0202U
]><010000000YKGT0:Fei02U]N@400000080Y[WW00<000000:Jji`2V^^L0202V^^L00`000000Y[[W
0:Jji`040:Jji`8000000P2W_^X00`000000YkkZ0:NnjP080:NnjP040000002W_^X0YkkZ0:NnjP@0
00000`2W`N`00`000000Yl7/0:O1k0080:O1k0030000002W`N`0Yl7/00<000001P2W`^d00`000000
Yl7/0:O1k0070:O1k0030000002W`N`0Yl7/00<000001P2V`Nd00`000000Y[o/0:Jok0070:Jok0@0
0000202U_N/00`000000YK_Y0:Fkj@070:Fkj@040000002U^^P0YK[X0:Fjj0@000000`2S]nL00`00
0000XkGU0:>ei@080:>ei@030000002T/n@0Y;?T00D0Y;?T1@0000080::^h0030000002R[=h0XZcN
00L0XZcN00<000000::[g@2RZmd01`2RZmd010000000XjWK0:>Yf`2SZM/500000080XJGI00D00000
0:6Te`2QY=L0XJCG000000050:6Te`030000002QX]H0XJ;F00P0XJ;F00<000000?ooo`3oool0303o
ool00`000000oooo0?ooo`0A0?ooo`00<`3oool2000003P0oooo00<000000:B^g`2T[]l01@2T[]l3
000000T0YK?S00<000000:Fdh`2U]><01`2U]><4000000L0Y[WW00<000000:Jji`2V^^L0202V^^L0
0`000000Y[[W0:Jji`03000000D0YkkZ00<000000:NnjP2W_^X01`2W_^X4000000P0Yl7/00<00000
0:O1k02W`N`01`2W`N`3000000X0Yl;]00<000000:O1k02W`N`01P2W`N`3000000T0Y/7]00<00000
0:Jok02V_n`0102V_n`300000080YKo/00<000000:Fmj`2U_N/01`2U_N/00`000000YK_Y0:Fkj@06
0:Fkj@D000001`2S]nL00`000000XkGU0:>ei@080:>ei@040000002T/n@0Y;?T0:Bci0@000000`2R
/>800`000000XZkP0::^h0080::^h0030000002R[=h0XZcN00L0XZcN00<000000::[g@2RZmd01@2R
Zmd5000000P0XJGI00D000000:6Te`2QY=L0XJCG000000050:6Te`030000002QX]H0XJ;F00P0XJ;F
00<000000?ooo`3oool02`3oool00`000000oooo0?ooo`0A0?ooo`00=@3oool00`000000oooo0?oo
o`0e0?ooo`040000002T[]l0Y:kO0:B^g`@000000P2V/n800`000000YK?S0:Fch`080:Fch`030000
002U]><0YKCS00@0YKCS0P0000020:NiiP030000002V^NL0Y[WW00L0Y[WW00<000000:Jji`2V^^L0
1P2V^^L4000000T0YkkZ00<000000:NnjP2W_^X0102W_^X200000080Yl7/00<000000:O1k02W`N`0
202W`N`00`000000Yl7/0:O1k0040:O1k08000000P2W`nh00`000000Yl;]0:O2k@090:O2k@040000
002W`N`0Yl7/0:O1k0@000000P2V`^h00`000000Y/7]0:K1k@080:K1k@030000002V_n`0Y[o/00<0
00001P2U_n`00`000000YKg[0:Fmj`070:Fmj`040000002U^nT0YK_Y0:Fkj@@000000`2S^NT00`00
0000XkOW0:>gi`070:>gi`030000002S]ND0XkGU00L0XkGU100000070::`hP030000002R[^00XZkP
00P0XZkP00<000000::/gP2R[=h01`2R[=h010000000XZ_M0::[g@2RZmd400000080X:KJ00<00000
0:6Uf@2QYMT0202QYMT00`000000XJCG0:6Te`020:6Te`030000002QY=L0XJCG0080XJCG00<00000
0:6ReP2QX]H0202QX]H00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo0140oooo000f0?oo
o`030000003oool0oooo03D0oooo0`0000070:JchP030000002U/n<0YK?S00P0YK?S00<000000:Fd
h`2U]><00`0000050:NiiP030000002V^NL0Y[WW00L0Y[WW00@000000:Jji`2V^^L0Y[[W10000003
0:NnjP030000002W_^X0YkkZ00P0YkkZ00<000000:NnjP2W_^X00`0000050:O1k0030000002W`N`0
Yl7/00P0Yl7/00<000000:O1k02W`N`00`0000050:O3kP030000002W`^d0Yl;]00P0Yl;]10000007
0:K2kP800000202V`Nd3000000T0YKo/00<000000:Fmj`2U_N/01`2U_N/4000000L0XkWY00<00000
0:>gi`2S]nL0202S]nL00`000000XkGU0:>ei@030:>ei@<000000P2Q/^@00`000000X[3R0::`hP07
0::`hP030000002R[^00XZkP00P0XZkP00<000000::/gP2R[=h01@2R[=h5000000L0X:KJ00<00000
0:6Uf@2QYMT0202QYMT01@000000XJCG0:6Te`2QY=L0000000D0XJCG00<000000:6ReP2QX]H01P2Q
X]H3000000d0oooo00<000000?ooo`3oool0403oool003L0oooo00<000000?ooo`3oool0=@3oool0
0`000000Y[?R0:JchP070:JchP030000002U/n<0YK?S00L0YK?S0`0000080:NiiP030000002V^NL0
Y[WW00L0Y[WW100000080:NnjP030000002W_^X0YkkZ00L0YkkZ0`0000090:O1k0030000002W`N`0
Yl7/00H0Yl7/100000090:O3kP030000002W`^d0Yl;]00@0Yl;]0`0000020:K4k`030000002V`^h0
Y/;^00P0Y/;^00@000000:K1k@2V`Nd0Y/7]100000020:C1kP030000002U_n`0YKo/00P0YKo/00<0
00000:Fmj`2U_N/0102U_N/200000080Xkc[00<000000:>ij@2S^NT01`2S^NT00`000000XkOW0:>g
i`070:>gi`030000002S]ND0XkGU00<000001@2Q/^@00`000000X[3R0::`hP080::`hP030000002R
[^00XZkP00L0XZkP00@000000::/gP2R[=h0XZcN100000030:2Xg0030000002PY]X0X:KJ00H0X:KJ
00<000000:6Uf@2QYMT0202QYMT00`000000XJCG0:6Te`020:6Te`030000002QY=L0XJCG0080XJCG
00@000000:6ReP2QX]H0XJ;F1@00000209nNd`030000003oool0oooo00/0oooo00<000000?ooo`3o
ool0403oool003P0oooo0P00000f0?ooo`030000002V/n80Y[?R00L0Y[?R00<000000:Fch`2U/n<0
102U/n<200000080YkSV00<000000:NiiP2W^NH01`2W^NH00`000000Y[WW0:Jii`040:Jii`800000
0P2W_^T00`000000YkkZ0:NnjP080:NnjP030000002W_^X0YkkZ00@0YkkZ0P0000020:O2k0030000
002W`N`0Yl7/00P0Yl7/00@000000:O1k02W`N`0Yl7/100000030:O4kP030000002W`nh0Yl?^00P0
Yl?^00<000000:O2k@2W`^d00`0000060:K4k`030000002V`^h0Y/;^00L0Y/;^100000070:C1kP03
0000002U_n`0YKo/00P0YKo/00<000000:Fmj`2U_N/00`0000050:>lj`030000002S^NT0XkWY00L0
XkWY00<000000:>gi`2S]nL01@2S]nL4000000T0XK;T00<000000::`hP2R/>80202R/>800`000000
XZkP0::^h0050::^h0D000001`2PZ=`00`000000X:KJ0:2VfP070:2VfP030000002QYMT0XJGI00P0
XJGI00<000000:6Te`2QY=L00P2QY=L00`000000XJCG0:6Te`05000000P0WikC00<000000?ooo`3o
ool02P3oool00`000000oooo0?ooo`0@0?ooo`00>P3oool00`000000oooo0?ooo`0d0?ooo`030000
002V/n80Y[?R00L0Y[?R00<000000:Fch`2U/n<00`0000050:NhiP030000002W^NH0YkWV00L0YkWV
00<000000:Jii`2V^NL00`0000050:Nnj@030000002W_^X0YkkZ00P0YkkZ00<000000:NnjP2W_^X0
0`0000050:O2k0030000002W`N`0Yl7/00L0Yl7/100000080:O4kP800000202W`nh3000000T0Y/C_
00<000000:K2kP2V`^h0102V`^h300000080Y<?_00<000000:C1kP2T`Nh01`2T`Nh00`000000YKo/
0:Fok0060:Fok0@00000202S_>/00`000000XkWY0:>ij@070:>ij@040000002S]nL0XkOW0:>gi`@0
00000`2Q]NL00`000000XK;T0:6bi0080:6bi0030000002R/>80X[3R00L0X[3R00@000000::^h02R
[^00XZkP1000000309n[gP030000002PZ=`0X:SL00L0X:SL00<000000:2VfP2PY]X01P2PY]X00`00
0000XJGI0:6Uf@080:6Uf@040000002QY=L0XJCG0:6Te`@000000P2OWm@00`000000WikC09nNd`08
09nNd`030000003oool0oooo00X0oooo00<000000?ooo`3oool0403oool003/0oooo00<000000?oo
o`3oool0=03oool00`000000Y[?R0:JchP060:JchP<00000202W^>H00`000000YkWV0:NiiP070:Ni
iP<000002@2W_^T00`000000YkkZ0:NnjP060:NnjP@000002@2W`^`00`000000Yl7/0:O1k0040:O1
k08000000P2WaNl00`000000YlC^0:O4kP090:O4kP040000002W`nh0Yl?^0:O3kP@000000P2VaO00
0`000000Y/C_0:K4k`080:K4k`030000002V`^h0Y/;^00<000001P2T`nl00`000000Y<7^0:C1kP07
0:C1kP040000002U_n`0YKo/0:Fok0@000000`2R_^d00`000000Xkc[0:>lj`070:>lj`030000002S
^NT0XkWY00H0XkWY100000080:6ei`030000002Q/^@0XK;T00P0XK;T00<000000::`hP2R/>801@2R
/>85000000L0Wj_N00<000000:2Xg02PZ=`01`2PZ=`00`000000X:KJ0:2VfP070:2VfP030000002Q
YMT0XJGI00H0XJGI1@00000209nOe0030000002OWm@0WioD0080WioD00<0000009nNd`2OW]<0202O
W]<00`000000oooo0?ooo`090?ooo`030000003oool0oooo0100oooo000l0?ooo`030000003oool0
oooo03@0oooo00@000000:JchP2V/n80Y[?R100000020:Nhi@030000002W^>H0YkSV00L0YkSV00<0
00000:NiiP2W^NH0102W^NH200000080YkgY00<000000:Nnj@2W_^T0202W_^T010000000YkkZ0:Nn
jP2W_^X4000000<0Yl;]00<000000:O2k02W`^`0202W`^`00`000000Yl7/0:O1k003000000D0YlG_
00<000000:O4kP2Wa>h0202Wa>h4000000L0Y/G`0P0000080:K4k`<000002@2T`nl00`000000Y<7^
0:C1kP060:C1kPD00000202R_^d00`000000Xkc[0:>lj`070:>lj`040000002S^NT0XkWY0:>ij@@0
00000P2P]nT00`000000XKGW0:6ei`080:6ei`030000002Q/^@0XK;T00L0XK;T00@000000::`hP2R
/>80X[3R1000000309n]h@030000002OZmh0Wj_N00L0Wj_N00<000000:2Xg02PZ=`01`2PZ=`00`00
0000X:KJ0:2VfP060:2VfP040000002QYMT0XJGI0:6Uf@D000000P2NXMH00`000000WioD09nOe003
09nOe0050000002OWm@0WioD09nOe00000002P2OW]<00`000000oooo0?ooo`090?ooo`030000003o
ool0oooo0100oooo000m0?ooo`800000=@3oool3000000L0YkSU00<000000:NhiP2W^>H01`2W^>H0
0`000000YkWV0:NiiP03000000D0YkgY00<000000:Nnj@2W_^T01`2W_^T4000000P0Yl;]0P000008
0:O2k0<000002@2WaNl00`000000YlC^0:O4kP040:O4kP<000000P2Ua_400`000000Y/G`0:K5l008
0:K5l0040000002Va>l0Y/C_0:K4k`@000000P2TaO000`000000Y<?_0:C3k`080:C3k`040000002T
`Nh0Y<7^0:C1kP@000000`2R`Nl00`000000X[k]0::nk@070::nk@030000002S_>/0Xkc[00H0Xkc[
1@0000070:2gj@030000002Q]NL0XKGW00P0XKGW00<000000:6bi02Q/^@00`2Q/^@7000000L0WjgQ
00<0000009n[gP2OZmh01`2OZmh00`000000X:SL0:2Xg0070:2Xg0030000002PY]X0X:KJ00<0X:KJ
1`00000809jQeP030000002OWm@0WioD00<0WioD00D0000009nOe02OWm@0WioD0000000:09nNd`03
0000003oool0oooo00P0oooo00<000000?ooo`3oool0403oool003l0oooo00<000000?ooo`3oool0
<`3oool00`000000YkSU0:Nhi@070:Nhi@030000002W^>H0YkSV00H0YkSV0`0000090:Nmj@030000
002W_^T0YkkY00@0YkkY0P0000020:O2k@030000002W`^d0Yl;]00T0Yl;]00@000000:O2k02W`^`0
Yl;/100000020:O5k`030000002WaNl0YlG_00P0YlG_00<000000:O4kP2Wa>h00`0000060:G6l@03
0000002VaO00Y/G`00H0Y/G`1@0000070:C5l0800000202T`nl4000000P0X/7_00<000000::nk@2R
_^d01`2R_^d010000000Xkc[0:>lj`2S_>/4000000<0X;[[00<000000:2gj@2P]nT01`2P]nT00`00
0000XKGW0:6ei`060:6ei`L000001@2N[n@00`000000WjgQ09n]h@0709n]h@030000002OZmh0Wj_N
00L0Wj_N00<000000:2Xg02PZ=`01@2PZ=`7000000@0WZ?H00<0000009jQeP2NXMH0202NXMH00`00
0000WioD09nOe00409nOe0040000002OWm@0WioD000000X0WikC00<000000?ooo`3oool02@3oool0
0`000000oooo0?ooo`0?0?ooo`00@03oool00`000000oooo0?ooo`0c0?ooo`030000002W^>D0YkSU
00L0YkSU00@000000:NhiP2W^>H0YkSV100000020:Nmj@030000002W_NT0YkgY00P0YkgY00<00000
0:Nnj@2W_^T00`0000050:O2k@030000002W`^d0Yl;]00P0Yl;]100000070:O5k`800000202WaNl3
000000X0YLKa00@000000:K5l02VaO00Y/G`100000030:C7lP030000002TaO00Y<G`00P0Y<G`00@0
00000:C3k`2T`nl0Y<?_100000020:;3l@030000002R`Nl0X/7_00L0X/7_00<000000::nk@2R_^d0
1P2R_^d5000000P0X;[[00<000000:2gj@2P]nT01`2P]nT010000000XKGW0:6ei`2Q]NL4000000<0
W[;V00<0000009j_i02N[n@01P2N[n@00`000000WjgQ09n]h@0709n]h@030000002OZmh0Wj_N00L0
Wj_N00@000000:2Xg02PZ=`0X:SL1000000209fUf`030000002NXmP0WZ?H00L0WZ?H00<0000009jQ
eP2NXMH0202NXMH00`000000WioD09nOe00309nOe0050000002OWm@0WioD09nOe00000002P2OW]<0
0`000000oooo0?ooo`080?ooo`030000003oool0oooo00l0oooo00110?ooo`030000003oool0oooo
0380oooo00<000000:Nhi@2W^>D01`2W^>D4000000L0YkgY0P0000080:Nmj@<000002@2W`^d20000
00H0Yl;]0P0000020:O6l0030000002WaNl0YlG_00P0YlG_00@000000:O5k`2WaNl0YlG_10000002
0:G7l@030000002Ua_40YLKa00P0YLKa100000080:C7lP030000002TaO00Y<G`00H0Y<G`1@000007
0:;3l@800000202R`Nl010000000X[k]0::nk@2R_^d4000000<0Wkg^00<000000:2jj`2P^^/01`2P
^^/00`000000X;OY0:2gj@060:2gj@D000001`2N/^H00`000000WZoT09j_i00709j_i0030000002O
[N40WjgQ00L0WjgQ00<0000009n[gP2OZmh01@2OZmh5000000L0WJGK00<0000009jSf02NXmP01P2N
XmP00`000000WZ7F09jQeP0809jQeP030000002OWm@0WioD00@0WioD00@0000009nOe02OWm@00000
202OW]<3000000X0oooo00<000000?ooo`3oool03`3oool00480oooo0P00000c0?ooo`030000002W
^>D0YkSU00@0YkSU0P0000020:Nmj@030000002W_NT0YkgY00P0YkgY00@000000:Nmj@2W_NT0YkgY
100000020:O2k@8000002P2W`^d00`000000Yl;]0:O2k@03000000D0YlK`00<000000:O5k`2WaNl0
1`2WaNl4000000L0YLOa0P0000060:G6l@8000000P2Sb?<00`000000Y<Ob0:C7lP080:C7lP040000
002TaO00Y<G`0:C5l0@000000`2Qa_800`000000X/?a0:;3l@080:;3l@030000002R`Nl0X/7_00<0
X/7_1P00000809nmkP030000002P^^/0X;[[00L0X;[[00@000000:2gj@2P]nT0X;OY1000000309fe
j@030000002N/^H0W[;V00L0W[;V00<0000009j_i02N[n@01`2N[n@00`000000WjgQ09n]h@0609n]
h@040000002OZmh0Wj_N09n[gP@000000`2MYmd00`000000WJGK09fUf`0609fUf`030000002NXmP0
WZ?H00L0WZ?H00<0000009jQeP2NXMH0202NXMH00`000000WioD09nOe00409nOe0040000002OWm@0
WioD00000080WikC1@00000209jKd0030000003oool0oooo00P0oooo00<000000?ooo`3oool03`3o
ool004@0oooo00<000000?ooo`3oool0<@3oool00`000000YkSU0:Nhi@03000000D0YkgY00<00000
0:Nmj@2W_NT01`2W_NT4000000P0Yl;]00<000000:O2k@2W`^d01`2W`^d3000000T0YlK`00<00000
0:O5k`2WaNl0102WaNl200000080YLWb00<000000:G7l@2Uao40202Uao400`000000YLKa0:G6l@03
000000D0XlSc0P0000080:C7lP@00000202Qa_800`000000X/?a0:;3l@060:;3l@L00000102O`?00
0`000000Wkg^09nmkP0709nmkP030000002P^^/0X;[[00H0X;[[1@00000709fej@030000002N/^H0
W[;V00P0W[;V00<0000009j_i02N[n@01P2N[n@00`000000WjgQ09n]h@0309n]h@L000001`2MYmd0
0`000000WJGK09fUf`0709fUf`030000002NXmP0WZ?H00H0WZ?H00<0000009jQeP2NXMH0202NXMH0
0`000000WioD09nOe00309nOe0L00000202NVm000`000000oooo0?ooo`070?ooo`030000003oool0
oooo00l0oooo00150?ooo`030000003oool0oooo0340oooo0P0000090:Nmj@030000002W_NT0YkgY
00@0YkgY0P0000020:O2k@030000002W`^d0Yl;]00P0Yl;]0P0000030:O2k@@000000P2Vao000`00
0000YlK`0:O6l0080:O6l0030000002WaNl0YlG_00<000001@2UbO82000000P0YLOa0`00000:0:?8
l`040000002Tao80Y<Ob0:C7lP@000000P2Pb?@00`000000XLKb0:76lP080:76lP040000002R`o40
X/?a0:;3l@@000000`2N`o800`000000Wl3`09o0l00609o0l0800000202O_Nh010000000X;[[0:2j
j`2P^^/4000000<0W;S/00<0000009fej@2M]NT01`2M]NT00`000000W[;V09jbiP0709jbiP030000
002N[n@0WZoT00<0WZoT2@00000509bYh0030000002MYmd0WJOM00L0WJOM00<0000009fUf`2MYM/0
1P2MYM/00`000000WZ?H09jSf00709jSf0030000002NXMH0WZ7F00H0WZ7F1`00000209fLdP030000
002MW=80000000X0WY_@00<000000?ooo`3oool01`3oool00`000000oooo0?ooo`0?0?ooo`00AP3o
ool00`000000oooo0?ooo`0a0?ooo`030000002W_NT0YkgY00P0YkgY00<000000:Nmj@2W_NT00`00
00050:O2k@030000002W`^d0Yl;]00P0Yl;]100000070:K7l0800000202Wa_03000000X0YLWb00@0
00000:G7l@2Uao40YLOa100000020:?;m0030000002Sb?<0XlSc00P0XlSc100000070:38m0800000
202Qa_84000000P0W/?b00<0000009o0l02O`?001`2O`?000`000000Wkg^09nmkP0309nmkPH00000
202L^>`00`000000WKGY09fej@0709fej@030000002N/^H0W[;V00D0W[;V1`00000509^/h`030000
002LZN00W:WP00H0W:WP00<0000009fWg@2MYmd01`2MYmd00`000000WJGK09fUf`0709fUf`030000
002NXmP0WZ?H00H0WZ?H00@0000009jQeP2NXMH0WZ7F1@00000209bMe0030000002MW=80WIcB00D0
WIcB00<0000009fLdP0000002P2NVm000`000000oooo0?ooo`060?ooo`030000003oool0oooo00l0
oooo00170?ooo`800000<P3oool00`000000YkgY0:Nmj@070:Nmj@<000002@2W`^d00`000000Yl;]
0:O2k@040:O2k@<000000P2Vao400`000000Y/O`0:K7l0080:K7l0040000002Wa_00YlK`0:O6l0@0
00000P2Ub_<2000000T0YLWb100000070:?;m08000001P2Sb?<200000080X<_f00<000000:38m02P
b?@0202Pb?@010000000XLKb0:76lP2Qa_8400000080WLKe00<0000009k3lP2N`o801`2N`o800`00
0000Wl3`09o0l00609o0l0L00000102K_>l00`000000W;S/09bhk00709bhk0030000002M]NT0WKGY
00L0WKGY00@0000009jbiP2N/^H0W[;V1000000309Z_iP030000002K[><0VjcS00H0VjcS00<00000
09bYh02LZN001`2LZN000`000000WJOM09fWg@0709fWg@030000002MYM/0WJGK00H0WJGK00<00000
09jSf02NXmP00`2NXmP7000000P0W9gD00<0000009fLdP2MW=801@2MW=82000000X0WY_@00<00000
0?ooo`3oool01`3oool00`000000oooo0?ooo`0>0?ooo`00B@3oool00`000000oooo0?ooo`0`0?oo
o`030000002W_NT0YkgY00@0YkgY0P0000020:O3k@8000002@2W`^d00`000000Yl;]0:O2k@030000
00H0Y/Oa0P0000080:K7l0@00000202Ub_<2000000<0YLWb100000020:?<mP030000002Sbo@0Xl_d
00P0Xl_d00<000000:?8l`2Sb?<00`0000050:3;mP800000202Pb?@4000000L0WLKe0P00000809k3
lP040000002O`?00Wl3`09o0l0@000000`2J_o800`000000Vkc_09^lk`0609^lk`030000002L^>`0
W;S/00L0W;S/00<0000009fej@2M]NT00`2M]NT7000000L0VZoV00<0000009^/h`2K[><01`2K[><0
0`000000W:WP09bYh00709bYh0030000002MYmd0WJOM00H0WJOM00<0000009fUf`2MYM/00`2MYM/9
000000@0VioF00<0000009bMe02LWM@0202LWM@00`000000WIcB09fLdP0509fLdP030000002MW=80
000000X0WY_@00<000000?ooo`3oool01P3oool00`000000oooo0?ooo`0>0?ooo`00BP3oool00`00
0000oooo0?ooo`0`0?ooo`030000002W_NT0YkgY00<000001P2W`nd00`000000Yl;]0:O2k@060:O2
k@<000002`2Vao4010000000Y/O`0:K7l02Vao0400000080YL_d00<000000:G:l`2Ub_<0202Ub_<4
000000L0Xlcf0P0000080:?;m0<000002P2PboH010000000X<Sd0:38m02Pb?@400000080W<Wg00<0
000009g6m@2Ma_D0202Ma_D00`000000W/?b09k3lP0309k3lPH00000202J_o800`000000Vkc_09^l
k`0609^lk`030000002L^>`0W;S/00H0W;S/1P00000509Vbj@030000002J[nH0VZoV00L0VZoV00<0
000009^/h`2K[><01P2K[><00`000000W:WP09bYh00709bYh0030000002MYmd0WJOM00<0WJOM2@00
000409ZQf@030000002KWmH0VioF00L0VioF00<0000009bMe02LWM@0202LWM@00`000000WIcB09fL
dP0509fLdP8000002P2NVm000`000000oooo0?ooo`060?ooo`030000003oool0oooo00h0oooo001;
0?ooo`030000003oool0oooo0300oooo0P00000:0:O3k@8000000P2W`^d400000080Y/Sa0P00000:
0:K7l@@000001`2Ubo@2000000H0YL[c0P0000020:;>m`030000002Sc?H0Xlcf00P0Xlcf00@00000
0:?;m02Sbo@0Xl_d1000000209o=n08000002@2PboH4000000L0W<Wg0P00000809g6m@H00000102I
`o@00`000000V[ob09ZolP0709ZolP030000002K_>l0Vkc_00L0Vkc_00@0000009bhk02L^>`0W;S/
1000000209Rfk@030000002I/^T0VK;Y00H0VK;Y00<0000009Z_iP2J[nH01`2J[nH00`000000VjcS
09^/h`0709^/h`030000002LZN00W:WP00D0W:WP1`00000409ZSg0030000002JXMT0VZ7I00L0VZ7I
00<0000009^OeP2KWmH01P2KWmH00`000000W9gD09bMe00809bMe0030000002MW=80WIcB00H0WIcB
0P00000:09jKd0030000003oool0oooo00D0oooo00<000000?ooo`3oool03P3oool004`0oooo0P00
000a0?ooo`8000002P2W`nd3000000P0Y/Sa00<000000:K7l@2Vao401@2Vao4200000080YLcd00<0
00000:G;m02Ubo@0202Ubo@00`000000YL[c0:G:l`03000000D0X/kg0P0000080:?<mP@00000202O
cOP2000000<0X<_f1000000209_=n@030000002LbOL0W<Wg00P0W<Wg00@0000009g6m@2Ma_D0WLKe
1000000209S6m`030000002I`o@0VL?d00H0VL?d0P00000809ZolP030000002K_>l0Vkc_00<0Vkc_
1`00000609Rfk@030000002I/^T0VK;Y00L0VK;Y00<0000009Z_iP2J[nH01`2J[nH00`000000VjcS
09^/h`0609^/h`040000002LZN00W:WP09bYh0@000000P2IY]l00`000000VZ?L09ZSg00709ZSg003
0000002JXMT0VZ7I00H0VZ7I00<0000009^OeP2KWmH01`2KWmH00`000000W9gD09bMe00809bMe003
0000002MW=80WIcB00H0WIcB00<0000009jKd02NVm001P2NVm03000000L0oooo00<000000?ooo`3o
ool03P3oool004h0oooo00<000000?ooo`3oool0<03oool00`000000Yl?]0:O3k@050:O3k@800000
0P2Vb?400`000000Y/Sa0:K8l@070:K8l@8000000P2Vao43000000D0YLcd0P0000080:G;m0<00000
2P2Rc_L010000000Xlcf0:?<mP2Sc?H400000080W/oi00<0000009o=n02OcOP01`2OcOP5000000L0
Vlgi00<0000009c9m`2LbOL01P2LbOL5000000L0V<Kg00<0000009W3m02I`o@01`2I`o@00`000000
V[ob09ZolP0309ZolPP000001@2G^_000`000000V;K]09Rfk@0609Rfk@030000002I/^T0VK;Y00L0
VK;Y00<0000009Z_iP2J[nH01P2J[nH00`000000VjcS09^/h`0309^/h`L000001`2IY]l00`000000
VZ?L09ZSg00609ZSg0030000002JXMT0VZ7I00L0VZ7I00<0000009^OeP2KWmH01P2KWmH00`000000
W9gD09bMe00809bMe0030000002MW=80WIcB00H0WIcB0P00000209jKd0D000000P2LUlh00`000000
oooo0?ooo`050?ooo`030000003oool0oooo00h0oooo001?0?ooo`030000003oool0oooo0300oooo
0P0000020:O3k@<000001@2Vb?42000000P0Y/Sa0`00000:0:G<m0040000002Ubo@0YL_d0:G;m0@0
00000P2Rd?P2000000T0X/kg1000000709k?n@8000000`2OcOP4000000<0V/ok00<0000009_=n@2K
cOT01`2KcOT010000000W<Wg09c9m`2LbOL4000000<0U/[j00<0000009S6m`2Ha_L01`2Ha_L00`00
0000VL?d09W3m00309W3m0T00000102E__<00`000000Uk[`09Njl00709Njl0030000002H]^d0V;K]
00H0V;K]00<0000009Vbj@2I/^T01P2I/^T00`000000VZoV09Z_iP0309Z_iPT000001@2GZ>800`00
0000VJKO09VVg`0609VVg`030000002JXm`0VZ?L00L0VZ?L00<0000009ZQf@2JXMT01P2JXMT00`00
0000VioF09^OeP0709^OeP030000002LWM@0W9gD00P0W9gD00<0000009fLdP2MW=800P2MW=870000
00P0W9O>00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0>0?ooo`00D03oool00`000000
oooo0?ooo`0a0?ooo`8000002P2Vb?4010000000Y/Sa0:K8l@2Vb?4400000080Y<ge0P0000090:G<
m0@00000202Rd?P2000000<0X/kg1000000209gBnP030000002NcoT0W/oi00L0W/oi1000000809[?
n`8000001@2KcOT6000000P0U/[j00<0000009S6m`2Ha_L01P2Ha_L6000000D0Tl;g00<0000009Fn
l`2E__<01P2E__<00`000000Uk[`09Njl00709Njl0030000002H]^d0V;K]00D0V;K]00<0000009Vb
j@2I/^T00`2I/^T9000000D0UZcV00<0000009NXhP2GZ>801P2GZ>800`000000VJKO09VVg`0709VV
g`030000002JXm`0VZ?L00H0VZ?L00<0000009ZQf@2JXMT01`2JXMT00`000000VioF09^OeP0609^O
eP030000002LWM@0W9gD00@0W9gD2@00000409^Hd08000002@2LUlh00`000000oooo0?ooo`050?oo
o`030000003oool0oooo00d0oooo001A0?ooo`800000<P3oool00`000000Y/Sa0:K8l@080:K8l@@0
0000202TcOD2000000<0YLcd100000020:7An08000002@2Rd?P4000000L0WM;j0P00000309k?n@@0
00000P2Hd_`2000000T0V/ok1P00000409C>o08000002@2Fb_X010000000V<Kg09S6m`2Ha_L40000
0080T<Kj00<0000009?2m`2C`_L01`2C`_L00`000000UKkc09Fnl`0609Fnl`030000002G^_00Uk[`
00<0Uk[`4@00000509B_j@030000002F[>H0UZcV00H0UZcV00<0000009NXhP2GZ>801`2GZ>800`00
0000VJKO09VVg`0609VVg`030000002JXm`0VZ?L00L0VZ?L00<0000009ZQf@2JXMT01P2JXMT00`00
0000VioF09^OeP0309^OePX00000102JVM800`000000ViS@09^Hd00709^Hd08000002@2LUlh00`00
0000oooo0?ooo`040?ooo`030000003oool0oooo00d0oooo001C0?ooo`030000003oool0oooo0300
oooo0P0000060:K8l@8000000P2Tc_H00`000000Y<ge0:C=m@080:C=m@@00000202QdOP2000000<0
X]3h1000000209gDn`030000002Md_X0WM;j00L0WM;j1000000809SBo08000000`2Jco/400000080
T]7m0P00000809C>o08000001@2Fb_X6000000L0T<Kj0P00000809?2m`030000002E__<0UKkc00<0
UKkc20000005096gl@030000002C/nd0Tk?]00D0Tk?]00<0000009B_j@2D[nT01`2D[nT00`000000
UZcV09J/iP0609J/iP030000002GZ>80UjSR00L0UjSR00<0000009VVg`2IY]l01P2IY]l00`000000
VZ?L09ZSg00609ZSg0030000002JXMT0VZ7I00<0VZ7I2@00000409VKe0030000002JVM80VYWB00P0
VYWB00<0000009^Hd02KV=001P2KV=02000000T0W9O>00<000000?ooo`3oool0103oool00`000000
oooo0?ooo`0=0?ooo`00E03oool00`000000oooo0?ooo`0a0?ooo`030000002Vb?40Y/Sa00<00000
1@2Tc_H2000000H0Y<ge0P0000020:7Bn@8000002@2QdOP4000000L0WMCk0P00000309gBnP@00000
0P2GeOd2000000T0V=;l1000000809;Ao@8000001@2Dc_`8000000@0S/[l00<000000936nP2@a_X0
202@a_X00`000000Tl;g09?2m`0309?2m`P00000102>_?D00`000000TKOa096gl@07096gl@030000
002C/nd0Tk?]00D0Tk?]00<0000009B_j@2D[nT01P2D[nT00`000000UZcV09J/iP0709J/iP030000
002GZ>80UjSR00H0UjSR00<0000009VVg`2IY]l01P2IY]l00`000000VZ?L09ZSg00309ZSg0T00000
102GWML00`000000VI_D09VKe00709VKe0030000002JVM80VYWB00L0VYWB00<0000009^Hd02KV=00
1`2KV=02000000P0W9O>00<000000?ooo`3oool0103oool00`000000oooo0?ooo`0=0?ooo`00E@3o
ool00`000000oooo0?ooo`0a0?ooo`8000002P2Tc_H00`000000Y<ge0:C=m@03000000H0XM;i0P00
00030:7An0@000000P2Le_`2000000P0WMCk1000000809OEo@8000000`2Hd_`400000080SmCn0P00
000909;Ao@H00000102;c_h00`000000S/[l08k:o00608k:o08000001@2@a_X9000000@0Rl3i00<0
000008jlm@2>_?D01P2>_?D00`000000TKOa096gl@06096gl@030000002C/nd0Tk?]00D0Tk?]00<0
000009B_j@2D[nT01`2D[nT00`000000UZcV09J/iP0609J/iP030000002GZ>80UjSR00<0UjSR4P00
000409JOfP030000002GWML0UigG00L0UigG00<0000009VKe02IVm@01P2IVm@00`000000VYWB09ZI
dP0809ZIdP030000002KV=00ViS@00H0ViS@00<0000009bGcP000000202LUlh00`000000oooo0?oo
o`030?ooo`030000003oool0oooo00d0oooo001F0?ooo`800000<P3oool2000000T0Y<kf0`00000:
0:7Bn@@00000202Le_`200000080WMCk1000000309GGoP8000001P2GeOd6000000P0SmCn0P000003
09;Ao@@000000P27dOl00`000000Rlkn08_>oP0608_>oP8000001@2>b_`8000000D0QlGl00<00000
08_0n@2;`?T01P2;`?T00`000000S[ce08jlm@0508jlm@030000002A]o40TKOa00L0TKOa00<00000
09>ck@2C/nd01@2C/nd00`000000U:oY09B_j@0309B_jA8000001@2CYN400`000000UJ;N09FRgP06
09FRgP030000002FWmX0UYoJ00H0UYoJ00<0000009NMe`2GWML01P2GWML00`000000VI_D09VKe007
09VKe0030000002JVM80VYWB00L0VYWB00<0000009^Hd02KV=001`2KV=000`000000W9O>00000007
09bGcP030000003oool0oooo00<0oooo00<000000?ooo`3oool03@3oool005P0oooo00<000000?oo
o`3oool0<@3oool2000000<0Y<kf100000030:7DnP800000102Qd_T400000080VmOl0P00000909cF
o0<000002@2Eeoh6000000D0SMOo0P00000608oDoPH000001`27dOl2000000D0Rlkn2000000408?9
oP8000002027aO`00`000000Rl3i08_0n@0608_0n@030000002>_?D0S[ce00D0S[ce00<00000096g
l@2A]o400`2A]o4A000000D0SjcY00<00000096Xi@2AZ>D01P2AZ>D00`000000TjGQ09>Uh@0609>U
h@030000002EX]h0UJ;N00H0UJ;N00<0000009JOfP2FWmX01P2FWmX00`000000UigG09NMe`0709NM
e`030000002IVm@0VI_D00H0VI_D00<0000009ZIdP2JVM80202JVM800`000000ViS@09^Hd00609^H
d0030000002LUlh0000000P0W9O>00<000000?ooo`3oool00P3oool00`000000oooo0?ooo`0=0?oo
o`00F@3oool00`000000oooo0?ooo`0b0?ooo`<000002@2Qe?X4000000P0VmOl0P00000309cFo0@0
00000P2DfOh2000000@0UMOn1000000308[Io`8000001P2=eol8000000@0PmCo0P00000608OAo`P0
0000101nc?l00`000000PlWn08?9oP0708?9oP8000001`27aO`00`000000Rl3i08_0n@0308_0nA00
00001@29]?800`000000S;3^08b`kP0508b`kP030000002?[>T0SjcY00H0SjcY00<00000096Xi@2A
Z>D01P2AZ>D00`000000TjGQ09>Uh@0709>Uh@030000002EX]h0UJ;N00H0UJ;N00<0000009JOfP2F
WmX01P2FWmX00`000000UigG09NMe`0609NMe`030000002IVm@0VI_D00L0VI_D00<0000009ZIdP2J
VM801`2JVM800`000000ViS@09^Hd00709^Hd0030000002LUlh0000000<0W9O>1@0000050?ooo`03
0000003oool0oooo00`0oooo001J0?ooo`030000003oool0oooo03<0oooo0P0000040:7DnP@00000
0P2KfOd2000000T0VmOl1000000809CIoP@000002@2:fOl6000000@0O]Ko0P00000608?Do`P00000
101hcol2000000L0O/co0P00000508?9oQ4000001021_OX00`000000QKWg08Fim`0508Fim`030000
0029]?80RKCb00L0RKCb00<0000008b`kP2</>h01@2</>h00`000000SjcY08n/j@0608n/j@030000
002AZ>D0TJSU00H0TJSU00<0000009>Uh@2CYN401P2CYN400`000000UJ;N09FRgP0609FRgP030000
002FWmX0UYoJ00H0UYoJ00<0000009NMe`2GWML01`2GWML00`000000VI_D09VKe00609VKe0030000
002JVM80VYWB00P0VYWB00<0000009^Hd02KV=000P2KV=0:000000@0VY?<00<000000?ooo`3oool0
0`3oool00`000000oooo0?ooo`0<0?ooo`00F`3oool2000003D0oooo1000000809_Io@8000000`2K
eo`4000000<0T]_n0P00000309CIoP@000000`28fol2000000@0R]Wo1000000307[Ho@8000001@1n
e_l8000000D0L]7n0P00000507S?oa0000001@1daOl00`000000Nl;m07_2o@0507_2o@0300000021
_OX0PKgj00H0PKgj00<0000008Fim`25^OL01@25^OL00`000000RKCb08VdlP0608VdlP030000002<
/>h0S;3^00D0S;3^00<0000008n/j@2?[>T01`2?[>T00`000000TJSU096Xi@06096Xi@030000002C
YN40TjGQ00H0TjGQ00<0000009FRgP2EX]h01P2EX]h00`000000UYoJ09JOfP0609JOfP030000002G
WML0UigG00H0UigG00<0000009VKe02IVm@01`2IVm@00`000000VYWB09ZIdP0309ZIdPT00000102H
U<h01@000000VY?<09ZCc02JTl`0000000H0VY?<00<000000?ooo`3oool00P3oool00`000000oooo
0?ooo`0<0?ooo`00G@3oool00`000000oooo0?ooo`0d0?ooo`8000002@2KfOd4000000L0T]_n1P00
000608SKo`H000001`1jf?d7000000D0Jm;k3`00000506C9o08000001P1]b?h2000000L0M<Go0P00
000607_2o@8000001`21_OX00`000000QKWg08Fim`0508Fim`0300000029]?80RKCb00H0RKCb00<0
000008b`kP2</>h01@2</>h00`000000SjcY08n/j@0608n/j@030000002AZ>D0TJSU00H0TJSU00<0
000009>Uh@2CYN401P2CYN400`000000UJ;N09FRgP0609FRgP030000002FWmX0UYoJ00H0UYoJ00<0
000009NMe`2GWML00`2GWMLC000000@0UiK@00<0000009RDcP2HU<h01`2HU<h010000000VY?<09ZC
c000000609ZCc0030000003oool0oooo0080oooo00<000000?ooo`3oool0303oool005h0oooo00<0
00000?ooo`3oool0=@3oool2000000<0VmWm10000004097MoPL000001P25g?h6000000D0M]Wk2000
000406CBmPP00000101@ao02000000H0F/WgMP00000409BIeP030000002FUm<0UYOC00H0UYOC00<0
000009NFd02GU]00202GU]000`000000V9C>09RDcP0609RDcP050000002JTl`0VY?<09ZCc0000000
1P2JTl`01@000000oooo0?ooo`3oool0000000h0oooo001O0?ooo`030000003oool0oooo03H0oooo
0`000005097MoP@000000`23gOd2000000@0QMcn1000000307;In0L00000101NdO48000000D0AlGW
3`00000403bkj@8000001P1:_o<2000000H0E/3j0P00000606:oo@030000001/_Od0K;gm00D0K;gm
00<0000007Bin`1d^O/01@1d^O/00`000000NkGh07^en00507^en00300000021/?<0PK3c00H0PK3c
00<0000008F/kP25[>h01@25[>h00`000000RJSY08VXj@0608VXj@030000002<Y>D0S:CU00H0S:CU
00<0000008jQh@2>XN401P2>XN400`000000T9kL092Ng006092Ng0030000002BVmT0TY_I00D0TY_I
00<0000009BIeP2DVMH01`2DVMH00`000000UYOC09JGd`0609JGd`030000002GU]00UiK@00L0UiK@
00<0000009RDcP2HU<h01`2HU<h01@000000VY?<09ZCc02JTl`0000000D0VY?<00D000000?ooo`3o
ool0oooo0000000>0?ooo`00H03oool2000003T0oooo1@00000708?Mo@H00000101bfOP4000000<0
F=3[?P00000206:oo@8000001P1/_Od2000000H0M;Wk00<0000007^en01k]OP01@1k]OP00`000000
PK3c086`l`06086`l`0300000025[>h0QJc^00@0QJc^00<0000008VXj@29Z>T01P29Z>T00`000000
S:CU08bTi@0608bTi@030000002>XN40SZ7Q00H0SZ7Q00<00000092Ng02@W]`01P2@W]`00`000000
TY_I09:Kf@0609:Kf@030000002DVMH0U9WF00H0U9WF00<0000009JGd`2FUm<01P2FUm<00`000000
UiK@09NFd00809NFd0030000002HU<h0V9C>00H0V9C>00D0000009ZCc02JTl`0VY?<0000000509ZC
c0030000003oool0oooo0080oooo00<000000?ooo`3oool02`3oool00680oooo00<000000?ooo`3o
ool0>`3oool7000000D0Km[e5@00000R0?ooo`L0000000<0:JgT0000000000001P0j/o0200000003
04Zfn0000000000000h000000`1d^O/00`000000NkGh07^en00507^en00300000021/?<0PK3c00D0
PK3c00<0000008F/kP25[>h01@25[>h00`000000RJSY08VXj@0608VXj@030000002<Y>D0S:CU00H0
S:CU00<0000008jQh@2>XN401P2>XN400`000000T9kL092Ng006092Ng0030000002BVmT0TY_I00D0
TY_I00<0000009BIeP2DVMH01`2DVMH00`000000UYOC09JGd`0609JGd`030000002GU]00UiK@00L0
UiK@00<0000009RDcP2HU<h01P2HU<h00`000000VY?<09ZCc00209ZCc0030000002JTl`0VY?<00<0
VY?<00D000000?ooo`3oool0oooo0000000=0?ooo`00H`3oool00`000000oooo0?ooo`0o0?oooa00
00001@3oool00`000000oooo0?ooo`0]0?oooa00000000<0B[Kh0000000000001P1H]O`00`000000
I;?k06Bcn`0A000000<0PK3c00<0000008F/kP25[>h01@25[>h00`000000RJSY08VXj@0608VXj@03
0000002<Y>D0S:CU00D0S:CU00<0000008jQh@2>XN401P2>XN400`000000T9kL092Ng006092Ng003
0000002BVmT0TY_I00H0TY_I00<0000009BIeP2DVMH01P2DVMH00`000000UYOC09JGd`0609JGd`03
0000002GU]00UiK@00P0UiK@00<0000009RDcP2HU<h01P2HU<h00`000000VY?<09ZCc00209ZCc003
0000002JTl`0VY?<0080VY?<00D000000?ooo`3oool0oooo0000000=0?ooo`00I03oool00`000000
oooo0?ooo`1C0?ooo`030000003oool0oooo03d0oooo2000000205Reo08000001@1T/o/00`000000
K[3h06j`n00506j`n0040000001f[?@0MZcd07J/m0P000000`25[>h00`000000RJSY08VXj@0608VX
j@030000002<Y>D0S:CU00H0S:CU00<0000008jQh@2>XN401P2>XN400`000000T9kL092Ng006092N
g0030000002BVmT0TY_I00D0TY_I00<0000009BIeP2DVMH01`2DVMH00`000000UYOC09JGd`0609JG
d`030000002GU]00UiK@00L0UiK@00<0000009RDcP2HU<h01P2HU<h00`000000VY?<09ZCc00309ZC
c0030000002JTl`0VY?<0080VY?<00@000000?ooo`3oool000003@3oool006D0oooo0P00001C0?oo
o`030000003oool0oooo04D0oooo1P00000406Bcn`030000001^/?P0K[3h00D0K[3h00<0000007J/
m01f[?@01@1f[?@00`000000O:O_07bWk`0B000000<0S:CU00<0000008jQh@2>XN401P2>XN400`00
0000T9kL092Ng006092Ng0030000002BVmT0TY_I00H0TY_I00<0000009BIeP2DVMH01P2DVMH00`00
0000UYOC09JGd`0609JGd`030000002GU]00UiK@00P0UiK@00<0000009RDcP2HU<h01P2HU<h00`00
0000VY?<09ZCc00209ZCc0H000000P3oool00`000000oooo0?ooo`0;0?ooo`00I`3oool00`000000
oooo0?ooo`1@0?ooo`030000003oool0oooo04/0oooo100000000`1T/o/0000006j`n00506j`n003
0000001f[?@0MZcd00H0MZcd00<0000007bWk`1lYnl0101lYnl00`000000PJ?Y086Sj@06086Sj@04
00000025Wn@0QIoT08FOi1/000000`2BVmT00`000000U9WF09BIeP0709BIeP030000002FUm<0UYOC
00H0UYOC00<0000009NFd02GU]000`2GU]0D000000<0V93:00@000000?ooo`3oool000003@3oool0
06P0oooo00<000000?ooo`3oool0C`3oool00`000000oooo0?ooo`1?0?ooo`H000000`1^/?P00`00
0000MZcd07J/m00507J/m0030000001lYnl0O:O_00D0O:O_00<00000086Sj@21XnT01@21XnT00`00
0000QIoT08FOi00608FOi00300000029W>00RIcP00H0RIcP00<0000008bIf`2<VM/01@2<VM/00`00
0000SYOH08jGf00208jGf1`00000102DT/h00`000000UY7<09JAc00609JAc0030000002HT<X0V93:
00@0V93:00L0000009R@bP2HT<X0V93:0000003oool0000000d0oooo001Y0?ooo`030000003oool0
oooo04h0oooo00<000000?ooo`3oool0E@3oool9000000<0MZcd00<0000007bWk`1lYnl0101lYnl0
0`000000PJ?Y086Sj@06086Sj@0300000025Wn@0QIoT00D0QIoT00<0000008VLh029W>001P29W>00
0`000000S9WK08bIf`0608bIf`030000002>UmP0SYOH00D0SYOH00<00000092Ee02@UM@01P2@UM@0
0`000000TY?A09:Cd@0709:Cd@030000002DT/h0U9;>00L0U9;>00<0000009JAc02FTL`01P2FTL`0
0`000000V93:09R@bP0409R@bP040000002HT<X0V93:00000080oooo00<000000?ooo`3oool02P3o
ool006X0oooo0P00001>0?ooo`030000003oool0oooo05h0oooo2000000307bWk`0300000021XnT0
PJ?Y00H0PJ?Y00<0000008FOi025Wn@01@25Wn@00`000000RIcP08VLh00608VLh0030000002<VM/0
S9WK00D0S9WK00<0000008jGf02>UmP01P2>UmP00`000000T9GD092Ee006092Ee0030000002BTm40
TY?A00H0TY?A00<0000009BBcP2DT/h01`2DT/h00`000000UY7<09JAc00609JAc0030000002HT<X0
V93:00@0V93:00@0000009R@bP2HT<X000000P3oool00`000000oooo0?ooo`0:0?ooo`00K03oool0
0`000000oooo0?ooo`1;0?ooo`030000003oool0oooo06H0oooo2@000003086Sj@0300000025Wn@0
QIoT00H0QIoT00<0000008VLh029W>001@29W>000`000000S9WK08bIf`0608bIf`030000002>UmP0
SYOH00D0SYOH00<00000092Ee02@UM@01P2@UM@00`000000TY?A09:Cd@0709:Cd@030000002DT/h0
U9;>00L0U9;>00<0000009JAc02FTL`01P2FTL`00`000000V93:09R@bP0409R@bP060000002HT<X0
V93:0000003oool00000303oool006d0oooo00<000000?ooo`3oool0B@3oool00`000000oooo0?oo
o`1`0?ooo`T000000`25Wn@00`000000RIcP08VLh00608VLh0030000002<VM/0S9WK00D0S9WK00<0
000008jGf02>UmP01P2>UmP00`000000T9GD092Ee006092Ee0030000002BTm40TY?A00H0TY?A00<0
000009BBcP2DT/h01`2DT/h00`000000UY7<09JAc00609JAc0030000002HT<X0V93:00D0V93:00D0
000009R@bP000000oooo0000000<0?ooo`00KP3oool00`000000oooo0?ooo`180?ooo`030000003o
ool0oooo07T0oooo2@00000308VLh0030000002<VM/0S9WK00H0S9WK00<0000008jGf02>UmP01@2>
UmP00`000000T9GD092Ee006092Ee0030000002BTm40TY?A00L0TY?A00<0000009BBcP2DT/h01P2D
T/h00`000000UY7<09JAc00709JAc0030000002HT<X0V93:00D0V93:00@0000009R@bP0000000000
303oool006l0oooo0P0000180?ooo`030000003oool0oooo0880oooo2@00000308bIf`030000002>
UmP0SYOH00H0SYOH00<00000092Ee02@UM@01P2@UM@00`000000TY?A09:Cd@0609:Cd@030000002D
T/h0U9;>00L0U9;>00<0000009JAc02FTL`01P2FTL`00`000000V93:09R@bP0509R@bP040000002H
T<X00000000000`0oooo001a0?ooo`030000003oool0oooo04D0oooo00<000000?ooo`3oool0R`3o
ool9000000<0SYOH00<00000092Ee02@UM@01P2@UM@00`000000TY?A09:Cd@0709:Cd@030000002D
T/h0U9;>00H0U9;>00<0000009JAc02FTL`01`2FTL`00`000000V93:09R@bP0509R@bP<00000303o
ool00780oooo00<000000?ooo`3oool0A03oool00`000000oooo0?ooo`2D0?oooa800000102BTm40
0`000000U9;>09BBcP0709BBcP030000002FTL`0UY7<00H0UY7<00<0000009R@bP2HT<X01P2HT<X3
000000/0oooo001c0?ooo`030000003oool0oooo04<0oooo00<000000?ooo`3oool0YP3ooolS0000
00/0oooo001d0?ooo`800000@`3oool00`000000oooo0?ooo`370?ooo`8000002`3oool007H0oooo
00<000000?ooo`3oool0@03oool00`000000oooo0?ooo`370?ooo`8000002`3oool007L0oooo00<0
00000?ooo`3oool0?`3oool00`000000oooo0?ooo`330?ooo`@000003@3oool007P0oooo0P00000o
0?ooo`030000003oool0oooo0;l0oooo1000000A0?ooo`00NP3oool00`000000oooo0?ooo`0l0?oo
o`030000003oool0oooo0;/0oooo1000000E0?ooo`00N`3oool00`000000oooo0?ooo`0k0?ooo`03
0000003oool0oooo0;L0oooo1000000I0?ooo`00O03oool00`000000oooo0?ooo`0j0?ooo`030000
003oool0oooo0;<0oooo1000000M0?ooo`00O@3oool2000003X0oooo00<000000?ooo`3oool0[`3o
ool400000240oooo001o0?ooo`030000003oool0oooo03L0oooo00<000000?ooo`3oool0Z`3oool4
000002D0oooo00200?ooo`030000003oool0oooo03H0oooo00<000000?ooo`3oool0Y`3oool40000
02T0oooo00210?ooo`030000003oool0oooo03D0oooo00<000000?ooo`3oool0X`3oool4000002d0
oooo00220?ooo`800000=@3oool00`000000oooo0?ooo`2O0?ooo`@00000<@3oool008@0oooo00<0
00000?ooo`3oool0<P3oool00`000000oooo0?ooo`2K0?ooo`@00000=@3oool008D0oooo00<00000
0?ooo`3oool0<@3oool00`000000oooo0?ooo`2G0?ooo`@00000>@3oool008H0oooo00<000000?oo
o`3oool0<03oool00`000000oooo0?ooo`2C0?ooo`@00000?@3oool008L0oooo0P00000`0?ooo`03
0000003oool0oooo08l0oooo100000110?ooo`00R@3oool00`000000oooo0?ooo`0]0?ooo`030000
003oool0oooo08/0oooo100000150?ooo`00RP3oool00`000000oooo0?ooo`0/0?ooo`030000003o
ool0oooo08L0oooo100000190?ooo`00R`3oool00`000000oooo0?ooo`0Z0?ooo`030000003oool0
oooo08D0oooo0`00001=0?ooo`00S03oool2000002X0oooo00<000000?ooo`3oool0P@3oool40000
0500oooo002>0?ooo`030000003oool0oooo02L0oooo00<000000?ooo`3oool0O@3oool4000005@0
oooo002?0?ooo`030000003oool0oooo02H0oooo00<000000?ooo`3oool0N@3oool4000005P0oooo
002@0?ooo`030000003oool0oooo02D0oooo00<000000?ooo`3oool0M@3oool4000005`0oooo002A
0?ooo`8000009@3oool00`000000oooo0?ooo`1a0?ooo`@00000H03oool009<0oooo00<000000?oo
o`3oool08P3oool00`000000oooo0?ooo`1]0?ooo`@00000I03oool009@0oooo00<000000?ooo`3o
ool08@3oool00`000000oooo0?ooo`1Y0?ooo`@00000J03oool009D0oooo00<000000?ooo`3oool0
803oool00`000000oooo0?ooo`1U0?ooo`@00000K03oool009H0oooo0P00000P0?ooo`030000003o
ool0oooo0640oooo1000001`0?ooo`00V03oool00`000000oooo0?ooo`0M0?ooo`030000003oool0
oooo05d0oooo1000001d0?ooo`00V@3oool00`000000oooo0?ooo`0L0?ooo`030000003oool0oooo
05T0oooo1000001h0?ooo`00VP3oool00`000000oooo0?ooo`0K0?ooo`030000003oool0oooo05D0
oooo1000001l0?ooo`00V`3oool2000001/0oooo00<000000?ooo`3oool0D@3oool400000800oooo
002M0?ooo`030000003oool0oooo01P0oooo00<000000?ooo`3oool0C@3oool4000008@0oooo002N
0?ooo`030000003oool0oooo01L0oooo00<000000?ooo`3oool0B@3oool4000008P0oooo002O0?oo
o`030000003oool0oooo01H0oooo00<000000?ooo`3oool0A@3oool4000008`0oooo002P0?ooo`80
00005P3oool00`000000oooo0?ooo`110?ooo`@00000T03oool00:80oooo00<000000?ooo`3oool0
4`3oool00`000000oooo0?ooo`0n0?ooo`<00000U03oool00:<0oooo00<000000?ooo`3oool04P3o
ool00`000000oooo0?ooo`0j0?ooo`@00000U`3oool00:@0oooo00<000000?ooo`3oool04@3oool0
0`000000oooo0?ooo`0f0?ooo`@00000V`3oool00:D0oooo0P00000A0?ooo`030000003oool0oooo
0380oooo1000002O0?ooo`00Y`3oool00`000000oooo0?ooo`0>0?ooo`030000003oool0oooo02h0
oooo1000002S0?ooo`00Z03oool00`000000oooo0?ooo`0=0?ooo`030000003oool0oooo02X0oooo
1000002W0?ooo`00Z@3oool00`000000oooo0?ooo`0;0?ooo`030000003oool0oooo02L0oooo1000
002[0?ooo`00ZP3oool2000000/0oooo00<000000?ooo`3oool08`3oool400000:l0oooo002/0?oo
o`030000003oool0oooo00P0oooo00<000000?ooo`3oool07`3oool400000;<0oooo002]0?ooo`03
0000003oool0oooo00L0oooo00<000000?ooo`3oool06`3oool400000;L0oooo002^0?ooo`030000
003oool0oooo00H0oooo00<000000?ooo`3oool05`3oool400000;/0oooo002_0?ooo`8000001P3o
ool00`000000oooo0?ooo`0C0?ooo`@00000_`3oool00;40oooo00<000000?ooo`3oool00`3oool0
0`000000oooo0?ooo`0?0?ooo`@00000``3oool00;80oooo00<000000?ooo`3oool00P3oool00`00
0000oooo0?ooo`0;0?ooo`@00000a`3oool00;<0oooo00D000000?ooo`3oool0oooo000000090?oo
o`@00000b`3oool00;@0oooo0P0000000`3oool000000?ooo`040?ooo`@00000c`3oool00;H0oooo
0P0000000`3oool000000000000200000=<0oooo002g0?ooo`800000e`3oool00?l0ooooT@3oool0
0?l0ooooT@3oool00?l0ooooT@3oool00?l0ooooT@3oool00?l0ooooT@3oool00?l0ooooT@3oool0
0001\
\>"],
  ImageRangeCache->{{{0, 399}, {319, 0}} -> {-0.137708, -0.0537357, \
0.00280954, 0.00284865}}],

Cell[BoxData[
    TagBox[\(\[SkeletonIndicator]  SurfaceGraphics  \[SkeletonIndicator]\),
      False,
      Editable->False]], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Export["\<G:\Robert\Vorlesungen\Variationsrechnung\Pr\[ADoubleDot]\
sentation\2Dvar.png\>", zweidvar, \ ImageSize \[Rule] 400]\)], "Input"],

Cell[BoxData[
    \("G:\\Robert\\Vorlesungen\\Variationsrechnung\\Pr\[ADoubleDot]sentation\\\
2Dvar.png"\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"5.0 for Microsoft Windows",
ScreenRectangle->{{0, 1152}, {0, 791}},
WindowSize->{1144, 764},
WindowMargins->{{0, Automatic}, {Automatic, 0}}
]

(*******************************************************************
Cached data follows.  If you edit this Notebook file directly, not
using Mathematica, you must remove the line containing CacheID at
the top of  the file.  The cache data will then be recreated when
you save this file from within Mathematica.
*******************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1754, 51, 332, 5, 22, "Message"],

Cell[CellGroupData[{
Cell[2111, 60, 77, 1, 50, "Input"],
Cell[2191, 63, 36, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2264, 69, 84, 1, 42, "Input"],
Cell[2351, 72, 64, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2452, 78, 125, 2, 63, "Input"],
Cell[2580, 82, 65, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2682, 88, 109, 2, 30, "Input"],
Cell[2794, 92, 22859, 617, 267, 4846, 390, "GraphicsData", "PostScript", \
"Graphics"],
Cell[25656, 711, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[25823, 719, 57, 1, 30, "Input"],
Cell[25883, 722, 53, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[25973, 728, 56, 1, 30, "Input"],
Cell[26032, 731, 52, 1, 29, "Output"]
}, Open  ]],
Cell[26099, 735, 115, 2, 50, "Input"],

Cell[CellGroupData[{
Cell[26239, 741, 2640, 65, 90, "Input"],
Cell[28882, 808, 38536, 954, 328, 13177, 637, "GraphicsData", "PostScript", \
"Graphics"],
Cell[67421, 1764, 130, 3, 29, "Output"]
}, Open  ]],
Cell[67566, 1770, 26, 0, 30, "Input"],

Cell[CellGroupData[{
Cell[67617, 1774, 232, 3, 70, "Input"],
Cell[67852, 1779, 324, 5, 22, "Message"],
Cell[68179, 1786, 41, 1, 29, "Output"]
}, Open  ]],
Cell[68235, 1790, 173, 4, 50, "Input"],

Cell[CellGroupData[{
Cell[68433, 1798, 318, 6, 50, "Input"],
Cell[68754, 1806, 31431, 851, 328, 13715, 629, "GraphicsData", "PostScript", \
"Graphics"],
Cell[100188, 2659, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[100355, 2667, 82, 1, 30, "Input"],
Cell[100440, 2670, 38652, 958, 328, 13237, 641, "GraphicsData", "PostScript", \
"Graphics"],
Cell[139095, 3630, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[139262, 3638, 152, 2, 30, "Input"],
Cell[139417, 3642, 116, 2, 29, "Output"]
}, Open  ]],
Cell[139548, 3647, 26, 0, 30, "Input"],

Cell[CellGroupData[{
Cell[139599, 3651, 164, 2, 30, "Input"],
Cell[139766, 3655, 122, 2, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[139925, 3662, 150, 3, 42, "Input"],
Cell[140078, 3667, 53, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[140168, 3673, 181, 3, 63, "Input"],
Cell[140352, 3678, 53, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[140442, 3684, 88, 2, 50, "Input"],
Cell[140533, 3688, 53, 1, 29, "Output"]
}, Open  ]],
Cell[140601, 3692, 278, 9, 50, "Input"],

Cell[CellGroupData[{
Cell[140904, 3705, 45, 1, 30, "Input"],
Cell[140952, 3708, 46, 1, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[141035, 3714, 184, 4, 110, "Input"],
Cell[141222, 3720, 45, 1, 29, "Output"],
Cell[141270, 3723, 45, 1, 29, "Output"],
Cell[141318, 3726, 38, 1, 41, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[141393, 3732, 130, 3, 50, "Input"],
Cell[141526, 3737, 348, 6, 22, "Message"],
Cell[141877, 3745, 91, 1, 29, "Output"]
}, Open  ]],
Cell[141983, 3749, 26, 0, 30, "Input"],

Cell[CellGroupData[{
Cell[142034, 3753, 77, 1, 30, "Input"],
Cell[142114, 3756, 43202, 1150, 296, 9473, 729, "GraphicsData", "PostScript", \
"Graphics"],
Cell[185319, 4908, 132, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[185488, 4916, 160, 3, 30, "Input"],
Cell[185651, 4921, 328, 5, 22, "Message"],
Cell[185982, 4928, 677, 16, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[186696, 4949, 695, 17, 30, "Input"],
Cell[187394, 4968, 529, 10, 76, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[187960, 4983, 2531, 65, 70, "Input"],
Cell[190494, 5050, 47702, 1192, 328, 17420, 814, "GraphicsData", \
"PostScript", "Graphics"],
Cell[238199, 6244, 130, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[238366, 6252, 156, 2, 30, "Input"],
Cell[238525, 6256, 118, 2, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[238680, 6263, 56, 1, 30, "Input"],
Cell[238739, 6266, 1003, 17, 124, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[239779, 6288, 261, 5, 30, "Input"],
Cell[240043, 6295, 175909, 3536, 328, 68989, 2211, "GraphicsData", \
"PostScript", "Graphics"],
Cell[415955, 9833, 137, 3, 29, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[416129, 9841, 159, 2, 30, "Input"],
Cell[416291, 9845, 118, 2, 29, "Output"]
}, Open  ]]
}
]
*)



(*******************************************************************
End of Mathematica Notebook file.
*******************************************************************)

