;
; Kernel1.0 (C) rk.bo02/01
;

		list P=16F84,n=80

		ERRORLEVEL -302

		include	<p16F84.inc>


		__config _XT_OSC & _PWRTE_ON & _WDT_OFF

		radix hex


; ------------------ declare all necessary stuff ------------------

tmr0value = .256-.200+.3		; 200us/Int
; baud = 1200

bitlen = .4			; (1/baud/TMR0)
TxBitCnt = bitlen*10		; (TX bits + 2)*bitlen
RxInitCnt = bitlen+(bitlen/2)	; bitlen + bitlen/2

	CBLOCK 0x0C

temp		; for general purposes
temp2
temp3
loop
count

W_Save	;(I)
S_Save	;(I)
; ---------------------------  System  ---------------------------
CondReg
ConfigReg
KernelReg
; ---------------------------  timing  ---------------------------
ticks	;(I)
mdelay	;(I)
wdelay
sldelay
; ---------------------------  Kernel  ---------------------------
kdelay
ktemp
kloop
LED01
LED02
LED03
LED04
LED
LEDCnt
KeyRes
; ------------------------  RS 232 stuff  ------------------------
RS232Reg	;(I)
TxReg	;(I)
TxBuf	;(I)
TxCnt	;(I)
RxReg	;(I)
RxBuf	;(I)
RxCnt	;(I)
bitlencnt	;(I)
; ---------------------  Serial Communication  -------------------
CharCnt
CharSum
pointer
DCmdCnt
DCmdS	

	ENDC

; KernelReg
#define		KR00 	KernelReg,0
#define 	KR01	KernelReg,1
#define 	KR02	KernelReg,2
#define 	KR03	KernelReg,3
#define 	KR04	KernelReg,4
#define 	KR05	KernelReg,5
#define 	KeyPressed	KernelReg,6
#define		tmsflag	KernelReg,7

;	PortA
#define		Key01	PORTA,0
#define		Key02	PORTA,1
#define		Key03	PORTA,2
#define		Key04	PORTA,3

#define		SRegClock	PORTA,0
#define		SRegData	PORTA,1

;	PortB
#define		RxD	PORTB,0
#define		TxD	PORTA,4

#define		DataIn		PORTB,4
#define		B05		PORTB,5
#define		Rel01	PORTB,6
#define		Rel02	PORTB,7

; ConfigReg
#define		Co0		ConfigReg,0
#define		Co1		ConfigReg,1
#define		Co2		ConfigReg,2
#define		Co3		ConfigReg,3
#define		Co4		ConfigReg,4
#define		Co5		ConfigReg,5
#define		Co6		ConfigReg,6
#define		Co7		ConfigReg,7

; CondReg
#define		CR00	CondReg,0
#define 	CR01	CondReg,1
#define 	CR02	CondReg,2
#define 	CR03	CondReg,3
#define 	CR04	CondReg,4
#define 	CR05	CondReg,5
#define 	CR06	CondReg,6
#define		CR07	CondReg,7

; RS232Reg
#define		TxFlg	RS232Reg,0
#define		RxFlg	RS232Reg,1
#define		ValMode	RS232Reg,2
#define		ValErr	RS232Reg,3
#define		nibble	RS232Reg,4
#define		CmdFound	RS232Reg,5

;

	org 0
	
 	goto Start

	org 4

; ----------------------  Interrupt Routinen ----------------------

Interrupt
	movwf W_Save
	swapf W_Save,f
	swapf STATUS,w		; Zero flag preserve
	movwf S_Save
	bcf STATUS,RP0		; force Bank0

IntCheck
	btfsc INTCON,T0IF	; Timer Interrupt?
	goto ServiceTMR0	; yes, it is!
	btfsc INTCON,INTF	; INT Interrupt?
	goto ServiceRX		; yes, it is!

IntEnd
	swapf S_Save,W
	movwf STATUS
	swapf W_Save,W
	retfie

ServiceRX
	movlw RxInitCnt
	movwf RxCnt
	movlw h'80'		; RX init
	movwf RxReg
	bcf INTCON,INTE
	bcf INTCON,INTF
	goto IntEnd

ServiceTMR0
	incf ticks,f	; Uhr stellen
	goto ServiceTX

ChkTxCnt
	movwf TxCnt
	decfsz bitlencnt,f	; mod bitlen=0 --> next bit
	goto CheckRx		; else Check RX

	movlw bitlen
	movwf bitlencnt		; nachladen
	setc			; carry fr Stoppbit
	rrf TxReg,f		; transmit LSB first
	goto OutputBit

ServiceTX
	decfsz TxCnt,w
	goto ChkTxCnt		; transfer in progress
	btfss TxFlg
	goto CheckRx		; nothing to transfer
	movf TxBuf,w
	movwf TxReg
	movlw TxBitCnt
	movwf TxCnt
	movlw bitlen
	movwf bitlencnt
	bcf TxFlg
	clrc			; clear carry for start bit

OutputBit			; carry = HIGH
	skpc
	bcf TxD
	skpnc
	bsf TxD

CheckRx
	btfss INTCON,INTE	; RX in progress?
	decfsz RxCnt,f		; time for next bit?
	goto timerms
	movlw bitlen		; reload bit counter for next bit
	movwf RxCnt

	rrf PORTB,w		; RxOut in carry
	rrf RxReg,f		; carry in RxReg einschieben
	skpc			; if carry, then RX is done
	goto timerms
	movf RxReg,w
	movwf RxBuf
	bsf RxFlg		; set RX flag

timerms
	btfsc tmsflag
	goto tmrms01
	movf ticks,w
	xorwf mdelay,w
	btfss STATUS,Z		; schon 1ms abgelaufen?
	goto IntAdj
	bsf tmsflag
tmrms01
	movf ticks,w
	clrc
	addlw .19				; fr 1ms
	movwf mdelay		; neuer Wert!

	decfsz kdelay,f
	goto IntAdj

IntKeyDisp
	btfsc LEDCnt,0	; #1?
	goto IKD01
	btfsc LEDCnt,1	; #2?
	goto IKD02
	btfsc LEDCnt,2	; #3?
	goto IKD03
	bcf LEDCnt,3
	bsf LEDCnt,0		; #1 on
	movfw LED01
	goto IKDEnd
IKD01
	bcf LEDCnt,0
	bsf LEDCnt,1	; #2 on
	movfw LED02
	goto IKDEnd
IKD02
	bcf LEDCnt,1
	bsf LEDCnt,2	; #3 on
	movfw LED03
	goto IKDEnd
IKD03
	bcf LEDCnt,2
	bsf LEDCnt,3	; #4 on
	movfw LED04

IKDEnd		; w enth"alt LED#
	call LEDTab
	movwf LED
	movlw .8
	movwf kloop
	movfw LEDCnt
	movwf ktemp

DO01	bcf SRegData
	rlf ktemp,f
	btfsc STATUS,C
	bsf SRegData
	bsf SRegClock	; toggle
	bcf SRegClock
	decfsz kloop,f
	goto DO01

	movlw .8
	movwf kloop
	movfw LED
	movwf ktemp

DO02	bcf SRegData
	rlf ktemp,f
	btfsc STATUS,C
	bsf SRegData
	bsf SRegClock	; toggle
	bcf SRegClock
	decfsz kloop,f
	goto DO02
	movlw .2
	movwf kdelay

IntAdj
	movlw tmr0value
	addwf TMR0,f
	bcf INTCON,INTF
	bsf INTCON,INTE
	bcf INTCON,T0IF		; start timer
	goto IntEnd

; ------------------------  DisplayInt  ---------------------


; ------------------------  Siebensegment  ---------------------


LEDTab
	addwf PCL,f
	retlw B'10110111'	; 0
	retlw B'00010100'	; 1
	retlw B'01110011'	; 2
	retlw B'01110110'	; 3
	retlw B'11010100'	; 4
	retlw B'11100110'	; 5
	retlw B'11000111'	; 6
	retlw B'00110100'	; 7
	retlw B'11110111'	; 8
	retlw B'11110100'	; 9
	retlw B'11110101'	; A	-10
	retlw B'11000111'	; B	-11
	retlw B'01000011'	; C	-12
	retlw B'01010111'	; D	-13
	retlw B'11100011'	; E	-14
	retlw B'11100001'	; F	-15
	retlw B'11100111'	; G	-16
	retlw B'11000101'	; H	-17
	retlw B'00000100'	; I	-18
	retlw B'10000011'	; L	-19
	retlw B'01000101'	; N	-20
	retlw B'01000111'	; o	-21
	retlw B'11110001'	; P	-22
	retlw B'01000001'	; r	-23
	retlw B'11100110'	; S	-24
	retlw B'01010100'	; T	-25
	retlw B'00000111'	; U	-26
	retlw B'00000000'	; space	-27
	
DTEnd
	retlw 0

	if ( (LEDTab & 0x0FF) >= (DTEnd & 0x0FF) )
       		MESSG 'Warning: LEDTab crosses page boundry'
    	endif

MessageTab
	addwf PCL,f
	retlw 0
	retlw .13
	retlw .10
	retlw .10
	dt "PIC 16F84 Evaluation-board 1.0 (C) rk.bo"	; msg #1
	retlw 0
	dt "ok"			; msg #2
	retlw 0
	dt "error"		; msg #3
	retlw 0
	retlw .13		; msg #4
	retlw .10
	retlw 0
	dt "ready"		; msg #5
	retlw .13
	retlw 0
MTEnd
	retlw 0

	if ( (MessageTab & 0x0FF) >= (MTEnd & 0x0FF) )
       MESSG "Warning: MessageTab crosses page boundry"
    endif	

; ------------------------  Initialisierung  ---------------------

Init
	bcf STATUS,RP0	; Bank 0
	movlw 0x0C		; RAM lschen
	movwf FSR
in01	
	clrf INDF
	incf FSR,f
	movlw H'2F'		; EoRAM
	xorwf FSR,w
	btfss STATUS,Z
	goto in01

	movlw H'01'		; init RS232C
	movwf TxCnt
	clrf RxCnt
	clrf RS232Reg

	bsf tmsflag		; init mstimer

InitPorts
	clrf PORTA
	clrf PORTB				; all outputs low
	bsf STATUS,RP0		; Bank 1 select
	movlw B'11101100'
	movwf TRISA				; PortA Input
	movlw B'11110001'
	movwf TRISB				; PortB 
	bcf STATUS,RP0		; Bank 0 select
	clrf PORTA
	clrf PORTB				; all outputs low
	bsf TxD

InitTimer
	bsf STATUS,RP0		; Bank 1
	movlw B'10001000'	; Int lowering edge; Presc. 1:1
	movwf OPTION_REG
	bcf STATUS,RP0		; Bank 0
	movlw B'00110000'	; enable Interrupts
	movwf INTCON
	movlw tmr0value		; default timer values for 100us/Interrupt
	movwf TMR0
	retfie						; Interrupt enabled


; -----------------------  now goes it loose ---------------------

Start	call Init
	call InitMsg
	call CrLf

Main
	call ClearDisplay

Mainloop
	movlw .17
	movwf LED01
	call delay
	call DispShift
	movlw .10
	movwf LED01
	call delay
	call DispShift
	movlw .19
	movwf LED01
	call delay
	call DispShift
	movlw .19
	movwf LED01
	call delay
	call DispShift
	movlw .21
	movwf LED01
	call delay
	call DispShift
	movlw .27
	movwf LED01
	call delay
	call DispShift
	movlw .27
	movwf LED01
	call delay
	call DispShift
	movlw .27
	movwf LED01
	call delay
	call DispShift
	movlw .27
	movwf LED01
	call delay
	call delay
	call delay
	call delay
	call DispShift
	nop
	goto Mainloop

delay
	movlw .100
	goto wait





; --------------------  common used subroutines ------------------

wait					; in ms
	movwf wdelay
wait01	bcf tmsflag
wait02	btfss tmsflag
	goto wait02
	decfsz wdelay,f
	goto wait01
	return


DispShift
	movfw LED04
	movwf count
	movfw LED03
	movwf LED04
	movfw LED02
	movwf LED03
	movfw LED01
	movwf LED02

	movfw count
	movwf LED01
	return

ClearDisplay
	movlw .27		; space
	movwf LED01
	movwf LED02
	movwf LED03
	movwf LED04
	return	

;
; ------------------------  RS232 Get/PutChar --------------------
;

OutASCII
	clrc
	addlw H'32'
	call OutChar
	return

OutChar
	btfsc TxFlg
	goto OutChar
	movwf TxBuf
	bsf TxFlg
	return

CrLf
	movlw .4
	goto MessageOut

MsgSpaces
	movlw .32
	call OutChar
	call OutChar
	goto OutChar
	
InitMsg
	movlw .1
	call MessageOut
	goto CrLf

MessageOut
	movwf temp	; save Messagenumber
	movlw H'FF'
	movwf pointer
MO02
	incf pointer,f
	movfw pointer
	call MessageTab
	xorlw 0
	btfss STATUS,Z
	goto MO02
	decfsz temp,f
	goto MO02	; till Message begins
	;
	incf pointer,f
	movfw pointer
	call MessageTab
MO03
	call OutChar
	incf pointer,f
	movfw pointer
	call MessageTab
	xorlw 0
	btfss STATUS,Z
	goto MO03
	return

StOutByte
	movwf temp
	movlw H'01'
	movwf wdelay
StOB01
	rlf temp,f
	skpc
	movlw a'0'
	skpnc
	movlw a'1'
	call OutChar
	rlf wdelay,f
	btfss STATUS,C
	goto StOB01
	goto CrLf
	
 END

