<?php
//no caching since picture-sizes might change by editing gallery_config.php 
clearstatcache();
header("Cache-Control: no-cache, must-revalidate");
header("Pragma: no-cache");

// Run includes
require_once(dirname(dirname(__FILE__))."/../includes.php");
require_once(dirname(dirname(__FILE__))."/gallery/gallery_config.php");
		
// Initialise functions for user details, icon management and profile management
run("userdetails:init");
run("profile:init");
run("gallery:init");

//Vars		
global $CFG;
global $PAGE;
global $page_owner;
$owner_username = user_info('username', $page_owner);

//Build up page		
templates_page_setup();

//Check received values
if(!(is_numeric($_GET[height])))
die("supported height has a bad type");

if(!(is_numeric($_GET[width])))
die("supported width has a bad type");

if(!(is_numeric($_GET[image])))
die("supported image has a bad type");

if(!(is_numeric($_GET[height])))
die("supported height has a bad type");

if(!(is_numeric($_GET[idx])))
die("supported idx has a bad type");

if(!(is_numeric($_GET[ident])))
die("supported ident has a bad type");


//received values		
$width= $_GET[width];
$height= $_GET[height];
$pic_id= $_GET[image];
$idx= $_GET[idx];
$ident= $_GET[ident];

//extract picturevalues from database with received $pic_id
$picture=get_records_select('files',"ident = ? AND files_owner = ?",array($pic_id,$page_owner));
$ident_file = $picture["$pic_id"]->ident;
$folder= $picture["$pic_id"]->folder;
$originalname= $picture["$pic_id"]->originalname;

//path to our picture
$picture="$CFG->wwwroot".$owner_username."/files/".$folder."/".$ident_file."/".$originalname;

//Scaling of the pictures depending on their width and height
if($width > $height)
{
	if($width > $width_anzeige)
	{
		$faktor=$width/$width_anzeige;
		$width=intval($width/$faktor);
		$height=intval($height/$faktor);
	}
}
else if($height > $width)
{
	if($height > $height_anzeige)
	{
		$faktor=$height/$height_anzeige;
		$height=intval($height/$faktor);
		$width=intval($width/$faktor);
	}
}
//If pictures width and height are equal and they are too large
else if($height > $height_anzeige)
	{
		$faktor=$height/$height_anzeige;
		$height=intval($height/$faktor);
		$width=intval($width/$faktor);
	}

	
	$body .= "<p><a href=".$CFG->wwwroot . "mod/gallery/index.php?ident=$ident&idx=$idx>";
	$body .= "". __gettext("Return to");
    $body .= "</a></p>";

if ($files = get_records_select('files',"originalname = ? AND files_owner = ? " ,array($originalname,$page_owner))) 
{
    foreach($files as $file)
	{
                
					if (run("users:access_level_check",$file->access) == true || $file->owner == $_SESSION['userid']) 
					{
						$username = $owner_username;
						$ident_file = (int) $file->ident;
						$filesize=round(($file->size / 1048576),4) . "MB "; 
						$location=$file->location;
						$description=$file->description;
						$title = $file->title;
					}
	}
}
		$filemenu = file_edit_links($file);
    	$keywords = display_output_field(array("","keywords","file","gallery",$ident_file));
                    
		if ($keywords) 
		{
    	$keywords = __gettext("Keywords: ") . $keywords;
    	}

       
	    //If User didnt specify title, description and/or keywords use standarts from "gallery_config.php"
		if($title=="")
		$title=$tit;
		
		if($description=="")
		$description=$desc;
		
		if($keywords=="")
		$keywords=$key;
		
		//Output a scaled version of the picture + supported information
		$body.="<table align='center'>
		<tr>
			<td>
        		<a href='$picture' border='0'>
                	<img src='$picture' width='$width' height='$height' border='0' alt=''/>
            	</a>
			</td> 
			<td>
            	<a href='$picture' border='0'><b>'$title'</b></a>
        		<p>'$filemenu'</p>
            	<p>'$description'</p>
            	<p>'$keywords'</p>
       			<p>'$filesize'</p>
			</td> 
    		</tr>
				</table>";

echo templates_page_draw( array(
                    $title,
                    templates_draw(array(
                            
							'context' => 'contentholder',
                            'body' => $body,
                        	'title' => $title,
                            
										)
                        			)
                				)
                		);
?>
